/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.testframe.utilities;

import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestPreparedStatement;
import com.sap.sapdb.testframe.utilities.User;
import java.sql.Connection;
import java.sql.SQLException;

public class Session
implements Runnable {
    User mUser;
    String[] mSql;
    Exception mException;
    TestCase mTestCase;
    boolean mHasException;
    Connection mConnection = null;
    TestPreparedStatement mPrepStmt = null;
    private boolean mIsInterrupted = false;
    private boolean mStopWhenSQLExceptionOccurs = true;
    private static int mUniqueCounter = 0;
    private static String[] mSqlOrderedSequence = new String[50];
    private static boolean mTraceSQLSequence = false;
    private boolean mTraceSQLSession = true;
    private int mIsolationLevel = 2;

    public Session(TestCase pTestCase, User pUser, String[] pSql) {
        this.mTestCase = pTestCase;
        this.mUser = pUser;
        this.mSql = pSql;
        try {
            this.mConnection = this.mUser.connect();
        }
        catch (TestDatabaseException tde) {
            this.mException = tde;
            this.mHasException = true;
        }
    }

    public Session(TestCase pTestCase, User pUser, String pSql) {
        this(pTestCase, pUser, new String[]{pSql});
    }

    private static synchronized void addToOrderedSequence(String pSql) {
        if (mUniqueCounter >= 50) {
            mUniqueCounter = 0;
        }
        Session.mSqlOrderedSequence[Session.mUniqueCounter++] = pSql;
    }

    void closeSession() {
        block7: {
            block6: {
                try {
                    if (this.mPrepStmt != null) {
                        this.mPrepStmt.close();
                    }
                }
                catch (SQLException se) {
                    if (this.mHasException) break block6;
                    this.mException = se;
                    this.mHasException = true;
                }
            }
            try {
                if (this.mConnection != null) {
                    this.mConnection.close();
                }
            }
            catch (SQLException se) {
                if (this.mHasException) break block7;
                this.mException = se;
                this.mHasException = true;
            }
        }
    }

    void executeStatement(String pSql) throws SQLException {
        this.mPrepStmt = new TestPreparedStatement(this.mTestCase, this.mConnection, pSql);
        this.mPrepStmt.enableExceptions(this.isStopWhenSQLExceptionOccurs());
        if (mTraceSQLSequence && this.mTraceSQLSession) {
            Session.addToOrderedSequence(pSql);
        }
        try {
            this.mPrepStmt.execute();
            this.mConnection.commit();
        }
        catch (SQLException se) {
            this.mConnection.rollback();
            throw se;
        }
    }

    public Exception getException() {
        return this.mException;
    }

    public int getIsolationLevel() {
        return this.mIsolationLevel;
    }

    public String[] getSql() {
        return this.mSql;
    }

    public TestCase getTestCase() {
        return this.mTestCase;
    }

    public static int getUniqueCounter() {
        return mUniqueCounter;
    }

    public User getUser() {
        return this.mUser;
    }

    public boolean hasException() {
        return this.mHasException;
    }

    void interrupt() {
        this.mIsInterrupted = true;
        try {
            this.mPrepStmt.cancel();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    boolean isInterrupted() {
        if (Thread.currentThread().isInterrupted()) {
            if (!this.mIsInterrupted) {
                this.interrupt();
            }
            return true;
        }
        if (this.mIsInterrupted) {
            Thread.currentThread().interrupt();
            return true;
        }
        return false;
    }

    public boolean isStopWhenSQLExceptionOccurs() {
        return this.mStopWhenSQLExceptionOccurs;
    }

    public static boolean isTraceSQLSequence() {
        return mTraceSQLSequence;
    }

    public boolean isTraceSQLSession() {
        return this.mTraceSQLSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            for (int i = 0; i < this.mSql.length; ++i) {
                if (this.isInterrupted()) {
                    break;
                }
                this.executeStatement(this.mSql[i]);
            }
        }
        catch (SQLException se) {
            this.mException = se;
            this.mHasException = true;
        }
        finally {
            this.closeSession();
        }
    }

    public void setIsolationLevel(int newIsolationLevel) {
        this.mIsolationLevel = newIsolationLevel;
    }

    public void setStopWhenSQLExceptionOccurs(boolean newStopWhenSQLExceptionOccurs) {
        this.mStopWhenSQLExceptionOccurs = newStopWhenSQLExceptionOccurs;
    }

    public static void setTraceSQLSequence(boolean newTraceSQLSequence) {
        mTraceSQLSequence = newTraceSQLSequence;
    }

    public void setTraceSQLSession(boolean newTraceSQLSession) {
        this.mTraceSQLSession = newTraceSQLSession;
    }

    public static void setUniqueCounter(int newUniqueCounter) {
        mUniqueCounter = newUniqueCounter;
    }
}

