/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.testframe.utilities;

import com.sap.sapdb.testframe.driver.TestSequence;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class JarTest {
    public static void main(String[] argv) {
        Vector<String> jarFiles = new Vector<String>();
        Vector<String> seqFiles = new Vector<String>();
        for (int i = 0; i < argv.length; ++i) {
            if (argv[i].endsWith(".seq")) {
                seqFiles.add(argv[i]);
                continue;
            }
            if (!argv[i].endsWith(".jar")) continue;
            jarFiles.add(argv[i]);
        }
        if (jarFiles.size() == 0 || seqFiles.size() == 0) {
            System.err.println("Need jar file as first and sequence file as second argument!");
            System.exit(1);
        }
        Vector<String> classesInJar = new Vector<String>();
        Vector<String> classesInSeqButNotInJar = new Vector<String>();
        Vector<String> classesInSeqAllreadyChecked = new Vector<String>();
        Iterator it = jarFiles.iterator();
        try {
            while (it.hasNext()) {
                JarFile jar = new JarFile((String)it.next());
                Enumeration<JarEntry> en = jar.entries();
                while (en.hasMoreElements()) {
                    String entry = ((ZipEntry)en.nextElement()).getName();
                    if (!entry.endsWith(".class")) continue;
                    entry = entry.substring(0, entry.length() - 6);
                    entry = entry.replace('/', '.');
                    try {
                        Class<?> c;
                        Class<?> superClass = c = Class.forName(entry);
                        boolean disabled = false;
                        try {
                            Field f = c.getDeclaredField("DISABLED");
                            if (Modifier.isStatic(f.getModifiers())) {
                                disabled = f.getBoolean(null);
                            }
                        }
                        catch (NoSuchFieldException e) {
                        }
                        catch (IllegalArgumentException e) {
                            e.printStackTrace();
                        }
                        catch (SecurityException e) {
                            e.printStackTrace();
                        }
                        catch (IllegalAccessException e) {
                            e.printStackTrace();
                        }
                        if (Modifier.isAbstract(c.getModifiers()) || disabled) continue;
                        while ((superClass = superClass.getSuperclass()) != null) {
                            if (!superClass.toString().endsWith("com.sap.sapdb.testframe.testcase.TestCase")) continue;
                            classesInJar.add(c.getName());
                        }
                    }
                    catch (ClassCastException e) {
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    catch (Error e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        TestSequence seq = new TestSequence();
        Iterator it2 = seqFiles.iterator();
        try {
            int classesInJarCount = classesInJar.size();
            while (it2.hasNext()) {
                seq.addSequence((String)it2.next());
            }
            it = seq.iterator();
            while (it.hasNext()) {
                TestSequence.TestSequenceItem item;
                Object obj = it.next();
                if (!(obj instanceof TestSequence.TestSequenceItem) || classesInSeqAllreadyChecked.contains((item = (TestSequence.TestSequenceItem)obj).getClassName())) continue;
                classesInSeqAllreadyChecked.add(item.getClassName());
                boolean b = classesInJar.remove(item.getClassName());
                if (b) continue;
                classesInSeqButNotInJar.add(item.getClassName());
            }
            int rc = 0;
            it = classesInJar.iterator();
            if (it.hasNext()) {
                System.out.println("Tests in jar but not in sequence file:");
                rc = 3;
            } else {
                System.out.println("OK. All tests in the jar file are refernced in the sequence file.");
            }
            while (it.hasNext()) {
                System.out.println(it.next());
            }
            System.out.println("");
            it = classesInSeqButNotInJar.iterator();
            if (it.hasNext()) {
                System.out.println("Tests in sequence file but not in jar:");
                rc = 3;
            }
            while (it.hasNext()) {
                System.out.println(it.next());
            }
            System.out.println("--------------------------------------------------------------------------------\n| Test in Seq \t| Test in Jar \t| in Seq/ not in Jar \t| in Jar/ not in Seq \n--------------------------------------------------------------------------------\n|         " + classesInSeqAllreadyChecked.size() + "\t|         " + classesInJarCount + "\t|       \t" + classesInSeqButNotInJar.size() + "\t|             " + classesInJar.size() + " \n" + "--------------------------------------------------------------------------------\n");
            if (rc != 0) {
                System.exit(rc);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (SAXNotRecognizedException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (SAXNotSupportedException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (SAXException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

