/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.testframe.utilities;

import java.text.ParseException;

public class Conversion {
    private Conversion() {
    }

    public static byte[] stringToHex(String s) throws ParseException {
        if (s == null) {
            return new byte[0];
        }
        if (s.startsWith("X")) {
            s = s.substring(1);
        }
        if (!s.matches("\\p{XDigit}*")) {
            throw new ParseException("Binary value " + s + " contains non hexa decimal characters. Only 0-9 a-f A-F are allowed", 0);
        }
        if (s.length() % 2 != 0) {
            throw new ParseException("Binary value must have an even length.", s.length() - 1);
        }
        int leng = s.length() / 2;
        byte[] bytearray = new byte[leng];
        for (int i = 0; i < leng; ++i) {
            bytearray[i] = (byte)Integer.parseInt(s.substring(i * 2, i * 2 + 2), 16);
        }
        return bytearray;
    }

    public static String hexToString(byte[] bytearr) {
        if (bytearr == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int k = 0; k < bytearr.length; ++k) {
            if ((bytearr[k] & 0xFF) < 10) {
                sb.append("0");
            }
            sb.append(Integer.toString(bytearr[k] & 0xFF, 16));
        }
        return sb.toString();
    }

    public static String removeDuplicatetSpaces(String s) {
        int l = 0;
        int len = s.length();
        char[] ca = new char[len];
        boolean space = false;
        for (int j = 0; j < len; ++j) {
            char ca1 = s.charAt(j);
            if (ca1 == ' ' || ca1 == '\t' || ca1 == '\n') {
                if (space) continue;
                ca[l] = 32;
                ++l;
                space = true;
                continue;
            }
            ca[l] = ca1;
            ++l;
            space = false;
        }
        return new String(ca, 0, l);
    }
}

