/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.testframe.testcase;

import com.sap.sapdb.testframe.testcase.ColumnDescriptor;
import com.sap.sapdb.testframe.testcase.VerificationDataIterator;
import com.sap.sapdb.testframe.testcase.VerificationDataIteratorPretty;
import com.stevesoft.pat.Regex;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public abstract class VerificationData {
    protected ArrayList mValues;
    protected ArrayList mColumnDescriptions;
    protected ArrayList mTempRow;
    protected boolean mColumnnamesDefined;
    protected boolean mColumnTypesDefined;
    protected String mErrorMessage = "n/a";
    protected int mResultCounter;
    protected int mColumnNumber = 0;
    protected int mRowNumber;
    protected boolean mCheckColumnNames = true;
    protected static Method bigDecimalToString = null;
    protected static long[] tenToThePowerOf = new long[]{1L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L, 10000000000000L, 100000000000000L, 1000000000000000L, 10000000000000000L, 100000000000000000L, 1000000000000000000L};
    protected Hashtable rowHash = new Hashtable();
    protected LinkedList notHashableRows = new LinkedList();
    protected boolean mResultSetIsScrollable = false;
    private int mCharInACell = 15;
    public static final char OP_SORTED = 's';
    public static final char OP_SUBSET = 'u';
    public static final char OP_COMPLETE = 'c';
    public static String numberPattern = "[\\+-]?[\\d]+(\\.[\\d]*)?";
    private Pattern rangePattern = Pattern.compile("(RANGE:)?(([<>]=?" + numberPattern + ")|(" + numberPattern + "/" + numberPattern + "\\%?))");
    private Pattern qoutationMarks = Pattern.compile("''");
    private boolean generatedFromResultSet = false;

    protected VerificationData() {
        if (bigDecimalToString == null) {
            VerificationData.setBigDecimalToStringFunction();
        }
        this.mColumnDescriptions = new ArrayList(20);
        this.mValues = new ArrayList(100);
        this.mTempRow = new ArrayList(20);
        this.mColumnnamesDefined = false;
        this.mResultCounter = -1;
    }

    protected VerificationData(String Datasets) throws RuntimeException {
        this();
        this.add(Datasets);
    }

    protected VerificationData(ResultSet Set2) throws RuntimeException {
        this();
        try {
            if (Set2.getType() != 1003) {
                this.mResultSetIsScrollable = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.add(Set2);
    }

    public void add(String Set2) throws RuntimeException {
        if (Set2 == null) {
            throw new RuntimeException("Input string is null!");
        }
        String helpSet = Set2.trim();
        String tempInput = null;
        String[] SetAsArray = new String[100];
        int ic = 0;
        int indexOfArray = 0;
        boolean isOpenedParenthesis = false;
        boolean isOpenedApostrophe = false;
        char currentChar = 'a';
        int startOfSubString = 0;
        if (helpSet.startsWith("(") && helpSet.indexOf("(", 1) == -1 && helpSet.endsWith(")")) {
            if (helpSet.substring(1, helpSet.length() - 1).trim().length() == 0) {
                throw new RuntimeException("Illegal DataSet! (opened and closed parenthesis without content); \ninput: " + Set2);
            }
            SetAsArray[0] = helpSet.substring(1, helpSet.length() - 1).trim();
        }
        if (!helpSet.startsWith("(") && !helpSet.endsWith(")")) {
            SetAsArray[0] = helpSet;
        }
        if (!helpSet.startsWith("(") && helpSet.endsWith(")")) {
            throw new RuntimeException("Input string does not start with a parenthesis but ends with one. \ninput: " + Set2);
        }
        if (helpSet.startsWith("(") && !helpSet.endsWith(")")) {
            throw new RuntimeException("Input string does not end with a parenthesis. \ninput: " + Set2);
        }
        if (helpSet.startsWith("(") && helpSet.indexOf("(", 1) != -1 && helpSet.endsWith(")")) {
            for (int i = 0; i < helpSet.length(); ++i) {
                currentChar = helpSet.charAt(i);
                if (!isOpenedParenthesis && currentChar == '(') {
                    isOpenedParenthesis = true;
                    startOfSubString = i + 1;
                    continue;
                }
                if (!isOpenedApostrophe && currentChar == '\'') {
                    isOpenedApostrophe = true;
                    continue;
                }
                if (isOpenedApostrophe && currentChar == '\'') {
                    if (helpSet.charAt(i + 1) == '\'') {
                        ++i;
                        continue;
                    }
                    isOpenedApostrophe = false;
                    continue;
                }
                if (!isOpenedApostrophe && isOpenedParenthesis && currentChar == ')') {
                    isOpenedParenthesis = false;
                    if (helpSet.substring(startOfSubString, i).trim().length() != 0) {
                        SetAsArray[indexOfArray] = helpSet.substring(startOfSubString, i).trim();
                        ++indexOfArray;
                    } else {
                        throw new RuntimeException("Illegal DataSet! (opened and closed parenthesis without content); \ninput: " + Set2);
                    }
                }
                if (!isOpenedParenthesis || isOpenedApostrophe || currentChar != 40) continue;
                throw new RuntimeException("Illegal DataSet (duplicate opened parenthesis); \ninput: " + Set2);
            }
            if (isOpenedApostrophe) {
                throw new RuntimeException("Illegal DataSet input ( unclosed apostrophe )!\ninput: " + Set2);
            }
        }
        indexOfArray = 0;
        while (SetAsArray[indexOfArray] != null) {
            tempInput = SetAsArray[indexOfArray].trim();
            int tempInputLength = tempInput.length();
            if (tempInput.startsWith("[") && !tempInput.endsWith("]")) {
                throw new RuntimeException("Input token does not end with a bracket. \ntoken: " + tempInput);
            }
            if (tempInput.startsWith("[") && tempInput.endsWith("]") && this.mColumnnamesDefined) {
                throw new RuntimeException("Second token with column definition.\ntoken: " + tempInput);
            }
            if (tempInput.startsWith("[") && tempInput.endsWith("]") && !this.mColumnnamesDefined) {
                StringTokenizer stTempInput = new StringTokenizer(tempInput.substring(1, tempInputLength - 1), ",");
                while (stTempInput.hasMoreTokens()) {
                    String dummy = stTempInput.nextToken().trim();
                    if (dummy.indexOf(":") == -1) {
                        this.mColumnDescriptions.add(new ColumnDescriptor(dummy));
                        continue;
                    }
                    this.mColumnDescriptions.add(new ColumnDescriptor(dummy.substring(0, dummy.indexOf(":")).trim(), ColumnDescriptor.getType(dummy.substring(dummy.indexOf(":") + 1, dummy.length()).trim())));
                }
                if (this.mColumnNumber == 0) {
                    this.mColumnNumber = this.mColumnDescriptions.size();
                } else if (this.mColumnNumber != this.mColumnDescriptions.size()) {
                    throw new RuntimeException("Definition of column does not match with existing number ( " + this.mColumnNumber + " ) of columns. \ntoken: " + tempInput);
                }
                this.mColumnnamesDefined = true;
            }
            if (!tempInput.startsWith("[")) {
                StringBuffer tempValue = new StringBuffer();
                this.mTempRow.clear();
                int i = 0;
                boolean dontExpectComma = true;
                isOpenedApostrophe = false;
                while (i < tempInputLength) {
                    currentChar = tempInput.charAt(i);
                    if (Character.isWhitespace(currentChar)) {
                        ++i;
                        continue;
                    }
                    if (currentChar == ',') {
                        if (dontExpectComma) {
                            ic = i + 1;
                            throw new RuntimeException("Wrong data definition! Found no content before comma.\ntoken: " + tempInput + "\nposition: " + ic);
                        }
                        dontExpectComma = true;
                        ++i;
                        continue;
                    }
                    if (dontExpectComma && (Character.toUpperCase(currentChar) == 'N' || Character.toUpperCase(currentChar) == 'I')) {
                        if (i + 3 <= tempInputLength && tempInput.substring(i, i + 3).compareToIgnoreCase("NaN") == 0) {
                            this.mTempRow.add(new String("NaN"));
                            i += 3;
                            dontExpectComma = false;
                            continue;
                        }
                        if (i + 4 <= tempInputLength && tempInput.substring(i, i + 4).compareToIgnoreCase("NULL") == 0) {
                            this.mTempRow.add(null);
                            i += 4;
                            dontExpectComma = false;
                            continue;
                        }
                        if (i + 6 <= tempInputLength && tempInput.substring(i, i + 6).compareToIgnoreCase("IGNORE") == 0) {
                            this.mTempRow.add("IGNORE");
                            i += 6;
                            dontExpectComma = false;
                            continue;
                        }
                        ic = i + 1;
                        throw new RuntimeException("Wrong data definition! Expected one of the words \"NULL\", \"NaN\" or \"IGNORE\" but found something else.\ntoken: " + tempInput + "\nposition: " + ic);
                    }
                    if (dontExpectComma && Character.toUpperCase(currentChar) == 'X') {
                        int j = 0;
                        while (i < tempInputLength - 1) {
                            ++j;
                            if ((currentChar = Character.toUpperCase(tempInput.charAt(++i))) == ',') {
                                --i;
                                --j;
                                break;
                            }
                            if (Character.isDigit(currentChar) || currentChar == 'A' || currentChar == 'B' || currentChar == 'C' || currentChar == 'D' || currentChar == 'E' || currentChar == 'F') {
                                tempValue.append(currentChar);
                                continue;
                            }
                            ic = i + 1;
                            throw new RuntimeException("Wrong data definition! Unexpected sign for hex value found: " + currentChar + "\nin token: " + tempInput + "\nat position: " + ic);
                        }
                        if (j % 2 == 0) {
                            this.mTempRow.add(tempValue.toString().trim());
                            tempValue.delete(0, tempValue.length());
                            dontExpectComma = false;
                            ++i;
                            continue;
                        }
                        ic = i + 1;
                        throw new RuntimeException("Wrong data definition! Found the beginnig of a binary value " + tempValue + " but not a correct end\nfrom token: " + tempInput + "\nposition: " + ic);
                    }
                    if (dontExpectComma && (Character.isDigit(currentChar) || currentChar == '-' || currentChar == '+' || currentChar == '.' || currentChar == '<' || currentChar == '>' || currentChar == '/' || currentChar == '=' || currentChar == '%')) {
                        tempValue.append(currentChar);
                        while (i < tempInputLength - 1) {
                            if ((currentChar = tempInput.charAt(++i)) == ',') {
                                --i;
                                break;
                            }
                            tempValue.append(currentChar);
                        }
                        try {
                            String temptempValue = tempValue.toString().trim();
                            if (this.rangePattern.matcher(tempValue).matches()) {
                                if (!temptempValue.startsWith("RANGE:")) {
                                    temptempValue = "RANGE:" + temptempValue;
                                }
                                this.mTempRow.add(temptempValue);
                            } else if (temptempValue.length() < 10 && temptempValue.indexOf(".") == -1) {
                                this.mTempRow.add(Integer.valueOf(temptempValue));
                            } else {
                                BigDecimal myBigValue = new BigDecimal(temptempValue);
                                this.mTempRow.add(myBigValue);
                            }
                        }
                        catch (NumberFormatException nfe) {
                            ic = i + 1;
                            throw new RuntimeException("Wrong data definition! Tried to build a number with: " + tempValue + " \nfrom token: " + tempInput + "\nposition: " + ic);
                        }
                        dontExpectComma = false;
                        ++i;
                        tempValue.delete(0, tempValue.length());
                        continue;
                    }
                    if (dontExpectComma && currentChar == 'R') {
                        if (i + 6 <= tempInputLength && tempInput.substring(i, i + 6).compareToIgnoreCase("REGEX:") == 0) {
                            tempValue.append("REGEX:");
                            i += 6;
                            dontExpectComma = true;
                            continue;
                        }
                        if (i + 6 <= tempInputLength && tempInput.substring(i, i + 6).compareToIgnoreCase("RANGE:") == 0) {
                            tempValue.append("RANGE:");
                            i += 6;
                            dontExpectComma = true;
                            continue;
                        }
                        ic = i + 1;
                        throw new RuntimeException("Wrong data definition! Expected the words \"REGEX:\" but found something else.\ntoken: " + tempInput + "\nposition: " + ic);
                    }
                    if (dontExpectComma && currentChar == '\'') {
                        isOpenedApostrophe = true;
                        while (i < tempInputLength - 1) {
                            if ((currentChar = tempInput.charAt(++i)) == '\'') {
                                if (i + 1 < tempInputLength) {
                                    if (tempInput.charAt(i + 1) == '\'') {
                                        tempValue.append(currentChar);
                                        ++i;
                                        continue;
                                    }
                                    isOpenedApostrophe = false;
                                    break;
                                }
                                isOpenedApostrophe = false;
                                break;
                            }
                            tempValue.append(currentChar);
                        }
                        if (!isOpenedApostrophe) {
                            this.mTempRow.add(tempValue.toString());
                            tempValue.delete(0, tempValue.length());
                            dontExpectComma = false;
                            ++i;
                            continue;
                        }
                        ic = i + 1;
                        throw new RuntimeException("Wrong data definition! ( unclosed apostrophe ).\ntoken: " + tempInput + "\nposition: " + ic);
                    }
                    ic = i + 1;
                    throw new RuntimeException("Wrong data definition! Expecting a number, a string or NULL.\ntoken: " + tempInput + "\nposition: " + ic);
                }
                if (dontExpectComma || tempValue.length() > 0) {
                    throw new RuntimeException("Wrong data definition! \ntoken: " + tempInput + "\nposition: " + i);
                }
                if (this.mColumnnamesDefined && this.mColumnNumber != this.mTempRow.size()) {
                    throw new RuntimeException("Wrong data definition! Found " + (this.mTempRow.size() == 1 ? "one entry" : this.mTempRow.size() + " entries") + ", but " + this.mColumnNumber + " column's exists.\ntoken: " + tempInput);
                }
                if (this.mColumnNumber == 0) {
                    this.mColumnNumber = this.mTempRow.size();
                } else if (this.mColumnNumber != this.mTempRow.size()) {
                    throw new RuntimeException("Wrong data definition! Found " + (this.mTempRow.size() == 1 ? "one entry" : this.mTempRow.size() + " entries") + ", but " + this.mColumnNumber + " column's exists.\ntoken: " + tempInput);
                }
                this.mValues.add(this.mTempRow.clone());
                ++this.mRowNumber;
                this.mTempRow.clear();
            }
            ++indexOfArray;
        }
        this.setRowCounter(this.mRowNumber);
        this.mErrorMessage = "No errors.";
    }

    /*
     * Exception decompiling
     */
    public void add(ResultSet Set) throws RuntimeException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 23[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void add(List list) {
        if (list == null) {
            throw new IllegalArgumentException("null is not accepted");
        }
        if (this.mColumnNumber == 0) {
            throw new RuntimeException("No column are specified. Plese add columns width add(\"[NAME: TYPE, NAME: TYPE, ...]\").");
        }
        if (this.mColumnNumber != list.size()) {
            throw new RuntimeException("Wrong data definition! Found " + (list.size() == 1 ? "one entry" : this.mTempRow.size() + " entries") + ", but " + this.mColumnNumber + " column's exists.");
        }
        Object[] array = new Object[this.mColumnNumber];
        for (int i = 0; i < this.mColumnNumber; ++i) {
            String o = (String)list.get(i);
            if (o == null || o.equals("NULL")) continue;
            int type = ((ColumnDescriptor)this.mColumnDescriptions.get(i)).getType();
            if (ColumnDescriptor.isString(type)) {
                if (o.startsWith("'") && o.endsWith("'")) {
                    array[i] = this.qoutationMarks.matcher(o.substring(1, o.length() - 1)).replaceAll("'");
                    continue;
                }
                if (o.startsWith("REGEX:'") && o.endsWith("'")) {
                    array[i] = this.qoutationMarks.matcher("REGEX:" + o.substring(7, o.length() - 1)).replaceAll("'");
                    continue;
                }
                array[i] = this.qoutationMarks.matcher(o).replaceAll("'");
                continue;
            }
            if (type == 4) {
                try {
                    array[i] = Integer.valueOf(o);
                }
                catch (NumberFormatException e) {
                    array[i] = o;
                }
                continue;
            }
            if (ColumnDescriptor.isNumeric(type)) {
                try {
                    array[i] = new BigDecimal(o);
                }
                catch (NumberFormatException e) {
                    array[i] = o;
                }
                continue;
            }
            if (!ColumnDescriptor.isBinary(type)) continue;
            array[i] = o.startsWith("X") || o.startsWith("x") ? o.substring(1).toUpperCase() : o;
        }
        this.mValues.add(new ArrayList<Object>(Arrays.asList(array)));
        ++this.mRowNumber;
        this.setRowCounter(this.mRowNumber);
        this.mErrorMessage = "No errors.";
    }

    public void ignoreCellForVerification(int Row, int Column) throws RuntimeException {
        if (this.mRowNumber == 0) {
            throw new RuntimeException("Error. Verification data object is empty!");
        }
        if (this.mRowNumber < Row) {
            throw new RuntimeException("Error. Row number " + Row + " does not exist in verification data object! Max rows in this object: " + this.mRowNumber);
        }
        if (this.mColumnNumber < Column) {
            throw new RuntimeException("Error. Column number " + Column + " does not exist in verification data object! Max columns in this object: " + this.mColumnNumber);
        }
        this.mTempRow = (ArrayList)this.mValues.get(Row - 1);
        this.mTempRow.set(Column - 1, "IGNORE");
        this.mValues.set(Row - 1, this.mTempRow.clone());
    }

    protected boolean checkMetaData(ResultSet Set2) throws Exception {
        ResultSetMetaData MetaData = Set2.getMetaData();
        int ColumnNumber = MetaData.getColumnCount();
        if (ColumnNumber != this.mColumnNumber) {
            throw new RuntimeException("Wrong number of columns: Expecting <" + this.mColumnNumber + ">, but found <" + ColumnNumber + "> columns.");
        }
        for (int i = 0; i < this.mColumnNumber; ++i) {
            if (!this.mColumnnamesDefined) continue;
            ColumnDescriptor Col = (ColumnDescriptor)this.mColumnDescriptions.get(i);
            if (!(!this.mCheckColumnNames || Col.getName().compareTo(MetaData.getColumnName(i + 1)) == 0 || Col.getName().equalsIgnoreCase("OWNER") && MetaData.getColumnName(i + 1).equalsIgnoreCase("SCHEMANAME") || Col.getName().equalsIgnoreCase("SCHEMANAME") && MetaData.getColumnName(i + 1).equalsIgnoreCase("OWNER"))) {
                throw new RuntimeException("Wrong column name in column " + (i + 1) + ": Expecting <" + Col.getName() + ">, but found <" + MetaData.getColumnName(i + 1) + ">.");
            }
            if (Col.compareType(MetaData.getColumnType(i + 1))) continue;
            throw new RuntimeException("Wrong data type of column " + (i + 1) + ", name: " + MetaData.getColumnName(i + 1) + ": Expecting <" + Col.getTypeName() + ">, but found <" + ColumnDescriptor.getTypeName(MetaData.getColumnType(i + 1)) + ">.");
        }
        return true;
    }

    protected boolean checkMetaData(VerificationData Set2) throws RuntimeException {
        int ColumnNumber = 0;
        ColumnDescriptor Col = null;
        ColumnDescriptor ColFromSet = null;
        ColumnNumber = Set2.getColumnCounter();
        if (ColumnNumber != this.mColumnNumber) {
            throw new RuntimeException("Wrong number of columns: Expecting <" + this.mColumnNumber + ">, but found <" + ColumnNumber + "> columns.");
        }
        for (int i = 0; i < this.mColumnNumber; ++i) {
            if (!this.mColumnnamesDefined) continue;
            Col = (ColumnDescriptor)this.mColumnDescriptions.get(i);
            ColFromSet = (ColumnDescriptor)Set2.getColumnDescriptions().get(i);
            if (!(!this.mCheckColumnNames || Col.getName().compareTo(ColFromSet.getName()) == 0 || Col.getName().equalsIgnoreCase("OWNER") && ColFromSet.getName().equalsIgnoreCase("SCHEMANAME") || Col.getName().equalsIgnoreCase("SCHEMANAME") && ColFromSet.getName().equalsIgnoreCase("OWNER"))) {
                throw new RuntimeException("Wrong column name in column " + (i + 1) + ": Expecting <" + Col.getName() + ">, but found <" + ColFromSet.getName() + ">.");
            }
            if (Col.compareType(ColFromSet.getType())) continue;
            throw new RuntimeException("Wrong data type of column " + (i + 1) + ", name: " + ColFromSet.getName() + ": Expecting <" + Col.getTypeName() + ">, but found <" + ColumnDescriptor.getTypeName(ColFromSet.getType()) + ">.");
        }
        return true;
    }

    protected void checkResultCounter(ResultSet Set2) throws RuntimeException {
        if (this.mResultCounter != -1) {
            int resultCounterInSet = 0;
            try {
                Set2.beforeFirst();
                while (Set2.next()) {
                    ++resultCounterInSet;
                }
            }
            catch (SQLException sqle) {
                throw new RuntimeException("Can't check number of results.");
            }
            if (this.mResultCounter != resultCounterInSet) {
                throw new RuntimeException("Wrong number of results: Expecting <" + this.mResultCounter + "> rows, but found <" + resultCounterInSet + ">.");
            }
        }
    }

    protected void checkResultCounter(VerificationData Set2) throws RuntimeException {
        if (this.mResultCounter != -1 && this.mResultCounter != Set2.getRowCounter()) {
            throw new RuntimeException("Wrong number of results: Expecting <" + this.mResultCounter + "> rows, but found <" + Set2.getRowCounter() + ">.");
        }
    }

    public void clear() {
        this.mValues.clear();
        this.mColumnDescriptions.clear();
        this.mTempRow.clear();
        this.mColumnnamesDefined = false;
        this.mResultCounter = -1;
        this.mErrorMessage = "No error.";
        this.mColumnNumber = 0;
        this.mRowNumber = 0;
        this.setGeneratedFromResultSet(false);
    }

    private String paddTo(String str, int len) {
        int l = str.length();
        if (l < len) {
            char[] ca = new char[len - l];
            Arrays.fill(ca, ' ');
            return str + new String(ca);
        }
        if (l == len) {
            return str;
        }
        return str.substring(0, len - 2) + "..";
    }

    public void setTheCellLengthOfTheResultset(int newLength) {
        if (newLength > 2) {
            this.mCharInACell = newLength;
        }
    }

    public String toString() {
        String dummy = null;
        if (this.mRowNumber != 0 || this.mColumnNumber != 0) {
            if (this.mColumnnamesDefined) {
                int i;
                dummy = "";
                for (i = 0; i < this.mColumnNumber; ++i) {
                    dummy = dummy + this.paddTo(((ColumnDescriptor)this.mColumnDescriptions.get(i)).getName(), this.mCharInACell);
                    dummy = dummy + " ";
                }
                dummy = dummy + "\n";
                for (i = 0; i < this.mColumnNumber; ++i) {
                    dummy = dummy + this.paddTo("" + ((ColumnDescriptor)this.mColumnDescriptions.get(i)).getType(), this.mCharInACell);
                    dummy = dummy + " ";
                }
                dummy = dummy + "\n";
                for (i = 0; i < this.mColumnNumber; ++i) {
                    dummy = dummy + this.paddTo(((ColumnDescriptor)this.mColumnDescriptions.get(i)).getTypeName(), this.mCharInACell);
                    dummy = dummy + " ";
                }
            }
            if (dummy == null) {
                dummy = "No column information (type and name) available.";
            }
            dummy = dummy + "\n\n";
            ArrayList tempRow = new ArrayList();
            String valueInRow = null;
            for (int i = 0; i < this.mRowNumber; ++i) {
                tempRow = (ArrayList)this.mValues.get(i);
                for (int j = 0; j < tempRow.size(); ++j) {
                    if (tempRow.get(j) == null) {
                        dummy = dummy + this.paddTo("NULL", this.mCharInACell);
                        dummy = dummy + " ";
                        continue;
                    }
                    valueInRow = tempRow.get(j).toString();
                    dummy = dummy + this.paddTo(valueInRow, this.mCharInACell);
                    dummy = dummy + " ";
                }
                dummy = dummy + "\n";
            }
        }
        return dummy;
    }

    public String resultSetRowToString(ResultSet Set2, int row) {
        String dummy = "";
        Object dummyobj = null;
        try {
            if (Set2.getType() != 1003) {
                Set2.absolute(row);
            }
            for (int i = 0; i < Set2.getMetaData().getColumnCount(); ++i) {
                dummyobj = Set2.getMetaData().getColumnType(i + 1) == -2 ? ColumnDescriptor.hex2String(Set2.getBytes(i + 1)) : Set2.getObject(i + 1);
                if (Set2.wasNull()) {
                    dummy = dummy + " NULL,";
                    continue;
                }
                dummy = dummy + this.paddTo(" " + dummyobj, this.mCharInACell);
                dummy = dummy + ",";
            }
            if ((dummy = dummy.trim()).length() > 3) {
                dummy = dummy.substring(0, dummy.length() - 1);
            }
        }
        catch (SQLException sqle) {
            dummy = dummy + " n/a -> " + sqle.getLocalizedMessage();
        }
        return dummy;
    }

    public String verificationDataRowToString(VerificationData Set2, int row) {
        String dummy = "";
        Object dummyobj = null;
        try {
            ArrayList thisRow = (ArrayList)Set2.getRows().get(row);
            for (int i = 0; i < thisRow.size(); ++i) {
                dummyobj = thisRow.get(i);
                if (dummyobj == null) {
                    dummy = dummy + this.paddTo(" NULL,", this.mCharInACell);
                    continue;
                }
                dummy = dummy + this.paddTo(" " + dummyobj, this.mCharInACell);
                dummy = dummy + ",";
            }
            if ((dummy = dummy.trim()).length() > 3) {
                dummy = dummy.substring(0, dummy.length() - 1);
            }
        }
        catch (Exception e) {
            dummy = dummy + " n/a -> " + e.getLocalizedMessage();
        }
        return dummy;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception e) {
            return null;
        }
    }

    protected void compareNumber(ResultSet Set2, int Column, int Row, Object Value) throws RuntimeException {
        try {
            BigDecimal RefVal = Set2.getBigDecimal(Column);
            this.compareNumber(RefVal, Column, Row, Value);
        }
        catch (SQLException e) {
            if (e.getErrorCode() == -10811) {
                if (!((String)Value).equalsIgnoreCase("NaN")) {
                    throw new RuntimeException("Wrong value in row <" + Row + ">, column <" + Column + ">: Expecting <" + Value + ">, but found 'NaN' value.");
                }
            }
            throw new RuntimeException("Illegal ResultSet. " + e.getLocalizedMessage());
        }
    }

    protected void compareNumber(VerificationData Set2, int Column, int Row, Object Value) throws RuntimeException {
        Object RefObj = null;
        RefObj = ((ArrayList)Set2.getRows().get(Row)).get(Column);
        this.compareNumber((Object)RefObj, Column + 1, Row + 1, Value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void compareNumber(Object RefObj, int Column, int Row, Object Value) throws RuntimeException {
        BigDecimal val2;
        if (Value != null && Value instanceof String && ((String)Value).equalsIgnoreCase("IGNORE")) {
            return;
        }
        if (Value == null || RefObj == null) {
            if (Value == null && RefObj != null) {
                throw new RuntimeException("Wrong value in row <" + Row + ">, column <" + Column + ">: Expecting NULL value, but found <" + RefObj + ">.");
            }
            if (Value == null || RefObj != null) return;
            throw new RuntimeException("Wrong value in row <" + Row + ">, column <" + Column + ">: Expecting <" + Value + ">, but found NULL value.");
        }
        if (Value instanceof String && ((String)Value).equalsIgnoreCase("NaN") || RefObj instanceof String && ((String)RefObj).equalsIgnoreCase("NaN")) {
            if (!(Value instanceof String && !(RefObj instanceof String) || !(Value instanceof String) && RefObj instanceof String) && ((String)Value).equalsIgnoreCase((String)RefObj)) return;
            throw new RuntimeException("Wrong value in row <" + Row + ">, column <" + Column + ">: Expecting <" + Value + ">, but found <" + RefObj + ">.");
        }
        if (Value != null && Value instanceof String && ((String)Value).startsWith("RANGE:")) {
            BigDecimal RefVal = RefObj instanceof Integer ? new BigDecimal(((Integer)RefObj).doubleValue()) : (BigDecimal)RefObj;
            String m_Value = ((String)Value).replaceAll(" ", "").substring(6);
            if (m_Value.charAt(0) == '<') {
                if (m_Value.charAt(1) == '=') {
                    if (RefVal.compareTo(new BigDecimal(m_Value.substring(2))) <= 0) return;
                    throw new RuntimeException("Wrong value in row <" + Row + ">, column <" + Column + ">: Expecting <  <=" + m_Value.substring(2) + ">, but found <" + RefVal + ">.");
                }
                if (RefVal.compareTo(new BigDecimal(m_Value.substring(1))) < 0) return;
                throw new RuntimeException("Wrong value in row <" + Row + ">, column <" + Column + ">: Expecting <  <" + m_Value.substring(1) + ">, but found <" + RefVal + ">.");
            }
            if (m_Value.charAt(0) == '>') {
                if (m_Value.charAt(1) == '=') {
                    if (RefVal.compareTo(new BigDecimal(m_Value.substring(2))) >= 0) return;
                    throw new RuntimeException("Wrong value in row <" + Row + ">, column <" + Column + ">: Expecting <  >=" + m_Value.substring(2) + ">, but found <" + RefVal + ">.");
                }
                if (RefVal.compareTo(new BigDecimal(m_Value.substring(1))) > 0) return;
                throw new RuntimeException("Wrong value in row <" + Row + ">, column <" + Column + ">: Expecting <  >" + m_Value.substring(1) + ">, but found <" + RefVal + ">.");
            }
            if (m_Value.indexOf("/") == -1) throw new RuntimeException("Wrong syntax. Found a range but it didn't start with '<' or '>' or have a '/' inside.");
            String[] valueArray = m_Value.split("/");
            if (valueArray[1].indexOf("%") != -1) {
                valueArray[1] = valueArray[1].substring(0, valueArray[1].indexOf("%"));
                BigDecimal bd1 = new BigDecimal(valueArray[0]);
                BigDecimal bd2 = new BigDecimal(valueArray[1]);
                BigDecimal bd3 = null;
                bd3 = bd1.multiply(bd2).divide(BigDecimal.valueOf(100L), 4, 6);
                if (RefVal.compareTo(bd1.subtract(bd3)) >= 0 && RefVal.compareTo(bd1.add(bd3)) <= 0) return;
                throw new RuntimeException("Wrong value in row <" + Row + ">, column <" + Column + ">: Expecting < " + bd1.subtract(bd3).toString() + " <= x <= " + bd1.add(bd3).toString() + " >, but found <" + RefVal + ">.");
            }
            if (RefVal.compareTo(new BigDecimal(valueArray[0])) >= 0 && RefVal.compareTo(new BigDecimal(valueArray[1])) <= 0) return;
            throw new RuntimeException("Wrong value in row <" + Row + ">, column <" + Column + ">: Expecting < " + valueArray[0] + " <= x <= " + valueArray[1] + " >, but found <" + RefVal + ">.");
        }
        if (Value instanceof Integer) {
            if (RefObj instanceof Integer) {
                if (((Integer)RefObj).compareTo((Integer)Value) == 0) return;
                throw new RuntimeException("Wrong value in row <" + Row + ">, column <" + Column + ">: Expecting <" + Value + ">, but found <" + RefObj + ">.");
            }
            val2 = new BigDecimal(((Integer)Value).doubleValue());
        } else {
            val2 = (BigDecimal)Value;
        }
        BigDecimal RefVal = RefObj instanceof Integer ? new BigDecimal(((Integer)RefObj).doubleValue()) : (BigDecimal)RefObj;
        if (RefVal.compareTo(val2) == 0) return;
        throw new RuntimeException("Wrong value in row <" + Row + ">, column <" + Column + ">: Expecting <" + Value + ">, but found <" + RefVal + ">.");
    }

    protected void compareString(ResultSet Set2, int Column, int Row, String Value) throws RuntimeException {
        this.compareString(Set2, Column, Row, Value, null);
    }

    protected void compareString(ResultSet Set2, int Column, int Row, String Value, String expr) throws RuntimeException {
        try {
            String RefVal = Set2.getString(Column);
            this.compareString(RefVal, Column, Row, Value, expr);
        }
        catch (SQLException e) {
            throw new RuntimeException("Illegal ResultSet found. " + e.getLocalizedMessage());
        }
    }

    protected void compareString(VerificationData Set2, int Column, int Row, String Value) throws RuntimeException {
        this.compareString(Set2, Column, Row, Value, null);
    }

    protected void compareString(Object RefObj, int Column, int Row, String Value) throws RuntimeException {
        this.compareString(RefObj, Column, Row, Value, null);
    }

    protected void compareString(VerificationData Set2, int Column, int Row, String Value, String expr) throws RuntimeException {
        Object RefObj = ((ArrayList)Set2.getRows().get(Row)).get(Column);
        this.compareString(RefObj, Column + 1, Row + 1, Value, expr);
    }

    protected void compareString(Object RefObj, int Column, int Row, String Value, String expr) throws RuntimeException {
        if (Value != null && Value.equalsIgnoreCase("IGNORE")) {
            return;
        }
        if (Value == null || RefObj == null) {
            if (Value == null && RefObj != null) {
                throw new RuntimeException("Wrong value in row <" + Row + ">, column <" + Column + ">: Expecting NULL value, but found <" + RefObj + ">.");
            }
            if (Value != null && RefObj == null) {
                throw new RuntimeException("Wrong value in row <" + Row + ">, column <" + Column + ">:  Expecting <" + Value + ">, but found NULL value.");
            }
        } else {
            String RefVal = (String)RefObj;
            if (expr != null) {
                Regex regexpr = Regex.perlCode((String)expr);
                Value = regexpr.replaceAll(Value);
                RefVal = regexpr.replaceAll(RefVal);
            }
            if (Value.startsWith("REGEX:")) {
                if (!RefVal.matches(Value.substring(6))) {
                    throw new RuntimeException("Wrong value in row <" + Row + ">, column <" + Column + ">: Expecting <" + Value.substring(6) + ">, but found <" + RefVal + ">.");
                }
            } else if (RefVal.compareTo(Value) != 0) {
                throw new RuntimeException("Wrong value in row <" + Row + ">, column <" + Column + ">: Expecting <" + Value + ">, but found <" + RefVal + ">.");
            }
        }
    }

    protected void compareBinary(ResultSet Set2, int Column, int Row, String Value) throws RuntimeException {
        try {
            String RefObj = null;
            byte[] bytes = Set2.getBytes(Column);
            if (!Set2.wasNull()) {
                RefObj = ColumnDescriptor.hex2String(bytes);
            }
            this.compareBinary(RefObj, Column, Row, Value);
        }
        catch (SQLException e) {
            throw new RuntimeException("Illegal Resultset found. " + e.getLocalizedMessage());
        }
    }

    protected void compareBinary(VerificationData Set2, int Column, int Row, String Value) throws RuntimeException {
        Object RefObj = ((ArrayList)Set2.getRows().get(Row)).get(Column);
        this.compareBinary(RefObj, Column + 1, Row + 1, Value);
    }

    protected void compareBinary(Object RefObj, int Column, int Row, String Value) throws RuntimeException {
        if (Value != null && Value.equalsIgnoreCase("IGNORE")) {
            return;
        }
        if (Value == null || RefObj == null) {
            if (Value == null && RefObj != null) {
                throw new RuntimeException("Wrong value in row <" + Row + ">, column <" + Column + ">: Expecting NULL value, but found <" + RefObj + ">.");
            }
            if (Value != null && RefObj == null) {
                throw new RuntimeException("Wrong value in row <" + Row + ">, column <" + Column + ">:  Expecting <" + Value + ">, but found NULL value.");
            }
        } else {
            String RefVal = ((String)RefObj).replaceAll("0+$", "");
            if (!RefVal.equalsIgnoreCase(Value.replaceAll("0+$", ""))) {
                throw new RuntimeException("Wrong value in row <" + Row + ">, column <" + Column + ">: \nExpecting <" + Value.toUpperCase() + ">, \nbut found <" + RefVal.toUpperCase() + ">.");
            }
        }
    }

    public abstract boolean equals(ResultSet var1);

    public abstract boolean equals(VerificationData var1);

    public String getErrorMessage() {
        return this.mErrorMessage;
    }

    public abstract char getOperatorType();

    public Iterator iterator() {
        return new VerificationDataIterator(this.mValues, this.mColumnDescriptions, this.mColumnnamesDefined);
    }

    public Iterator iteratorPretty() {
        return new VerificationDataIteratorPretty(this.mValues, this.mColumnDescriptions, this.mColumnnamesDefined);
    }

    public void setColumnNameCheck(boolean CheckOrNot) {
        this.mCheckColumnNames = CheckOrNot;
    }

    void setRowCounter(int RowCounter) {
        this.mResultCounter = RowCounter;
    }

    public int getRowCounter() {
        return this.mResultCounter;
    }

    void setColumnCounter(int ColumnCounter) {
        this.mColumnNumber = ColumnCounter;
    }

    public int getColumnCounter() {
        return this.mColumnNumber;
    }

    protected ArrayList getRows() {
        return this.mValues;
    }

    protected ArrayList getColumnDescriptions() {
        return this.mColumnDescriptions;
    }

    protected void generateHashTable(Regex regexpr) {
        this.rowHash.clear();
        this.notHashableRows.clear();
        for (int n = 0; n < this.mRowNumber; ++n) {
            List dataRow = (List)this.mValues.get(n);
            Integer hash = VerificationData.createRowHash(dataRow, this.mColumnNumber, regexpr);
            if (hash == null) {
                this.notHashableRows.add(new Integer(n));
                continue;
            }
            LinkedList<Integer> ll = (LinkedList<Integer>)this.rowHash.get(hash);
            if (ll == null) {
                ll = new LinkedList<Integer>();
                this.rowHash.put(hash, ll);
            }
            ll.add(new Integer(n));
        }
    }

    /*
     * Unable to fully structure code
     */
    protected static Integer createRowHash(List dataRow, int length, Regex regexpr) {
        array = dataRow.toArray();
        hashCode = 1;
        for (i = 0; i < length; ++i) {
            if (array[i] instanceof String) {
                value = (String)array[i];
                if (value.startsWith("REGEX:") || value.startsWith("RANGE:") || value.equalsIgnoreCase("IGNORE")) {
                    return null;
                }
                if (value.matches("\\p{XDigit}+")) {
                    value = value.replaceAll("0+$", "");
                }
                if (regexpr != null) {
                    value = regexpr.replaceAll(value);
                }
                hashCode = 31 * hashCode + value.hashCode();
                continue;
            }
            if (array[i] instanceof BigDecimal) {
                big = (BigDecimal)array[i];
                bigInt = big.unscaledValue();
                unscaledValue = bigInt.longValue();
                scale = big.scale();
                bitLength = bigInt.bitLength();
                if (bitLength > 63 || scale > 18) {
                    try {
                        splitNumber = ((String)VerificationData.bigDecimalToString.invoke((Object)big, new Object[0])).split("\\.");
                        try {
                            unscaledValue = Long.parseLong(splitNumber[0]);
                            if (splitNumber.length != 2) ** GOTO lbl49
                            n = splitNumber[1].length() > 17 ? Long.parseLong(splitNumber[1].substring(0, 18)) : Long.parseLong(splitNumber[1]) * VerificationData.tenToThePowerOf[17 - splitNumber[1].length()];
                            unscaledValue ^= n ^ n >>> 32;
                        }
                        catch (NumberFormatException e) {
                            unscaledValue = 0x7FFFFFFFFFFFFFFFL;
                        }
                    }
                    catch (IllegalArgumentException e) {
                        throw new RuntimeException("Can not access " + VerificationData.bigDecimalToString.toString() + "\n" + e.getMessage());
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException("Can not access " + VerificationData.bigDecimalToString.toString() + "\n" + e.getMessage());
                    }
                    catch (InvocationTargetException e) {
                        throw new RuntimeException("Can not access " + VerificationData.bigDecimalToString.toString() + "\n" + e.getMessage());
                    }
                } else if (scale > 0) {
                    v = unscaledValue / VerificationData.tenToThePowerOf[scale];
                    n = unscaledValue % VerificationData.tenToThePowerOf[scale] * VerificationData.tenToThePowerOf[18 - scale];
                    unscaledValue = v ^ (n ^ n >>> 32);
                } else if (scale < 0) {
                    if ((double)((int)Math.log(Math.pow(2.0, bitLength))) / Math.log(10.0) + (double)Math.abs(scale) > 19.0) {
                        unscaledValue = 0x7FFFFFFFFFFFFFFFL;
                    } else if ((long)big.signum() * (unscaledValue *= (long)Math.pow(10.0, Math.abs(scale))) < 0L) {
                        unscaledValue = 0x7FFFFFFFFFFFFFFFL;
                    }
                }
lbl49:
                // 10 sources

                if (unscaledValue < 0L) {
                    hashCode = 31 * hashCode + (int)(unscaledValue ^ (unscaledValue ^ -1L) >>> 32);
                    continue;
                }
                hashCode = 31 * hashCode + (int)(unscaledValue ^ unscaledValue >>> 32);
                continue;
            }
            if (array[i] instanceof Long) {
                l = (Long)array[i];
                if (l < 0L) {
                    hashCode = 31 * hashCode + (int)(l ^ (l ^ -1L) >>> 32);
                    continue;
                }
                hashCode = 31 * hashCode + (int)(l ^ l >>> 32);
                continue;
            }
            obj = array[i];
            hashCode = 31 * hashCode + (obj == null ? 0 : obj.hashCode());
        }
        return new Integer(hashCode);
    }

    public boolean isGeneratedFromResultSet() {
        return this.generatedFromResultSet;
    }

    private void setGeneratedFromResultSet(boolean generatedFromResultSet) {
        this.generatedFromResultSet = generatedFromResultSet;
    }

    protected static void setBigDecimalToStringFunction() {
        Method m;
        try {
            m = BigDecimal.class.getMethod("toPlainString", new Class[0]);
        }
        catch (SecurityException e) {
            throw new RuntimeException("Can not access toPlainString() Method of class BigDecimal");
        }
        catch (NoSuchMethodException e) {
            try {
                m = BigDecimal.class.getMethod("toString", new Class[0]);
            }
            catch (Exception e1) {
                throw new RuntimeException("Can not get toString() Method of class BigDecimal");
            }
        }
        bigDecimalToString = m;
    }
}

