/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.testframe.testcase;

import com.sap.sapdb.testframe.testcase.ColumnDescriptor;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestPreparedStatement;
import com.sap.sapdb.testframe.utilities.Conversion;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Map;

public class TestCallableStatement
extends TestPreparedStatement
implements CallableStatement {
    public TestCallableStatement(TestCase pTestCase, Connection pConnection, String pSql) throws SQLException {
        super(pTestCase);
        this.mStatement = pConnection.prepareCall(pSql);
        this.mConnection = pConnection;
        this.mResultItemData.setSqlStatement(pSql);
    }

    public TestCallableStatement(TestCase pTestCase, Connection pConnection, String pSql, int pResultSetType, int pResultSetConcurrency) throws SQLException {
        super(pTestCase);
        this.mStatement = pConnection.prepareCall(pSql, pResultSetType, pResultSetConcurrency);
        this.mConnection = pConnection;
        this.mResultItemData.setSqlStatement(pSql);
    }

    public Array getArray(int i) throws SQLException {
        return ((CallableStatement)this.mStatement).getArray(i);
    }

    public Array getArray(String s) throws SQLException {
        return ((CallableStatement)this.mStatement).getArray(s);
    }

    public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        return ((CallableStatement)this.mStatement).getBigDecimal(parameterIndex);
    }

    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        return null;
    }

    public BigDecimal getBigDecimal(String parameterIndex) throws SQLException {
        return ((CallableStatement)this.mStatement).getBigDecimal(parameterIndex);
    }

    public Blob getBlob(int i) throws SQLException {
        return ((CallableStatement)this.mStatement).getBlob(i);
    }

    public Blob getBlob(String s) throws SQLException {
        return ((CallableStatement)this.mStatement).getBlob(s);
    }

    public boolean getBoolean(int parameterIndex) throws SQLException {
        return ((CallableStatement)this.mStatement).getBoolean(parameterIndex);
    }

    public boolean getBoolean(String parameterIndex) throws SQLException {
        return ((CallableStatement)this.mStatement).getBoolean(parameterIndex);
    }

    public byte getByte(int parameterIndex) throws SQLException {
        return ((CallableStatement)this.mStatement).getByte(parameterIndex);
    }

    public byte getByte(String parameterIndex) throws SQLException {
        return ((CallableStatement)this.mStatement).getByte(parameterIndex);
    }

    public byte[] getBytes(int parameterIndex) throws SQLException {
        return ((CallableStatement)this.mStatement).getBytes(parameterIndex);
    }

    public byte[] getBytes(String parameterIndex) throws SQLException {
        return ((CallableStatement)this.mStatement).getBytes(parameterIndex);
    }

    public Clob getClob(int i) throws SQLException {
        return ((CallableStatement)this.mStatement).getClob(i);
    }

    public Clob getClob(String s) throws SQLException {
        return ((CallableStatement)this.mStatement).getClob(s);
    }

    public Date getDate(int parameterIndex) throws SQLException {
        return ((CallableStatement)this.mStatement).getDate(parameterIndex);
    }

    public Date getDate(String parameterIndex) throws SQLException {
        return ((CallableStatement)this.mStatement).getDate(parameterIndex);
    }

    public Date getDate(int parameterIndex, Calendar cal) throws SQLException {
        return ((CallableStatement)this.mStatement).getDate(parameterIndex, cal);
    }

    public Date getDate(String parameterIndex, Calendar cal) throws SQLException {
        return ((CallableStatement)this.mStatement).getDate(parameterIndex, cal);
    }

    public double getDouble(int parameterIndex) throws SQLException {
        return ((CallableStatement)this.mStatement).getDouble(parameterIndex);
    }

    public double getDouble(String parameterIndex) throws SQLException {
        return ((CallableStatement)this.mStatement).getDouble(parameterIndex);
    }

    public float getFloat(int parameterIndex) throws SQLException {
        return ((CallableStatement)this.mStatement).getFloat(parameterIndex);
    }

    public float getFloat(String parameterIndex) throws SQLException {
        return ((CallableStatement)this.mStatement).getFloat(parameterIndex);
    }

    public int getInt(int parameterIndex) throws SQLException {
        return ((CallableStatement)this.mStatement).getInt(parameterIndex);
    }

    public int getInt(String parameterIndex) throws SQLException {
        return ((CallableStatement)this.mStatement).getInt(parameterIndex);
    }

    public long getLong(int parameterIndex) throws SQLException {
        return ((CallableStatement)this.mStatement).getLong(parameterIndex);
    }

    public long getLong(String parameterIndex) throws SQLException {
        return ((CallableStatement)this.mStatement).getLong(parameterIndex);
    }

    public Object getObject(int parameterIndex) throws SQLException {
        return ((CallableStatement)this.mStatement).getObject(parameterIndex);
    }

    public Object getObject(String parameterIndex) throws SQLException {
        return ((CallableStatement)this.mStatement).getObject(parameterIndex);
    }

    public Object getObject(int i, Map map) throws SQLException {
        return ((CallableStatement)this.mStatement).getObject(i, map);
    }

    public Object getObject(String s, Map map) throws SQLException {
        return ((CallableStatement)this.mStatement).getObject(s, map);
    }

    public Ref getRef(int i) throws SQLException {
        return ((CallableStatement)this.mStatement).getRef(i);
    }

    public Ref getRef(String s) throws SQLException {
        return ((CallableStatement)this.mStatement).getRef(s);
    }

    public short getShort(int parameterIndex) throws SQLException {
        return ((CallableStatement)this.mStatement).getShort(parameterIndex);
    }

    public short getShort(String parameterIndex) throws SQLException {
        return ((CallableStatement)this.mStatement).getShort(parameterIndex);
    }

    public String getString(int parameterIndex) throws SQLException {
        return ((CallableStatement)this.mStatement).getString(parameterIndex);
    }

    public String getString(String parameterIndex) throws SQLException {
        return ((CallableStatement)this.mStatement).getString(parameterIndex);
    }

    public Time getTime(int parameterIndex) throws SQLException {
        return ((CallableStatement)this.mStatement).getTime(parameterIndex);
    }

    public Time getTime(String parameterIndex) throws SQLException {
        return ((CallableStatement)this.mStatement).getTime(parameterIndex);
    }

    public Time getTime(int parameterIndex, Calendar cal) throws SQLException {
        return ((CallableStatement)this.mStatement).getTime(parameterIndex, cal);
    }

    public Time getTime(String parameterIndex, Calendar cal) throws SQLException {
        return ((CallableStatement)this.mStatement).getTime(parameterIndex, cal);
    }

    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        return ((CallableStatement)this.mStatement).getTimestamp(parameterIndex);
    }

    public Timestamp getTimestamp(String parameterIndex) throws SQLException {
        return ((CallableStatement)this.mStatement).getTimestamp(parameterIndex);
    }

    public Timestamp getTimestamp(int parameterIndex, Calendar cal) throws SQLException {
        return ((CallableStatement)this.mStatement).getTimestamp(parameterIndex, cal);
    }

    public Timestamp getTimestamp(String parameterIndex, Calendar cal) throws SQLException {
        return ((CallableStatement)this.mStatement).getTimestamp(parameterIndex, cal);
    }

    public void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        ((CallableStatement)this.mStatement).registerOutParameter(parameterIndex, sqlType);
    }

    public void registerOutParameter(String parameterIndex, int sqlType) throws SQLException {
        ((CallableStatement)this.mStatement).registerOutParameter(parameterIndex, sqlType);
    }

    public void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        ((CallableStatement)this.mStatement).registerOutParameter(parameterIndex, sqlType, scale);
    }

    public void registerOutParameter(String parameterIndex, int sqlType, int scale) throws SQLException {
        ((CallableStatement)this.mStatement).registerOutParameter(parameterIndex, sqlType, scale);
    }

    public void registerOutParameter(int paramIndex, int sqlType, String typeName) throws SQLException {
        ((CallableStatement)this.mStatement).registerOutParameter(paramIndex, sqlType, typeName);
    }

    public void registerOutParameter(String paramIndex, int sqlType, String typeName) throws SQLException {
        ((CallableStatement)this.mStatement).registerOutParameter(paramIndex, sqlType, typeName);
    }

    public boolean wasNull() throws SQLException {
        return ((CallableStatement)this.mStatement).wasNull();
    }

    public URL getURL(int arg0) throws SQLException {
        return null;
    }

    public URL getURL(String arg0) throws SQLException {
        return null;
    }

    public void setAsciiStream(String arg0, InputStream arg1, int arg2) throws SQLException {
    }

    public void setBigDecimal(String arg0, BigDecimal arg1) throws SQLException {
    }

    public void setBinaryStream(String arg0, InputStream arg1, int arg2) throws SQLException {
    }

    public void setBoolean(String arg0, boolean arg1) throws SQLException {
    }

    public void setByte(String arg0, byte arg1) throws SQLException {
    }

    public void setBytes(String arg0, byte[] arg1) throws SQLException {
    }

    public void setCharacterStream(String arg0, Reader arg1, int arg2) throws SQLException {
    }

    public void setDate(String arg0, Date arg1, Calendar arg2) throws SQLException {
    }

    public void setDate(String arg0, Date arg1) throws SQLException {
    }

    public void setDouble(String arg0, double arg1) throws SQLException {
    }

    public void setFloat(String arg0, float arg1) throws SQLException {
    }

    public void setInt(String arg0, int arg1) throws SQLException {
    }

    public void setLong(String arg0, long arg1) throws SQLException {
    }

    public void setNull(String arg0, int arg1, String arg2) throws SQLException {
    }

    public void setNull(String arg0, int arg1) throws SQLException {
    }

    public void setObject(String arg0, Object arg1, int arg2, int arg3) throws SQLException {
    }

    public void setObject(String arg0, Object arg1, int arg2) throws SQLException {
    }

    public void setObject(String arg0, Object arg1) throws SQLException {
    }

    public void setShort(String arg0, short arg1) throws SQLException {
    }

    public void setString(String arg0, String arg1) throws SQLException {
    }

    public void setTime(String arg0, Time arg1, Calendar arg2) throws SQLException {
    }

    public void setTime(String arg0, Time arg1) throws SQLException {
    }

    public void setTimestamp(String arg0, Timestamp arg1, Calendar arg2) throws SQLException {
    }

    public void setTimestamp(String arg0, Timestamp arg1) throws SQLException {
    }

    public void setURL(String arg0, URL arg1) throws SQLException {
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        return null;
    }

    public void setURL(int arg0, URL arg1) throws SQLException {
    }

    public boolean execute(String arg0, int arg1) throws SQLException {
        return false;
    }

    public boolean execute(String arg0, int[] arg1) throws SQLException {
        return false;
    }

    public boolean execute(String arg0, String[] arg1) throws SQLException {
        return false;
    }

    public int executeUpdate(String arg0, int[] arg1) throws SQLException {
        return 0;
    }

    public int executeUpdate(String arg0, String[] arg1) throws SQLException {
        return 0;
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        return null;
    }

    public boolean getMoreResults(int arg0) throws SQLException {
        return false;
    }

    public int getResultSetHoldability() throws SQLException {
        return 0;
    }

    public String getOutParam(int ct, String type) throws SQLException {
        return this.getOutParam(ct, ColumnDescriptor.getType(type));
    }

    public String getOutParam(int ct, int type) throws SQLException {
        String outP = null;
        if (type == 16 || type == -7) {
            outP = "" + this.getBoolean(ct);
        } else if (type == 4) {
            outP = "" + this.getInt(ct);
        } else if (type == 5) {
            outP = "" + this.getShort(ct);
        } else if (type == 3 || type == 2) {
            outP = "" + this.getBigDecimal(ct);
        } else if (type == 6 || type == 7) {
            outP = "" + this.getFloat(ct);
        } else if (type == 1 || type == 12 || type == -1) {
            outP = "" + this.getString(ct);
        } else if (type == 91) {
            outP = "" + this.getDate(ct);
        } else if (type == 92) {
            outP = "" + this.getTime(ct);
        } else if (type == 93) {
            outP = "" + this.getTimestamp(ct);
        } else if (type == -3 || type == -4) {
            byte[] bytes = this.getBytes(ct);
            if (bytes != null) {
                outP = "X" + Conversion.hexToString(bytes);
            }
        } else {
            outP = "" + this.getObject(ct);
        }
        if (this.wasNull()) {
            return null;
        }
        return outP;
    }

    public void setInParam(int ct, String type, String inP) throws SQLException, ParseException {
        this.setInParam(ct, ColumnDescriptor.getType(type), inP);
    }

    public void setInParam(int ct, int type, String inP) throws SQLException, ParseException {
        if (inP == null) {
            this.setNull(ct, type);
        } else if (type == 16 || type == -7) {
            this.setBoolean(ct, inP.equalsIgnoreCase("true"));
        } else if (type == 4) {
            this.setInt(ct, (int)new Integer(inP));
        } else if (type == 5) {
            this.setShort(ct, (short)new Short(inP));
        } else if (type == 3 || type == 2) {
            this.setBigDecimal(ct, new BigDecimal(inP));
        } else if (type == -5) {
            this.setLong(ct, (long)new Long(inP));
        } else if (type == 6 || type == 7) {
            this.setFloat(ct, new Float(inP).floatValue());
        } else if (type == 1 || type == 12 || type == -1) {
            this.setString(ct, inP);
        } else if (type == 91) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            this.setDate(ct, new Date(sdf.parse(inP).getTime()));
        } else if (type == 92) {
            SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
            this.setTime(ct, new Time(sdf.parse(inP).getTime()));
        } else if (type == 93) {
            SimpleDateFormat sdf = inP.matches("\\d{1,4}-\\d{1,2}-\\d{1,2} \\d{1,2}:\\d{1,2}:\\d{1,2}\\.\\d+") ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS") : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            this.setTimestamp(ct, new Timestamp(sdf.parse(inP).getTime()));
        } else if (type == -3 || type == -4) {
            this.setBytes(ct, Conversion.stringToHex(inP));
        }
    }
}

