/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.testframe.testcase;

import com.sap.sapdb.testframe.testcase.ColumnDescriptor;
import junit.framework.TestCase;

public class ColumnDescriptorUnitTest
extends TestCase {
    public void testGetTypeString() {
        ColumnDescriptorUnitTest.assertEquals((int)1, (int)ColumnDescriptor.getType("CHAR"));
        ColumnDescriptorUnitTest.assertEquals((int)1, (int)ColumnDescriptor.getType("char"));
        ColumnDescriptorUnitTest.assertEquals((int)1111, (int)ColumnDescriptor.getType(" BLABLEBLU"));
    }

    public void testDefaultColumnType() {
        ColumnDescriptor cd = new ColumnDescriptor("Hello");
        ColumnDescriptorUnitTest.assertEquals((int)-1234256, (int)cd.getType());
        ColumnDescriptorUnitTest.assertEquals((String)"TYPE NOT SET", (String)cd.getTypeName());
        ColumnDescriptorUnitTest.assertEquals((String)"TYPE NOT SET", (String)ColumnDescriptor.getTypeName(-1234256));
        cd = new ColumnDescriptor();
        ColumnDescriptorUnitTest.assertTrue((boolean)cd.compareType(4));
        ColumnDescriptorUnitTest.assertEquals((String)"TYPE NOT SET", (String)cd.getTypeName());
    }

    public void testCompareTypes() {
        ColumnDescriptorUnitTest.assertTrue((boolean)ColumnDescriptor.compareTypes(4, -1234256));
        ColumnDescriptorUnitTest.assertTrue((boolean)ColumnDescriptor.compareTypes(-1234256, 4));
        ColumnDescriptorUnitTest.assertTrue((boolean)ColumnDescriptor.compareTypes(-1234256, -1234256));
        ColumnDescriptorUnitTest.assertTrue((boolean)ColumnDescriptor.compareTypes(4, 4));
        ColumnDescriptorUnitTest.assertTrue((boolean)ColumnDescriptor.compareTypes(4, 2));
        ColumnDescriptorUnitTest.assertTrue((boolean)ColumnDescriptor.compareTypes(4, 0));
        ColumnDescriptorUnitTest.assertTrue((boolean)ColumnDescriptor.compareTypes(1, 1));
        ColumnDescriptorUnitTest.assertTrue((boolean)ColumnDescriptor.compareTypes(1, 12));
        ColumnDescriptorUnitTest.assertTrue((boolean)ColumnDescriptor.compareTypes(-1, 12));
        ColumnDescriptorUnitTest.assertFalse((boolean)ColumnDescriptor.compareTypes(4, 1111));
        ColumnDescriptorUnitTest.assertFalse((boolean)ColumnDescriptor.compareTypes(3, -1));
    }

    public void testIsNumeric() {
        ColumnDescriptorUnitTest.assertTrue((boolean)ColumnDescriptor.isNumeric(4));
        ColumnDescriptorUnitTest.assertTrue((boolean)ColumnDescriptor.isNumeric(3));
        ColumnDescriptorUnitTest.assertTrue((boolean)ColumnDescriptor.isNumeric(-6));
        ColumnDescriptorUnitTest.assertTrue((boolean)ColumnDescriptor.isNumeric(6));
        ColumnDescriptorUnitTest.assertTrue((boolean)ColumnDescriptor.isNumeric(8));
        ColumnDescriptorUnitTest.assertTrue((boolean)ColumnDescriptor.isNumeric(-5));
        ColumnDescriptorUnitTest.assertTrue((boolean)ColumnDescriptor.isNumeric(2));
        ColumnDescriptorUnitTest.assertTrue((boolean)ColumnDescriptor.isNumeric(5));
        ColumnDescriptorUnitTest.assertTrue((boolean)ColumnDescriptor.isNumeric(7));
        ColumnDescriptorUnitTest.assertFalse((boolean)ColumnDescriptor.isNumeric(1));
    }

    public void testIsString() {
        ColumnDescriptorUnitTest.assertTrue((boolean)ColumnDescriptor.isString(1));
        ColumnDescriptorUnitTest.assertTrue((boolean)ColumnDescriptor.isString(-1));
        ColumnDescriptorUnitTest.assertTrue((boolean)ColumnDescriptor.isString(12));
        ColumnDescriptorUnitTest.assertTrue((boolean)ColumnDescriptor.isString(91));
        ColumnDescriptorUnitTest.assertTrue((boolean)ColumnDescriptor.isString(92));
        ColumnDescriptorUnitTest.assertTrue((boolean)ColumnDescriptor.isString(93));
        ColumnDescriptorUnitTest.assertTrue((boolean)ColumnDescriptor.isString(-7));
        ColumnDescriptorUnitTest.assertTrue((boolean)ColumnDescriptor.isString(2005));
        ColumnDescriptorUnitTest.assertFalse((boolean)ColumnDescriptor.isString(4));
    }

    public void testIsBinary() {
        ColumnDescriptorUnitTest.assertTrue((boolean)ColumnDescriptor.isBinary(-2));
        ColumnDescriptorUnitTest.assertTrue((boolean)ColumnDescriptor.isBinary(-4));
        ColumnDescriptorUnitTest.assertTrue((boolean)ColumnDescriptor.isBinary(-3));
        ColumnDescriptorUnitTest.assertTrue((boolean)ColumnDescriptor.isBinary(2004));
        ColumnDescriptorUnitTest.assertFalse((boolean)ColumnDescriptor.isBinary(4));
    }

    public void testgetEquivalentType() {
        ColumnDescriptorUnitTest.assertEquals((int)1, (int)ColumnDescriptor.getEquivalentType(12));
        ColumnDescriptorUnitTest.assertEquals((int)1, (int)ColumnDescriptor.getEquivalentType(-1));
        ColumnDescriptorUnitTest.assertEquals((int)4, (int)ColumnDescriptor.getEquivalentType(3));
        ColumnDescriptorUnitTest.assertEquals((int)4, (int)ColumnDescriptor.getEquivalentType(2));
        ColumnDescriptorUnitTest.assertEquals((int)4, (int)ColumnDescriptor.getEquivalentType(5));
        ColumnDescriptorUnitTest.assertEquals((int)6, (int)ColumnDescriptor.getEquivalentType(8));
        ColumnDescriptorUnitTest.assertEquals((int)1111, (int)ColumnDescriptor.getEquivalentType(1111));
    }
}

