/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.testframe.driver;

import com.sap.sapdb.testframe.driver.TestDriver;
import com.sap.sapdb.testframe.driver.TestProtocolFile;
import com.sap.sapdb.testframe.driver.TestStatistic;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.ListIterator;

public class TestProtocol {
    public static final char INFO = 'I';
    public static final char WARNING = 'W';
    public static final char ERROR = 'E';
    public static final char NONE = 'N';
    public static final char ABORT = 'A';
    public static final char TRACE = 'T';
    public static final char REMINDER = 'R';
    private File mSaveFile;
    private FileWriter mFileWriter;
    private static final String PROT_LINE_SHORT = "*****";
    private static final String PROT_LINE_LONG = "******************************************************************************";
    private static final String PROT_LINE_EMPTY = "";
    private ArrayList mProtocolItems;
    private boolean mProtocolWasSaved = false;
    private TestProtocolHeader mProtocolHeader;
    private int mSaveFileVersion;
    private static SimpleDateFormat mDateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
    private static final String S80 = "                                                                            ";
    private static final String ITEM_SEPERATOR_LINE = "------------------------------------------------------------------------------";
    private TestProtocolTrailer mProtocolTrailer;
    private AsyncProtocolWriter mAsyncProtocolWriter;
    private boolean mProtocolWasPrinted = false;
    private boolean mAsyncPrintSave = false;
    private String mLastTestId = "";
    private boolean mPrintExceptionTraceback = false;
    private int mBlockingRate = 10;
    private String mFileNamePrefix = null;
    private String mFileNamePath = null;
    private boolean mInfoMessageFilter = false;
    private StringBuffer mErrorBuffer = null;
    private String mLastTestIdForErrorProtocol = "";
    private boolean mErrorProtocolExists = false;
    private boolean remote = false;

    public TestProtocol(String pDbName, String pDbHost, String pDbSysName) {
        this.mProtocolHeader = new TestProtocolHeader(pDbName, pDbHost, pDbSysName, new Date(System.currentTimeMillis()));
        this.mProtocolItems = new ArrayList();
        this.mProtocolTrailer = new TestProtocolTrailer();
    }

    public TestProtocol(String pDbName, String pDbHost, String pDbSysName, String pSaveFilePath, String pSaveFileName, String pSaveFileExtension) throws IOException {
        this(pDbName, pDbHost, pDbSysName);
        TestProtocolFile lPFile = TestProtocol.createFile(pSaveFilePath, pSaveFileName, pSaveFileExtension);
        if (!lPFile.isNewlyCreated()) {
            throw new IOException("Couldn't create a NEW Protocol file. Path/FileName: " + lPFile.getFile().getAbsolutePath());
        }
        this.mSaveFile = lPFile.getFile();
        this.mFileWriter = new FileWriter(this.mSaveFile);
        this.setSaveFileVersion(Integer.parseInt(lPFile.getFileVersionNumber()));
        this.setFileNamePath(pSaveFilePath);
        this.setFileNamePrefix(pSaveFileName);
    }

    public TestProtocol(String pDbName, String pDbHost, String pDbSysName, String pSaveFilePath, String pSaveFileName, String pSaveFileExtension, int pSaveFileVersion) throws IOException {
        this(pDbName, pDbHost, pDbSysName);
        TestProtocolFile lPFile = TestProtocol.createFile(pSaveFilePath, pSaveFileName, pSaveFileExtension, pSaveFileVersion);
        if (!lPFile.isNewlyCreated()) {
            throw new IOException("Couldn't create a NEW Protocol file. Path/FileName: " + lPFile.getFile().getAbsolutePath());
        }
        this.mSaveFile = lPFile.getFile();
        this.mFileWriter = new FileWriter(this.mSaveFile);
        this.setSaveFileVersion(pSaveFileVersion);
        this.setFileNamePath(pSaveFilePath);
        this.setFileNamePrefix(pSaveFileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addExceptionItem(String pTestId, String pMessageId, char pMessageType, String pMessageText, Exception pException) {
        this.updateGlobalCounters(pMessageType);
        if (this.isInfoMessageFilter() && pMessageType == 'I') {
            return;
        }
        ArrayList arrayList = this.mProtocolItems;
        synchronized (arrayList) {
            if (pException != null) {
                this.mProtocolItems.add(new TestProtocolExceptionItem(pTestId, pMessageId, pMessageType, pMessageText, pException));
            } else {
                this.mProtocolItems.add(new TestProtocolItem(pTestId, pMessageId, pMessageType, pMessageText));
            }
            if (pMessageType == 'E') {
                this.addErrorMessageToErrorprotocol(pTestId, pMessageId, pMessageText, null);
            }
        }
        if (this.mAsyncPrintSave) {
            this.notifyAsyncWriters(pTestId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addExceptionSqlItem(String pTestId, String pMessageId, char pMessageType, String pMessageText, Exception pException, String pSql) {
        this.updateGlobalCounters(pMessageType);
        if (this.isInfoMessageFilter() && pMessageType == 'I') {
            return;
        }
        ArrayList arrayList = this.mProtocolItems;
        synchronized (arrayList) {
            if (pSql != null && pException != null) {
                this.mProtocolItems.add(new TestProtocolExceptionSqlItem(pTestId, pMessageId, pMessageType, pMessageText, pException, pSql));
            } else if (pSql != null) {
                this.mProtocolItems.add(new TestProtocolSqlItem(pTestId, pMessageId, pMessageType, pMessageText, pSql));
            } else if (pException != null) {
                this.mProtocolItems.add(new TestProtocolExceptionItem(pTestId, pMessageId, pMessageType, pMessageText, pException));
            } else {
                this.mProtocolItems.add(new TestProtocolItem(pTestId, pMessageId, pMessageType, pMessageText));
            }
            if (pMessageType == 'E') {
                this.addErrorMessageToErrorprotocol(pTestId, pMessageId, pMessageText, null);
            }
        }
        if (this.mAsyncPrintSave) {
            this.notifyAsyncWriters(pTestId);
        }
    }

    public ArrayList getItems() {
        return this.mProtocolItems;
    }

    public boolean getErrorProtocolExists() {
        return this.mErrorProtocolExists;
    }

    public String getErrorProtocol() {
        if (this.mErrorBuffer == null) {
            return null;
        }
        try {
            StringWriter sw = new StringWriter();
            this.mProtocolTrailer.print(new PrintWriter(sw));
            this.mErrorBuffer.append("<pre>" + sw.toString() + "</pre>");
        }
        catch (Exception e) {
            this.mErrorBuffer.append("<hr>End of error protocol<br>");
        }
        this.mErrorBuffer.append("</body></html>");
        return this.mErrorBuffer.toString();
    }

    private void addErrorMessageToErrorprotocol(String pTestId, String pMessageId, String pMessageText, String pFileName) {
        if (this.mErrorBuffer == null) {
            this.mErrorBuffer = new StringBuffer(20000);
            this.mErrorBuffer.append("<html><head></head><body>");
            this.mErrorProtocolExists = true;
            try {
                StringWriter sw = new StringWriter();
                this.mProtocolHeader.print(new PrintWriter(sw));
                this.mErrorBuffer.append("<pre>" + sw.toString() + "</pre>");
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (!this.mLastTestIdForErrorProtocol.equalsIgnoreCase(pTestId)) {
            if (this.mLastTestIdForErrorProtocol.length() != 0) {
                this.mErrorBuffer.append("<hr>");
            }
            if (pTestId != null) {
                this.mLastTestIdForErrorProtocol = pTestId;
            }
        }
        this.mErrorBuffer.append("<pre>ERROR    " + pTestId + " " + pMessageId + " " + mDateFormat.format(new Date(System.currentTimeMillis())) + "\n");
        this.mErrorBuffer.append(pMessageText + "\n</pre>");
        if (pFileName != null) {
            String pFileLocation = TestDriver.mWEBDavBaseURL.toString() + TestDriver.mWEBDavDir + pFileName;
            this.mErrorBuffer.append("Additional protocol: <A HREF=\"" + pFileLocation + "\">" + pFileName + "</A><br>");
        }
    }

    public final void addItem(String pTestId, String pMessageId, char pMessageType, String pMessageText) {
        this.addItem(pTestId, pMessageId, pMessageType, pMessageText, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addItem(String pTestId, String pMessageId, char pMessageType, String pMessageText, String pFileName) {
        this.updateGlobalCounters(pMessageType);
        if (this.isInfoMessageFilter() && pMessageType == 'I') {
            return;
        }
        ArrayList arrayList = this.mProtocolItems;
        synchronized (arrayList) {
            if (pFileName != null) {
                this.mProtocolItems.add(new TestProtocolItem(pTestId, pMessageId, pMessageType, pMessageText + "\n\nAdditional protocol: " + pFileName));
            } else {
                this.mProtocolItems.add(new TestProtocolItem(pTestId, pMessageId, pMessageType, pMessageText));
            }
            if (pMessageType == 'E') {
                this.addErrorMessageToErrorprotocol(pTestId, pMessageId, pMessageText, pFileName);
            }
        }
        if (this.mAsyncPrintSave) {
            this.notifyAsyncWriters(pTestId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addSqlItem(String pTestId, String pMessageId, char pMessageType, String pMessageText, String pSql) {
        this.updateGlobalCounters(pMessageType);
        if (this.isInfoMessageFilter() && pMessageType == 'I') {
            return;
        }
        ArrayList arrayList = this.mProtocolItems;
        synchronized (arrayList) {
            if (pSql != null) {
                this.mProtocolItems.add(new TestProtocolSqlItem(pTestId, pMessageId, pMessageType, pMessageText, pSql));
            } else {
                this.mProtocolItems.add(new TestProtocolItem(pTestId, pMessageId, pMessageType, pMessageText));
            }
            if (pMessageType == 'E') {
                this.addErrorMessageToErrorprotocol(pTestId, pMessageId, pMessageText, null);
            }
        }
        if (this.mAsyncPrintSave) {
            this.notifyAsyncWriters(pTestId);
        }
    }

    public void close() {
        this.stopAsyncWriters();
    }

    public static TestProtocolFile createFile(String pSaveFilePath, String pSaveFileName, String pSaveFileExtension) throws IOException {
        File lSaveFile = null;
        String si4 = null;
        boolean lNew = false;
        if (pSaveFilePath.trim().equals(PROT_LINE_EMPTY) || pSaveFilePath == null || pSaveFileName.trim().equals(PROT_LINE_EMPTY) || pSaveFileName == null) {
            throw new IOException("Missing protocol file name or file path");
        }
        String Ext = new String(pSaveFileExtension.trim());
        if (Ext.equals(PROT_LINE_EMPTY)) {
            Ext = "prt";
        }
        if (!pSaveFileName.trim().equals(PROT_LINE_EMPTY) && pSaveFileName != null) {
            File ff = new File(pSaveFilePath);
            TestProtocolFilenameFilter rr = new TestProtocolFilenameFilter(pSaveFileName);
            String[] ss = ff.list(rr);
            if (ss == null) {
                throw new IOException("Could not create protocol file in directory " + ff.getAbsolutePath());
            }
            int i = 0;
            DecimalFormat df = new DecimalFormat("####");
            df.setMinimumIntegerDigits(4);
            si4 = df.format(i);
            String lCheckFileName = pSaveFileName + si4 + ".";
            boolean lFileCreated = false;
            while (!lFileCreated && i < 9999) {
                boolean lFileFound = false;
                for (int j = 0; j < ss.length; ++j) {
                    if (ss[j].indexOf(lCheckFileName) == -1) continue;
                    lFileFound = true;
                    break;
                }
                if (!lFileFound) {
                    String lSaveFileName = lCheckFileName + pSaveFileExtension;
                    lSaveFile = new File(pSaveFilePath, lSaveFileName);
                    lNew = lSaveFile.createNewFile();
                    lFileCreated = true;
                    continue;
                }
                si4 = df.format(++i);
                lCheckFileName = pSaveFileName + si4 + ".";
            }
            if (i >= 9999) {
                throw new IOException("Could not create protocol file, because 9999 versions exist. Filename/path: " + lSaveFile.getAbsolutePath());
            }
        }
        return new TestProtocolFile(lSaveFile, si4, lNew);
    }

    public static TestProtocolFile createFile(String pSaveFilePath, String pSaveFileName, String pSaveFileExtension, int pSaveFileVersion) throws IOException {
        File lSaveFile = null;
        String si4 = null;
        boolean lNew = true;
        if (pSaveFilePath.trim().equals(PROT_LINE_EMPTY) || pSaveFilePath == null || pSaveFileName.trim().equals(PROT_LINE_EMPTY) || pSaveFileName == null) {
            throw new IOException("Missing protocol file name or file path");
        }
        String Ext = new String(pSaveFileExtension.trim());
        if (Ext.equals(PROT_LINE_EMPTY)) {
            Ext = "prt";
        }
        if (!pSaveFileName.trim().equals(PROT_LINE_EMPTY) && pSaveFileName != null) {
            if (pSaveFileVersion >= 9999) {
                throw new IOException("Could not create protocol file because 9999 versions exist. Filename/path :" + lSaveFile.getAbsolutePath());
            }
            DecimalFormat df = new DecimalFormat("####");
            df.setMinimumIntegerDigits(4);
            si4 = df.format(pSaveFileVersion);
            String lSaveFileName = pSaveFileName + si4 + "." + pSaveFileExtension;
            lSaveFile = new File(pSaveFilePath, lSaveFileName);
            lNew = lSaveFile.createNewFile();
        }
        return new TestProtocolFile(lSaveFile, si4, lNew);
    }

    public final boolean enableParallelPrintSaveMode(int pBlockingRate, char pMode) {
        if (this.mAsyncPrintSave) {
            return false;
        }
        this.mAsyncPrintSave = true;
        if (this.mProtocolWasPrinted || this.mProtocolWasSaved) {
            return false;
        }
        if (pBlockingRate != 0) {
            this.mBlockingRate = pBlockingRate;
        }
        switch (pMode) {
            case 'A': {
                this.mAsyncProtocolWriter = new AsyncProtocolWriter(new PrintWriter(System.out));
                this.mProtocolWasPrinted = true;
                break;
            }
            case 'B': {
                this.mAsyncProtocolWriter = new AsyncProtocolWriter(new PrintWriter(this.mFileWriter));
                break;
            }
            case 'C': {
                this.mAsyncProtocolWriter = new AsyncProtocolWriter(new PrintWriter(System.out), new PrintWriter(this.mFileWriter));
                this.mProtocolWasPrinted = true;
                break;
            }
            default: {
                this.mAsyncProtocolWriter = new AsyncProtocolWriter(new PrintWriter(System.out), new PrintWriter(this.mFileWriter));
                this.mProtocolWasPrinted = true;
            }
        }
        this.mAsyncProtocolWriter.start();
        return true;
    }

    public void finalize() {
        TestDriver.addState(" Testprotocol->finalize()");
        try {
            this.mFileWriter.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.stopAsyncWriters();
            if (this.mSaveFile != null && !this.mProtocolWasSaved) {
                this.mSaveFile.delete();
            }
        }
        catch (Exception e) {
            this.stopAsyncWriters();
        }
    }

    public static String getErrorText(char pErr) {
        switch (pErr) {
            case 'A': {
                return "ABORT   ";
            }
            case 'E': {
                return "ERROR   ";
            }
            case 'W': {
                return "WARNING ";
            }
            case 'I': {
                return "INFO    ";
            }
            case 'T': {
                return "TRACE   ";
            }
            case 'R': {
                return "REMIND  ";
            }
        }
        return "INFO 2  ";
    }

    public String getFileNamePrefix() {
        return this.mFileNamePrefix;
    }

    public String getFilePath() {
        return this.mFileNamePath;
    }

    public boolean getProtocolWasSaved() {
        return this.mProtocolWasSaved;
    }

    public File getSaveFile() {
        return this.mSaveFile;
    }

    public int getSaveFileVersion() {
        return this.mSaveFileVersion;
    }

    public boolean isInfoMessageFilter() {
        return this.mInfoMessageFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyAsyncWriters(String pTestId) {
        if (this.mProtocolItems.size() % this.mBlockingRate == 0 || !pTestId.equals(this.mLastTestId)) {
            this.mLastTestId = pTestId;
            if (this.mAsyncProtocolWriter != null) {
                AsyncProtocolWriter asyncProtocolWriter = this.mAsyncProtocolWriter;
                synchronized (asyncProtocolWriter) {
                    this.mAsyncProtocolWriter.notify();
                }
            }
        }
    }

    public void print() throws IOException {
        if (this.mAsyncPrintSave) {
            return;
        }
        this.mProtocolWasPrinted = true;
        PrintWriter OutputScreen = new PrintWriter(new BufferedOutputStream(System.out));
        this.write(OutputScreen);
        OutputScreen.close();
    }

    public void save() throws IOException {
        if (this.mAsyncPrintSave) {
            return;
        }
        if (this.mProtocolItems.isEmpty()) {
            return;
        }
        if (this.mSaveFile == null || this.mFileWriter == null) {
            throw new IOException("No filename specified. Can't save protocol");
        }
        this.mProtocolWasSaved = true;
        PrintWriter OutputFile = new PrintWriter(new BufferedWriter(this.mFileWriter));
        this.write(OutputFile);
        OutputFile.close();
    }

    public void setDbBuildNumber(String pDbBuildNumber) {
        this.mProtocolHeader.setDbBuildNumber(pDbBuildNumber);
    }

    public void setDbBit(Integer pDbBit) {
        this.mProtocolHeader.setDbBit(pDbBit.toString());
    }

    public void setDbKernelMode(String pDbKernelMode) {
        this.mProtocolHeader.setDbKernelMode(pDbKernelMode);
    }

    public void setDbRunDirectory(String pDbRunDirectory) {
        this.mProtocolHeader.setDbRunDirectory(pDbRunDirectory);
    }

    public void setDbRoot(String pDbRoot) {
        this.mProtocolHeader.setDbRoot(pDbRoot);
    }

    public void setDbVersion(String pDbVersion) {
        this.mProtocolHeader.setDbVersion(pDbVersion);
    }

    public void setJDBCDriverVersion(String pjdbcVersion) {
        this.mProtocolHeader.setJDBCDriverVersion(pjdbcVersion);
    }

    public void setPort(int pPort) {
        this.mProtocolHeader.setPort(pPort);
    }

    private void setFileNamePath(String newFileNamePath) {
        this.mFileNamePath = newFileNamePath;
    }

    public final void setRemote(boolean b) {
        this.remote = b;
    }

    public final boolean isRemote() {
        return this.remote;
    }

    private void setFileNamePrefix(String newFileNamePrefix) {
        this.mFileNamePrefix = newFileNamePrefix;
    }

    public void setInfoMessageFilter(boolean pInfoMessageFilter) {
        this.mInfoMessageFilter = pInfoMessageFilter;
    }

    public void setOpSystem(String pOpSystem) {
        this.mProtocolHeader.setOpSystem(pOpSystem);
    }

    public void setPrintExceptionTraceback(boolean pPrintExceptionTraceback) {
        this.mPrintExceptionTraceback = pPrintExceptionTraceback;
    }

    private void setSaveFileVersion(int pSaveFileVersion) {
        this.mSaveFileVersion = pSaveFileVersion;
    }

    public void setTestDriverVersion(String pTestDriverVersion) {
        this.mProtocolHeader.setTestDriverVersion(pTestDriverVersion);
    }

    public void setTestDriverStart(Date pTestDriverStart) {
        this.mProtocolHeader.setTestDriverStart(pTestDriverStart);
    }

    public void flushAsyncWriters() {
        if (this.mAsyncPrintSave) {
            this.mAsyncProtocolWriter.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopAsyncWriters() {
        if (this.mAsyncPrintSave) {
            this.mAsyncProtocolWriter.setStop(true);
            AsyncProtocolWriter asyncProtocolWriter = this.mAsyncProtocolWriter;
            synchronized (asyncProtocolWriter) {
                this.mAsyncProtocolWriter.notify();
            }
        }
    }

    private void updateGlobalCounters(char pMessageType) {
        switch (pMessageType) {
            case 'I': {
                TestStatistic.incTotalInfos();
                break;
            }
            case 'W': {
                TestStatistic.incTotalWarnings();
                break;
            }
            case 'E': {
                TestStatistic.incTotalErrors();
                break;
            }
            case 'R': {
                TestStatistic.incTotalReminders();
            }
        }
    }

    public void write(PrintWriter pIODevice) throws IOException {
        this.mProtocolHeader.print(pIODevice);
        this.writeItems(pIODevice);
        this.mProtocolTrailer.print(pIODevice);
    }

    private void writeItems(PrintWriter pIODevice) throws IOException {
        boolean TestProthasItems = false;
        ListIterator ListIt = this.mProtocolItems.listIterator();
        while (ListIt.hasNext()) {
            TestProthasItems = true;
            TestProtocolBasicItem tp = (TestProtocolBasicItem)ListIt.next();
            tp.printItem(pIODevice);
            pIODevice.println(ITEM_SEPERATOR_LINE);
        }
        if (!TestProthasItems) {
            pIODevice.println("There are no messages inside the protocol");
        }
        pIODevice.println(PROT_LINE_EMPTY);
    }

    static class TestProtocolFilenameFilter
    implements FilenameFilter {
        private String mFName;

        TestProtocolFilenameFilter(String pFName) {
            this.mFName = pFName;
        }

        public boolean accept(File dir, String name) {
            if (name.lastIndexOf(this.mFName) != -1) {
                return this.mFName.length() + 8 == name.length();
            }
            return false;
        }
    }

    class AsyncProtocolWriter
    extends Thread {
        PrintWriter mAIODevice1 = null;
        PrintWriter mAIODevice2 = null;
        boolean mIsStopped = false;

        AsyncProtocolWriter(Writer pWriter) {
            this.setDaemon(false);
            this.setPriority(1);
            this.mAIODevice1 = new PrintWriter(pWriter, true);
        }

        AsyncProtocolWriter(Writer pWriter1, Writer pWriter2) {
            this(pWriter1);
            this.mAIODevice2 = new PrintWriter(pWriter2, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flush() {
            if (TestProtocol.this.mProtocolItems.size() > 0) {
                this.writeItemsAsync(this.mAIODevice1, this.mAIODevice2);
            }
            this.setStop(true);
            AsyncProtocolWriter asyncProtocolWriter = this;
            synchronized (asyncProtocolWriter) {
                this.notifyAll();
            }
            while (this.isAlive()) {
                try {
                    AsyncProtocolWriter.sleep(500L);
                }
                catch (Exception exception) {}
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                TestProtocol.this.mProtocolHeader.print(this.mAIODevice1);
                if (this.mAIODevice2 != null) {
                    TestProtocol.this.mProtocolHeader.print(this.mAIODevice2);
                }
                while (true) {
                    this.writeItemsAsync(this.mAIODevice1, this.mAIODevice2);
                    if (TestProtocol.this.mProtocolItems.size() >= TestProtocol.this.mBlockingRate) continue;
                    AsyncProtocolWriter asyncProtocolWriter = this;
                    synchronized (asyncProtocolWriter) {
                        if (this.mIsStopped) {
                            break;
                        }
                        this.wait();
                    }
                }
                TestProtocol.this.mProtocolTrailer.print(this.mAIODevice1);
                if (this.mAIODevice2 != null) {
                    TestProtocol.this.mProtocolTrailer.print(this.mAIODevice2);
                }
            }
            catch (InterruptedException e) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        void setStop(boolean pStop) {
            this.mIsStopped = pStop;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void writeItemsAsync(PrintWriter pIODevice1, PrintWriter pIODevice2) {
            int lSize = TestProtocol.this.mProtocolItems.size();
            if (!TestProtocol.this.mProtocolWasSaved && lSize > 0) {
                TestProtocol.this.mProtocolWasSaved = true;
            }
            try {
                for (int i = 0; i < lSize; ++i) {
                    TestProtocolBasicItem tp = (TestProtocolBasicItem)TestProtocol.this.mProtocolItems.get(i);
                    tp.printItem(this.mAIODevice1);
                    pIODevice1.println(TestProtocol.ITEM_SEPERATOR_LINE);
                    if (pIODevice2 == null) continue;
                    tp.printItem(this.mAIODevice2);
                    pIODevice2.println(TestProtocol.ITEM_SEPERATOR_LINE);
                }
                ArrayList i = TestProtocol.this.mProtocolItems;
                synchronized (i) {
                    for (int i2 = lSize - 1; i2 >= 0; --i2) {
                        TestProtocol.this.mProtocolItems.remove(i2);
                    }
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    static class TestProtocolTrailer {
        private Date mEndDate;

        TestProtocolTrailer() {
        }

        void print(PrintWriter pIODevice) throws IOException {
            StringBuffer sb = new StringBuffer("***** Total Tests      : " + TestStatistic.getTestsPlanned() + TestProtocol.S80);
            int pos = 73;
            boolean lnw = false;
            pIODevice.println(TestProtocol.PROT_LINE_LONG);
            sb.replace(0, 90, "***** Tests Planned    : " + TestStatistic.getTestsPlanned() + TestProtocol.S80);
            pIODevice.println(sb.substring(0, 73) + TestProtocol.PROT_LINE_SHORT);
            lnw = true;
            sb.replace(0, 90, "***** Tests Started    : " + TestStatistic.getTestsStarted() + TestProtocol.S80);
            pIODevice.println(sb.substring(0, 73) + TestProtocol.PROT_LINE_SHORT);
            lnw = true;
            sb.replace(0, 90, "***** Tests Successful : " + TestStatistic.getTestsSuccessful() + TestProtocol.S80);
            pIODevice.println(sb.substring(0, 73) + TestProtocol.PROT_LINE_SHORT);
            lnw = true;
            sb.replace(0, 90, "***** Total Errors     : " + TestStatistic.getTotalErrors() + TestProtocol.S80);
            pIODevice.println(sb.substring(0, 73) + TestProtocol.PROT_LINE_SHORT);
            lnw = true;
            sb.replace(0, 90, "***** Total Warnings   : " + TestStatistic.getTotalWarnings() + TestProtocol.S80);
            pIODevice.println(sb.substring(0, 73) + TestProtocol.PROT_LINE_SHORT);
            lnw = true;
            sb.replace(0, 90, "***** Total Infos      : " + TestStatistic.getTotalInfos() + TestProtocol.S80);
            pIODevice.println(sb.substring(0, 73) + TestProtocol.PROT_LINE_SHORT);
            lnw = true;
            sb.replace(0, 90, "***** Total Reminders  : " + TestStatistic.getTotalReminders() + TestProtocol.S80);
            pIODevice.println(sb.substring(0, 73) + TestProtocol.PROT_LINE_SHORT);
            lnw = true;
            if (lnw) {
                pIODevice.println(TestProtocol.PROT_LINE_LONG);
            }
            this.mEndDate = new Date(System.currentTimeMillis());
            pIODevice.println("*****                       " + mDateFormat.format(this.mEndDate) + "                          " + TestProtocol.PROT_LINE_SHORT);
            pIODevice.println("*****                       End of TESTPROTOCOL                          *****");
            pIODevice.println(TestProtocol.PROT_LINE_LONG);
        }
    }

    private class TestProtocolHeader {
        private Date mStartDate;
        private String mDbName;
        private String mDbVersion = "";
        private String mDbBuildNumber = "";
        private String mBit = "0";
        private String mDbKernelMode = "";
        private String mDbHost;
        private String mDbRunDirectory = "";
        private String mDbRoot = "";
        private String mDbSysName;
        private String mOpSystem = "";
        private String mTestDriverVersion = "";
        private String mjdbcDriverVersion = null;
        private int mPort;

        TestProtocolHeader(String pDbName, String pDbHost, String pDbSysName, Date pStartDate) {
            this.mDbName = pDbName;
            this.mDbHost = pDbHost;
            this.mDbSysName = pDbSysName;
            this.mStartDate = pStartDate;
        }

        String getOpSystem() {
            return this.mOpSystem;
        }

        String getDbRunDirectory() {
            return this.mDbRunDirectory;
        }

        String getDbRoot() {
            return this.mDbRoot;
        }

        String getDbVersion() {
            return this.mDbVersion;
        }

        String getDbBuildNumber() {
            return this.mDbBuildNumber;
        }

        String getDbKernelMode() {
            return this.mDbKernelMode;
        }

        String getTestDriverVersion() {
            return this.mTestDriverVersion;
        }

        void setOpSystem(String pOpSystem) {
            this.mOpSystem = pOpSystem;
        }

        void setTestDriverVersion(String pTestDriverVersion) {
            this.mTestDriverVersion = pTestDriverVersion;
        }

        void setJDBCDriverVersion(String pJDBCDriverVersion) {
            this.mjdbcDriverVersion = pJDBCDriverVersion;
        }

        void setPort(int pPort) {
            this.mPort = pPort;
        }

        void setTestDriverStart(Date pTestDriverStart) {
            this.mStartDate = pTestDriverStart;
        }

        void setDbRunDirectory(String newDbRunDirectory) {
            this.mDbRunDirectory = newDbRunDirectory;
        }

        void setDbRoot(String newDbRoot) {
            this.mDbRoot = newDbRoot;
        }

        void setDbVersion(String newDbVersion) {
            this.mDbVersion = newDbVersion;
        }

        void setDbBuildNumber(String newDbBuildNumber) {
            this.mDbBuildNumber = newDbBuildNumber;
        }

        void setDbBit(String newDbBit) {
            this.mBit = newDbBit;
        }

        void setDbKernelMode(String newDbKernelMode) {
            this.mDbKernelMode = newDbKernelMode;
        }

        void print(PrintWriter pIODevice) throws IOException {
            int pos = 73;
            String timestamp = mDateFormat.format(this.mStartDate);
            pIODevice.println(TestProtocol.PROT_LINE_LONG);
            pIODevice.println("*****                       Begin of TESTPROTOCOL                        *****");
            pIODevice.println("*****                        " + timestamp + "                         " + TestProtocol.PROT_LINE_SHORT);
            pIODevice.println(TestProtocol.PROT_LINE_LONG);
            if (TestProtocol.this.isRemote()) {
                pIODevice.println("***** Test is running on remote DB. Please see file <Remote DB Sys Info> *****");
                pIODevice.println("***** The following information refers to your local machine.            *****");
                pIODevice.println(TestProtocol.PROT_LINE_LONG);
            }
            StringBuffer sb = new StringBuffer("***** Database type    : " + this.mDbSysName + TestProtocol.S80);
            pIODevice.println(sb.substring(0, 73) + TestProtocol.PROT_LINE_SHORT);
            sb.replace(0, 90, "***** TestDriver Vers. : " + this.mTestDriverVersion + TestProtocol.S80);
            pIODevice.println(sb.substring(0, 73) + TestProtocol.PROT_LINE_SHORT);
            if (System.getProperty("jtest.root") != null) {
                sb.replace(0, 90, "***** jtest_root       : " + System.getProperty("jtest.root") + TestProtocol.S80);
                pIODevice.println(sb.substring(0, 73) + TestProtocol.PROT_LINE_SHORT);
            }
            if (!this.mDbSysName.equals("NONE")) {
                sb.replace(0, 90, "***** Database         : " + this.mDbName + TestProtocol.S80);
                pIODevice.println(sb.substring(0, 73) + TestProtocol.PROT_LINE_SHORT);
                sb.replace(0, 90, "***** Port             : " + this.mPort + TestProtocol.S80);
                pIODevice.println(sb.substring(0, 73) + TestProtocol.PROT_LINE_SHORT);
            }
            if (!this.mDbVersion.trim().equals(TestProtocol.PROT_LINE_EMPTY)) {
                sb.replace(0, 90, "***** Version          : " + this.mDbVersion + TestProtocol.S80);
                pIODevice.println(sb.substring(0, 73) + TestProtocol.PROT_LINE_SHORT);
            }
            if (!this.mDbRoot.trim().equals(TestProtocol.PROT_LINE_EMPTY) && !TestProtocol.this.isRemote()) {
                sb.replace(0, 90, "***** Db Root          : " + this.mDbRoot + TestProtocol.S80);
                pIODevice.println(sb.substring(0, 73) + TestProtocol.PROT_LINE_SHORT);
            }
            if (!this.mDbKernelMode.trim().equals(TestProtocol.PROT_LINE_EMPTY)) {
                sb.replace(0, 90, "***** Kernel mode      : " + this.mDbKernelMode + TestProtocol.S80);
                pIODevice.println(sb.substring(0, 73) + TestProtocol.PROT_LINE_SHORT);
            }
            if (!this.mDbBuildNumber.trim().equals(TestProtocol.PROT_LINE_EMPTY)) {
                sb.replace(0, 90, "***** Build number     : " + this.mDbBuildNumber + TestProtocol.S80);
                pIODevice.println(sb.substring(0, 73) + TestProtocol.PROT_LINE_SHORT);
            }
            if (!this.mBit.trim().equals("0")) {
                sb.replace(0, 90, "***** 32 Bit / 64 Bit  : " + this.mBit + " Bit" + TestProtocol.S80);
                pIODevice.println(sb.substring(0, 73) + TestProtocol.PROT_LINE_SHORT);
            }
            sb.replace(0, 90, "***** Hostname         : " + this.mDbHost + TestProtocol.S80);
            pIODevice.println(sb.substring(0, 73) + TestProtocol.PROT_LINE_SHORT);
            if (!this.mOpSystem.trim().equals(TestProtocol.PROT_LINE_EMPTY)) {
                String ls = this.mOpSystem;
                if (this.mOpSystem.indexOf("\n") != -1) {
                    ls = ls.substring(0, this.mOpSystem.indexOf("\n"));
                }
                sb.replace(0, 90, "***** Operating system : " + ls + TestProtocol.S80);
                pIODevice.println(sb.substring(0, 73) + TestProtocol.PROT_LINE_SHORT);
            }
            if (!this.mDbRunDirectory.trim().equals(TestProtocol.PROT_LINE_EMPTY) && !TestProtocol.this.isRemote()) {
                sb.replace(0, 90, "***** Db Run Directory : " + this.mDbRunDirectory + TestProtocol.S80);
                pIODevice.println(sb.substring(0, 73) + TestProtocol.PROT_LINE_SHORT);
            }
            sb.replace(0, 90, "***** Java VM          : " + System.getProperty("java.vm.name") + " " + System.getProperty("java.vm.vendor") + TestProtocol.S80);
            pIODevice.println(sb.substring(0, 73) + TestProtocol.PROT_LINE_SHORT);
            sb.replace(0, 90, "***** Java VM Version  : " + System.getProperty("java.vm.version") + TestProtocol.S80);
            pIODevice.println(sb.substring(0, 73) + TestProtocol.PROT_LINE_SHORT);
            sb.replace(0, 90, "***** Java Version     : " + System.getProperty("java.version") + TestProtocol.S80);
            pIODevice.println(sb.substring(0, 73) + TestProtocol.PROT_LINE_SHORT);
            sb.replace(0, 90, "***** Java Path        : " + System.getProperty("java.home") + TestProtocol.S80);
            pIODevice.println(sb.substring(0, 73) + TestProtocol.PROT_LINE_SHORT);
            if (this.mjdbcDriverVersion != null) {
                sb.replace(0, 90, "***** JDBC Driver Vers.: " + this.mjdbcDriverVersion.substring(0, 48) + TestProtocol.S80);
                pIODevice.println(sb.substring(0, 73) + TestProtocol.PROT_LINE_SHORT);
                sb.replace(0, 90, "*****                  : " + this.mjdbcDriverVersion.substring(48) + TestProtocol.S80);
                pIODevice.println(sb.substring(0, 73) + TestProtocol.PROT_LINE_SHORT);
            }
            pIODevice.println(TestProtocol.PROT_LINE_LONG);
            pIODevice.println();
        }
    }

    class TestProtocolExceptionSqlItem
    extends TestProtocolExceptionItem {
        private String mSql;

        TestProtocolExceptionSqlItem(String pTestId, String pMessageId, char pMessageType, String pMessageText, Exception pException, String pSql) {
            super(pTestId, pMessageId, pMessageType, pMessageText, pException);
            this.mSql = pSql;
        }

        void printItem(PrintWriter pIODevice) throws IOException {
            pIODevice.println(TestProtocol.getErrorText(this.mMessageType) + this.mTestId + " " + this.mMessageId + " " + mDateFormat.format(this.mDate) + " " + this.mException.getClass());
            pIODevice.println(" + " + this.mSql);
            pIODevice.println(" - " + this.mMessageText);
            pIODevice.println(" !!! " + this.mException.getMessage());
            if (TestProtocol.this.mPrintExceptionTraceback) {
                pIODevice.println("Traceback (innermost first) {");
                this.mException.printStackTrace(pIODevice);
                pIODevice.println(" } End of traceback");
            }
        }
    }

    class TestProtocolExceptionItem
    extends TestProtocolBasicItem {
        Exception mException;

        TestProtocolExceptionItem(String pTestId, String pMessageId, char pMessageType, String pMessageText, Exception pException) {
            super(pTestId, pMessageId, pMessageType, pMessageText);
            this.mException = pException;
        }

        void printItem(PrintWriter pIODevice) throws IOException {
            pIODevice.println(TestProtocol.getErrorText(this.mMessageType) + " " + this.mTestId + " " + this.mMessageId + " " + mDateFormat.format(this.mDate) + " " + this.mException.getClass());
            pIODevice.println(" - " + this.mMessageText);
            pIODevice.println(" !!! " + this.mException.getMessage());
            if (TestProtocol.this.mPrintExceptionTraceback) {
                pIODevice.println("Traceback (innermost first) {");
                this.mException.printStackTrace(pIODevice);
                pIODevice.println(" } End of traceback");
            }
        }
    }

    class TestProtocolSqlItem
    extends TestProtocolBasicItem {
        private String mSql;

        TestProtocolSqlItem(String pTestId, String pMessageId, char pMessageType, String pMessageText, String pSql) {
            super(pTestId, pMessageId, pMessageType, pMessageText);
            this.mSql = pSql;
        }

        void printItem(PrintWriter pIODevice) throws IOException {
            pIODevice.println(TestProtocol.getErrorText(this.mMessageType) + " " + this.mTestId + " " + this.mMessageId + " " + mDateFormat.format(this.mDate));
            pIODevice.println(" + " + this.mSql);
            pIODevice.println(" - " + this.mMessageText);
        }
    }

    class TestProtocolItem
    extends TestProtocolBasicItem {
        TestProtocolItem(String pTestId, String pMessageId, char pMessageType, String pMessageText) {
            super(pTestId, pMessageId, pMessageType, pMessageText);
        }

        void printItem(PrintWriter pIODevice) throws IOException {
            pIODevice.println(TestProtocol.getErrorText(this.mMessageType) + " " + this.mTestId + " " + this.mMessageId + " " + mDateFormat.format(this.mDate));
            if (this.mMessageText == null) {
                pIODevice.println("Message text was null.\nPotential reason:\n - OutOfMemory error during a test\n - wrong call of the addMessage(..) method\n - java VM bug");
            } else if (this.mMessageText.indexOf("\n") != -1) {
                pIODevice.println(this.mMessageText);
            } else {
                pIODevice.println(" - " + this.mMessageText);
            }
        }
    }

    public abstract class TestProtocolBasicItem {
        String mTestId;
        Date mDate;
        String mMessageId;
        char mMessageType;
        String mMessageText;

        TestProtocolBasicItem(String pTestId, String pMessageId, char pMessageType, String pMessageText) {
            this.mTestId = pTestId;
            this.mMessageId = pMessageId;
            this.mMessageType = pMessageType;
            this.mMessageText = pMessageText;
            this.mDate = new Date(System.currentTimeMillis());
        }

        abstract void printItem(PrintWriter var1) throws IOException;

        String getTestId() {
            return this.mTestId;
        }

        char getMessageType() {
            return this.mMessageType;
        }

        public String getMessageText() {
            return this.mMessageText;
        }
    }
}

