/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.testframe.driver;

import com.sap.dbtech.powertoys.DBM;
import com.sap.dbtech.powertoys.DBMException;
import com.sap.dbtech.rte.comm.RTEException;
import com.sap.sapdb.testframe.driver.DatabaseNotExistentException;
import com.sap.sapdb.testframe.driver.TestDatabase;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDatabaseNotFoundException;
import com.sap.sapdb.testframe.driver.TestDatabaseSapDevice;
import com.sap.sapdb.testframe.driver.TestDriver;
import com.sap.sapdb.testframe.driver.TestDriverProtocol;
import com.sap.sapdb.testframe.driver.TestProtocol;
import com.sap.sapdb.testframe.driver.UnknownUserException;
import com.sap.sapdb.testframe.utilities.DBMFile;
import com.sap.sapdb.testframe.utilities.Execute;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;

public class TestDatabaseSap
extends TestDatabase {
    static final String JDBC_DRIVER = "com.sap.dbtech.jdbc.DriverSapDB";
    private String mInstanceType;
    private int mBitVersion = -1;
    private DBM mDBMan = null;
    private Properties mJdbcProps = null;
    private String mJdbcTraceOutput = null;
    private boolean mIsEnabledJdbcTrace = false;
    private String mAdditionalTrace = null;
    private Vector mDatabaseCommands = null;
    private Vector mDBMsrvCommands = null;
    private RegisteredDatabases mRegisteredDatabases = null;
    private String mRoot = null;
    private String mOsUser = null;
    private String mOsPassword = null;
    private String mSize = null;
    private TestDriverProtocol mProtocol = null;
    private boolean mIsCreated = false;
    private String mKernelMode = "FAST";
    private HashMap mConfiguration = null;
    private boolean mIsActionTraced = false;
    private String mKernelVersion = null;
    private String mKernelBuild = null;
    private String mRunDir = null;
    private String mHostName = "unknown";
    private ArrayList mDeviceList;
    private String mInitialState = null;
    private boolean mKeep = false;
    private String mKeepState = "OFFLINE";
    private boolean mDrop = false;
    private boolean mForceCreate = false;
    private boolean mIsShort = false;
    private boolean mDisableDatabaseRestart = false;
    private boolean mIsHSS = false;
    private boolean kernelBinaryMissing = false;
    private boolean mOLTPTraceEnabled = false;
    private boolean mOMSTraceEnabled = false;

    public TestDatabaseSap(String pHost, String pName) throws ClassNotFoundException, TestDatabaseException {
        super(JDBC_DRIVER);
        if (pHost.equalsIgnoreCase("NONE") || pName != null && pName.equalsIgnoreCase("NONE")) {
            this.mSys = "NONE";
            this.mHost = pHost;
            this.mName = pName;
            this.mDriver = null;
            this.mPort = 7210;
            this.mDBMUser = "NONE";
            this.mDBMPassword = "NONE";
            this.mDBAUser = "NONE";
            this.mDBAPassword = "NONE";
        } else {
            this.mSys = "SAP";
            this.mHost = pHost;
            this.mName = pName;
            this.mDriver = JDBC_DRIVER;
            this.mPort = 7210;
            this.mUrl = "jdbc:sapdb://" + pHost + ":" + this.mPort + "/" + pName;
            this.mDBMUser = "DBM";
            this.mDBMPassword = "DBM";
            this.mDBAUser = "DBA";
            this.mDBAPassword = "DBA";
            this.mJdbcTraceOutput = System.getProperty("user.dir") + System.getProperty("file.separator") + "jdbcTrace.prt";
        }
    }

    private void addProtocol(char pMessageType, String pText) {
        if (this.mProtocol == null) {
            System.out.println(TestProtocol.getErrorText(pMessageType) + " " + pText);
        } else {
            this.mProtocol.addItem(pMessageType, pText);
        }
    }

    private void addTraceToProtocol(String pText) {
        if (this.isActionTraced()) {
            this.mProtocol.addItem('T', pText);
        }
    }

    public void cold() throws TestDatabaseException {
        this.dbmCmd("db_cold");
    }

    public boolean isKernelBinaryMissing() {
        return this.kernelBinaryMissing;
    }

    private void configureInstance() throws DBMException, RTEException, TestDatabaseException, FileNotFoundException, IOException {
        int datSize = 0;
        int logSize = 0;
        if (this.mSize.equalsIgnoreCase("SMALL")) {
            datSize = 6250;
            logSize = 6250;
        } else if (this.mSize.equalsIgnoreCase("MEDIUM")) {
            datSize = 12500;
            logSize = 12500;
        } else if (this.mSize.equalsIgnoreCase("LARGE")) {
            datSize = 131072;
            logSize = 65536;
        } else if (this.mSize.equalsIgnoreCase("HUGE")) {
            datSize = 262144;
            logSize = 65536;
        }
        this.dbmCmd("param_startsession");
        try {
            if (this.mInstanceType == null) {
                this.dbmCmd("param_init");
            } else {
                this.dbmCmd("param_init " + this.mInstanceType);
            }
        }
        catch (TestDatabaseException dbe) {
            if (dbe.getLocalizedMessage().indexOf("param file of database already exists") != -1) {
                this.addProtocol('W', dbe.getLocalizedMessage());
                this.addProtocol('W', "Existing param file(s):\n" + this.dbmCmd("param_versions") + "\n\nTry to remove old existing param file with \"param_rmfile\"");
                this.dbmCmd("param_abortsession");
                this.dbmCmd("param_rmfile");
                this.dbmCmd("param_startsession");
                if (this.mInstanceType == null) {
                    this.dbmCmd("param_init");
                } else {
                    this.dbmCmd("param_init " + this.mInstanceType);
                }
            }
            throw dbe;
        }
        this.dbmCmd("param_put MAXLOCKS 20000");
        this.dbmCmd("param_put MAXUSERTASKS 50");
        this.dbmCmd("param_put MAXCPU " + this.getHardwareSettings("MAXCPU"));
        this.dbmCmd("param_put _COMMENT SAPDBJAVATEST");
        if (this.mConfiguration != null && !this.mConfiguration.isEmpty()) {
            Set keys = this.mConfiguration.keySet();
            Iterator it = keys.iterator();
            while (it.hasNext()) {
                String key = ((String)it.next()).toUpperCase().trim();
                String value = ((String)this.mConfiguration.get(key)).trim();
                this.addProtocol('I', "db-config-param: " + key + " " + value);
                this.dbmCmd("param_put " + key + " " + value);
            }
        }
        this.dbmCmd("param_checkall");
        this.dbmCmd("param_commitsession");
        if (this.mDeviceList != null && !this.mDeviceList.isEmpty()) {
            TestDatabaseSapDevice device;
            ListIterator it = this.mDeviceList.listIterator();
            StringBuffer sb = new StringBuffer();
            boolean existLogDev = false;
            boolean existDataDev = false;
            while (it.hasNext()) {
                TestDatabaseSapDevice device2 = (TestDatabaseSapDevice)it.next();
                if (!(device2.getKind().toUpperCase().compareTo("LOG") != 0 && device2.getKind().toUpperCase().compareTo("MLOG") != 0 || existLogDev)) {
                    existLogDev = true;
                }
                if (device2.getKind().toUpperCase().compareTo("DATA") != 0 || existDataDev) continue;
                existDataDev = true;
            }
            if (!(existLogDev && existDataDev)) {
                if (!existLogDev) {
                    throw new TestDatabaseException("ERROR: No LOG device in configuration-file definition!");
                }
                if (!existLogDev) {
                    throw new TestDatabaseException("ERROR: No DATA device in configuration-file definition!");
                }
            }
            ArrayList<String> listOfNames = new ArrayList<String>();
            it = this.mDeviceList.listIterator();
            while (it.hasNext()) {
                TestDatabaseSapDevice device3 = (TestDatabaseSapDevice)it.next();
                if (listOfNames.contains(device3.getName().toUpperCase())) {
                    throw new TestDatabaseException("ERROR: Duplicate dev name in configuration-file definition!");
                }
                listOfNames.add(device3.getName().toUpperCase());
            }
            ArrayList<String> listOfDataNumbers = new ArrayList<String>();
            ArrayList<String> listOfLogNumbers = new ArrayList<String>();
            it = this.mDeviceList.listIterator();
            while (it.hasNext()) {
                device = (TestDatabaseSapDevice)it.next();
                if (device.getKind().compareTo("DATA") == 0 && listOfDataNumbers.contains(Integer.toString(device.getNumber()))) {
                    throw new TestDatabaseException("ERROR: Duplicate DATA dev space number in configuration-file definition!");
                }
                if (device.getKind().compareTo("DATA") == 0) {
                    listOfDataNumbers.add(Integer.toString(device.getNumber()));
                }
                if ((device.getKind().compareTo("LOG") == 0 || device.getKind().compareTo("MLOG") == 0) && listOfLogNumbers.contains(Integer.toString(device.getNumber()))) {
                    throw new TestDatabaseException("ERROR: Duplicate LOG dev space number in configuration-file definition!");
                }
                if (device.getKind().compareTo("LOG") != 0 && device.getKind().compareTo("MLOG") != 0) continue;
                listOfLogNumbers.add(Integer.toString(device.getNumber()));
            }
            it = this.mDeviceList.listIterator();
            while (it.hasNext()) {
                device = (TestDatabaseSapDevice)it.next();
                sb.setLength(0);
                sb.append("param_adddevspace ");
                sb.append(Integer.toString(device.getNumber()));
                sb.append(" ");
                sb.append(device.getKind());
                sb.append(" ");
                sb.append(device.getName());
                sb.append(" ");
                sb.append(device.getType());
                sb.append(" ");
                sb.append(Integer.toString(device.getSize()));
                if (device.getPartitionNumber() != -1) {
                    sb.append(" ");
                    sb.append(Integer.toString(device.getPartitionNumber()));
                }
                this.dbmCmd(sb.toString());
            }
        } else {
            this.dbmCmd("param_adddevspace 1 DATA DAT_001.dat F " + Integer.toString(datSize));
            this.dbmCmd("param_adddevspace 1 LOG LOG_001.dat F " + Integer.toString(logSize));
        }
        if (TestDriver.compareRelease(this.getKernelVersion(), "<", "7.5.0")) {
            this.addTraceToProtocol("Try to call a db_register command to activate the correct kernel mode (" + this.mKernelMode + "); only necessary for database release lower than 7.5. An error will be ignored.");
            this.executeDBMcmd("db_register -" + this.mKernelMode.toLowerCase());
        }
    }

    public Connection connect() throws TestDatabaseException {
        Properties conp = new Properties();
        conp.put("user", this.mDBAUser);
        conp.put("password", this.mDBAPassword);
        if (this.isJDBCTraceEnabled()) {
            conp.put("trace", this.getJdbcTraceOutput());
        }
        Connection connection = this.connect(conp);
        return connection;
    }

    public Connection connect(String pUser, String pPassword) throws TestDatabaseException {
        Properties conp = new Properties();
        conp.put("user", pUser);
        conp.put("password", pPassword);
        if (this.isJDBCTraceEnabled()) {
            conp.put("trace", this.getJdbcTraceOutput());
        }
        Connection connection = this.connect(conp);
        return connection;
    }

    public Connection connect(Properties pInfo) throws TestDatabaseException {
        String key = null;
        try {
            if (this.isJDBCTraceEnabled()) {
                pInfo.put("trace", this.getJdbcTraceOutput());
            }
            if (this.mJdbcProps != null) {
                Enumeration<?> e = this.mJdbcProps.propertyNames();
                while (e.hasMoreElements()) {
                    key = e.nextElement().toString();
                    pInfo.put(key, this.mJdbcProps.getProperty(key));
                }
            }
            Connection connection = DriverManager.getConnection(this.mUrl, pInfo);
            return connection;
        }
        catch (SQLException e) {
            throw new TestDatabaseException(e, "Cannot connect with user: " + pInfo.get("user") + ", " + pInfo.get("password"));
        }
    }

    public void createInstance() throws TestDatabaseException, IOException, FileNotFoundException {
        this.createInstance(null);
    }

    /*
     * Loose catch block
     */
    public void createInstance(TestDriver mMaster) throws TestDatabaseException, IOException, FileNotFoundException {
        block54: {
            this.mIsCreated = this.register();
            if (!this.isCreated()) {
                if (this.isForceCreate()) {
                    boolean isDroped = false;
                    if (mMaster != null) {
                        mMaster.printMessage("Dropping existing database <" + this.mName + ">");
                    }
                    if (!isDroped) {
                        isDroped = this.dropInstance(this.mDBMUser, this.mDBMPassword, true);
                    }
                    if (!isDroped) {
                        isDroped = this.dropInstance(this.mDBMUser.toUpperCase(), this.mDBMPassword.toUpperCase(), true);
                    }
                    if (!isDroped) {
                        isDroped = this.dropInstance(this.mDBMUser.toLowerCase(), this.mDBMPassword.toLowerCase(), true);
                    }
                    if (!isDroped) {
                        isDroped = this.dropInstance("DBM", "DBM", true);
                    }
                    if (!isDroped) {
                        isDroped = this.dropInstance("DBM".toUpperCase(), "DBM".toUpperCase(), true);
                    }
                    if (!isDroped) {
                        isDroped = this.dropInstance("DBM".toLowerCase(), "DBM".toLowerCase(), true);
                    }
                    if (!isDroped) {
                        isDroped = this.dropInstance("CONTROL", "CONTROL", true);
                    }
                    if (!isDroped) {
                        isDroped = this.dropInstance("CONTROL".toUpperCase(), "CONTROL".toUpperCase(), true);
                    }
                    if (!isDroped) {
                        isDroped = this.dropInstance("CONTROL".toLowerCase(), "CONTROL".toLowerCase(), true);
                    }
                    if (!(isDroped = true)) {
                        throw new TestDatabaseException("Could not drop database instance");
                    }
                    this.mDBMan = null;
                    if (mMaster != null) {
                        mMaster.printMessage("Registering the new instance");
                    }
                    this.mIsCreated = this.register();
                    if (!this.mIsCreated) {
                        throw new TestDatabaseException("Could not re-create database instance");
                    }
                } else {
                    throw new TestDatabaseNotFoundException("Database could not be registered, and auto creation is disabled");
                }
            }
            if (this.mDBMan != null) {
                this.mDBMan.release();
            }
            this.mDBMan = null;
            this.configureInstance();
            if (mMaster != null) {
                mMaster.printMessage("Starting <" + this.mName + "> in admin mode with " + this.mKernelMode + " kernel");
            }
            this.dbmCmd("db_start -" + this.mKernelMode);
            if (mMaster != null) {
                mMaster.addTraceToProtocol("set kernel build");
            }
            this.setKernelBuild();
            if (mMaster != null) {
                mMaster.addTraceToProtocol("Database release: " + this.getKernelVersion() + "." + this.getKernelBuild().substring(0, 3));
            }
            if (TestDriver.compareRelease(this.getKernelVersion() + "." + this.getKernelBuild().substring(0, 3), ">=", "7.4.4.1")) {
                if (mMaster != null) {
                    mMaster.printMessage("Running: db_activate");
                }
                if (mMaster != null) {
                    mMaster.setTestMonitorStatus("Driver: db_activate");
                }
                this.dbmCmd("db_activate " + this.mDBAUser + "," + this.mDBAPassword);
            } else {
                if (mMaster != null) {
                    mMaster.printMessage("Running INIT CONFIG");
                }
                this.dbmCmd("util_connect");
                if (mMaster != null) {
                    mMaster.setTestMonitorStatus("Driver: INIT CONFIG");
                }
                this.dbmCmd("util_execute INIT CONFIG");
                if (mMaster != null) {
                    mMaster.printMessage("Activating");
                }
                if (mMaster != null) {
                    mMaster.setTestMonitorStatus("Driver: Activating");
                }
                this.dbmCmd("util_activate " + this.mDBAUser + "," + this.mDBAPassword);
                this.dbmCmd("util_release");
            }
            if (!this.isShort()) {
                if (mMaster != null) {
                    mMaster.printMessage("Loading system tables");
                }
                if (mMaster != null) {
                    mMaster.setTestMonitorStatus("Driver: Loading system tables");
                }
                this.dbmCmd("load_systab -ud DOMAIN");
                if (mMaster != null && !this.mDisableDatabaseRestart) {
                    mMaster.setTestMonitorStatus("Driver: Restart (" + this.mKernelMode + ")");
                }
                if (!this.mDisableDatabaseRestart) {
                    this.dbmCmd("db_restart -" + this.mKernelMode);
                }
            }
            if (this.getKernelVersion().startsWith("7.2")) {
                this.enableWriteTransactionForLiveCache();
            }
            if (!this.isShort()) {
                if (mMaster != null) {
                    mMaster.printMessage("Creating initial backup in file DAT_RESET.dat and a backup in file DAT_INIT.dat");
                }
                this.dbmCmd("backup_media_put IND DAT_INIT.dat FILE DATA 0 8 YES");
                this.dbmCmd("backup_media_put RSV DAT_RESET.dat FILE DATA 0 8 YES");
            }
            this.dbmCmd("backup_media_put auto autosave FILE AUTO");
            if (this.isLiveCache()) {
                String dbaUser = this.mDBAUser + "," + this.mDBAPassword;
                this.dbmCmd("sql_connect " + dbaUser);
                try {
                    this.dbmCmd("sql_execute call force_and_wait_for_checkpoint");
                }
                catch (Exception e) {
                    System.out.println("Exception :" + e.getLocalizedMessage());
                }
                try {
                    this.dbmCmd("sql_release");
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.dbmCmd("util_connect");
            if (!this.isShort()) {
                this.dbmCmd("backup_save IND MIGRATION DATA");
                this.dbmCmd("backup_save RSV MIGRATION DATA");
            }
            try {
                this.dbmCmd("autosave_on");
            }
            catch (TestDatabaseException tde) {
                this.addProtocol('I', "Only in 7.4 is autosave_on allowed.");
            }
            this.dbmCmd("util_release");
            if (this.mIsHSS && this.mConfiguration.get("HS_NODE_002") != null) {
                String node = this.mConfiguration.get("HS_NODE_002").toString();
                String osUser = this.mOsUser + "," + this.mOsPassword;
                this.dbmCmd("hss_removestandby node=" + node);
                this.dbmCmd("hss_addstandby node=" + node + " login=" + osUser + " path=" + this.getDBRoot() + " user=yes");
            }
            this.dbmCmd("db_stop");
            this.mDBMan.release();
            this.mDBMan = null;
            Object var5_10 = null;
            try {
                if (this.mDBMan != null) {
                    this.dbmCmd("util_release");
                    this.dbmCmd("sql_release");
                    this.mDBMan.release();
                    this.mDBMan = null;
                }
                break block54;
            }
            catch (Exception e) {
                this.mDBMan = null;
            }
            break block54;
            {
                catch (Exception e) {
                    this.addProtocol('E', e.getMessage());
                    throw new TestDatabaseException(e, e.getMessage());
                }
            }
            catch (Throwable throwable) {
                Object var5_11 = null;
                try {
                    if (this.mDBMan != null) {
                        this.dbmCmd("util_release");
                        this.dbmCmd("sql_release");
                        this.mDBMan.release();
                        this.mDBMan = null;
                    }
                }
                catch (Exception e) {
                    this.mDBMan = null;
                }
                throw throwable;
            }
        }
    }

    private String dbmCmd(String pCmd) throws TestDatabaseException {
        String cmd = null;
        String result = null;
        this.addTraceToProtocol("dbmCmd('" + pCmd + "') with host: " + this.mHost + ", port: " + this.mPort + ", name: " + this.mName + ", root: " + this.mRoot);
        if (this.mDBMan == null) {
            try {
                this.mDBMan = DBM.dbDBM((String)(this.mHost + ":" + this.mPort), (String)this.mName);
            }
            catch (RTEException e) {
                this.mDBMan = null;
                throw new DatabaseNotExistentException((Exception)((Object)e), this.mName, this.mHost);
            }
            cmd = "USER_LOGON " + this.mDBMUser + ',' + this.mDBMPassword;
            try {
                this.mDBMan.cmd(cmd);
            }
            catch (RTEException e) {
                this.mDBMan = null;
                throw new UnknownUserException((Exception)((Object)e), this.mName, this.mDBMUser + ", " + this.mDBMPassword);
            }
            catch (DBMException e) {
                this.mDBMan = null;
                throw new UnknownUserException((Exception)((Object)e), this.mName, this.mDBMUser + ", " + this.mDBMPassword);
            }
            this.addTraceToProtocol("Trying dbm command: " + cmd + " ... successful!");
        }
        cmd = pCmd;
        try {
            SimpleDateFormat myStartDate = new SimpleDateFormat("HH:mm:ss.S");
            this.addTraceToProtocol("Trying dbm command: " + cmd + " at " + myStartDate.format(new Date(System.currentTimeMillis())));
            result = this.mDBMan.cmd(cmd);
            if (pCmd.equalsIgnoreCase("db_state")) {
                this.addTraceToProtocol("" + cmd + " ... successful at " + myStartDate.format(new Date(System.currentTimeMillis())) + " with: " + result);
            } else {
                this.addTraceToProtocol("" + cmd + " ... successful at " + myStartDate.format(new Date(System.currentTimeMillis())));
            }
            return result;
        }
        catch (Exception e) {
            this.addTraceToProtocol("Trying dbm command: '" + cmd + "' and getting: " + e.getLocalizedMessage());
            this.kernelBinaryMissing = this.checkForKernelBinaryMissingError(e.getMessage());
            if (this.mDBMan != null) {
                try {
                    this.mDBMan.release();
                }
                catch (RTEException rtee) {
                    // empty catch block
                }
            }
            this.mDBMan = null;
            throw new TestDatabaseException(e, "Trying: " + cmd + ", Current command: '" + cmd + "' getting: " + e.getLocalizedMessage());
        }
    }

    private String dbmCmd(String pCmd, String pUser, String pPassword) throws TestDatabaseException {
        String cmd = null;
        try {
            if (this.mDBMan == null) {
                this.mDBMan = DBM.dbDBM((String)(this.mHost + ":" + this.mPort), (String)this.mName);
            }
            cmd = "USER_LOGON " + pUser + ',' + pPassword;
            this.mDBMan.cmd(cmd);
            this.addTraceToProtocol("Trying " + cmd + " ... successful!");
            cmd = pCmd;
            String result = this.mDBMan.cmd(cmd);
            this.addTraceToProtocol("Trying " + cmd + " ... successful!");
            return result;
        }
        catch (Exception e) {
            this.addTraceToProtocol("Trying " + cmd);
            throw new TestDatabaseException(e, "Trying :" + cmd + ", Current command: " + cmd);
        }
    }

    private String dbmCmdSql(String pCmd) throws TestDatabaseException {
        String cmd = null;
        if (this.mDBMan == null) {
            try {
                this.mDBMan = DBM.dbDBM((String)(this.mHost + ":" + this.mPort), (String)this.mName);
            }
            catch (RTEException e) {
                throw new DatabaseNotExistentException((Exception)((Object)e), this.mName, this.mHost);
            }
            cmd = "USER_LOGON " + this.mDBMUser + ',' + this.mDBMPassword;
            try {
                this.mDBMan.cmd(cmd);
            }
            catch (RTEException e) {
                throw new UnknownUserException((Exception)((Object)e), this.mName, this.mDBMUser + ", " + this.mDBMPassword);
            }
            catch (DBMException e) {
                throw new UnknownUserException((Exception)((Object)e), this.mName, this.mDBMUser + ", " + this.mDBMPassword);
            }
            this.addTraceToProtocol("Trying " + cmd + " ... successful!");
        }
        try {
            cmd = "sql_connect";
            this.mDBMan.cmd(cmd);
            cmd = pCmd;
            String result = this.mDBMan.cmd(cmd);
            this.addTraceToProtocol("Trying " + cmd + " ... successful!");
            cmd = "sql_release";
            this.mDBMan.cmd(cmd);
            return result;
        }
        catch (Exception e) {
            this.addTraceToProtocol("Trying " + cmd);
            throw new TestDatabaseException(e, "Trying :" + cmd + ", Current command: " + cmd);
        }
    }

    public void disableJDBCTrace() {
        this.mIsEnabledJdbcTrace = false;
    }

    /*
     * Loose catch block
     */
    public void disableOLTPTrace() throws TestDatabaseException {
        block15: {
            Connection con = null;
            Statement stmt = null;
            con = this.connect();
            stmt = con.createStatement();
            stmt.executeUpdate("Diagnose vtrace default off");
            this.mOLTPTraceEnabled = false;
            Object var5_3 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException err) {
                // empty catch block
            }
            try {
                if (con != null) {
                    con.close();
                }
                break block15;
            }
            catch (SQLException err) {}
            break block15;
            {
                catch (SQLException e) {
                    throw new TestDatabaseException(e, "vTrace could not be disabled");
                }
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException err) {
                    // empty catch block
                }
                try {
                    if (con != null) {
                        con.close();
                    }
                }
                catch (SQLException err) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public void disableOMSTrace() throws TestDatabaseException {
        block15: {
            Connection con = null;
            Statement stmt = null;
            con = this.connect();
            stmt = con.createStatement();
            stmt.executeUpdate("Diagnose vtrace object off");
            this.mOMSTraceEnabled = false;
            Object var5_3 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException err) {
                // empty catch block
            }
            try {
                if (con != null) {
                    con.close();
                }
                break block15;
            }
            catch (SQLException err) {}
            break block15;
            {
                catch (SQLException e) {
                    throw new TestDatabaseException(e, "object vTrace could not be disabled");
                }
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException err) {
                    // empty catch block
                }
                try {
                    if (con != null) {
                        con.close();
                    }
                }
                catch (SQLException err) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dropInstance() throws TestDatabaseException {
        if (!this.isCreated()) {
            System.out.println("jtest--> Don't drop the database because it wasn't created.");
            this.addTraceToProtocol("Don't drop the database because it wasn't created.");
            return true;
        }
        boolean isDroped = false;
        try {
            this.addTraceToProtocol("Trying drop database ...");
            if (this.mInstanceType.compareTo("LVC") != 0) {
                try {
                    this.dbmCmd("db_cold");
                    this.dbmCmd("util_connect");
                    this.dbmCmd("autosave_off");
                    this.dbmCmd("util_release");
                }
                catch (Exception e) {
                    this.addProtocol('E', e.getMessage());
                }
                finally {
                    try {
                        this.dbmCmd("util_release");
                    }
                    catch (Exception e) {}
                }
            }
            String wrkDir = this.dbmCmd("param_getvalue RUNDIRECTORY");
            wrkDir = wrkDir.substring(0, wrkDir.indexOf(10));
            this.dbmCmd("db_stop");
            this.dbmCmd("db_clear");
            this.dbmCmd("db_drop");
            if (this.mDBMan != null) {
                this.mDBMan.release();
                this.mDBMan = null;
            }
            if (this.getHost().equals("localhost")) {
                this.addTraceToProtocol("Trying to clean up file directory ...");
                File FileDir = new File(wrkDir);
                if (FileDir.isDirectory()) {
                    String[] FileList = FileDir.list();
                    for (int i = 0; i < FileList.length; ++i) {
                        File file = new File(FileDir, FileList[i]);
                        file.delete();
                    }
                    FileDir.delete();
                }
            }
            isDroped = true;
        }
        catch (Exception e) {
            throw new TestDatabaseException(e, e.getMessage());
        }
        return isDroped;
    }

    public boolean dropInstance(String pUser, String pPassword, boolean pDropRundir) {
        boolean isDroped = false;
        try {
            this.addTraceToProtocol("Trying drop database ...");
            String wrkDir = this.dbmCmd("param_getvalue RUNDIRECTORY");
            wrkDir = wrkDir.substring(0, wrkDir.indexOf(10));
            this.dbmCmd("db_stop", pUser, pPassword);
            this.dbmCmd("db_clear");
            this.dbmCmd("db_drop", pUser, pPassword);
            if (pDropRundir && this.getHost().equals("localhost")) {
                this.addTraceToProtocol("Trying to clean up file directory '" + wrkDir + "'...");
                File FileDir = new File(wrkDir);
                if (FileDir.isDirectory()) {
                    String[] FileList = FileDir.list();
                    for (int i = 0; i < FileList.length; ++i) {
                        File file = new File(FileDir, FileList[i]);
                        file.delete();
                    }
                    FileDir.delete();
                }
            }
            if (this.mIsHSS) {
                this.addTraceToProtocol("Trying drop database on node " + this.mConfiguration.get("HS_NODE_002").toString() + " ...");
                this.setHost(this.mConfiguration.get("HS_NODE_002").toString());
                this.dbmCmd("db_stop", pUser, pPassword);
                this.dbmCmd("db_clear");
                this.dbmCmd("db_drop", pUser, pPassword);
                this.setHost(this.mConfiguration.get("HS_NODE_001").toString());
            }
            isDroped = true;
        }
        catch (Exception e) {
            this.addProtocol('E', e.getLocalizedMessage());
            isDroped = false;
        }
        return isDroped;
    }

    public void enableJDBCTrace() {
        this.mIsEnabledJdbcTrace = true;
        this.addTraceToProtocol("jdbc trace enabled. Tracefile: " + this.getJdbcTraceOutput());
    }

    /*
     * Loose catch block
     */
    public void enableOLTPTrace() throws TestDatabaseException {
        block16: {
            Connection con = null;
            Statement stmt = null;
            this.addTraceToProtocol("Try to enable OLTP trace");
            con = this.connect();
            stmt = con.createStatement();
            stmt.executeUpdate("Diagnose vtrace default on");
            this.mOLTPTraceEnabled = true;
            Object var5_3 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException err) {
                // empty catch block
            }
            try {
                if (con != null) {
                    con.close();
                }
                break block16;
            }
            catch (SQLException err) {}
            break block16;
            {
                catch (SQLException e) {
                    System.err.println("SQLException: " + e.getLocalizedMessage());
                    e.printStackTrace();
                    throw new TestDatabaseException(e, "vTrace could not be enabled");
                }
                catch (NullPointerException npe) {
                    System.err.println("NullPointerException: " + npe.getLocalizedMessage());
                    npe.printStackTrace();
                    throw new TestDatabaseException(npe, "object vTrace could not be enabled");
                }
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException err) {
                    // empty catch block
                }
                try {
                    if (con != null) {
                        con.close();
                    }
                }
                catch (SQLException err) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public void enableOMSTrace() throws TestDatabaseException {
        block16: {
            Connection con = null;
            Statement stmt = null;
            this.addTraceToProtocol("Try to enable OMS trace");
            con = this.connect();
            stmt = con.createStatement();
            stmt.executeUpdate("Diagnose vtrace object on");
            this.mOMSTraceEnabled = true;
            Object var5_3 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException err) {
                // empty catch block
            }
            try {
                if (con != null) {
                    con.close();
                }
                break block16;
            }
            catch (SQLException err) {}
            break block16;
            {
                catch (SQLException e) {
                    System.err.println("SQLException: " + e.getLocalizedMessage());
                    e.printStackTrace();
                    throw new TestDatabaseException(e, "object vTrace could not be enabled");
                }
                catch (NullPointerException npe) {
                    System.err.println("NullPointerException: " + npe.getLocalizedMessage());
                    npe.printStackTrace();
                    throw new TestDatabaseException(npe, "object vTrace could not be enabled");
                }
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException err) {
                    // empty catch block
                }
                try {
                    if (con != null) {
                        con.close();
                    }
                }
                catch (SQLException err) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public void enableAdditionalTrace() throws TestDatabaseException {
        block20: {
            Statement stmt;
            Connection con;
            block18: {
                if (this.mAdditionalTrace == null) {
                    return;
                }
                boolean error = false;
                con = null;
                stmt = null;
                String vtraceToken = null;
                String currentcmd = null;
                this.addProtocol('W', "Please do not use the tag <db-additional-trace> in the cfg file. Instead of that use the tag <database-command> in the same file to describe the additional trace. For help, please look into the TestDriverConfig.dtd .");
                con = this.connect();
                stmt = con.createStatement();
                StringTokenizer traceToken = new StringTokenizer(this.mAdditionalTrace, ",");
                while (traceToken.hasMoreTokens()) {
                    vtraceToken = traceToken.nextToken().trim();
                    currentcmd = vtraceToken.indexOf("=") != -1 ? "SET PARAMETER " + vtraceToken : "diagnose vtrace " + vtraceToken + " on";
                    this.addTraceToProtocol("Try to enable additional trace with: " + currentcmd);
                    try {
                        stmt.executeUpdate(currentcmd);
                    }
                    catch (SQLException innersqle) {
                        error = true;
                        this.addTraceToProtocol("Can't execute: Diagnose vtrace " + vtraceToken + " on -> " + innersqle.getLocalizedMessage());
                    }
                }
                con.commit();
                if (!error) break block18;
                this.addProtocol('W', "At least one additional vtrace command has not been executed. Use testDriver option \"-T\" for more information.");
            }
            Object var9_9 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException err) {
                // empty catch block
            }
            try {
                if (con != null) {
                    con.close();
                }
                break block20;
            }
            catch (SQLException err) {}
            break block20;
            {
                catch (SQLException e) {
                    throw new TestDatabaseException(e, "additional vTrace could not be enabled.");
                }
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException err) {
                    // empty catch block
                }
                try {
                    if (con != null) {
                        con.close();
                    }
                }
                catch (SQLException err) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public void executeDatabaseCommands() throws TestDatabaseException {
        block19: {
            if (this.mDatabaseCommands == null) {
                return;
            }
            this.addTraceToProtocol("in executeDatabaseCommands() with mURL = " + this.mUrl + ", mDBAUser = " + this.mDBAUser);
            Connection con = null;
            Statement stmt = null;
            String currentcmd = null;
            con = this.connect();
            stmt = con.createStatement();
            for (int i = 0; i < this.mDatabaseCommands.size(); ++i) {
                currentcmd = (String)this.mDatabaseCommands.get(i);
                this.addTraceToProtocol("Try to execute the database command: " + currentcmd);
                try {
                    stmt.executeUpdate(currentcmd);
                    continue;
                }
                catch (SQLException innersqle) {
                    this.addProtocol('E', "Can not execute the database command: " + currentcmd + " ->\n" + innersqle.getLocalizedMessage());
                }
            }
            con.commit();
            Object var7_7 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException err) {
                // empty catch block
            }
            try {
                if (con != null) {
                    con.close();
                }
                break block19;
            }
            catch (SQLException err) {}
            break block19;
            {
                catch (SQLException e) {
                    throw new TestDatabaseException(e, "The method executeDatabaseCommands() caught an exception.");
                }
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException err) {
                    // empty catch block
                }
                try {
                    if (con != null) {
                        con.close();
                    }
                }
                catch (SQLException err) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void executeDBMServerCommands() throws TestDatabaseException {
        if (this.mDBMsrvCommands == null) {
            return;
        }
        String currentcmd = null;
        DBM myDBM = null;
        try {
            try {
                this.addTraceToProtocol("in executeDBMServerCommands() with mHost = " + this.mHost + ", mPort = " + this.mPort + ", mName = " + this.mName + ", mDBMUser = " + this.mDBMUser);
                if (myDBM == null) {
                    myDBM = DBM.dbDBM((String)(this.mHost + ":" + this.mPort), (String)this.mName);
                    String logon = "USER_LOGON " + this.mDBMUser + ',' + this.mDBMPassword;
                    myDBM.cmd(logon);
                }
                for (int i = 0; i < this.mDBMsrvCommands.size(); ++i) {
                    currentcmd = (String)this.mDBMsrvCommands.get(i);
                    this.addTraceToProtocol("Try to execute the dbm server command: " + currentcmd);
                    try {
                        myDBM.cmd(currentcmd);
                        continue;
                    }
                    catch (DBMException innersqle) {
                        this.addProtocol('E', "Can not execute the dbm server command: " + currentcmd + " ->\n" + innersqle.getLocalizedMessage());
                    }
                }
                Object var6_8 = null;
            }
            catch (RTEException rtee) {
                throw new TestDatabaseException((Exception)((Object)rtee), "The method executeDBMServerCommands() caught an exception.");
            }
            catch (DBMException dbme) {
                throw new TestDatabaseException((Exception)((Object)dbme), "The method executeDBMServerCommands() caught an exception.");
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            try {
                if (myDBM != null) {
                    myDBM.release();
                }
                myDBM = null;
                throw throwable;
            }
            catch (RTEException err) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (RTEException err) {}
        if (myDBM == null) return;
        myDBM.release();
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void enableWriteTransactionForLiveCache() {
        block12: {
            block11: {
                try {
                    try {
                        if (!this.isLiveCache()) {
                            var4_1 = null;
                            break block11;
                        }
                        dbmUser = this.mDBMUser + "," + this.mDBMPassword;
                        this.mDBMan.cmd("user_logon " + dbmUser);
                        admUser = this.mDBAUser + "," + this.mDBAPassword;
                        this.mDBMan.cmd("sql_connect " + admUser);
                        this.mDBMan.cmd("sql_execute ENABLE WRITE TRANSACTION");
                        break block12;
                    }
                    catch (Exception e) {
                        this.addProtocol('E', "Enable write transaction for live cache failed");
                        var4_3 = null;
                        try {
                            if (this.mDBMan == null) return;
                            this.mDBMan.cmd("sql_release");
                            return;
                        }
                        catch (Exception e) {
                            return;
                        }
                    }
                }
                catch (Throwable var3_12) {
                    var4_4 = null;
                    ** try [egrp 2[TRYBLOCK] [6 : 167->187)] { 
lbl31:
                    // 1 sources

                    if (this.mDBMan == null) throw var3_12;
                    this.mDBMan.cmd("sql_release");
                    throw var3_12;
lbl35:
                    // 1 sources

                    catch (Exception e) {
                        // empty catch block
                    }
                    throw var3_12;
                }
            }
            ** try [egrp 2[TRYBLOCK] [6 : 167->187)] { 
lbl40:
            // 1 sources

            if (this.mDBMan == null) return;
            this.mDBMan.cmd("sql_release");
            return;
lbl44:
            // 1 sources

            catch (Exception e) {
                // empty catch block
            }
            return;
        }
        var4_2 = null;
        try {}
        catch (Exception e) {}
        if (this.mDBMan == null) return;
        this.mDBMan.cmd("sql_release");
        return;
    }

    public String executeDBMcmd(String pCmd) throws TestDatabaseException {
        String logon = "";
        try {
            this.addTraceToProtocol("execute DBM command: " + pCmd);
            if (this.mDBMan == null) {
                this.mDBMan = DBM.dbDBM((String)(this.mHost + ":" + this.mPort), (String)this.mName);
                logon = "USER_LOGON " + this.mDBMUser + ',' + this.mDBMPassword;
                this.mDBMan.cmd(logon);
            }
            return this.mDBMan.cmd(pCmd);
        }
        catch (DBMException dbe) {
            throw new TestDatabaseException((Exception)((Object)dbe), " DBM command: " + pCmd + ", logon String: " + logon);
        }
        catch (Exception e) {
            try {
                if (this.mDBMan != null) {
                    this.mDBMan.release();
                }
            }
            catch (Exception e2) {
                // empty catch block
            }
            this.mDBMan = null;
            throw new TestDatabaseException(e, " DBM command: " + pCmd + ", logon String: " + logon);
        }
    }

    public String executeDBMcmdWithoutLogin(String pCmd) throws TestDatabaseException {
        try {
            if (this.mDBMan == null) {
                if (this.isActionTraced()) {
                    System.out.println("Try new dbm with: 'mDBMan = DBM.dbDBM(" + this.mHost + ":" + this.mPort + "," + this.mName + ")'");
                }
                this.mDBMan = DBM.dbDBM((String)(this.mHost + ":" + this.mPort), (String)this.mName);
            }
            this.addTraceToProtocol("execute DBM command without user login: '" + pCmd + "' with DBM.dbDBM(" + this.mHost + ":" + this.mPort + "," + this.mName + ")");
            if (this.isActionTraced()) {
                System.out.println("Try to call: mDBMan.cmd(" + pCmd + ")");
            }
            String tmp = this.mDBMan.cmd(pCmd);
            this.mDBMan.release();
            this.mDBMan = null;
            return tmp;
        }
        catch (DBMException dbe) {
            throw new TestDatabaseException((Exception)((Object)dbe), " DBM command: " + pCmd);
        }
        catch (Exception e) {
            try {
                if (this.mDBMan != null) {
                    this.mDBMan.release();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.mDBMan = null;
            throw new TestDatabaseException(e, " DBM command: " + pCmd);
        }
    }

    public boolean exists() {
        DBM DBMan = null;
        try {
            DBMan = DBM.dbDBM((String)(this.mHost + ":" + this.mPort), (String)this.mName);
            DBMan.release();
            DBMan = null;
        }
        catch (RTEException e) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean existsUser(String pUser, String pPassword) {
        block15: {
            DBM DBMan = null;
            DBMan = DBM.dbDBM((String)(this.mHost + ":" + this.mPort), (String)this.mName);
            DBMan.cmd("USER_LOGON " + pUser + ',' + pPassword);
            Object var7_4 = null;
            try {
                if (DBMan != null) {
                    DBMan.release();
                }
                break block15;
            }
            catch (Exception e2) {}
            break block15;
            {
                catch (RTEException e) {
                    boolean bl = false;
                    Object var7_5 = null;
                    try {
                        if (DBMan != null) {
                            DBMan.release();
                        }
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    return bl;
                }
                catch (DBMException e) {
                    boolean bl;
                    try {
                        bl = false;
                        Object var7_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_7 = null;
                        try {
                            if (DBMan != null) {
                                DBMan.release();
                            }
                        }
                        catch (Exception e2) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    try {
                        if (DBMan != null) {
                            DBMan.release();
                        }
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    return bl;
                }
            }
        }
        return true;
    }

    /*
     * Loose catch block
     */
    void flushTrace() throws TestDatabaseException {
        block16: {
            if (this.mOMSTraceEnabled || this.mOLTPTraceEnabled || this.mAdditionalTrace != null || this.mDatabaseCommands != null && this.mDatabaseCommands.size() > 0) {
                Connection con = null;
                Statement stmt = null;
                String cmd = null;
                con = this.connect();
                stmt = con.createStatement();
                cmd = this.getKernelVersion() != null && this.getKernelBuild() != null && TestDriver.compareRelease(this.getKernelVersion() + "." + this.getKernelBuild().substring(0, 3), ">=", "7.4.4.1") ? "diagnose vtrace flush" : "vtrace";
                stmt.executeUpdate(cmd);
                Object var6_4 = null;
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException err) {
                    // empty catch block
                }
                try {
                    if (con != null) {
                        con.close();
                    }
                    break block16;
                }
                catch (SQLException err) {}
                break block16;
                {
                    catch (Exception e) {
                        this.addProtocol('E', "flushTrace with \"" + cmd + "\" failed. " + e.getMessage());
                        throw new TestDatabaseException(e, "flushTrace  with \"" + cmd + "\" failed");
                    }
                }
                catch (Throwable throwable) {
                    Object var6_5 = null;
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (SQLException err) {
                        // empty catch block
                    }
                    try {
                        if (con != null) {
                            con.close();
                        }
                    }
                    catch (SQLException err) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
    }

    public String getAllParameter() throws TestDatabaseException {
        return this.executeDBMcmd("param_directgetall");
    }

    public File getAllParameterAsFile() throws Exception {
        File tmpFile = File.createTempFile("params", ".txt");
        tmpFile.deleteOnExit();
        FileWriter writer = new FileWriter(tmpFile);
        writer.write(this.getAllParameter());
        writer.close();
        return tmpFile;
    }

    public String getDatabaseProtocolViaDBMKey(String pKey) throws Exception {
        if (this.mDBMan != null) {
            this.mDBMan.release();
        }
        try {
            this.mDBMan = DBM.dbDBM((String)(this.mHost + ":" + this.mPort), (String)this.mName);
        }
        catch (RTEException e) {
            throw new DatabaseNotExistentException((Exception)((Object)e), this.mName, this.mHost);
        }
        String cmd = "USER_LOGON " + this.mDBMUser + ',' + this.mDBMPassword;
        try {
            this.mDBMan.cmd(cmd);
        }
        catch (RTEException e) {
            throw new UnknownUserException((Exception)((Object)e), this.mName, this.mDBMUser + ", " + this.mDBMPassword);
        }
        catch (DBMException e) {
            throw new UnknownUserException((Exception)((Object)e), this.mName, this.mDBMUser + ", " + this.mDBMPassword);
        }
        this.addTraceToProtocol("Trying dbm command: " + cmd + " ... successful!");
        DBMFile df = new DBMFile(this.mDBMan);
        StringBuffer sb = new StringBuffer();
        DBMFile.DBMFileInputStream in = df.getInputStream(pKey);
        byte[] buf = new byte[4096];
        int n = 0;
        if (in.available() > 0x200000) {
            throw new Exception("File length: " + in.available() + " bytes; limit: " + 0x200000 + " bytes!");
        }
        while (in.available() > 0) {
            n = in.read(buf);
            sb.append(new String(buf, 0, n));
        }
        return sb.toString();
    }

    public void setBitVersion(int pBits) {
        if (pBits == 32 || pBits == 64 || pBits == 128 || pBits == 256) {
            this.mBitVersion = pBits;
        } else {
            System.err.println("Wrong value ('" + pBits + "') to set the bit version.");
            this.mBitVersion = -1;
        }
    }

    public int getBitVersion() {
        if (this.mBitVersion != -1) {
            return this.mBitVersion;
        }
        this.mBitVersion = this.getHardwareSettings("BIT");
        return this.mBitVersion;
    }

    public ArrayList getDeviceList() {
        return this.mDeviceList;
    }

    public int getHardwareSettings(String Parameter) {
        String sDevTool = null;
        String sFileSep = System.getProperty("file.separator");
        int CPU = 0;
        if (Parameter.equals("MAXCPU")) {
            if (this.getHost().equals("localhost")) {
                sDevTool = System.getProperty("env.tool");
                if (sDevTool == null) {
                    this.addProtocol('I', "Environment variable TOOL not defined.");
                    return 1;
                }
                String sCommand = sDevTool + sFileSep + "bin" + sFileSep + "machineInfo";
                StringBuffer ProcessOutput = new StringBuffer();
                Execute SystemProcess = null;
                SystemProcess = new Execute(sCommand, null, ProcessOutput);
                SystemProcess.exec();
                StringTokenizer st = new StringTokenizer(ProcessOutput.toString());
                while (st.hasMoreTokens()) {
                    if (!st.nextToken().equalsIgnoreCase("PROCESSORS:")) continue;
                    CPU = new Integer(st.nextToken().toString());
                    break;
                }
                if (CPU == 0) {
                    this.addProtocol('I', "Could not read number of CPU.");
                } else {
                    this.addProtocol('I', "CPU's for this System: " + CPU);
                }
                if (CPU == 4) {
                    return 3;
                }
                if (CPU > 4) {
                    return CPU - 2;
                }
                return 1;
            }
            return 1;
        }
        if (Parameter.equals("BIT")) {
            if (this.mBitVersion != -1) {
                return this.mBitVersion;
            }
            int result = 0;
            try {
                if (System.getProperty("os.name").substring(0, 3).equalsIgnoreCase("WIN")) {
                    result = 32;
                } else {
                    String sCommand = this.getInstRoot() + sFileSep + "pgm" + sFileSep + "kernel -v";
                    String[] cmdArr = new String[]{"sh", "-c", sCommand};
                    StringBuffer ProcessOutput = new StringBuffer();
                    Execute SystemProcess = null;
                    SystemProcess = new Execute(cmdArr, null, ProcessOutput);
                    SystemProcess.exec();
                    String output = new String(ProcessOutput);
                    if (output.startsWith("32")) {
                        result = 32;
                    }
                    if (output.startsWith("64")) {
                        result = 64;
                    }
                }
            }
            catch (Exception e) {
                this.addProtocol('I', "Could not read, if 32 Bit or 64 Bit.");
                return result;
            }
            return result;
        }
        return 0;
    }

    public String getId() throws TestDatabaseException {
        return this.mSys + this.getKernelVersion();
    }

    public String getIndepDataPath() throws TestDatabaseException {
        String indepDataPath = this.executeDBMcmd("dbm_getpath IndepDataPath");
        if (indepDataPath != null) {
            return indepDataPath.trim();
        }
        return null;
    }

    public String getInitialState() {
        return this.mInitialState;
    }

    public String getInstanceType() throws TestDatabaseException {
        return this.getParameter("INSTANCE_TYPE");
    }

    public String getInstRoot() throws TestDatabaseException {
        if (this.mRoot != null && this.mRoot.length() > 2) {
            return this.mRoot;
        }
        String instroot = null;
        DBM dbm = null;
        try {
            this.addTraceToProtocol("getInstRoot() with host: " + this.mHost + ", port: " + this.mPort + ", name: " + this.mName + ", root: " + this.mRoot);
            dbm = this.mRoot != null && this.getHost().equals("localhost") ? DBM.dbrootDBM((String)(this.mHost + ":" + this.mPort), (String)this.mRoot) : DBM.dbDBM((String)(this.mHost + ":" + this.mPort), (String)this.mName);
            instroot = dbm.cmd("dbm_version INSTROOT").trim();
            if (dbm != null) {
                dbm.release();
            }
        }
        catch (Exception e) {
            throw new TestDatabaseException(e, "Command failed: dbm_version INSTROOT");
        }
        this.mRoot = instroot;
        return instroot;
    }

    public String getDBVersionWithHostAndDBRoot(String dbhost, String dbroot) {
        String version = "unknown";
        String cmdResult = null;
        String tempString = null;
        DBM dbm = null;
        try {
            dbm = DBM.dbrootDBM((String)(dbhost + ":" + this.mPort), (String)dbroot);
            cmdResult = dbm.cmd("inst_enum");
            BufferedReader br = new BufferedReader(new StringReader(cmdResult));
            String line = null;
            while ((line = br.readLine()) != null) {
                int firstPositionOfSpace = line.indexOf(" ");
                if (!line.substring(firstPositionOfSpace).trim().equalsIgnoreCase(dbroot)) continue;
                version = line.substring(0, firstPositionOfSpace).trim();
            }
            String patchedVersion = "";
            StringTokenizer versST = new StringTokenizer(version, ".");
            patchedVersion = patchedVersion + versST.nextToken();
            patchedVersion = patchedVersion + ".";
            patchedVersion = patchedVersion + versST.nextToken();
            while (versST.hasMoreTokens()) {
                patchedVersion = patchedVersion + ".";
                tempString = versST.nextToken();
                if (tempString.length() == 1) {
                    patchedVersion = patchedVersion + "0";
                    patchedVersion = patchedVersion + tempString;
                    continue;
                }
                patchedVersion = patchedVersion + tempString;
            }
            this.addTraceToProtocol("getDbVersionWithHostAndDBRoot(" + dbhost + "," + dbroot + "); convert version: '" + version + "' to '" + patchedVersion + "'");
            version = patchedVersion;
        }
        catch (Exception e) {
            version = "unknown";
        }
        return version;
    }

    String getJdbcTraceOutput() {
        return this.mJdbcTraceOutput;
    }

    public String getCPCVersion() {
        StringBuffer ProcessOutput = new StringBuffer();
        Execute SystemProcess = null;
        String sCommand = null;
        String[] cmdArr = new String[3];
        boolean useCmdArray = false;
        if (System.getProperty("os.name").substring(0, 3).equalsIgnoreCase("WIN")) {
            sCommand = "cpc -V";
        } else {
            useCmdArray = true;
            sCommand = "cpc -V";
            cmdArr[0] = "sh";
            cmdArr[1] = "-c";
            cmdArr[2] = sCommand;
        }
        SystemProcess = !useCmdArray ? new Execute(sCommand, null, ProcessOutput) : new Execute(cmdArr, null, ProcessOutput);
        SystemProcess.exec();
        String resultOfProcess = ProcessOutput.toString();
        if (resultOfProcess.indexOf("found") != -1) {
            resultOfProcess = "not installed";
        }
        if (resultOfProcess.indexOf("IOException") != -1) {
            resultOfProcess = "not installed";
        }
        return resultOfProcess;
    }

    public String getJdbcDriverVersion() {
        try {
            return DriverManager.getConnection(this.mUrl, this.getDBAUser(), this.getDBAPassword()).getMetaData().getDriverVersion();
        }
        catch (SQLException sql) {
            return "unknown";
        }
    }

    public String getKernelBuild() throws TestDatabaseException {
        return this.mKernelBuild;
    }

    public String getKernelMode() {
        return this.mKernelMode;
    }

    public String getKernelVersion() throws TestDatabaseException {
        return this.getKernelVersion(false);
    }

    public String getKernelVersion(boolean forceReading) throws TestDatabaseException {
        if (this.mKernelVersion != null && !forceReading) {
            return this.mKernelVersion;
        }
        if (this.isNone()) {
            return "";
        }
        String value = this.getParameter("KERNELVERSION");
        StringTokenizer st = new StringTokenizer(value);
        String kernel = null;
        while (st.hasMoreTokens()) {
            if (!st.nextToken().equals("KERNEL")) continue;
            kernel = st.nextToken();
        }
        if (kernel == null) {
            this.mKernelVersion = null;
        } else {
            String patchedVersion = "";
            String tempString = null;
            StringTokenizer versST = new StringTokenizer(kernel, ".");
            patchedVersion = patchedVersion + versST.nextToken();
            patchedVersion = patchedVersion + ".";
            patchedVersion = patchedVersion + versST.nextToken();
            while (versST.hasMoreTokens()) {
                patchedVersion = patchedVersion + ".";
                tempString = versST.nextToken();
                if (tempString.length() == 1) {
                    patchedVersion = patchedVersion + "0";
                    patchedVersion = patchedVersion + tempString;
                    continue;
                }
                patchedVersion = patchedVersion + tempString;
            }
            this.mKernelVersion = patchedVersion;
        }
        return this.mKernelVersion;
    }

    public String getParameter(String pKey) throws TestDatabaseException {
        return this.executeDBMcmd("param_getvalue " + pKey).trim();
    }

    public String getRunDir() throws TestDatabaseException {
        return this.mRunDir;
    }

    public String getDBRoot() throws TestDatabaseException {
        return this.mRoot;
    }

    public String getState() throws TestDatabaseException {
        String state = null;
        StringTokenizer st = new StringTokenizer(this.dbmCmd("db_state"));
        while (st.hasMoreTokens()) {
            if (!st.nextToken().equalsIgnoreCase("State")) continue;
            state = st.nextToken();
            break;
        }
        return state;
    }

    public String getTraceFileName() throws TestDatabaseException {
        if (!this.isTraced()) {
            return null;
        }
        String traceDir = this.getIndepDataPath();
        return traceDir + System.getProperty("file.separator") + this.getName() + ".prt";
    }

    public String getVersion() throws TestDatabaseException {
        String version = null;
        StringTokenizer st = new StringTokenizer(this.getKernelBuild(), "-");
        if (st.hasMoreTokens()) {
            version = this.getKernelVersion() + '.' + st.nextToken();
        }
        return version;
    }

    public String getSqlMode() throws TestDatabaseException {
        String mode = "INTERNAL";
        String modeProp = null;
        if (this.mJdbcProps != null) {
            modeProp = this.mJdbcProps.getProperty("sqlmode");
        }
        if (modeProp != null) {
            mode = modeProp;
        }
        return mode;
    }

    private boolean isActionTraced() {
        return this.mIsActionTraced;
    }

    public boolean isCold() throws TestDatabaseException {
        return this.getState().equalsIgnoreCase("COLD") || this.getState().equalsIgnoreCase("ADMIN");
    }

    public boolean isCreated() {
        return this.mIsCreated;
    }

    public boolean isDrop() {
        return this.mDrop;
    }

    boolean isForceCreate() {
        return this.mForceCreate;
    }

    public boolean isShort() {
        return this.mIsShort;
    }

    public boolean isFull() throws TestDatabaseException {
        String state = null;
        StringTokenizer st = new StringTokenizer(this.dbmCmdSql("info state"));
        while (st.hasMoreTokens()) {
            if (!st.nextToken().equalsIgnoreCase("Database") || !st.nextToken().equalsIgnoreCase("Full") || !st.nextToken().equalsIgnoreCase("=")) continue;
            state = st.nextToken();
            return !state.equalsIgnoreCase("No");
        }
        return false;
    }

    public boolean isJDBCTraceEnabled() {
        return this.mIsEnabledJdbcTrace;
    }

    public boolean isKeep() {
        return this.mKeep;
    }

    private boolean isLiveCache() throws TestDatabaseException {
        return this.getParameter("INSTANCE_TYPE").equals("LVC");
    }

    public boolean isOffline() throws TestDatabaseException {
        return this.getState().equalsIgnoreCase("OFFLINE");
    }

    public boolean isOLTPTraceEnabled() {
        return this.mOLTPTraceEnabled;
    }

    public boolean isOMSTraceEnabled() {
        return this.mOMSTraceEnabled;
    }

    boolean isTraced() {
        return this.mOLTPTraceEnabled || this.mOMSTraceEnabled || this.mAdditionalTrace != null;
    }

    public boolean isWarm() throws TestDatabaseException {
        String currentDBState = this.getState();
        return currentDBState.equalsIgnoreCase("WARM") || currentDBState.equalsIgnoreCase("ONLINE");
    }

    public boolean isHSS() {
        return this.mIsHSS;
    }

    public void offline() throws TestDatabaseException {
        this.dbmCmd("db_offline");
    }

    private boolean register() throws TestDatabaseException {
        String dbmUser = this.mDBMUser + "," + this.mDBMPassword;
        String osUser = this.mOsUser + "," + this.mOsPassword;
        String currentCmd = null;
        boolean isCreated = false;
        StringBuffer ProcessOutput = new StringBuffer();
        if (this.mConfiguration != null && this.mConfiguration.get("OFFICIAL_NODE") != null && this.mConfiguration.get("OFFICIAL_NODE").toString().length() != 0) {
            this.mIsHSS = true;
        }
        this.addTraceToProtocol("register() with host: " + this.mHost + ", port: " + this.mPort + ", name: " + this.mName + ", root: " + this.mRoot);
        if (this.getHost().equals("localhost")) {
            String osVersion = TestDriver.getOpSystem().substring(0, 3);
            if (TestDriver.isDevelopmentInstallation()) {
                osVersion = TestDriver.getOpSystem().substring(0, 3);
                currentCmd = osVersion.equalsIgnoreCase("WIN") ? (this.mIsHSS ? this.getInstRoot() + File.separator + "pgm" + File.separator + "dbmcli.exe -s -R \"" + this.getInstRoot() + "\" db_create -u " + this.mName + " " + dbmUser + " " + osUser : this.getInstRoot() + File.separator + "pgm" + File.separator + "dbmcli.exe -s -R \"" + this.getInstRoot() + "\" db_create " + this.mName + " " + dbmUser) : this.getInstRoot() + File.separator + "bin" + File.separator + "dbmcli -s -R " + this.getInstRoot() + " db_create " + this.mName + " " + dbmUser;
                this.addTraceToProtocol("Trying system call: " + currentCmd + " ...");
                ProcessOutput = new StringBuffer();
                Execute DbmcliProcess = new Execute(currentCmd, new String[]{"SAPDB_NO_INDEPPATH=y"}, ProcessOutput);
                DbmcliProcess.exec();
                if (DbmcliProcess.getExitValue() == 0) {
                    isCreated = true;
                } else {
                    if (ProcessOutput.toString().indexOf("Service database has been locked by another process") != -1) {
                        this.addProtocol('W', "Creating database " + this.getName() + " with command:\n " + currentCmd + " \nfailed! DBMCLI output: \n" + ProcessOutput.toString() + "\nexit value: " + DbmcliProcess.getExitValue() + "\n try it in 15 sec again.");
                        try {
                            Thread.sleep(15000L);
                        }
                        catch (InterruptedException ie) {
                            // empty catch block
                        }
                        ProcessOutput = new StringBuffer();
                        DbmcliProcess = new Execute(currentCmd, new String[]{"SAPDB_NO_INDEPPATH=y"}, ProcessOutput);
                        DbmcliProcess.exec();
                        if (DbmcliProcess.getExitValue() == 0) {
                            isCreated = true;
                            return isCreated;
                        }
                    }
                    isCreated = false;
                    if (currentCmd.endsWith(this.mOsPassword)) {
                        String patchedPassword = "," + this.mOsPassword.replaceAll(".", "*");
                        currentCmd.replaceAll("," + this.mOsPassword, patchedPassword);
                    }
                    this.addProtocol('I', "Creating database " + this.getName() + " with command:\n " + currentCmd + " \nfailed! DBMCLI output: \n" + ProcessOutput.toString() + "\nexit value: " + DbmcliProcess.getExitValue());
                    this.kernelBinaryMissing = this.checkForKernelBinaryMissingError(ProcessOutput.toString());
                }
            } else {
                Execute DbmcliProcess;
                boolean useCMDArray = false;
                String[] cmdArr = new String[3];
                if (System.getProperty("os.name").substring(0, 3).equalsIgnoreCase("WIN")) {
                    currentCmd = this.mIsHSS ? "dbmcli -R \"" + this.getInstRoot() + "\" db_create -u " + this.mName + " " + dbmUser + " " + osUser : "dbmcli -R \"" + this.getInstRoot() + "\" db_create " + this.mName + " " + dbmUser;
                } else if (new File(this.getInstRoot() + File.separator + "bin" + File.separator + "dbmcli").exists()) {
                    this.addTraceToProtocol("Found dbmcli in: " + this.getInstRoot() + File.separator + "bin \nand use this one for database creation.");
                    currentCmd = this.getInstRoot() + File.separator + "bin" + File.separator + "dbmcli -s -R " + this.getInstRoot() + " db_create " + this.mName + " " + dbmUser;
                    useCMDArray = true;
                } else {
                    currentCmd = "dbmcli -R " + this.getInstRoot() + " db_create " + this.mName + " " + dbmUser;
                    useCMDArray = true;
                }
                ProcessOutput = new StringBuffer();
                if (useCMDArray) {
                    cmdArr[0] = "sh";
                    cmdArr[1] = "-c";
                    cmdArr[2] = currentCmd;
                    this.addTraceToProtocol("Trying system call: " + cmdArr[0] + " " + cmdArr[1] + " " + cmdArr[2] + " " + " ...");
                    DbmcliProcess = new Execute(cmdArr, null, ProcessOutput);
                } else {
                    this.addTraceToProtocol("Trying system call: " + currentCmd + " ...");
                    DbmcliProcess = new Execute(currentCmd, null, ProcessOutput);
                }
                DbmcliProcess.exec();
                if (DbmcliProcess.getExitValue() == 0) {
                    isCreated = true;
                } else {
                    isCreated = false;
                    if (useCMDArray) {
                        if (cmdArr[2].endsWith(this.mOsPassword)) {
                            String patchedPassword = "," + this.mOsPassword.replaceAll(".", "*");
                            cmdArr[2].replaceAll("," + this.mOsPassword, patchedPassword);
                        }
                        this.addProtocol('I', "Creating database " + this.getName() + " with command:\n " + cmdArr[0] + " " + cmdArr[1] + " " + cmdArr[2] + " " + " \nfailed! DBMCLI output: \n" + ProcessOutput.toString() + "\nexit value: " + DbmcliProcess.getExitValue());
                    } else {
                        if (currentCmd.endsWith(this.mOsPassword)) {
                            String patchedPassword = "," + this.mOsPassword.replaceAll(".", "*");
                            currentCmd.replaceAll("," + this.mOsPassword, patchedPassword);
                        }
                        this.addProtocol('I', "Creating database " + this.getName() + " with command:\n " + currentCmd + " \nfailed! DBMCLI output: \n" + ProcessOutput.toString() + "\nexit value: " + DbmcliProcess.getExitValue());
                    }
                    this.kernelBinaryMissing = this.checkForKernelBinaryMissingError(ProcessOutput.toString());
                }
            }
        } else {
            if (this.mIsHSS) {
                currentCmd = "db_create -u " + this.mName + " " + dbmUser + " " + osUser;
                this.addTraceToProtocol("Trying db_create -u " + this.mName + " " + dbmUser + " " + osUser + " ...");
            } else {
                currentCmd = "db_create " + this.mName + " " + dbmUser + " " + osUser;
                this.addTraceToProtocol("Trying db_create " + this.mName + " " + dbmUser + " " + osUser + " ...");
            }
            try {
                this.mDBMan = DBM.dbrootDBM((String)(this.mHost + ":" + this.mPort), (String)this.mRoot);
                this.mDBMan.cmd(currentCmd);
                isCreated = true;
                this.mDBMan.release();
                this.mDBMan = null;
            }
            catch (Exception e) {
                isCreated = false;
                try {
                    if (this.mDBMan != null) {
                        this.mDBMan.release();
                    }
                }
                catch (RTEException rtexc) {
                    // empty catch block
                }
                this.mDBMan = null;
                if (e.getLocalizedMessage().indexOf("Connection down, session released") != -1) {
                    this.addProtocol('W', "Cannot connect to host " + this.mHost + " with root: " + this.mRoot + "\nperhaps unknown root\nException: " + e.getLocalizedMessage());
                }
                String patchedPassword = this.mOsPassword.replaceAll(".", "*");
                osUser = osUser.replaceAll(this.mOsPassword, patchedPassword);
                this.addProtocol('W', "Creating database " + this.getName() + " " + e.getClass() + " " + e.getLocalizedMessage() + "\n" + "Host: " + this.mHost + "\nRoot: " + this.mRoot + "\nName: " + this.mName + "\nDBM:  " + dbmUser + "\nOSUser:  " + osUser);
            }
        }
        return isCreated;
    }

    protected boolean checkForKernelBinaryMissingError(String errMsg) {
        if (errMsg.indexOf("The file '") != -1 && errMsg.indexOf("kernel") != -1 && errMsg.indexOf("' was not found") != -1) {
            return true;
        }
        return errMsg.indexOf("kernel program missing") != -1;
    }

    public void restart() throws TestDatabaseException {
        String ActualCommand = "";
        String kernelMode = this.getKernelMode();
        this.addTraceToProtocol("Restarting Database (" + kernelMode + ")");
        if (kernelMode.equalsIgnoreCase("FAST")) {
            ActualCommand = "db_warm -f";
        }
        if (kernelMode.equalsIgnoreCase("SLOW")) {
            ActualCommand = "db_warm -s";
        }
        if (kernelMode.equalsIgnoreCase("TEST")) {
            ActualCommand = "db_warm -t";
        }
        this.dbmCmd(ActualCommand);
        if (this.mIsHSS) {
            System.out.println("TestDatabase--> Restarting Standby");
            this.addTraceToProtocol("Restarting Standby");
            this.dbmCmd("db_standby " + this.getParameter("HS_NODE_002"));
        }
        if (this.mOLTPTraceEnabled) {
            this.enableOLTPTrace();
        }
        if (this.mOMSTraceEnabled) {
            this.enableOMSTrace();
        }
        this.enableAdditionalTrace();
        this.executeDatabaseCommands();
        this.executeDBMServerCommands();
        if (this.getKernelVersion().startsWith("7.2")) {
            this.enableWriteTransactionForLiveCache();
        }
    }

    public void resetInstance() throws TestDatabaseException {
        this.releaseDBMConnection();
        this.addProtocol('I', "Reset database. Entered resetInstance()");
        System.out.println("TestDatabase--> Resetting Database (" + this.mKernelMode + ")");
        String ActualCommand = "";
        try {
            if (TestDriver.compareRelease(this.getKernelVersion(), ">=", "7.4") && this.isWarm()) {
                ActualCommand = "autosave_off";
                this.dbmCmd(ActualCommand);
            }
            ActualCommand = "db_stop";
            this.dbmCmd(ActualCommand);
            ActualCommand = "service_connect";
            this.dbmCmd(ActualCommand);
            ActualCommand = "recover_config RSV";
            this.dbmCmd(ActualCommand);
            ActualCommand = "service_release";
            this.dbmCmd(ActualCommand);
            ActualCommand = "db_cold -" + this.mKernelMode;
            this.dbmCmd(ActualCommand);
            ActualCommand = "util_connect";
            this.dbmCmd(ActualCommand);
            if (TestDriver.compareRelease(this.getKernelVersion() + "." + this.getKernelBuild().substring(0, 3), ">=", "7.4.4.1")) {
                ActualCommand = "db_activate RECOVER RSV DATA";
                this.dbmCmd(ActualCommand);
            } else {
                ActualCommand = "util_execute INIT CONFIG";
                this.dbmCmd(ActualCommand);
                ActualCommand = "backup_restore RSV DATA";
                this.dbmCmd(ActualCommand);
            }
            ActualCommand = "db_warm -" + this.mKernelMode;
            this.restart();
            ActualCommand = "util_connect";
            this.dbmCmd(ActualCommand);
            ActualCommand = "backup_save IND MIGRATION DATA";
            this.dbmCmd(ActualCommand);
            if (TestDriver.compareRelease(this.getKernelVersion(), ">=", "7.4")) {
                ActualCommand = "autosave_on";
                this.dbmCmd(ActualCommand);
            }
            ActualCommand = "util_release";
            this.dbmCmd(ActualCommand);
        }
        catch (Exception e) {
            if (ActualCommand.equalsIgnoreCase("db_stop") && System.getProperty("os.name").equalsIgnoreCase("hp-ux")) {
                String[] cmdArr = new String[3];
                StringBuffer ProcessOutput = new StringBuffer();
                int counter = 0;
                do {
                    ++counter;
                    ProcessOutput = new StringBuffer();
                    cmdArr[0] = "sh";
                    cmdArr[1] = "-c";
                    cmdArr[2] = "ps -aef | grep " + this.getName();
                    ProcessOutput.append("Trying system call: '" + cmdArr[0] + " " + cmdArr[1] + " " + cmdArr[2] + "' ...\n");
                    Execute PsProcess = new Execute(cmdArr, null, ProcessOutput);
                    PsProcess.exec();
                    ProcessOutput.append("\nand now uptime ...\n");
                    cmdArr[0] = "sh";
                    cmdArr[1] = "-c";
                    cmdArr[2] = "uptime";
                    PsProcess = new Execute(cmdArr, null, ProcessOutput);
                    PsProcess.exec();
                    this.addProtocol('T', counter + ". system call output:\n" + ProcessOutput.toString());
                    if (PsProcess.getExitValue() != 0) {
                        counter = -1;
                    }
                    try {
                        Thread.sleep(120000L);
                    }
                    catch (InterruptedException intEx) {
                        // empty catch block
                    }
                } while (counter <= 120 && counter != -1);
            }
            throw new TestDatabaseException(e, "Could not execute command: " + ActualCommand + " in resetInstance()");
        }
        finally {
            try {
                this.mDBMan.cmd("util_release");
            }
            catch (Exception e) {}
        }
    }

    public void restoreInstance() throws TestDatabaseException {
        this.releaseDBMConnection();
        this.addProtocol('I', "Restore database. Entered restoreInstance()");
        System.out.println("TestDatabase--> Restarting Database (" + this.mKernelMode + ")");
        String ActualCommand = "";
        try {
            if (TestDriver.compareRelease(this.getKernelVersion(), ">=", "7.4")) {
                if (this.isWarm()) {
                    ActualCommand = "autosave_off";
                    this.dbmCmd(ActualCommand);
                }
                ActualCommand = "db_stop";
                this.dbmCmd(ActualCommand);
                ActualCommand = "db_clear";
                this.dbmCmd(ActualCommand);
                ActualCommand = "db_cold -" + this.mKernelMode;
                this.dbmCmd(ActualCommand);
                ActualCommand = "util_connect";
                this.dbmCmd(ActualCommand);
                if (TestDriver.compareRelease(this.getKernelVersion() + "." + this.getKernelBuild().substring(0, 3), ">=", "7.4.4.1")) {
                    ActualCommand = "db_activate RECOVER IND DATA";
                    this.dbmCmd(ActualCommand);
                } else {
                    ActualCommand = "util_execute INIT CONFIG";
                    this.dbmCmd(ActualCommand);
                    ActualCommand = "backup_restore IND DATA";
                    this.dbmCmd(ActualCommand);
                }
                ActualCommand = "util_release";
                this.dbmCmd(ActualCommand);
                ActualCommand = "db_warm -" + this.mKernelMode;
                this.restart();
                ActualCommand = "util_connect";
                this.dbmCmd(ActualCommand);
                ActualCommand = "backup_save IND MIGRATION DATA";
                this.dbmCmd(ActualCommand);
                ActualCommand = "autosave_on";
                this.dbmCmd(ActualCommand);
                ActualCommand = "util_release";
                this.dbmCmd(ActualCommand);
            } else {
                ActualCommand = "db_stop";
                this.dbmCmd(ActualCommand);
                ActualCommand = "db_clear";
                this.dbmCmd(ActualCommand);
                ActualCommand = "db_cold -" + this.mKernelMode;
                this.dbmCmd(ActualCommand);
                ActualCommand = "util_connect";
                this.dbmCmd(ActualCommand);
                ActualCommand = "util_execute INIT CONFIG";
                this.dbmCmd(ActualCommand);
                ActualCommand = "backup_restore IND DATA";
                this.dbmCmd(ActualCommand);
                ActualCommand = "util_release";
                this.dbmCmd(ActualCommand);
                ActualCommand = "db_warm -" + this.mKernelMode;
                this.restart();
            }
        }
        catch (Exception e) {
            if (ActualCommand.equalsIgnoreCase("autosave_off")) {
                e.printStackTrace();
            }
            if (ActualCommand.equalsIgnoreCase("db_stop") && System.getProperty("os.name").equalsIgnoreCase("hp-ux")) {
                String[] cmdArr = new String[3];
                StringBuffer ProcessOutput = new StringBuffer();
                int counter = 0;
                do {
                    ++counter;
                    ProcessOutput = new StringBuffer();
                    cmdArr[0] = "sh";
                    cmdArr[1] = "-c";
                    cmdArr[2] = "ps -aef | grep " + this.getName();
                    ProcessOutput.append("Trying system call: '" + cmdArr[0] + " " + cmdArr[1] + " " + cmdArr[2] + "' ...\n");
                    Execute PsProcess = new Execute(cmdArr, null, ProcessOutput);
                    PsProcess.exec();
                    ProcessOutput.append("\nand now uptime ...\n");
                    cmdArr[0] = "sh";
                    cmdArr[1] = "-c";
                    cmdArr[2] = "uptime";
                    PsProcess = new Execute(cmdArr, null, ProcessOutput);
                    PsProcess.exec();
                    this.addProtocol('T', counter + ". system call output:\n" + ProcessOutput.toString());
                    if (PsProcess.getExitValue() != 0) {
                        counter = -1;
                    }
                    try {
                        Thread.sleep(120000L);
                    }
                    catch (InterruptedException intEx) {
                        // empty catch block
                    }
                } while (counter <= 120 && counter != -1);
            }
            throw new TestDatabaseException(e, "Could not execute command: " + ActualCommand + " in restoreInstance()");
        }
        finally {
            try {
                this.mDBMan.cmd("util_release");
            }
            catch (Exception e) {}
        }
    }

    public void setConfiguration(HashMap pConfiguration) {
        this.mConfiguration = pConfiguration;
    }

    void setDisableDatabaseRestart(boolean newValue) {
        this.mDisableDatabaseRestart = newValue;
    }

    public void setDeviceList(ArrayList newDeviceList) {
        this.mDeviceList = newDeviceList;
    }

    public void setDrop(boolean newDrop) {
        this.mDrop = newDrop;
    }

    public void setForceCreate(boolean newForceCreate) {
        this.mForceCreate = newForceCreate;
    }

    public void setHostName(String newName) {
        this.mHostName = newName;
    }

    public String getHostName() {
        return this.mHostName;
    }

    public void setHost(String pNewHost) {
        this.mHost = pNewHost;
        this.mUrl = "jdbc:sapdb://" + this.mHost + ":" + this.mPort + "/" + this.mName;
        try {
            if (this.mDBMan != null) {
                this.mDBMan.release();
            }
        }
        catch (RTEException rte) {
            this.addTraceToProtocol("mDBMan.release(); in setHost(" + pNewHost + ") returns: " + rte.getMessage());
        }
        this.mDBMan = null;
    }

    void setInitialState(String newInitialState) {
        this.mInitialState = newInitialState;
    }

    public void setInstanceType(String pInstanceType) {
        this.mInstanceType = pInstanceType;
    }

    public void setIsActionTraced(boolean newIsActionTraced) {
        this.mIsActionTraced = newIsActionTraced;
    }

    public void setJdbcTraceOutput(String pPath) {
        this.mJdbcTraceOutput = pPath + System.getProperty("file.separator") + "jdbcTrace.prt";
    }

    public void setJdbcProperty(Properties pProps) {
        this.mJdbcProps = pProps;
    }

    public void setKeep(boolean newKeep) {
        this.mKeep = newKeep;
    }

    public void setKeepState(String newKeepState) {
        this.mKeepState = newKeepState;
    }

    public String getKeepState() {
        return this.mKeepState;
    }

    void setIsShort(boolean newShort) {
        this.mIsShort = newShort;
    }

    void setKernelBuild() throws TestDatabaseException {
        String value = this.getParameter("KERNELVERSION");
        StringTokenizer st = new StringTokenizer(value);
        String build = null;
        while (st.hasMoreTokens()) {
            if (!st.nextToken().equals("BUILD")) continue;
            build = st.nextToken();
        }
        this.mKernelBuild = build;
    }

    public void setKernelMode(String pKernelMode) {
        this.mKernelMode = pKernelMode;
    }

    void setKernelVersion() throws TestDatabaseException {
        String value = this.getParameter("KERNELVERSION");
        StringTokenizer st = new StringTokenizer(value);
        String kernel = null;
        while (st.hasMoreTokens()) {
            if (!st.nextToken().equals("KERNEL")) continue;
            kernel = st.nextToken();
        }
        this.mKernelVersion = kernel;
        try {
            String patchedVersion = "";
            String tempString = null;
            StringTokenizer versST = new StringTokenizer(kernel, ".");
            patchedVersion = patchedVersion + versST.nextToken();
            patchedVersion = patchedVersion + ".";
            patchedVersion = patchedVersion + versST.nextToken();
            while (versST.hasMoreTokens()) {
                patchedVersion = patchedVersion + ".";
                tempString = versST.nextToken();
                if (tempString.length() == 1) {
                    patchedVersion = patchedVersion + "0";
                    patchedVersion = patchedVersion + tempString;
                    continue;
                }
                patchedVersion = patchedVersion + tempString;
            }
            this.mKernelVersion = patchedVersion;
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void setOLTPTraceEnabled(boolean newOLTPTraceEnabled) {
        this.mOLTPTraceEnabled = newOLTPTraceEnabled;
    }

    public void setOMSTraceEnabled(boolean newOMSTraceEnabled) {
        this.mOMSTraceEnabled = newOMSTraceEnabled;
    }

    public void setAdditionalTrace(String pAddTrace) {
        this.mAdditionalTrace = pAddTrace;
    }

    public void setDatabaseCommands(Vector pCommands) {
        this.mDatabaseCommands = pCommands;
    }

    public void setDbmServerCommands(Vector pCommands) {
        this.mDBMsrvCommands = pCommands;
    }

    public void setOsPassword(String pOsPassword) {
        this.mOsPassword = pOsPassword;
    }

    public void setOsUser(String pOsUser) {
        this.mOsUser = pOsUser;
    }

    public void setParameter(String pKey, String pValue) throws TestDatabaseException {
        this.dbmCmd("db_cold");
        if (!this.isCold()) {
            throw new TestDatabaseException("Error in setting database parameter: Database is not cold");
        }
        this.dbmCmd("param_startsession");
        this.dbmCmd("param_put " + pKey + " " + pValue);
        this.dbmCmd("param_checkall");
        this.dbmCmd("param_commitsession");
        this.dbmCmd("db_offline");
        if (this.mKernelMode.equalsIgnoreCase("FAST")) {
            this.dbmCmd("db_warm -f");
        }
        if (this.mKernelMode.equalsIgnoreCase("SLOW")) {
            this.dbmCmd("db_warm -s");
        }
        if (this.mKernelMode.equalsIgnoreCase("TEST")) {
            this.dbmCmd("db_warm -t");
        }
    }

    public void setParameters(Properties pParams) throws TestDatabaseException {
        this.dbmCmd("db_cold");
        if (!this.isCold()) {
            throw new TestDatabaseException("Error in setting database parameters: Database is not cold");
        }
        this.dbmCmd("param_startsession");
        String key = null;
        Enumeration<?> e = pParams.propertyNames();
        while (e.hasMoreElements()) {
            key = e.nextElement().toString();
            this.dbmCmd("param_put " + key + " " + pParams.getProperty(key));
        }
        this.dbmCmd("param_checkall");
        this.dbmCmd("param_commitsession");
        if (!this.isShort()) {
            this.dbmCmd("util_connect");
            this.dbmCmd("backup_save RSV MIGRATION DATA");
            this.dbmCmd("util_release");
        }
        this.dbmCmd("db_offline");
        if (this.mKernelMode.equalsIgnoreCase("FAST")) {
            this.dbmCmd("db_warm -f");
        }
        if (this.mKernelMode.equalsIgnoreCase("SLOW")) {
            this.dbmCmd("db_warm -s");
        }
        if (this.mKernelMode.equalsIgnoreCase("TEST")) {
            this.dbmCmd("db_warm -t");
        }
    }

    public void setProtocol(TestDriverProtocol pProtocol) {
        this.mProtocol = pProtocol;
    }

    public void setRoot(String pRoot) {
        this.mRoot = pRoot;
    }

    void setRunDir() throws TestDatabaseException {
        String value = this.getParameter("RUNDIRECTORY");
        this.mRunDir = value.trim();
    }

    public void setSize(String pSize) {
        this.mSize = pSize;
    }

    public void releaseDBMConnection() {
        try {
            if (this.mDBMan != null) {
                this.mDBMan.release();
                this.mDBMan = null;
            }
        }
        catch (Exception e) {
            this.mDBMan = null;
        }
    }

    public void setPort(int pNewPort) {
        this.mPort = pNewPort;
        this.mUrl = "jdbc:sapdb://" + this.mHost + ":" + this.mPort + "/" + this.mName;
    }

    public boolean start() throws TestDatabaseException {
        if (this.mKernelMode == null) {
            this.mKernelMode = "fast";
        }
        if (this.mRegisteredDatabases == null) {
            this.mRegisteredDatabases = new RegisteredDatabases();
        }
        if (!this.mKernelMode.equalsIgnoreCase(this.mRegisteredDatabases.getActiveKernelMode()) && !this.mDisableDatabaseRestart) {
            this.offline();
        }
        if (this.getKernelBuild() == null) {
            this.setKernelBuild();
        }
        if (TestDriver.compareRelease("7.4.4.1", ">", this.getKernelVersion() + "." + this.getKernelBuild().substring(0, 3))) {
            if (!this.mRegisteredDatabases.isRegistered("FAST")) {
                try {
                    this.mRegisteredDatabases.register("FAST");
                }
                catch (TestDatabaseException tbe) {
                    this.addProtocol('I', "Can not register FAST kernel. " + tbe.getLocalizedMessage());
                }
            }
            if (!this.mRegisteredDatabases.isRegistered("SLOW")) {
                try {
                    this.mRegisteredDatabases.register("SLOW");
                }
                catch (TestDatabaseException tbe) {
                    this.addProtocol('I', "Can not register SLOW kernel. " + tbe.getLocalizedMessage());
                }
            }
            if (!this.mRegisteredDatabases.isRegistered("TEST")) {
                try {
                    this.mRegisteredDatabases.register("TEST");
                }
                catch (TestDatabaseException tbe) {
                    this.addProtocol('I', "Can not register TEST kernel. " + tbe.getLocalizedMessage());
                }
            }
            if (!this.mRegisteredDatabases.isRegistered(this.mKernelMode)) {
                this.mRegisteredDatabases.register(this.mKernelMode);
            }
        } else {
            try {
                this.mRegisteredDatabases.register();
            }
            catch (TestDatabaseException tbe) {
                this.addProtocol('I', "Can not execute: db_register \nget: " + tbe.getLocalizedMessage());
            }
        }
        if (!this.mDisableDatabaseRestart || !this.isWarm()) {
            this.restart();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    void startXServer() throws TestDatabaseException {
        block13: {
            String indepProgPath;
            block11: {
                block12: {
                    if (!TestDriver.isDevelopmentInstallation()) break block12;
                    String currentCmd = this.mRoot + File.separator + "bin" + File.separator + "x_server start";
                    Execute XServerProcess = new Execute(currentCmd, new String[]{"SAPDB_NO_INDEPPATH=y"});
                    XServerProcess.exec();
                    break block13;
                }
                String dbmCmd = "dbm_getpath IndepProgPath";
                indepProgPath = null;
                DBM dbm = null;
                dbm = DBM.dbrootDBM((String)(this.mHost + ":" + this.mPort), (String)this.mRoot);
                String result = dbm.cmd("dbm_getpath IndepProgPath");
                indepProgPath = result.substring(0, result.indexOf(10));
                Object var6_8 = null;
                try {
                    if (dbm != null) {
                        dbm.release();
                    }
                    break block11;
                }
                catch (Exception ex) {}
                break block11;
                {
                    catch (Exception e) {
                        this.addProtocol('W', "Retrieving 'IndepProgPath' via 'dbm_getpath' failed: " + e.getMessage());
                        Object var6_9 = null;
                        try {
                            if (dbm != null) {
                                dbm.release();
                            }
                            break block11;
                        }
                        catch (Exception ex) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var6_10 = null;
                    try {
                        if (dbm != null) {
                            dbm.release();
                        }
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            String currentCmd = indepProgPath + File.separator + "bin" + File.separator + "x_server start";
            Execute XServerProcess = new Execute(currentCmd, null);
            XServerProcess.exec();
        }
    }

    public void stop() throws TestDatabaseException {
        this.dbmCmd("db_stop");
    }

    public void switchState(String pState) throws TestDatabaseException {
        if (pState == null) {
            return;
        }
        if (this.getState().equalsIgnoreCase(pState)) {
            return;
        }
        if (pState.equalsIgnoreCase("WARM")) {
            this.dbmCmd("db_warm -" + this.mKernelMode);
        } else if (pState.equalsIgnoreCase("COLD")) {
            this.dbmCmd("db_cold -" + this.mKernelMode);
        } else if (pState.equalsIgnoreCase("OFFLINE")) {
            this.dbmCmd("db_offline");
        } else if (pState.equalsIgnoreCase("ADMIN")) {
            this.dbmCmd("db_admin -" + this.mKernelMode);
        } else if (pState.equalsIgnoreCase("ONLINE")) {
            this.dbmCmd("db_online -" + this.mKernelMode);
        }
    }

    static /* synthetic */ String access$100(TestDatabaseSap x0, String x1) throws TestDatabaseException {
        return x0.dbmCmd(x1);
    }

    static /* synthetic */ DBM access$200(TestDatabaseSap x0) {
        return x0.mDBMan;
    }

    static /* synthetic */ DBM access$202(TestDatabaseSap x0, DBM x1) {
        x0.mDBMan = x1;
        return x0.mDBMan;
    }

    class RegisteredDatabases {
        private Properties mRegisteredDatabasesList = null;

        RegisteredDatabases() throws TestDatabaseException {
            TestDatabaseSap.this.addTraceToProtocol("Determine registered databases ...");
            this.getRegisteredDatabasesList();
        }

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void getRegisteredDatabasesList() throws TestDatabaseException {
            try {
                block21: {
                    block20: {
                        if (this.mRegisteredDatabasesList == null) break block20;
                        var11_1 = null;
                        ** GOTO lbl65
                    }
                    dbenum = TestDatabaseSap.access$100(TestDatabaseSap.this, "db_enum");
                    st1 = new StringTokenizer(dbenum, "\n");
                    if (st1.countTokens() != 0) break block21;
                    ** GOTO lbl75
                }
                this.mRegisteredDatabasesList = new Properties();
                while (st1.hasMoreTokens()) {
                    currentLine = st1.nextToken();
                    st2 = new StringTokenizer(currentLine);
                    counter = 0;
                    AttributeList = null;
                    Attributes = new Attributes();
                    block17: while (st2.hasMoreTokens()) {
                        currentItem = st2.nextToken().trim();
                        switch (++counter) {
                            case 1: {
                                name = currentItem.toUpperCase();
                                if (this.mRegisteredDatabasesList.get(name) == null) {
                                    AttributeList = new ArrayList();
                                    this.mRegisteredDatabasesList.put(name, AttributeList);
                                    break;
                                }
                                AttributeList = (ArrayList)this.mRegisteredDatabasesList.get(name);
                                break;
                            }
                            case 2: {
                                Attributes.setRoot(currentItem);
                                break;
                            }
                            case 3: {
                                Attributes.setKernel(currentItem);
                                break;
                            }
                            case 4: {
                                Attributes.setKernelMode(currentItem);
                                break;
                            }
                            case 5: {
                                Attributes.setState(currentItem);
                                continue block17;
                            }
                        }
                    }
                    AttributeList.add(Attributes);
                }
                ** GOTO lbl86
            }
            catch (Exception e) {
                throw new TestDatabaseException(e.getMessage());
            }
            {
                catch (Throwable var10_19) {
                    var11_4 = null;
                    try {
                        if (TestDatabaseSap.access$200(TestDatabaseSap.this) == null) throw var10_19;
                        TestDatabaseSap.access$200(TestDatabaseSap.this).release();
                        TestDatabaseSap.access$202(TestDatabaseSap.this, null);
                        throw var10_19;
                    }
                    catch (Exception e) {
                        TestDatabaseSap.access$202(TestDatabaseSap.this, null);
                    }
                    throw var10_19;
                }
lbl65:
                // 1 sources

                ** try [egrp 2[TRYBLOCK] [7 : 288->320)] { 
lbl66:
                // 1 sources

                if (TestDatabaseSap.access$200(TestDatabaseSap.this) == null) return;
                TestDatabaseSap.access$200(TestDatabaseSap.this).release();
                TestDatabaseSap.access$202(TestDatabaseSap.this, null);
                return;
lbl71:
                // 1 sources

                catch (Exception e) {
                    TestDatabaseSap.access$202(TestDatabaseSap.this, null);
                }
                return;
lbl75:
                // 1 sources

                var11_2 = null;
                ** try [egrp 2[TRYBLOCK] [7 : 288->320)] { 
lbl77:
                // 1 sources

                if (TestDatabaseSap.access$200(TestDatabaseSap.this) == null) return;
                TestDatabaseSap.access$200(TestDatabaseSap.this).release();
                TestDatabaseSap.access$202(TestDatabaseSap.this, null);
                return;
lbl82:
                // 1 sources

                catch (Exception e) {
                    TestDatabaseSap.access$202(TestDatabaseSap.this, null);
                }
                return;
lbl86:
                // 1 sources

                var11_3 = null;
                try {}
                catch (Exception e) {}
                TestDatabaseSap.access$202(TestDatabaseSap.this, null);
                return;
                if (TestDatabaseSap.access$200(TestDatabaseSap.this) == null) return;
                TestDatabaseSap.access$200(TestDatabaseSap.this).release();
                TestDatabaseSap.access$202(TestDatabaseSap.this, null);
                return;
            }
        }

        public void register(String pKernelMode) throws TestDatabaseException {
            String cmd = "db_register -" + pKernelMode.toLowerCase();
            TestDatabaseSap.this.executeDBMcmd(cmd);
            this.getRegisteredDatabasesList();
        }

        public void register() throws TestDatabaseException {
            String cmd = "db_register";
            TestDatabaseSap.this.executeDBMcmd(cmd);
            this.getRegisteredDatabasesList();
        }

        public boolean isRegistered(String pKernelMode) throws TestDatabaseException {
            if (TestDatabaseSap.this.mRegisteredDatabases == null) {
                TestDatabaseSap.this.mRegisteredDatabases = new RegisteredDatabases();
            }
            if (this.mRegisteredDatabasesList.get(TestDatabaseSap.this.mName.toUpperCase()) == null) {
                return false;
            }
            ArrayList attributeList = (ArrayList)this.mRegisteredDatabasesList.get(TestDatabaseSap.this.mName.toUpperCase());
            ListIterator it = attributeList.listIterator();
            boolean isEqual = false;
            while (it.hasNext()) {
                Attributes attribute = (Attributes)it.next();
                String root = attribute.getRoot();
                if (!TestDatabaseSap.this.getInstRoot().equalsIgnoreCase(root) || !this.compareKernel(TestDatabaseSap.this.getKernelVersion(), attribute.getKernel()) || !pKernelMode.equalsIgnoreCase(attribute.getKernelMode())) continue;
                isEqual = true;
                break;
            }
            return isEqual;
        }

        public boolean isRunning(String pKernelMode) throws TestDatabaseException {
            if (TestDatabaseSap.this.mRegisteredDatabases == null) {
                TestDatabaseSap.this.mRegisteredDatabases = new RegisteredDatabases();
            }
            if (this.mRegisteredDatabasesList.get(TestDatabaseSap.this.mName.toUpperCase()) == null) {
                return false;
            }
            ArrayList attributeList = (ArrayList)this.mRegisteredDatabasesList.get(TestDatabaseSap.this.mName.toUpperCase());
            ListIterator it = attributeList.listIterator();
            boolean isRunning = false;
            while (it.hasNext()) {
                Attributes attribute = (Attributes)it.next();
                String root = attribute.getRoot();
                if (!TestDatabaseSap.this.getInstRoot().equalsIgnoreCase(root) || !this.compareKernel(TestDatabaseSap.this.getKernelVersion(), attribute.getKernel()) || !pKernelMode.equalsIgnoreCase(attribute.getKernelMode()) || !attribute.getState().equalsIgnoreCase("Running")) continue;
                isRunning = true;
                break;
            }
            return isRunning;
        }

        public String getActiveKernelMode() throws TestDatabaseException {
            if (TestDatabaseSap.this.mRegisteredDatabases == null) {
                TestDatabaseSap.this.mRegisteredDatabases = new RegisteredDatabases();
            }
            if (this.mRegisteredDatabasesList.get(TestDatabaseSap.this.mName.toUpperCase()) == null) {
                return null;
            }
            ArrayList attributeList = (ArrayList)this.mRegisteredDatabasesList.get(TestDatabaseSap.this.mName.toUpperCase());
            ListIterator it = attributeList.listIterator();
            String kernelMode = null;
            while (it.hasNext()) {
                Attributes attribute = (Attributes)it.next();
                String root = attribute.getRoot();
                if (!TestDatabaseSap.this.getInstRoot().equalsIgnoreCase(root) || !this.compareKernel(TestDatabaseSap.this.getKernelVersion(), attribute.getKernel()) || !attribute.getState().equalsIgnoreCase("Running")) continue;
                kernelMode = attribute.getKernelMode();
                break;
            }
            return kernelMode;
        }

        private boolean compareKernel(String pKernel1, String pKernel2) {
            StringTokenizer st1 = new StringTokenizer(pKernel1, ".");
            StringTokenizer st2 = new StringTokenizer(pKernel2, ".");
            int minCountToken = Math.min(st1.countTokens(), st2.countTokens());
            int counter = 0;
            String s1 = null;
            String s2 = null;
            while (st1.hasMoreTokens() && ++counter <= minCountToken) {
                s1 = s1 + st1.nextToken();
            }
            counter = 0;
            while (st2.hasMoreTokens() && ++counter <= minCountToken) {
                s2 = s2 + st2.nextToken();
            }
            return s1.compareTo(s2) == 0;
        }

        class Attributes {
            String mRoot = "unknown root";
            String mKernel = "unknown kernel version";
            String mKernelMode = "unknown kernel mode";
            String mState = "unknow state";

            Attributes() {
            }

            Attributes(String pRoot, String pKernel, String pKernelMode, String pState) {
                this.mRoot = pRoot;
                this.mKernel = pKernel;
                this.mKernelMode = pKernelMode;
                this.mState = pState;
            }

            void setRoot(String pRoot) {
                this.mRoot = pRoot;
            }

            void setKernel(String pKernel) {
                this.mKernel = pKernel;
            }

            void setKernelMode(String pKernelMode) {
                this.mKernelMode = pKernelMode;
            }

            void setState(String pState) {
                this.mState = pState;
            }

            String getRoot() {
                return this.mRoot;
            }

            String getKernel() {
                return this.mKernel;
            }

            String getKernelMode() {
                return this.mKernelMode;
            }

            String getState() {
                return this.mState;
            }
        }
    }
}

