/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.testframe.driver;

import com.sap.sapdb.testframe.driver.DatabaseConstants;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;

public abstract class TestDatabase
implements DatabaseConstants {
    protected String mSys;
    protected String mName;
    protected String mHost;
    protected int mPort;
    protected String mDriver;
    protected String mUrl;
    protected String mDBMUser;
    protected String mDBMPassword;
    protected String mDBAUser;
    protected String mDBAPassword;

    public TestDatabase() {
    }

    public TestDatabase(String pDriver) throws ClassNotFoundException {
        this();
        Class.forName(pDriver);
    }

    public Connection connect() throws TestDatabaseException {
        Properties conp = new Properties();
        conp.put("user", this.mDBAUser);
        conp.put("password", this.mDBAPassword);
        Connection connection = this.connect(conp);
        return connection;
    }

    public Connection connect(String pUser, String pPassword) throws TestDatabaseException {
        Properties conp = new Properties();
        conp.put("user", pUser);
        conp.put("password", pPassword);
        Connection connection = this.connect(conp);
        return connection;
    }

    public Connection connect(Properties pInfo) throws TestDatabaseException {
        try {
            Connection connection = DriverManager.getConnection(this.mUrl, pInfo);
            return connection;
        }
        catch (SQLException e) {
            throw new TestDatabaseException(e.getMessage());
        }
    }

    public void disconnect() throws TestDatabaseException {
    }

    public void disconnect(Connection pConnection) throws SQLException {
        pConnection.close();
    }

    public String executeDBMcmd(String pCmd) throws TestDatabaseException {
        if (!this.isSap()) {
            new TestDatabaseException("DBM command '" + pCmd + "' not supported for database type " + this.getSys());
        }
        return null;
    }

    public String getDBAPassword() {
        return this.mDBAPassword;
    }

    public String getDBAUser() {
        return this.mDBAUser;
    }

    public String getDBMPassword() {
        return this.mDBMPassword;
    }

    public String getDBMUser() {
        return this.mDBMUser;
    }

    public String getHost() {
        return this.mHost;
    }

    public void setHost(String newHost) {
        this.mHost = newHost;
    }

    public int getPort() {
        return this.mPort;
    }

    public String getId() throws TestDatabaseException {
        return this.mSys;
    }

    public String getName() {
        return this.mName;
    }

    public String getPassword() {
        return this.getDBAPassword();
    }

    public String getSys() {
        return this.mSys;
    }

    public String getUser() {
        return this.getDBAUser();
    }

    public boolean isNone() {
        return this.getSys().endsWith("NONE");
    }

    public boolean isDb2() {
        return this.getSys().endsWith("DB2");
    }

    public boolean isInterbase() {
        return this.getSys().endsWith("ITB");
    }

    public boolean isOracle() {
        return this.getSys().endsWith("ORA");
    }

    public boolean isSap() {
        return this.getSys().equalsIgnoreCase("SAP");
    }

    public boolean isSQLServer() {
        return this.getSys().endsWith("MSS");
    }

    public void restart() throws TestDatabaseException {
    }

    public void setDBAPassword(String pPassword) {
        this.mDBAPassword = pPassword;
    }

    public void setDBAUser(String pUser) {
        this.mDBAUser = pUser;
    }

    public void setDBMPassword(String pPassword) {
        this.mDBMPassword = pPassword;
    }

    public void setDBMUser(String pUser) {
        this.mDBMUser = pUser;
    }

    public void testConnection() throws TestDatabaseException {
        this.testConnection(this.mDBAUser, this.mDBAPassword);
    }

    public void testConnection(String pUser, String pPassword) throws TestDatabaseException {
        Connection con = null;
        try {
            con = DriverManager.getConnection(this.mUrl, pUser, pPassword);
        }
        catch (SQLException e) {
            throw new TestDatabaseException("User <" + pUser + "," + pPassword + "> cannot connect to database <" + this.mHost + ":" + this.mName + ">\n" + e.getLocalizedMessage());
        }
        finally {
            try {
                con.close();
            }
            catch (Exception e) {}
        }
    }
}

