/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.sqltest.parser;

import com.sap.sapdb.sqltest.parser.StatementBean;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;

public class TestCaseBean {
    private String comment = "";
    private int testCaseNumber;
    private String responsible;
    private String excludeProperty = null;
    private ArrayList prepareStatemets = new ArrayList();
    private ArrayList cleanUpStatements = new ArrayList();
    private ArrayList runStatements;

    public String toString() {
        String str = "\nTest case #" + String.valueOf(this.testCaseNumber) + " =>\n";
        str = str + "Comments: " + this.comment + "\n";
        str = str + "Responsible: " + this.responsible + "\n";
        int currentPosition = 1;
        if (!this.prepareStatemets.isEmpty()) {
            str = str + "Prepare statements ( " + currentPosition + ".." + (currentPosition + this.prepareStatemets.size()) + " ):" + this.prepareStatemets + "\n";
            currentPosition += this.prepareStatemets.size();
        }
        if (!this.runStatements.isEmpty()) {
            str = str + "Run statements ( " + currentPosition + ".." + (currentPosition + this.runStatements.size()) + " ):" + this.runStatements + "\n";
            currentPosition += this.runStatements.size();
        }
        if (!this.cleanUpStatements.isEmpty()) {
            str = str + "Clean up statements( " + currentPosition + ".." + (currentPosition + this.cleanUpStatements.size()) + " ):" + this.cleanUpStatements + "\n";
        }
        return str;
    }

    public String statementsToString() {
        StatementBean sb;
        Iterator it;
        String str = "comment for this testcase #" + String.valueOf(this.testCaseNumber) + ": \n\"" + this.comment + "\"\n------\n";
        str = str + "\nTest case #" + String.valueOf(this.testCaseNumber) + " => \n";
        int currentPosition = 1;
        if (!this.prepareStatemets.isEmpty()) {
            it = this.prepareStatemets.iterator();
            str = str + "\nPrepare statements ( " + currentPosition + ".." + (currentPosition + this.prepareStatemets.size() - 1) + " ): \n\n";
            while (it.hasNext()) {
                sb = (StatementBean)it.next();
                if (currentPosition < 10) {
                    str = str + "   " + currentPosition + ".";
                }
                if (currentPosition > 9 && currentPosition < 100) {
                    str = str + "  " + currentPosition + ".";
                }
                if (currentPosition > 99) {
                    str = str + " " + currentPosition + ".";
                }
                if (sb.getUser() != null) {
                    str = str + " [" + sb.getUser() + "]";
                }
                str = str + " " + sb.getCallString() + "\n\n";
                ++currentPosition;
            }
        }
        if (!this.runStatements.isEmpty()) {
            it = this.runStatements.iterator();
            str = str + "\nRun statements ( " + currentPosition + ".." + (currentPosition + this.runStatements.size() - 1) + " ): \n\n";
            while (it.hasNext()) {
                sb = (StatementBean)it.next();
                if (currentPosition < 10) {
                    str = str + "   " + currentPosition + ".";
                }
                if (currentPosition > 9 && currentPosition < 100) {
                    str = str + "  " + currentPosition + ".";
                }
                if (currentPosition > 99) {
                    str = str + " " + currentPosition + ".";
                }
                if (sb.getUser() != null) {
                    str = str + " [" + sb.getUser() + "]";
                }
                str = str + " " + sb.getCallString() + "\n\n";
                ++currentPosition;
            }
        }
        if (!this.cleanUpStatements.isEmpty()) {
            it = this.cleanUpStatements.iterator();
            str = str + "\nCleanUp statements ( " + currentPosition + ".." + (currentPosition + this.cleanUpStatements.size() - 1) + " ): \n\n";
            while (it.hasNext()) {
                sb = (StatementBean)it.next();
                if (currentPosition < 10) {
                    str = str + "   " + currentPosition + ".";
                }
                if (currentPosition > 9 && currentPosition < 100) {
                    str = str + "  " + currentPosition + ".";
                }
                if (currentPosition > 99) {
                    str = str + " " + currentPosition + ".";
                }
                if (sb.getUser() != null) {
                    str = str + " [" + sb.getUser() + "]";
                }
                str = str + " " + sb.getCallString() + "\n\n";
                ++currentPosition;
            }
        }
        return str;
    }

    public void writeXML(PrintStream out, String indent, String startIndent) {
        StatementBean sb;
        Iterator it;
        out.println(startIndent + "<Test Number=\"" + String.valueOf(this.testCaseNumber) + "\" Responsible=\"" + this.responsible + "\">");
        out.println(startIndent + indent + "<Comment>");
        out.println(startIndent + indent + indent + this.comment.trim());
        out.println(startIndent + indent + "</Comment>");
        if (!this.prepareStatemets.isEmpty()) {
            out.println(startIndent + indent + "<Prepare>");
            it = this.prepareStatemets.iterator();
            while (it.hasNext()) {
                sb = (StatementBean)it.next();
                sb.writeXML(out, indent, startIndent + indent + indent);
            }
            out.println(startIndent + indent + "</Prepare>");
        }
        out.println(startIndent + indent + "<Run>");
        it = this.runStatements.iterator();
        while (it.hasNext()) {
            sb = (StatementBean)it.next();
            sb.writeXML(out, indent, startIndent + indent + indent);
        }
        out.println(startIndent + indent + "</Run>");
        if (!this.cleanUpStatements.isEmpty()) {
            out.println(startIndent + indent + "<CleanUp>");
            it = this.cleanUpStatements.iterator();
            while (it.hasNext()) {
                sb = (StatementBean)it.next();
                sb.writeXML(out, indent, startIndent + indent + indent);
            }
            out.println(startIndent + indent + "</CleanUp>");
        }
        out.println(startIndent + "</Test>");
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String newComment) {
        this.comment = newComment;
    }

    public void setPrepareStatemets(ArrayList prepareStatemets) {
        this.prepareStatemets = prepareStatemets;
    }

    public ArrayList getPrepareStatemets() {
        return this.prepareStatemets;
    }

    public void setCleanUpStatements(ArrayList newCleanUpStatements) {
        this.cleanUpStatements = newCleanUpStatements;
    }

    public ArrayList getCleanUpStatements() {
        return this.cleanUpStatements;
    }

    public void setTestCaseNumber(int testCaseNumber) {
        this.testCaseNumber = testCaseNumber;
    }

    public int getTestCaseNumber() {
        return this.testCaseNumber;
    }

    public void setRunStatements(ArrayList runStatements) {
        this.runStatements = runStatements;
    }

    public ArrayList getRunStatements() {
        return this.runStatements;
    }

    public void setResponsible(String responsible) {
        this.responsible = responsible;
    }

    public String getResponsible() {
        return this.responsible;
    }

    public void setExcludeProperty(String exclude) {
        this.excludeProperty = exclude;
    }

    public String getExcludeProperty() {
        return this.excludeProperty;
    }
}

