/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.sqltest.parser;

import com.sap.sapdb.sqltest.parser.ErrorBean;
import com.sap.sapdb.testframe.testcase.VerificationData;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;

public class StatementBean {
    private String callString = "";
    private ArrayList errorBeans = new ArrayList();
    private String listOfExpectedErrorCodes;
    private VerificationData verificationData = null;
    private boolean ignoreErrors = false;
    private boolean verify = false;
    private String verifyOperatorType;
    private String repeatable;
    private String drop;
    private boolean callable = false;
    private Vector parameters = null;
    private String user;

    public String toString() {
        String str = "\nStatement: " + this.callString + "\n";
        str = str + "Verify = " + this.verify + "\n";
        str = str + "Ignore = " + this.ignoreErrors + "\n";
        str = str + "Repeatable = " + this.repeatable + "\n";
        str = str + "User = " + this.user + "\n";
        if (this.verificationData != null) {
            str = str + "ResultSet:\n";
            Iterator it = this.verificationData.iteratorPretty();
            while (it.hasNext()) {
                str = str + it.next() + "\n";
            }
        }
        if (!this.errorBeans.isEmpty()) {
            str = str + "Possible errors: " + this.errorBeans.toString();
        }
        return str;
    }

    public void writeXML(PrintStream out, String indent, String startIndent) {
        Iterator it;
        out.print(startIndent + "<Statement");
        if (this.isVerify()) {
            out.print(" verify=\"true\"");
        }
        if (this.isIgnoreErrors()) {
            out.print(" ignore=\"true\"");
        }
        out.println(">");
        out.println(startIndent + indent + "<CallString>");
        out.println(startIndent + indent + this.callString.trim());
        out.println(startIndent + indent + "</CallString>");
        if (this.verificationData != null) {
            out.println(startIndent + indent + "<ResultSet Verification=\"" + this.verifyOperatorType + "\">");
            it = this.verificationData.iterator();
            boolean isColumnDefinition = true;
            while (it.hasNext()) {
                String s;
                StringTokenizer tokenizer;
                String str = (String)it.next();
                if (isColumnDefinition) {
                    if (str.startsWith("[")) {
                        str = str.substring(1, str.length() - 1);
                        out.println(startIndent + indent + indent + "<ColumnDefinition>");
                        tokenizer = new StringTokenizer(str, ",");
                        while (tokenizer.hasMoreElements()) {
                            s = tokenizer.nextToken();
                            out.println(startIndent + indent + indent + indent + "<ColumnName>" + s.substring(0, s.indexOf(58)) + "</ColumnName>");
                            out.println(startIndent + indent + indent + indent + "<ColumnName>" + s.substring(s.indexOf(58) + 1, s.length()) + "</ColumnName>");
                        }
                        out.println(startIndent + indent + indent + "</ColumnDefinition>");
                    }
                    isColumnDefinition = false;
                }
                if (!str.startsWith("(")) continue;
                str = str.substring(1, str.length() - 1);
                out.println(startIndent + indent + indent + "<Row>");
                tokenizer = new StringTokenizer(str, ",");
                while (tokenizer.hasMoreElements()) {
                    s = tokenizer.nextToken();
                    out.println(startIndent + indent + indent + indent + "<Value>" + s + "</Value>");
                }
                out.println(startIndent + indent + indent + "</Row>");
            }
            out.println(startIndent + indent + "</ResultSet>");
        }
        if (!this.errorBeans.isEmpty()) {
            it = this.errorBeans.iterator();
            while (it.hasNext()) {
                ErrorBean eb = (ErrorBean)it.next();
                eb.writeXML(out, indent, startIndent + indent);
            }
        }
        out.println(startIndent + "</Statement>");
    }

    public boolean checkErrorCodes(int expectedCode) {
        Iterator it = this.errorBeans.iterator();
        while (it.hasNext()) {
            if (((ErrorBean)it.next()).getErrorCode() != expectedCode) continue;
            return true;
        }
        return false;
    }

    public String getCallString() {
        return this.callString;
    }

    public void setCallString(String newCallString) {
        this.callString = newCallString;
    }

    public ArrayList getErrorBeans() {
        return this.errorBeans;
    }

    public void setErrorBeans(ArrayList newErrorBeans) {
        this.errorBeans = newErrorBeans;
    }

    public String getListOfExpectedErrorCodes() {
        Iterator it = this.errorBeans.iterator();
        this.listOfExpectedErrorCodes = "( ";
        while (it.hasNext()) {
            this.listOfExpectedErrorCodes = this.listOfExpectedErrorCodes + String.valueOf(((ErrorBean)it.next()).getErrorCode()) + " ";
        }
        this.listOfExpectedErrorCodes = this.listOfExpectedErrorCodes + ")";
        return this.listOfExpectedErrorCodes;
    }

    public void setVerificationData(VerificationData verificationData) {
        this.verificationData = verificationData;
    }

    public VerificationData getVerificationData() {
        return this.verificationData;
    }

    public void setIgnoreErrors(boolean ignoreErrors) {
        this.ignoreErrors = ignoreErrors;
    }

    public boolean isIgnoreErrors() {
        return this.ignoreErrors;
    }

    public void setVerify(boolean verify) {
        this.verify = verify;
    }

    public boolean isVerify() {
        return this.verify;
    }

    public void setVerifyOperatorType(String verifyOperatorType) {
        this.verifyOperatorType = verifyOperatorType;
    }

    public String getVerifyOperatorType() {
        return this.verifyOperatorType;
    }

    public void setRepeatable(String repeatable) {
        this.repeatable = repeatable;
    }

    public String getRepeatable() {
        return this.repeatable;
    }

    public void setDrop(String drop) {
        this.drop = drop;
    }

    public String getDrop() {
        return this.drop;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getUser() {
        return this.user;
    }

    public void setCallable(boolean callable) {
        this.callable = callable;
    }

    public boolean isCallable() {
        return this.callable;
    }

    public void addParam(Param p) {
        if (this.parameters == null) {
            this.parameters = new Vector();
        }
        this.parameters.addElement(p);
    }

    public Vector getParams() {
        return this.parameters;
    }

    public static class Param {
        public String paramType = null;
        public int dataType = 1111;
        public String inValue = null;
        public String outValue = null;

        public Param(String p, int d, String i, String o) {
            this.paramType = new String(p);
            this.dataType = d;
            this.inValue = i != null ? new String(i) : null;
            this.outValue = o != null ? new String(o) : null;
        }
    }
}

