/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.sqltest.interpreter.unittests;

import com.sap.sapdb.sqltest.interpreter.TestCasesInterpreter;
import com.sap.sapdb.sqltest.parser.ErrorBean;
import com.sap.sapdb.sqltest.parser.StatementBean;
import com.sap.sapdb.sqltest.parser.TestCaseBean;
import com.sap.sapdb.testframe.driver.TestDatabase;
import com.sap.sapdb.testframe.driver.TestDatabaseSap;
import com.sap.sapdb.testframe.driver.TestProtocol;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.VerificationData;
import com.sap.sapdb.testframe.testcase.VerificationDataComplete;
import java.sql.Connection;
import java.util.ArrayList;

public class JUnit_TestCaseInterpreter
extends junit.framework.TestCase {
    TestCasesInterpreter tip;
    Connection con;
    StatementBean st1 = new StatementBean();
    ArrayList el = new ArrayList();
    int i = 0;

    protected void setUp() throws Exception {
        super.setUp();
        this.tip = new TestCasesInterpreter();
        TestDatabaseSap tdb = new TestDatabaseSap("localhost", "sql77");
        TestCase.setDatabase((TestDatabase)tdb);
        TestCasesInterpreter.setProtocol((TestProtocol)new TestProtocol("stedi", "stedi", "stedi"));
        TestCaseBean tcb = new TestCaseBean();
        tcb.setTestCaseNumber(1);
        this.tip.setTestCase(tcb);
        tdb.enableJDBCTrace();
        this.con = tdb.connect();
        this.tip.setConnection(this.con);
        this.st1.setCallString("drop user JunitUser1");
        this.st1.setIgnoreErrors(true);
        this.tip.executeStatement(this.st1);
        this.st1.setIgnoreErrors(false);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.tip = null;
        System.gc();
    }

    public void testCreateConnectWorkDisconnectDropUser() {
        ++this.i;
        this.st1.setCallString("select username from sessions where own='YES'");
        this.st1.setVerificationData((VerificationData)new VerificationDataComplete("('DBA')"));
        JUnit_TestCaseInterpreter.assertTrue((boolean)this.tip.executeStatement(this.st1));
        this.st1.setCallString("create user JunitUser1 password j");
        this.st1.setVerificationData(null);
        JUnit_TestCaseInterpreter.assertTrue((boolean)this.tip.executeStatement(this.st1));
        this.st1.setCallString("connect JunitUser1 identified by j");
        this.st1.setVerificationData(null);
        JUnit_TestCaseInterpreter.assertTrue((boolean)this.tip.executeStatement(this.st1));
        this.st1.setCallString("SELECT username from sessions where own='YES'");
        this.st1.setUser("JunitUser1");
        this.st1.setVerificationData((VerificationData)new VerificationDataComplete("('JUNITUSER1')"));
        JUnit_TestCaseInterpreter.assertTrue((boolean)this.tip.executeStatement(this.st1));
        this.st1.setCallString("rollback release");
        this.st1.setUser("JunitUser1");
        this.st1.setVerificationData(null);
        JUnit_TestCaseInterpreter.assertTrue((boolean)this.tip.executeStatement(this.st1));
        this.st1.setCallString("select username from sessions where own='YES'");
        this.st1.setUser("JunitUser1");
        this.el.clear();
        this.el.add(new ErrorBean(-821, ""));
        this.st1.setErrorBeans(this.el);
        JUnit_TestCaseInterpreter.assertTrue((boolean)this.tip.executeStatement(this.st1));
        this.st1.setCallString("drop user JunitUser1");
        this.st1.setUser(null);
        this.el.clear();
        this.st1.setErrorBeans(this.el);
        boolean b = this.tip.executeStatement(this.st1);
        JUnit_TestCaseInterpreter.assertTrue((boolean)b);
    }

    public void testConnectSingleUserTwiceExclusive() {
        this.st1.setCallString("select username from sessions where own='YES'");
        this.st1.setVerificationData((VerificationData)new VerificationDataComplete("('DBA')"));
        JUnit_TestCaseInterpreter.assertTrue((boolean)this.tip.executeStatement(this.st1));
        this.st1.setCallString("create user JunitUser1 password j exclusive");
        this.st1.setVerificationData(null);
        JUnit_TestCaseInterpreter.assertTrue((boolean)this.tip.executeStatement(this.st1));
        this.st1.setCallString("connect JunitUser1 identified by j");
        this.st1.setVerificationData(null);
        JUnit_TestCaseInterpreter.assertTrue((boolean)this.tip.executeStatement(this.st1));
        this.st1.setCallString("connect JunitUser1 identified by j");
        this.st1.setVerificationData(null);
        this.el.clear();
        this.el.add(new ErrorBean(-8022, ""));
        this.st1.setErrorBeans(this.el);
        JUnit_TestCaseInterpreter.assertTrue((boolean)this.tip.executeStatement(this.st1));
        this.el.clear();
        this.st1.setErrorBeans(this.el);
        this.st1.setCallString("select username from sessions where own='YES'");
        this.st1.setUser("JunitUser1");
        this.st1.setVerificationData((VerificationData)new VerificationDataComplete("('JUNITUSER1')"));
        JUnit_TestCaseInterpreter.assertTrue((boolean)this.tip.executeStatement(this.st1));
        this.st1.setCallString("rollback release");
        this.st1.setUser("JunitUser1");
        this.st1.setVerificationData(null);
        JUnit_TestCaseInterpreter.assertTrue((boolean)this.tip.executeStatement(this.st1));
        this.st1.setCallString("drop user JunitUser1");
        this.st1.setUser(null);
        this.el.clear();
        this.st1.setErrorBeans(this.el);
        boolean b = this.tip.executeStatement(this.st1);
        JUnit_TestCaseInterpreter.assertTrue((boolean)b);
        if (!b) {
            System.exit(1);
        }
    }

    public void testConnectSingleUserTwiceNotExclusive() {
        this.st1.setCallString("select username from sessions where own='YES'");
        this.st1.setVerificationData((VerificationData)new VerificationDataComplete("('DBA')"));
        JUnit_TestCaseInterpreter.assertTrue((boolean)this.tip.executeStatement(this.st1));
        this.st1.setCallString("create user JunitUser1 password j not exclusive");
        this.st1.setVerificationData(null);
        JUnit_TestCaseInterpreter.assertTrue((boolean)this.tip.executeStatement(this.st1));
        this.st1.setCallString("connect JunitUser1 identified by j");
        this.st1.setVerificationData(null);
        JUnit_TestCaseInterpreter.assertTrue((boolean)this.tip.executeStatement(this.st1));
        JUnit_TestCaseInterpreter.assertTrue((boolean)this.tip.executeStatement(this.st1));
        this.st1.setCallString("select username from sessions where own='YES'");
        this.st1.setUser("JunitUser1");
        this.st1.setVerificationData((VerificationData)new VerificationDataComplete("('JUNITUSER1')"));
        JUnit_TestCaseInterpreter.assertTrue((boolean)this.tip.executeStatement(this.st1));
        this.st1.setUser("JunitUser1#1");
        JUnit_TestCaseInterpreter.assertTrue((boolean)this.tip.executeStatement(this.st1));
        this.st1.setUser("JunitUser1#2");
        JUnit_TestCaseInterpreter.assertTrue((boolean)this.tip.executeStatement(this.st1));
        this.st1.setCallString("rollback release");
        this.st1.setUser("JunitUser1");
        this.st1.setVerificationData(null);
        JUnit_TestCaseInterpreter.assertTrue((boolean)this.tip.executeStatement(this.st1));
        this.st1.setUser("JunitUser1#2");
        JUnit_TestCaseInterpreter.assertTrue((boolean)this.tip.executeStatement(this.st1));
        this.st1.setCallString("drop user JunitUser1");
        this.st1.setUser(null);
        this.el.clear();
        this.st1.setErrorBeans(this.el);
        boolean b = this.tip.executeStatement(this.st1);
        JUnit_TestCaseInterpreter.assertTrue((boolean)b);
        if (!b) {
            System.exit(1);
        }
    }

    public void testCommitRelease() {
        this.st1.setUser(null);
        this.st1.setCallString("create user JunitUser1 password j");
        this.st1.setVerificationData(null);
        JUnit_TestCaseInterpreter.assertTrue((boolean)this.tip.executeStatement(this.st1));
        this.st1.setCallString("connect JunitUser1 identified by j");
        this.st1.setVerificationData(null);
        JUnit_TestCaseInterpreter.assertTrue((boolean)this.tip.executeStatement(this.st1));
        this.st1.setCallString("select username from sessions where own='YES'");
        this.st1.setUser("JunitUser1");
        this.st1.setVerificationData((VerificationData)new VerificationDataComplete("('JUNITUSER1')"));
        JUnit_TestCaseInterpreter.assertTrue((boolean)this.tip.executeStatement(this.st1));
        this.st1.setCallString("commit release");
        this.st1.setUser("JunitUser1");
        this.st1.setVerificationData(null);
        JUnit_TestCaseInterpreter.assertTrue((boolean)this.tip.executeStatement(this.st1));
        this.st1.setCallString("select username from sessions where own='YES'");
        this.st1.setUser("JunitUser1");
        this.el.clear();
        this.el.add(new ErrorBean(-821, ""));
        this.st1.setErrorBeans(this.el);
        JUnit_TestCaseInterpreter.assertTrue((boolean)this.tip.executeStatement(this.st1));
        this.st1.setCallString("drop user JunitUser1");
        this.st1.setUser(null);
        this.el.clear();
        this.st1.setErrorBeans(this.el);
        boolean b = this.tip.executeStatement(this.st1);
        JUnit_TestCaseInterpreter.assertTrue((boolean)b);
        if (!b) {
            System.exit(1);
        }
    }

    public void testCommitWorkRelease() {
        this.st1.setCallString("create user JunitUser1 password j");
        this.st1.setVerificationData(null);
        JUnit_TestCaseInterpreter.assertTrue((boolean)this.tip.executeStatement(this.st1));
        this.st1.setCallString("connect JunitUser1 identified by j");
        this.st1.setVerificationData(null);
        JUnit_TestCaseInterpreter.assertTrue((boolean)this.tip.executeStatement(this.st1));
        this.st1.setCallString("select username from sessions where own='YES'");
        this.st1.setUser("JunitUser1");
        this.st1.setVerificationData((VerificationData)new VerificationDataComplete("('JUNITUSER1')"));
        JUnit_TestCaseInterpreter.assertTrue((boolean)this.tip.executeStatement(this.st1));
        this.st1.setCallString("commit work release");
        this.st1.setUser("JunitUser1");
        this.st1.setVerificationData(null);
        JUnit_TestCaseInterpreter.assertTrue((boolean)this.tip.executeStatement(this.st1));
        this.st1.setCallString("select username from sessions where own='YES'");
        this.st1.setUser("JunitUser1");
        this.el.clear();
        this.el.add(new ErrorBean(-821, ""));
        this.st1.setErrorBeans(this.el);
        JUnit_TestCaseInterpreter.assertTrue((boolean)this.tip.executeStatement(this.st1));
        this.st1.setCallString("drop user JunitUser1");
        this.st1.setUser(null);
        this.el.clear();
        this.st1.setErrorBeans(this.el);
        boolean b = this.tip.executeStatement(this.st1);
        JUnit_TestCaseInterpreter.assertTrue((boolean)b);
        if (!b) {
            System.exit(1);
        }
    }

    public void testRollbackWorkRelease() {
        this.st1.setCallString("create user JunitUser1 password j");
        this.st1.setVerificationData(null);
        JUnit_TestCaseInterpreter.assertTrue((boolean)this.tip.executeStatement(this.st1));
        this.st1.setCallString("connect JunitUser1 identified by j");
        this.st1.setVerificationData(null);
        JUnit_TestCaseInterpreter.assertTrue((boolean)this.tip.executeStatement(this.st1));
        this.st1.setCallString("select username from sessions where own='YES'");
        this.st1.setUser("JunitUser1");
        this.st1.setVerificationData((VerificationData)new VerificationDataComplete("('JUNITUSER1')"));
        JUnit_TestCaseInterpreter.assertTrue((boolean)this.tip.executeStatement(this.st1));
        this.st1.setCallString("Rollback Work release");
        this.st1.setUser("JunitUser1");
        this.st1.setVerificationData(null);
        JUnit_TestCaseInterpreter.assertTrue((boolean)this.tip.executeStatement(this.st1));
        this.st1.setCallString("select username from sessions where own='YES'");
        this.st1.setUser("JunitUser1");
        this.el.clear();
        this.el.add(new ErrorBean(-821, ""));
        this.st1.setErrorBeans(this.el);
        JUnit_TestCaseInterpreter.assertTrue((boolean)this.tip.executeStatement(this.st1));
        this.st1.setCallString("drop user JunitUser1");
        this.st1.setUser(null);
        this.el.clear();
        this.st1.setErrorBeans(this.el);
        boolean b = this.tip.executeStatement(this.st1);
        JUnit_TestCaseInterpreter.assertTrue((boolean)b);
        if (!b) {
            System.exit(1);
        }
    }
}

