/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.sqltest.interpreter;

import com.sap.sapdb.sqltest.interpreter.Cache;
import com.sap.sapdb.sqltest.interpreter.Catalog;
import com.sap.sapdb.sqltest.interpreter.Reference;
import com.sap.sapdb.sqltest.parser.StatementBean;
import com.sap.sapdb.sqltest.parser.TestCaseBean;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDatabaseSap;
import com.sap.sapdb.testframe.testcase.TestCallableStatement;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestStatement;
import com.sap.sapdb.testframe.testcase.VerificationDataComplete;
import com.sap.sapdb.testframe.utilities.TestCaseDBVersionScope;
import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;

public class TestCasesInterpreter
extends TestCase {
    protected Connection myConnection = null;
    protected TestStatement myStatement = null;
    protected TestCallableStatement myCallableStatement = null;
    protected TreeMap cases = null;
    protected String currentXMLFileName;
    protected TestCaseBean testCase;
    protected boolean traceMode;
    protected boolean errorTraceMode;
    protected boolean autoCommit;
    protected String testSqlMode;
    protected String runningStage;
    private Catalog catalog;
    private Cache cache;
    private int numberOfStartedTestCases = 0;
    private int numberOfFailedTestCases = 0;
    private int numberOfExcludedTestCases = 0;
    protected boolean isCurrentTestCaseFailed;
    private boolean isInfoIgnored;
    private int statementCounter = 0;
    private int cellLengthForPrintedResultSet = 25;
    private Vector mDatabaseParameter = new Vector();
    private Hashtable userConnections = new Hashtable();
    private Properties conProps;
    private boolean mDoConsistencyCheck = false;
    public static final String[] knownConnectionProperties = new String[]{"sqlmode", "timeout", "isolation", "reconnect", "autocommit", "spaceoption", "unicode", "trace", "application", "applversion"};
    private boolean stopOnFirstError = false;
    private boolean mAnErrorOccured = false;
    private String mErrorDescription = "";
    private String sVersion = "4.4";

    public void setInfoIgnored(boolean infoIgnored) {
        this.isInfoIgnored = infoIgnored;
    }

    public void setStopOnError(boolean stopOnError) {
        this.stopOnFirstError = stopOnError;
    }

    protected void printTrace(String str) {
        if (this.traceMode) {
            System.out.println(str);
            System.out.flush();
        }
    }

    /*
     * Exception decompiling
     */
    public boolean executeStatement(StatementBean st) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 13[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean executeSomeStatements(Iterator it) {
        while (it.hasNext()) {
            StatementBean sb = (StatementBean)it.next();
            ++this.statementCounter;
            if (this.executeStatement(sb)) continue;
            if (!this.isCurrentTestCaseFailed) {
                ++this.numberOfFailedTestCases;
                this.isCurrentTestCaseFailed = true;
            }
            return false;
        }
        return true;
    }

    public void setNewDatabaseParameter(String pParameter) {
        if (pParameter == null || pParameter.length() == 0) {
            return;
        }
        StringTokenizer stz = new StringTokenizer(pParameter, ",;");
        String curVal = null;
        try {
            TestDatabaseSap thisDB = (TestDatabaseSap)TestCasesInterpreter.getDatabase();
            while (stz.hasMoreTokens()) {
                String dbpOldValue;
                curVal = stz.nextToken().trim();
                String dbpName = curVal.substring(0, curVal.indexOf(":"));
                String dbpNewValue = curVal.substring(curVal.indexOf(":") + 1, curVal.length());
                if (dbpNewValue.compareTo(dbpOldValue = thisDB.getParameter(dbpName)) == 0) continue;
                this.mDatabaseParameter.add(new String(dbpName + "," + dbpNewValue + "," + dbpOldValue));
            }
            if (this.mDatabaseParameter.size() > 0) {
                System.out.println("Set new database parameter from parameter file...");
                thisDB.executeDBMcmd("db_cold");
                thisDB.executeDBMcmd("param_startsession");
                for (int i = 0; i < this.mDatabaseParameter.size(); ++i) {
                    curVal = (String)this.mDatabaseParameter.get(i);
                    stz = new StringTokenizer(curVal, ",");
                    thisDB.executeDBMcmd("param_put " + stz.nextToken() + " " + stz.nextToken());
                }
                thisDB.executeDBMcmd("param_checkall");
                thisDB.executeDBMcmd("param_commitsession");
                thisDB.executeDBMcmd("db_offline");
                thisDB.restart();
            }
        }
        catch (TestDatabaseException tbe) {
            this.addMessage("setNewDatabaseParameter", 'E', "Tried to set: " + pParameter + "\nas new database parameter and got: " + tbe.getLocalizedMessage());
            this.mDatabaseParameter.clear();
        }
    }

    public void restoreOldDatabaseParameters() {
        if (this.mDatabaseParameter.size() == 0) {
            return;
        }
        try {
            TestDatabaseSap thisDB = (TestDatabaseSap)TestCasesInterpreter.getDatabase();
            System.out.println("Restore old database parameter...");
            thisDB.executeDBMcmd("db_cold");
            thisDB.executeDBMcmd("param_startsession");
            for (int i = 0; i < this.mDatabaseParameter.size(); ++i) {
                String curVal = (String)this.mDatabaseParameter.get(i);
                StringTokenizer stz = new StringTokenizer(curVal, ",");
                String dbpName = stz.nextToken();
                stz.nextToken();
                String dbpValue = stz.nextToken();
                thisDB.executeDBMcmd("param_put " + dbpName + " " + dbpValue);
            }
            thisDB.executeDBMcmd("param_checkall");
            thisDB.executeDBMcmd("param_commitsession");
            thisDB.executeDBMcmd("db_offline");
            thisDB.restart();
        }
        catch (TestDatabaseException tbe) {
            this.addMessage("restoreOldDatabaseParameters", 'E', "Tried to restore old database parameter and got: " + tbe.getLocalizedMessage());
        }
    }

    public static String getTestClassId() {
        return "TestCasesInterpreter";
    }

    public void setTraceMode(boolean b) {
        this.traceMode = b;
    }

    public void setTestCase(TestCaseBean t) {
        this.testCase = t;
    }

    public void setConnection(Connection conn) {
        this.myConnection = conn;
    }

    public void setDefaultConnectionProperties(Properties props) {
        this.conProps = props;
    }

    public void setUserConnections(Hashtable conn) {
        this.userConnections = conn;
    }

    public void reset() {
        this.statementCounter = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        System.out.println(TestCasesInterpreter.getTestClassId() + " - Version: " + this.sVersion);
        this.addMessage(TestCasesInterpreter.getTestClassId(), 'I', "Version: " + this.sVersion);
        String catalogFileName = TestCasesInterpreter.getParameterString((String)"catalogFileName", (String)"");
        this.mDoConsistencyCheck = TestCasesInterpreter.getParameterBoolean((String)"DoConsistencyCheck", (boolean)false);
        this.isInfoIgnored = TestCasesInterpreter.getParameterBoolean((String)"IGNORE_INFO", (boolean)true);
        this.errorTraceMode = TestCasesInterpreter.getParameterBoolean((String)"ERRORTRACE", (boolean)false);
        boolean dropTestUser = TestCasesInterpreter.getParameterBoolean((String)"dropTestUser", (boolean)true);
        boolean testUserisDBA = TestCasesInterpreter.getParameterBoolean((String)"DBATestUser", (boolean)false);
        boolean testUserisSYSDBA = TestCasesInterpreter.getParameterBoolean((String)"SYSDBATestUser", (boolean)false);
        this.traceMode = TestCasesInterpreter.getParameterBoolean((String)"TRACE", (boolean)false);
        if (this.traceMode) {
            this.isInfoIgnored = false;
            this.errorTraceMode = true;
        }
        String URIPrefix = "file:///" + this.getDataInputPath() + File.separator;
        this.autoCommit = TestCasesInterpreter.getParameterBoolean((String)"AUTOCOMMIT", (boolean)false);
        this.testSqlMode = TestCasesInterpreter.getParameterString((String)"SQLMODE", (String)"INTERNAL");
        String testUser = TestCasesInterpreter.getParameterString((String)"testUser", (String)"");
        String testPassword = TestCasesInterpreter.getParameterString((String)"testPassword", (String)"");
        this.stopOnFirstError = TestCasesInterpreter.getParameterBoolean((String)"StopOnFirstError", (boolean)false);
        if (testUserisSYSDBA) {
            testUser = TestCasesInterpreter.getDatabase().getDBAUser();
            testPassword = TestCasesInterpreter.getDatabase().getDBAPassword();
            dropTestUser = false;
            testUserisDBA = false;
        }
        if (testUser.equals("")) {
            this.addMessage("", 'W', "Parameter testUser not set in parameter file, using default: TESTUSER");
            testUser = "TESTUSER";
        }
        if (testPassword.equals("")) {
            this.addMessage("", 'W', "Parameter testPassword not set in parameter file, using default: TESTUSER");
            testPassword = "TESTUSER";
        }
        this.cellLengthForPrintedResultSet = TestCasesInterpreter.getParameterInt((String)"RESULTSETLENGTH", (int)25);
        int maxExcludeRulesInProtocol = TestCasesInterpreter.getParameterInt((String)"MAXEXCLUDERULESINPROTOCOL", (int)-1);
        boolean disableAllExcludeRules = TestCasesInterpreter.getParameterBoolean((String)"DISABLEALLEXCLUDERULES", (boolean)false);
        String DataBaseParameter = TestCasesInterpreter.getParameterString((String)"DB_PARAMETER", (String)"");
        File catalogFile = new File(this.getDataInputPath() + File.separator + catalogFileName);
        int numberOfSelectedTestCases = 0;
        String Scope_charEncType = null;
        String Scope_sqlmode = this.testSqlMode;
        String Scope_version = null;
        try {
            Iterator itRef;
            int numberOfPlannedTestCases;
            TestDatabaseSap myDb = (TestDatabaseSap)TestCasesInterpreter.getDatabase();
            String sqlMode = myDb.getSqlMode();
            this.setNewDatabaseParameter(DataBaseParameter);
            Scope_charEncType = myDb.getParameter("_UNICODE").equalsIgnoreCase("YES") ? (myDb.getParameter("DEFAULT_CODE").equalsIgnoreCase("UNICODE") ? "unicode" : "mixed") : "ascii";
            Scope_version = myDb.getVersion();
            if (dropTestUser) {
                this.myConnection = TestCasesInterpreter.getDatabase().connect(TestCasesInterpreter.getUser(), TestCasesInterpreter.getPassword());
                TestStatement stmt = new TestStatement((TestCase)this, this.myConnection);
                if (sqlMode.equals("ORACLE")) {
                    stmt.executeUpdateIgnoreErrors("DROP USER " + testUser + " CASCADE");
                    if (testUserisDBA) {
                        stmt.executeUpdate("CREATE USER " + testUser + " IDENTIFIED BY " + testPassword);
                    } else {
                        stmt.executeUpdate("CREATE USER " + testUser + " IDENTIFIED BY " + testPassword);
                    }
                } else {
                    stmt.executeUpdateIgnoreErrors("DROP USER " + testUser);
                    if (testUserisDBA) {
                        stmt.executeUpdate("CREATE USER " + testUser + " PASSWORD " + testPassword + " DBA NOT EXCLUSIVE");
                    } else {
                        stmt.executeUpdate("CREATE USER " + testUser + " PASSWORD " + testPassword + " RESOURCE NOT EXCLUSIVE");
                    }
                }
                this.myConnection.commit();
                stmt.close();
                this.myConnection.close();
            }
            this.conProps = new Properties();
            this.conProps.put("user", testUser);
            this.conProps.put("password", testPassword);
            if (this.autoCommit) {
                this.conProps.put("autocommit", "on");
            } else {
                this.conProps.put("autocommit", "off");
            }
            this.conProps.put("sqlmode", this.testSqlMode);
            this.addMessage("Parameterfile", 'T', "The following parameter file was used:\n" + this.getParameterFileLocation());
            TestCasesInterpreter.printParametersToProtocol();
            this.myConnection = TestCasesInterpreter.getDatabase().connect(this.conProps);
            this.addMessage("Testcontext", 'T', "The context for these tests is: \nRelease     : " + Scope_version + "\nCharEncType : " + Scope_charEncType + "\nSQLMode     : " + Scope_sqlmode + "\n\ndb parameter:" + "\n _UNICODE      = " + myDb.getParameter("_UNICODE") + "\n DEFAULT_CODE  = " + myDb.getParameter("DEFAULT_CODE") + "\n _PACKET_SIZE  = " + myDb.getParameter("_PACKET_SIZE"));
            this.cache = new Cache(URIPrefix);
            String singleTest = TestCasesInterpreter.getParameterString((String)"SingleTest", (String)"");
            if (singleTest.length() != 0) {
                System.out.println("SingleTest: " + singleTest);
                String[] tests = singleTest.split(";|,");
                ArrayList<Reference> al = new ArrayList<Reference>(tests.length);
                for (int i = 0; i < tests.length; ++i) {
                    String[] s = tests[i].split(":");
                    if (s.length != 2) {
                        this.addMessage("Invalid parameter syntax", 'E', "Please specify single tests with <File name>:<Testnumber>. You entered " + tests[i] + ".");
                        continue;
                    }
                    try {
                        int testNummber = Integer.parseInt(s[1]);
                        al.add(new Reference(s[0], testNummber, null, true));
                        continue;
                    }
                    catch (NumberFormatException e) {
                        this.addMessage("Invalid test number", 'E', "The test number must be an integer. You entered " + s[1] + ".");
                    }
                }
                numberOfPlannedTestCases = al.size();
                itRef = al.iterator();
            } else {
                this.catalog = new Catalog(catalogFile);
                itRef = this.catalog.iterator();
                numberOfPlannedTestCases = this.catalog.getNumberOfReferences();
            }
            while (itRef.hasNext() && !this.mAnErrorOccured) {
                TestCaseDBVersionScope t;
                Reference currentRef = (Reference)itRef.next();
                if (!currentRef.getSelected()) continue;
                ++numberOfSelectedTestCases;
                this.testCase = this.cache.getCaseForReference(currentRef);
                if (this.testCase == null) {
                    this.addMessage("File = " + currentRef.getFileName(), 'W', "the test case for this " + currentRef.toString() + " does not exist.");
                    continue;
                }
                if (!disableAllExcludeRules && this.testCase.getExcludeProperty() != null && this.testCase.getExcludeProperty().length() != 0 && !(t = new TestCaseDBVersionScope(this.testCase.getExcludeProperty())).isInScope(Scope_charEncType, Scope_sqlmode, Scope_version)) {
                    if (this.numberOfExcludedTestCases <= maxExcludeRulesInProtocol || maxExcludeRulesInProtocol == -1) {
                        this.addMessage("Exclude rule", 'T', "Test " + currentRef.toString() + " \nwas not executed because exclude rule \"" + this.testCase.getExcludeProperty() + "\" matched.");
                    }
                    ++this.numberOfExcludedTestCases;
                    continue;
                }
                ++this.numberOfStartedTestCases;
                if (this.numberOfStartedTestCases % 100 == 0) {
                    this.setStatus(this.numberOfStartedTestCases + " of " + numberOfPlannedTestCases);
                }
                this.isCurrentTestCaseFailed = false;
                this.printTrace("-----------------------------------------------------------------------------");
                this.printTrace("-----------------------------------------------------------------------------");
                this.printTrace("Current reference: " + currentRef + "\n");
                this.printTrace("Execute:\n" + this.testCase);
                this.printTrace("-----------------------------------------------------------------------------");
                this.printTrace("Statements executed:\n\n");
                boolean result = true;
                this.currentXMLFileName = currentRef.getStructurePath() + "\n   file: " + currentRef.getFileName();
                this.statementCounter = 0;
                if (!this.testCase.getPrepareStatemets().isEmpty()) {
                    this.runningStage = "Prepare";
                    this.printTrace("Prepare phase:");
                    result = this.executeSomeStatements(this.testCase.getPrepareStatemets().iterator());
                    if (!result) {
                        this.printTrace("Prepare phase failed.\n");
                    } else {
                        this.printTrace("Prepare phase successful.\n");
                    }
                }
                if (result) {
                    this.runningStage = "Run";
                    this.printTrace("Run phase:");
                    if (!this.executeSomeStatements(this.testCase.getRunStatements().iterator())) {
                        this.printTrace("Run phase failed.\n");
                    } else {
                        this.printTrace("Run phase successful.\n");
                    }
                }
                this.runningStage = "CleanUp";
                this.printTrace("CleanUp phase:");
                if (!this.testCase.getCleanUpStatements().isEmpty()) {
                    this.executeSomeStatements(this.testCase.getCleanUpStatements().iterator());
                }
                this.myConnection.commit();
            }
            int numberOfSuccessfulTestCases = this.numberOfStartedTestCases - this.numberOfFailedTestCases;
            if (numberOfSelectedTestCases * 3 < this.numberOfExcludedTestCases * 10) {
                this.addMessage("Tests not executed!", 'W', "At least 30% of the selected tests are excluded through the exclude rules.");
            }
            this.addMessage("\nCatalog file " + catalogFileName + " has been interpreted.", 'I', " Test Cases in Catalog  : " + numberOfPlannedTestCases + "\n" + " Test Cases Selected    : " + numberOfSelectedTestCases + "\n" + " Test Cases Excluded    : " + this.numberOfExcludedTestCases + "\n" + " Test Cases Started     : " + this.numberOfStartedTestCases + "\n" + " Test Cases Successful  : " + numberOfSuccessfulTestCases + "\n" + " Test Cases Failed      : " + this.numberOfFailedTestCases + "\n" + " Total Errors           : " + TestCasesInterpreter.getErrorCounter() + "\n" + " Total Warnings         : " + TestCasesInterpreter.getWarningCounter() + "\n" + " Total Infos            : " + TestCasesInterpreter.getInfoCounter());
            if (this.mAnErrorOccured) {
                this.addMessage(TestCasesInterpreter.getTestClassId(), 'E', "Because the parameter 'StopOnFirstError' is set to TRUE and an error is occurred, the test stopped too early. It is possible that further errors exist.");
                this.addMessage(TestCasesInterpreter.getTestClassId(), 'W', "An error occured, the parameter 'StopOnFirstError' is set to TRUE and the consistency check and the restore of old database parameter will not be executed.");
                this.addMessage(TestCasesInterpreter.getTestClassId(), 'W', "The error description: \n" + this.mErrorDescription);
            }
            if (!this.myConnection.isClosed()) {
                this.myConnection.close();
            }
            if (this.mDoConsistencyCheck && !this.mAnErrorOccured) {
                boolean errorInConsistencyCheck = false;
                this.myConnection = TestCasesInterpreter.getDatabase().connect(TestCasesInterpreter.getUser(), TestCasesInterpreter.getPassword());
                TestStatement stmt = new TestStatement((TestCase)this, this.myConnection);
                String qry = "select * from files f where (type = 'INDEX' or type = 'SHORT COLUMN FILE') and not exists (select * from files f1 where f1.fileid = f.primaryfileid) and f.FILESTATE <> 'DELETED'";
                VerificationDataComplete myVeri = null;
                ResultSet myRS = null;
                myRS = stmt.executeQuery(qry);
                myVeri = new VerificationDataComplete(myRS);
                if (myVeri.getRowCounter() != 0) {
                    errorInConsistencyCheck = true;
                    this.addMessage(TestCasesInterpreter.getTestClassId(), 'E', "Database consistency check (" + myVeri.getRowCounter() + ") fails.\nResultset for\n" + qry + "\n" + myVeri.toString());
                }
                if ((myVeri = new VerificationDataComplete(myRS = stmt.executeQuery(qry = "select * from files f where type = 'TABLE' and fileid < x'8000000000000000' and fileid <> x'0000000000000064' and fileid <> x'0000000000000065' and not exists (select * from sysdd.tables where objectid = f.fileid) and f.FILESTATE <> 'DELETED'"))).getRowCounter() != 0) {
                    errorInConsistencyCheck = true;
                    this.addMessage(TestCasesInterpreter.getTestClassId(), 'E', "Database consistency check (" + myVeri.getRowCounter() + ") fails.\nResultset for " + qry + "\n" + myVeri.toString());
                }
                if ((myVeri = new VerificationDataComplete(myRS = stmt.executeQuery(qry = "select * from files f where type = 'INDEX' and not exists (select * from sysdd.indexes i where i.fileid = f.fileid) and f.FILESTATE <> 'DELETED'"))).getRowCounter() != 0) {
                    errorInConsistencyCheck = true;
                    this.addMessage(TestCasesInterpreter.getTestClassId(), 'E', "Database consistency check (" + myVeri.getRowCounter() + ") fails.\nResultset for\n" + qry + "\n" + myVeri.toString());
                }
                int myRowCount = 0;
                try {
                    qry = "check catalog";
                    myRowCount = stmt.executeUpdate(qry);
                    if (myRowCount != 0) {
                        errorInConsistencyCheck = true;
                        this.addMessage(TestCasesInterpreter.getTestClassId(), 'E', "Database consistency check (" + myRowCount + ") fails.\nResult for\n" + qry + "\n" + myRowCount);
                    }
                }
                catch (SQLException sqle) {
                    errorInConsistencyCheck = true;
                    this.addMessage(TestCasesInterpreter.getTestClassId(), 'E', "Database consistency check (" + myRowCount + ") fails.\nExecption for\n" + qry + "\n" + sqle.getErrorCode() + "\n" + sqle.getLocalizedMessage());
                }
                try {
                    qry = "db_execute check data";
                    String dbmresult = TestCasesInterpreter.getDatabase().executeDBMcmd(qry);
                    if (dbmresult.trim().length() != 0 && !dbmresult.trim().startsWith("OK")) {
                        errorInConsistencyCheck = true;
                        this.addMessage(TestCasesInterpreter.getTestClassId(), 'E', "Database consistency check fails.\nResult for executeDBMcmd(" + qry + ")\n" + dbmresult);
                    }
                }
                catch (TestDatabaseException tdbe) {
                    errorInConsistencyCheck = true;
                    this.addMessage(TestCasesInterpreter.getTestClassId(), 'E', "Database consistency check fails.\nExecption for executeDBMcmd(" + qry + ")\n" + tdbe.getLocalizedMessage());
                }
                if (errorInConsistencyCheck) {
                    this.addMessage(TestCasesInterpreter.getTestClassId(), 'E', "There are errors in the database consistency check.");
                } else {
                    this.addMessage(TestCasesInterpreter.getTestClassId(), 'I', "There are no errors in the database consistency check.");
                }
            }
            if (!this.mAnErrorOccured) {
                this.restoreOldDatabaseParameters();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.handleExceptions(e);
        }
        finally {
            try {
                if (!this.myConnection.isClosed()) {
                    this.myConnection.commit();
                    this.myConnection.close();
                }
            }
            catch (Exception e) {}
        }
    }
}

