/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.sqltest.interpreter;

import com.sap.sapdb.sqltest.interpreter.Reference;
import com.sap.sapdb.testframe.utilities.UniversalFileAccess;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

public class Catalog
implements ErrorHandler {
    private Document document;
    private ArrayList references;

    public Catalog(String uri) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(true);
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        System.out.println("Catalog: " + uri);
        this.document = builder.parse(uri);
        this.references = this.getReferences();
    }

    public Catalog(File file) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(true);
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setErrorHandler(this);
        System.out.println("Catalog: " + file);
        InputStream is = UniversalFileAccess.getInputStream((File)file);
        this.document = builder.parse(is, UniversalFileAccess.createUri((File)file));
        is.close();
        this.references = this.getReferences();
    }

    public void warning(SAXParseException exception) throws SAXParseException {
        System.err.println("WARNING: line " + exception.getLineNumber() + ": " + exception.getMessage());
    }

    public void error(SAXParseException exception) throws SAXParseException {
        System.err.println("ERROR: line " + exception.getLineNumber() + ": " + exception.getMessage());
        throw exception;
    }

    public void fatalError(SAXParseException exception) throws SAXParseException {
        System.err.println("FATAL: line " + exception.getLineNumber() + ": " + exception.getMessage());
        throw exception;
    }

    private String getStructurePathForReference(Node reference) {
        String path = "";
        Node level = reference.getParentNode();
        Node parent = level.getParentNode();
        while (level.getNodeName().compareTo("CATALOG") != 0) {
            String levelName = level.getAttributes().getNamedItem("Name").getNodeValue();
            path = path.compareTo("") == 0 ? levelName : levelName + " -> " + path;
            parent = parent.getParentNode();
            level = level.getParentNode();
        }
        path = "path in catalog: " + path;
        return path;
    }

    private ArrayList getReferences() {
        this.references = new ArrayList();
        NodeList nl = this.document.getElementsByTagName("REFERENCE");
        for (int i = 0; i < nl.getLength(); ++i) {
            boolean sel = false;
            Node currNode = nl.item(i);
            NamedNodeMap attrs = currNode.getAttributes();
            String fileName = attrs.getNamedItem("FileName").getNodeValue();
            int number = Integer.parseInt(attrs.getNamedItem("Number").getNodeValue());
            String structurePath = this.getStructurePathForReference(currNode);
            if (attrs.getNamedItem("selected").getNodeValue().equals("true")) {
                sel = true;
            }
            this.references.add(new Reference(fileName, number, structurePath, sel));
        }
        return this.references;
    }

    public int getNumberOfReferences() {
        if (this.references != null) {
            return this.references.size();
        }
        return 0;
    }

    public Iterator iterator() {
        return this.references.iterator();
    }

    public static void main(String[] argv) {
        if (argv.length != 1) {
            System.out.println("Usage: java Catalog [URI]");
            System.exit(0);
        }
        String uri = argv[0];
        try {
            Catalog cat = new Catalog(uri);
            System.out.println(cat.getReferences());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

