/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.sqltest.dynamic;

import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDatabaseSap;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.testcase.TestStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class StackOverflowWhere
extends TestCase {
    private static final String testUser = "TESTTEAM";
    private static final String testPassword = "TESTTEAM";
    private static final String testSqlMode = "INTERNAL";
    private static Properties UserConnectionProperties = new Properties();
    private static Properties DBAConnectionProperties = new Properties();
    private static String DB_VERSION;
    private static String DB_OS_VERSION;
    private static int DB_BITS;
    private static String DB_OS;
    private static String DB_SYS;
    private static Properties MIN_STACK_SIZE_WHERE;
    private static Vector mDatabaseParameter;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void prepare() throws TestCaseException {
        System.out.println("Prepare of " + StackOverflowWhere.getTestClassId());
        MIN_STACK_SIZE_WHERE.setProperty("WinIA32", "1019");
        MIN_STACK_SIZE_WHERE.setProperty("WinIA64", "1019");
        MIN_STACK_SIZE_WHERE.setProperty("LinuxIA32", "1019");
        MIN_STACK_SIZE_WHERE.setProperty("LinuxIA64", "1019");
        MIN_STACK_SIZE_WHERE.setProperty("DEC", "500");
        MIN_STACK_SIZE_WHERE.setProperty("AIX", "1019");
        MIN_STACK_SIZE_WHERE.setProperty("HP-UX", "1019");
        MIN_STACK_SIZE_WHERE.setProperty("Reliant", "500");
        MIN_STACK_SIZE_WHERE.setProperty("SUN", "1000");
        MIN_STACK_SIZE_WHERE.setProperty("All", "250");
        Connection UserDatabaseConnection = null;
        Connection DBADatabaseConnection = null;
        TestStatement initStatement = null;
        UserConnectionProperties.put("user", "TESTTEAM");
        UserConnectionProperties.put("password", "TESTTEAM");
        UserConnectionProperties.put("autocommit", "on");
        UserConnectionProperties.put("sqlmode", testSqlMode);
        DBAConnectionProperties.put("user", StackOverflowWhere.getUser());
        DBAConnectionProperties.put("password", StackOverflowWhere.getPassword());
        DBAConnectionProperties.put("autocommit", "on");
        DBAConnectionProperties.put("sqlmode", testSqlMode);
        try {
            StackOverflowWhere.setNewDatabaseParameter("_PACKET_SIZE:100000");
            DB_SYS = StackOverflowWhere.getDatabase().getSys();
            if (DB_SYS != "SAP") {
                throw new Exception(" This test does not work with " + DB_SYS);
            }
            TestDatabaseSap DB = (TestDatabaseSap)StackOverflowWhere.getDatabase();
            DB_BITS = DB.getBitVersion();
            DB_VERSION = DB.getVersion();
            DB_OS = DB.executeDBMcmdWithoutLogin("dbm_version sysname").trim().toUpperCase();
            if (DB_OS.startsWith("WINDOWS")) {
                if (DB_BITS == 32) {
                    DB_OS_VERSION = "WinIA32";
                } else {
                    if (DB_BITS != 64) throw new Exception(" Unknown database version: " + DB_VERSION + " on " + DB_OS);
                    DB_OS_VERSION = "WinIA64";
                }
            } else if (DB_OS.indexOf("LINUX") >= 0) {
                if (DB_BITS == 32) {
                    DB_OS_VERSION = "LinuxIA32";
                } else {
                    if (DB_BITS != 64) throw new Exception(" Unknown database version: " + DB_VERSION + " on " + DB_OS);
                    DB_OS_VERSION = "LinuxIA64";
                }
            } else if (DB_OS.indexOf("AIX") >= 0) {
                DB_OS_VERSION = "AIX";
            } else if (DB_OS.indexOf("HP-UX") >= 0) {
                DB_OS_VERSION = "HP-UX";
            } else if (DB_OS.indexOf("OSF1") >= 0) {
                DB_OS_VERSION = "DEC";
            } else if (DB_OS.indexOf("RELIANT") >= 0) {
                DB_OS_VERSION = "Reliant";
            } else {
                if (DB_OS.indexOf("SUNOS") < 0) throw new Exception(" Unknown database version: " + DB_VERSION + " on " + DB_OS);
                DB_OS_VERSION = "SUN";
            }
            DBADatabaseConnection = StackOverflowWhere.getDatabase().connect(DBAConnectionProperties);
            initStatement = new TestStatement(null, DBADatabaseConnection);
            initStatement.executeUpdateIgnoreErrors("drop user TESTTEAM");
            initStatement.executeUpdate("create user TESTTEAM Password TESTTEAM resource not exclusive");
            UserDatabaseConnection = StackOverflowWhere.getDatabase().connect(UserConnectionProperties);
            return;
        }
        catch (Exception e) {
            StackOverflowWhere.addGlobalMessage((String)"Method prepare", (char)'E', (String)"preparation failed");
            throw new TestCaseException("Error during preparation: " + e.getClass() + e.getMessage());
        }
        finally {
            try {
                initStatement.close();
            }
            catch (Exception e) {}
            try {
                DBADatabaseConnection.commit();
                DBADatabaseConnection.close();
            }
            catch (Exception e) {}
            try {
                UserDatabaseConnection.commit();
                UserDatabaseConnection.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block40: {
            System.out.println("Run of " + StackOverflowWhere.getTestClassId());
            Connection UserDatabaseConnection = null;
            TestStatement testStatement = null;
            try {
                int i;
                int startValue;
                UserDatabaseConnection = StackOverflowWhere.getDatabase().connect(UserConnectionProperties);
                testStatement = new TestStatement((TestCase)this, UserDatabaseConnection);
                testStatement.enableExplain(false);
                String TestName = " StackOverflow(Where)";
                int expectedValue = Integer.parseInt(MIN_STACK_SIZE_WHERE.getProperty(DB_OS_VERSION));
                int minValue = Integer.parseInt(MIN_STACK_SIZE_WHERE.getProperty("All"));
                int maxValue = startValue = 2;
                testStatement.executeUpdate("Create table tab1(int1 fixed(10),int12 fixed(10),char1 char(20),char12 char(20),primary key(int1,char1))");
                testStatement.executeUpdate("Create table tab2(int1 fixed(10),int22 fixed(10),char1 char(20),char22 char(20),primary key(int1,char1))");
                testStatement.executeUpdate("Create view view1 as Select tab1.int1, tab1.char1, tab1.int12, tab2.int22, tab1.char12, tab2.char22 from tab1,tab2 where tab1.int1 = tab2.int1 and tab1.char1 = tab2.char1");
                for (i = 1; i <= 1000; ++i) {
                    testStatement.executeUpdate("insert into tab1 values(" + i + "," + i + ",'Test','test" + i + "')");
                }
                for (i = 1; i <= 1000; ++i) {
                    testStatement.executeUpdate("insert into tab2 values(" + i + "," + i + ",'Test','test" + i + "')");
                }
                String query1 = "select count(*) from view1 where char1 ='Test'and (int1 = 1";
                String query2 = " or int1 = ";
                String query3 = ")";
                try {
                    while (true) {
                        query1 = query1 + query2 + maxValue;
                        testStatement.executeQuery(query1 + query3);
                        ++maxValue;
                    }
                }
                catch (Exception e) {
                    String ex = e.getMessage();
                    if (ex.indexOf("-1104") >= 0 || ex.indexOf("-918") >= 0) {
                        if ((double)maxValue >= (double)expectedValue * 0.9) {
                            this.addMessage(this.nextStep("") + TestName, 'I', "Result(" + (maxValue - 1) + ")is in range of the expected value(" + expectedValue + "}");
                        } else if (maxValue >= minValue) {
                            this.addMessage(this.nextStep("") + TestName, 'W', "Result(" + (maxValue - 1) + ")is not in range of the expected value(" + expectedValue + "}");
                        } else {
                            this.addMessage(this.nextStep("") + TestName, 'E', "Result(" + (maxValue - 1) + ")is below minimum requiered value(" + minValue + "}");
                        }
                    } else if (ex.indexOf("-915") >= 0) {
                        this.addMessage(this.nextStep("") + TestName, 'I', "-915 No more memory. No StackOverflow occured");
                    } else if (ex.indexOf("-1102") >= 0) {
                        this.addMessage(this.nextStep("") + TestName, 'I', "-1102 Too complicated SQL statement (too many subqueries). No StackOverflow occured with " + (maxValue - 1) + " a ");
                    } else if (ex.indexOf("-1107") >= 0) {
                        this.addMessage(this.nextStep("") + TestName, 'I', "-1107 Too complicated SQL statement (too many internal commands). No StackOverflow occured with " + (maxValue - 1) + "  or-linked where conditions");
                    } else {
                        if (ex.indexOf("-813") >= 0 && (double)maxValue > (double)expectedValue * 0.3) {
                            this.addMessage(this.nextStep("") + TestName, 'W', "Kernel crashed. No StackOverflow occured after " + maxValue + " steps (1)");
                            try {
                                testStatement.close();
                            }
                            catch (Exception e2) {
                                // empty catch block
                            }
                            try {
                                UserDatabaseConnection.commit();
                                UserDatabaseConnection.close();
                            }
                            catch (Exception e3) {
                                // empty catch block
                            }
                            return;
                        }
                        this.addMessage(this.nextStep("") + TestName, 'E', ex);
                        throw new TestCaseException("The exception: " + ex + " occured at " + maxValue + " or-linked where conditions");
                    }
                    try {
                        testStatement.close();
                    }
                    catch (Exception e4) {
                        // empty catch block
                    }
                    try {
                        UserDatabaseConnection.commit();
                        UserDatabaseConnection.close();
                    }
                    catch (Exception e5) {}
                    break block40;
                    catch (Exception e6) {
                        this.handleExceptions(e6);
                        break block40;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                try {
                    testStatement.close();
                }
                catch (Exception e) {}
                try {
                    UserDatabaseConnection.commit();
                    UserDatabaseConnection.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void cleanUp() throws TestCaseException {
        Connection DBADatabaseConnection = null;
        TestStatement cleanStatement = null;
        try {
            System.out.println("CleanUp of " + StackOverflowWhere.getTestClassId());
            if (((TestDatabaseSap)StackOverflowWhere.getDatabase()).isWarm()) {
                DBADatabaseConnection = StackOverflowWhere.getDatabase().connect(DBAConnectionProperties);
                cleanStatement = new TestStatement(null, DBADatabaseConnection);
                cleanStatement.executeUpdate("drop user TESTTEAM");
            }
            StackOverflowWhere.restoreOldDatabaseParameters();
        }
        catch (Exception e) {
            StackOverflowWhere.addGlobalMessage((String)"Method cleanup", (char)'E', (String)"cleanup failed");
            throw new TestCaseException("Error during cleanup: " + e.getClass() + e.getMessage());
        }
        finally {
            try {
                cleanStatement.close();
            }
            catch (Exception e) {}
            try {
                DBADatabaseConnection.commit();
                DBADatabaseConnection.close();
            }
            catch (Exception e) {}
        }
    }

    public static String getTestClassId() {
        return "StackOverflowWhere";
    }

    public static void setNewDatabaseParameter(String pParameter) {
        if (pParameter == null || pParameter.length() == 0) {
            return;
        }
        StringTokenizer stz = new StringTokenizer(pParameter, ",;");
        String curVal = null;
        try {
            TestDatabaseSap thisDB = (TestDatabaseSap)StackOverflowWhere.getDatabase();
            while (stz.hasMoreTokens()) {
                String dbpOldValue;
                curVal = stz.nextToken().trim();
                String dbpName = curVal.substring(0, curVal.indexOf(":"));
                String dbpNewValue = curVal.substring(curVal.indexOf(":") + 1, curVal.length());
                if (dbpNewValue.compareTo(dbpOldValue = thisDB.getParameter(dbpName)) == 0) continue;
                mDatabaseParameter.add(new String(dbpName + "," + dbpNewValue + "," + dbpOldValue));
            }
            if (mDatabaseParameter.size() > 0) {
                System.out.println("Set new database parameter from parameter file...");
                thisDB.executeDBMcmd("db_cold");
                thisDB.executeDBMcmd("param_startsession");
                for (int i = 0; i < mDatabaseParameter.size(); ++i) {
                    curVal = (String)mDatabaseParameter.get(i);
                    stz = new StringTokenizer(curVal, ",");
                    thisDB.executeDBMcmd("param_put " + stz.nextToken() + " " + stz.nextToken());
                }
                thisDB.executeDBMcmd("param_checkall");
                thisDB.executeDBMcmd("param_commitsession");
                thisDB.executeDBMcmd("db_offline");
                thisDB.restart();
            }
        }
        catch (TestDatabaseException tbe) {
            StackOverflowWhere.addGlobalMessage((String)"setNewDatabaseParameter", (char)'E', (String)("Tried to set: " + pParameter + "\nas new database parameter and got: " + tbe.getLocalizedMessage()));
            mDatabaseParameter.clear();
        }
    }

    public static void restoreOldDatabaseParameters() {
        if (mDatabaseParameter.size() == 0) {
            return;
        }
        try {
            TestDatabaseSap thisDB = (TestDatabaseSap)StackOverflowWhere.getDatabase();
            System.out.println("Restore old database parameter...");
            thisDB.executeDBMcmd("db_cold");
            thisDB.executeDBMcmd("param_startsession");
            for (int i = 0; i < mDatabaseParameter.size(); ++i) {
                String curVal = (String)mDatabaseParameter.get(i);
                StringTokenizer stz = new StringTokenizer(curVal, ",");
                String dbpName = stz.nextToken();
                stz.nextToken();
                String dbpValue = stz.nextToken();
                thisDB.executeDBMcmd("param_put " + dbpName + " " + dbpValue);
            }
            thisDB.executeDBMcmd("param_checkall");
            thisDB.executeDBMcmd("param_commitsession");
            thisDB.executeDBMcmd("db_offline");
            thisDB.restart();
        }
        catch (TestDatabaseException tbe) {
            StackOverflowWhere.addGlobalMessage((String)"restoreOldDatabaseParameters", (char)'E', (String)("Tried to restore old database parameter and got: " + tbe.getLocalizedMessage()));
        }
    }

    static {
        MIN_STACK_SIZE_WHERE = new Properties();
        mDatabaseParameter = new Vector();
    }
}

