/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.sqltest.dynamic;

import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDatabaseSap;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.testcase.TestStatement;
import com.sap.sapdb.testframe.testcase.VerificationDataComplete;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class StackOverflowViews
extends TestCase {
    private static final String testUser = "TESTTEAM";
    private static final String testPassword = "TESTTEAM";
    private static final String testSqlMode = "INTERNAL";
    private static Properties UserConnectionProperties = new Properties();
    private static Properties DBAConnectionProperties = new Properties();
    private static String DB_VERSION;
    private static String DB_OS_VERSION;
    private static int DB_BITS;
    private static String DB_OS;
    private static String DB_SYS;
    private static Properties MIN_STACK_SIZE_VIEWS;
    private static Vector mDatabaseParameter;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void prepare() throws TestCaseException {
        System.out.println("Prepare of " + StackOverflowViews.getTestClassId());
        MIN_STACK_SIZE_VIEWS.setProperty("WinIA32", "4000");
        MIN_STACK_SIZE_VIEWS.setProperty("WinIA64", "950");
        MIN_STACK_SIZE_VIEWS.setProperty("LinuxIA32", "1100");
        MIN_STACK_SIZE_VIEWS.setProperty("LinuxIA64", "500");
        MIN_STACK_SIZE_VIEWS.setProperty("DEC", "425");
        MIN_STACK_SIZE_VIEWS.setProperty("AIX", "200");
        MIN_STACK_SIZE_VIEWS.setProperty("HP-UX", "240");
        MIN_STACK_SIZE_VIEWS.setProperty("Reliant", "190");
        MIN_STACK_SIZE_VIEWS.setProperty("SUN", "275");
        MIN_STACK_SIZE_VIEWS.setProperty("All", "60");
        Connection UserDatabaseConnection = null;
        Connection DBADatabaseConnection = null;
        TestStatement initStatement = null;
        UserConnectionProperties.put("user", "TESTTEAM");
        UserConnectionProperties.put("password", "TESTTEAM");
        UserConnectionProperties.put("autocommit", "on");
        UserConnectionProperties.put("sqlmode", testSqlMode);
        DBAConnectionProperties.put("user", StackOverflowViews.getUser());
        DBAConnectionProperties.put("password", StackOverflowViews.getPassword());
        DBAConnectionProperties.put("autocommit", "on");
        DBAConnectionProperties.put("sqlmode", testSqlMode);
        try {
            StackOverflowViews.setNewDatabaseParameter("_PACKET_SIZE:100000");
            DB_SYS = StackOverflowViews.getDatabase().getSys();
            if (DB_SYS != "SAP") {
                throw new Exception(" This test does not work with " + DB_SYS);
            }
            TestDatabaseSap DB = (TestDatabaseSap)StackOverflowViews.getDatabase();
            DB_BITS = DB.getBitVersion();
            DB_VERSION = DB.getVersion();
            DB_OS = DB.executeDBMcmdWithoutLogin("dbm_version sysname").trim().toUpperCase();
            if (DB_OS.startsWith("WINDOWS")) {
                if (DB_BITS == 32) {
                    DB_OS_VERSION = "WinIA32";
                } else {
                    if (DB_BITS != 64) throw new Exception(" Unknown database version: " + DB_VERSION + " on " + DB_OS);
                    DB_OS_VERSION = "WinIA64";
                }
            } else if (DB_OS.indexOf("LINUX") >= 0) {
                if (DB_BITS == 32) {
                    DB_OS_VERSION = "LinuxIA32";
                } else {
                    if (DB_BITS != 64) throw new Exception(" Unknown database version: " + DB_VERSION + " on " + DB_OS);
                    DB_OS_VERSION = "LinuxIA64";
                }
            } else if (DB_OS.indexOf("AIX") >= 0) {
                DB_OS_VERSION = "AIX";
            } else if (DB_OS.indexOf("HP-UX") >= 0) {
                DB_OS_VERSION = "HP-UX";
            } else if (DB_OS.indexOf("OSF1") >= 0) {
                DB_OS_VERSION = "DEC";
            } else if (DB_OS.indexOf("RELIANT") >= 0) {
                DB_OS_VERSION = "Reliant";
            } else {
                if (DB_OS.indexOf("SUNOS") < 0) throw new Exception(" Unknown database version: " + DB_VERSION + " on " + DB_OS);
                DB_OS_VERSION = "SUN";
            }
            DBADatabaseConnection = StackOverflowViews.getDatabase().connect(DBAConnectionProperties);
            initStatement = new TestStatement(null, DBADatabaseConnection);
            initStatement.executeUpdateIgnoreErrors("drop user TESTTEAM");
            initStatement.executeUpdate("create user TESTTEAM Password TESTTEAM resource not exclusive");
            UserDatabaseConnection = StackOverflowViews.getDatabase().connect(UserConnectionProperties);
            return;
        }
        catch (Exception e) {
            StackOverflowViews.addGlobalMessage((String)"Method prepare", (char)'E', (String)"preparation failed");
            e.printStackTrace();
            throw new TestCaseException("Error during preparation: " + e.getClass() + e.getMessage());
        }
        finally {
            try {
                initStatement.close();
            }
            catch (Exception e) {}
            try {
                DBADatabaseConnection.commit();
                DBADatabaseConnection.close();
            }
            catch (Exception e) {}
            try {
                UserDatabaseConnection.commit();
                UserDatabaseConnection.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block52: {
            int startValue;
            System.out.println("Run of " + StackOverflowViews.getTestClassId());
            Connection UserDatabaseConnection = null;
            TestStatement testStatement = null;
            UserDatabaseConnection = StackOverflowViews.getDatabase().connect(UserConnectionProperties);
            testStatement = new TestStatement((TestCase)this, UserDatabaseConnection);
            testStatement.enableExplain(false);
            String TestName = " StackOverflow(Views)";
            int expectedValue = Integer.parseInt(MIN_STACK_SIZE_VIEWS.getProperty(DB_OS_VERSION));
            int minValue = Integer.parseInt(MIN_STACK_SIZE_VIEWS.getProperty("All"));
            int maxValue = startValue = 2;
            ResultSet Result = null;
            String exec1 = "create view view";
            String exec2 = " as select * from view";
            String query1 = "Select * from view";
            VerificationDataComplete CorrectResult = new VerificationDataComplete();
            try {
                testStatement.executeUpdate("Create table tab1(int1 fixed(10), int2 fixed(10), char1 varchar(100) ascii, char2 varchar(100) ascii)");
                for (int i = 1; i <= 100; ++i) {
                    testStatement.executeUpdate("insert into tab1 values(" + i + "," + (101 - i) + ",'" + i + "','" + (101 - i) + "')");
                    CorrectResult.add(i + "," + (101 - i) + ",'" + i + "','" + (101 - i) + "'");
                }
                testStatement.executeUpdate("Create View view1 as select * from tab1");
                while (maxValue <= 15000) {
                    String executeStatement = exec1 + maxValue + exec2 + (maxValue - 1);
                    String queryStatement = query1 + maxValue;
                    testStatement.executeUpdate(executeStatement);
                    Result = testStatement.executeQuery(queryStatement);
                    Result.next();
                    if (maxValue % 100 == 0) {
                        System.out.println(maxValue);
                    }
                    ++maxValue;
                }
                this.addMessage(this.nextStep("") + TestName, 'I', "Querytest with " + maxValue + " stacked views successfull");
            }
            catch (Exception e) {
                String ex = e.getMessage();
                if (ex.indexOf("-918") >= 0) {
                    if ((double)maxValue >= (double)expectedValue * 0.9) {
                        this.addMessage(this.nextStep("") + TestName, 'I', "Result(" + (maxValue - 1) + ")is in range of the expected value(" + expectedValue + "}");
                    } else if (maxValue >= minValue) {
                        this.addMessage(this.nextStep("") + TestName, 'W', "Result(" + (maxValue - 1) + ")is not in range of the expected value(" + expectedValue + "}");
                    } else {
                        this.addMessage(this.nextStep("") + TestName, 'E', "Result(" + (maxValue - 1) + ")is below minimum requiered value(" + minValue + "}");
                    }
                }
                if (ex.indexOf("-915") >= 0) {
                    this.addMessage(this.nextStep("") + TestName, 'I', "-915 No more memory. No StackOverflow occured");
                }
                if (ex.indexOf("-1102") >= 0) {
                    this.addMessage(this.nextStep("") + TestName, 'I', "-1102 Too complicated SQL statement (too many subqueries). No StackOverflow occured with " + (maxValue - 1) + " a ");
                }
                if (ex.indexOf("-1107") >= 0) {
                    this.addMessage(this.nextStep("") + TestName, 'I', "-1107 Too complicated SQL statement (too many internal commands). No StackOverflow occured with " + (maxValue - 1) + " subqueries");
                }
                if (ex.indexOf("-813") >= 0 && (double)maxValue > (double)expectedValue * 0.3) {
                    this.addMessage(this.nextStep("") + TestName, 'W', "Kernel crashed. No StackOverflow occured after " + maxValue + " steps (1)");
                    Object var16_18 = null;
                    try {
                        if (((TestDatabaseSap)StackOverflowViews.getDatabase()).isWarm()) {
                            ResultSet res = testStatement.executeQuery("select count(*) as VIEWCOUNT from views where owner = 'TESTTEAM' and VIEWNAME like 'VIEW%'");
                            res.next();
                            int ViewCount = res.getInt("VIEWCOUNT");
                            System.out.println("VIEWCOUNT: " + ViewCount);
                            if (ViewCount > 150) {
                                for (int i = ViewCount - 100; i > 1; i -= 100) {
                                    System.out.println("dropping view" + i);
                                    testStatement.executeUpdate("drop view view" + i);
                                }
                            }
                            System.out.println("dropping last view");
                            testStatement.executeUpdate("drop view view1");
                        }
                    }
                    catch (Exception e2) {
                        this.handleExceptions(e2);
                    }
                    try {
                        testStatement.close();
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    try {
                        UserDatabaseConnection.commit();
                        UserDatabaseConnection.close();
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    return;
                }
                this.addMessage(this.nextStep("") + TestName, 'E', ex);
                throw new TestCaseException("The exception: " + ex + " occured at " + (maxValue - 1) + " stacked views");
            }
            Object var16_19 = null;
            try {
                if (((TestDatabaseSap)StackOverflowViews.getDatabase()).isWarm()) {
                    ResultSet res = testStatement.executeQuery("select count(*) as VIEWCOUNT from views where owner = 'TESTTEAM' and VIEWNAME like 'VIEW%'");
                    res.next();
                    int ViewCount = res.getInt("VIEWCOUNT");
                    System.out.println("VIEWCOUNT: " + ViewCount);
                    if (ViewCount > 150) {
                        for (int i = ViewCount - 100; i > 1; i -= 100) {
                            System.out.println("dropping view" + i);
                            testStatement.executeUpdate("drop view view" + i);
                        }
                    }
                    System.out.println("dropping last view");
                    testStatement.executeUpdate("drop view view1");
                }
            }
            catch (Exception e2) {
                this.handleExceptions(e2);
            }
            try {
                testStatement.close();
            }
            catch (Exception e2) {
                // empty catch block
            }
            try {
                UserDatabaseConnection.commit();
                UserDatabaseConnection.close();
            }
            catch (Exception e2) {}
            break block52;
            {
                catch (Exception e) {
                    this.handleExceptions(e);
                    Object var16_20 = null;
                    try {
                        if (((TestDatabaseSap)StackOverflowViews.getDatabase()).isWarm()) {
                            ResultSet res = testStatement.executeQuery("select count(*) as VIEWCOUNT from views where owner = 'TESTTEAM' and VIEWNAME like 'VIEW%'");
                            res.next();
                            int ViewCount = res.getInt("VIEWCOUNT");
                            System.out.println("VIEWCOUNT: " + ViewCount);
                            if (ViewCount > 150) {
                                for (int i = ViewCount - 100; i > 1; i -= 100) {
                                    System.out.println("dropping view" + i);
                                    testStatement.executeUpdate("drop view view" + i);
                                }
                            }
                            System.out.println("dropping last view");
                            testStatement.executeUpdate("drop view view1");
                        }
                    }
                    catch (Exception e2) {
                        this.handleExceptions(e2);
                    }
                    try {
                        testStatement.close();
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    try {
                        UserDatabaseConnection.commit();
                        UserDatabaseConnection.close();
                    }
                    catch (Exception e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var16_21 = null;
                try {
                    if (((TestDatabaseSap)StackOverflowViews.getDatabase()).isWarm()) {
                        ResultSet res = testStatement.executeQuery("select count(*) as VIEWCOUNT from views where owner = 'TESTTEAM' and VIEWNAME like 'VIEW%'");
                        res.next();
                        int ViewCount = res.getInt("VIEWCOUNT");
                        System.out.println("VIEWCOUNT: " + ViewCount);
                        if (ViewCount > 150) {
                            for (int i = ViewCount - 100; i > 1; i -= 100) {
                                System.out.println("dropping view" + i);
                                testStatement.executeUpdate("drop view view" + i);
                            }
                        }
                        System.out.println("dropping last view");
                        testStatement.executeUpdate("drop view view1");
                    }
                }
                catch (Exception e2) {
                    this.handleExceptions(e2);
                }
                try {
                    testStatement.close();
                }
                catch (Exception e2) {
                    // empty catch block
                }
                try {
                    UserDatabaseConnection.commit();
                    UserDatabaseConnection.close();
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public static void cleanUp() throws TestCaseException {
        Connection DBADatabaseConnection = null;
        TestStatement cleanStatement = null;
        try {
            System.out.println("CleanUp of " + StackOverflowViews.getTestClassId());
            if (((TestDatabaseSap)StackOverflowViews.getDatabase()).isWarm()) {
                DBADatabaseConnection = StackOverflowViews.getDatabase().connect(DBAConnectionProperties);
                cleanStatement = new TestStatement(null, DBADatabaseConnection);
                cleanStatement.executeUpdate("drop user TESTTEAM");
            }
            StackOverflowViews.restoreOldDatabaseParameters();
        }
        catch (Exception e) {
            StackOverflowViews.addGlobalMessage((String)"Method cleanup", (char)'E', (String)"cleanup failed");
            e.printStackTrace();
            throw new TestCaseException("Error during cleanup: " + e.getClass() + e.getMessage());
        }
        finally {
            try {
                cleanStatement.close();
            }
            catch (Exception e) {}
            try {
                DBADatabaseConnection.commit();
                DBADatabaseConnection.close();
            }
            catch (Exception e) {}
        }
    }

    public static String getTestClassId() {
        return "StackOverflowViews";
    }

    public static void setNewDatabaseParameter(String pParameter) {
        if (pParameter == null || pParameter.length() == 0) {
            return;
        }
        StringTokenizer stz = new StringTokenizer(pParameter, ",;");
        String curVal = null;
        try {
            TestDatabaseSap thisDB = (TestDatabaseSap)StackOverflowViews.getDatabase();
            while (stz.hasMoreTokens()) {
                String dbpOldValue;
                curVal = stz.nextToken().trim();
                String dbpName = curVal.substring(0, curVal.indexOf(":"));
                String dbpNewValue = curVal.substring(curVal.indexOf(":") + 1, curVal.length());
                if (dbpNewValue.compareTo(dbpOldValue = thisDB.getParameter(dbpName)) == 0) continue;
                mDatabaseParameter.add(new String(dbpName + "," + dbpNewValue + "," + dbpOldValue));
            }
            if (mDatabaseParameter.size() > 0) {
                System.out.println("Set new database parameter from parameter file...");
                thisDB.executeDBMcmd("db_cold");
                thisDB.executeDBMcmd("param_startsession");
                for (int i = 0; i < mDatabaseParameter.size(); ++i) {
                    curVal = (String)mDatabaseParameter.get(i);
                    stz = new StringTokenizer(curVal, ",");
                    thisDB.executeDBMcmd("param_put " + stz.nextToken() + " " + stz.nextToken());
                }
                thisDB.executeDBMcmd("param_checkall");
                thisDB.executeDBMcmd("param_commitsession");
                thisDB.executeDBMcmd("db_offline");
                thisDB.restart();
            }
        }
        catch (TestDatabaseException tbe) {
            StackOverflowViews.addGlobalMessage((String)"setNewDatabaseParameter", (char)'E', (String)("Tried to set: " + pParameter + "\nas new database parameter and got: " + tbe.getLocalizedMessage()));
            mDatabaseParameter.clear();
        }
    }

    public static void restoreOldDatabaseParameters() {
        if (mDatabaseParameter.size() == 0) {
            return;
        }
        try {
            TestDatabaseSap thisDB = (TestDatabaseSap)StackOverflowViews.getDatabase();
            System.out.println("Restore old database parameter...");
            thisDB.executeDBMcmd("db_cold");
            thisDB.executeDBMcmd("param_startsession");
            for (int i = 0; i < mDatabaseParameter.size(); ++i) {
                String curVal = (String)mDatabaseParameter.get(i);
                StringTokenizer stz = new StringTokenizer(curVal, ",");
                String dbpName = stz.nextToken();
                stz.nextToken();
                String dbpValue = stz.nextToken();
                thisDB.executeDBMcmd("param_put " + dbpName + " " + dbpValue);
            }
            thisDB.executeDBMcmd("param_checkall");
            thisDB.executeDBMcmd("param_commitsession");
            thisDB.executeDBMcmd("db_offline");
            thisDB.restart();
        }
        catch (TestDatabaseException tbe) {
            StackOverflowViews.addGlobalMessage((String)"restoreOldDatabaseParameters", (char)'E', (String)("Tried to restore old database parameter and got: " + tbe.getLocalizedMessage()));
        }
    }

    static {
        MIN_STACK_SIZE_VIEWS = new Properties();
        mDatabaseParameter = new Vector();
    }
}

