/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.sqltest.dynamic;

import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDatabaseSap;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.testcase.TestStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class StackOverflow
extends TestCase {
    private static final String testUser = "TESTTEAM";
    private static final String testPassword = "TESTTEAM";
    private static final String testSqlMode = "INTERNAL";
    private static Properties UserConnectionProperties = new Properties();
    private static Properties DBAConnectionProperties = new Properties();
    private static String DB_VERSION;
    private static String DB_OS_VERSION;
    private static int DB_BITS;
    private static String DB_OS;
    private static String DB_SYS;
    private static Properties MIN_STACK_SIZE_COMPUTATION_1;
    private static Properties MIN_STACK_SIZE_COMPUTATION_2;
    private static Properties MIN_STACK_SIZE_SUBQUERY;
    private static Properties MIN_STACK_SIZE_UNION;
    private static Vector mDatabaseParameter;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void prepare() throws TestCaseException {
        System.out.println("Prepare of " + StackOverflow.getTestClassId());
        MIN_STACK_SIZE_COMPUTATION_1.setProperty("WinIA32", "4000");
        MIN_STACK_SIZE_COMPUTATION_1.setProperty("WinIA64", "2000");
        MIN_STACK_SIZE_COMPUTATION_1.setProperty("LinuxIA32", "1300");
        MIN_STACK_SIZE_COMPUTATION_1.setProperty("LinuxIA64", "500");
        MIN_STACK_SIZE_COMPUTATION_1.setProperty("DEC", "850");
        MIN_STACK_SIZE_COMPUTATION_1.setProperty("AIX", "1470");
        MIN_STACK_SIZE_COMPUTATION_1.setProperty("HP-UX", "1260");
        MIN_STACK_SIZE_COMPUTATION_1.setProperty("Reliant", "550");
        MIN_STACK_SIZE_COMPUTATION_1.setProperty("SUN", "1500");
        MIN_STACK_SIZE_COMPUTATION_1.setProperty("All", "300");
        MIN_STACK_SIZE_COMPUTATION_2.setProperty("WinIA32", "7650");
        MIN_STACK_SIZE_COMPUTATION_2.setProperty("WinIA64", "950");
        MIN_STACK_SIZE_COMPUTATION_2.setProperty("LinuxIA32", "1920");
        MIN_STACK_SIZE_COMPUTATION_2.setProperty("LinuxIA64", "500");
        MIN_STACK_SIZE_COMPUTATION_2.setProperty("DEC", "850");
        MIN_STACK_SIZE_COMPUTATION_2.setProperty("AIX", "2090");
        MIN_STACK_SIZE_COMPUTATION_2.setProperty("HP-UX", "1530");
        MIN_STACK_SIZE_COMPUTATION_2.setProperty("Reliant", "550");
        MIN_STACK_SIZE_COMPUTATION_2.setProperty("SUN", "2100");
        MIN_STACK_SIZE_COMPUTATION_2.setProperty("All", "300");
        MIN_STACK_SIZE_SUBQUERY.setProperty("WinIA32", "4000");
        MIN_STACK_SIZE_SUBQUERY.setProperty("WinIA64", "950");
        MIN_STACK_SIZE_SUBQUERY.setProperty("LinuxIA32", "1100");
        MIN_STACK_SIZE_SUBQUERY.setProperty("LinuxIA64", "500");
        MIN_STACK_SIZE_SUBQUERY.setProperty("DEC", "425");
        MIN_STACK_SIZE_SUBQUERY.setProperty("AIX", "170");
        MIN_STACK_SIZE_SUBQUERY.setProperty("HP-UX", "140");
        MIN_STACK_SIZE_SUBQUERY.setProperty("Reliant", "190");
        MIN_STACK_SIZE_SUBQUERY.setProperty("SUN", "180");
        MIN_STACK_SIZE_SUBQUERY.setProperty("All", "100");
        MIN_STACK_SIZE_UNION.setProperty("WinIA32", "4000");
        MIN_STACK_SIZE_UNION.setProperty("WinIA64", "950");
        MIN_STACK_SIZE_UNION.setProperty("LinuxIA32", "1100");
        MIN_STACK_SIZE_UNION.setProperty("LinuxIA64", "500");
        MIN_STACK_SIZE_UNION.setProperty("DEC", "425");
        MIN_STACK_SIZE_UNION.setProperty("AIX", "200");
        MIN_STACK_SIZE_UNION.setProperty("HP-UX", "240");
        MIN_STACK_SIZE_UNION.setProperty("Reliant", "190");
        MIN_STACK_SIZE_UNION.setProperty("SUN", "275");
        MIN_STACK_SIZE_UNION.setProperty("All", "60");
        Connection UserDatabaseConnection = null;
        Connection DBADatabaseConnection = null;
        TestStatement initStatement = null;
        UserConnectionProperties.put("user", "TESTTEAM");
        UserConnectionProperties.put("password", "TESTTEAM");
        UserConnectionProperties.put("autocommit", "on");
        UserConnectionProperties.put("sqlmode", testSqlMode);
        DBAConnectionProperties.put("user", StackOverflow.getUser());
        DBAConnectionProperties.put("password", StackOverflow.getPassword());
        DBAConnectionProperties.put("autocommit", "on");
        DBAConnectionProperties.put("sqlmode", testSqlMode);
        try {
            StackOverflow.setNewDatabaseParameter("_PACKET_SIZE:100000");
            DB_SYS = StackOverflow.getDatabase().getSys();
            if (DB_SYS != "SAP") {
                throw new Exception(" This test does not work with " + DB_SYS);
            }
            TestDatabaseSap DB = (TestDatabaseSap)StackOverflow.getDatabase();
            DB_BITS = DB.getBitVersion();
            DB_VERSION = DB.getVersion();
            DB_OS = DB.executeDBMcmdWithoutLogin("dbm_version sysname").trim().toUpperCase();
            if (DB_OS.startsWith("WINDOWS")) {
                if (DB_BITS == 32) {
                    DB_OS_VERSION = "WinIA32";
                } else {
                    if (DB_BITS != 64) throw new Exception(" Unknown database version: " + DB_VERSION + " on " + DB_OS);
                    DB_OS_VERSION = "WinIA64";
                }
            } else if (DB_OS.indexOf("LINUX") >= 0) {
                if (DB_BITS == 32) {
                    DB_OS_VERSION = "LinuxIA32";
                } else {
                    if (DB_BITS != 64) throw new Exception(" Unknown database version: " + DB_VERSION + " on " + DB_OS);
                    DB_OS_VERSION = "LinuxIA64";
                }
            } else if (DB_OS.indexOf("AIX") >= 0) {
                DB_OS_VERSION = "AIX";
            } else if (DB_OS.indexOf("HP-UX") >= 0) {
                DB_OS_VERSION = "HP-UX";
            } else if (DB_OS.indexOf("OSF1") >= 0) {
                DB_OS_VERSION = "DEC";
            } else if (DB_OS.indexOf("RELIANT") >= 0) {
                DB_OS_VERSION = "Reliant";
            } else {
                if (DB_OS.indexOf("SUNOS") < 0) throw new Exception(" Unknown database version: " + DB_VERSION + " on " + DB_OS);
                DB_OS_VERSION = "SUN";
            }
            DBADatabaseConnection = StackOverflow.getDatabase().connect(DBAConnectionProperties);
            initStatement = new TestStatement(null, DBADatabaseConnection);
            initStatement.executeUpdateIgnoreErrors("drop user TESTTEAM");
            initStatement.executeUpdate("create user TESTTEAM Password TESTTEAM resource not exclusive");
            UserDatabaseConnection = StackOverflow.getDatabase().connect(UserConnectionProperties);
            return;
        }
        catch (Exception e) {
            StackOverflow.addGlobalMessage((String)"Method prepare", (char)'E', (String)"preparation failed");
            throw new TestCaseException("Error during preparation: " + e.getClass() + e.getMessage());
        }
        finally {
            try {
                initStatement.close();
            }
            catch (Exception e) {}
            try {
                DBADatabaseConnection.commit();
                DBADatabaseConnection.close();
            }
            catch (Exception e) {}
            try {
                UserDatabaseConnection.commit();
                UserDatabaseConnection.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void run() {
        block83: {
            System.out.println("Run of " + StackOverflow.getTestClassId());
            UserDatabaseConnection = null;
            testStatement = null;
            try {
                UserDatabaseConnection = StackOverflow.getDatabase().connect(StackOverflow.UserConnectionProperties);
                testStatement = new TestStatement((TestCase)this, UserDatabaseConnection);
                testStatement.enableExplain(false);
                TestName = " StackOverflow(1+(1+1))";
                expectedValue = Integer.parseInt(StackOverflow.MIN_STACK_SIZE_COMPUTATION_1.getProperty(StackOverflow.DB_OS_VERSION));
                minValue = Integer.parseInt(StackOverflow.MIN_STACK_SIZE_COMPUTATION_1.getProperty("All"));
                maxValue = startValue = expectedValue / 2;
                computation = "(1+1)";
                compprefix = "(1+(1+(1+(1+(1+(1+(1+(1+(1+(1+";
                compsufix = "))))))))))";
                for (x = 1; x <= startValue; ++x) {
                    computation = "(1+" + computation + ")";
                }
                try {
                    while (true) {
                        testStatement.executeQuery("Select " + computation + " as Result from dual");
                        computation = compprefix + computation + compsufix;
                        maxValue += 10;
                    }
                }
                catch (Exception e) {
                    block86: {
                        block85: {
                            block84: {
                                ex = e.getMessage();
                                if (ex.indexOf("-918") < 0) break block84;
                                if ((double)maxValue > (double)expectedValue * 0.9) {
                                    this.addMessage(this.nextStep("") + TestName, 'I', "Result(" + maxValue + ")is in range of the expected value(" + expectedValue + "}");
                                } else if (maxValue >= minValue) {
                                    this.addMessage(this.nextStep("") + TestName, 'W', "Result(" + maxValue + ")is not in range of the expected value(" + expectedValue + "}");
                                } else {
                                    this.addMessage(this.nextStep("") + TestName, 'E', "Result(" + maxValue + ")is below minimum requiered value(" + minValue + "}");
                                }
                                ** GOTO lbl62
                            }
                            if (ex.indexOf("-1104") < 0) break block85;
                            this.addMessage(this.nextStep("") + TestName, 'I', "-1104 Too complicated SQL statement (KB-stack overflow). No StackOverflow occured with " + maxValue + " steps");
                            ** GOTO lbl62
                        }
                        if (ex.indexOf("-915") < 0) break block86;
                        this.addMessage(this.nextStep("") + TestName, 'I', "-915 No more memory. No StackOverflow occured after " + maxValue + " steps");
                        ** GOTO lbl62
                    }
                    if (ex.indexOf("-813") >= 0 && (double)maxValue > (double)expectedValue * 0.3) {
                        this.addMessage(this.nextStep("") + TestName, 'W', "Kernel crashed. No StackOverflow occured after " + maxValue + " steps (1)");
                        try {
                            testStatement.close();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        try {
                            UserDatabaseConnection.commit();
                            UserDatabaseConnection.close();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        return;
                    }
                    this.addMessage(this.nextStep("") + TestName, 'E', ex);
                    throw new TestCaseException("The exception: " + ex + " occured at " + maxValue + " steps");
lbl62:
                    // 5 sources

                    TestName = " StackOverflow(1+1)";
                    expectedValue = Integer.parseInt(StackOverflow.MIN_STACK_SIZE_COMPUTATION_2.getProperty(StackOverflow.DB_OS_VERSION));
                    minValue = Integer.parseInt(StackOverflow.MIN_STACK_SIZE_COMPUTATION_2.getProperty("All"));
                    maxValue = startValue = expectedValue / 2;
                    computation = "1+1";
                    compprefix = "1+1+1+1+1+1+1+1+1+1+";
                    for (x = 1; x <= startValue; ++x) {
                        computation = "1+" + computation;
                    }
                    try {
                        while (true) {
                            testStatement.executeQuery("Select " + computation + " as Result from dual");
                            computation = compprefix + computation;
                            maxValue += 10;
                        }
                    }
                    catch (Exception e) {
                        block89: {
                            block88: {
                                block87: {
                                    ex = e.getMessage();
                                    if (ex.indexOf("-918") < 0) break block87;
                                    if ((double)maxValue > (double)expectedValue * 0.9) {
                                        this.addMessage(this.nextStep("") + TestName, 'I', "Result(" + maxValue + ")is in range of the expected value(" + expectedValue + "}");
                                    } else if (maxValue >= minValue) {
                                        this.addMessage(this.nextStep("") + TestName, 'W', "Result(" + maxValue + ")is not in range of the expected value(" + expectedValue + "}");
                                    } else {
                                        this.addMessage(this.nextStep("") + TestName, 'E', "Result(" + maxValue + ")is below minimum requiered value(" + minValue + "}");
                                    }
                                    ** GOTO lbl115
                                }
                                if (ex.indexOf("-1104") < 0) break block88;
                                this.addMessage(this.nextStep("") + TestName, 'I', "-1104 Too complicated SQL statement (KB-stack overflow). No StackOverflow occured with " + maxValue + " steps");
                                ** GOTO lbl115
                            }
                            if (ex.indexOf("-915") < 0) break block89;
                            this.addMessage(this.nextStep("") + TestName, 'I', "-915 No more memory. No StackOverflow occured after " + maxValue + " steps");
                            ** GOTO lbl115
                        }
                        if (ex.indexOf("-813") >= 0 && (double)maxValue > (double)expectedValue * 0.3) {
                            this.addMessage(this.nextStep("") + TestName, 'W', "Kernel crashed. No StackOverflow occured after " + maxValue + " steps (2)");
                            try {
                                testStatement.close();
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            try {
                                UserDatabaseConnection.commit();
                                UserDatabaseConnection.close();
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            return;
                        }
                        this.addMessage(this.nextStep("") + TestName, 'E', ex);
                        throw new TestCaseException("The exception: " + ex + " occured at " + maxValue + " steps");
lbl115:
                        // 5 sources

                        TestName = " StackOverflow(Subquery)";
                        expectedValue = Integer.parseInt(StackOverflow.MIN_STACK_SIZE_SUBQUERY.getProperty(StackOverflow.DB_OS_VERSION));
                        minValue = Integer.parseInt(StackOverflow.MIN_STACK_SIZE_SUBQUERY.getProperty("All"));
                        maxValue = startValue = minValue / 2;
                        query = "select dummy from dual where dummy = (select dummy from dual)";
                        queryprefix = "select dummy from dual where dummy = (";
                        querysufix = ")";
                        for (x = 1; x <= startValue; ++x) {
                            query = queryprefix + query + querysufix;
                        }
                        try {
                            while (true) {
                                testStatement.executeQuery(query);
                                for (x = 1; x <= 10; ++x) {
                                    query = queryprefix + query + querysufix;
                                }
                                maxValue += 10;
                            }
                        }
                        catch (Exception e) {
                            block93: {
                                block92: {
                                    block91: {
                                        block90: {
                                            ex = e.getMessage();
                                            if (ex.indexOf("-918") < 0) break block90;
                                            if ((double)maxValue >= (double)expectedValue * 0.9) {
                                                this.addMessage(this.nextStep("") + TestName, 'I', "Result(" + maxValue + ")is in range of the expected value(" + expectedValue + "}");
                                            } else if (maxValue >= minValue) {
                                                this.addMessage(this.nextStep("") + TestName, 'W', "Result(" + maxValue + ")is not in range of the expected value(" + expectedValue + "}");
                                            } else {
                                                this.addMessage(this.nextStep("") + TestName, 'E', "Result(" + maxValue + ")is below minimum requiered value(" + minValue + "}");
                                            }
                                            ** GOTO lbl175
                                        }
                                        if (ex.indexOf("-915") < 0) break block91;
                                        this.addMessage(this.nextStep("") + TestName, 'I', "-915 No more memory. No StackOverflow occured");
                                        ** GOTO lbl175
                                    }
                                    if (ex.indexOf("-1104") < 0) break block92;
                                    this.addMessage(this.nextStep("") + TestName, 'I', "-1104 Too complicated SQL statement (KB-stack overflow). No StackOverflow occured with " + maxValue + " subqueries");
                                    ** GOTO lbl175
                                }
                                if (ex.indexOf("-1102") < 0) break block93;
                                this.addMessage(this.nextStep("") + TestName, 'I', "-1102 Too complicated SQL statement (too many subqueries). No StackOverflow occured with " + maxValue + " subqueries");
                                ** GOTO lbl175
                            }
                            if (ex.indexOf("-813") >= 0 && (double)maxValue > (double)expectedValue * 0.3) {
                                this.addMessage(this.nextStep("") + TestName, 'W', "Kernel crashed. No StackOverflow occured after " + maxValue + " steps (3)");
                                try {
                                    testStatement.close();
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                                try {
                                    UserDatabaseConnection.commit();
                                    UserDatabaseConnection.close();
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                                return;
                            }
                            this.addMessage(this.nextStep("") + TestName, 'E', ex);
                            throw new TestCaseException("The exception: " + ex + " occured at " + maxValue + " subqueries");
lbl175:
                            // 6 sources

                            TestName = " StackOverflow(Union)";
                            expectedValue = Integer.parseInt(StackOverflow.MIN_STACK_SIZE_UNION.getProperty(StackOverflow.DB_OS_VERSION));
                            minValue = Integer.parseInt(StackOverflow.MIN_STACK_SIZE_UNION.getProperty("All"));
                            maxValue = startValue = minValue / 2;
                            query = "select * from dual";
                            queryprefix = "";
                            querysufix = " union all select * from dual";
                            for (x = 1; x <= startValue; ++x) {
                                query = queryprefix + query + querysufix;
                            }
                            try {
                                while (true) {
                                    testStatement.executeQuery(query);
                                    for (x = 1; x <= 10; ++x) {
                                        query = queryprefix + query + querysufix;
                                    }
                                    maxValue += 10;
                                }
                            }
                            catch (Exception e) {
                                ex = e.getMessage();
                                if (ex.indexOf("-918") >= 0) {
                                    if ((double)maxValue >= (double)expectedValue * 0.9) {
                                        this.addMessage(this.nextStep("") + TestName, 'I', "Result(" + maxValue + ")is in range of the expected value(" + expectedValue + "}");
                                    } else if (maxValue >= minValue) {
                                        this.addMessage(this.nextStep("") + TestName, 'W', "Result(" + maxValue + ")is not in range of the expected value(" + expectedValue + "}");
                                    } else {
                                        this.addMessage(this.nextStep("") + TestName, 'E', "Result(" + maxValue + ")is below minimum requiered value(" + minValue + "}");
                                    }
                                } else if (ex.indexOf("-915") >= 0) {
                                    this.addMessage(this.nextStep("") + TestName, 'I', "-915 No more memory. No StackOverflow occured");
                                } else if (ex.indexOf("-1102") >= 0) {
                                    this.addMessage(this.nextStep("") + TestName, 'I', "-1102 Too complicated SQL statement (too many subqueries). No StackOverflow occured with " + maxValue + " subqueries");
                                } else if (ex.indexOf("-1107") >= 0) {
                                    this.addMessage(this.nextStep("") + TestName, 'I', "-1107 Too complicated SQL statement (too many internal commands). No StackOverflow occured with " + maxValue + " subqueries");
                                } else {
                                    if (ex.indexOf("-813") >= 0 && (double)maxValue > (double)expectedValue * 0.3) {
                                        this.addMessage(this.nextStep("") + TestName, 'W', "Kernel crashed. No StackOverflow occured after " + maxValue + " steps (4)");
                                        try {
                                            testStatement.close();
                                        }
                                        catch (Exception e) {
                                            // empty catch block
                                        }
                                        try {
                                            UserDatabaseConnection.commit();
                                            UserDatabaseConnection.close();
                                        }
                                        catch (Exception e) {
                                            // empty catch block
                                        }
                                        return;
                                    }
                                    this.addMessage(this.nextStep("") + TestName, 'E', ex);
                                    throw new TestCaseException("The exception: " + ex + " occured at " + maxValue + " subqueries");
                                }
                                try {
                                    testStatement.close();
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                                try {
                                    UserDatabaseConnection.commit();
                                    UserDatabaseConnection.close();
                                }
                                catch (Exception e) {}
                                break block83;
                                catch (Exception e) {
                                    this.handleExceptions(e);
                                    break block83;
                                }
                                catch (Throwable var14_35) {
                                    throw var14_35;
                                }
                            }
                        }
                    }
                }
            }
            finally {
                try {
                    testStatement.close();
                }
                catch (Exception e) {}
                try {
                    UserDatabaseConnection.commit();
                    UserDatabaseConnection.close();
                }
                catch (Exception var3_8) {}
            }
        }
    }

    public static void cleanUp() throws TestCaseException {
        Connection DBADatabaseConnection = null;
        TestStatement cleanStatement = null;
        try {
            System.out.println("CleanUp of " + StackOverflow.getTestClassId());
            if (((TestDatabaseSap)StackOverflow.getDatabase()).isWarm()) {
                DBADatabaseConnection = StackOverflow.getDatabase().connect(DBAConnectionProperties);
                cleanStatement = new TestStatement(null, DBADatabaseConnection);
                cleanStatement.executeUpdate("drop user TESTTEAM");
            }
            StackOverflow.restoreOldDatabaseParameters();
        }
        catch (Exception e) {
            StackOverflow.addGlobalMessage((String)"Method cleanup", (char)'E', (String)"cleanup failed");
            throw new TestCaseException("Error during cleanup: " + e.getClass() + e.getMessage());
        }
        finally {
            try {
                cleanStatement.close();
            }
            catch (Exception e) {}
            try {
                DBADatabaseConnection.commit();
                DBADatabaseConnection.close();
            }
            catch (Exception e) {}
        }
    }

    public static String getTestClassId() {
        return "StackOverflow";
    }

    public static void setNewDatabaseParameter(String pParameter) {
        if (pParameter == null || pParameter.length() == 0) {
            return;
        }
        StringTokenizer stz = new StringTokenizer(pParameter, ",;");
        String curVal = null;
        try {
            TestDatabaseSap thisDB = (TestDatabaseSap)StackOverflow.getDatabase();
            while (stz.hasMoreTokens()) {
                String dbpOldValue;
                curVal = stz.nextToken().trim();
                String dbpName = curVal.substring(0, curVal.indexOf(":"));
                String dbpNewValue = curVal.substring(curVal.indexOf(":") + 1, curVal.length());
                if (dbpNewValue.compareTo(dbpOldValue = thisDB.getParameter(dbpName)) == 0) continue;
                mDatabaseParameter.add(new String(dbpName + "," + dbpNewValue + "," + dbpOldValue));
            }
            if (mDatabaseParameter.size() > 0) {
                System.out.println("Set new database parameter from parameter file...");
                thisDB.executeDBMcmd("db_cold");
                thisDB.executeDBMcmd("param_startsession");
                for (int i = 0; i < mDatabaseParameter.size(); ++i) {
                    curVal = (String)mDatabaseParameter.get(i);
                    stz = new StringTokenizer(curVal, ",");
                    thisDB.executeDBMcmd("param_put " + stz.nextToken() + " " + stz.nextToken());
                }
                thisDB.executeDBMcmd("param_checkall");
                thisDB.executeDBMcmd("param_commitsession");
                thisDB.executeDBMcmd("db_offline");
                thisDB.restart();
            }
        }
        catch (TestDatabaseException tbe) {
            StackOverflow.addGlobalMessage((String)"setNewDatabaseParameter", (char)'E', (String)("Tried to set: " + pParameter + "\nas new database parameter and got: " + tbe.getLocalizedMessage()));
            mDatabaseParameter.clear();
        }
    }

    public static void restoreOldDatabaseParameters() {
        if (mDatabaseParameter.size() == 0) {
            return;
        }
        try {
            TestDatabaseSap thisDB = (TestDatabaseSap)StackOverflow.getDatabase();
            System.out.println("Restore old database parameter...");
            thisDB.executeDBMcmd("db_cold");
            thisDB.executeDBMcmd("param_startsession");
            for (int i = 0; i < mDatabaseParameter.size(); ++i) {
                String curVal = (String)mDatabaseParameter.get(i);
                StringTokenizer stz = new StringTokenizer(curVal, ",");
                String dbpName = stz.nextToken();
                stz.nextToken();
                String dbpValue = stz.nextToken();
                thisDB.executeDBMcmd("param_put " + dbpName + " " + dbpValue);
            }
            thisDB.executeDBMcmd("param_checkall");
            thisDB.executeDBMcmd("param_commitsession");
            thisDB.executeDBMcmd("db_offline");
            thisDB.restart();
        }
        catch (TestDatabaseException tbe) {
            StackOverflow.addGlobalMessage((String)"restoreOldDatabaseParameters", (char)'E', (String)("Tried to restore old database parameter and got: " + tbe.getLocalizedMessage()));
        }
    }

    static {
        MIN_STACK_SIZE_COMPUTATION_1 = new Properties();
        MIN_STACK_SIZE_COMPUTATION_2 = new Properties();
        MIN_STACK_SIZE_SUBQUERY = new Properties();
        MIN_STACK_SIZE_UNION = new Properties();
        mDatabaseParameter = new Vector();
    }
}

