/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.sqltest.dynamic;

import com.sap.dbtech.powertoys.DBM;
import com.sap.dbtech.powertoys.DBMException;
import com.sap.dbtech.rte.comm.RTEException;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestPreparedStatement;
import com.sap.sapdb.testframe.testcase.TestStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Random;
import java.util.TreeMap;
import java.util.Vector;

public class Lock
extends TestCase {
    public static boolean DEBUG = false;
    protected static int transactionCount = 9;
    protected static int tablesize = 100;
    protected static int REQUEST_TIMEOUT = 5;
    protected static int DEADLOCK_DETECTION = 4;
    private static final String mExUser = "dttest";
    private static final String mExPassword = "dttest";
    private Connection lConnection = null;
    private Random ran = new Random();
    private StatementExecuteThread t1;
    private StatementExecuteThread t2;
    private StatementExecuteThread t3;
    private String currentTestSequence = "";
    private String currentTestCase = "";
    private Hashtable currentTestCaseStatements = new Hashtable();
    private Vector currentTestCaseErrors = new Vector();
    private StatementExecuteThread[] transactions = new StatementExecuteThread[transactionCount];
    protected static final String mVersion = "0.2";
    public static final char[] CHARACTERS = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '!', '\"', '\u00a7', '$', '%', '&', '/', '(', ')', '=', '?', '+', '-', '_', '.', ':', ',', ';', '#', '~', '*'};
    private static int EXECUTION_TIME = 0;
    private static int CURRENT_EXECUTION_TIME = 1;
    private static Object EXECUTION_TIME_MUTEX = new Object();
    private Object sync_mutex = new Object();

    public static String getTestClassId() {
        return "Lock";
    }

    public static void prepare() {
        Lock.setDbParameter(REQUEST_TIMEOUT, 4);
    }

    public static void cleanUp() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block25: {
            int i3;
            int i2;
            TestStatement stmt = null;
            TestPreparedStatement prepStmt = null;
            System.out.println(Lock.getTestClassId() + " in version " + mVersion + " started");
            this.addMessage(Lock.getTestClassId(), 'I', "Test in version 0.2 started.");
            this.lConnection = Lock.getDatabase().connect(Lock.getUser(), Lock.getPassword());
            stmt = new TestStatement((TestCase)this, this.lConnection);
            stmt.enableExceptions(false);
            stmt.executeUpdate("Drop user dttest");
            for (i2 = 1; i2 <= transactionCount; ++i2) {
                stmt.execute("drop user locku" + i2);
            }
            stmt.enableExceptions(true);
            stmt.executeUpdate("Create user dttest password dttest dba not exclusive");
            stmt.close();
            this.lConnection.close();
            this.lConnection = Lock.getDatabase().connect("dttest", "dttest");
            stmt = new TestStatement((TestCase)this, this.lConnection);
            for (i2 = 1; i2 <= transactionCount; ++i2) {
                stmt.execute("create table tab" + i2 + " ( i1 int, i2 int, c1 char(20), c2 char(30), primary key (i1))");
                prepStmt = new TestPreparedStatement((TestCase)this, this.lConnection, "insert into tab" + i2 + " values ( ?, ?, ?, ?)");
                for (int j = 0; j < tablesize; ++j) {
                    prepStmt.setInt(1, j);
                    prepStmt.setInt(2, this.ran.nextInt());
                    prepStmt.setString(3, this.ranString(20));
                    prepStmt.setString(4, this.ranString(30));
                    prepStmt.addBatch();
                }
                prepStmt.executeBatch();
            }
            for (i2 = 1; i2 <= transactionCount; ++i2) {
                stmt.execute("create user locku" + i2 + " password locku" + i2);
                for (int j = 1; j <= transactionCount; ++j) {
                    stmt.execute("grant all on tab" + j + " to locku" + i2);
                }
                Properties prop = new Properties();
                prop.setProperty("user", "locku" + i2);
                prop.setProperty("password", "locku" + i2);
                prop.setProperty("autocommit", "off");
                StatementExecuteThread t = new StatementExecuteThread((Statement)new TestStatement((TestCase)this, Lock.getDatabase().connect(prop)));
                t.setName("T" + i2);
                this.transactions[i2 - 1] = t;
            }
            this.t1 = this.transactions[0];
            this.t2 = this.transactions[1];
            this.t3 = this.transactions[2];
            this.testDeadlocks();
            this.testDeadlockDetectionDepth();
            this.finishOldTestCase();
            Object var7_10 = null;
            for (i3 = 0; i3 < this.transactions.length; ++i3) {
                if (this.transactions[i3] == null) continue;
                this.transactions[i3].cancel();
            }
            try {
                stmt.close();
            }
            catch (Exception e2) {
                // empty catch block
            }
            try {
                this.lConnection.close();
                this.lConnection = Lock.getDatabase().connect(Lock.getUser(), Lock.getPassword());
                stmt = new TestStatement((TestCase)this, this.lConnection);
                for (i3 = 1; i3 <= transactionCount; ++i3) {
                    stmt.execute("drop user locku" + i3);
                }
                stmt.executeUpdate("drop user dttest");
                stmt.close();
                this.lConnection.close();
            }
            catch (Exception e3) {}
            break block25;
            {
                catch (Exception e) {
                    this.handleExceptions(e);
                    Object var7_11 = null;
                    for (int i3 = 0; i3 < this.transactions.length; ++i3) {
                        if (this.transactions[i3] == null) continue;
                        this.transactions[i3].cancel();
                    }
                    try {
                        stmt.close();
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    try {
                        this.lConnection.close();
                        this.lConnection = Lock.getDatabase().connect(Lock.getUser(), Lock.getPassword());
                        stmt = new TestStatement((TestCase)this, this.lConnection);
                        for (int i4 = 1; i4 <= transactionCount; ++i4) {
                            stmt.execute("drop user locku" + i4);
                        }
                        stmt.executeUpdate("drop user dttest");
                        stmt.close();
                        this.lConnection.close();
                    }
                    catch (Exception e3) {}
                }
            }
            catch (Throwable throwable) {
                Object var7_12 = null;
                for (int i3 = 0; i3 < this.transactions.length; ++i3) {
                    if (this.transactions[i3] == null) continue;
                    this.transactions[i3].cancel();
                }
                try {
                    stmt.close();
                }
                catch (Exception e2) {
                    // empty catch block
                }
                try {
                    this.lConnection.close();
                    this.lConnection = Lock.getDatabase().connect(Lock.getUser(), Lock.getPassword());
                    stmt = new TestStatement((TestCase)this, this.lConnection);
                    for (int i4 = 1; i4 <= transactionCount; ++i4) {
                        stmt.execute("drop user locku" + i4);
                    }
                    stmt.executeUpdate("drop user dttest");
                    stmt.close();
                    this.lConnection.close();
                }
                catch (Exception e3) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    private void testDeadlocks() throws SQLException {
        this.startNewTestSequence("Deadlock detection - test with LOCK statement");
        this.startNewTestcase("table lock - table lock");
        this.t1.execute("lock table tab1 in exclusive mode");
        this.t2.execute("lock table tab2 in exclusive mode");
        this.t1.execute("lock table tab2 in exclusive mode");
        this.t2.execute("lock table tab1 in exclusive mode", 600, "Deadlock with two table locks.");
        this.startNewTestcase("table lock - row lock");
        this.t1.execute("lock row tab1 key i1 = " + this.ran.nextInt(tablesize) + " in exclusive mode");
        this.t2.execute("lock row tab2 key i1 = " + this.ran.nextInt(tablesize) + " in exclusive mode");
        this.t1.execute("lock table tab2 in exclusive mode");
        this.t2.execute("lock table tab1 in exclusive mode", 600, "Deadlock with concurrent table and row locks.");
        this.startNewTestcase("table lock - row lock - table lock - row lock");
        this.t1.execute("lock table tab1 in exclusive mode");
        this.t2.execute("lock row tab2 key i1 = " + this.ran.nextInt(tablesize) + " in exclusive mode");
        this.t1.execute("lock table tab2 in exclusive mode");
        this.t2.execute("lock row tab1 key i1 = " + this.ran.nextInt(tablesize) + " in exclusive mode", 600, "Deadlock with concurrent table and row locks.");
        this.startNewTestcase("row lock - table lock");
        this.t1.execute("lock table tab1 in exclusive mode");
        this.t2.execute("lock table tab2 in exclusive mode");
        this.t1.execute("lock row tab2 key i1 = " + this.ran.nextInt(tablesize) + " in exclusive mode");
        this.t2.execute("lock row tab1 key i1 = " + this.ran.nextInt(tablesize) + " in exclusive mode", 600, "Deadlock with concurrent table and row locks.");
        this.startNewTestcase("row lock - row lock on same table");
        this.t1.execute("lock row tab1 key i1 = 10 in exclusive mode");
        this.t2.execute("lock row tab1 key i1 = 20 in exclusive mode");
        this.t1.execute("lock row tab1 key i1 = 20 in exclusive mode");
        this.t2.execute("lock row tab1 key i1 = 10 in exclusive mode", 600, "Deadlock with row locks on one table.");
        this.startNewTestcase("row lock - row lock on different tables");
        this.t1.execute("lock row tab1 key i1 = 10 in exclusive mode");
        this.t2.execute("lock row tab2 key i1 = 20 in exclusive mode");
        this.t1.execute("lock row tab2 key i1 = 20 in exclusive mode");
        this.t2.execute("lock row tab1 key i1 = 10 in exclusive mode", 600, "Deadlock with row locks on different tables.");
        this.startNewTestcase("three row locks and one table lock on one table");
        this.t1.execute("lock row tab1 key i1 = 10 in exclusive mode");
        this.t2.execute("lock row tab1 key i1 = 20 in exclusive mode");
        this.t2.execute("lock row tab1 key i1 = 10 in exclusive mode");
        this.t1.execute("lock table tab1 in exclusive mode", 600, "Deadlock with row locks on different tables.");
        this.startNewTestcase("three table locks and one row");
        this.t1.execute("lock table tab1 in exclusive mode");
        this.t2.execute("lock table tab2 in exclusive mode");
        this.t1.execute("lock table tab2 in exclusive mode");
        this.t2.execute("lock row tab1 key i1 = 10 in exclusive mode", 600, "Deadlock with table and row locks.");
        this.startNewTestcase("deadlocks over three tables");
        this.t1.execute("lock table tab1 in exclusive mode");
        this.t2.execute("lock table tab2 in exclusive mode");
        this.t3.execute("lock table tab3 in exclusive mode");
        this.t1.execute("lock table tab2 in exclusive mode");
        this.t2.execute("lock table tab3 in exclusive mode");
        this.t3.execute("lock table tab1 in exclusive mode", 600, "Deadlock with three table locks.");
        this.t2.execute("rollback");
        this.startNewTestSequence("Deadlock detection - test with INSERT statement");
        this.startNewTestcase("table lock - row lock");
        this.t1.execute("insert into tab1 values (" + (tablesize + 10) + ", 123, 'asbg', 'adha' ) ");
        this.t2.execute("insert into tab2 values (" + (tablesize + 10) + ", 123, 'asbg', 'adha' ) ");
        this.t1.execute("lock table tab2 in exclusive mode");
        this.t2.execute("lock table tab1 in exclusive mode", 600, "Deadlock with concurrent table and row locks.");
        this.startNewTestcase("row lock - table lock");
        this.t1.execute("lock table tab1 in exclusive mode");
        this.t2.execute("lock table tab2 in exclusive mode");
        this.t1.execute("insert into tab2 values (" + (tablesize + 10) + ", 123, 'asbg', 'adha' ) ");
        this.t2.execute("insert into tab1 values (" + (tablesize + 10) + ", 123, 'asbg', 'adha' ) ", 600, "Deadlock with concurrent table and row locks.");
        this.startNewTestcase("table lock - row lock - table lock - row lock");
        this.t1.execute("lock table tab1 in exclusive mode");
        this.t2.execute("insert into tab2 values (" + (tablesize + 9) + ", 123, 'asbg', 'adha' ) ");
        this.t1.execute("lock table tab2 in exclusive mode");
        this.t2.execute("insert into tab1 values (" + (tablesize + 9) + ", 123, 'asbg', 'adha' ) ", 600, "Deadlock with concurrent table and row locks.");
        this.startNewTestcase("row lock - row lock on same table");
        this.t1.execute("insert into tab1 values (" + (tablesize + 11) + ", 123, 'asbg', 'adha' ) ");
        this.t2.execute("insert into tab1 values (" + (tablesize + 12) + ", 123, 'asbg', 'adha' ) ");
        this.t1.execute("insert into tab1 values (" + (tablesize + 12) + ", 123, 'asbg', 'adha' ) ");
        this.t2.execute("insert into tab1 values (" + (tablesize + 11) + ", 123, 'asbg', 'adha' ) ", 600, "Deadlock with row locks on one table.");
        this.startNewTestcase("row lock - row lock on different tables");
        this.t1.execute("insert into tab1 values (" + (tablesize + 13) + ", 123, 'asbg', 'adha' ) ");
        this.t2.execute("insert into tab2 values (" + (tablesize + 13) + ", 123, 'asbg', 'adha' ) ");
        this.t1.execute("insert into tab2 values (" + (tablesize + 13) + ", 123, 'asbg', 'adha' ) ");
        this.t2.execute("insert into tab1 values (" + (tablesize + 13) + ", 123, 'asbg', 'adha' ) ", 600, "Deadlock with row locks on different tables.");
        this.startNewTestcase("three row locks and one table lock on different tables");
        this.t1.execute("insert into tab1 values (" + (tablesize + 14) + ", 123, 'asbg', 'adha' ) ");
        this.t2.execute("insert into tab2 values (" + (tablesize + 14) + ", 123, 'asbg', 'adha' ) ");
        this.t1.execute("insert into tab2 values (" + (tablesize + 14) + ", 123, 'asbg', 'adha' ) ");
        this.t2.execute("lock table tab1 in exclusive mode", 600, "Deadlock with row locks on different tables.");
        this.startNewTestcase("three table locks and one row");
        this.t1.execute("lock table tab1 in exclusive mode");
        this.t2.execute("lock table tab2 in exclusive mode");
        this.t1.execute("lock table tab2 in exclusive mode");
        this.t2.execute("insert into tab1 values (" + (tablesize + 15) + ", 123, 'asbg', 'adha' ) ", 600, "Deadlock with table and row locks.");
    }

    private void testDeadlockDetectionDepth() {
        this.startNewTestSequence("DEADLOCK_DETECTION parameter");
        this.subTestDeadlockDetectionDepth(4);
        this.subTestDeadlockDetectionDepth(transactionCount - 2);
        this.startNewTestcase("test DEADLOCK_DETECTION=0 (OFF)");
        Lock.setDbParameter(REQUEST_TIMEOUT, 0);
        this.reinitTransactions();
        this.t1.execute("lock table tab1 in exclusive mode");
        this.t2.execute("lock table tab2 in exclusive mode");
        this.t1.execute("lock table tab2 in exclusive mode", 500, "Deadlock detection should be off.");
        this.t2.execute("lock table tab1 in exclusive mode", 500, "Deadlock detection should be off.");
    }

    private void subTestDeadlockDetectionDepth(int depth) {
        int i;
        this.startNewTestcase("test DEADLOCK_DETECTION=" + depth + " with " + (depth + 1) + " transactions.\n This should detect deadlocks between " + (depth + 1) + " transactions.");
        Lock.setDbParameter(REQUEST_TIMEOUT, depth);
        this.reinitTransactions();
        for (i = 1; i <= depth + 1; ++i) {
            this.transactions[i - 1].execute("lock table tab" + i + " in exclusive mode");
        }
        for (i = 1; i <= depth + 1; ++i) {
            if (i < depth + 1) {
                this.transactions[i - 1].execute("lock table tab" + (i + 1) + " in exclusive mode");
                continue;
            }
            this.transactions[i - 1].execute("lock table tab1 in exclusive mode", 600, "Deadlock with table locks. Should be detected.");
        }
        for (i = depth; i > 0; --i) {
            this.transactions[i - 1].rollback();
        }
        this.startNewTestcase("test DEADLOCK_DETECTION=" + depth + " with " + (depth + 2) + " transactions.\n Deadlocks between " + (depth + 2) + " transaction should not be detected.");
        for (i = 1; i <= depth + 2; ++i) {
            this.transactions[i - 1].execute("lock table tab" + i + " in exclusive mode");
        }
        for (i = 1; i <= depth + 2; ++i) {
            if (i < depth + 2) {
                this.transactions[i - 1].execute("lock table tab" + (i + 1) + " in exclusive mode", 500, "Deadlock with table locks. Should not be detected.");
                continue;
            }
            this.transactions[i - 1].execute("lock table tab1 in exclusive mode", 500, "Deadlock with table locks. Should not be detected.");
        }
        for (i = depth + 1; i > 0; --i) {
            this.transactions[i - 1].rollback();
        }
    }

    protected void rollback() {
        for (int i = 0; i < this.transactions.length; ++i) {
            this.transactions[i].rollback();
        }
    }

    protected void reinitTransactions() {
        for (int i = 0; i < this.transactions.length; ++i) {
            this.transactions[i].reinitConnection();
        }
    }

    private String ranString(int length) {
        char[] c = new char[length];
        for (int i = 0; i < length; ++i) {
            c[i] = CHARACTERS[this.ran.nextInt(CHARACTERS.length)];
        }
        return new String(c);
    }

    protected void finishOldTestCase() {
        this.rollback();
        this.sync(EXECUTION_TIME);
        int errorcount = this.currentTestCaseErrors.size();
        if (errorcount > 0) {
            String error = "Test sequence: " + this.currentTestSequence + "\n" + "Test case: " + this.currentTestCase + "\n" + errorcount + " statements failed:\n";
            Iterator it = this.currentTestCaseErrors.iterator();
            while (it.hasNext()) {
                error = error + "\n" + it.next().toString() + "\n";
            }
            this.addMessage("Test case failed", 'E', error);
            this.addTestcaseTraceToProtocol();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sync(int statementnumber) {
        Object object = this.sync_mutex;
        synchronized (object) {
            while (CURRENT_EXECUTION_TIME < statementnumber + 1 || this.areSomeThreadsExecutingStatements()) {
                try {
                    this.sync_mutex.wait();
                }
                catch (InterruptedException e) {
                    this.addMessage("Wait interrupted", 'W', e.getMessage());
                }
            }
        }
    }

    protected boolean areSomeThreadsExecutingStatements() {
        for (int i = 0; i < this.transactions.length; ++i) {
            if (!this.transactions[i].isExecutingStatement()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTestcaseTraceToProtocol() {
        Object object = this.sync_mutex;
        synchronized (object) {
            TreeMap<String, StringBuffer> strings = new TreeMap<String, StringBuffer>(new Comparator(){

                public int compare(Object o1, Object o2) {
                    if (o1 == o2) {
                        return 0;
                    }
                    String s1 = (String)o1;
                    String s2 = (String)o2;
                    return Integer.valueOf(s1.substring(1)).compareTo(Integer.valueOf(s2.substring(1)));
                }
            });
            StringBuffer timeLine = new StringBuffer();
            int length = 0;
            LinkedList l = new LinkedList(this.currentTestCaseStatements.keySet());
            Collections.sort(l);
            Iterator<Object> it = l.iterator();
            while (it.hasNext()) {
                Integer i = (Integer)it.next();
                String s = (String)this.currentTestCaseStatements.get(i);
                int j = s.indexOf(":");
                String t = s.substring(0, j);
                s = s.substring(j + 1);
                StringBuffer row = (StringBuffer)strings.get(t);
                if (row == null) {
                    row = new StringBuffer(t);
                    row.append(":");
                }
                this.rightFill(row, length + 1);
                this.rightFill(timeLine, row.length());
                timeLine.append(i);
                s = s.replaceAll("lock table", "lock");
                s = s.replaceAll(" in \\w+ mode", "");
                s = s.replaceAll("lock row (\\w+) key i1 = (\\d*)", "lock row $1 i=$2");
                s = s.replaceAll("insert into (\\w+) values \\(\\s?(\\d*).*", "ins $1 i=$2");
                row.append(s);
                length = row.length();
                strings.put(t, row);
            }
            it = strings.keySet().iterator();
            String result = timeLine.append('\n').toString();
            while (it.hasNext()) {
                result = result + ((StringBuffer)strings.get(it.next())).append('\n').toString();
            }
            this.addMessage("Testcase Trace", 'T', result);
        }
    }

    private void rightFill(StringBuffer b, int length) {
        if (b.length() < length) {
            int k = length - b.length();
            char[] chararray = new char[k];
            for (int i1 = 0; i1 < chararray.length; ++i1) {
                chararray[i1] = 32;
            }
            b.append(chararray);
        }
    }

    private void startNewTestcase(String description) {
        this.finishOldTestCase();
        if (DEBUG) {
            System.out.println("Test case: " + description);
        }
        this.currentTestCaseStatements.clear();
        this.currentTestCaseErrors.clear();
        this.currentTestCase = description;
    }

    private void startNewTestSequence(String description) {
        this.finishOldTestCase();
        if (DEBUG) {
            System.out.println("Test sequence: " + description);
        }
        this.currentTestSequence = description;
    }

    private static void setDbParameter(int requestTimeout, int deadlockDetection) {
        Lock.addGlobalMessage((String)"Set db_parameter", (char)'T', (String)("Set db parameter:\nREQUEST_TIMEOUT to " + requestTimeout + "\n" + "DEADLOCK_DETECTION to " + deadlockDetection + "\n" + "Restart database!"));
        try {
            DBM dbm = DBM.dbDBM((String)Lock.getDatabase().getHost(), (String)Lock.getDatabase().getName());
            dbm.cmd("USER_LOGON " + Lock.getDatabase().getDBMUser() + "," + Lock.getDatabase().getDBMPassword(), true);
            dbm.cmd("param_put REQUEST_TIMEOUT " + requestTimeout);
            dbm.cmd("param_put DEADLOCK_DETECTION " + deadlockDetection);
            dbm.cmd("db_restart");
            dbm.release();
        }
        catch (RTEException e) {
            Lock.addGlobalMessage((String)"Error while set db parameters", (char)'E', (String)e.getMessage());
        }
        catch (DBMException e) {
            Lock.addGlobalMessage((String)"Error while set db parameters", (char)'E', (String)e.getMessage());
        }
    }

    private class StatementExecuteThread
    extends Thread {
        private LinkedList statementQueue = new LinkedList();
        private boolean cancelled = false;
        private boolean finish = false;
        private Statement stmt = null;
        private boolean executingStatement = false;
        private boolean wasRollbacked = true;

        public StatementExecuteThread(Statement stmt) {
            this.stmt = stmt;
            this.start();
        }

        public synchronized int execute(String statement) {
            return this.execute(statement, 0, "");
        }

        public synchronized int rollback() {
            if (!this.wasRollbacked) {
                this.wasRollbacked = true;
                return this.execute("rollback", 0, "", true);
            }
            return EXECUTION_TIME;
        }

        public synchronized int execute(String statement, int expectedErrorCode, String message) {
            this.wasRollbacked = false;
            return this.execute(statement, expectedErrorCode, message, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized int execute(String statement, int expectedErrorCode, String message, boolean hideInProtocol) {
            LinkedList linkedList = this.statementQueue;
            synchronized (linkedList) {
                EXECUTION_TIME++;
                this.statementQueue.add(new StatementType(statement, EXECUTION_TIME, expectedErrorCode, message));
                if (!hideInProtocol) {
                    Lock.this.currentTestCaseStatements.put(new Integer(EXECUTION_TIME), this.getName() + ": " + statement);
                }
                this.debug("Statement added to queue");
                this.statementQueue.notify();
            }
            this.notify();
            return EXECUTION_TIME;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            this.cancelled = true;
            StatementExecuteThread statementExecuteThread = this;
            synchronized (statementExecuteThread) {
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finish() {
            this.finish = true;
            StatementExecuteThread statementExecuteThread = this;
            synchronized (statementExecuteThread) {
                this.notify();
            }
        }

        public void reinitConnection() {
            this.wasRollbacked = false;
            this.rollback();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block18: while (!this.cancelled) {
                String sql = null;
                int executionTime = 0;
                StatementType st = null;
                Object object = this.statementQueue;
                synchronized (object) {
                    if (this.statementQueue.isEmpty()) {
                        try {
                            this.debug("Waiting for statements. ");
                            this.statementQueue.wait();
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        continue;
                    }
                    st = (StatementType)this.statementQueue.removeFirst();
                    sql = st.getSql();
                    executionTime = st.getExecutionTime();
                }
                if (sql != null) {
                    block24: {
                        object = EXECUTION_TIME_MUTEX;
                        synchronized (object) {
                            while (executionTime != CURRENT_EXECUTION_TIME) {
                                try {
                                    EXECUTION_TIME_MUTEX.wait();
                                }
                                catch (InterruptedException e) {
                                    Lock.this.addMessage("Wait interrupted", 'W', e.getMessage());
                                }
                                if (!this.cancelled) continue;
                                break block18;
                            }
                        }
                        StatementExecuteThread.yield();
                        try {
                            this.debug("Execute statement " + executionTime + ": \"" + sql + "\"");
                            this.executingStatement = true;
                            StatementExecuteThread.yield();
                            object = EXECUTION_TIME_MUTEX;
                            synchronized (object) {
                                CURRENT_EXECUTION_TIME++;
                                EXECUTION_TIME_MUTEX.notifyAll();
                            }
                            this.stmt.execute(sql);
                            this.debug("Executed statement " + executionTime + " successfully");
                            if (st.getExpectedError() != 0) {
                                Lock.this.currentTestCaseErrors.add("Error expected\n" + this.getName() + " at " + executionTime + ": \"" + sql + "\"\n" + "Expetced the error " + st.getExpectedError() + " but statement was successful\n" + st.getErrorMessage());
                            }
                        }
                        catch (SQLException e) {
                            this.debug("Statement " + executionTime + " failed with " + e.getErrorCode());
                            if (st.getExpectedError() == 0) {
                                Lock.this.currentTestCaseErrors.add("Unexpected Error\n" + this.getName() + " at " + executionTime + ": \"" + sql + "\"\n" + "No error was expected but get: " + e.getMessage());
                            }
                            if (st.getExpectedError() == e.getErrorCode()) break block24;
                            Lock.this.currentTestCaseErrors.add("Wrong error\n" + this.getName() + " at " + executionTime + ": \"" + sql + "\"\n" + "Expetced the error " + st.getExpectedError() + " but get: " + e.getMessage() + "\n" + st.getErrorMessage());
                        }
                    }
                    this.executingStatement = false;
                    object = Lock.this.sync_mutex;
                    synchronized (object) {
                        Lock.this.sync_mutex.notifyAll();
                        continue;
                    }
                }
                if (!this.finish) continue;
                this.debug("I have finshed.");
                break;
            }
        }

        private void debug(String message) {
            if (DEBUG) {
                System.out.println(this.getName() + " at " + CURRENT_EXECUTION_TIME + ": " + message);
            }
        }

        public boolean isExecutingStatement() {
            return this.executingStatement;
        }

        private class StatementType {
            private int executionTime;
            private String sql;
            private int expectedError;
            private String errorMessage;

            public StatementType(String sql, int executionTime, int expectedError, String errorMessage) {
                this.sql = sql;
                this.executionTime = executionTime;
                this.expectedError = expectedError;
                this.errorMessage = errorMessage;
            }

            public String getSql() {
                return this.sql;
            }

            public int getExecutionTime() {
                return this.executionTime;
            }

            protected String getErrorMessage() {
                return this.errorMessage;
            }

            protected int getExpectedError() {
                return this.expectedError;
            }
        }
    }
}

