/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.sqltest.ddl;

import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.testcase.TestPreparedStatement;
import com.sap.sapdb.testframe.testcase.TestStatement;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;

public class AlterTableLong
extends TestCase {
    private static final String mExUser = "SUT";
    private static final String mExPassword = "SUT";

    public static void cleanUp() throws TestCaseException {
        System.out.println("End of " + AlterTableLong.getTestClassId());
    }

    public static String getMinimumRelease() {
        return "7.4.3";
    }

    public static String getTestClassId() {
        return "AlterTableLong";
    }

    public static long getTimeout() {
        return 300000L;
    }

    public static void prepare() throws TestCaseException {
        Connection myConnection = null;
        TestStatement myStatement = null;
        System.out.println("Start of " + AlterTableLong.getTestClassId());
        try {
            myConnection = AlterTableLong.getDatabase().connect(AlterTableLong.getUser(), AlterTableLong.getPassword());
            myStatement = new TestStatement(null, myConnection);
            myStatement.enableExceptions(false);
            myStatement.executeUpdate("Drop user SUT");
            myStatement.enableExceptions(true);
            myStatement.executeUpdate("Create user SUT password SUT resource not exclusive");
            myStatement.close();
            myConnection.close();
        }
        catch (Exception e) {
            AlterTableLong.addGlobalMessage((String)"Method prepare", (char)'E', (String)"preparation failed");
            throw new TestCaseException("Error during preparation: " + e.getClass() + e.getMessage());
        }
        finally {
            try {
                myStatement.close();
            }
            catch (Exception e) {}
            try {
                myConnection.commit();
                myConnection.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Connection myConnection = null;
        Object myStatement = null;
        boolean ONE_AT_A_TIME = true;
        try {
            myConnection = AlterTableLong.getDatabase().connect("SUT", "SUT");
            myConnection.setAutoCommit(false);
            this.longValueTest(myConnection, 0x200000);
            int noOfInserts = 2;
            this.alterTableAddLong(myConnection, new String[]{"LONG"}, new int[0], noOfInserts, true, true);
            this.alterTableAddLong(myConnection, new String[]{"LONGFILE"}, new int[0], noOfInserts, true, true);
            this.alterTableAddLong(myConnection, new String[]{"LONG"}, new int[]{0}, noOfInserts, true, true);
            this.alterTableAddLong(myConnection, new String[]{"LONGFILE"}, new int[]{0}, noOfInserts, true, true);
            this.alterTableAddLong(myConnection, new String[]{"LONG", "LONGFILE"}, new int[0], noOfInserts, true, true);
            this.alterTableAddLong(myConnection, new String[]{"LONGFILE", "LONG"}, new int[0], noOfInserts, true, true);
            this.alterTableAddLong(myConnection, new String[]{"LONG", "LONGFILE"}, new int[]{1}, noOfInserts, false, true);
            this.alterTableAddLong(myConnection, new String[]{"LONGFILE", "LONG"}, new int[]{1}, noOfInserts, false, true);
            this.alterTableAddLong(myConnection, new String[]{"LONG", "LONGFILE"}, new int[]{0, 1}, noOfInserts, false, true);
            this.alterTableAddLong(myConnection, new String[]{"LONGFILE", "LONG"}, new int[]{0, 1}, noOfInserts, false, false);
            this.alterTableAddLong(myConnection, new String[]{"LONG", "LONGFILE", "LONGFILE"}, new int[0], noOfInserts, true, true);
            this.alterTableAddLong(myConnection, new String[]{"LONGFILE", "LONGFILE", "LONG"}, new int[0], noOfInserts, true, true);
            this.alterTableAddLong(myConnection, new String[]{"LONG", "LONG", "LONGFILE"}, new int[0], noOfInserts, true, true);
            this.alterTableAddLong(myConnection, new String[]{"LONG", "LONGFILE", "LONGFILE"}, new int[]{2}, noOfInserts, false, true);
            this.alterTableAddLong(myConnection, new String[]{"LONGFILE", "LONGFILE", "LONG"}, new int[]{2}, noOfInserts, false, true);
            this.alterTableAddLong(myConnection, new String[]{"LONG", "LONG", "LONGFILE"}, new int[]{2}, noOfInserts, false, true);
            this.alterTableAddLong(myConnection, new String[]{"LONG", "LONGFILE", "LONGFILE"}, new int[]{1, 2}, noOfInserts, false, true);
            this.alterTableAddLong(myConnection, new String[]{"LONGFILE", "LONGFILE", "LONG"}, new int[]{1, 2}, noOfInserts, false, false);
            this.alterTableAddLong(myConnection, new String[]{"LONG", "LONG", "LONGFILE"}, new int[]{0, 1}, noOfInserts, false, true);
            this.alterTableAddLong(myConnection, new String[]{"LONG", "LONG", "LONGFILE"}, new int[]{0, 1}, noOfInserts, false, false);
        }
        catch (Exception e) {
            this.handleExceptions(e);
        }
        finally {
            try {
                myStatement.close();
            }
            catch (Exception e) {}
            try {
                myConnection.rollback();
                myConnection.close();
            }
            catch (Exception e) {}
        }
    }

    private void alterTableAddLong(Connection c, String[] longColsAdded, int[] dropOrder, int noOfInserts, boolean addSingle, boolean dropSingle) throws SQLException, TestCaseException {
        int i;
        int rowNo;
        int i2;
        int i3;
        StringBuffer buf = new StringBuffer(100);
        TestStatement s = new TestStatement((TestCase)this, c, 1005, 1007);
        s.enableExceptions(false);
        s.execute("DROP TABLE CE1");
        s.enableExceptions(true);
        this.addMessage("alterTableAddLong", 'I', "Adding: " + Arrays.asList(longColsAdded).toString());
        s.execute("CREATE TABLE CE1 (KEY1 CHAR(15), COL1 CHAR(15), COL2 INT, PRIMARY KEY (KEY1))");
        if (addSingle) {
            for (i3 = 0; i3 < longColsAdded.length; ++i3) {
                s.execute("ALTER TABLE CE1 ADD " + this.extraName(i3) + " " + longColsAdded[i3]);
            }
        } else {
            for (i3 = 0; i3 < longColsAdded.length; ++i3) {
                if (i3 != 0) {
                    buf.append(", ");
                }
                buf.append(this.extraName(i3) + " " + longColsAdded[i3]);
            }
            s.execute("ALTER TABLE CE1 ADD " + buf);
        }
        for (int rowNo2 = 0; rowNo2 < noOfInserts; ++rowNo2) {
            buf.setLength(0);
            for (i2 = 0; i2 < longColsAdded.length; ++i2) {
                if (i2 != 0) {
                    buf.append(",");
                }
                buf.append("'" + this.extraArg(rowNo2, i2) + "'");
            }
            s.execute("INSERT INTO CE1 VALUES ('key" + rowNo2 + "', " + "'col" + rowNo2 + "', " + rowNo2 + ", " + buf + ")");
        }
        c.commit();
        ResultSet result = s.executeQuery("SELECT * FROM CE1");
        if (s.getResultCounter() != noOfInserts) {
            this.addMessage(this.nextStep("alterTableAddLong"), 'E', "mismatching result counter", s.getSqlString());
        } else {
            rowNo = 0;
            while (result.next()) {
                this.verifyRegularColumns(result, rowNo);
                for (i = 0; i < longColsAdded.length; ++i) {
                    if (result.getString(this.extraName(i)).equals(this.extraArg(rowNo, i))) continue;
                    this.addMessage(this.nextStep("alterTableAddLong"), 'E', "result mismatch: " + result.getString(this.extraName(i)) + ", " + this.extraArg(rowNo, i));
                }
                ++rowNo;
            }
        }
        if (dropSingle) {
            for (i2 = 0; i2 < dropOrder.length; ++i2) {
                s.execute("ALTER TABLE CE1 DROP " + this.extraName(dropOrder[i2]));
            }
        } else {
            buf.setLength(0);
            for (i2 = 0; i2 < dropOrder.length; ++i2) {
                buf.append(this.extraName(dropOrder[i2]) + ",");
            }
            buf.setLength(buf.length() - 1);
            s.execute("ALTER TABLE CE1 DROP " + buf);
        }
        c.commit();
        result = s.executeQuery("SELECT * FROM CE1");
        if (s.getResultCounter() != noOfInserts) {
            this.addMessage(this.nextStep("alterTableAddLong"), 'E', "mismatching result counter", s.getSqlString());
        } else {
            rowNo = 0;
            while (result.next()) {
                this.verifyRegularColumns(result, rowNo);
                for (i = 0; i < longColsAdded.length; ++i) {
                    if (this.contains(dropOrder, i) || result.getString(this.extraName(i)).equals(this.extraArg(rowNo, i))) continue;
                    this.addMessage(this.nextStep("alterTableAddLong"), 'E', "result mismatch: " + result.getString(this.extraName(i)) + ", " + this.extraArg(rowNo, i));
                }
                ++rowNo;
            }
        }
        s.execute("DROP TABLE CE1");
        c.commit();
    }

    private boolean verifyRegularColumns(ResultSet result, int rowNo) throws SQLException {
        boolean ok = true;
        if (!result.getString("key1").equals("key" + rowNo)) {
            this.addMessage(this.nextStep("alterTableAddLong"), 'E', "result mismatch for column 'key1': " + result.getString("key1") + ", " + "key" + rowNo);
            ok = false;
        }
        if (!result.getString("col1").equals("col" + rowNo)) {
            this.addMessage(this.nextStep("alterTableAddLong"), 'E', "result mismatch for column 'col1': " + result.getString("col1") + ", " + "col" + rowNo);
            ok = false;
        }
        if (result.getInt("col2") != rowNo) {
            this.addMessage(this.nextStep("alterTableAddLong"), 'E', "result mismatch for column 'col2': " + result.getInt("col2") + ", " + rowNo);
            ok = false;
        }
        return ok;
    }

    private boolean contains(int[] array, int number) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != number) continue;
            return true;
        }
        return false;
    }

    private String extraName(int index) {
        return "extra" + index;
    }

    private String extraArg(int rowNumber, int number) {
        return new String("ABC" + rowNumber + "-" + number);
    }

    private void longValueTest(Connection c, int size) throws SQLException, TestCaseException {
        int blockSize = 10240;
        TestStatement s = new TestStatement((TestCase)this, c);
        this.addMessage(this.nextStep("longValueTest"), 'I', "LONG size:" + size + " bytes.");
        s.enableExceptions(false);
        s.execute("DROP TABLE CE1");
        s.enableExceptions(true);
        s.execute("CREATE TABLE CE1 (KEY1 CHAR(15), COL1 CHAR(15), PRIMARY KEY (KEY1))");
        s.execute("ALTER TABLE CE1 ADD EXTRA1 LONG");
        try {
            TestPreparedStatement prepS = new TestPreparedStatement(null, c, "INSERT CE1 values (?,?,?)");
            prepS.setString(1, "key");
            prepS.setString(2, "col1");
            prepS.setAsciiStream(3, (InputStream)new AsciiStream(size), size);
            prepS.execute();
            ResultSet result = s.executeQuery("SELECT EXTRA1 FROM CE1");
            while (result.next()) {
                InputStream fromTableStream = result.getAsciiStream("EXTRA1");
                AsciiStream referenceStream = new AsciiStream(size);
                long resultPos = 0L;
                byte[] tableBuf = new byte[blockSize];
                byte[] referenceBuf = new byte[blockSize];
                block3: while (((InputStream)referenceStream).available() > 0) {
                    fromTableStream.read(tableBuf, 0, blockSize);
                    ((InputStream)referenceStream).read(referenceBuf, 0, blockSize);
                    int i = 0;
                    while (i < blockSize) {
                        if (tableBuf[i] != referenceBuf[i]) {
                            this.addMessage(this.nextStep("longValueTest"), 'E', "result mismatch position: " + resultPos);
                            continue block3;
                        }
                        ++i;
                        ++resultPos;
                    }
                }
            }
        }
        catch (IOException e) {
            this.addMessage(this.nextStep("longValueTest"), 'E', "problem with streams: " + e.getMessage());
        }
        s.execute("DROP TABLE CE1");
        c.commit();
    }

    static class AsciiStream
    extends InputStream {
        protected long size;
        protected long position;

        public AsciiStream(long size) {
            this.size = size;
            this.position = 0L;
        }

        public int available() throws IOException {
            return (int)(this.size - this.position);
        }

        public void close() {
        }

        public void mark(int readlimit) {
        }

        public boolean markSupported() {
            return false;
        }

        public int read() throws IOException {
            if (this.position >= this.size) {
                return -1;
            }
            byte result = this.currentByte();
            ++this.position;
            return result;
        }

        private byte currentByte() {
            return (byte)(48 + (byte)(this.position % 10L));
        }

        public int read(byte[] b, int off, int len) throws IOException {
            if (len == 0) {
                return 0;
            }
            long result = Math.min((long)len, this.size - this.position);
            if (result == 0L) {
                return -1;
            }
            int i = 0;
            while ((long)i < result) {
                b[off + i] = this.currentByte();
                ++this.position;
                ++i;
            }
            return (int)result;
        }

        public void reset() throws IOException {
            this.position = 0L;
        }

        public long skip(long count) throws IOException {
            long result = Math.min(count, this.size - this.position);
            this.position += count;
            return result;
        }

        public static void main(String[] args) throws IOException {
            long streamLen = Long.valueOf(args[0]);
            AsciiStream stream = new AsciiStream(streamLen);
            byte[] buf = new byte[1024];
            boolean atEnd = false;
            int pos = 0;
            while (!atEnd) {
                int chunkSize = stream.read(buf);
                if (chunkSize == 0) {
                    atEnd = true;
                    continue;
                }
                System.out.println("at " + (pos += chunkSize) + " of " + streamLen);
            }
        }

        public long getPosition() {
            return this.position;
        }

        public String toString() {
            return "<generators.AsciiStream (" + this.size + ")>";
        }
    }
}

