/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.sut;

import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDatabaseSap;
import com.sap.sapdb.testframe.driver.TestDriver;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.testcase.TestStatement;
import com.sap.sapdb.testframe.utilities.Execute;
import com.sap.sapdb.testframe.utilities.Zipper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.StringTokenizer;

public class SutStarter
extends TestCase {
    private static String instRoot;
    private static String jtestRoot;
    private static String kernel;
    private static String codeType;
    private static String dbName;
    private static String fileSep;
    private static String zipFileName;
    private static boolean diffErr;
    private static boolean enableKBStackUsage;
    private static boolean preTest;
    private static String releaseAndQALevel;
    private static boolean patchISUTFile;

    public static long getTimeout() {
        return 50400000L;
    }

    public static void prepare() throws TestCaseException {
        instRoot = mTestDriverOptions.getProperty("DBRoot");
        if (instRoot == null) {
            SutStarter.addGlobalMessage((String)"", (char)'E', (String)"Error in prepare(). DBROOT not set.");
        }
        if ((jtestRoot = System.getProperty("jtest.root")) == null) {
            SutStarter.addGlobalMessage((String)"", (char)'E', (String)"Error in prepare(). Property jtest.root not set.");
            throw new TestCaseException("Error in prepare()");
        }
        File fJtestRoot = new File(jtestRoot);
        if (!fJtestRoot.isDirectory()) {
            SutStarter.addGlobalMessage((String)"", (char)'E', (String)("Error in prepare(). Property jtest.root = \"" + jtestRoot + "\" not found."));
            throw new TestCaseException("Error in prepare()");
        }
        preTest = SutStarter.getParameterBoolean((String)"preTest", (boolean)false);
        kernel = SutStarter.getParameterString((String)"kernel", (String)"slow");
        codeType = SutStarter.getParameterString((String)"codetype", (String)"");
        zipFileName = SutStarter.getParameterString((String)"zipFile", (String)"sutprt.zip");
        releaseAndQALevel = SutStarter.getParameterString((String)"release", (String)"none");
        diffErr = SutStarter.getParameterString((String)"diffErr", (String)"false").equalsIgnoreCase("true");
        enableKBStackUsage = SutStarter.getParameterBoolean((String)"StoreKBStackUsage", (boolean)false);
        dbName = SutStarter.getDatabase().getName();
        patchISUTFile = SutStarter.getParameterBoolean((String)"patchISUTFile", (boolean)false);
        fileSep = System.getProperty("file.separator");
        if (preTest) {
            try {
                SutStarter.copyFile(new File(jtestRoot + fileSep + "sut" + fileSep + "ISUT"), new File(jtestRoot + fileSep + "sut" + fileSep + "ISUT.orig"));
                SutStarter.overwriteIsut();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (patchISUTFile) {
            SutStarter.patchISUTFile(codeType);
        }
        String cmd = "perl " + jtestRoot + fileSep + "sut" + fileSep + "sutinst.pl -j " + jtestRoot;
        if (instRoot != null && !instRoot.equals("")) {
            cmd = cmd + " -I " + instRoot;
        }
        cmd = cmd + " -d " + dbName;
        StringBuffer sb = new StringBuffer();
        Execute exc = new Execute(cmd, null, sb);
        exc.exec();
        System.out.println("Executing command:\n" + cmd);
        System.out.println(sb.toString());
        SutStarter.addGlobalMessage((String)"", (char)'I', (String)("Executing command:\n" + cmd));
        SutStarter.addGlobalMessage((String)"", (char)'I', (String)("Output of sutinst.pl:\n" + sb.toString()));
        int errorCode = 0;
        errorCode = exc.getExitValue();
        if (errorCode > 255) {
            errorCode -= 65536;
        } else if (errorCode > 127) {
            errorCode -= 256;
        }
        if (errorCode != 0) {
            SutStarter.addGlobalMessage((String)"", (char)'E', (String)(cmd + " => RC = " + errorCode));
            SutStarter.addGlobalMessage((String)"", (char)'E', (String)"Error in prepare(). sutinst failed.");
            throw new TestCaseException("Error in prepare()");
        }
        SutStarter.addGlobalMessage((String)"", (char)'I', (String)(cmd + " successful!"));
    }

    public void run() {
        String ChangeList;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
        String monPrimkey = "driverStarted='" + dateFormat.format(this.getTestDriverStart()) + "'";
        this.setStatus("Run sutrun.pl");
        String monUser = mTestDriverOptions.getProperty("SaveDBUser");
        String monPwd = mTestDriverOptions.getProperty("SaveDBUser-password");
        String monHost = mTestDriverOptions.getProperty("SaveDBHost");
        String monName = mTestDriverOptions.getProperty("SaveDBName");
        int arrLength = 11;
        if (instRoot != null && !instRoot.equals("")) {
            arrLength += 2;
        }
        if (codeType != null && !codeType.equals("")) {
            arrLength += 2;
        }
        String[] cmdArr = new String[arrLength];
        int i = 0;
        cmdArr[i++] = "perl";
        cmdArr[i++] = jtestRoot + fileSep + "sut" + fileSep + "sutrun.pl";
        cmdArr[i++] = "-j";
        cmdArr[i++] = jtestRoot;
        if (instRoot != null && !instRoot.equals("")) {
            cmdArr[i++] = "-I";
            cmdArr[i++] = instRoot;
        }
        cmdArr[i++] = "-m";
        cmdArr[i++] = "\"" + monPrimkey + "," + monHost + "," + monName + "," + monUser + "," + monPwd + "\"";
        cmdArr[i++] = "-d";
        cmdArr[i++] = dbName;
        cmdArr[i++] = "-v";
        cmdArr[i++] = kernel;
        if (codeType != null && !codeType.equals("")) {
            cmdArr[i++] = "-c";
            cmdArr[i++] = codeType;
        }
        cmdArr[i++] = "-a";
        if (enableKBStackUsage) {
            SutStarter.addGlobalMessage((String)"run()", (char)'I', (String)"enable kb stack usage");
            System.out.println("enable kb stack usage");
            try {
                ((TestDatabaseSap)TestCase.getDatabase()).executeDBMcmd("param_directput SHOW_MAX_KB_STACK_USE YES");
            }
            catch (Exception exp) {
                SutStarter.addGlobalMessage((String)"run()", (char)'W', (String)("'param_directput SHOW_MAX_KB_STACK_USE YES' fails\n" + exp.getLocalizedMessage()));
            }
        }
        long startTime = System.currentTimeMillis();
        StringBuffer sb = new StringBuffer();
        Execute exc = new Execute(cmdArr, null, sb);
        System.out.println("Executing command:\n" + this.array2String(cmdArr));
        exc.exec();
        long endTime = System.currentTimeMillis();
        System.out.println(sb.toString());
        SutStarter.addGlobalMessage((String)"", (char)'I', (String)("Executing command:\n" + this.array2String(cmdArr)));
        SutStarter.addGlobalMessage((String)"", (char)'I', (String)("Output of sutrun.pl:\n" + sb.toString()));
        int errorCode = 0;
        errorCode = exc.getExitValue();
        if (errorCode > 255) {
            errorCode -= 65536;
        } else if (errorCode > 127) {
            errorCode -= 256;
        }
        if (errorCode == 0) {
            SutStarter.addGlobalMessage((String)"", (char)'I', (String)(this.array2String(cmdArr) + " successful!"));
            SutStarter.addGlobalMessage((String)"", (char)'I', (String)"SUT finished with no differences.");
        } else {
            SutStarter.addGlobalMessage((String)"", (char)'I', (String)(this.array2String(cmdArr) + " => RC = " + errorCode));
            if (errorCode < 0) {
                SutStarter.addGlobalMessage((String)"", (char)'E', (String)"Error in run(). sutrun failed.");
            } else {
                SutStarter.addGlobalMessage((String)"", (char)'I', (String)("SUT finished with " + errorCode + " differences."));
            }
        }
        this.checkForDiffOrCore(sb.toString());
        StringBuffer contentOfTheFile = new StringBuffer();
        try {
            FileWriter specialWriter = new FileWriter(new File(jtestRoot + fileSep + "sut" + fileSep + "stdout_" + kernel + "_" + codeType + ".txt"));
            specialWriter.write(this.array2String(cmdArr));
            specialWriter.write("\n");
            specialWriter.write(sb.toString());
            specialWriter.close();
        }
        catch (IOException ioe) {
            this.addMessage(SutStarter.getTestClassId(), 'W', "Can not write the stdout file 'stdout_" + kernel + "_" + codeType + ".txt'. \nReason: " + ioe.getLocalizedMessage());
        }
        SimpleDateFormat mDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
        contentOfTheFile = new StringBuffer();
        contentOfTheFile.append("driverid=");
        contentOfTheFile.append(mDateFormat.format(TestDriver.getStartTime()));
        if (!releaseAndQALevel.equalsIgnoreCase("none")) {
            contentOfTheFile.append("\n");
            contentOfTheFile.append("release=");
            contentOfTheFile.append(releaseAndQALevel);
        }
        if (!(ChangeList = mTestDriverOptions.getProperty("ChangeListNumber")).equalsIgnoreCase("n/a")) {
            contentOfTheFile.append("\n");
            contentOfTheFile.append("changelist=");
            contentOfTheFile.append(ChangeList);
        }
        contentOfTheFile.append("\n\n");
        try {
            FileWriter specialWriter = new FileWriter(new File(this.getDataOutputPath() + fileSep + "sutresults.txt"));
            specialWriter.write(contentOfTheFile.toString());
            specialWriter.close();
        }
        catch (IOException ioe) {
            this.addMessage(SutStarter.getTestClassId(), 'W', "Can not write the special file 'sutresults.txt'. \nReason: " + ioe.getLocalizedMessage());
        }
        if (preTest) {
            try {
                SutStarter.copyFile(new File(jtestRoot + fileSep + "sut" + fileSep + "ISUT.orig"), new File(jtestRoot + fileSep + "sut" + fileSep + "ISUT"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (endTime - startTime < 60000L && !preTest) {
            SutStarter.addGlobalMessage((String)"run()", (char)'E', (String)("The script 'sutrun.pl' has finished in less than one minute. Runtime: " + (endTime - startTime) / 1000L + " sec. \nIt is almost certain that there have been undetected errors."));
        }
        try {
            ((TestDatabaseSap)TestCase.getDatabase()).executeDBMcmd("db_warm");
        }
        catch (Exception exp) {
            SutStarter.addGlobalMessage((String)"run()", (char)'I', (String)("the restart of the database fails\n" + exp.getLocalizedMessage()));
        }
        this.storeStackConsumeInQADB();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void storeStackConsumeInQADB() {
        String insertQRY = null;
        String myURL = null;
        Connection lConnection = null;
        TestStatement Stmt = null;
        try {
            SimpleDateFormat mDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
            String driverStarted = mDateFormat.format(this.getTestDriverStart());
            String MakeKey = mTestDriverOptions.getProperty("MakeKey");
            if (MakeKey == null || MakeKey.equalsIgnoreCase("0")) {
                this.addMessage("storeStackConsumeInQADB()", 'I', "No MakeKey given. No entry in QADB possible.");
                return;
            }
            String directoryForStackSaveFile = null;
            directoryForStackSaveFile = codeType == null || codeType.equals("") ? kernel : codeType;
            if (directoryForStackSaveFile == null || directoryForStackSaveFile.length() == 0) {
                this.addMessage("storeStackConsumeInQADB()", 'I', "No idea where the stack prot file is. No stack usage entries in QADB possible.");
                return;
            }
            String theProtFileAscii = null;
            theProtFileAscii = enableKBStackUsage ? jtestRoot + fileSep + "sut" + fileSep + directoryForStackSaveFile + fileSep + "KBstackusage.prt" : jtestRoot + fileSep + "sut" + fileSep + directoryForStackSaveFile + fileSep + "stackusage.prt";
            File theProtFile = new File(theProtFileAscii);
            if (!theProtFile.exists()) {
                this.addMessage("storeStackConsumeInQADB()", 'I', "File '" + theProtFileAscii + "' not found. No SUT stack usage entries in QADB possible.");
                return;
            }
            BufferedReader reader = new BufferedReader(new FileReader(theProtFile));
            String line = reader.readLine();
            StringTokenizer stForLine = null;
            String testName = null;
            int stackConsume = -1;
            int specialStackConsume = -1;
            int serverStackConsume = -1;
            String databaseHost = "PTS";
            if (mTestDriverOptions.getProperty("SaveDBHost") != null) {
                databaseHost = mTestDriverOptions.getProperty("SaveDBHost");
            }
            String databaseName = "QADB";
            if (mTestDriverOptions.getProperty("SaveDBName") != null) {
                databaseName = mTestDriverOptions.getProperty("SaveDBName");
            }
            myURL = "jdbc:sapdb://" + databaseHost + "/" + databaseName;
            lConnection = DriverManager.getConnection(myURL, "TESTER", "TESTER");
            Stmt = new TestStatement((TestCase)this, lConnection);
            this.setStatus("Save results...");
            int database_MAXTASK_STACK = new Integer(((TestDatabaseSap)TestCase.getDatabase()).getParameter("_MAXTASK_STACK"));
            int databaseMAX_SPECIALTASK_STACK = new Integer(((TestDatabaseSap)TestCase.getDatabase()).getParameter("MAX_SPECIALTASK_STACK"));
            int databaseMAX_SERVERTASK_STACK = new Integer(((TestDatabaseSap)TestCase.getDatabase()).getParameter("MAX_SERVERTASK_STACK"));
            database_MAXTASK_STACK *= 1024;
            databaseMAX_SPECIALTASK_STACK *= 1024;
            databaseMAX_SERVERTASK_STACK *= 1024;
            String KernelVersion = "unknown";
            try {
                KernelVersion = ((TestDatabaseSap)SutStarter.getDatabase()).getKernelVersion();
            }
            catch (TestDatabaseException e) {
                KernelVersion = "unknown - " + e.getLocalizedMessage();
            }
            boolean is7500 = false;
            if (KernelVersion.equals("7.5.0") || KernelVersion.equals("7.5.00") || KernelVersion.equals("7.05.00")) {
                is7500 = true;
            }
            while (line != null) {
                specialStackConsume = -1;
                serverStackConsume = -1;
                stForLine = new StringTokenizer(line, ";");
                testName = stForLine.nextToken();
                stackConsume = new Integer(stForLine.nextToken());
                if (stForLine.hasMoreTokens()) {
                    specialStackConsume = new Integer(stForLine.nextToken());
                    serverStackConsume = new Integer(stForLine.nextToken());
                }
                insertQRY = "INSERT INTO STACKUSAGESUT set ";
                insertQRY = insertQRY + "DRIVERSTARTED = '" + driverStarted + "',";
                insertQRY = insertQRY + "MAKEKEY = " + MakeKey + ",";
                insertQRY = insertQRY + "SUTTYPE = '" + directoryForStackSaveFile + "',";
                insertQRY = insertQRY + "TESTNAME = '" + testName + "',";
                insertQRY = insertQRY + "STACKUSAGE = " + stackConsume + ",";
                insertQRY = insertQRY + "SPECIALSTACKUSAGE = " + specialStackConsume + ",";
                insertQRY = insertQRY + "SERVERSTACKUSAGE = " + serverStackConsume + ",";
                insertQRY = enableKBStackUsage ? insertQRY + "STACKTYPE = 'KB'" : insertQRY + "STACKTYPE = 'normal'";
                insertQRY = insertQRY + "";
                Stmt.executeUpdate(insertQRY);
                line = reader.readLine();
                if (is7500 && (testName.equalsIgnoreCase("SUBQUERY") || testName.equalsIgnoreCase("VIEWCHCK") || testName.equalsIgnoreCase("UNIONTST"))) {
                    if ((double)database_MAXTASK_STACK * 0.9 < (double)stackConsume) {
                        SutStarter.addGlobalMessage((String)"checkStack", (char)'W', (String)("The maximum used user task stack size for the test '" + testName + "' is too high (" + stackConsume + " bytes) but it is not a real problem, because the test will use over 90% of _MAXTASK_STACK (" + database_MAXTASK_STACK + " bytes)."));
                    }
                } else if ((double)database_MAXTASK_STACK * 0.9 < (double)stackConsume) {
                    SutStarter.addGlobalMessage((String)"checkStack", (char)'E', (String)("The maximum used user task stack size for the test '" + testName + "' is too high (" + stackConsume + " bytes). Over 90% of _MAXTASK_STACK (" + database_MAXTASK_STACK + " bytes)."));
                }
                if ((double)databaseMAX_SPECIALTASK_STACK * 0.9 < (double)specialStackConsume) {
                    SutStarter.addGlobalMessage((String)"checkStack", (char)'E', (String)("The maximum used special task stack size for the test '" + testName + "' is too high (" + specialStackConsume + " bytes)."));
                }
                if (!((double)databaseMAX_SERVERTASK_STACK * 0.9 < (double)serverStackConsume)) continue;
                SutStarter.addGlobalMessage((String)"checkStack", (char)'E', (String)("The maximum used server task stack size for the test '" + testName + "' is too high (" + serverStackConsume + " bytes)."));
            }
            return;
        }
        catch (Exception exp) {
            SutStarter.addGlobalMessage((String)"storeStackConsumeInQADB()", (char)'W', (String)("Something wrong during the save of the stack consume in QADB.\n" + exp.getLocalizedMessage()));
            if (insertQRY != null) {
                SutStarter.addGlobalMessage((String)"storeStackConsumeInQADB()", (char)'T', (String)("insert statement: '" + insertQRY + "'\nwith URL: " + myURL));
            }
            exp.printStackTrace();
            return;
        }
        finally {
            try {
                if (Stmt != null) {
                    Stmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (lConnection != null) {
                    lConnection.close();
                }
            }
            catch (Exception e) {}
        }
    }

    private String array2String(String[] cmdArr) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < cmdArr.length; ++i) {
            buf.append(cmdArr[i]);
            buf.append(" ");
        }
        return buf.toString();
    }

    public String getLogFile() {
        File theZipFile = new File(jtestRoot + fileSep + "sut" + fileSep + zipFileName);
        if (theZipFile.exists()) {
            theZipFile.delete();
        }
        Zipper myZipper = new Zipper(theZipFile);
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".prot") || name.endsWith(".pdiff") || name.endsWith(".prt") || name.endsWith(".err") || name.endsWith(".vprot");
            }
        };
        File[] filelist = new File(jtestRoot + fileSep + "sut" + fileSep + "fast").listFiles(filter);
        if (filelist != null) {
            myZipper.addFiles(filelist);
        }
        if ((filelist = new File(jtestRoot + fileSep + "sut" + fileSep + "slow").listFiles(filter)) != null) {
            myZipper.addFiles(filelist);
        }
        if ((filelist = new File(jtestRoot + fileSep + "sut" + fileSep + "quick").listFiles(filter)) != null) {
            myZipper.addFiles(filelist);
        }
        if ((filelist = new File(jtestRoot + fileSep + "sut" + fileSep + "alluni").listFiles(filter)) != null) {
            myZipper.addFiles(filelist);
        }
        if ((filelist = new File(jtestRoot + fileSep + "sut" + fileSep + "dbuni").listFiles(filter)) != null) {
            myZipper.addFiles(filelist);
        }
        if ((filelist = new File(jtestRoot + fileSep + "sut" + fileSep + "uni").listFiles(filter)) != null) {
            myZipper.addFiles(filelist);
        }
        if ((filelist = new File(jtestRoot + fileSep + "sut" + fileSep + "multi").listFiles(filter)) != null) {
            myZipper.addFiles(filelist);
        }
        if ((filelist = new File(jtestRoot + fileSep + "sut" + fileSep + "xci").listFiles(filter)) != null) {
            myZipper.addFiles(filelist);
        }
        if ((filelist = new File(jtestRoot + fileSep + "sut" + fileSep + "prot").listFiles(filter)) != null) {
            myZipper.addFiles(filelist);
        }
        try {
            SutStarter.copyFile(new File(this.getDataOutputPath() + fileSep + "sutresults.txt"), new File(jtestRoot + fileSep + "sut" + fileSep + "sutresults.txt"));
        }
        catch (Exception exp) {
            System.out.println("Can't copy 'sutresults.txt' file. \n" + exp.getLocalizedMessage());
            exp.printStackTrace();
            this.addMessage("SutStarter", 'W', "Can't copy 'sutresults.txt' file. \n" + exp.getLocalizedMessage());
        }
        try {
            File knldiagFile = new File(jtestRoot + fileSep + "sut" + fileSep + "knldiag_" + kernel + "_" + codeType + ".err");
            FileWriter fwknl = new FileWriter(knldiagFile);
            System.out.println("Database state: " + ((TestDatabaseSap)TestCase.getDatabase()).getState());
            String knldiag = ((TestDatabaseSap)TestCase.getDatabase()).getDatabaseProtocolViaDBMKey("KNLDIAGERR");
            fwknl.write(knldiag.substring(0), 0, knldiag.length());
            fwknl.close();
        }
        catch (Exception exp) {
            System.out.println("Can't create 'knldiag.err' file. \n" + exp.getLocalizedMessage());
            exp.printStackTrace();
            this.addMessage("SutStarter", 'W', "Can't create 'knldiag.err' file. \n" + exp.getLocalizedMessage());
        }
        filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".txt") || name.endsWith(".prot") || name.endsWith(".prt") || name.endsWith(".err");
            }
        };
        filelist = new File(jtestRoot + fileSep + "sut").listFiles(filter);
        myZipper.addFiles(filelist);
        try {
            myZipper.setRootDirectory(new File(jtestRoot + fileSep + "sut"));
            myZipper.zip();
        }
        catch (IOException e) {
            this.addMessage("SutStarter", 'W', "Failed to create a zipfile with the protocol files\n" + e.getLocalizedMessage());
            return null;
        }
        return theZipFile.getAbsolutePath();
    }

    private static void overwriteIsut() {
        try {
            FileWriter writer = new FileWriter(new File(jtestRoot + fileSep + "sut" + fileSep + "ISUT"));
            writer.write("Duser XINITDB       name\nDuser A01DBA        name\n");
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void patchISUTFile(String myCodeType) {
        if (myCodeType == null) {
            return;
        }
        try {
            FileWriter writer = new FileWriter(new File(jtestRoot + fileSep + "sut" + fileSep + "ISUT"));
            writer.write("Duser XINITDB       name\n");
            if (myCodeType.equalsIgnoreCase("")) {
                writer.write(SutStarter.buildISUTContent("tpunx"));
            }
            if (myCodeType.equalsIgnoreCase("dbuni")) {
                writer.write(SutStarter.buildISUTContent("uunix"));
            }
            if (myCodeType.equalsIgnoreCase("uni")) {
                writer.write(SutStarter.buildISUTContent("upnix"));
            }
            if (myCodeType.equalsIgnoreCase("xci")) {
                writer.write(SutStarter.buildISUTContent("cunix"));
            }
            if (myCodeType.equalsIgnoreCase("alluni")) {
                writer.write(SutStarter.buildISUTContent("cpnix"));
            }
            if (myCodeType.equalsIgnoreCase("multi")) {
                writer.write(SutStarter.buildISUTContent("munix"));
            }
            writer.close();
        }
        catch (Exception e) {
            SutStarter.addGlobalMessage((String)"patchISUTFile", (char)'W', (String)("During the patching of ISUT:\n" + e.getMessage()));
            e.printStackTrace();
        }
    }

    private static String buildISUTContent(String fileExtension) {
        String[] allFiles = new File(jtestRoot + fileSep + "sut").list();
        String returnValue = "";
        StringBuffer myLittleBuffer = new StringBuffer();
        myLittleBuffer.append("Following files were added: \n ");
        int counter = 0;
        for (int i = 0; i < allFiles.length; ++i) {
            if (!allFiles[i].toLowerCase().endsWith(fileExtension.toLowerCase())) continue;
            returnValue = returnValue + "D00000 " + allFiles[i].substring(0, allFiles[i].indexOf(".")) + " user\n";
            myLittleBuffer.append(" " + allFiles[i].substring(0, allFiles[i].indexOf(".")));
            if (counter % 8 == 0 && counter != 0) {
                myLittleBuffer.append(",\n ");
            } else {
                myLittleBuffer.append(",");
            }
            ++counter;
        }
        String allAddedTests = myLittleBuffer.toString();
        allAddedTests = allAddedTests.substring(0, allAddedTests.length() - 1);
        SutStarter.addGlobalMessage((String)"patchISUTFile", (char)'I', (String)("patchISUTFile is set to true; codetype is '" + codeType + "'; use all files with extension '" + fileExtension + "'; found: " + counter + " files.\n" + allAddedTests));
        return returnValue;
    }

    private void checkForDiffOrCore(String stdOut) {
        BufferedReader reader;
        if (stdOut == null) {
            return;
        }
        String line = "";
        File fileToRead = new File(TestDriver.getJTestRoot() + File.separator + "sut" + File.separator + "prot" + File.separator + "alldiff.prt");
        if (diffErr) {
            try {
                reader = new BufferedReader(new FileReader(fileToRead));
                line = reader.readLine();
                while (line != null) {
                    this.addMessage("Check", 'E', ".pdiff file found for: " + line.substring(0, line.indexOf(".")));
                    line = reader.readLine();
                }
            }
            catch (FileNotFoundException fnfe) {
                System.out.println("FileNotFoundException during reading of " + fileToRead + " -> " + fnfe.getLocalizedMessage());
            }
            catch (IOException ioe) {
                System.out.println("IOException during \"line = reader.readLine();\" -> " + ioe.getLocalizedMessage());
            }
        } else {
            try {
                reader = new BufferedReader(new FileReader(fileToRead));
                line = reader.readLine();
                while (line != null) {
                    this.addMessage("Check", 'W', ".pdiff file found for: " + line.substring(0, line.indexOf(".")));
                    line = reader.readLine();
                }
            }
            catch (FileNotFoundException fnfe) {
                System.out.println("FileNotFoundException during reading of " + fileToRead + " -> " + fnfe.getLocalizedMessage());
            }
            catch (IOException ioe) {
                System.out.println("IOException during \"line = reader.readLine();\" -> " + ioe.getLocalizedMessage());
            }
        }
        if (stdOut.indexOf("syserr") != -1) {
            this.addMessage("Check", 'E', "At least one .syserr file found.");
        }
        fileToRead = new File(TestDriver.getJTestRoot() + File.separator + "sut" + File.separator + "prot" + File.separator + "allcore.prt");
        try {
            reader = new BufferedReader(new FileReader(fileToRead));
            line = reader.readLine();
            while (line != null) {
                this.addMessage("Check", 'E', ".core file found for: " + line.substring(0, line.indexOf(".")));
                line = reader.readLine();
            }
        }
        catch (FileNotFoundException fnfe) {
            System.out.println("FileNotFoundException during reading of " + fileToRead + " -> " + fnfe.getLocalizedMessage());
        }
        catch (IOException ioe) {
            System.out.println("IOException during \"line = reader.readLine();\" -> " + ioe.getLocalizedMessage());
        }
    }

    private static void copyFile(File in, File out) throws Exception {
        FileInputStream fis = new FileInputStream(in);
        FileOutputStream fos = new FileOutputStream(out);
        byte[] buf = new byte[1024];
        int i = 0;
        while ((i = fis.read(buf)) != -1) {
            fos.write(buf, 0, i);
        }
        fis.close();
        fos.close();
    }

    static {
        enableKBStackUsage = false;
        patchISUTFile = false;
    }
}

