/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.subtransaction;

import com.sap.sapdb.oltptest.subtransaction.SubTransactionTestThread;
import com.sap.sapdb.oltptest.subtransaction.XmlErrorHandler;
import com.sap.sapdb.oltptest.subtransaction.statements.DataManipulationStatement;
import com.sap.sapdb.oltptest.subtransaction.statements.DeleteDataStatement;
import com.sap.sapdb.oltptest.subtransaction.statements.InsertDataStatement;
import com.sap.sapdb.oltptest.subtransaction.statements.ReleaseSavepointStatement;
import com.sap.sapdb.oltptest.subtransaction.statements.RollbackToStatement;
import com.sap.sapdb.oltptest.subtransaction.statements.SavePointStatement;
import com.sap.sapdb.oltptest.subtransaction.statements.SubTransactionStatement;
import com.sap.sapdb.oltptest.subtransaction.statements.SubtransBeginStatement;
import com.sap.sapdb.oltptest.subtransaction.statements.SubtransEndStatement;
import com.sap.sapdb.oltptest.subtransaction.statements.SubtransRollbackStatement;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.testcase.TestStatement;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SubTransactionTest
extends TestCase {
    private static String defaultUserName = "JOJO";
    private static String defaultUserPass = "PUPS";
    private static int defaultTableRowCount = 10;
    private static String dafaultTableName = "TAB";
    private static int defaultNoOpenTransactionError = -7065;
    private static int defaultNoSavePointError = -7065;
    private static int defaultToManySavePointsError = -1111;
    private static int defaultNoNameError = -3014;
    private static boolean defaultKeepUser = false;
    private static int defaultProtocolLevel = 1;
    private static int defaultNumberOfThreads = 3;
    private static int[] fatalError = new int[]{-813, -8888, -10821, -708};
    private static int defaultMaxNumberOfSavepoints = 50;
    private static int defaultMaxNumberOfOccurredErrors = 15;
    private String userPass;
    private int tableRowCount;
    private String tableName;
    private int noOpenTransactionError;
    private int noSavePointError;
    private int toManySavePointsError;
    private int noNameError;
    private static int maxNumberOfSavepoints;
    private int protocolLevel;

    public static void prepare() throws TestCaseException {
    }

    /*
     * Exception decompiling
     */
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Missing node tying up JSR block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.tieUpRelations(Op02WithProcessedDataAndRefs.java:2900)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.copyBlock(Op02WithProcessedDataAndRefs.java:2889)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.inlineJSR(Op02WithProcessedDataAndRefs.java:2845)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSRs(Op02WithProcessedDataAndRefs.java:2591)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSR(Op02WithProcessedDataAndRefs.java:2481)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:444)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void cleanUp() throws TestCaseException {
    }

    private void interruptAllThreads(SubTransactionTestThread[] currentThreads) {
        for (int h1 = 0; h1 < currentThreads.length; ++h1) {
            if (currentThreads[h1] == null) continue;
            currentThreads[h1].interrupt();
        }
    }

    private ArrayList readStatementsFromXmlFile(File xmlFile, int sequenceNumber) {
        ArrayList<SubtransBeginStatement> result = new ArrayList<SubtransBeginStatement>();
        this.ownAddMessage(-1, sequenceNumber, -1, 1, 'I', "read xml file");
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(true);
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setErrorHandler(new XmlErrorHandler());
            Document xmlDocument = builder.parse(xmlFile);
            Element root = xmlDocument.getDocumentElement();
            NodeList nl = root.getChildNodes();
            for (int h1 = 0; h1 < nl.getLength(); ++h1) {
                DataManipulationStatement dataManipulation;
                Node currentNode = nl.item(h1);
                if (currentNode.getNodeType() != 1) continue;
                String nodeName = currentNode.getNodeName();
                NamedNodeMap attributes = currentNode.getAttributes();
                NodeList elements = currentNode.getChildNodes();
                int statementType = -1;
                if (nodeName.equals("subtransBegin")) {
                    statementType = 0;
                }
                if (nodeName.equals("subtransEnd")) {
                    statementType = 1;
                }
                if (nodeName.equals("subtransRollback")) {
                    statementType = 2;
                }
                if (nodeName.equals("savepoint")) {
                    statementType = 3;
                }
                if (nodeName.equals("rollbackTo")) {
                    statementType = 4;
                }
                if (nodeName.equals("releaseSavepoint")) {
                    statementType = 5;
                }
                if (statementType == -1) continue;
                SubTransactionStatement statement = null;
                int error = 0;
                String name = null;
                Node errorNode = attributes.getNamedItem("error");
                if (errorNode != null) {
                    error = new Integer(errorNode.getNodeValue());
                }
                if (statementType == 3 || statementType == 4 || statementType == 5) {
                    name = attributes.getNamedItem("name").getNodeValue();
                }
                ArrayList<Integer> deleteArrayList = new ArrayList<Integer>();
                if (elements != null) {
                    for (int h2 = 0; h2 < elements.getLength(); ++h2) {
                        Node item = elements.item(h2);
                        if (item.getNodeType() != 1 || !item.getNodeName().equals("delete")) continue;
                        NamedNodeMap itemAttributes = item.getAttributes();
                        Node deleteNode = itemAttributes.getNamedItem("insertOfStatement");
                        deleteArrayList.add(new Integer(deleteNode.getNodeValue()));
                    }
                }
                if (deleteArrayList.size() > 0) {
                    int[] deleteList = new int[deleteArrayList.size()];
                    for (int h3 = 0; h3 < deleteArrayList.size(); ++h3) {
                        deleteList[h3] = (Integer)deleteArrayList.get(h3);
                    }
                    dataManipulation = new DeleteDataStatement(deleteList);
                } else {
                    dataManipulation = new InsertDataStatement();
                }
                switch (statementType) {
                    case 0: {
                        statement = new SubtransBeginStatement(error, dataManipulation);
                        break;
                    }
                    case 1: {
                        statement = new SubtransEndStatement(error, dataManipulation);
                        break;
                    }
                    case 2: {
                        statement = new SubtransRollbackStatement(error, dataManipulation);
                        break;
                    }
                    case 3: {
                        statement = new SavePointStatement(error, name, dataManipulation);
                        break;
                    }
                    case 4: {
                        statement = new RollbackToStatement(error, name, dataManipulation);
                        break;
                    }
                    case 5: {
                        statement = new ReleaseSavepointStatement(error, name, dataManipulation);
                    }
                }
                result.add((SubtransBeginStatement)statement);
            }
        }
        catch (SAXException e) {
            this.ownAddMessage(-1, sequenceNumber, -1, 0, 'E', "error during reading xml-file " + xmlFile.toString() + " :" + e.getMessage());
            e.printStackTrace();
            return null;
        }
        catch (ParserConfigurationException e) {
            this.ownAddMessage(-1, sequenceNumber, -1, 0, 'E', "error during reading xml-file " + xmlFile.toString() + " :" + e.getMessage());
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            this.ownAddMessage(-1, sequenceNumber, -1, 0, 'E', "error during reading xml-file " + xmlFile.toString() + " :" + e.getMessage());
            e.printStackTrace();
            return null;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void dropAllUsers(ArrayList createdUser) {
        block52: {
            if (createdUser.size() > 0) {
                Connection masterConnection = null;
                TestStatement masterStatement = null;
                String currentUserName = "";
                masterConnection = SubTransactionTest.getDatabase().connect(SubTransactionTest.getUser(), SubTransactionTest.getPassword());
                masterStatement = new TestStatement(null, masterConnection);
                if (this.protocolLevel == 0) {
                    this.ownAddMessage(-1, -1, -1, 0, 'I', "drop users");
                } else {
                    System.out.println("\n---------------------------------------\n");
                }
                for (int h1 = 0; h1 < createdUser.size(); ++h1) {
                    currentUserName = (String)createdUser.get(h1);
                    if (this.protocolLevel >= 1) {
                        this.ownAddMessage(-1, -1, -1, 0, 'I', "drop user " + currentUserName);
                    }
                    masterStatement.enableExceptions(false);
                    masterStatement.executeUpdate("drop user " + currentUserName);
                    masterStatement.enableExceptions(true);
                }
                Object var7_9 = null;
                try {
                    masterStatement.close();
                }
                catch (NullPointerException e2) {
                }
                catch (SQLException e2) {
                    if (this.checkSqlException(((SQLException)e2).getErrorCode())) {
                        this.ownAddMessage(-1, -1, -1, 0, 'E', "fatal error while trying to close statement (end test) : " + e2.getMessage());
                        return;
                    }
                    this.ownAddMessage(-1, -1, -1, 1, 'W', "error while trying to close statement : " + e2.getMessage());
                }
                try {
                    masterConnection.close();
                }
                catch (NullPointerException e2) {
                }
                catch (SQLException e2) {
                    if (this.checkSqlException(((SQLException)e2).getErrorCode())) {
                        this.ownAddMessage(-1, -1, -1, 0, 'E', "fatal error while trying to close connection (end test) : " + e2.getMessage());
                        return;
                    }
                    this.ownAddMessage(-1, -1, -1, 1, 'W', "error while trying to close connection : " + e2.getMessage());
                }
                break block52;
                {
                    catch (TestDatabaseException e) {
                        this.ownAddMessage(-1, -1, -1, 0, 'E', "error during dropping user " + currentUserName + " : " + e.getMessage());
                        e.printStackTrace();
                        Object var7_10 = null;
                        try {
                            masterStatement.close();
                        }
                        catch (NullPointerException e2) {
                        }
                        catch (SQLException e2) {
                            if (this.checkSqlException(((SQLException)e2).getErrorCode())) {
                                this.ownAddMessage(-1, -1, -1, 0, 'E', "fatal error while trying to close statement (end test) : " + e2.getMessage());
                                return;
                            }
                            this.ownAddMessage(-1, -1, -1, 1, 'W', "error while trying to close statement : " + e2.getMessage());
                        }
                        try {
                            masterConnection.close();
                        }
                        catch (NullPointerException e2) {
                        }
                        catch (SQLException e2) {
                            if (this.checkSqlException(((SQLException)e2).getErrorCode())) {
                                this.ownAddMessage(-1, -1, -1, 0, 'E', "fatal error while trying to close connection (end test) : " + e2.getMessage());
                                return;
                            }
                            this.ownAddMessage(-1, -1, -1, 1, 'W', "error while trying to close connection : " + e2.getMessage());
                        }
                        break block52;
                    }
                    catch (SQLException e) {
                        if (this.checkSqlException(e.getErrorCode())) {
                            this.ownAddMessage(-1, -1, -1, 0, 'E', "fatal error during dropping user " + currentUserName + " (end test) : " + e.getMessage());
                            Object var7_11 = null;
                            try {
                                masterStatement.close();
                            }
                            catch (NullPointerException e2) {
                            }
                            catch (SQLException e2) {
                                if (this.checkSqlException(((SQLException)e2).getErrorCode())) {
                                    this.ownAddMessage(-1, -1, -1, 0, 'E', "fatal error while trying to close statement (end test) : " + e2.getMessage());
                                    return;
                                }
                                this.ownAddMessage(-1, -1, -1, 1, 'W', "error while trying to close statement : " + e2.getMessage());
                            }
                            try {
                                masterConnection.close();
                            }
                            catch (NullPointerException e2) {
                            }
                            catch (SQLException e2) {
                                if (this.checkSqlException(((SQLException)e2).getErrorCode())) {
                                    this.ownAddMessage(-1, -1, -1, 0, 'E', "fatal error while trying to close connection (end test) : " + e2.getMessage());
                                    return;
                                }
                                this.ownAddMessage(-1, -1, -1, 1, 'W', "error while trying to close connection : " + e2.getMessage());
                            }
                            return;
                        }
                        this.ownAddMessage(-1, -1, -1, 0, 'E', "error during dropping user " + currentUserName + " : " + e.getMessage());
                        e.printStackTrace();
                        Object var7_12 = null;
                        try {
                            masterStatement.close();
                        }
                        catch (NullPointerException e2) {
                        }
                        catch (SQLException e2) {
                            if (this.checkSqlException(((SQLException)e2).getErrorCode())) {
                                this.ownAddMessage(-1, -1, -1, 0, 'E', "fatal error while trying to close statement (end test) : " + e2.getMessage());
                                return;
                            }
                            this.ownAddMessage(-1, -1, -1, 1, 'W', "error while trying to close statement : " + e2.getMessage());
                        }
                        try {
                            masterConnection.close();
                        }
                        catch (NullPointerException e2) {
                        }
                        catch (SQLException e2) {
                            if (this.checkSqlException(((SQLException)e2).getErrorCode())) {
                                this.ownAddMessage(-1, -1, -1, 0, 'E', "fatal error while trying to close connection (end test) : " + e2.getMessage());
                                return;
                            }
                            this.ownAddMessage(-1, -1, -1, 1, 'W', "error while trying to close connection : " + e2.getMessage());
                        }
                        break block52;
                    }
                    catch (Exception e) {
                        this.ownAddMessage(-1, -1, -1, 0, 'E', "error during dropping user " + currentUserName + " : " + e.getMessage());
                        e.printStackTrace();
                        Object var7_13 = null;
                        try {
                            masterStatement.close();
                        }
                        catch (NullPointerException e2) {
                        }
                        catch (SQLException e2) {
                            if (this.checkSqlException(((SQLException)e2).getErrorCode())) {
                                this.ownAddMessage(-1, -1, -1, 0, 'E', "fatal error while trying to close statement (end test) : " + e2.getMessage());
                                return;
                            }
                            this.ownAddMessage(-1, -1, -1, 1, 'W', "error while trying to close statement : " + e2.getMessage());
                        }
                        try {
                            masterConnection.close();
                        }
                        catch (NullPointerException e2) {
                        }
                        catch (SQLException e2) {
                            if (this.checkSqlException(((SQLException)e2).getErrorCode())) {
                                this.ownAddMessage(-1, -1, -1, 0, 'E', "fatal error while trying to close connection (end test) : " + e2.getMessage());
                                return;
                            }
                            this.ownAddMessage(-1, -1, -1, 1, 'W', "error while trying to close connection : " + e2.getMessage());
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var7_14 = null;
                    try {
                        masterStatement.close();
                    }
                    catch (NullPointerException e2) {
                    }
                    catch (SQLException e2) {
                        if (this.checkSqlException(((SQLException)e2).getErrorCode())) {
                            this.ownAddMessage(-1, -1, -1, 0, 'E', "fatal error while trying to close statement (end test) : " + e2.getMessage());
                            return;
                        }
                        this.ownAddMessage(-1, -1, -1, 1, 'W', "error while trying to close statement : " + e2.getMessage());
                    }
                    try {
                        masterConnection.close();
                    }
                    catch (NullPointerException e2) {
                    }
                    catch (SQLException e2) {
                        if (this.checkSqlException(((SQLException)e2).getErrorCode())) {
                            this.ownAddMessage(-1, -1, -1, 0, 'E', "fatal error while trying to close connection (end test) : " + e2.getMessage());
                            return;
                        }
                        this.ownAddMessage(-1, -1, -1, 1, 'W', "error while trying to close connection : " + e2.getMessage());
                    }
                    throw throwable;
                }
            }
        }
    }

    protected synchronized void ownAddMessage(int threadNo, int sequenceNo, int statementNo, int priority, char messageType, String messageText) {
        if (priority <= this.protocolLevel) {
            String messageId = new String("");
            if (threadNo != -1 || sequenceNo != -1 || statementNo != -1) {
                DecimalFormat df;
                messageId = messageId + "(";
                if (threadNo != -1) {
                    df = new DecimalFormat("000");
                    messageId = messageId + "thr " + df.format(threadNo) + ",";
                } else {
                    messageId = messageId + "     - ,";
                }
                if (sequenceNo != -1) {
                    df = new DecimalFormat("000");
                    messageId = messageId + "seq " + df.format(sequenceNo) + ",";
                } else {
                    messageId = messageId + "     - ,";
                }
                if (statementNo != -1) {
                    df = new DecimalFormat("0000");
                    messageId = messageId + "sta " + df.format(statementNo) + ")";
                } else {
                    messageId = messageId + "      - )";
                }
            }
            if (messageType == 'E') {
                System.out.println(messageId + "ERROR   : " + messageText);
                this.addMessage(messageId, 'E', messageText);
            }
            if (messageType == 'W') {
                System.out.println(messageId + "WARNING : " + messageText);
                this.addMessage(messageId, 'W', messageText);
            }
            if (messageType == 'I') {
                System.out.println(messageId + "INFO    : " + messageText);
                this.addMessage(messageId, 'I', messageText);
            }
        }
    }

    protected synchronized Connection threadConnect(String userName) throws TestDatabaseException {
        Properties connectProp = new Properties();
        connectProp.put("user", userName);
        connectProp.put("password", this.userPass);
        connectProp.put("autocommit", "off");
        Connection c = SubTransactionTest.getDatabase().connect(connectProp);
        return c;
    }

    private boolean checkSqlException(int errorCode) {
        for (int h1 = 0; h1 < fatalError.length; ++h1) {
            if (errorCode != fatalError[h1]) continue;
            return true;
        }
        return false;
    }

    protected int getNoSavePointError() {
        return this.noSavePointError;
    }

    protected int getNoOpenTransactionError() {
        return this.noOpenTransactionError;
    }

    public int getToManySavePointsError() {
        return this.toManySavePointsError;
    }

    public int getNoNameError() {
        return this.noNameError;
    }

    protected String getTableName() {
        return this.tableName;
    }

    protected int getTableRowCount() {
        return this.tableRowCount;
    }

    protected String getUserPass() {
        return this.userPass;
    }

    public int getMaxNumberOfSavepoints() {
        return maxNumberOfSavepoints;
    }
}

