/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.sqlmanager;

import com.sap.sapdb.oltptest.sqlmanager.DatabaseObject;
import com.sap.sapdb.oltptest.sqlmanager.QueryTests;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDatabaseSap;
import com.sap.sapdb.testframe.driver.TestDriver;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.testcase.TestStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class SystemTablesMultiUser
extends TestCase {
    private static int USERCOUNT = 6;
    private static final String TESTUSERNAME = "TESTUSER";
    private static Properties DBAConnectionInternalProperties = new Properties();
    private static Properties DBAConnectionOracleProperties = new Properties();
    private static boolean UNICODE;
    private static Hashtable excludedSystabs;
    private String testrunname;
    private static String DATABASEVERSION;
    private static Vector TestUserList;
    private Vector systemTableList = new Vector();
    private QueryTests tests;
    private String stopOnError = "0";

    public static void prepare() throws TestCaseException {
        System.out.println("Prepare of " + SystemTablesMultiUser.getTestClassId());
        DBAConnectionInternalProperties.put("user", SystemTablesMultiUser.getUser());
        DBAConnectionInternalProperties.put("password", SystemTablesMultiUser.getPassword());
        DBAConnectionInternalProperties.put("autocommit", "on");
        DBAConnectionInternalProperties.put("sqlmode", "internal");
        DBAConnectionOracleProperties.put("user", SystemTablesMultiUser.getUser());
        DBAConnectionOracleProperties.put("password", SystemTablesMultiUser.getPassword());
        DBAConnectionOracleProperties.put("autocommit", "on");
        DBAConnectionOracleProperties.put("sqlmode", "Oracle");
        String excludedSystabsString = new String();
        excludedSystabsString = SystemTablesMultiUser.getParameterString((String)"excludedSystabs", (String)"");
        StringTokenizer st = new StringTokenizer(excludedSystabsString, ";,");
        excludedSystabs = new Hashtable(25);
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            excludedSystabs.put(s, "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block34: {
            DatabaseObject systemTable = null;
            Connection DatabaseConnection = null;
            ResultSet res1 = null;
            TestStatement runStatement = null;
            ThreadGroup testThreadGroup = null;
            SimpleDateFormat fmt = new SimpleDateFormat();
            fmt.applyPattern("yyyy-MM-dd_HH-mm-ss");
            this.testrunname = this.getTestId() + "_Log_" + fmt.format(new Date());
            System.out.println("Run of " + SystemTablesMultiUser.getTestClassId());
            DATABASEVERSION = ((TestDatabaseSap)SystemTablesMultiUser.getDatabase()).getKernelVersion() + "." + ((TestDatabaseSap)SystemTablesMultiUser.getDatabase()).getKernelBuild().substring(0, 3);
            UNICODE = SystemTablesMultiUser.getDatabase().executeDBMcmd("param_getvalue _UNICODE").trim().equalsIgnoreCase("yes");
            USERCOUNT = Integer.parseInt(SystemTablesMultiUser.getParameterString((String)"UserCount", (String)Integer.toString(USERCOUNT)));
            String WARNINGONLY = SystemTablesMultiUser.getParameterString((String)"WARNINGONLY", (String)"");
            StringTokenizer st = new StringTokenizer(WARNINGONLY, ";,");
            Properties WARNINGONLYLIST = new Properties();
            while (st.hasMoreTokens()) {
                WARNINGONLYLIST.setProperty(st.nextToken(), "");
            }
            this.stopOnError = SystemTablesMultiUser.getParameterString((String)"StopOnError", (String)"0");
            if (!this.stopOnError.equals("0")) {
                SystemTablesMultiUser.getDatabase().executeDBMcmd("util_connect");
                SystemTablesMultiUser.getDatabase().executeDBMcmd("util_execute DIAGNOSE VTRACE STOP ON ERROR " + this.stopOnError);
                SystemTablesMultiUser.getDatabase().executeDBMcmd("util_release");
            }
            DatabaseConnection = SystemTablesMultiUser.getDatabase().connect(DBAConnectionInternalProperties);
            runStatement = new TestStatement(null, DatabaseConnection);
            res1 = TestDriver.compareRelease((String)DATABASEVERSION, (String)">=", (String)"7.6") ? runStatement.executeQuery("select SCHEMANAME,tablename,Tabletype from tables where type = 'SYSTEM'") : runStatement.executeQuery("select OWNER,tablename,Tabletype from tables where type = 'SYSTEM'");
            while (res1.next()) {
                this.systemTableList.add(new DatabaseObject(res1.getString(1), res1.getString(2), res1.getString(3)));
            }
            Object[] itSystabList = this.systemTableList.toArray();
            String objectname = null;
            int systemtablecount = this.systemTableList.size();
            for (int i = 0; i < systemtablecount; ++i) {
                DatabaseObject DBObject = (DatabaseObject)itSystabList[i];
                objectname = DBObject.getObjectName().toUpperCase().replaceAll("\"", "");
                if (!excludedSystabs.containsKey(objectname)) continue;
                this.systemTableList.remove(DBObject);
            }
            System.out.println("Testrun: \t" + this.testrunname);
            System.out.println("Usercount: \t" + USERCOUNT + "(Parameter: USERCOUNT)");
            System.out.println("Unicode: \t" + UNICODE);
            System.out.println("Tablecount: \t" + this.systemTableList.size());
            System.out.println("Stop on Error: \t" + SystemTablesMultiUser.getParameterString((String)"StopOnError", (String)"0") + "  (Parameter: StopOnError)");
            System.out.println("Known Errors: \t" + WARNINGONLY + "  (Parameter: WARNINGONLY)");
            this.addMessage("", 'I', "Testrun: \t" + this.testrunname + "\nUsercount: \t" + USERCOUNT + "(Parameter: USERCOUNT)" + "\nUnicode: \t" + UNICODE + "\nTablecount: \t" + this.systemTableList.size() + "\nStop on Error: \t" + SystemTablesMultiUser.getParameterString((String)"StopOnError", (String)"0") + "  (Parameter: StopOnError)" + "\nKnown Errors: \t" + WARNINGONLY + " (Parameter: WARNINGONLY)");
            Iterator it1 = this.systemTableList.iterator();
            StringBuffer dummySB = new StringBuffer();
            dummySB.append("The following view names are truncated:\nnew name\t\t\t\told name\n");
            boolean dummySBhasContent = false;
            while (it1.hasNext()) {
                systemTable = (DatabaseObject)it1.next();
                if (!systemTable.getViewNameTruncated()) continue;
                dummySBhasContent = true;
                dummySB.append("" + systemTable.getObjectViewName() + "");
                if (systemTable.getObjectViewName().length() < 32) {
                    dummySB.append(" ");
                }
                dummySB.append("\tv_" + systemTable.getObjectOwner() + "_" + systemTable.getObjectName().replaceAll("\"", "") + "\n");
            }
            if (dummySBhasContent) {
                this.addMessage("Truncated view names", 'I', "" + dummySB.toString());
            }
            String Query1 = "select * from ";
            String Query = "";
            it1 = this.systemTableList.iterator();
            while (it1.hasNext()) {
                systemTable = (DatabaseObject)it1.next();
                try {
                    Query = Query1 + systemTable.getObjectIdentifier();
                    res1 = runStatement.executeQuery(Query);
                    systemTable.setColumnList(res1.getMetaData());
                }
                catch (Exception e) {
                    this.addMessage("Data collection SQL-statement " + runStatement.getSqlString() + " failed", 'E', e.toString());
                    throw new TestCaseException("Data collection SQL-statement " + runStatement.getSqlString() + " failed");
                }
            }
            System.out.println(this.systemTableList.size() + " System Tables/Views found");
            System.out.println("DataCollection completed");
            for (int i = 1; i <= USERCOUNT; ++i) {
                TestUserList.add(TESTUSERNAME + i);
            }
            String dropUser = "Drop user ";
            Iterator itu = TestUserList.iterator();
            while (itu.hasNext()) {
                runStatement.executeUpdateIgnoreErrors(dropUser + itu.next());
            }
            Iterator it = TestUserList.iterator();
            while (it.hasNext()) {
                String username = (String)it.next();
                runStatement.execute("create user " + username + " Password " + username + " DBA not exclusive");
            }
            runStatement.close();
            DatabaseConnection.close();
            this.tests = new QueryTests(this, this.testrunname, (TestDatabaseSap)SystemTablesMultiUser.getDatabase(), this.systemTableList, DBAConnectionInternalProperties, USERCOUNT, false, WARNINGONLYLIST);
            testThreadGroup = new ThreadGroup("testThreadGroup");
            it1 = TestUserList.iterator();
            Thread[] testThreadArray = new Thread[USERCOUNT];
            int i = 0;
            while (it1.hasNext()) {
                String testuser = (String)it1.next();
                testThreadArray[i] = new SystemTablesMultiUSerThread(testThreadGroup, i, testuser, testuser, this);
                ++i;
            }
            for (int j = 0; j < testThreadArray.length; ++j) {
                testThreadArray[j].start();
            }
            ThreadGroup threadGroup = testThreadGroup;
            synchronized (threadGroup) {
                while (testThreadGroup.activeCount() > 0) {
                    testThreadGroup.wait(10L);
                }
            }
            Object var27_32 = null;
            try {
                DatabaseConnection = SystemTablesMultiUser.getDatabase().connect(DBAConnectionInternalProperties);
                runStatement = new TestStatement(null, DatabaseConnection);
                String dropUser2 = "Drop user ";
                Iterator it12 = TestUserList.iterator();
                while (it12.hasNext()) {
                    try {
                        runStatement.executeUpdate(dropUser2 + it12.next());
                    }
                    catch (Exception e2) {
                        this.addMessage(this.nextStep("") + "The SQL-statement " + runStatement.getSqlString() + " failed", 'W', e2.toString());
                    }
                }
                DatabaseConnection.commit();
                DatabaseConnection.close();
            }
            catch (Exception e3) {}
            break block34;
            {
                catch (Exception e) {
                    testThreadGroup.stop();
                    this.handleExceptions(e);
                    System.gc();
                    Object var27_33 = null;
                    try {
                        DatabaseConnection = SystemTablesMultiUser.getDatabase().connect(DBAConnectionInternalProperties);
                        runStatement = new TestStatement(null, DatabaseConnection);
                        String dropUser2 = "Drop user ";
                        Iterator it12 = TestUserList.iterator();
                        while (it12.hasNext()) {
                            try {
                                runStatement.executeUpdate(dropUser2 + it12.next());
                            }
                            catch (Exception e2) {
                                this.addMessage(this.nextStep("") + "The SQL-statement " + runStatement.getSqlString() + " failed", 'W', e2.toString());
                            }
                        }
                        DatabaseConnection.commit();
                        DatabaseConnection.close();
                    }
                    catch (Exception e3) {}
                }
            }
            catch (Throwable throwable) {
                Object var27_34 = null;
                try {
                    DatabaseConnection = SystemTablesMultiUser.getDatabase().connect(DBAConnectionInternalProperties);
                    runStatement = new TestStatement(null, DatabaseConnection);
                    String dropUser2 = "Drop user ";
                    Iterator it12 = TestUserList.iterator();
                    while (it12.hasNext()) {
                        try {
                            runStatement.executeUpdate(dropUser2 + it12.next());
                        }
                        catch (Exception e2) {
                            this.addMessage(this.nextStep("") + "The SQL-statement " + runStatement.getSqlString() + " failed", 'W', e2.toString());
                        }
                    }
                    DatabaseConnection.commit();
                    DatabaseConnection.close();
                }
                catch (Exception e3) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public String getLogFile() {
        return this.tests.getLogFile();
    }

    public static String getTestClassId() {
        return "SystemTablesMultiUser";
    }

    static {
        DATABASEVERSION = null;
        TestUserList = new Vector();
    }

    public class SystemTablesMultiUSerThread
    extends Thread {
        private Properties ConnectionProperties;
        private SystemTablesMultiUser main;
        private int usernumber;

        public SystemTablesMultiUSerThread(ThreadGroup group, int usernumber, String username, String password, SystemTablesMultiUser main) {
            super(group, new String(username));
            this.ConnectionProperties = new Properties();
            this.main = null;
            this.main = main;
            this.ConnectionProperties.put("user", new String(username));
            this.ConnectionProperties.put("password", new String(password));
            this.ConnectionProperties.put("autocommit", "on");
            this.ConnectionProperties.put("sqlmode", "internal");
            this.usernumber = usernumber;
        }

        public void run() {
            try {
                this.main.tests.verifyMetaDataTest(this.usernumber, this.ConnectionProperties);
                this.main.tests.countResultsetsTest(this.usernumber, this.ConnectionProperties);
                this.main.tests.orderByTest(this.usernumber, this.ConnectionProperties);
                this.main.tests.functionQueryTest(this.usernumber, this.ConnectionProperties);
                this.main.tests.groupByQueryTest(this.usernumber, this.ConnectionProperties);
                this.main.tests.unionQueryTest(this.usernumber, this.ConnectionProperties);
                this.main.tests.subselectQueryTest(this.usernumber, this.ConnectionProperties);
                this.main.tests.joinQueryTest(this.usernumber, this.ConnectionProperties);
            }
            catch (Exception e) {
                this.main.handleExceptions(e);
            }
        }
    }
}

