/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.sqlmanager;

import com.sap.sapdb.oltptest.sqlmanager.DatabaseObject;
import com.sap.sapdb.oltptest.sqlmanager.QueryTests;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDatabaseSap;
import com.sap.sapdb.testframe.driver.TestDriver;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.testcase.TestStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class SystemTables
extends TestCase {
    private static Properties DBAConnectionInternalProperties;
    private static Properties DBAConnectionOracleProperties;
    private Vector systemTableList = new Vector();
    private boolean UNICODE;
    private String DATABASEVERSION;
    private static final int USERCOUNT = 1;
    private String stopOnError = "0";
    private String testrunname;
    private QueryTests tests;

    public static void prepare() throws TestCaseException {
        System.out.println("Prepare of " + SystemTables.getTestClassId());
        DBAConnectionInternalProperties = new Properties();
        DBAConnectionOracleProperties = new Properties();
        DBAConnectionInternalProperties.put("user", SystemTables.getUser());
        DBAConnectionInternalProperties.put("password", SystemTables.getPassword());
        DBAConnectionInternalProperties.put("autocommit", "on");
        DBAConnectionInternalProperties.put("sqlmode", "internal");
        DBAConnectionOracleProperties.put("user", SystemTables.getUser());
        DBAConnectionOracleProperties.put("password", SystemTables.getPassword());
        DBAConnectionOracleProperties.put("autocommit", "on");
        DBAConnectionOracleProperties.put("sqlmode", "Oracle");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block24: {
            DatabaseObject systemTable = null;
            ResultSet res1 = null;
            Connection DatabaseConnection = null;
            TestStatement runStatement = null;
            SimpleDateFormat fmt = new SimpleDateFormat();
            fmt.applyPattern("yyyy-MM-dd_HH-mm-ss");
            this.testrunname = this.getTestId() + "_Log_" + fmt.format(new Date());
            System.out.println("Run of " + SystemTables.getTestClassId());
            DatabaseConnection = SystemTables.getDatabase().connect(DBAConnectionInternalProperties);
            this.UNICODE = SystemTables.getDatabase().executeDBMcmd("param_getvalue _UNICODE").trim().equalsIgnoreCase("yes");
            this.DATABASEVERSION = ((TestDatabaseSap)SystemTables.getDatabase()).getKernelVersion() + "." + ((TestDatabaseSap)SystemTables.getDatabase()).getKernelBuild().substring(0, 3);
            String WARNINGONLY = SystemTables.getParameterString((String)"WARNINGONLY", (String)"");
            StringTokenizer st = new StringTokenizer(WARNINGONLY, ";,");
            Properties WARNINGONLYLIST = new Properties();
            while (st.hasMoreTokens()) {
                WARNINGONLYLIST.setProperty(st.nextToken(), "");
            }
            this.stopOnError = SystemTables.getParameterString((String)"StopOnError", (String)"0");
            if (!this.stopOnError.equals("0")) {
                SystemTables.getDatabase().executeDBMcmd("util_connect");
                SystemTables.getDatabase().executeDBMcmd("util_execute DIAGNOSE VTRACE STOP ON ERROR " + this.stopOnError);
                SystemTables.getDatabase().executeDBMcmd("util_release");
            }
            runStatement = new TestStatement(null, DatabaseConnection);
            res1 = TestDriver.compareRelease((String)this.DATABASEVERSION, (String)">=", (String)"7.6") ? runStatement.executeQuery("select SCHEMANAME,tablename,Tabletype from tables where type = 'SYSTEM'") : runStatement.executeQuery("select OWNER,tablename,Tabletype from tables where type = 'SYSTEM'");
            while (res1.next()) {
                if (res1.getString(2).equalsIgnoreCase("dual")) continue;
                this.systemTableList.add(new DatabaseObject(res1.getString(1), res1.getString(2), res1.getString(3)));
            }
            System.out.println("Testrun: \t" + this.testrunname);
            System.out.println("Usercount: \t1");
            System.out.println("Unicode: \t" + this.UNICODE);
            System.out.println("Tablecount: \t" + this.systemTableList.size());
            System.out.println("Stop on Error: \t" + SystemTables.getParameterString((String)"StopOnError", (String)"0") + "  (Parameter: StopOnError)");
            System.out.println("Known Errors: \t" + WARNINGONLY + "  (Parameter: WARNINGONLY)");
            this.addMessage("", 'I', "Testrun: \t" + this.testrunname + "\nUsercount: \t" + 1 + "\nUnicode: \t" + this.UNICODE + "\nTablecount: \t" + this.systemTableList.size() + "\nStop on Error: \t" + SystemTables.getParameterString((String)"StopOnError", (String)"0") + "  (Parameter: StopOnError)" + "\nKnown Errors: \t" + WARNINGONLY + " (Parameter: WARNINGONLY)");
            Iterator it1 = this.systemTableList.iterator();
            StringBuffer dummySB = new StringBuffer();
            dummySB.append("The following view names are truncated:\nnew name\t\t\t\told name\n");
            boolean dummySBhasContent = false;
            while (it1.hasNext()) {
                systemTable = (DatabaseObject)it1.next();
                if (!systemTable.getViewNameTruncated()) continue;
                dummySBhasContent = true;
                dummySB.append("" + systemTable.getObjectViewName() + "");
                if (systemTable.getObjectViewName().length() < 32) {
                    dummySB.append(" ");
                }
                dummySB.append("\tv_" + systemTable.getObjectOwner() + "_" + systemTable.getObjectName().replaceAll("\"", "") + "\n");
            }
            if (dummySBhasContent) {
                this.addMessage("Truncated view names", 'I', "" + dummySB.toString());
            }
            String Query1 = "select * from ";
            String Query = "";
            it1 = this.systemTableList.iterator();
            while (it1.hasNext()) {
                systemTable = (DatabaseObject)it1.next();
                try {
                    Query = Query1 + systemTable.getObjectIdentifier();
                    res1 = runStatement.executeQuery(Query);
                    systemTable.setColumnList(res1.getMetaData());
                }
                catch (Exception e) {
                    this.addMessage("Data collection SQL-statement " + runStatement.getSqlString() + " failed", 'E', e.toString());
                    throw new TestCaseException("Data collection SQL-statement " + runStatement.getSqlString() + " failed");
                }
            }
            System.out.println(this.systemTableList.size() + " System Tables/Views found");
            System.out.println("DataCollection completed");
            runStatement.close();
            DatabaseConnection.close();
            this.tests = new QueryTests(this, this.testrunname, (TestDatabaseSap)SystemTables.getDatabase(), this.systemTableList, DBAConnectionInternalProperties, 1, true, WARNINGONLYLIST);
            this.tests.verifyMetaDataTest(0, null);
            this.tests.createViews(0, null);
            this.tests.countResultsetsTest(0, null);
            this.tests.orderByTest(0, null);
            this.tests.functionQueryTest(0, null);
            this.tests.groupByQueryTest(0, null);
            this.tests.unionQueryTest(0, null);
            this.tests.subselectViewQueryTest(0, null);
            this.tests.subselectQueryTest(0, null);
            this.tests.joinQueryTest(0, null);
            Object var16_16 = null;
            try {
                DatabaseConnection = SystemTables.getDatabase().connect(DBAConnectionInternalProperties);
                runStatement = new TestStatement(null, DatabaseConnection);
                String dropView = "";
                String dropView1 = "drop view ";
                Iterator it99 = this.systemTableList.iterator();
                while (it99.hasNext()) {
                    systemTable = (DatabaseObject)it99.next();
                    dropView = dropView1 + systemTable.getObjectViewName();
                    try {
                        runStatement.executeUpdate(dropView);
                    }
                    catch (Exception e2) {
                        this.addMessage(this.nextStep("") + "The SQL-statement " + runStatement.getSqlString() + " failed", 'W', e2.toString());
                    }
                }
                runStatement.close();
                DatabaseConnection.commit();
                DatabaseConnection.close();
            }
            catch (Exception e3) {}
            break block24;
            {
                catch (Exception e) {
                    this.handleExceptions(e);
                    Object var16_17 = null;
                    try {
                        DatabaseConnection = SystemTables.getDatabase().connect(DBAConnectionInternalProperties);
                        runStatement = new TestStatement(null, DatabaseConnection);
                        String dropView = "";
                        String dropView1 = "drop view ";
                        Iterator it99 = this.systemTableList.iterator();
                        while (it99.hasNext()) {
                            systemTable = (DatabaseObject)it99.next();
                            dropView = dropView1 + systemTable.getObjectViewName();
                            try {
                                runStatement.executeUpdate(dropView);
                            }
                            catch (Exception e2) {
                                this.addMessage(this.nextStep("") + "The SQL-statement " + runStatement.getSqlString() + " failed", 'W', e2.toString());
                            }
                        }
                        runStatement.close();
                        DatabaseConnection.commit();
                        DatabaseConnection.close();
                    }
                    catch (Exception e3) {}
                }
            }
            catch (Throwable throwable) {
                Object var16_18 = null;
                try {
                    DatabaseConnection = SystemTables.getDatabase().connect(DBAConnectionInternalProperties);
                    runStatement = new TestStatement(null, DatabaseConnection);
                    String dropView = "";
                    String dropView1 = "drop view ";
                    Iterator it99 = this.systemTableList.iterator();
                    while (it99.hasNext()) {
                        systemTable = (DatabaseObject)it99.next();
                        dropView = dropView1 + systemTable.getObjectViewName();
                        try {
                            runStatement.executeUpdate(dropView);
                        }
                        catch (Exception e2) {
                            this.addMessage(this.nextStep("") + "The SQL-statement " + runStatement.getSqlString() + " failed", 'W', e2.toString());
                        }
                    }
                    runStatement.close();
                    DatabaseConnection.commit();
                    DatabaseConnection.close();
                }
                catch (Exception e3) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public String getLogFile() {
        return this.tests.getLogFile();
    }

    public static String getTestClassId() {
        return "SystemTables";
    }
}

