/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.sqlmanager;

import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.testcase.TestPreparedStatement;
import com.sap.sapdb.testframe.testcase.TestStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Properties;
import java.util.Random;

public class SharedCatalog_Test
extends TestCase {
    private static boolean mTestEndsWithoutError = true;
    static long mDDLCount = 0L;
    static final String lastUpdate = "19.05.2004 15:15";
    boolean m_stop = false;
    int m_maxUsers = 1500;
    int m_maxTablesPerUser = 3;
    Random m_random;

    private static boolean testEndsWithoutAnError() {
        return mTestEndsWithoutError;
    }

    public static long getTimeout() {
        return 0x6DDD00L;
    }

    public static void cleanUp() throws TestCaseException {
        if (!SharedCatalog_Test.testEndsWithoutAnError()) {
            return;
        }
        Connection mConnection = null;
        TestStatement mStmt = null;
        try {
            mConnection = SharedCatalog_Test.getDatabase().connect(SharedCatalog_Test.getUser(), SharedCatalog_Test.getPassword());
            mStmt = new TestStatement(null, mConnection);
            mStmt.executeUpdateIgnoreErrors("DROP TABLE TAB1");
            mStmt.executeUpdateIgnoreErrors("DROP TABLE TAB2");
            mConnection.commit();
        }
        catch (Exception e) {
            SharedCatalog_Test.addGlobalMessage((String)"Method cleanUp", (char)'E', (String)"cleanup failed");
            throw new TestCaseException("Error during cleanup: " + e.getClass() + e.getMessage());
        }
        System.out.println("End of " + SharedCatalog_Test.getTestClassId());
    }

    public static String getTestClassId() {
        return "SharedCatalog Test";
    }

    public static boolean isReferenceEnabled() {
        return true;
    }

    private void handleException(Exception e) {
        this.handleExceptions(e);
    }

    static void CreateRandomTable(Connection con, int TabId, int MaxColLength) throws SQLException {
        Random random = new Random(13L);
        block9: while (true) {
            try {
                while (true) {
                    int colCount = random.nextInt(1023);
                    int longCols = 0;
                    String createString = "CREATE TABLE TAB" + TabId + "(K INTEGER KEY";
                    int rowLength = 7;
                    int maxRand = 3;
                    for (int col = 0; col < colCount; ++col) {
                        createString = createString + ", COL" + col;
                        switch (random.nextInt(maxRand)) {
                            case 0: {
                                int length = 1 + random.nextInt(MaxColLength);
                                createString = createString + " CHAR(" + length + ")";
                                rowLength += length;
                                break;
                            }
                            case 1: {
                                createString = createString + " INTEGER ";
                                rowLength += 7;
                                break;
                            }
                            case 2: {
                                createString = createString + " LONG ASCII";
                                rowLength += 9;
                                if (1 != ++longCols) break;
                                --maxRand;
                            }
                        }
                        if (rowLength > 8000) break;
                    }
                    createString = createString + ")";
                    Statement stmt = con.createStatement();
                    stmt.execute(createString);
                    try {
                        Statement select = con.createStatement();
                        select.execute("SELECT * FROM TAB" + TabId);
                        break block9;
                    }
                    catch (SQLException x) {
                        if (-2003 != x.getErrorCode()) break block9;
                        Statement drop = con.createStatement();
                        drop.execute("DROP TABLE TAB" + TabId);
                        continue;
                    }
                    break;
                }
            }
            catch (SQLException e) {
                if (-2000 == e.getErrorCode()) continue;
                throw e;
            }
            break;
        }
        Statement grant = con.createStatement();
        grant.execute("grant all on TAB" + TabId + " to public");
    }

    public static void prepare(String SQLMode, int maxUsers, int tablesPerUser) throws TestCaseException {
        Connection mConnection = null;
        TestStatement mStmt = null;
        try {
            System.out.println("prepare called");
            Properties conProps = new Properties();
            conProps.put("user", SharedCatalog_Test.getUser());
            conProps.put("password", SharedCatalog_Test.getPassword());
            conProps.put("sqlmode", SQLMode);
            mConnection = SharedCatalog_Test.getDatabase().connect(conProps);
            mConnection.setAutoCommit(true);
            mStmt = new TestStatement(null, mConnection);
            mStmt.executeUpdateIgnoreErrors("DROP USER SHAREDCAT_USER");
            mStmt.executeUpdate("CREATE USER SHAREDCAT_USER PASSWORD SHAREDCAT_USER DBA NOT EXCLUSIVE");
            for (int ix = 0; ix < maxUsers; ++ix) {
                String user = "USER" + ix;
                String createSchemaStatement = "CREATE USER " + user + " PASSWORD U RESOURCE";
                mStmt.executeUpdate(createSchemaStatement);
                Properties userConProps = new Properties();
                userConProps.put("user", user);
                userConProps.put("password", "U");
                Connection userCon = SharedCatalog_Test.getDatabase().connect(userConProps);
                userCon.setAutoCommit(true);
                TestStatement stmt = new TestStatement(null, userCon);
                for (int tab = 0; tab < tablesPerUser; ++tab) {
                    SharedCatalog_Test.CreateRandomTable(userCon, tab, 300);
                }
                userCon.commit();
                userCon.close();
            }
            mConnection.commit();
            mConnection.close();
            mConnection = null;
            System.out.println("prepare finished successfully");
        }
        catch (Exception e) {
            SharedCatalog_Test.addGlobalMessage((String)"Method prepare", (char)'E', (String)("preparation failed " + mStmt.getSqlString() + " " + ((SQLException)e).getErrorCode() + ((SQLException)e).getLocalizedMessage()));
            throw new TestCaseException("Error during preparation: " + e.getClass() + e.getMessage());
        }
    }

    public void RunTest(String SQLMode, boolean SharedSQL, int ThreadCount, boolean DDLThread, boolean AutoCom, int wDMLCom, int wDMLRoll, int wDDL, int TimePerThread, int RndInteger, int RndString, int AddTime) throws TestCaseException {
        Connection mConnection = null;
        TestStatement mStmt = null;
        try {
            Properties conProps = new Properties();
            conProps.put("user", SharedCatalog_Test.getUser());
            conProps.put("password", SharedCatalog_Test.getPassword());
            conProps.put("sqlmode", SQLMode);
            mConnection = SharedCatalog_Test.getDatabase().connect(conProps);
            mConnection.setAutoCommit(true);
            mStmt = new TestStatement(null, mConnection);
            mConnection.close();
            long SleepTime = 60000L * (long)TimePerThread;
            System.out.println("ThreadCount " + ThreadCount);
            int maxUsers = this.m_maxUsers;
            int tablesPerUser = this.m_maxTablesPerUser;
            this.m_maxUsers = 1;
            this.m_maxTablesPerUser = 1;
            CatalogThread[] theThreads = new CatalogThread[ThreadCount + 1];
            for (int ix = 0; ix < ThreadCount - 1; ++ix) {
                theThreads[ix] = new CatalogReadThread(SQLMode, ix);
            }
            theThreads[ThreadCount] = new CatalogDDLThread(500);
            for (int minutes = 0; minutes < 60; ++minutes) {
                Thread.sleep(60000L);
                if (minutes > 0) {
                    if (minutes % 10 == 0) {
                        this.m_maxUsers = maxUsers;
                    } else if (minutes % 5 == 0) {
                        this.m_maxUsers = maxUsers > 10 ? 10 : maxUsers;
                    }
                }
                System.out.println("max users = " + this.m_maxUsers);
                if (this.m_stop) break;
            }
            this.addMessage("", 'I', "Stop all threads");
            this.m_stop = true;
            int countRunning = 0;
            for (int seconds = 0; seconds < 120; ++seconds) {
                Thread.sleep(1000L);
                countRunning = 0;
                for (int t = 0; t <= ThreadCount; ++t) {
                    try {
                        if (!theThreads[t].IsRunning()) continue;
                        ++countRunning;
                        continue;
                    }
                    catch (NullPointerException nullEx) {
                        // empty catch block
                    }
                }
                if (0 == countRunning) break;
            }
            if (0 != countRunning) {
                throw new TestCaseException("could not stop all threads");
            }
        }
        catch (Exception e) {
            throw new TestCaseException("Error testing locking functionality: " + e.getClass() + " " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        String SQLMode = null;
        try {
            System.out.println(SharedCatalog_Test.getTestClassId() + "; last update: " + lastUpdate);
            SQLMode = SharedCatalog_Test.getParameterString((String)"SQLMode", (String)"internal");
            if (!SQLMode.equalsIgnoreCase("oracle")) {
                SQLMode = "internal";
            }
            this.addMessage("", 'I', "SQLMode is " + SQLMode);
            this.addMessage("", 'I', "##### Stress testing ");
            int TestCount = SharedCatalog_Test.getParameterInt((String)"TestCount", (int)1);
            for (int i = 1; i <= TestCount; ++i) {
                boolean SharedSQL = SharedCatalog_Test.getParameterBoolean((String)("SharedSQL_" + i), (boolean)true);
                int ThreadCount = SharedCatalog_Test.getParameterInt((String)("ThreadCount_" + i), (int)21);
                boolean DDLThread = SharedCatalog_Test.getParameterBoolean((String)("DDLThread_" + i), (boolean)true);
                boolean AutoCom = SharedCatalog_Test.getParameterBoolean((String)("AutoCommit_" + i), (boolean)false);
                int wDMLCom = SharedCatalog_Test.getParameterInt((String)"wDMLCom_1", (int)20);
                int wDMLRoll = SharedCatalog_Test.getParameterInt((String)("wDMLRoll_" + i), (int)2);
                int wDDL = SharedCatalog_Test.getParameterInt((String)("wDDL_" + i), (int)2);
                int TimePerThread = SharedCatalog_Test.getParameterInt((String)("TimePerThread_" + i), (int)1);
                int RndInteger = SharedCatalog_Test.getParameterInt((String)("RndInteger_" + i), (int)1000);
                int RndString = SharedCatalog_Test.getParameterInt((String)("RndString_" + i), (int)3);
                int AddTime = SharedCatalog_Test.getParameterInt((String)("AddTime_" + i), (int)10);
                System.out.println("Run now " + i + " of " + TestCount);
                this.addMessage("", 'I', "### RUN " + i + "// SharedSQL: " + SharedSQL + "/ Threads: " + ThreadCount + "/ DDLThread: " + DDLThread + "/ AutoCommit: " + AutoCom + "/ wDMLCom: " + wDMLCom + "/ wDMLRoll: " + wDMLRoll + "/ wDDL: " + wDDL + "/ TimePerThread: " + TimePerThread + "/ RndInteger: " + RndInteger + "/ RndString: " + RndString + "/ AddTime: " + AddTime);
                SharedCatalog_Test.getDatabase().executeDBMcmd("sql_execute set parameter sharedsql = 'NO'");
                SharedCatalog_Test.prepare(SQLMode, this.m_maxUsers, this.m_maxTablesPerUser);
                this.RunTest(SQLMode, SharedSQL, ThreadCount, DDLThread, AutoCom, wDMLCom, wDMLRoll, wDDL, TimePerThread, RndInteger, RndString, AddTime);
            }
        }
        catch (Exception e) {
            mTestEndsWithoutError = false;
            if (e.getLocalizedMessage().indexOf("least one actor had an") != -1) {
                this.addMessage("run exception", 'I', "" + e.getClass() + "\n" + e.getLocalizedMessage());
            } else {
                this.addMessage("run exception", 'E', "" + e.getClass() + "\n" + e.getLocalizedMessage());
            }
            e.printStackTrace();
        }
    }

    private String paddTo(String str, int len) {
        int l = str.length();
        if (l < len) {
            char[] ca = new char[len - l];
            Arrays.fill(ca, ' ');
            return str + new String(ca);
        }
        if (l == len) {
            return str;
        }
        return str.substring(0, len);
    }

    class SQLBasicSelect
    extends CatalogThread {
        Connection mConnectionB;
        TestPreparedStatement mStmtB;

        SQLBasicSelect(String SQLMode) {
            this.mConnectionB = null;
            this.mStmtB = null;
        }

        public void run() {
            try {
                this.mConnectionB.commit();
            }
            catch (Exception ex) {
                SharedCatalog_Test.this.addMessage("", 'E', "" + ex.getLocalizedMessage());
                mTestEndsWithoutError = false;
            }
        }
    }

    class CatalogReadThread
    extends CatalogThread {
        private int m_threadId;

        CatalogReadThread(String SQLMode, int id) {
            this.m_threadId = id;
        }

        public void run() {
            Object rs = null;
            System.out.println("Reader Thread started");
            Random random = new Random(this.m_threadId * 17);
            try {
                boolean ix = false;
                TestStatement stmt = new TestStatement(null, this.m_connection);
                int selCount = 0;
                while (true) {
                    if (SharedCatalog_Test.this.m_stop) {
                        this.m_running = false;
                        return;
                    }
                    stmt.executeQuery("SELECT * FROM USER" + random.nextInt(SharedCatalog_Test.this.m_maxUsers) + ".TAB" + random.nextInt(SharedCatalog_Test.this.m_maxTablesPerUser));
                    ++selCount;
                }
            }
            catch (Exception ex) {
                SharedCatalog_Test.this.m_stop = true;
                System.out.println("ReadThreadError " + ex.getClass() + " " + ex.getMessage());
                SharedCatalog_Test.this.addMessage("", 'E', "" + ex.getLocalizedMessage());
                mTestEndsWithoutError = false;
                return;
            }
        }
    }

    class CatalogDDLThread
    extends CatalogThread {
        private int m_intervall;

        CatalogDDLThread(int intervall) {
            this.m_intervall = 0;
            this.m_intervall = intervall;
        }

        public void run() {
            while (true) {
                try {
                    Thread.sleep(this.m_intervall);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (SharedCatalog_Test.this.m_stop) {
                    this.m_running = false;
                    return;
                }
                Random random = new Random(17L);
                String alterStmt = null;
                try {
                    Statement alter = this.m_connection.createStatement();
                    if (SharedCatalog_Test.this.m_maxUsers > 1) {
                        alterStmt = "ALTER TABLE USER" + random.nextInt(SharedCatalog_Test.this.m_maxUsers) + ".TAB" + random.nextInt(SharedCatalog_Test.this.m_maxTablesPerUser);
                        if (random.nextInt(1000) < 500) {
                            alterStmt = alterStmt + " DYNAMIC";
                            continue;
                        }
                        alterStmt = alterStmt + " NOT DYNAMIC";
                        continue;
                    }
                    alterStmt = "alter table USER" + random.nextInt(SharedCatalog_Test.this.m_maxUsers) + ".TAB" + random.nextInt(SharedCatalog_Test.this.m_maxTablesPerUser) + " DROP COLUMN COL0";
                    alter.execute(alterStmt);
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    this.m_connection.rollback();
                    continue;
                }
                catch (Exception e) {
                    System.out.println(alterStmt + " failed : " + e.getMessage());
                    continue;
                }
                break;
            }
        }
    }

    class CatalogThread
    extends Thread {
        Connection m_connection = null;
        boolean m_running;

        CatalogThread() {
            Properties conProps = new Properties();
            try {
                conProps.put("user", TestCase.getUser());
                conProps.put("password", TestCase.getPassword());
                this.m_connection = TestCase.getDatabase().connect(conProps);
                this.m_connection.setAutoCommit(false);
                System.out.println("Thread connected");
                this.m_running = true;
                this.start();
            }
            catch (Exception ex) {
                System.out.println("Connection failed" + ex.getClass() + " " + ex.getMessage());
            }
        }

        public void run() {
        }

        boolean IsRunning() {
            return this.m_running;
        }
    }
}

