/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.sqlmanager;

import com.sap.dbtech.powertoys.Loader;
import com.sap.dbtech.powertoys.LoaderException;
import com.sap.dbtech.rte.comm.RTEException;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDatabaseSap;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.testcase.TestStatement;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Random;

public class RecordExtensions
extends TestCase {
    private static final String VERSION = "1.11";
    private static final String mExUser = "TESTER";
    private static final String mExPassword = "TESTER";
    private static int NON_LOB_COLUMN_COUNT = 9;
    private static Random rndGen;
    private static long rndSeed;
    private static int maxColSize;
    private static int maxRecLen;
    private static int tableRowCount;
    private static int maxLongColumnCount;
    private static boolean bDoLoaderExport;
    private static int stdoutLogLevel;
    private static int protLogLevel;
    private static int loopCount;
    private static boolean doCleanup;

    private void logMsg(int logLevel, String msg) {
        if (logLevel <= stdoutLogLevel) {
            System.out.println(msg);
        }
        if (logLevel == 0) {
            this.addMessage("", 'E', msg);
        } else if (logLevel <= protLogLevel) {
            this.addMessage("", 'I', msg);
        }
    }

    public static void prepare() throws TestCaseException {
        Connection con = null;
        TestStatement myStatement = null;
        System.out.println("Start of " + RecordExtensions.getTestClassId() + " " + VERSION);
        try {
            rndSeed = RecordExtensions.getParameterLong((String)"RandomSeed", (long)new Date().getTime());
            rndGen = new Random(rndSeed);
            doCleanup = RecordExtensions.getParameterBoolean((String)"DoCleanup", (boolean)true);
            maxColSize = RecordExtensions.getParameterInt((String)"MaxColumnLength", (int)1800);
            maxRecLen = RecordExtensions.getParameterInt((String)"MaxRecordLength", (int)30000);
            tableRowCount = RecordExtensions.getParameterInt((String)"TableRowCount", (int)75);
            maxLongColumnCount = RecordExtensions.getParameterInt((String)"MaxLongColCount", (int)100);
            bDoLoaderExport = RecordExtensions.getParameterBoolean((String)"LoaderExport", (boolean)true);
            stdoutLogLevel = RecordExtensions.getParameterInt((String)"StdoutLogLevel", (int)1);
            protLogLevel = RecordExtensions.getParameterInt((String)"ProtLogLevel", (int)1);
            loopCount = RecordExtensions.getParameterInt((String)"LoopCount", (int)100);
            con = RecordExtensions.getDatabase().connect(RecordExtensions.getUser(), RecordExtensions.getPassword());
            myStatement = new TestStatement(null, con, 1005, 1007);
            myStatement.enableExceptions(false);
            myStatement.execute("Alter User TESTER Disable Connect");
            myStatement.execute("Drop user TESTER");
            con.commit();
            myStatement.enableExceptions(true);
            myStatement.execute("Create user TESTER password TESTER dba not exclusive");
            myStatement.close();
            con.close();
        }
        catch (Exception e) {
            RecordExtensions.addGlobalMessage((String)"Method prepare", (char)'E', (String)"preparation failed");
            throw new TestCaseException("Error during preparation: " + e.getClass() + e.getMessage());
        }
    }

    public void run() {
        this.dumpConfig();
        try {
            Connection con = RecordExtensions.getDatabase().connect("TESTER", "TESTER");
            for (int i = 1; i <= loopCount; ++i) {
                this.logMsg(1, "Iteration no. " + i + ", " + (loopCount - i) + " more to go...");
                int lobColCount = rndGen.nextInt(maxLongColumnCount) + 1;
                int rowCount = rndGen.nextInt(tableRowCount) + 1;
                TestTable table = new TestTable("T", NON_LOB_COLUMN_COUNT, 0, 1, rowCount);
                this.testCycle(con, table);
                table.drop(con);
                table = new TestTable("T", NON_LOB_COLUMN_COUNT, lobColCount, 2, rowCount);
                this.testCycle(con, table);
                table.drop(con);
                table = new TestTable("T", NON_LOB_COLUMN_COUNT, lobColCount, 1, rowCount);
                this.testCycle(con, table);
                table.drop(con);
            }
        }
        catch (Exception e) {
            StringWriter stackTraceStr = new StringWriter();
            PrintWriter stackTrace = new PrintWriter(stackTraceStr);
            e.printStackTrace(stackTrace);
            RecordExtensions.addGlobalMessage((String)"Run", (char)'E', (String)("error during test run:\n" + e.getMessage() + ",\n" + stackTraceStr.toString()));
            e.printStackTrace();
        }
    }

    public static void cleanUp() throws TestCaseException {
        if (!doCleanup) {
            return;
        }
        try {
            Connection con = RecordExtensions.getDatabase().connect(RecordExtensions.getUser(), RecordExtensions.getPassword());
            TestStatement stmt = new TestStatement(null, con, 1005, 1007);
            stmt.enableExceptions(false);
            stmt.execute("Alter User TESTER Disable Connect");
            stmt.execute("Drop user TESTER");
            con.commit();
            stmt.enableExceptions(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void dumpConfig() {
        int actualProtLogLevel = protLogLevel;
        int actualStdoutLogLevel = stdoutLogLevel;
        protLogLevel = 1;
        stdoutLogLevel = 1;
        StringBuffer infoStr = new StringBuffer(1000);
        infoStr.append("\nRecord Extension Test V1.11\n");
        infoStr.append("===========================\n");
        infoStr.append("\nConfiguration");
        infoStr.append("\n-------------\n");
        infoStr.append("\nRandomSeed     : " + rndSeed);
        infoStr.append("\nMaxColumnLength: " + maxColSize);
        infoStr.append("\nMaxRecordLength: " + maxRecLen);
        infoStr.append("\nTableRowCount  : " + tableRowCount);
        infoStr.append("\nLoopCount      : " + loopCount);
        infoStr.append("\nLoaderExport   : " + bDoLoaderExport);
        infoStr.append("\nProtLogLevel   : " + actualProtLogLevel);
        infoStr.append("\nStdoutLogLevel : " + actualStdoutLogLevel);
        infoStr.append("\nDoCleanup      : " + doCleanup);
        infoStr.append("\n");
        this.logMsg(1, infoStr.toString());
        protLogLevel = actualProtLogLevel;
        stdoutLogLevel = actualStdoutLogLevel;
    }

    public Connection newUserConnection() throws TestDatabaseException {
        return RecordExtensions.getDatabase().connect("TESTER", "TESTER");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testCycle(Connection con, TestTable table) throws SQLException, TestCaseException, RTEException, LoaderException, TestDatabaseException {
        block10: {
            table.create(con);
            table.fillTable(con);
            table.verifyTableContent();
            table.update(con, 20000);
            table.check();
            table.verifyTableContent();
            table.update(con, 500);
            table.check();
            table.verifyTableContent();
            table.update(con, 10000);
            table.check();
            table.verifyTableContent();
            table.update(con, 30000);
            table.check();
            table.verifyTableContent();
            table.alterWithCopy(con, false);
            table.verifyTableContent();
            table.check();
            table.alterWithCopy(con, true);
            table.verifyTableContent();
            table.check();
            table.addForeignKey(con);
            if (!bDoLoaderExport) {
                return;
            }
            try {
                Loader loader = this.loaderConnect();
                if (rndGen.nextBoolean()) {
                    this.logMsg(1, " simple loader export");
                    table.loaderExport(loader);
                    if (rndGen.nextInt(8) > 0) {
                        table.loaderImport(loader);
                        table.check();
                        table.verifyTableContent();
                        break block10;
                    }
                    try {
                        this.logMsg(1, "  breaking foreign key");
                        table.breakForeignKey(con);
                        table.loaderImport(loader);
                        throw new TestCaseException("foreign key check must fail");
                    }
                    catch (LoaderException e) {
                        if (e.getMessage().indexOf("350") != -1) {
                            table.verifyTableContent();
                            break block10;
                        }
                        throw e;
                    }
                }
                this.logMsg(1, " loader export with table rewrite");
                this.alterAndExportImport(con, loader, table);
            }
            finally {
                if (doCleanup) {
                    table.deleteLoaderFiles();
                }
            }
        }
    }

    private void alterAndExportImport(Connection con, Loader loader, TestTable table) throws SQLException, TestCaseException, TestDatabaseException, RTEException, LoaderException {
        table.alterWithoutCopy(con);
        table.verifyTableContent();
        table.check();
        table.loaderExport(loader);
        table.verifyTableContent();
        table.check();
        table.loaderImport(loader);
        table.verifyTableContent();
        table.check();
    }

    private Loader loaderConnect() throws RTEException, LoaderException {
        Properties loaderProperties = new Properties();
        String hostString = RecordExtensions.getDatabase().getHost() + ":" + RecordExtensions.getDatabase().getPort();
        this.logMsg(3, "   loader 'host' property: '" + hostString + "'");
        loaderProperties.setProperty("host", hostString);
        loaderProperties.setProperty("dbname", RecordExtensions.getDatabase().getName());
        Loader loader = new Loader(loaderProperties);
        loader.cmd("USE USER TESTER TESTER");
        return loader;
    }

    static {
        maxColSize = -1;
        maxRecLen = -1;
        tableRowCount = -1;
        maxLongColumnCount = -1;
        bDoLoaderExport = true;
        stdoutLogLevel = 1;
        protLogLevel = 1;
        loopCount = -1;
        doCleanup = true;
    }

    class TestTable {
        public static final int ONLY_LONG = 0;
        public static final int ONLY_LONGFILE = 1;
        public static final int MIX_LONG_LONGFILE = 2;
        private static final int LOB_SIZE_IN_RECORD = 9;
        private String tableName;
        private int regularColumnCount;
        private int lobColumnCount;
        private int lobKind;
        private int tableRowCount;
        private ArrayList tableContents;
        private SimpleValueGenerator stringValueGenerator;
        private String fkTableName;
        private String loaderBaseName = null;

        public TestTable(String tableName, int regularColumnCount, int lobColumnCount, int lobKind, int rowCount) {
            RecordExtensions.this.logMsg(1, "create table " + tableName + " with " + lobColumnCount + " lobs, " + rowCount + " rows");
            this.tableName = tableName;
            this.regularColumnCount = regularColumnCount;
            this.lobColumnCount = lobColumnCount;
            this.lobKind = lobKind;
            this.tableRowCount = rowCount;
            this.stringValueGenerator = new SimpleValueGenerator(this.regularColumnCount);
        }

        public void breakForeignKey(Connection con) throws SQLException {
            if (this.fkTableName == null) {
                return;
            }
            PreparedStatement stmt = con.prepareStatement("Delete " + this.fkTableName + " Where i = ?");
            stmt.setInt(1, rndGen.nextInt(this.tableRowCount) + 1);
            stmt.execute();
        }

        public String getName() {
            return this.tableName;
        }

        public String getLoaderFileName() throws TestDatabaseException {
            if (this.loaderBaseName == null) {
                String runDir = ((TestDatabaseSap)TestCase.getDatabase()).getRunDir();
                this.loaderBaseName = runDir + File.separator + "loader-table-" + this.tableName;
            }
            return this.loaderBaseName;
        }

        public void create(Connection con) throws SQLException {
            StringBuffer createText = new StringBuffer("create table " + this.tableName + " (i integer," + " c1 varchar(505) unicode," + " c2 varchar(2015) unicode," + " c3 varchar(2015) unicode," + " c4 varchar(2015) unicode," + " c5 varchar(2015) unicode," + " c6 varchar(2015) unicode," + " c7 varchar(2015) unicode," + " c8 varchar(2015) unicode," + " primary key (c1, i)");
            block7: for (int i = 0; i < this.lobColumnCount; ++i) {
                switch (this.lobKind) {
                    case 0: {
                        createText.append(", l" + i + " long");
                        continue block7;
                    }
                    case 1: {
                        createText.append(", l" + i + " longfile");
                        continue block7;
                    }
                    case 2: {
                        if (rndGen.nextInt(5) < 4) {
                            createText.append(", l" + i + " long");
                            continue block7;
                        }
                        createText.append(", l" + i + " longfile");
                    }
                }
            }
            createText.append(")");
            this.drop(con);
            Statement stmt = con.createStatement();
            while (true) {
                try {
                    stmt.execute(createText.toString());
                    con.commit();
                }
                catch (SQLException e) {
                    if (e.getErrorCode() != -2000) {
                        throw e;
                    }
                    System.out.println("too many lob columns: " + this.lobColumnCount);
                    continue;
                }
                break;
            }
        }

        private void drop(Connection con) throws SQLException {
            block6: {
                Statement stmt;
                block5: {
                    stmt = con.createStatement();
                    try {
                        stmt.execute("Drop Table " + this.tableName);
                    }
                    catch (SQLException e) {
                        if (e.getErrorCode() == -4004) break block5;
                        throw e;
                    }
                }
                if (this.fkTableName != null) {
                    try {
                        stmt.execute("Drop Table " + this.fkTableName);
                    }
                    catch (SQLException e) {
                        if (e.getErrorCode() == -4004) break block6;
                        throw e;
                    }
                }
            }
        }

        public void fillTable(Connection con) throws SQLException, TestCaseException {
            RecordExtensions.this.logMsg(1, " fill table " + this.tableName + "; max record length = " + maxRecLen);
            int maxSepSize = 505;
            int minEnforcedSepSize = 50;
            int maxRandomWidth = maxSepSize - minEnforcedSepSize - 1;
            StringBuffer valueString = new StringBuffer(maxSepSize);
            for (int i = 0; i < minEnforcedSepSize; ++i) {
                valueString.append("1");
            }
            String identicalPart = valueString.toString();
            ArrayList<Integer> uniqueValues = new ArrayList<Integer>(this.tableRowCount);
            for (int i = 0; i < this.tableRowCount; ++i) {
                uniqueValues.add(new Integer(i));
            }
            Collections.shuffle(uniqueValues);
            PreparedStatement updStmt = null;
            StringBuffer updStmtText = new StringBuffer(this.lobColumnCount * 4);
            if (this.lobColumnCount > 0) {
                updStmtText.append("Update T Set l0 = ?");
                for (int i = 1; i < this.lobColumnCount; ++i) {
                    updStmtText.append(", l" + i + " = ?");
                }
                updStmtText.append("where i = ? and c1 = ?");
                updStmt = con.prepareStatement(updStmtText.toString());
            }
            PreparedStatement prepStmt = con.prepareStatement("Insert T (i,c1,c2,c3,c4,c5,c6,c7,c8) values (?, ?, ?, ?, ?, ?, ?, ?, ?)");
            this.tableContents = new ArrayList(this.tableRowCount);
            ArrayList<Integer> valueLengths = new ArrayList<Integer>(this.regularColumnCount);
            int rowNo = 1;
            Iterator iter = uniqueValues.iterator();
            while (iter.hasNext()) {
                String uniqueString;
                valueString.setLength(0);
                valueLengths.clear();
                if (maxSepSize > minEnforcedSepSize) {
                    this.createRandomString(valueString, rndGen.nextInt(maxRandomWidth));
                }
                if ((uniqueString = identicalPart + valueString.append((Integer)iter.next()).toString()).length() > maxSepSize) {
                    RecordExtensions.this.addMessage("Run", 'E', "unique insert string too long:\n" + uniqueString.length() + "\n " + uniqueString);
                }
                int colNo = 1;
                prepStmt.setInt(colNo++, rowNo);
                prepStmt.setString(colNo++, uniqueString);
                int colWidthLeft = maxRecLen - this.lobColumnCount * 9;
                for (int j = 0; j < this.regularColumnCount - 2; ++j) {
                    int curColLen = 0;
                    if (colWidthLeft > 0) {
                        curColLen = rndGen.nextInt(maxColSize) + 1;
                        if (curColLen > colWidthLeft) {
                            curColLen = colWidthLeft;
                        }
                        prepStmt.setString(colNo++, this.stringValueGenerator.getStringValue(j + 1, curColLen));
                    } else {
                        prepStmt.setString(colNo++, null);
                    }
                    colWidthLeft -= curColLen;
                    valueLengths.add(new Integer(curColLen));
                }
                prepStmt.execute();
                this.tableContents.add(new RowValue(rowNo, uniqueString, valueLengths));
                if (this.lobColumnCount > 0) {
                    colNo = 1;
                    for (int k = 0; k < this.lobColumnCount; ++k) {
                        updStmt.setString(colNo++, this.buildLobValue(rowNo, k));
                    }
                    updStmt.setInt(colNo++, rowNo);
                    updStmt.setString(colNo++, uniqueString);
                    updStmt.execute();
                }
                if (++rowNo % 100 != 0) continue;
                con.commit();
            }
            con.commit();
        }

        public void update(Connection con, int maxRecLen) throws SQLException, TestCaseException {
            RecordExtensions.this.logMsg(1, " update table " + this.tableName + "; max record length = " + maxRecLen);
            ArrayList<Integer> valueLengths = new ArrayList<Integer>(NON_LOB_COLUMN_COUNT);
            PreparedStatement prepStmt = con.prepareStatement("Update " + this.tableName + " Set c2 = ?, c3 = ?," + " c4 = ?, c5 = ?, c6 = ?, c7 = ?, c8 = ? where i = ?");
            int rowNo = 1;
            Iterator iter = this.tableContents.iterator();
            while (iter.hasNext()) {
                valueLengths.clear();
                RowValue rowValue = (RowValue)iter.next();
                int colNo = 1;
                int colWidthLeft = maxRecLen - this.lobColumnCount * 9;
                for (int j = 0; j < this.regularColumnCount - 2; ++j) {
                    int curColLen = 0;
                    if (colWidthLeft > 0) {
                        curColLen = rndGen.nextInt(maxColSize) + 1;
                        if (curColLen > colWidthLeft) {
                            curColLen = colWidthLeft;
                        }
                        prepStmt.setString(colNo++, this.stringValueGenerator.getStringValue(j + 1, curColLen));
                    } else {
                        prepStmt.setString(colNo++, null);
                    }
                    colWidthLeft -= curColLen;
                    valueLengths.add(new Integer(curColLen));
                }
                prepStmt.setInt(colNo++, rowNo);
                prepStmt.execute();
                rowValue.setValueLengths(valueLengths);
                if (++rowNo % 100 != 0) continue;
                con.commit();
            }
            con.commit();
        }

        public void loaderExport(Loader loader) throws RTEException, LoaderException, TestDatabaseException {
            RecordExtensions.this.logMsg(2, "  export table " + this.tableName + " to " + this.getLoaderFileName());
            loader.cmd("export table t catalog outstream \"" + this.getLoaderFileName() + ".cat\" pages");
            loader.cmd("export table t data outstream \"" + this.getLoaderFileName() + ".pages\" pages");
        }

        public void loaderImport(Loader loader) throws RTEException, LoaderException, TestDatabaseException {
            RecordExtensions.this.logMsg(2, "  import table " + this.tableName + " from " + this.getLoaderFileName());
            loader.cmd("drop table t");
            loader.cmd("import table t catalog instream \"" + this.getLoaderFileName() + ".cat\" pages");
            loader.cmd("import table t data instream \"" + this.getLoaderFileName() + ".pages\" pages");
        }

        public void deleteLoaderFiles() {
            try {
                File loaderFile = new File(this.getLoaderFileName() + ".cat");
                if (loaderFile.exists()) {
                    loaderFile.delete();
                }
                if ((loaderFile = new File(this.getLoaderFileName() + ".pages")).exists()) {
                    loaderFile.delete();
                }
            }
            catch (Exception e) {
                RecordExtensions.this.logMsg(0, "error during cleanup:" + e.getMessage());
            }
        }

        public void verifyTableContent() throws SQLException, TestCaseException, TestDatabaseException {
            RecordExtensions.this.logMsg(2, " verify table " + this.tableName);
            Connection con = RecordExtensions.this.newUserConnection();
            Statement stmt = con.createStatement();
            ResultSet res = stmt.executeQuery("Select i,c1,c2,c3,c4,c5,c6,c7,c8 from T order by i,c1");
            int rowNo = 1;
            boolean bError = false;
            while (res.next()) {
                String uniqueVal;
                RowValue rowValue = (RowValue)this.tableContents.get(rowNo - 1);
                int colNo = 1;
                int retrievedRowNo = res.getInt(colNo++);
                if (rowValue.getRowNo() != retrievedRowNo) {
                    RecordExtensions.this.logMsg(0, " error verifying table " + this.tableName + ":\n" + "found i '" + retrievedRowNo + "' != expected i '" + rowValue.getRowNo() + "'");
                    bError = true;
                }
                if (!(uniqueVal = res.getString(colNo++)).equals(rowValue.getUniqueCol())) {
                    RecordExtensions.this.logMsg(0, " error verifying table " + this.tableName + ":\n" + "found uniqueVal '" + uniqueVal + "' != expected uniqueVal '" + rowValue.getUniqueCol() + "'");
                    bError = true;
                }
                for (int i = 0; i < this.regularColumnCount - 2; ++i) {
                    String colVal = res.getString(colNo++);
                    int strLen = (Integer)rowValue.getValueLengths().get(i);
                    String expVal = this.stringValueGenerator.getStringValue(i + 1, strLen);
                    if (colVal != null) {
                        if (colVal.equals(expVal)) continue;
                        RecordExtensions.this.logMsg(0, " error verifying table " + this.tableName + ":\n" + "found colNo " + (colNo - 1) + " '" + colVal + "' != expected  '" + expVal + "'");
                        bError = true;
                        continue;
                    }
                    if (this.stringValueGenerator.getStringValue(i + 1, strLen) == null) continue;
                    RecordExtensions.this.logMsg(0, " error verifying table " + this.tableName + ":\n" + "found colNo " + (colNo - 1) + " '" + colVal + "' != expected  '" + expVal + "'");
                    bError = true;
                }
                if (bError) {
                    RecordExtensions.this.addMessage("Run", 'E', "verify failed for row " + rowNo);
                    throw new TestCaseException("verify failed");
                }
                ++rowNo;
            }
            res.close();
            StringBuffer stmtText = new StringBuffer(1000);
            stmtText.append("Select i");
            for (int k = 0; k < this.lobColumnCount; ++k) {
                stmtText.append(", l" + k);
            }
            stmtText.append(" from t order by i,c1");
            res = stmt.executeQuery(stmtText.toString());
            bError = false;
            rowNo = 1;
            while (res.next()) {
                RowValue rowValue = (RowValue)this.tableContents.get(rowNo - 1);
                int colNo = 1;
                if (rowValue.getRowNo() != res.getInt(colNo++)) {
                    bError = true;
                }
                for (int i = 0; i < this.lobColumnCount; ++i) {
                    String lobVal;
                    if ((lobVal = res.getString(colNo++)) == null) {
                        RecordExtensions.this.logMsg(0, " error verifying lobs of table " + this.tableName + ":\n" + "lob value must not be NULL in lob col no " + (colNo - 1));
                        bError = true;
                        break;
                    }
                    if (lobVal.equals(this.buildLobValue(rowNo, i))) continue;
                    RecordExtensions.this.logMsg(0, " error verifying lobs of table " + this.tableName + ":\n" + "found lob col no " + (colNo - 1) + " '" + lobVal + "' != expected  '" + this.buildLobValue(rowNo, i) + "'");
                    bError = true;
                    break;
                }
                if (bError) {
                    RecordExtensions.this.addMessage("Run", 'E', "verify of lob values failed for row " + rowNo);
                    throw new TestCaseException("verify failed");
                }
                ++rowNo;
            }
            res.close();
            this.verifyFileDirCounter(con);
            con.close();
        }

        public void verifyFileDirCounter(Connection con) throws SQLException, TestCaseException {
            PreparedStatement stmt = con.prepareStatement("Select f.ENTRYCOUNT, f.TREEINDEXSIZE, f.TREELEAVESSIZE, f.LOBSIZE from FILES f, TABLES t where t.OWNER = user and t.TABLENAME = ? and t.TABLEID = f.FILEID");
            stmt.setString(1, this.tableName);
            ResultSet res = stmt.executeQuery();
            res.next();
            int colNo = 1;
            int filesEntryCount = res.getInt(colNo++);
            int filesTreeIndexSize = res.getInt(colNo++);
            int filesTreeLeavesSize = res.getInt(colNo++);
            int filesLobSize = res.getInt(colNo++);
            res.close();
            int tsEntryCount = -1;
            int tsTreeIndexSize = -1;
            int tsTreeLeavesSize = -1;
            int tsLobSize = -1;
            stmt = con.prepareStatement("Select DESCRIPTION, NUMERIC_VALUE from TABLESTATISTICS where OWNER = user and TABLENAME = ? and (DESCRIPTION = 'Rows' or DESCRIPTION = 'Index pages' or DESCRIPTION = 'Leaf  pages' or DESCRIPTION = 'LOB column pages' or DESCRIPTION = 'LONG column pages')");
            stmt.setString(1, this.tableName);
            res = stmt.executeQuery();
            while (res.next()) {
                colNo = 1;
                String desc = res.getString(colNo++);
                int val = res.getInt(colNo++);
                if (desc.equals("Rows")) {
                    tsEntryCount = val;
                    continue;
                }
                if (desc.equals("Index pages")) {
                    tsTreeIndexSize = val * 8;
                    continue;
                }
                if (desc.equals("Leaf  pages")) {
                    tsTreeLeavesSize = val * 8;
                    continue;
                }
                if (!desc.equals("LOB column pages") && !desc.equals("LONG column pages")) continue;
                tsLobSize = val * 8;
            }
            boolean bError = false;
            if (filesEntryCount != tsEntryCount) {
                bError = true;
            }
            if (filesTreeIndexSize != tsTreeIndexSize) {
                bError = true;
            }
            if (filesTreeLeavesSize != tsTreeLeavesSize) {
                bError = true;
            }
            if (filesLobSize != tsLobSize) {
                bError = true;
            }
            if (bError) {
                RecordExtensions.this.logMsg(0, "incorrect file dir counters (FILES,TABLESTATISTICS):\nentry count: " + filesEntryCount + ", " + tsEntryCount + "\nindex size : " + filesTreeIndexSize + ", " + tsTreeIndexSize + "\nleaf size  : " + filesTreeLeavesSize + ", " + tsTreeLeavesSize + "\nlob size   : " + filesLobSize + ", " + tsLobSize);
                throw new TestCaseException("verify failed: incorrect table entry count");
            }
            res.close();
        }

        public void addForeignKey(Connection con) throws SQLException {
            RecordExtensions.this.logMsg(2, " TestTable::addForeignKey " + this.tableName);
            if (this.fkTableName != null) {
                return;
            }
            this.fkTableName = this.tableName + "_FK";
            Statement stmt = con.createStatement();
            stmt.execute("Create Table " + this.fkTableName + " (i integer, fk varchar(505) unicode, primary key(fk))");
            stmt.execute("Insert " + this.fkTableName + " (i,fk) Select i,c1 from " + this.tableName);
            stmt.execute("Alter Table " + this.tableName + " Add Foreign Key (c1) references " + this.fkTableName + "(fk) on delete cascade");
        }

        public void alterWithoutCopy(Connection con) throws SQLException {
            RecordExtensions.this.logMsg(2, " TestTable::alterWithoutCopy " + this.tableName);
            Statement stmt = con.createStatement();
            stmt.execute("Create Table TEMP.storage As Select i,C2 from " + this.tableName);
            stmt.execute("Alter Table " + this.tableName + " Drop C2");
            stmt.execute("Alter Table " + this.tableName + " Add C2 Varchar(2015)");
            stmt.execute("Update " + this.tableName + " t set C2 = (Select C2 from TEMP.storage where t.i = TEMP.storage.i)");
            stmt.execute("Drop Table TEMP.storage");
        }

        public void alterWithCopy(Connection con, boolean sorted) throws SQLException {
            RecordExtensions.this.logMsg(2, " TestTable::alterWithCopy " + this.tableName);
            Statement stmt = con.createStatement();
            if (sorted) {
                stmt.execute("Alter Table " + this.tableName + " Add ExtraLong Long");
            } else {
                stmt.execute("Create Index " + this.tableName + "_I  on " + this.tableName + " (c1)");
                stmt.execute("Alter Table " + this.tableName + " Drop Primary Key");
                stmt.execute("Alter Table " + this.tableName + " Add Primary Key (c1)");
            }
        }

        public void check() throws SQLException, TestDatabaseException {
            RecordExtensions.this.logMsg(2, " check table " + this.tableName);
            Connection con = RecordExtensions.this.newUserConnection();
            Statement stmt = con.createStatement();
            stmt.execute("Check Table " + this.tableName + " With Long Check");
            con.close();
        }

        private void createRandomString(StringBuffer randomString, int length) {
            randomString.setLength(0);
            if (length > 1) {
                int nullFillLen = rndGen.nextInt(length - 1);
                for (int i = 0; i < nullFillLen; ++i) {
                    randomString.append("0");
                }
                length -= nullFillLen;
            }
            for (int i = 0; i < length; ++i) {
                randomString.append(rndGen.nextInt(10));
            }
        }

        private String buildLobValue(int rowNo, int colNo) {
            return "LOB" + rowNo + colNo;
        }
    }

    class SimpleValueGenerator {
        private ArrayList colValues;

        public SimpleValueGenerator(int columnCount) {
            int i;
            this.colValues = new ArrayList(columnCount);
            StringBuffer fillStr = new StringBuffer(maxColSize);
            for (i = 0; i < maxColSize; ++i) {
                fillStr.append("0");
            }
            for (i = 0; i < 8; ++i) {
                String iStr = String.valueOf(i + 1);
                this.colValues.add(fillStr.substring(0, maxColSize - iStr.length()) + iStr);
            }
        }

        public String getStringValue(int colNo, int stringLength) {
            String colString = (String)this.colValues.get(colNo - 1);
            if (stringLength == 0) {
                return null;
            }
            int startPos = colString.length() - stringLength + 1;
            return colString.substring(startPos);
        }
    }

    class RowValue {
        private int rowNo;
        private String uniqueCol;
        private ArrayList valueLengths;

        public RowValue(int rowNo, String uniqueCol, List valueLengths) {
            this.rowNo = rowNo;
            this.uniqueCol = uniqueCol;
            this.valueLengths = new ArrayList(valueLengths);
        }

        public int getRowNo() {
            return this.rowNo;
        }

        public String getUniqueCol() {
            return this.uniqueCol;
        }

        public List getValueLengths() {
            return this.valueLengths;
        }

        public void setValueLengths(ArrayList valueLengths) {
            this.valueLengths.clear();
            this.valueLengths.addAll(valueLengths);
        }
    }
}

