/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.sqlmanager;

import com.sap.sapdb.oltptest.sqlmanager.DatabaseObject;
import com.sap.sapdb.oltptest.sqlmanager.QueryTests;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDatabaseSap;
import com.sap.sapdb.testframe.driver.TestDriver;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.testcase.TestStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;

public class HintQueryTest
extends TestCase {
    private static Properties DBAConnectionProperties;
    private static Properties MonaConnectionProperties;
    private static String SCHEMANAME;
    private String testrunname;
    private static final int USERCOUNT = 1;
    private static int TABLECOUNT;
    private Vector tableList = new Vector();
    private boolean UNICODE;
    private boolean additionalTests = false;
    private static Vector HINTLIST;
    private String DATABASEVERSION;
    private String stopOnError = "0";
    private static Vector queryList;
    private static int runtime;
    private QueryTests tests;

    public static void prepare() throws TestCaseException {
        System.out.println("Prepare of " + HintQueryTest.getTestClassId());
        runtime = HintQueryTest.getParameterInt((String)"Runtime", (int)120);
        DBAConnectionProperties = new Properties();
        MonaConnectionProperties = new Properties();
        DBAConnectionProperties.put("user", HintQueryTest.getUser());
        DBAConnectionProperties.put("password", HintQueryTest.getPassword());
        DBAConnectionProperties.put("autocommit", "on");
        DBAConnectionProperties.put("sqlmode", "internal");
        MonaConnectionProperties.put("user", "MONA");
        MonaConnectionProperties.put("password", "RED");
        MonaConnectionProperties.put("autocommit", "on");
        MonaConnectionProperties.put("sqlmode", "internal");
        queryList.add("SELECT* from custom_hotel ");
        queryList.add("SELECT firstname, name  FROM hotel.customer ");
        queryList.add("SELECT *  FROM hotel.customer ");
        queryList.add("SELECT name, firstname  FROM hotel.customer ");
        queryList.add("SELECT zip, name city_name  FROM hotel.city  WHERE state = 'NY' ");
        queryList.add("SELECT zip, name  FROM hotel.city  WHERE name = 'Washington' ");
        queryList.add("SELECT DISTINCT name, state  FROM hotel.city  ORDER BY name ");
        queryList.add("SELECT title, name  FROM hotel.customer  WHERE title ='Company' ");
        queryList.add("SELECT firstname, name, zip  FROM hotel.customer  WHERE name > 'Randolph' ");
        queryList.add("SELECT firstname, name, zip  FROM hotel.customer  WHERE (title ='Company') AND (name > 'Randolph') ");
        queryList.add("SELECT title, name, zip  FROM hotel.customer  WHERE zip BETWEEN '10000' AND '30000' ");
        queryList.add("SELECT title, firstname, name  FROM hotel.customer  WHERE title IN ('Mr', 'Mrs') ");
        queryList.add("SELECT firstname, name  FROM hotel.customer  WHERE name LIKE 'P%' ");
        queryList.add("SELECT firstname, name  FROM hotel.customer  WHERE name LIKE '%er' ");
        queryList.add("SELECT firstname, name  FROM hotel.customer  WHERE firstname LIKE '_i__' ");
        queryList.add("SELECT firstname, name  FROM hotel.customer  WHERE name LIKE '_%an%' ");
        queryList.add("SELECT name, state  FROM hotel.city  WHERE NOT (state = 'CA' OR state = 'DC' OR state = 'IL' OR state = 'NY') ");
        queryList.add("SELECT name, state  FROM hotel.city  WHERE NOT (state BETWEEN 'CA' AND 'NY') ");
        queryList.add("SELECT name, state  FROM hotel.city  WHERE state NOT BETWEEN 'CA' AND 'NY' ");
        queryList.add("SELECT name, state  FROM hotel.city  WHERE NOT (state IN ('CA', 'DC', 'IL', 'NY')) ");
        queryList.add("SELECT name, state  FROM hotel.city  WHERE state NOT IN ('CA', 'DC', 'IL', 'NY') ");
        queryList.add("SELECT firstname, name  FROM hotel.customer  WHERE NOT (firstname LIKE '%e%') ");
        queryList.add("SELECT firstname, name  FROM hotel.customer  WHERE firstname NOT LIKE '%e%' ");
        queryList.add("SELECT firstname, name  FROM hotel.customer  WHERE NOT (firstname IS NULL) ");
        queryList.add("SELECT firstname, name  FROM hotel.customer  WHERE firstname IS NOT NULL ");
        queryList.add("SELECT type, SUM(free)  FROM hotel.room  GROUP BY type ");
        queryList.add("SELECT type, MIN(price) min_price, FIXED (AVG(price),5,2) avg_price, MAX(price) max_price  FROM hotel.room  GROUP BY type ");
        queryList.add("SELECT type, MIN(price) min_price, FIXED(AVG(price),5,2) avg_price, MAX(price) max_price  FROM hotel.room  GROUP BY type  HAVING MIN(price) >= 70 ");
        queryList.add("SELECT hno, price*7 weekly_price, type  FROM hotel.room  WHERE type = 'single' AND hno <50 ");
        queryList.add("SELECT hno, type, price  FROM hotel.room  WHERE price*7 < 500 AND type = 'single' ");
        queryList.add("SELECT hno, type, price  FROM hotel.room  WHERE (price*1.05)*7 < 500 AND type = 'single' ");
        queryList.add("SELECT cno, name & ', ' & firstname name  FROM hotel.customer WHERE cno = 3000 ");
        queryList.add("SELECT cno, SUBSTR(firstname,1,1) & '. ' & name name  FROM hotel.customer WHERE cno = 3000 ");
        queryList.add("SELECT rno, arrival, DAYNAME(arrival) arrival_day FROM hotel.reservation WHERE rno < 150 ");
        queryList.add("SELECT name, 675456 number_of_days, DATE(675456) counted_date FROM hotel.city WHERE zip = '12203' ");
        queryList.add("SELECT hno,  CASE  WHEN price IS NULL THEN 'Not yet priced'  WHEN price < 70 THEN 'Very cheap'  WHEN price >= 70 AND price < 100 THEN 'Normal price'  ELSE 'Expensive hotel'  END price_range  FROM hotel.room WHERE hno < 100 AND type = 'single' ");
        queryList.add("SELECT hno,  CASE price  WHEN NULL THEN 'Not yet priced'  WHEN 70 THEN 'Very cheap'  WHEN 90 THEN 'Cheap'  WHEN 100 THEN 'Normal hotel'  WHEN 115 THEN 'Expensive hotel'  WHEN 135 THEN 'Very expensive hotel'  ELSE 'Not yet in price_range list'  END price  FROM hotel.room WHERE hno < 100 AND type = 'single' ");
        queryList.add("SELECT hno, avgprice(zip) avgprice FROM hotel.hotel WHERE hno = 40 ");
        queryList.add("SELECT COUNT(*) number  FROM hotel.customer ");
        queryList.add("SELECT COUNT(DISTINCT name) number_city  FROM hotel.city ");
        queryList.add("SELECT SUM(price) sum_price, MIN(price) min_price, FIXED(AVG(price),5,2) avg_price, MAX(price) max_price, COUNT(*) number_room  FROM hotel.room  WHERE type = 'single' ");
        queryList.add("SELECT arrival, ADDDATE (arrival,2) new_arrival, rno  FROM hotel.reservation  WHERE rno = 130 ");
        queryList.add("SELECT arrival, departure, DATEDIFF(departure, arrival) overnight_stays, rno  FROM hotel.reservation  WHERE rno = 130 ");
        queryList.add("SELECT * FROM hotel.hotel  WHERE CHR(hno) LIKE '1__' ");
        queryList.add("SELECT * FROM hotel.hotel WHERE UPPER(name) = 'STAR' ");
        queryList.add("SELECT VALUE(firstname, 'Company') firstname, name  FROM hotel.customer  WHERE firstname IS NULL ");
        queryList.add("SELECT hno, price, DECODE(type, 'single', 1, 'double', 2, 'suite', 3) code  FROM hotel.room  WHERE hno < 60 ");
        queryList.add("SELECT name & ', ' & firstname name, zip  FROM hotel.customer  WHERE cno < 3500 ");
        queryList.add("SELECT RTRIM(title,'any') title, name  FROM hotel.customer  WHERE title = 'Company' ");
        queryList.add("SELECT title, SUBSTR(firstname,1,1)& '. '&name name  FROM hotel.customer  WHERE firstname IS NOT NULL ");
        queryList.add("SELECT LFILL(firstname,' ',10) firstname, name  FROM hotel.customer  WHERE firstname IS NOT NULL AND title = 'Mrs' ");
        queryList.add("SELECT hno, zip, REPLACE(address,'Str.','Street') address  FROM hotel.hotel  WHERE zip < '40000' ");
        queryList.add("SELECT name, TRANSLATE(name,'ae','xy') name_new  FROM hotel.customer  WHERE cno > 4000 ");
        queryList.add("SELECT name, LENGTH(name) len  FROM hotel.customer  WHERE title = 'Mrs' ORDER BY len, name ");
        queryList.add("SELECT name, INITCAP(name) name_new  FROM hotel.customer  WHERE firstname IS NULL ");
        queryList.add("SELECT name, INDEX(name,'er') position_er  FROM hotel.customer  WHERE title = 'Mrs' ");
        queryList.add("SELECT title, MIN(name) min_name  FROM hotel.customer  GROUP BY title ");
        queryList.add("SELECT name, zip  FROM hotel.customer  WHERE zip = (SELECT MAX(zip) FROM hotel.customer) ");
        queryList.add("SELECT hno, name, zip  FROM hotel.hotel  WHERE zip IN(SELECT zip FROM hotel.customer WHERE title = 'Mrs') ");
        queryList.add("SELECT hno, name  FROM hotel.hotel  WHERE name = ANY(SELECT name FROM hotel.city) ");
        queryList.add("SELECT cno, name  FROM hotel.customer  WHERE cno = ANY(SELECT cno FROM hotel.reservation WHERE arrival > '2005-01-01') ");
        queryList.add("SELECT hno, type, price  FROM hotel.room room_table  WHERE price =  (SELECT MAX(price) FROM hotel.room WHERE type = room_table.type) ");
        queryList.add("SELECT cno, title, name FROM hotel.customer  WHERE EXISTS  (SELECT * FROM hotel.reservation  WHERE hotel.customer.cno = hotel.reservation.cno) ");
        queryList.add("SELECT reservation.rno, customer.name, reservation.arrival, reservation.departure  FROM hotel.customer, hotel.reservation  WHERE customer.name = 'Porter'  AND customer.cno = reservation.cno ");
        queryList.add("SELECT customer.name, reservation.rno, hotel.name hotel_name  FROM hotel.customer, hotel.reservation, hotel.hotel  WHERE customer.name = 'Porter'  AND customer.cno=reservation.cno  AND reservation.hno = hotel.hno ");
        queryList.add("SELECT hotel.name hotel_name, city.zip, city.name city_name  FROM hotel.hotel, hotel.city  WHERE city.state = 'CA' AND city.zip=hotel.zip ");
        queryList.add("SELECT hotel.name hotel_name, city.zip, city.name city_name  FROM hotel.hotel, hotel.city  WHERE city.state = 'CA' AND city.zip=hotel.zip (+) ");
        queryList.add("SELECT zip customer_zip FROM hotel.customer WHERE zip > '90000' ");
        queryList.add("SELECT zip hotel_zip FROM hotel.hotel WHERE zip> '90000' ");
        queryList.add("SELECT zip FROM hotel.customer WHERE zip > '90000'  UNION SELECT zip FROM hotel.hotel WHERE zip > '90000' ");
        queryList.add("SELECT hno hno_or_cno, name hotel_or_customer_name, zip  FROM hotel.hotel WHERE zip < '30000'  UNION SELECT cno, name, zip  FROM hotel.customer WHERE zip < '30000' ");
        queryList.add("SELECT zip FROM hotel.customer WHERE zip < '30000'   INTERSECT  SELECT zip FROM hotel.hotel WHERE zip < '30000' ");
        queryList.add("SELECT zip FROM hotel.hotel WHERE zip < '30000'   EXCEPT  SELECT zip FROM hotel.customer WHERE zip < '30000'   ");
        queryList.add("select hadr.*,cadr.*, departure,arrival, datediff(departure, arrival) Days, r.price*datediff(departure, arrival) Cost from hotel.customer_addr cadr,hotel.reservation res, hotel.hotel_addr hadr , hotel.room r where res.hno=hadr.hno and res.hno =  r.hno and res.type=r.type and res.cno = cadr.cno");
        queryList.add("SELECT customer_addr.name, customer_addr.city, hotel_addr.name, hotel_addr.city  FROM customer_addr, hotel_addr, reservation  WHERE customer_addr.cno = reservation.cno AND hotel_addr.hno = reservation.hno ");
        HINTLIST.add("keyaccess");
        HINTLIST.add("indexaccess");
        HINTLIST.add("keyscan");
        HINTLIST.add("KEYRANGE");
        HINTLIST.add("indexscan");
        HINTLIST.add("INDEXRANGE");
        HINTLIST.add("BUILDRESULT");
        HINTLIST.add("FETCHRESULT");
        HINTLIST.add("ENABLE_MERGE");
        HINTLIST.add("DISABLE_INVONLY");
        HINTLIST.add("L1_STRATEGY");
        HINTLIST.add("L2_STRATEGY");
        HINTLIST.add("L2_RANGE_STRATEGY");
        HINTLIST.add("L2_MORE_STRATEGIES");
        HINTLIST.add("L2_STRAT_NO_OPTIM");
        HINTLIST.add("IN_STRATEGY");
        HINTLIST.add("SUBQ_STRATEGY");
        HINTLIST.add("ORDERED");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block34: {
            DatabaseObject table = null;
            ResultSet res1 = null;
            Connection DatabaseConnection = null;
            TestStatement runStatement = null;
            SimpleDateFormat fmt = new SimpleDateFormat();
            fmt.applyPattern("yyyy-MM-dd_HH-mm-ss");
            this.testrunname = this.getTestId() + "_Log_" + fmt.format(new Date());
            System.out.println("Run of " + HintQueryTest.getTestClassId());
            DatabaseConnection = HintQueryTest.getDatabase().connect(DBAConnectionProperties);
            this.UNICODE = HintQueryTest.getDatabase().executeDBMcmd("param_getvalue _UNICODE").trim().equalsIgnoreCase("yes");
            this.DATABASEVERSION = ((TestDatabaseSap)HintQueryTest.getDatabase()).getKernelVersion() + "." + ((TestDatabaseSap)HintQueryTest.getDatabase()).getKernelBuild().substring(0, 3);
            this.stopOnError = HintQueryTest.getParameterString((String)"StopOnError", (String)"0");
            if (!this.stopOnError.equals("0")) {
                HintQueryTest.getDatabase().executeDBMcmd("util_connect");
                HintQueryTest.getDatabase().executeDBMcmd("util_execute DIAGNOSE VTRACE STOP ON ERROR " + this.stopOnError);
                HintQueryTest.getDatabase().executeDBMcmd("util_release");
            }
            int precision = HintQueryTest.getParameterInt((String)"Precision", (int)3);
            int queriesPerStatement = HintQueryTest.getParameterInt((String)"queriesPerStatement", (int)10);
            this.additionalTests = HintQueryTest.getParameterBoolean((String)"additionalTests", (boolean)false);
            System.out.println("Testrun: \t" + this.testrunname);
            System.out.println("Usercount: \t1");
            System.out.println("Unicode: \t" + this.UNICODE);
            System.out.println("Tablecount: \t" + TABLECOUNT);
            System.out.println("Stop on Error: \t" + HintQueryTest.getParameterString((String)"StopOnError", (String)"0") + "  (Parameter: StopOnError)");
            System.out.println("Precision: \t" + precision + "  (Parameter: precision)");
            System.out.println("Additional Tests: \t" + this.additionalTests + "  (Parameter: additionalTests)");
            System.out.println("Different Hints per SQLStatement: \t" + queriesPerStatement + "  (Parameter: queriesPerStatement)");
            System.out.println("MaxRuntime in minutes: \t" + runtime);
            this.addMessage("", 'I', "Testrun: \t" + this.testrunname + "\nUsercount: \t" + 1 + "\nUnicode: \t" + this.UNICODE + "\nTablecount: \t" + TABLECOUNT + "\nStop on Error: \t" + HintQueryTest.getParameterString((String)"StopOnError", (String)"0") + "  (Parameter: StopOnError)" + "\nPrecision: \t" + precision + "  (Parameter: precision)" + "\nAdditional Tests: \t" + this.additionalTests + "  (Parameter: additionalTests)" + "\nDifferent Hints per SQLStatement: \t" + queriesPerStatement + "  (Parameter: queriesPerStatement)" + "\nMaxRuntime in minutes: \t" + runtime);
            Connection dbaUserConnection = HintQueryTest.getDatabase().connect(DBAConnectionProperties);
            TestStatement dbaUserStatement = new TestStatement((TestCase)this, dbaUserConnection);
            dbaUserStatement.executeUpdateIgnoreErrors("drop user mona");
            dbaUserStatement.close();
            dbaUserConnection.close();
            HintQueryTest.getDatabase().executeDBMcmd("load_tutorial");
            Connection testUserConnection = HintQueryTest.getDatabase().connect(MonaConnectionProperties);
            TestStatement testUserStatement = new TestStatement((TestCase)this, testUserConnection);
            testUserStatement.executeUpdateIgnoreErrors("create view hotel.employee_count as select h.hno,h.name, count(*) employees from hotel.hotel h, hotel.employee e where h.hno = e.hno group by h.hno,h.name");
            testUserStatement.execute("CREATE INDEX name_index ON hotel.customer (name)");
            testUserStatement.execute("CREATE INDEX hotel_name_index ON hotel.hotel (name)");
            testUserStatement.execute("CREATE INDEX name_state ON hotel.city (name,state)");
            testUserStatement.execute("CREATE INDEX full_name_index_employee ON hotel.employee (name,firstname)");
            testUserStatement.execute("CREATE UNIQUE INDEX address_index ON hotel.customer (firstname,name,address)");
            testUserStatement.executeUpdateIgnoreErrors("CREATE FUNCTION hotel.avgprice (zip CHAR(5)) RETURNS FIXED(6,2) AS VAR sum FIXED(10,2); price FIXED(6,2); hotels INTEGER; avg_price FIXED(6,2); TRY SET sum = 0; SET hotels = 0; DECLARE functionresult CURSOR FOR SELECT price FROM hotel.room,hotel.hotel WHERE zip = :zip AND room.hno = hotel.hno AND type = 'single'; WHILE $rc = 0 DO BEGIN FETCH functionresult INTO :price; SET sum = sum + price; SET hotels = hotels + 1; END; CATCH IF $rc <> 100 THEN STOP ($rc, 'unexpected error'); CLOSE functionresult; IF hotels > 0 THEN RETURN sum/hotels  ELSE RETURN NULL;");
            testUserStatement.executeUpdateIgnoreErrors("update stat *");
            res1 = testUserStatement.executeQuery("select SCHEMANAME,tablename,Tabletype from tables where Schemaname = 'HOTEL'");
            while (res1.next()) {
                this.tableList.add(new DatabaseObject(res1.getString(1), res1.getString(2), res1.getString(3)));
            }
            String Query1 = "select * from ";
            String Query = "";
            Iterator it1 = this.tableList.iterator();
            while (it1.hasNext()) {
                table = (DatabaseObject)it1.next();
                try {
                    Query = Query1 + table.getObjectIdentifier();
                    res1 = testUserStatement.executeQuery(Query);
                    table.setColumnList(res1.getMetaData());
                }
                catch (Exception e) {
                    this.addMessage("Data collection SQL-statement " + testUserStatement.getSqlString() + " failed", 'E', e.toString());
                    throw new TestCaseException("Data collection SQL-statement " + testUserStatement.getSqlString() + " failed");
                }
            }
            System.out.println(this.tableList.size() + " Tables/Views found");
            System.out.println("DataCollection completed");
            testUserStatement.close();
            testUserConnection.close();
            this.tests = new QueryTests(this, this.testrunname, (TestDatabaseSap)HintQueryTest.getDatabase(), this.tableList, MonaConnectionProperties, 1, true, new Properties());
            this.tests.verifyMetaDataTest(0, null);
            this.tests.createViews(0, null);
            if (this.additionalTests) {
                this.tests.countResultsetsTest(0, null);
            }
            this.tests.orderByTest(0, null);
            this.tests.functionQueryTest(0, null);
            this.tests.groupByQueryTest(0, null);
            if (this.additionalTests) {
                this.tests.unionQueryTest(0, null);
            }
            if (this.additionalTests) {
                this.tests.subselectViewQueryTest(0, null);
            }
            this.tests.subselectQueryTest(0, null);
            if (this.additionalTests) {
                this.tests.joinQueryTest(0, null);
            }
            this.tests.hintQueryTest(0, null, queryList, HINTLIST, true, precision, queriesPerStatement);
            Object var17_17 = null;
            try {
                DatabaseConnection = HintQueryTest.getDatabase().connect(DBAConnectionProperties);
                runStatement = new TestStatement(null, DatabaseConnection);
                if (TestDriver.compareRelease((String)this.DATABASEVERSION, (String)"<", (String)"7.6")) {
                    Iterator it = this.tableList.iterator();
                    table = null;
                    while (it.hasNext()) {
                        table = (DatabaseObject)it.next();
                        try {
                            runStatement.executeUpdateIgnoreErrors(table.getSqlDropString());
                        }
                        catch (Exception e2) {
                            this.addMessage(this.nextStep("") + "The SQL-statement " + runStatement.getSqlString() + " failed", 'W', e2.toString());
                        }
                    }
                } else {
                    try {
                        runStatement.executeUpdateIgnoreErrors("drop schema " + SCHEMANAME);
                    }
                    catch (Exception e3) {
                        this.addMessage(this.nextStep("") + "The SQL-statement " + runStatement.getSqlString() + " failed", 'W', e3.toString());
                    }
                }
                runStatement.close();
                DatabaseConnection.commit();
                DatabaseConnection.close();
            }
            catch (Exception e4) {}
            break block34;
            {
                catch (Exception e) {
                    this.handleExceptions(e);
                    Object var17_18 = null;
                    try {
                        DatabaseConnection = HintQueryTest.getDatabase().connect(DBAConnectionProperties);
                        runStatement = new TestStatement(null, DatabaseConnection);
                        if (TestDriver.compareRelease((String)this.DATABASEVERSION, (String)"<", (String)"7.6")) {
                            Iterator it = this.tableList.iterator();
                            table = null;
                            while (it.hasNext()) {
                                table = (DatabaseObject)it.next();
                                try {
                                    runStatement.executeUpdateIgnoreErrors(table.getSqlDropString());
                                }
                                catch (Exception e2) {
                                    this.addMessage(this.nextStep("") + "The SQL-statement " + runStatement.getSqlString() + " failed", 'W', e2.toString());
                                }
                            }
                        } else {
                            try {
                                runStatement.executeUpdateIgnoreErrors("drop schema " + SCHEMANAME);
                            }
                            catch (Exception e3) {
                                this.addMessage(this.nextStep("") + "The SQL-statement " + runStatement.getSqlString() + " failed", 'W', e3.toString());
                            }
                        }
                        runStatement.close();
                        DatabaseConnection.commit();
                        DatabaseConnection.close();
                    }
                    catch (Exception e4) {}
                }
            }
            catch (Throwable throwable) {
                Object var17_19 = null;
                try {
                    DatabaseConnection = HintQueryTest.getDatabase().connect(DBAConnectionProperties);
                    runStatement = new TestStatement(null, DatabaseConnection);
                    if (TestDriver.compareRelease((String)this.DATABASEVERSION, (String)"<", (String)"7.6")) {
                        Iterator it = this.tableList.iterator();
                        table = null;
                        while (it.hasNext()) {
                            table = (DatabaseObject)it.next();
                            try {
                                runStatement.executeUpdateIgnoreErrors(table.getSqlDropString());
                            }
                            catch (Exception e2) {
                                this.addMessage(this.nextStep("") + "The SQL-statement " + runStatement.getSqlString() + " failed", 'W', e2.toString());
                            }
                        }
                    } else {
                        try {
                            runStatement.executeUpdateIgnoreErrors("drop schema " + SCHEMANAME);
                        }
                        catch (Exception e3) {
                            this.addMessage(this.nextStep("") + "The SQL-statement " + runStatement.getSqlString() + " failed", 'W', e3.toString());
                        }
                    }
                    runStatement.close();
                    DatabaseConnection.commit();
                    DatabaseConnection.close();
                }
                catch (Exception e4) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public static long getTimeout() {
        return runtime * 60 * 1000;
    }

    public String getLogFile() {
        if (this.tests != null) {
            return this.tests.getLogFile();
        }
        return null;
    }

    public static String getTestClassId() {
        return "HintQueryTest";
    }

    static {
        SCHEMANAME = "TESTSCHEMA";
        TABLECOUNT = 9;
        HINTLIST = new Vector();
        queryList = new Vector();
        runtime = 120;
    }
}

