/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.sqlmanager;

import com.sap.sapdb.oltptest.sqlmanager.DatabaseObject;
import com.sap.sapdb.oltptest.sqlmanager.QueryTests;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDatabaseSap;
import com.sap.sapdb.testframe.driver.TestDriver;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.testcase.TestStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class DynamicTablesMultiUser
extends TestCase {
    private static int USERCOUNT = 3;
    private static final String TESTUSERNAME = "TESTUSER";
    private static String SCHEMANAME = "TESTSCHEMA";
    private String testrunname;
    private static int TABLECOUNT = 100;
    private static int MAXCOLUMNCOUNT = 15;
    private static int MAXDATACOUNT = 500;
    private boolean USEPREPAREDSTATEMENTS;
    private static Properties DBAConnectionInternalProperties = new Properties();
    private static Properties DBAConnectionOracleProperties = new Properties();
    private static boolean UNICODE;
    private static String DATABASEVERSION;
    private static Vector TestUserList;
    private Vector tableList = new Vector();
    private QueryTests tests;
    private String stopOnError = "0";

    public static void prepare() throws TestCaseException {
        System.out.println("Prepare of " + DynamicTablesMultiUser.getTestClassId());
        DBAConnectionInternalProperties.put("user", DynamicTablesMultiUser.getUser());
        DBAConnectionInternalProperties.put("password", DynamicTablesMultiUser.getPassword());
        DBAConnectionInternalProperties.put("autocommit", "on");
        DBAConnectionInternalProperties.put("sqlmode", "internal");
        DBAConnectionOracleProperties.put("user", DynamicTablesMultiUser.getUser());
        DBAConnectionOracleProperties.put("password", DynamicTablesMultiUser.getPassword());
        DBAConnectionOracleProperties.put("autocommit", "on");
        DBAConnectionOracleProperties.put("sqlmode", "Oracle");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block26: {
            Connection DatabaseConnection = null;
            TestStatement runStatement = null;
            ThreadGroup testThreadGroup = null;
            SimpleDateFormat fmt = new SimpleDateFormat();
            fmt.applyPattern("yyyy-MM-dd_HH-mm-ss");
            this.testrunname = this.getTestId() + "_Log_" + fmt.format(new Date());
            System.out.println("Run of " + DynamicTablesMultiUser.getTestClassId());
            DATABASEVERSION = ((TestDatabaseSap)DynamicTablesMultiUser.getDatabase()).getKernelVersion() + "." + ((TestDatabaseSap)DynamicTablesMultiUser.getDatabase()).getKernelBuild().substring(0, 3);
            UNICODE = DynamicTablesMultiUser.getDatabase().executeDBMcmd("param_getvalue _UNICODE").trim().equalsIgnoreCase("yes");
            String WARNINGONLY = DynamicTablesMultiUser.getParameterString((String)"WARNINGONLY", (String)"");
            StringTokenizer st = new StringTokenizer(WARNINGONLY, ";,");
            Properties WARNINGONLYLIST = new Properties();
            while (st.hasMoreTokens()) {
                WARNINGONLYLIST.setProperty(st.nextToken(), "");
            }
            TABLECOUNT = Integer.parseInt(DynamicTablesMultiUser.getParameterString((String)"TABLECOUNT", (String)Integer.toString(TABLECOUNT)));
            USERCOUNT = Integer.parseInt(DynamicTablesMultiUser.getParameterString((String)"UserCount", (String)Integer.toString(USERCOUNT)));
            this.USEPREPAREDSTATEMENTS = Boolean.valueOf(DynamicTablesMultiUser.getParameterString((String)"USEPREPARESTATEMENTS", (String)"true"));
            this.stopOnError = DynamicTablesMultiUser.getParameterString((String)"StopOnError", (String)"0");
            if (!this.stopOnError.equals("0")) {
                DynamicTablesMultiUser.getDatabase().executeDBMcmd("util_connect");
                DynamicTablesMultiUser.getDatabase().executeDBMcmd("util_execute DIAGNOSE VTRACE STOP ON ERROR " + this.stopOnError);
                DynamicTablesMultiUser.getDatabase().executeDBMcmd("util_release");
            }
            System.out.println("Testrun: \t" + this.testrunname);
            System.out.println("Usercount: \t" + USERCOUNT + "(Parameter: USERCOUNT)");
            System.out.println("Unicode: \t" + UNICODE);
            System.out.println("Tablecount: \t" + TABLECOUNT + "(Parameter: TABLECOUNT)");
            System.out.println("MaxColumns: \t" + MAXCOLUMNCOUNT);
            System.out.println("MaxDatasets: \t" + MAXDATACOUNT);
            System.out.println("Stop on Error: \t" + DynamicTablesMultiUser.getParameterString((String)"StopOnError", (String)"0") + "  (Parameter: StopOnError)");
            System.out.println("Known Errors: \t" + WARNINGONLY + "  (Parameter: WARNINGONLY)");
            System.out.println("Use Prepared Statements: \t" + this.USEPREPAREDSTATEMENTS + "  (Parameter: USEPREPAREDSTATEMENTS)");
            this.addMessage("", 'I', "Testrun: \t" + this.testrunname + "\nUsercount: \t" + USERCOUNT + "(Parameter: USERCOUNT)" + "\nUnicode: \t" + UNICODE + "\nTablecount: \t" + TABLECOUNT + "(Parameter: TABLECOUNT)" + "\nMaxColumns: \t" + MAXCOLUMNCOUNT + "\nMaxDatasets: \t" + MAXDATACOUNT + "\nStop on Error: \t" + DynamicTablesMultiUser.getParameterString((String)"StopOnError", (String)"0") + "  (Parameter: StopOnError)" + "\nKnown Errors: \t" + WARNINGONLY + " (Parameter: WARNINGONLY)" + "\nUse Prepared Statements: \t" + this.USEPREPAREDSTATEMENTS + "  (Parameter: USEPREPAREDSTATEMENTS)");
            DatabaseConnection = DynamicTablesMultiUser.getDatabase().connect(DBAConnectionInternalProperties);
            runStatement = new TestStatement(null, DatabaseConnection);
            System.out.println("Data generation started");
            this.tableList = TestDriver.compareRelease((String)DATABASEVERSION, (String)"<", (String)"7.6") ? this.createTables("DBA", "TAB", "COL", TABLECOUNT, MAXCOLUMNCOUNT, MAXDATACOUNT, UNICODE) : this.createTables(SCHEMANAME, "TAB", "COL", TABLECOUNT, MAXCOLUMNCOUNT, MAXDATACOUNT, UNICODE);
            System.out.println("Data generation completed");
            runStatement.execute("update stat *");
            for (int i = 1; i <= USERCOUNT; ++i) {
                TestUserList.add(TESTUSERNAME + i);
            }
            String dropUser = "Drop user ";
            Iterator itu = TestUserList.iterator();
            while (itu.hasNext()) {
                runStatement.executeUpdateIgnoreErrors(dropUser + itu.next());
            }
            Iterator it = TestUserList.iterator();
            while (it.hasNext()) {
                String username = (String)it.next();
                runStatement.execute("create user " + username + " Password " + username + " DBA not exclusive");
            }
            runStatement.close();
            DatabaseConnection.close();
            this.tests = new QueryTests(this, this.testrunname, (TestDatabaseSap)DynamicTablesMultiUser.getDatabase(), this.tableList, DBAConnectionInternalProperties, USERCOUNT, true, WARNINGONLYLIST);
            this.tests.createViews(0, null);
            testThreadGroup = new ThreadGroup("testThreadGroup");
            Iterator it1 = TestUserList.iterator();
            Thread[] testThreadArray = new Thread[USERCOUNT];
            int i = 0;
            while (it1.hasNext()) {
                String testuser = (String)it1.next();
                testThreadArray[i] = new DynamicTablesMultiUSerThread(testThreadGroup, i, testuser, testuser, this);
                ++i;
            }
            for (int j = 0; j < testThreadArray.length; ++j) {
                testThreadArray[j].start();
            }
            ThreadGroup threadGroup = testThreadGroup;
            synchronized (threadGroup) {
                while (testThreadGroup.activeCount() > 0) {
                    testThreadGroup.wait(10L);
                }
            }
            Object var19_21 = null;
            try {
                DatabaseConnection = DynamicTablesMultiUser.getDatabase().connect(DBAConnectionInternalProperties);
                runStatement = new TestStatement(null, DatabaseConnection);
                String dropUser2 = "Drop user ";
                Iterator it12 = TestUserList.iterator();
                while (it12.hasNext()) {
                    try {
                        runStatement.executeUpdate(dropUser2 + it12.next());
                    }
                    catch (Exception e2) {
                        this.addMessage(this.nextStep("") + "The SQL-statement " + runStatement.getSqlString() + " failed", 'W', e2.toString());
                    }
                }
                DatabaseConnection.commit();
                DatabaseConnection.close();
            }
            catch (Exception e3) {}
            break block26;
            {
                catch (Exception e) {
                    testThreadGroup.stop();
                    this.handleExceptions(e);
                    Object var19_22 = null;
                    try {
                        DatabaseConnection = DynamicTablesMultiUser.getDatabase().connect(DBAConnectionInternalProperties);
                        runStatement = new TestStatement(null, DatabaseConnection);
                        String dropUser2 = "Drop user ";
                        Iterator it12 = TestUserList.iterator();
                        while (it12.hasNext()) {
                            try {
                                runStatement.executeUpdate(dropUser2 + it12.next());
                            }
                            catch (Exception e2) {
                                this.addMessage(this.nextStep("") + "The SQL-statement " + runStatement.getSqlString() + " failed", 'W', e2.toString());
                            }
                        }
                        DatabaseConnection.commit();
                        DatabaseConnection.close();
                    }
                    catch (Exception e3) {}
                }
            }
            catch (Throwable throwable) {
                Object var19_23 = null;
                try {
                    DatabaseConnection = DynamicTablesMultiUser.getDatabase().connect(DBAConnectionInternalProperties);
                    runStatement = new TestStatement(null, DatabaseConnection);
                    String dropUser2 = "Drop user ";
                    Iterator it12 = TestUserList.iterator();
                    while (it12.hasNext()) {
                        try {
                            runStatement.executeUpdate(dropUser2 + it12.next());
                        }
                        catch (Exception e2) {
                            this.addMessage(this.nextStep("") + "The SQL-statement " + runStatement.getSqlString() + " failed", 'W', e2.toString());
                        }
                    }
                    DatabaseConnection.commit();
                    DatabaseConnection.close();
                }
                catch (Exception e3) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    private Vector createTables(String schemaName, String tablePrefix, String columnPrefix, int tablecount, int maxColumnCount, int maxDataCount, boolean unicode) throws Exception {
        Vector<DatabaseObject> tableListIntern = new Vector<DatabaseObject>();
        Connection DBConnection = DynamicTablesMultiUser.getDatabase().connect(DBAConnectionInternalProperties);
        TestStatement statement = new TestStatement(null, DBConnection);
        if (TestDriver.compareRelease((String)DATABASEVERSION, (String)">=", (String)"7.6")) {
            statement.executeUpdateIgnoreErrors("drop schema " + schemaName);
            statement.executeUpdate("create schema " + schemaName);
        }
        for (int i = 0; i < tablecount; ++i) {
            tableListIntern.add(DatabaseObject.getRandomTable(schemaName, tablePrefix + i, columnPrefix, maxColumnCount, unicode));
        }
        Iterator it = tableListIntern.iterator();
        while (it.hasNext()) {
            try {
                DatabaseObject dbo = (DatabaseObject)it.next();
                statement.executeUpdateIgnoreErrors(dbo.getSqlDropString());
                statement.execute(dbo.getSqlCreateString());
                statement.execute("grant all on " + dbo.getObjectIdentifier() + " to public");
            }
            catch (SQLException e) {
                System.out.println(statement.getSqlString());
                e.printStackTrace();
            }
        }
        Iterator it2 = tableListIntern.iterator();
        SimpleDateFormat TEST_TIME_FORMAT = new SimpleDateFormat("mm:ss.SSS");
        while (it2.hasNext()) {
            DatabaseObject dbo = (DatabaseObject)it2.next();
            long time = System.currentTimeMillis();
            if (this.USEPREPAREDSTATEMENTS) {
                try {
                    dbo.insertRandomData(DBConnection, maxDataCount);
                    System.out.println("Table Creation " + dbo.getObjectIdentifier() + " Data Creation/Insertion: " + TEST_TIME_FORMAT.format(new Date(System.currentTimeMillis() - time)));
                }
                catch (Exception e) {
                    System.out.println(statement.getSqlString());
                    e.printStackTrace();
                }
                continue;
            }
            Vector insertSqlStringList = dbo.getSqlInsertRandomDataString(maxDataCount);
            String generationTime = TEST_TIME_FORMAT.format(new Date(System.currentTimeMillis() - time));
            Iterator itInsertSqlStringList = insertSqlStringList.iterator();
            time = System.currentTimeMillis();
            while (itInsertSqlStringList.hasNext()) {
                String insertSqlString = (String)itInsertSqlStringList.next();
                try {
                    statement.execute(insertSqlString);
                }
                catch (SQLException e) {
                    System.out.println(statement.getSqlString());
                    e.printStackTrace();
                }
            }
            String insertionTime = TEST_TIME_FORMAT.format(new Date(System.currentTimeMillis() - time));
            System.out.println("Table Creation " + dbo.getObjectIdentifier() + " Data Creation: " + generationTime + " Data Insertion: " + insertionTime);
        }
        statement.close();
        DBConnection.close();
        return tableListIntern;
    }

    public String getLogFile() {
        return this.tests.getLogFile();
    }

    public static String getTestClassId() {
        return "DynamicTablesMultiUser";
    }

    static {
        DATABASEVERSION = null;
        TestUserList = new Vector();
    }

    public class DynamicTablesMultiUSerThread
    extends Thread {
        private Properties ConnectionProperties;
        private DynamicTablesMultiUser main;
        private int usernumber;

        public DynamicTablesMultiUSerThread(ThreadGroup group, int usernumber, String username, String password, DynamicTablesMultiUser main) {
            super(group, new String(username));
            this.ConnectionProperties = new Properties();
            this.main = null;
            this.main = main;
            this.ConnectionProperties.put("user", new String(username));
            this.ConnectionProperties.put("password", new String(password));
            this.ConnectionProperties.put("autocommit", "on");
            this.ConnectionProperties.put("sqlmode", "internal");
            this.usernumber = usernumber;
        }

        public void run() {
            try {
                this.main.tests.verifyMetaDataTest(this.usernumber, this.ConnectionProperties);
                this.main.tests.countResultsetsTest(this.usernumber, this.ConnectionProperties);
                this.main.tests.orderByTest(this.usernumber, this.ConnectionProperties);
                this.main.tests.functionQueryTest(this.usernumber, this.ConnectionProperties);
                this.main.tests.groupByQueryTest(this.usernumber, this.ConnectionProperties);
                this.main.tests.unionQueryTest(this.usernumber, this.ConnectionProperties);
                this.main.tests.subselectViewQueryTest(this.usernumber, this.ConnectionProperties);
                this.main.tests.subselectQueryTest(this.usernumber, this.ConnectionProperties);
                this.main.tests.joinQueryTest(this.usernumber, this.ConnectionProperties);
            }
            catch (Exception e) {
                this.main.handleExceptions(e);
            }
        }
    }
}

