/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.sqlmanager;

import com.sap.sapdb.oltptest.sqlmanager.DatabaseObject;
import com.sap.sapdb.oltptest.sqlmanager.QueryTests;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDatabaseSap;
import com.sap.sapdb.testframe.driver.TestDriver;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.testcase.TestStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class DynamicTables
extends TestCase {
    private static Properties DBAConnectionInternalProperties;
    private static Properties DBAConnectionOracleProperties;
    private static String SCHEMANAME;
    private String testrunname;
    private static final int USERCOUNT = 1;
    private static int TABLECOUNT;
    private static int MAXCOLUMNCOUNT;
    private static int MAXDATACOUNT;
    private Vector tableList = new Vector();
    private boolean UNICODE;
    private String DATABASEVERSION;
    private String stopOnError = "0";
    private boolean USEPREPAREDSTATEMENTS;
    private QueryTests tests;

    public static void prepare() throws TestCaseException {
        System.out.println("Prepare of " + DynamicTables.getTestClassId());
        DBAConnectionInternalProperties = new Properties();
        DBAConnectionOracleProperties = new Properties();
        DBAConnectionInternalProperties.put("user", DynamicTables.getUser());
        DBAConnectionInternalProperties.put("password", DynamicTables.getPassword());
        DBAConnectionInternalProperties.put("autocommit", "on");
        DBAConnectionInternalProperties.put("sqlmode", "internal");
        DBAConnectionOracleProperties.put("user", DynamicTables.getUser());
        DBAConnectionOracleProperties.put("password", DynamicTables.getPassword());
        DBAConnectionOracleProperties.put("autocommit", "on");
        DBAConnectionOracleProperties.put("sqlmode", "Oracle");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block38: {
            TestStatement runStatement;
            Connection DatabaseConnection;
            DatabaseObject table;
            block37: {
                table = null;
                DatabaseConnection = null;
                runStatement = null;
                SimpleDateFormat fmt = new SimpleDateFormat();
                fmt.applyPattern("yyyy-MM-dd_HH-mm-ss");
                this.testrunname = this.getTestId() + "_Log_" + fmt.format(new Date());
                System.out.println("Run of " + DynamicTables.getTestClassId());
                DatabaseConnection = DynamicTables.getDatabase().connect(DBAConnectionInternalProperties);
                this.UNICODE = DynamicTables.getDatabase().executeDBMcmd("param_getvalue _UNICODE").trim().equalsIgnoreCase("yes");
                this.DATABASEVERSION = ((TestDatabaseSap)DynamicTables.getDatabase()).getKernelVersion() + "." + ((TestDatabaseSap)DynamicTables.getDatabase()).getKernelBuild().substring(0, 3);
                String WARNINGONLY = DynamicTables.getParameterString((String)"WARNINGONLY", (String)"");
                StringTokenizer st = new StringTokenizer(WARNINGONLY, ";,");
                Properties WARNINGONLYLIST = new Properties();
                while (st.hasMoreTokens()) {
                    WARNINGONLYLIST.setProperty(st.nextToken(), "");
                }
                TABLECOUNT = Integer.parseInt(DynamicTables.getParameterString((String)"TABLECOUNT", (String)Integer.toString(TABLECOUNT)));
                this.USEPREPAREDSTATEMENTS = Boolean.valueOf(DynamicTables.getParameterString((String)"USEPREPARESTATEMENTS", (String)"true"));
                this.stopOnError = DynamicTables.getParameterString((String)"StopOnError", (String)"0");
                if (!this.stopOnError.equals("0")) {
                    DynamicTables.getDatabase().executeDBMcmd("util_connect");
                    DynamicTables.getDatabase().executeDBMcmd("util_execute DIAGNOSE VTRACE STOP ON ERROR " + this.stopOnError);
                    DynamicTables.getDatabase().executeDBMcmd("util_release");
                }
                System.out.println("Testrun: \t" + this.testrunname);
                System.out.println("Usercount: \t1");
                System.out.println("Unicode: \t" + this.UNICODE);
                System.out.println("Tablecount: \t" + TABLECOUNT + "  (Parameter: TABLECOUNT)");
                System.out.println("MaxColumns: \t" + MAXCOLUMNCOUNT);
                System.out.println("MaxDatasets: \t" + MAXDATACOUNT);
                System.out.println("Stop on Error: \t" + DynamicTables.getParameterString((String)"StopOnError", (String)"0") + "  (Parameter: StopOnError)");
                System.out.println("Known Errors: \t" + WARNINGONLY + "  (Parameter: WARNINGONLY)");
                System.out.println("Use Prepared Statements: \t" + this.USEPREPAREDSTATEMENTS + "  (Parameter: USEPREPAREDSTATEMENTS)");
                this.addMessage("", 'I', "Testrun: \t" + this.testrunname + "\nUsercount: \t" + 1 + "\nUnicode: \t" + this.UNICODE + "\nTablecount: \t" + TABLECOUNT + "(Parameter: TABLECOUNT)" + "\nMaxColumns: \t" + MAXCOLUMNCOUNT + "\nMaxDatasets: \t" + MAXDATACOUNT + "\nStop on Error: \t" + DynamicTables.getParameterString((String)"StopOnError", (String)"0") + "  (Parameter: StopOnError)" + "\nKnown Errors: \t" + WARNINGONLY + " (Parameter: WARNINGONLY)" + "\nUse Prepared Statements: \t" + this.USEPREPAREDSTATEMENTS + "  (Parameter: USEPREPAREDSTATEMENTS)");
                System.out.println("Data generation started");
                this.tableList = TestDriver.compareRelease((String)this.DATABASEVERSION, (String)"<", (String)"7.6") ? this.createTables("DBA", "TAB", "COL", TABLECOUNT, MAXCOLUMNCOUNT, MAXDATACOUNT, this.UNICODE) : this.createTables(SCHEMANAME, "TAB", "COL", TABLECOUNT, MAXCOLUMNCOUNT, MAXDATACOUNT, this.UNICODE);
                System.out.println("Data generation finished");
                runStatement = new TestStatement((TestCase)this, DatabaseConnection);
                runStatement.execute("update stat *");
                runStatement.close();
                DatabaseConnection.close();
                this.tests = new QueryTests(this, this.testrunname, (TestDatabaseSap)DynamicTables.getDatabase(), this.tableList, DBAConnectionInternalProperties, 1, true, WARNINGONLYLIST);
                if (!this.tests.getGlobalErrorOccured()) {
                    this.tests.verifyMetaDataTest(0, null);
                }
                if (!this.tests.getGlobalErrorOccured()) {
                    this.tests.createViews(0, null);
                }
                if (!this.tests.getGlobalErrorOccured()) {
                    this.tests.countResultsetsTest(0, null);
                }
                if (!this.tests.getGlobalErrorOccured()) {
                    this.tests.orderByTest(0, null);
                }
                if (!this.tests.getGlobalErrorOccured()) {
                    this.tests.functionQueryTest(0, null);
                }
                if (!this.tests.getGlobalErrorOccured()) {
                    this.tests.groupByQueryTest(0, null);
                }
                if (!this.tests.getGlobalErrorOccured()) {
                    this.tests.unionQueryTest(0, null);
                }
                if (!this.tests.getGlobalErrorOccured()) {
                    this.tests.subselectViewQueryTest(0, null);
                }
                if (!this.tests.getGlobalErrorOccured()) {
                    this.tests.subselectQueryTest(0, null);
                }
                if (!this.tests.getGlobalErrorOccured()) {
                    this.tests.joinQueryTest(0, null);
                }
                if (!this.tests.getGlobalErrorOccured()) break block37;
                this.addMessage(DynamicTables.getTestClassId(), 'E', "A global error occured. Not all tests were executed.");
            }
            Object var9_9 = null;
            try {
                DatabaseConnection = DynamicTables.getDatabase().connect(DBAConnectionInternalProperties);
                runStatement = new TestStatement(null, DatabaseConnection);
                if (TestDriver.compareRelease((String)this.DATABASEVERSION, (String)"<", (String)"7.6")) {
                    Iterator it = this.tableList.iterator();
                    table = null;
                    while (it.hasNext()) {
                        table = (DatabaseObject)it.next();
                        try {
                            runStatement.executeUpdateIgnoreErrors(table.getSqlDropString());
                        }
                        catch (Exception e2) {
                            this.addMessage(this.nextStep("") + "The SQL-statement " + runStatement.getSqlString() + " failed", 'W', e2.toString());
                        }
                    }
                } else {
                    try {
                        runStatement.executeUpdateIgnoreErrors("drop schema " + SCHEMANAME);
                    }
                    catch (Exception e3) {
                        this.addMessage(this.nextStep("") + "The SQL-statement " + runStatement.getSqlString() + " failed", 'W', e3.toString());
                    }
                }
                runStatement.close();
                DatabaseConnection.commit();
                DatabaseConnection.close();
            }
            catch (Exception e4) {}
            break block38;
            {
                catch (Exception e) {
                    this.handleExceptions(e);
                    Object var9_10 = null;
                    try {
                        DatabaseConnection = DynamicTables.getDatabase().connect(DBAConnectionInternalProperties);
                        runStatement = new TestStatement(null, DatabaseConnection);
                        if (TestDriver.compareRelease((String)this.DATABASEVERSION, (String)"<", (String)"7.6")) {
                            Iterator it = this.tableList.iterator();
                            table = null;
                            while (it.hasNext()) {
                                table = (DatabaseObject)it.next();
                                try {
                                    runStatement.executeUpdateIgnoreErrors(table.getSqlDropString());
                                }
                                catch (Exception e2) {
                                    this.addMessage(this.nextStep("") + "The SQL-statement " + runStatement.getSqlString() + " failed", 'W', e2.toString());
                                }
                            }
                        } else {
                            try {
                                runStatement.executeUpdateIgnoreErrors("drop schema " + SCHEMANAME);
                            }
                            catch (Exception e3) {
                                this.addMessage(this.nextStep("") + "The SQL-statement " + runStatement.getSqlString() + " failed", 'W', e3.toString());
                            }
                        }
                        runStatement.close();
                        DatabaseConnection.commit();
                        DatabaseConnection.close();
                    }
                    catch (Exception e4) {}
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                try {
                    DatabaseConnection = DynamicTables.getDatabase().connect(DBAConnectionInternalProperties);
                    runStatement = new TestStatement(null, DatabaseConnection);
                    if (TestDriver.compareRelease((String)this.DATABASEVERSION, (String)"<", (String)"7.6")) {
                        Iterator it = this.tableList.iterator();
                        table = null;
                        while (it.hasNext()) {
                            table = (DatabaseObject)it.next();
                            try {
                                runStatement.executeUpdateIgnoreErrors(table.getSqlDropString());
                            }
                            catch (Exception e2) {
                                this.addMessage(this.nextStep("") + "The SQL-statement " + runStatement.getSqlString() + " failed", 'W', e2.toString());
                            }
                        }
                    } else {
                        try {
                            runStatement.executeUpdateIgnoreErrors("drop schema " + SCHEMANAME);
                        }
                        catch (Exception e3) {
                            this.addMessage(this.nextStep("") + "The SQL-statement " + runStatement.getSqlString() + " failed", 'W', e3.toString());
                        }
                    }
                    runStatement.close();
                    DatabaseConnection.commit();
                    DatabaseConnection.close();
                }
                catch (Exception e4) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public String getLogFile() {
        return this.tests.getLogFile();
    }

    private Vector createTables(String schemaName, String tablePrefix, String columnPrefix, int tablecount, int maxColumnCount, int maxDataCount, boolean unicode) throws Exception {
        Vector<DatabaseObject> tableList = new Vector<DatabaseObject>();
        Connection DBConnection = DynamicTables.getDatabase().connect(DBAConnectionInternalProperties);
        TestStatement statement = new TestStatement(null, DBConnection);
        if (TestDriver.compareRelease((String)this.DATABASEVERSION, (String)">=", (String)"7.6")) {
            statement.executeUpdateIgnoreErrors("drop schema " + schemaName);
            statement.executeUpdate("create schema " + schemaName);
        }
        for (int i = 0; i < tablecount; ++i) {
            tableList.add(DatabaseObject.getRandomTable(schemaName, tablePrefix + i, columnPrefix, maxColumnCount, unicode));
        }
        Iterator it = tableList.iterator();
        while (it.hasNext()) {
            try {
                DatabaseObject dbo = (DatabaseObject)it.next();
                statement.executeUpdateIgnoreErrors(dbo.getSqlDropString());
                statement.execute(dbo.getSqlCreateString());
            }
            catch (SQLException e) {
                System.out.println(statement.getSqlString());
                e.printStackTrace();
            }
        }
        Iterator it2 = tableList.iterator();
        SimpleDateFormat TEST_TIME_FORMAT = new SimpleDateFormat("mm:ss.SSS");
        while (it2.hasNext()) {
            DatabaseObject dbo = (DatabaseObject)it2.next();
            long time = System.currentTimeMillis();
            if (this.USEPREPAREDSTATEMENTS) {
                try {
                    dbo.insertRandomData(DBConnection, maxDataCount);
                    System.out.println("Table Creation " + dbo.getObjectIdentifier() + " Data Creation/Insertion: " + TEST_TIME_FORMAT.format(new Date(System.currentTimeMillis() - time)));
                }
                catch (Exception e) {
                    System.out.println(statement.getSqlString());
                    e.printStackTrace();
                }
                continue;
            }
            Vector insertSqlStringList = dbo.getSqlInsertRandomDataString(maxDataCount);
            String generationTime = TEST_TIME_FORMAT.format(new Date(System.currentTimeMillis() - time));
            Iterator itInsertSqlStringList = insertSqlStringList.iterator();
            time = System.currentTimeMillis();
            while (itInsertSqlStringList.hasNext()) {
                String insertSqlString = (String)itInsertSqlStringList.next();
                try {
                    statement.execute(insertSqlString);
                }
                catch (SQLException e) {
                    System.out.println(statement.getSqlString());
                    e.printStackTrace();
                }
            }
            String insertionTime = TEST_TIME_FORMAT.format(new Date(System.currentTimeMillis() - time));
            System.out.println("Table Creation " + dbo.getObjectIdentifier() + " Data Creation: " + generationTime + " Data Insertion: " + insertionTime);
        }
        statement.close();
        DBConnection.close();
        return tableList;
    }

    public static String getTestClassId() {
        return "DynamicTables";
    }

    static {
        SCHEMANAME = "TESTSCHEMA";
        TABLECOUNT = 100;
        MAXCOLUMNCOUNT = 15;
        MAXDATACOUNT = 500;
    }
}

