/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.sqlmanager;

import com.sap.sapdb.testframe.testcase.TestPreparedStatement;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Properties;
import java.util.Random;
import java.util.Vector;

class DatabaseObject {
    private static Vector columnDatatypeList = new MyVector();
    private static Properties DatatypeSpecificationSqlStringList = new MyProperties();
    private static boolean valueListInitialized = false;
    private static String[] charunicodeValueList;
    private static String[] charasciiValueList;
    private static String[] charbyteValueList;
    private static String[] floatValueList;
    private static String[] booleanValueList;
    private static String[] integerValueList;
    private static String[] smallintValueList;
    private static Date[] dateValueList;
    private static Time[] timeValueList;
    private static Timestamp[] timestampValueList;
    private static String[] fixedValueList;
    private static String[] columnEncodingsUnicode;
    private static String[] columnEncodingsAscii;
    private static int VALUE_LIST_SIZE;
    private static int MAX_FLOAT_SIZE;
    private static int MAX_CHAR_SIZE;
    private static Random RANDOM;
    private String ObjectName;
    private String ObjectOwner;
    private String ObjectType;
    private static int ObjectViewNameNumber;
    private boolean ObjectViewNameTruncated = false;
    private String ObjectViewName;
    private Vector columnList;

    private static String stringReplace(String inputString, String searchString, String replaceString) {
        int i = inputString.indexOf(searchString);
        while (i > -1) {
            String s1 = inputString.substring(0, i);
            String s2 = inputString.substring(i + searchString.length());
            inputString = s1 + replaceString + s2;
            i = inputString.indexOf(searchString);
        }
        return inputString;
    }

    public int getNextViewNumber() {
        return ++ObjectViewNameNumber;
    }

    public boolean getViewNameTruncated() {
        return this.ObjectViewNameTruncated;
    }

    public void setViewNameTruncated() {
        this.ObjectViewNameTruncated = true;
    }

    public String getObjectName() {
        return "\"" + this.ObjectName + "\"";
    }

    public String getObjectOwner() {
        return this.ObjectOwner;
    }

    public String getObjectType() {
        return this.ObjectType;
    }

    public int getColumnCount() {
        return this.columnList.size();
    }

    DatabaseObject(String ObjectOwner, String ObjectName, String ObjectType) {
        this.ObjectName = ObjectName;
        this.ObjectType = ObjectType;
        this.ObjectOwner = ObjectOwner;
        this.columnList = new Vector();
        this.ObjectViewName = "v_" + ObjectOwner + "_" + ObjectName;
        if (this.ObjectViewName.length() > 32) {
            this.setViewNameTruncated();
            this.ObjectViewName = this.ObjectViewName.substring(0, 30) + this.getNextViewNumber();
        }
    }

    public String getObjectIdentifier() {
        return this.ObjectOwner + "." + this.ObjectName;
    }

    public void setColumnList(ResultSetMetaData mdata) throws Exception {
        for (int i = 1; i <= mdata.getColumnCount(); ++i) {
            this.columnList.add(new ColumnSpecification(mdata.getColumnName(i), mdata.getColumnTypeName(i), mdata.getColumnDisplaySize(i), mdata.getPrecision(i), null));
        }
    }

    private ColumnSpecification getColumn(int Columnnumber) {
        return (ColumnSpecification)this.columnList.get(Columnnumber - 1);
    }

    public void addColumn(String columnName, String columnType, int columnSize, int Precision, String Encoding) {
        this.columnList.add(new ColumnSpecification(columnName, columnType, columnSize, Precision, Encoding));
    }

    public String getColumnName(int columnIndex) {
        return "\"" + ((ColumnSpecification)this.columnList.get(columnIndex - 1)).getColumnName() + "\"";
    }

    public String getColumnIdentifier(int columnIndex) {
        return this.getObjectName() + "." + this.getColumnName(columnIndex);
    }

    public String getColumnType(int columnIndex) {
        String enc = ((ColumnSpecification)this.columnList.get(columnIndex - 1)).getColumnEncoding();
        if (enc == null) {
            return ((ColumnSpecification)this.columnList.get(columnIndex - 1)).getColumnType();
        }
        if (enc == "UNICODE" || enc == "BYTE") {
            return ((ColumnSpecification)this.columnList.get(columnIndex - 1)).getColumnType() + " " + enc;
        }
        return ((ColumnSpecification)this.columnList.get(columnIndex - 1)).getColumnType();
    }

    public String getColumnTypeWithoutEncoding(int columnIndex) {
        return ((ColumnSpecification)this.columnList.get(columnIndex - 1)).getColumnType();
    }

    public String getColumnEncoding(int columnIndex) {
        return ((ColumnSpecification)this.columnList.get(columnIndex - 1)).getColumnEncoding();
    }

    public int getColumnLength(int columnIndex) {
        return ((ColumnSpecification)this.columnList.get(columnIndex - 1)).getColumnLength();
    }

    public int getColumnPrecision(int columnIndex) {
        return ((ColumnSpecification)this.columnList.get(columnIndex - 1)).getColumnPrecision();
    }

    public long getTableLength() {
        long completeLength = 0L;
        for (int t = 1; t <= this.getColumnCount(); ++t) {
            completeLength += (long)this.getColumnLength(t);
        }
        return completeLength;
    }

    public String getObjectViewName() {
        return this.ObjectViewName;
    }

    public int getFirstColumn(String columnType) {
        for (int t = 1; t <= this.getColumnCount(); ++t) {
            if (!this.getColumnType(t).equalsIgnoreCase(columnType)) continue;
            return t;
        }
        return -1;
    }

    public boolean hasColumnType(String Columntype) {
        for (int t = 1; t <= this.getColumnCount(); ++t) {
            if (!this.getColumnType(t).equalsIgnoreCase(Columntype) || !this.isUsableColumn(t)) continue;
            return true;
        }
        return false;
    }

    public boolean hasOnlyLong() {
        for (int t = 1; t <= this.getColumnCount(); ++t) {
            if (this.getColumnType(t).indexOf("LONG") != -1) continue;
            return false;
        }
        return true;
    }

    public boolean hasUsableColumn() {
        for (int t = 1; t <= this.getColumnCount(); ++t) {
            if (!this.isUsableColumn(t)) continue;
            return true;
        }
        return false;
    }

    public boolean hasOnlyUsableColumns() {
        if (this.getColumnCount() < 1) {
            return false;
        }
        for (int t = 1; t <= this.getColumnCount(); ++t) {
            if (this.isUsableColumn(t)) continue;
            return false;
        }
        return true;
    }

    public int getRandomColumn() {
        int i = new Random().nextInt(this.getColumnCount()) + 1;
        if (this.hasUsableColumn()) {
            while (!this.isUsableColumn(i)) {
                if (i == this.getColumnCount()) {
                    i = 1;
                    continue;
                }
                ++i;
            }
            return i;
        }
        return -1;
    }

    public Vector getAllUsableColumns() {
        if (this.hasUsableColumn()) {
            Vector<Integer> v = new Vector<Integer>();
            for (int i = 1; i <= this.getColumnCount(); ++i) {
                if (!this.isUsableColumn(i)) continue;
                v.add(new Integer(i));
            }
            return v;
        }
        return null;
    }

    public int getRandomColumn(String columnType) {
        int i = new Random().nextInt(this.getColumnCount()) + 1;
        if (this.hasUsableColumn() && this.hasColumnType(columnType)) {
            while (!this.getColumnType(i).equalsIgnoreCase(columnType) || !this.isUsableColumn(i)) {
                if (i == this.getColumnCount()) {
                    i = 1;
                    continue;
                }
                ++i;
            }
            return i;
        }
        return -1;
    }

    public boolean isUsableColumn(int columnNumber) {
        return this.getColumnType(columnNumber).indexOf("LONG") < 0 && this.getColumnLength(columnNumber) < 510;
    }

    public static DatabaseObject getRandomTable(String schemaName, String tableName, String columnPrefix, int maxColumnCount, boolean unicode) throws Exception {
        DatabaseObject table = new DatabaseObject(schemaName, tableName, "TABLE");
        String[] columnEncodings = unicode ? columnEncodingsUnicode : columnEncodingsAscii;
        int currentColumnCount = RANDOM.nextInt(maxColumnCount) + 1;
        for (int j = 1; j <= currentColumnCount; ++j) {
            int columnTypeNumber = RANDOM.nextInt(columnDatatypeList.size());
            String columnTypeName = (String)columnDatatypeList.get(columnTypeNumber);
            if (columnTypeName.indexOf("CHAR") > -1) {
                table.addColumn(columnPrefix + j, columnTypeName, MAX_CHAR_SIZE, 0, columnEncodings[RANDOM.nextInt(columnEncodings.length)]);
                continue;
            }
            if (columnTypeName.equalsIgnoreCase("FIXED")) {
                table.addColumn(columnPrefix + j, columnTypeName, MAX_FLOAT_SIZE, MAX_FLOAT_SIZE / 2, null);
                continue;
            }
            if (columnTypeName.equalsIgnoreCase("FLOAT")) {
                int floatsize = MAX_FLOAT_SIZE;
                table.addColumn(columnPrefix + j, columnTypeName, floatsize, 0, null);
                continue;
            }
            table.addColumn(columnPrefix + j, columnTypeName, 0, 0, null);
        }
        return table;
    }

    public String getSqlDropString() {
        return "drop table " + this.getObjectIdentifier();
    }

    private static void fillRandomValueLists() {
        Calendar myCal;
        int i;
        int i2;
        int valueCount = VALUE_LIST_SIZE;
        booleanValueList = new String[VALUE_LIST_SIZE];
        for (i2 = 0; i2 < valueCount; ++i2) {
            DatabaseObject.booleanValueList[i2] = Boolean.toString(RANDOM.nextBoolean());
        }
        floatValueList = new String[VALUE_LIST_SIZE];
        for (i2 = 0; i2 < valueCount; ++i2) {
            DatabaseObject.floatValueList[i2] = Float.toString(RANDOM.nextFloat());
        }
        smallintValueList = new String[VALUE_LIST_SIZE];
        for (i2 = 0; i2 < valueCount; ++i2) {
            DatabaseObject.smallintValueList[i2] = Integer.toString(RANDOM.nextInt() % Short.MAX_VALUE);
        }
        integerValueList = new String[VALUE_LIST_SIZE];
        for (i2 = 0; i2 < valueCount; ++i2) {
            DatabaseObject.integerValueList[i2] = Integer.toString(RANDOM.nextInt());
        }
        dateValueList = new Date[VALUE_LIST_SIZE];
        for (i2 = 0; i2 < valueCount; ++i2) {
            DatabaseObject.dateValueList[i2] = new Date(RANDOM.nextLong() % 3338656939707L);
        }
        timeValueList = new Time[VALUE_LIST_SIZE];
        long myLong = 0L;
        for (i = 0; i < valueCount; ++i) {
            myLong = RANDOM.nextLong() % 3338656939707L;
            DatabaseObject.timeValueList[i] = new Time(myLong);
            myCal = Calendar.getInstance();
            myCal.setTimeInMillis(timeValueList[i].getTime());
            if (myCal.get(10) != 0 || myCal.get(12) >= 2) continue;
            System.out.println(" bad time: " + timeValueList[i] + "; long -> " + myLong);
            --i;
        }
        timestampValueList = new Timestamp[VALUE_LIST_SIZE];
        for (i = 0; i < valueCount; ++i) {
            myLong = RANDOM.nextLong() % 3338656879707L + 60000L;
            DatabaseObject.timestampValueList[i] = new Timestamp(myLong);
            myCal = Calendar.getInstance();
            myCal.setTimeInMillis(timestampValueList[i].getTime());
            if (myCal.get(10) != 0 || myCal.get(12) >= 2) continue;
            System.out.println(" bad timestamp: " + timeValueList[i] + "; long -> " + myLong);
            --i;
        }
        charunicodeValueList = new String[VALUE_LIST_SIZE];
        for (int i3 = 0; i3 < valueCount; ++i3) {
            int charcount = RANDOM.nextInt(MAX_CHAR_SIZE);
            char[] ca = new char[charcount];
            for (int j = 0; j < charcount; ++j) {
                int x = RANDOM.nextInt(65537);
                ca[j] = (char)x;
            }
            DatabaseObject.charunicodeValueList[i3] = new String(ca);
        }
        charasciiValueList = new String[VALUE_LIST_SIZE];
        byte[] ba = new byte[MAX_CHAR_SIZE];
        boolean conversionSucessfull = false;
        for (int i4 = 0; i4 < valueCount; ++i4) {
            conversionSucessfull = false;
            while (!conversionSucessfull) {
                try {
                    RANDOM.nextBytes(ba);
                    DatabaseObject.charasciiValueList[i4] = new String(ba, "ISO-8859-1").replaceAll("'", "_").replaceAll("\"", "_");
                    conversionSucessfull = true;
                }
                catch (UnsupportedEncodingException e) {
                    conversionSucessfull = false;
                }
            }
        }
        charbyteValueList = new String[VALUE_LIST_SIZE];
        for (int i5 = 0; i5 < valueCount; ++i5) {
            long byteValue = RANDOM.nextLong();
            String byteValueString = Long.toHexString(byteValue);
            if (byteValueString.length() % 2 == 1) {
                byteValueString = byteValueString.concat("0");
            }
            DatabaseObject.charbyteValueList[i5] = "x'" + byteValueString + "'";
        }
        fixedValueList = new String[VALUE_LIST_SIZE];
        for (int i6 = 0; i6 < valueCount; ++i6) {
            int decimalPart = RANDOM.nextInt();
            int fractionalPart = Math.abs(RANDOM.nextInt());
            DatabaseObject.fixedValueList[i6] = new String(decimalPart + "." + fractionalPart);
        }
        valueListInitialized = true;
    }

    private String getRandomData(ColumnSpecification column) {
        String columnType = column.getColumnType().toLowerCase();
        String columnEncoding = column.getColumnEncoding();
        int random = RANDOM.nextInt(VALUE_LIST_SIZE);
        String randomData = columnType.equals("varchar") || columnType.equals("char") ? (columnEncoding.equalsIgnoreCase("ascii") ? "'" + charasciiValueList[random] + "'" : (columnEncoding.equalsIgnoreCase("unicode") ? "'" + charunicodeValueList[random] + "'" : charbyteValueList[random])) : (columnType.equals("float") ? floatValueList[random] : (columnType.equals("boolean") ? booleanValueList[random] : (columnType.equals("smallint") ? smallintValueList[random] : (columnType.equals("integer") ? integerValueList[random] : (columnType.equals("time") ? "'" + timeValueList[random] + "'" : (columnType.equals("date") ? "'" + dateValueList[random] + "'" : (columnType.equals("timestamp") ? "'" + timestampValueList[random] + "'" : (columnType.equals("fixed") ? fixedValueList[random] : "Error"))))))));
        return randomData;
    }

    public Vector getSqlInsertRandomDataString(int rowcount) {
        if (!valueListInitialized) {
            DatabaseObject.fillRandomValueLists();
        }
        Vector<String> insertStringList = new Vector<String>();
        for (int i = 0; i < rowcount; ++i) {
            String insertString = "insert into " + this.getObjectIdentifier() + " values (";
            for (int j = 0; j < this.getColumnCount(); ++j) {
                insertString = insertString + this.getRandomData((ColumnSpecification)this.columnList.get(j));
                if (j >= this.getColumnCount() - 1) continue;
                insertString = insertString + ",";
            }
            insertString = insertString + ")";
            insertStringList.add(insertString);
        }
        return insertStringList;
    }

    public String getSqlCreateString() {
        String createTableStatement1 = "Create table ";
        String createTableStatement2 = "(";
        String createTableStatement4 = ",";
        String createTableStatement5 = ")";
        int columnCount = this.getColumnCount();
        String createTableStatement = createTableStatement1 + this.getObjectIdentifier() + createTableStatement2;
        for (int j = 1; j <= columnCount; ++j) {
            String columnType = this.getColumnTypeWithoutEncoding(j);
            String columnName = this.getColumnName(j);
            String datatypeSpecificationSqlString = DatatypeSpecificationSqlStringList.getProperty(columnType);
            createTableStatement = columnType.indexOf("CHAR") > -1 ? createTableStatement + columnName + " " + DatabaseObject.stringReplace(datatypeSpecificationSqlString, "#C", Integer.toString(this.getColumnLength(j))) + " " + this.getColumnEncoding(j) : (columnType.equalsIgnoreCase("FIXED") ? createTableStatement + columnName + " " + DatabaseObject.stringReplace(DatabaseObject.stringReplace(datatypeSpecificationSqlString, "#F", Integer.toString(this.getColumnLength(j))), "#P", Integer.toString(this.getColumnPrecision(j))) : (columnType.equalsIgnoreCase("FLOAT") ? createTableStatement + columnName + " " + DatabaseObject.stringReplace(datatypeSpecificationSqlString, "#F", Integer.toString(this.getColumnLength(j))) : createTableStatement + columnName + " " + datatypeSpecificationSqlString));
            if (j >= columnCount) continue;
            createTableStatement = createTableStatement + createTableStatement4;
        }
        createTableStatement = createTableStatement + createTableStatement5;
        return createTableStatement;
    }

    public void insertRandomData(Connection dbcon, int rowcount) throws Exception {
        if (!valueListInitialized) {
            DatabaseObject.fillRandomValueLists();
        }
        String preparedStatement = "insert into " + this.getObjectIdentifier() + " values (";
        for (int i = 1; i < this.getColumnCount(); ++i) {
            preparedStatement = preparedStatement + "?,";
        }
        preparedStatement = preparedStatement + "?)";
        TestPreparedStatement prepsta = new TestPreparedStatement(null, dbcon, preparedStatement);
        for (int j = 1; j <= rowcount; ++j) {
            for (int k = 1; k <= this.getColumnCount(); ++k) {
                ColumnSpecification column = this.getColumn(k);
                String columnType = column.getColumnType().toLowerCase();
                String columnEncoding = column.getColumnEncoding();
                int random = RANDOM.nextInt(VALUE_LIST_SIZE);
                if (columnType.equalsIgnoreCase("CHAR") || columnType.equalsIgnoreCase("VARCHAR")) {
                    if (columnEncoding.equalsIgnoreCase("ascii")) {
                        prepsta.setString(k, charasciiValueList[random]);
                        continue;
                    }
                    if (columnEncoding.equalsIgnoreCase("unicode")) {
                        prepsta.setString(k, charunicodeValueList[random]);
                        continue;
                    }
                    prepsta.setString(k, charbyteValueList[random]);
                    continue;
                }
                if (columnType.equalsIgnoreCase("FLOAT")) {
                    prepsta.setFloat(k, Float.parseFloat(floatValueList[random]));
                    continue;
                }
                if (columnType.equalsIgnoreCase("BOOLEAN")) {
                    prepsta.setBoolean(k, Boolean.valueOf(booleanValueList[random]).booleanValue());
                    continue;
                }
                if (columnType.equalsIgnoreCase("INTEGER")) {
                    prepsta.setInt(k, Integer.parseInt(integerValueList[random]));
                    continue;
                }
                if (columnType.equalsIgnoreCase("SMALLINT")) {
                    prepsta.setShort(k, Short.parseShort(smallintValueList[random]));
                    continue;
                }
                if (columnType.equalsIgnoreCase("DATE")) {
                    prepsta.setDate(k, dateValueList[random]);
                    continue;
                }
                if (columnType.equalsIgnoreCase("FIXED")) {
                    prepsta.setFloat(k, Float.parseFloat(fixedValueList[random]));
                    continue;
                }
                if (columnType.equalsIgnoreCase("TIME")) {
                    prepsta.setTime(k, timeValueList[random]);
                    continue;
                }
                if (columnType.equalsIgnoreCase("TIMESTAMP")) {
                    prepsta.setTimestamp(k, timestampValueList[random]);
                    continue;
                }
                System.out.println("Fehler!!! " + columnType);
            }
            prepsta.addBatch();
        }
        prepsta.executeBatch();
    }

    public String toString() {
        String rs = this.getObjectIdentifier() + "\n";
        for (int i = 1; i <= this.getColumnCount(); ++i) {
            rs = rs + this.getColumn(i) + "\n";
        }
        return rs;
    }

    public static void setRANDOM(Random random) {
        RANDOM = random;
    }

    static {
        columnEncodingsUnicode = new String[]{"ASCII", "UNICODE", "BYTE"};
        columnEncodingsAscii = new String[]{"ASCII", "BYTE"};
        VALUE_LIST_SIZE = 10;
        MAX_FLOAT_SIZE = 38;
        MAX_CHAR_SIZE = 80;
        RANDOM = new Random();
        ObjectViewNameNumber = 0;
    }

    private class ColumnSpecification {
        private String columnName;
        private String columnType;
        private int columnLength;
        private int columnPrecision;
        private String columnEncoding;

        public String getColumnEncoding() {
            return this.columnEncoding;
        }

        public void setColumnEncoding(String columnEncoding) {
            this.columnEncoding = columnEncoding;
        }

        public int getColumnLength() {
            return this.columnLength;
        }

        public int getColumnPrecision() {
            return this.columnPrecision;
        }

        public void setColumnPrecision(int columnPrecision) {
            this.columnPrecision = columnPrecision;
        }

        public void setColumnLength(int columnLength) {
            this.columnLength = columnLength;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        public String getColumnType() {
            return this.columnType;
        }

        public void setColumnType(String columnType) {
            this.columnType = columnType;
        }

        ColumnSpecification(String columnName, String columnType, int LEN, int Precision, String Encoding) {
            this.setColumnName(columnName);
            this.setColumnType(columnType);
            this.setColumnLength(LEN);
            this.setColumnPrecision(Precision);
            this.setColumnEncoding(Encoding);
        }

        private String setStringSize(String s, int size) {
            String buff = s;
            if (s.length() > size) {
                buff = s.substring(0, size - 2) + "..";
            } else if (s.length() < size) {
                buff = s;
                while (buff.length() < size) {
                    buff = buff + " ";
                }
            }
            return buff;
        }

        public String toString() {
            return this.setStringSize(this.getColumnName(), 30) + this.setStringSize(this.getColumnType() == null ? " " : this.getColumnType(), 30) + this.setStringSize(this.getColumnEncoding() == null ? " " : this.getColumnEncoding(), 30) + this.getColumnLength();
        }
    }

    public static class MyProperties
    extends Properties {
        static final long serialVersionUID = 8504520422344334L;

        MyProperties() {
            this.setProperty("CHAR", "CHAR (#C) ");
            this.setProperty("VARCHAR", "VARCHAR (#C) ");
            this.setProperty("FIXED", "FIXED (#F ,#P)");
            this.setProperty("FLOAT", "FLOAT (#F)");
            this.setProperty("BOOLEAN", "BOOLEAN");
            this.setProperty("INTEGER", "INTEGER");
            this.setProperty("SMALLINT", "SMALLINT");
            this.setProperty("DATE", "DATE");
            this.setProperty("TIME", "TIME");
            this.setProperty("TIMESTAMP", "TIMESTAMP");
        }
    }

    public static class MyVector
    extends Vector {
        static final long serialVersionUID = 32895290587293L;

        MyVector() {
            super(10);
            this.add("CHAR");
            this.add("VARCHAR");
            this.add("FIXED");
            this.add("FLOAT");
            this.add("BOOLEAN");
            this.add("INTEGER");
            this.add("SMALLINT");
            this.add("DATE");
            this.add("TIME");
            this.add("TIMESTAMP");
        }
    }
}

