/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.simple;

import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.testcase.TestPreparedStatement;
import com.sap.sapdb.testframe.testcase.TestStatement;
import java.sql.Connection;
import java.sql.SQLException;

public class myOLTPTest
extends TestCase {
    private static final String mExUser = "TESTEXAMPLE";
    private static final String mExPassword = "TESTEXAMPLE";

    public static void cleanUp() throws TestCaseException {
        System.out.println("End of " + myOLTPTest.getTestClassId());
    }

    public static String getTestClassId() {
        return "myOLTPTest";
    }

    public static void prepare() throws TestCaseException {
        Connection myConnection = null;
        TestStatement myStatement = null;
        TestPreparedStatement myPrepStatement = null;
        int lNoOfTableRows = myOLTPTest.getParameterInt((String)"NoOfTableRows", (int)99);
        System.out.println("Start of " + myOLTPTest.getTestClassId());
        System.out.println("NoOfTableRows " + lNoOfTableRows);
        try {
            int i;
            myConnection = myOLTPTest.getDatabase().connect(myOLTPTest.getUser(), myOLTPTest.getPassword());
            myStatement = new TestStatement(null, myConnection);
            myStatement.enableExceptions(false);
            myStatement.executeUpdate("Drop user TESTEXAMPLE");
            myStatement.enableExceptions(true);
            myStatement.executeUpdate("Create user TESTEXAMPLE password TESTEXAMPLE resource not exclusive");
            myStatement.close();
            myConnection.close();
            myConnection = myOLTPTest.getDatabase().connect("TESTEXAMPLE", "TESTEXAMPLE");
            myStatement = new TestStatement(null, myConnection);
            myStatement.executeUpdate("Create table MYTABLE (k0 char(10), k1 int, f0 char(20), primary key(k1, k0))");
            myPrepStatement = new TestPreparedStatement(null, myConnection, "Insert MYTABLE values (?,?,?)");
            for (i = 0; i < lNoOfTableRows; ++i) {
                myPrepStatement.setString(1, "Key" + i);
                myPrepStatement.setInt(2, i);
                myPrepStatement.setString(3, "Test" + i);
                myPrepStatement.executeUpdate();
            }
            myPrepStatement.close();
            myOLTPTest.addGlobalMessage((String)"Method prepare", (char)'I', (String)"just created MYTABLE");
            myStatement.executeUpdate("Create table MYBIGTABLE (k0 char(10), k1 int, f0 char(20), primary key(k1, k0))");
            myPrepStatement = new TestPreparedStatement(null, myConnection, "Insert MYBIGTABLE values (?,?,?)");
            for (i = 0; i < lNoOfTableRows * 10; ++i) {
                myPrepStatement.setString(1, "Key" + i);
                myPrepStatement.setInt(2, i);
                myPrepStatement.setString(3, "Test" + i);
                myPrepStatement.addBatch();
            }
            myPrepStatement.executeBatch();
            myPrepStatement.clearBatch();
            myOLTPTest.addGlobalMessage((String)"Method prepare", (char)'I', (String)"just created MYBIGTABLE");
        }
        catch (Exception e) {
            myOLTPTest.addGlobalMessage((String)"Method prepare", (char)'E', (String)"preparation failed");
            throw new TestCaseException("Error during preparation: " + e.getClass() + e.getMessage());
        }
        finally {
            try {
                myStatement.close();
            }
            catch (Exception e) {}
            try {
                myPrepStatement.close();
            }
            catch (Exception e) {}
            try {
                myConnection.commit();
                myConnection.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Connection myConnection = null;
        TestStatement myStatement = null;
        int lNoOfTableRows = myOLTPTest.getParameterInt((String)"NoOfTableRows", (int)100);
        try {
            myConnection = myOLTPTest.getDatabase().connect("TESTEXAMPLE", "TESTEXAMPLE");
            myStatement = new TestStatement((TestCase)this, myConnection, 1005, 1007);
            myStatement.executeQuery("select * from MYTABLE");
            myStatement.execute("delete from MYTABLE where k1 < 7");
            myStatement.executeQuery("select * from MYTABLE");
            if (myStatement.getResultCounter() != lNoOfTableRows - 7) {
                this.addMessage(this.nextStep("Select"), 'E', "Mismatching result counter", myStatement.getSqlString());
            }
            myConnection.commit();
            this.addMessage(this.getStep(), 'I', "This is a test message for demonstration");
        }
        catch (Exception e) {
            this.handleExceptions(e);
        }
        finally {
            try {
                myStatement.close();
            }
            catch (Exception e) {}
            try {
                myConnection.commit();
                myConnection.close();
            }
            catch (Exception e) {}
        }
    }
}

