/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.simple;

import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.testcase.TestPreparedStatement;
import com.sap.sapdb.testframe.testcase.TestStatement;
import java.sql.Connection;
import java.sql.SQLException;

public class TestExample
extends TestCase {
    private static final String mExUser = "TESTEXAMPLE";
    private static final String mExPassword = "TESTEXAMPLE";

    public static void cleanUp() throws TestCaseException {
        System.out.println("End of " + TestExample.getTestClassId());
    }

    public static String getTestClassId() {
        return "MyTestExample";
    }

    public static boolean isReferenceEnabled() {
        return true;
    }

    public static void prepare() throws TestCaseException {
        Connection myConnection = null;
        TestStatement myStatement = null;
        TestPreparedStatement myPrepStatement = null;
        int lNoOfTableRows = TestExample.getParameterInt((String)"NoOfTableRows", (int)99);
        System.out.println("Start of " + TestExample.getTestClassId());
        try {
            int i;
            myConnection = TestExample.getDatabase().connect(TestExample.getUser(), TestExample.getPassword());
            myStatement = new TestStatement(null, myConnection);
            myStatement.enableExceptions(false);
            myStatement.executeUpdate("Drop user TESTEXAMPLE");
            myStatement.enableExceptions(true);
            myStatement.executeUpdate("Create user TESTEXAMPLE password TESTEXAMPLE resource not exclusive");
            myStatement.close();
            myConnection.close();
            myConnection = TestExample.getDatabase().connect("TESTEXAMPLE", "TESTEXAMPLE");
            myStatement = new TestStatement(null, myConnection);
            myStatement.executeUpdate("Create table MYTABLE (k0 char(10), k1 int, f0 char(20), primary key(k1, k0))");
            myPrepStatement = new TestPreparedStatement(null, myConnection, "Insert MYTABLE values (?,?,?)");
            for (i = 0; i < lNoOfTableRows; ++i) {
                myPrepStatement.setString(1, "Key" + i);
                myPrepStatement.setInt(2, i);
                myPrepStatement.setString(3, "Test" + i);
                myPrepStatement.executeUpdate();
            }
            myPrepStatement.close();
            myStatement.executeUpdate("Create table MYBIGTABLE (k0 char(10), k1 int, f0 char(20), primary key(k1, k0))");
            myPrepStatement = new TestPreparedStatement(null, myConnection, "Insert MYBIGTABLE values (?,?,?)");
            for (i = 0; i < lNoOfTableRows * 10; ++i) {
                myPrepStatement.setString(1, "Key" + i);
                myPrepStatement.setInt(2, i);
                myPrepStatement.setString(3, "Test" + i);
                myPrepStatement.addBatch();
            }
            myPrepStatement.executeBatch();
            myPrepStatement.clearBatch();
        }
        catch (Exception e) {
            TestExample.addGlobalMessage((String)"Method prepare", (char)'E', (String)"preparation failed");
            throw new TestCaseException("Error during preparation: " + e.getClass() + e.getMessage());
        }
        finally {
            try {
                myStatement.close();
            }
            catch (Exception e) {}
            try {
                myPrepStatement.close();
            }
            catch (Exception e) {}
            try {
                myConnection.commit();
                myConnection.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Connection myConnection = null;
        TestStatement myStatement = null;
        int lNoOfTableRows = TestExample.getParameterInt((String)"NoOfTableRows", (int)100);
        try {
            myConnection = TestExample.getDatabase().connect("TESTEXAMPLE", "TESTEXAMPLE");
            myStatement = new TestStatement((TestCase)this, myConnection, 1005, 1007);
            myStatement.executeQuery("select * from MYTABLE");
            this.verify(myStatement, "Select");
            myStatement.execute("delete from MYTABLE where k1 < 7");
            myStatement.executeQuery("select * from MYTABLE");
            if (myStatement.getResultCounter() != lNoOfTableRows - 7) {
                this.addMessage(this.nextStep("Select"), 'E', "Mismatching result counter", myStatement.getSqlString());
            }
            myConnection.commit();
            myStatement.executeQuery("select count(*) from MYTABLE ");
            this.verify(myStatement, "Select");
            this.addMessage(this.getStep(), 'I', "This is a test message for demonstration");
            this.storeResultObject();
        }
        catch (Exception e) {
            this.handleExceptions(e);
        }
        finally {
            try {
                myStatement.close();
            }
            catch (Exception e) {}
            try {
                myConnection.commit();
                myConnection.close();
            }
            catch (Exception e) {}
        }
    }
}

