/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.simple;

import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.utilities.Execute;
import com.sap.sapdb.testframe.utilities.Zipper;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;

public class TestEnvironment
extends TestCase {
    public static String getTestClassId() {
        return "TestEnvironment";
    }

    public static long getTimeout() {
        return 300000L;
    }

    public void run() {
        System.out.println("Run of " + TestEnvironment.getTestClassId() + " and collect test environment information....");
        StringBuffer contentOfTheFile = new StringBuffer();
        try {
            contentOfTheFile.append("The system environment:\n\n");
            String cmd = "foreach my $key (sort keys %ENV) { \n print \"$key = $ENV{$key\n}\\n\" }";
            try {
                FileWriter perlwriter = new FileWriter(new File(this.getDataOutputPath() + System.getProperty("file.separator") + "javaenvtst.pl"));
                perlwriter.write(cmd);
                perlwriter.close();
            }
            catch (IOException ioe) {
                this.addMessage(TestEnvironment.getTestClassId(), 'W', "Can not write the environment to a seperate file. \nReason: " + ioe.getLocalizedMessage());
            }
            cmd = "perl " + this.getDataOutputPath() + System.getProperty("file.separator") + "javaenvtst.pl";
            this.addMessage(TestEnvironment.getTestClassId(), 'I', "try to execute: " + cmd);
            StringBuffer sb = new StringBuffer();
            Execute exc = new Execute(cmd, null, sb);
            exc.enableWritingStdout(true);
            exc.setErrPrefix("STDERR ");
            exc.exec();
            this.addMessage(TestEnvironment.getTestClassId(), 'I', "Environment variables:\n" + sb.toString() + "\nSize of the Buffer in bytes: " + sb.length());
            contentOfTheFile.append(sb.toString());
            contentOfTheFile.append("\n\nThe perl version:\n");
            cmd = "perl -V";
            sb = new StringBuffer();
            exc = new Execute(cmd, null, sb);
            exc.enableWritingStdout(true);
            exc.setErrPrefix("STDERR ");
            exc.exec();
            this.addMessage(TestEnvironment.getTestClassId(), 'I', cmd + ":\n" + sb.toString() + "\nSize of the Buffer in bytes: " + sb.length());
            contentOfTheFile.append("\n");
            contentOfTheFile.append(sb.toString());
            String name = System.getProperty("os.name");
            if (name.indexOf("Windows") == -1) {
                contentOfTheFile.append("\n\nid:\n");
                cmd = "id";
                sb = new StringBuffer();
                exc = new Execute(cmd, null, sb);
                exc.enableWritingStdout(true);
                exc.setErrPrefix("STDERR ");
                exc.exec();
                contentOfTheFile.append(sb.toString());
                contentOfTheFile.append("\n\nid -a:\n");
                cmd = "id -a";
                sb = new StringBuffer();
                exc = new Execute(cmd, null, sb);
                exc.enableWritingStdout(true);
                exc.setErrPrefix("STDERR ");
                exc.exec();
                contentOfTheFile.append(sb.toString());
                contentOfTheFile.append("\n\nwhich cc:\n");
                cmd = "which cc";
                sb = new StringBuffer();
                exc = new Execute(cmd, null, sb);
                exc.enableWritingStdout(true);
                exc.setErrPrefix("STDERR ");
                exc.exec();
                contentOfTheFile.append(sb.toString());
                contentOfTheFile.append("\n\nwhich cpc:\n");
                cmd = "which cpc";
                sb = new StringBuffer();
                exc = new Execute(cmd, null, sb);
                exc.enableWritingStdout(true);
                exc.setErrPrefix("STDERR ");
                exc.exec();
                contentOfTheFile.append(sb.toString());
            }
            contentOfTheFile.append("\n\nirconf -a:\n");
            cmd = "irconf -a";
            sb = new StringBuffer();
            exc = new Execute(cmd, null, sb);
            exc.enableWritingStdout(true);
            exc.setErrPrefix("STDERR ");
            exc.exec();
            this.addMessage(TestEnvironment.getTestClassId(), 'I', cmd + ":\n" + sb.toString() + "\nSize of the Buffer in bytes: " + sb.length());
            contentOfTheFile.append("\n");
            contentOfTheFile.append(sb.toString());
            String dbHost = TestEnvironment.getDatabase().getHost();
            if (dbHost.equals("localhost")) {
                String dbName = TestEnvironment.getDatabase().getName();
                Connection myDatabaseConnection = TestEnvironment.getDatabase().connect();
                contentOfTheFile.append("\n\nx_cons show all:\n");
                cmd = "x_cons " + dbName + " show all";
                sb = new StringBuffer(500000);
                exc = new Execute(cmd, null, sb);
                exc.enableWritingStdout(true);
                exc.setErrPrefix("STDERR ");
                exc.ignoreBufferLimitForStdOut(true);
                exc.exec();
                int exitValue = exc.getExitValue();
                if (exitValue != 0) {
                    if (sb.length() > 10000) {
                        this.addMessage(TestEnvironment.getTestClassId(), 'E', cmd + "\nExit value is: " + exitValue + "\nSize of the Stringbuffer in bytes is too big for test protocol: " + sb.length() + "\nOutput is written to disk: " + this.getDataOutputPath());
                        try {
                            FileWriter xconsOutFile = new FileWriter(new File(this.getDataOutputPath() + System.getProperty("file.separator") + "xconsShowAll.prt"));
                            xconsOutFile.write(sb.toString());
                            xconsOutFile.close();
                        }
                        catch (IOException ioe) {
                            this.addMessage(TestEnvironment.getTestClassId(), 'W', "Can not write the 'x_cons show all' output to a seperate file. \nReason: " + ioe.getLocalizedMessage());
                        }
                    } else {
                        this.addMessage(TestEnvironment.getTestClassId(), 'E', cmd + "\nExit value is: " + exitValue + ":\n" + sb.toString() + "\nSize of the Stringbuffer in bytes: " + sb.length());
                    }
                } else {
                    this.addMessage(TestEnvironment.getTestClassId(), 'I', "\nx_cons worked fine! Exit value was: " + exitValue);
                }
                if (myDatabaseConnection != null && !myDatabaseConnection.isClosed()) {
                    myDatabaseConnection.close();
                }
                contentOfTheFile.append("\n");
                contentOfTheFile.append(sb.toString());
            }
            try {
                FileWriter writer = new FileWriter(new File(this.getDataOutputPath() + System.getProperty("file.separator") + "TestEnvironment.txt"));
                writer.write(contentOfTheFile.toString());
                writer.close();
            }
            catch (IOException ioe) {
                this.addMessage(TestEnvironment.getTestClassId(), 'W', "Can not write the environment to a seperate file. \nReason: " + ioe.getLocalizedMessage());
            }
            File dropMe = new File(this.getDataOutputPath() + System.getProperty("file.separator") + "javaenvtst.pl");
            if (dropMe.exists()) {
                dropMe.delete();
            }
        }
        catch (Exception ex) {
            this.addMessage(TestEnvironment.getTestClassId(), 'E', "Catched an unexpected exception: " + ex.getMessage() + "\nCurrent content of the logfile: \n" + contentOfTheFile.toString());
        }
    }

    public static void cleanUp() throws TestCaseException {
        System.out.println("End of " + TestEnvironment.getTestClassId());
    }

    public static void prepare() throws TestCaseException {
        System.out.println("Start of the test " + TestEnvironment.getTestClassId());
    }

    public String getLogFile() {
        File theZipFile = null;
        try {
            File TestEnvironmentFile = new File(this.getDataOutputPath() + File.separator + "TestEnvironment.txt");
            theZipFile = new File(this.getDataOutputPath() + File.separator + "TestEnvironment.zip");
            Zipper myZipper = new Zipper(theZipFile);
            myZipper.addFile(TestEnvironmentFile);
            myZipper.zip();
        }
        catch (IOException e) {
            this.addMessage(TestEnvironment.getTestClassId(), 'W', "Failed to create a zipfile with the TestEnvironment:\n" + e.getLocalizedMessage());
            e.printStackTrace();
            return this.getDataOutputPath() + File.separator + "TestEnvironment.txt";
        }
        catch (Exception ex) {
            this.addMessage(TestEnvironment.getTestClassId(), 'W', "Failed to get the TestEnvironment:\n" + ex.getLocalizedMessage());
            ex.printStackTrace();
            return this.getDataOutputPath() + File.separator + "TestEnvironment.txt";
        }
        return theZipFile.getAbsolutePath();
    }
}

