/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.simple;

import com.sap.sapdb.oltptest.simple.SQLMaster;
import com.sap.sapdb.oltptest.simple.StressTestActor;
import com.sap.sapdb.oltptest.simple.TestActor;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.utilities.RandomGenerator;
import java.sql.SQLException;
import java.util.Date;

public class StressTest
extends SQLMaster {
    private static int mNumberOfTasks;
    private static int mMaximumRuntime;
    private static final String sVersion = "5.0";

    private Date attemptActorsStop(TestActor[] Actors) {
        for (int i = 0; i < Actors.length; ++i) {
            Actors[i].shouldStop();
        }
        return new Date();
    }

    TestActor[] createActors() throws Exception {
        int i;
        int j = 0;
        TestActor[] Actors = new TestActor[mNumberOfTasks];
        for (i = 0; i < mNumberOfTasks; ++i) {
            Actors[j] = new StressTestActor();
            Actors[j].setMaster(this);
            Actors[j].setTitle("StressTester" + i);
        }
        for (i = 0; i < Actors.length; ++i) {
            Actors[i].start();
        }
        return Actors;
    }

    private void forceActorsStop(TestActor[] Actors) {
        for (int i = 0; i < Actors.length; ++i) {
            Actors[i].interrupt();
        }
    }

    public static void prepare() throws TestCaseException {
        StressTest.readParameters();
        StressTest.printParameters();
    }

    private static void printParameters() throws TestCaseException {
        StressTest.printInfo("StressTest", "Starting StressTest 5.0");
        StressTest.printInfo("StressTest", "Number of parallel tasks= " + mNumberOfTasks);
        StressTest.printInfo("StressTest", "Maximum row count per table= " + StressTest.getParameterInt((String)"MaxRownumber", (int)1024));
        StressTest.printInfo("StressTest", "Initial row count per table= " + StressTest.getParameterInt((String)"InitialRownumber", (int)1024));
        StressTest.printInfo("StressTest", "Table row size= " + StressTest.getParameterInt((String)"RowLength", (int)1024) + " Bytes");
        StressTest.printInfo("StressTest", "Drop the tables when finished= " + StressTest.getParameterBoolean((String)"DropAfterExecution", (boolean)true));
        StressTest.printInfo("StressTest", "Percentage of INSERT commands= " + StressTest.getParameterInt((String)"InsertPercentage", (int)25) + " %");
        StressTest.printInfo("StressTest", "Percentage of UPDATE commands= " + StressTest.getParameterInt((String)"UpdatePercentage", (int)25) + " %");
        StressTest.printInfo("StressTest", "Percentage of DELETE commands= " + StressTest.getParameterInt((String)"DeletePercentage", (int)25) + " %");
        StressTest.printInfo("StressTest", "Percentage of SELECT commands= " + StressTest.getParameterInt((String)"SelectPercentage", (int)25) + " %");
        StressTest.printInfo("StressTest", "Commit percentage= " + StressTest.getParameterInt((String)"CommitPercentage", (int)67) + " %");
        StressTest.printInfo("StressTest", "Maximum statements per transaction= " + StressTest.getParameterInt((String)"MaxStatementsPerTransaction", (int)5));
        StressTest.printInfo("StressTest", "Maximum runtime= " + mMaximumRuntime + " min");
    }

    private static void readParameters() throws TestCaseException {
        mTraceOn = StressTest.getParameterBoolean((String)"TraceOn", (boolean)true);
        mNumberOfTasks = StressTest.getParameterInt((String)"NumberOfTasks", (int)1);
        mMaximumRuntime = StressTest.getParameterInt((String)"MaximumRuntime", (int)5);
        mRandomSeed = StressTest.getParameterInt((String)"RandomSeed", (int)-1);
        if (mRandomSeed != -1) {
            RandomGenerator.setRandomSeed((int)mRandomSeed);
        }
        if (mNumberOfTasks < 1) {
            throw new TestCaseException("NumberOfTasks has to be greater than 0");
        }
        if (mMaximumRuntime <= 0) {
            throw new TestCaseException("MaximumRuntime has to be greater than 0");
        }
    }

    public void run() {
        boolean Finished = false;
        boolean AttemptToStop = false;
        Date AttemptToStopTime = null;
        try {
            int i;
            TestActor[] Actors = this.createActors();
            Date StartTime = new Date();
            while (!Finished) {
                long TimeDiff;
                if (!AttemptToStop) {
                    if (mMaximumRuntime != -1 && (TimeDiff = (new Date().getTime() - StartTime.getTime()) / 60000L) > (long)mMaximumRuntime) {
                        AttemptToStopTime = this.attemptActorsStop(Actors);
                    }
                } else {
                    TimeDiff = new Date().getTime() - AttemptToStopTime.getTime();
                    if (TimeDiff > 5000L) {
                        this.forceActorsStop(Actors);
                    }
                }
                int NumberOfRunningActors = 0;
                for (i = 0; i < Actors.length; ++i) {
                    if (Actors[i].isRunning()) {
                        ++NumberOfRunningActors;
                        continue;
                    }
                    if (!Actors[i].hasError()) continue;
                    AttemptToStopTime = this.attemptActorsStop(Actors);
                }
                if (NumberOfRunningActors == 0) {
                    Finished = true;
                    continue;
                }
                Thread.sleep(100L);
            }
            for (i = 0; i < Actors.length; ++i) {
                if (Actors[i].hasError()) {
                    StressTest.addGlobalMessage((String)Actors[i].getTitle(), (char)'E', (String)Actors[i].getStatusMessage());
                    continue;
                }
                StressTest.addGlobalMessage((String)Actors[i].getTitle(), (char)'I', (String)Actors[i].getStatusMessage());
            }
        }
        catch (Exception e) {
            StressTest.addGlobalMessage((String)"StressTest", (char)'E', (String)e.getMessage());
        }
    }
}

