/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.simple;

import com.sap.dbtech.jdbc.exceptions.DatabaseException;
import com.sap.dbtech.powertoys.DBM;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.testcase.TestStatement;
import java.sql.Connection;
import java.sql.SQLException;

public class RestartDbFull
extends TestCase {
    private static final int DBERR_DUPLICATE_NAME = -6006;
    private static final int DBERR_DB_TIMEOUT = 700;
    private static final int DBERR_DB_CRASH = -708;
    private static final int NO_ROWS_ADDED = 10000;
    private static final String sUser = "VOLLEDB";
    private static final String sPassword = "VOLLEDB";
    private static boolean mConsoleMsg;
    private DBM mDBMan = null;
    private boolean isAlmostFull = false;
    private static int mNoRowsObserver;
    private static Connection mConnection;
    private static TestStatement mTstmt;
    private static String mDbFullPercentage;
    private static final String sVersion = "1.0";
    private static int mNoOfTables;

    public static String getTestClassId() {
        return "RestartDbFull";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void prepare() throws TestCaseException {
        Connection lDefConnection = null;
        TestStatement lDefTstmt = null;
        try {
            block13: {
                lDefConnection = RestartDbFull.getDatabase().connect(RestartDbFull.getUser(), RestartDbFull.getPassword());
                lDefTstmt = new TestStatement(null, lDefConnection);
                lDefTstmt.enableExceptions(false);
                lDefTstmt.executeUpdate("drop user VOLLEDB");
                lDefTstmt.enableExceptions(true);
                try {
                    lDefTstmt.executeUpdate("Create user VOLLEDB password VOLLEDB dba not exclusive");
                }
                catch (DatabaseException e) {
                    if (e.getErrorCode() == -6006) break block13;
                    RestartDbFull.addGlobalMessage((String)"Init failure", (char)'E', (String)"Creation of user : VOLLEDB not possible");
                    throw e;
                }
            }
            RestartDbFull.readParameters();
            RestartDbFull.printParameters();
            RestartDbFull.Trace(mConsoleMsg, 'I', "Creating table and dbprocedure");
            RestartDbFull.createTables(mNoOfTables);
            RestartDbFull.createDBProcedures(mNoOfTables);
            mConnection = RestartDbFull.getDatabase().connect("VOLLEDB", "VOLLEDB");
            mConnection.setAutoCommit(false);
            mTstmt = new TestStatement(null, mConnection);
            mConnection.commit();
        }
        catch (Exception e) {
            RestartDbFull.handleGlobalExceptions((Exception)e);
        }
        finally {
            try {
                lDefTstmt.close();
                lDefConnection.close();
            }
            catch (Exception exception) {}
        }
    }

    private static void readParameters() throws TestCaseException {
        mDbFullPercentage = RestartDbFull.getParameterString((String)"DBFullPercentage", (String)"99");
        mConsoleMsg = RestartDbFull.getParameterBoolean((String)"ConsoleMsg", (boolean)true);
        mNoOfTables = RestartDbFull.getParameterInt((String)"NoOfTables", (int)10);
    }

    private static void printParameters() throws TestCaseException {
        String parameterString = "";
        RestartDbFull.Trace(mConsoleMsg, 'I', "Starting RestartDbFull 1.0");
        parameterString = parameterString + "\n     Restart DB at filling degree (%): " + mDbFullPercentage + "\n\t  Number of tables                : " + mNoOfTables;
        RestartDbFull.Trace(mConsoleMsg, 'I', "\nParameter Setting for this test: \n------------------------------------------------------ \n" + parameterString + "\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Connection lConnection = null;
        TestStatement lTstmt = null;
        Object lTPstmt = null;
        String dbmCmdOut = "";
        try {
            lConnection = RestartDbFull.getDatabase().connect("VOLLEDB", "VOLLEDB");
            lTstmt = new TestStatement((TestCase)this, lConnection);
            FillDbThread superSizeMe = new FillDbThread(mNoOfTables);
            RestartDbFull.Trace(mConsoleMsg, 'I', "Performing 'dbmcli -d <db> -u dbm,dbm info state' until 'Data            (%)     = 90'");
            while (!this.isAlmostFull) {
                try {
                    dbmCmdOut = this.executeDBMCmd("info state");
                    int startFillstate = dbmCmdOut.indexOf("Data            (%)     = ");
                    String fillingState = dbmCmdOut.substring(startFillstate + 26, startFillstate + 28);
                    System.out.println("################ fillingState = " + fillingState);
                    if (!fillingState.equalsIgnoreCase(mDbFullPercentage)) continue;
                    this.isAlmostFull = true;
                    System.out.println("################ DB almost full - trying db_stop!!! ");
                    this.executeDBMCmd("db_stop");
                    superSizeMe.pleaseStop();
                }
                catch (Exception e) {
                    if (e.getMessage().equalsIgnoreCase("data area full")) {
                        RestartDbFull.Trace(mConsoleMsg, 'I', "DBME-Message: " + e.getMessage() + "\n   If this happened, the test does not habe a chance " + "\n   to run into DBFULL during restart (which is the " + "\n   purpose of this test) ... thus, it can be aborted!");
                        continue;
                    }
                    RestartDbFull.Trace(mConsoleMsg, 'I', "DBME-Message 'info state': " + e.getMessage());
                }
            }
            Thread.sleep(3000L);
            System.out.println("################ DB almost full - trying db_restart!!! \n      hoping that db falls in state FULL ");
            this.executeDBMCmd("db_restart");
        }
        catch (SQLException e) {
            if (700 == e.getErrorCode()) {
                RestartDbFull.Trace(mConsoleMsg, 'E', "Error is DB FULL or timeout after online: " + e.getErrorCode());
            }
        }
        catch (Exception e) {
            this.handleExceptions(e);
        }
        finally {
            try {
                lTstmt.close();
                lTPstmt.close();
                lConnection.close();
                RestartDbFull.Trace(true, 'I', "restart DB kernel");
                this.executeDBMCmd("db_restart");
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanUp() throws TestCaseException {
    }

    private static void createTables(int NoOfTables) {
        Connection con = null;
        TestStatement stmt = null;
        try {
            con = RestartDbFull.getDatabase().connect("VOLLEDB", "VOLLEDB");
            stmt = new TestStatement(null, con);
            for (int i = 0; i < NoOfTables; ++i) {
                stmt.executeUpdate("CREATE TABLE GROWING" + i + " (KEY1  int, FILLER  CHAR (250))");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void createDBProcedures(int NoOfTables) throws TestCaseException {
        Connection con = null;
        TestStatement stmt = null;
        try {
            con = RestartDbFull.getDatabase().connect("VOLLEDB", "VOLLEDB");
            stmt = new TestStatement(null, con);
            for (int i = 0; i < NoOfTables; ++i) {
                stmt.executeUpdate("CREATE DBPROC FILLDB" + i + "(IN I_NOROWSOBSERV INT) AS " + "VAR x INT;  y CHAR(250); " + "SET x=I_NOROWSOBSERV; " + "SET y='This is a test that is supposed to fill the database until it is completely full then tries to restart it and possible needs an addvolume to do so - afterwards it checks data consistency'; " + "WHILE x < (I_NOROWSOBSERV + 10000) DO BEGIN " + "\t\tx = x + 1; " + "\t\tINSERT INTO VOLLEDB.GROWING" + i + " VALUES(:x, :y); " + "END; ");
            }
            con.commit();
        }
        catch (Exception e) {
            RestartDbFull.Trace(mConsoleMsg, 'E', "SQL Error while creating DBProcedure: " + e.getMessage());
            throw new TestCaseException("DbFullTest.createDBProcedure() failed");
        }
        finally {
            try {
                stmt.close();
                con.close();
            }
            catch (Exception e) {}
        }
    }

    public static long getTimeout() {
        return 0L;
    }

    public static boolean isReferenceEnabled() {
        return false;
    }

    public static boolean isSAPOnly() {
        return true;
    }

    public String executeDBMCmd(String pCmd) throws TestDatabaseException {
        String logon = "";
        String mHost = "";
        String mName = "";
        try {
            mHost = RestartDbFull.getDatabase().getHost();
            mName = RestartDbFull.getDatabase().getName();
            int mPort = RestartDbFull.getDatabase().getPort();
            if (this.mDBMan == null) {
                this.mDBMan = DBM.dbDBM((String)(mHost + ":" + mPort), (String)mName);
                logon = "USER_LOGON " + RestartDbFull.getDatabase().getDBMUser() + "," + RestartDbFull.getDatabase().getDBMPassword();
                this.mDBMan.cmd(logon);
            }
            return this.mDBMan.cmd(pCmd);
        }
        catch (Exception e) {
            System.out.println("Could not execute: " + pCmd);
            if (pCmd.equalsIgnoreCase("db_restart") && e.getMessage().equalsIgnoreCase("data area full")) {
                RestartDbFull.Trace(mConsoleMsg, 'I', "Test worked fine! Data area fell full after restart!");
                RestartDbFull.Trace(mConsoleMsg, 'I', "Starting thread to put DB in admin mode, add a volume and restart db!");
                DbFullThread isFull = new DbFullThread();
                System.out.println("DbFullThread is running: " + isFull.isRunning());
                return "OK";
            }
            if (pCmd.equalsIgnoreCase("db_restart") && !e.getMessage().equalsIgnoreCase("data area full")) {
                RestartDbFull.Trace(mConsoleMsg, 'I', "Test did not work ok! Data area did NOT fall full after restart! \n    Test is done!");
                return "NOT OK";
            }
            System.out.println("Exception: " + e.getMessage() + "\n" + e.getClass());
            throw new TestDatabaseException(e, " DBM command: " + pCmd + ", logon String: " + logon);
        }
    }

    private static void Trace(boolean consoleMsg, char iwe, String msg) {
        if (consoleMsg) {
            System.out.println(msg);
        }
        if (iwe == 'I') {
            RestartDbFull.addGlobalMessage((String)RestartDbFull.getTestClassId(), (char)'I', (String)msg);
        }
        if (iwe == 'W') {
            RestartDbFull.addGlobalMessage((String)RestartDbFull.getTestClassId(), (char)'W', (String)msg);
        }
        if (iwe == 'E') {
            RestartDbFull.addGlobalMessage((String)RestartDbFull.getTestClassId(), (char)'E', (String)msg);
        }
    }

    static {
        mNoRowsObserver = 0;
        mConnection = null;
        mTstmt = null;
    }

    class DbFullThread
    extends Thread {
        String dbmCmdOut = "";
        int lNoOfTables;
        boolean keepRunning = true;

        DbFullThread() {
            this.start();
            RestartDbFull.Trace(mConsoleMsg, 'I', "Started DbFullThread!");
        }

        public void run() {
            String dbmCmdOut = "";
            try {
                Thread.sleep(10000L);
                RestartDbFull.Trace(mConsoleMsg, 'I', "Check, if DB is full (db_state - v)!");
                RestartDbFull.this.mDBMan = null;
                dbmCmdOut = RestartDbFull.this.executeDBMCmd("db_state -v");
                RestartDbFull.Trace(mConsoleMsg, 'I', "Output from db_state -v dbmCmdOut " + dbmCmdOut);
                int start = dbmCmdOut.indexOf("Database Full = ");
                String answer = dbmCmdOut.substring(start + 16, start + 19);
                if (answer.equalsIgnoreCase("yes")) {
                    RestartDbFull.Trace(mConsoleMsg, 'I', "DB is full (db_state - v)!!!!");
                    RestartDbFull.this.executeDBMCmd("db_stop");
                    Thread.sleep(3000L);
                    RestartDbFull.this.executeDBMCmd("db_admin");
                    Thread.sleep(3000L);
                    RestartDbFull.this.executeDBMCmd("db_addvolume DATA DAT02.dat F 5000");
                    RestartDbFull.this.executeDBMCmd("db_online");
                    RestartDbFull.Trace(mConsoleMsg, 'I', "DbFullThread: Made it until AFTER db_online!!!!");
                    this.keepRunning = false;
                }
            }
            catch (Exception e) {
                this.keepRunning = false;
                RestartDbFull.Trace(mConsoleMsg, 'E', "Error while filling DB:   " + e.getMessage());
            }
        }

        public boolean isRunning() {
            return this.keepRunning;
        }

        public void pleaseStop() {
            this.keepRunning = false;
        }
    }

    class FillDbThread
    extends Thread {
        String dbmCmdOut = "";
        int lNoOfTables;
        boolean keepRunning = true;

        FillDbThread(int NoOfTables) {
            this.lNoOfTables = NoOfTables;
            this.start();
            RestartDbFull.Trace(mConsoleMsg, 'I', "Started FillDbThread!");
        }

        public void run() {
            String CallString = "";
            try {
                RestartDbFull.Trace(mConsoleMsg, 'I', "CALL FILLDB<n> until db is full!");
                while (this.keepRunning) {
                    for (int i = 0; i < this.lNoOfTables; ++i) {
                        CallString = "CALL FILLDB" + i + "(" + mNoRowsObserver + ")";
                        mTstmt.execute(CallString);
                        mTstmt.execute("commit");
                    }
                    mConnection.commit();
                    mNoRowsObserver += 10000;
                    if (!RestartDbFull.this.isAlmostFull) continue;
                    this.keepRunning = false;
                }
            }
            catch (SQLException se) {
                if (700 == se.getErrorCode() || -708 == se.getErrorCode()) {
                    this.pleaseStop();
                    RestartDbFull.Trace(mConsoleMsg, 'I', "This is OK: Filling thread received timeout (err 700) or crash (err -708) because DB is now full:   " + se.getMessage());
                } else {
                    RestartDbFull.Trace(mConsoleMsg, 'E', "SQL Error while filling DB:   " + se.getMessage());
                    this.pleaseStop();
                }
            }
            catch (Exception e) {
                if (e.getClass().equals("Connection down, session released")) {
                    this.keepRunning = false;
                    RestartDbFull.Trace(mConsoleMsg, 'I', "Test just restarts DB - that's the reason for '" + e.getMessage() + "'");
                }
                this.keepRunning = false;
                RestartDbFull.Trace(mConsoleMsg, 'E', "Error while filling DB:   " + e.getMessage());
            }
        }

        public void pleaseStop() {
            this.keepRunning = false;
        }
    }
}

