/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.simple;

import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.testcase.TestStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;

public class Example5
extends TestCase {
    static int mUpdatePercent;
    static int mInsertPercent;
    static int mSelectPercent;
    static int mCommitPercent;
    static int mRollbackPercent;
    static long mStopTime;
    static boolean mTestRunning;
    static int mKey;

    private synchronized int getNextKey() {
        return mKey++;
    }

    public static void prepare() throws TestCaseException {
        try {
            Connection Con = Example5.getDatabase().connect(Example5.getUser(), Example5.getPassword());
            TestStatement Stmt = new TestStatement(null, Con);
            Stmt.executeUpdateIgnoreErrors("DROP USER TEST");
            Stmt.executeUpdate("CREATE USER TEST PASSWORD TEST RESOURCE NOT EXCLUSIVE", -6006);
            Con = Example5.getDatabase().connect("TEST", "TEST");
            Stmt = new TestStatement(null, Con);
            Stmt.executeUpdate("DROP TABLE MULTITABLE", -4004);
            Stmt.executeUpdate("CREATE TABLE MULTITABLE (IND CHAR(30), VALUE1 CHAR(50), VALUE2 FLOAT )");
            mInsertPercent = Example5.getParameterInt((String)"InsertPercent", (int)40);
            mUpdatePercent = Example5.getParameterInt((String)"UpdatePercent", (int)20) + mInsertPercent;
            mSelectPercent = Example5.getParameterInt((String)"SelectPercent", (int)40) + mUpdatePercent;
            mCommitPercent = Example5.getParameterInt((String)"CommitPercent", (int)5);
            mRollbackPercent = Example5.getParameterInt((String)"RollbackPercent", (int)3) + mCommitPercent;
            mStopTime = new Date().getTime() + (long)(Example5.getParameterInt((String)"MaxRuntime", (int)120) * 1000);
            mTestRunning = true;
            mKey = 0;
        }
        catch (Exception e) {
            Example5.addGlobalMessage((String)"Method prepare", (char)'E', (String)"preparation failed");
            throw new TestCaseException("Error during preparation: " + e.getClass() + e.getMessage());
        }
    }

    public static int randomInt(int MinValue, int MaxValue) {
        return (int)(Math.random() * (double)(MaxValue - MinValue + 1)) + MinValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Connection Con = null;
        try {
            Con = Example5.getDatabase().connect("TEST", "TEST");
            TestStatement Stmt = new TestStatement((TestCase)this, Con);
            Stmt.enableExplain(false);
            Con.setAutoCommit(false);
            System.out.println(this.getTestId() + ": Starting");
            while (mTestRunning) {
                String SQLStatement;
                int NextAction = Example5.randomInt(0, 100);
                if (NextAction < mInsertPercent) {
                    SQLStatement = "INSERT INTO MULTITABLE VALUES( '" + this.getTestId() + this.getNextKey() + "', 'VALUE" + Example5.randomInt(0, 10000) + "', " + Example5.randomInt(0, 10000) + ")";
                    Stmt.executeUpdate(SQLStatement);
                }
                if (NextAction >= mInsertPercent && NextAction < mUpdatePercent) {
                    SQLStatement = "UPDATE MULTITABLE SET VALUE1 = 'NEWVAL" + Example5.randomInt(0, 100) + "', VALUE2 = " + Example5.randomInt(0, 10000) + " WHERE IND = '" + this.getTestId() + Example5.randomInt(0, mKey) + "'";
                    Stmt.executeUpdate(SQLStatement);
                }
                if (NextAction >= mUpdatePercent && NextAction < mSelectPercent) {
                    SQLStatement = "SELECT * FROM MULTITABLE WHERE IND LIKE '*" + Example5.randomInt(0, mKey) + "*' OR VALUE1 = 'VALUE" + Example5.randomInt(0, 10000) + "' WITH LOCK ISOLATION LEVEL 0";
                    Stmt.executeQuery(SQLStatement);
                }
                if ((NextAction = (int)(Math.random() * 101.0)) < mCommitPercent) {
                    Con.commit();
                }
                if (NextAction > mCommitPercent && NextAction < mRollbackPercent) {
                    Con.rollback();
                }
                Thread.sleep(25L);
                if (new Date().getTime() <= mStopTime) continue;
                System.out.println(this.getTestId() + ": Timeout");
                mTestRunning = false;
            }
        }
        catch (Exception e) {
            System.out.println(this.getTestId() + ": Exception: " + e.getMessage());
            mTestRunning = false;
            this.handleExceptions(e);
        }
        finally {
            try {
                Con.rollback();
            }
            catch (Exception e) {}
        }
        System.out.println(this.getTestId() + ": Finished");
    }
}

