/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.simple;

import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDatabaseSap;
import com.sap.sapdb.testframe.driver.TestDriver;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.testcase.TestPreparedStatement;
import com.sap.sapdb.testframe.testcase.TestStatement;
import com.sap.sapdb.testframe.testcase.VerificationData;
import com.sap.sapdb.testframe.testcase.VerificationDataComplete;
import com.sap.sapdb.testframe.testcase.VerificationDataSorted;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;

public class DDLTest01
extends TestCase {
    private static final String sTestUser = "SAPDDLT01";
    private static final String sTestUserPassword = "SAPDDLT01";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanUp() throws TestCaseException {
    }

    public static String getTestClassId() {
        return "DDLTest01";
    }

    public static long getTimeout() {
        return 300000L;
    }

    public static boolean isReferenceEnabled() {
        return true;
    }

    public static boolean isSAPOnly() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void prepare() throws TestCaseException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Connection c = null;
        TestStatement s = null;
        try {
            c = DDLTest01.getDatabase().connect(DDLTest01.getDatabase().getUser(), DDLTest01.getDatabase().getPassword());
            s = new TestStatement((TestCase)this, c);
            s.enableExceptions(false);
            s.executeUpdate("drop user SAPDDLT01");
            s.enableExceptions(true);
            s.executeUpdate("create user SAPDDLT01 password SAPDDLT01 dba not exclusive");
            this.verify(s, "create");
            s.close();
            c.close();
            c = DDLTest01.getDatabase().connect("SAPDDLT01", "SAPDDLT01");
            s = new TestStatement((TestCase)this, c);
            String a = "CREATE TABLE R ( R1 CHAR (10)  ASCII, R2 CHAR (40) ASCII,";
            a = a + " R3 CHAR (160) ASCII, R4 CHAR (25) ASCII,";
            a = a + " D5 CHAR (12)  ASCII, PRIMARY KEY (R1,R2,R3,R4))";
            s.execute(a);
            String cr = a;
            this.verifyTableDef("R", c, "create");
            s.enableExceptions(false);
            a = "CREATE TABLE T ( D1 CHAR (10)  ASCII, D2 CHAR (40) ASCII,";
            a = a + "D3 CHAR (160) ASCII, D4 CHAR (25) ASCII,";
            a = a + "D5 CHAR (12)  ASCII, FOREIGN KEY (D1,D2,D3,D4) REFERENCES R (r1) )";
            s.execute(a);
            this.checkErrorCode(s, -1002, "create");
            a = "CREATE TABLE T ( D1 CHAR (10)  ASCII, D2 CHAR (40) ASCII,";
            a = a + "D3 CHAR (160) ASCII, D4 CHAR (25) ASCII,";
            a = a + "D5 CHAR (12)  ASCII, FOREIGN KEY (D1,D2,D3,D4) REFERENCES R (r1, r2) )";
            s.execute(a);
            this.checkErrorCode(s, -1002, "create");
            a = "CREATE TABLE T ( D1 CHAR (10)  ASCII, D2 CHAR (40) ASCII,";
            a = a + "D3 CHAR (160) ASCII, D4 CHAR (25) ASCII,";
            a = a + "D5 CHAR (12)  ASCII, FOREIGN KEY (D1,D2,D3,D4) REFERENCES R (r1, r2, r3) )";
            s.execute(a);
            this.checkErrorCode(s, -1002, "create");
            a = "CREATE TABLE T ( D1 CHAR (10)  ASCII, D2 CHAR (40) ASCII,";
            a = a + "D3 CHAR (160) ASCII, D4 CHAR (25) ASCII,";
            a = a + "D5 CHAR (12)  ASCII, FOREIGN KEY (D1,D2,D3,D4) REFERENCES R (r1, r1, r1, r1) )";
            s.execute(a);
            this.checkErrorCode(s, -8006, "create");
            a = "CREATE TABLE T ( D1 CHAR (10)  ASCII, D2 CHAR (40) ASCII,";
            a = a + "D3 CHAR (160) ASCII, D4 CHAR (25) ASCII,";
            a = a + "D5 CHAR (12)  ASCII, FOREIGN KEY (D1,D2,D3,D4) REFERENCES R (d1, d2, d3, d4) )";
            s.execute(a);
            this.checkErrorCode(s, -4005, "create");
            a = "CREATE TABLE T ( D1 CHAR (20)  ASCII, D2 CHAR (40) ASCII,";
            a = a + "D3 CHAR (160) ASCII, D4 CHAR (25) ASCII,";
            a = a + "D5 CHAR (12)  ASCII, FOREIGN KEY (D1,D2,D3,D4) REFERENCES R )";
            s.execute(a);
            this.checkErrorCode(s, -8006, "create");
            if (!TestDriver.compareRelease((String)(((TestDatabaseSap)DDLTest01.getDatabase()).getKernelVersion() + "." + ((TestDatabaseSap)DDLTest01.getDatabase()).getKernelBuild().substring(0, 3)), (String)">=", (String)"7.4.4.2")) {
                a = "CREATE TABLE T ( D1 CHAR (10)  EBCDIC, D2 CHAR (40) ASCII,";
                a = a + "D3 CHAR (160) ASCII, D4 CHAR (25) ASCII,";
                a = a + "D5 CHAR (12)  ASCII, FOREIGN KEY (D1,D2,D3,D4) REFERENCES R )";
                s.execute(a);
                this.checkErrorCode(s, -8006, "create");
            }
            a = "CREATE TABLE T ( D1 INT, D2 CHAR (40) ASCII,";
            a = a + "D3 CHAR (160) ASCII, D4 CHAR (25) ASCII,";
            a = a + "D5 CHAR (12)  ASCII, FOREIGN KEY (D1,D2,D3,D4) REFERENCES R )";
            s.execute(a);
            this.checkErrorCode(s, -8006, "create");
            a = "CREATE TABLE T ( D1 CHAR (10)  ASCII, D2 CHAR (40) ASCII,";
            a = a + "D3 CHAR (160) ASCII, D4 CHAR (25) ASCII,";
            a = a + "D5 CHAR (12)  ASCII, FOREIGN KEY (D6,D2,D3,D4) REFERENCES R )";
            s.execute(a);
            this.checkErrorCode(s, -4005, "create");
            a = "CREATE TABLE T ( D1 CHAR (20)  ASCII, D2 CHAR (40) ASCII,";
            a = a + "D3 CHAR (160) ASCII, D4 CHAR (25) ASCII,";
            a = a + "D5 CHAR (12)  ASCII, FOREIGN KEY (D1) REFERENCES R (r1,r2) )";
            s.execute(a);
            this.checkErrorCode(s, -8006, "create");
            a = "CREATE TABLE T ( D1 CHAR (20)  ASCII, D2 CHAR (40) ASCII,";
            a = a + "D3 CHAR (160) ASCII, D4 CHAR (25) ASCII,";
            a = a + "D5 CHAR (12)  ASCII, FOREIGN KEY (D4,D3,D2,D1) REFERENCES R )";
            s.execute(a);
            this.checkErrorCode(s, -8006, "create");
            a = "CREATE TABLE T ( D1 CHAR (20)  ASCII, D2 CHAR (40) ASCII,";
            a = a + "D3 CHAR (160) ASCII, D4 CHAR (25) ASCII,";
            a = a + "D5 CHAR (12)  ASCII, FOREIGN KEY (D4,D3,D3,D1) REFERENCES R (r1, r2, r3, r4) )";
            s.execute(a);
            this.checkErrorCode(s, -8006, "create");
            s.enableExceptions(true);
            a = "CREATE TABLE T ( D1 CHAR (10)  ASCII, D2 CHAR (40) ASCII,";
            a = a + "D3 CHAR (160) ASCII, D4 CHAR (25) ASCII,";
            a = a + "D5 CHAR (12)  ASCII, FOREIGN KEY (D1,D2,D3,D4) REFERENCES R (r1, r2, r3, r4) )";
            s.execute(a);
            String ct = a;
            this.verifyTableDef("T", c, "create");
            s.enableExceptions(false);
            s.execute(a);
            this.checkErrorCode(s, -6000, "create");
            s.executeUpdate("alter table t column d1 char (20) ascii");
            this.checkErrorCode(s, -7038, "alter column");
            s.executeUpdate("alter table t column d2 char (20) ascii");
            this.checkErrorCode(s, -7038, "alter column");
            s.executeUpdate("alter table t column d3 char (20) ascii");
            this.checkErrorCode(s, -7038, "alter column");
            s.executeUpdate("alter table t column d4 char (20) ascii");
            this.checkErrorCode(s, -7038, "alter column");
            s.executeUpdate("alter table r column r1 char (20) ascii");
            this.checkErrorCode(s, -7038, "alter column");
            s.executeUpdate("alter table r column r2 char (20) ascii");
            this.checkErrorCode(s, -7038, "alter column");
            s.executeUpdate("alter table r column r3 char (20) ascii");
            this.checkErrorCode(s, -7038, "alter column");
            s.executeUpdate("alter table r column r4 char (20) ascii");
            this.checkErrorCode(s, -7038, "alter column");
            this.verifyTableDef("R", c, "alter column");
            this.verifyTableDef("T", c, "alter column");
            s.enableExceptions(true);
            s.executeUpdate("drop table r");
            s.executeUpdate("drop table t");
            s.executeUpdate(cr);
            s.executeUpdate(ct);
            this.verifyTableDef("R", c, "create");
            this.verifyTableDef("T", c, "create");
            String c10 = "1111111111";
            String c12 = "555555555555";
            StringBuffer bb = new StringBuffer();
            for (int x = 0; x < 40; ++x) {
                bb.append("2");
            }
            String c40 = bb.toString();
            bb.delete(0, bb.length());
            for (int x = 0; x < 160; ++x) {
                bb.append("3");
            }
            String c160 = bb.toString();
            bb.delete(0, bb.length());
            for (int x = 0; x < 25; ++x) {
                bb.append("4");
            }
            String c25 = bb.toString();
            bb.delete(0, bb.length());
            a = " values ('" + c10 + "', '" + c40 + "', '" + c160 + "', '" + c25 + "', '" + c12 + "')";
            String b = "insert t " + a;
            s.enableExceptions(false);
            s.executeUpdate(b);
            this.checkErrorCode(s, 350, "insert");
            s.enableExceptions(true);
            b = "insert r " + a;
            s.executeUpdate(b);
            this.checkResultCounter(s, 1, "insert");
            b = "insert t " + a;
            s.executeUpdate(b);
            this.checkResultCounter(s, 1, "insert");
            VerificationDataSorted vs = new VerificationDataSorted("'" + c10 + "', '" + c40 + "', '" + c160 + "', '" + c25 + "', '" + c12 + "'");
            s.executeQuery("Select * from t");
            this.checkQuery(s, (VerificationData)vs, "select");
            s.enableExceptions(false);
            s.executeUpdate("alter table r column r1 char (2) ascii");
            this.checkErrorCode(s, -7038, "alter column");
            s.executeUpdate("alter table r column r2 char (2) ascii");
            this.checkErrorCode(s, -7038, "alter column");
            s.executeUpdate("alter table r column r3 char (2) ascii");
            this.checkErrorCode(s, -7038, "alter column");
            s.executeUpdate("alter table r modify r4 char (2) ascii");
            this.checkErrorCode(s, -7038, "alter column");
            s.enableExceptions(true);
            this.verifyTableDef("R", c, "alter column");
            s.execute("Select * from r");
            this.checkResultCounter(s, 1, "Select");
            s.enableExceptions(false);
            s.executeUpdate("alter table t column d1 char (2) ascii");
            this.checkErrorCode(s, -7038, "alter column");
            s.executeUpdate("alter table t column d2 char (2) ascii");
            this.checkErrorCode(s, -7038, "alter column");
            s.executeUpdate("alter table t column d3 char (2) ascii");
            this.checkErrorCode(s, -7038, "alter column");
            s.executeUpdate("alter table t modify d4 char (2) ascii");
            this.checkErrorCode(s, -7038, "alter column");
            s.enableExceptions(true);
            this.verifyTableDef("T", c, "alter column");
            s.executeQuery("Select * from t");
            this.checkResultCounter(s, 1, "Select");
            s.enableExceptions(false);
            s.executeUpdate("update t set d1 = '333333333.'");
            this.checkErrorCode(s, 350, "update");
            s.executeUpdate("update t set d2 = '333333333.'");
            this.checkErrorCode(s, 350, "update");
            s.executeUpdate("update t set d3 = '333333333.'");
            this.checkErrorCode(s, 350, "update");
            s.executeUpdate("update t set d4 = '333333333.'");
            this.checkErrorCode(s, 350, "update");
            s.enableExceptions(true);
            s.executeQuery("Select * from t");
            this.checkQuery(s, (VerificationData)vs, "select");
            s.enableExceptions(false);
            s.executeUpdate("update r set r1 = '333333333.'");
            this.checkErrorCode(s, 350, "update");
            s.executeUpdate("update r set r2 = '333333333.'");
            this.checkErrorCode(s, 350, "update");
            s.executeUpdate("update r set r3 = '333333333.'");
            this.checkErrorCode(s, 350, "update");
            s.executeUpdate("update r set r4 = '333333333.'");
            this.checkErrorCode(s, 350, "update");
            s.enableExceptions(true);
            s.executeQuery("Select * from r");
            this.checkQuery(s, (VerificationData)vs, "select");
            c.commit();
            s.executeUpdate("alter table t drop foreign key R_T");
            s.executeUpdate("update t set d1 = '333333333.'");
            s.executeUpdate("update t set d2 = '333333333.'");
            s.executeUpdate("update t set d3 = '333333333.'");
            s.executeUpdate("update t set d4 = '333333333.'");
            s.executeUpdate("update r set r1 = '333333333.'");
            s.executeUpdate("update r set r2 = '333333333.'");
            s.executeUpdate("update r set r3 = '333333333.'");
            s.executeUpdate("update r set r4 = '333333333.'");
            ResultSet rs1 = s.executeQuery("select * from r");
            VerificationDataSorted vs1 = new VerificationDataSorted(rs1);
            vs1.setColumnNameCheck(false);
            s.executeQuery("select * from t");
            this.checkQuery(s, (VerificationData)vs1, "update");
            s.executeUpdate("alter table t add FOREIGN KEY (D1,D2,D3,D4) REFERENCES R (r1, r2, r3, r4)");
            s.enableExceptions(false);
            s.executeUpdate("update t set d1 = '833333333.'");
            this.checkErrorCode(s, 350, "update");
            s.executeUpdate("update t set d2 = '833333333.'");
            this.checkErrorCode(s, 350, "update");
            s.executeUpdate("update t set d3 = '833333333.'");
            this.checkErrorCode(s, 350, "update");
            s.executeUpdate("update t set d4 = '833333333.'");
            this.checkErrorCode(s, 350, "update");
            s.enableExceptions(true);
            s.executeQuery("Select * from t");
            this.checkQuery(s, (VerificationData)vs1, "select");
            s.enableExceptions(false);
            s.executeUpdate("update r set r1 = '833333333.'");
            this.checkErrorCode(s, 350, "update");
            s.executeUpdate("update r set r2 = '833333333.'");
            this.checkErrorCode(s, 350, "update");
            s.executeUpdate("update r set r3 = '833333333.'");
            this.checkErrorCode(s, 350, "update");
            s.executeUpdate("update r set r4 = '833333333.'");
            this.checkErrorCode(s, 350, "update");
            s.executeUpdate("drop table r");
            s.enableExceptions(false);
            s.executeQuery("select * from r");
            this.checkErrorCode(s, -4004, "drop");
            s.executeUpdate("drop table t");
            s.executeQuery("select * from t");
            this.checkErrorCode(s, -4004, "drop");
            s.executeUpdate("drop table t");
            this.checkErrorCode(s, -4004, "drop");
            s.executeUpdate("create table r");
            this.checkErrorCode(s, -3014, "create");
            s.executeUpdate("create table r (xx char(r))");
            this.checkErrorCode(s, -5009, "create");
            s.executeUpdate("create table r (xx char(4), primary key (yy))");
            this.checkErrorCode(s, -4005, "create");
            s.executeUpdate("create table r (xx char(4), yy binary, primary key (yy, xx))");
            this.checkErrorCode(s, -5015, "create");
            s.executeUpdate("create table r (xx char(4), foreign key(xx))");
            this.checkErrorCode(s, -5015, "create");
            s.executeUpdate("create table r (xx char(4), foreign key(xx) references sdsds)");
            this.checkErrorCode(s, -4004, "create");
            s.executeUpdate("create table (xx char(4))");
            this.checkErrorCode(s, -3009, "create");
            s.enableExceptions(true);
            s.enableExceptions(false);
            s.executeUpdate("create index i1 on r");
            this.checkErrorCode(s, -5016, "create index");
            s.executeUpdate("create index i1 on r (r1 asc, r2 desc)");
            this.checkErrorCode(s, -4004, "create index");
            s.enableExceptions(true);
            a = "CREATE TABLE R ( R1 CHAR (10)  ASCII, R2 CHAR (40) ASCII,";
            a = a + " R3 CHAR (160) ASCII, R4 CHAR (25) ASCII,";
            a = a + " D5 CHAR (12)  ASCII, PRIMARY KEY (R1,R2,R3,R4))";
            s.execute(a);
            this.verifyTableDef("R", c, "create index");
            s.enableExceptions(false);
            s.executeUpdate("create index i1 on r (r1 asc, r1 desc)");
            this.checkErrorCode(s, -6001, "create index");
            s.executeUpdate("create index i1 on r (r6 asc, r1 desc)");
            this.checkErrorCode(s, -4005, "create index");
            s.enableExceptions(true);
            s.executeUpdate("create index i1 on r (r1 asc, r2 desc)");
            this.verifyIndexDef("R", "I1", c, "create index");
            s.enableExceptions(false);
            s.executeUpdate("create index i1 on r (r2 asc, r1 desc)");
            this.checkErrorCode(s, -6008, "create index");
            s.enableExceptions(true);
            s.executeUpdate("drop index i1");
            VerificationDataComplete vdc = new VerificationDataComplete();
            TestPreparedStatement sp = new TestPreparedStatement((TestCase)this, c, "insert r values ('1','2','3',?,?)");
            for (int i = 1; i < 20; ++i) {
                sp.setString(1, Integer.toString(i));
                sp.setString(2, Integer.toString(i));
                sp.executeUpdate();
                vdc.add("'1','2','3','" + Integer.toString(i) + "','" + Integer.toString(i) + "'");
            }
            s.executeQuery("select * from r");
            this.checkQuery(s, (VerificationData)vdc, "insert r");
            s.executeUpdate("create index i1 on r (r2 asc, r1 desc)");
            this.verifyIndexDef("R", "I1", c, "create index");
            s.executeUpdate("drop index i1");
            s.enableExceptions(false);
            s.executeUpdate("create unique index i1 on r (r2 asc, r1 desc)");
            this.checkErrorCode(s, 250, "create index");
            s.executeUpdate("create unique index i1 on r (r3 asc, r1 desc, r2)");
            this.checkErrorCode(s, 250, "create index");
            s.enableExceptions(true);
            s.executeUpdate("create unique index i1 on r (d5 asc, r1 desc)");
            this.verifyIndexDef("R", "I1", c, "create index");
            s.executeUpdate("create unique index i2 on r (r4 asc, r1 desc)");
            this.verifyIndexDef("R", "I2", c, "create index");
            s.enableExceptions(false);
            s.executeUpdate("update r set r4 = '77'");
            this.checkErrorCode(s, 200, "update r");
            s.executeUpdate("update r set d5 = '77'");
            this.checkErrorCode(s, 250, "update r");
            s.enableExceptions(true);
            s.executeUpdate("drop index I1 on R");
            s.executeUpdate("update r set d5 = '77'");
            this.storeResultObject();
        }
        catch (Exception e) {
            this.handleExceptions(e);
        }
        finally {
            try {
                s.close();
                c.close();
            }
            catch (Exception exception) {}
        }
    }
}

