/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.optimizer;

import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestStatementMonitor;
import com.sap.sapdb.testframe.driver.TestStatementMonitorException;
import com.sap.sapdb.testframe.testcase.ExplainDataIteratorPretty;
import com.sap.sapdb.testframe.testcase.ExplainException;
import com.sap.sapdb.testframe.testcase.ExplainObject;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.testcase.TestPreparedStatement;
import com.sap.sapdb.testframe.testcase.TestStatement;
import com.sap.sapdb.testframe.utilities.Table;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;

public class SingleTableV74
extends TestCase {
    private static String sUser = null;
    private static String sTableName = null;
    private static String sPassword = null;
    private static Table sTable;
    private static String sValueK0;
    private static String sValueFx;
    private static String sValueK2;
    private int mMaxNoOfVirtualReads = 0;
    private long mMaxRuntime = Long.MAX_VALUE;
    private int mDiffInteger = 0;
    private int mDiffString = 0;
    private int mTableRows = 0;
    private Connection mMainConnection = null;
    private TestPreparedStatement mMainPreparedStatement = null;
    private TestStatement mHelpStatement = null;
    private TestStatement mFinallyStatement = null;
    private TestStatementMonitor mMainMonitor = null;
    private ExplainObject mMainExplainObject = new ExplainObject();
    private boolean mDropIndexesAfterBlockFinished = true;
    private TestStatementMonitor mAlternativeMonitor = null;
    private static final DecimalFormat K2_FORMAT;
    private String mMethodName = null;
    private static final String DEFAULT_BLOCK_SEQUENCE = "1;2;3;4;5;6;7;8;9;10";

    private void addAlternativeStrategieMessage(TestPreparedStatement pOriginalStmt, int pOriginalReads, TestPreparedStatement pAlternativelStmt, int pAlternativeReads) {
        StringBuffer ls1 = new StringBuffer();
        ls1.append("Alternative strategie needs " + pAlternativeReads + " virtual reads. Optimizer strat. needs " + pOriginalReads + " virtual reads");
        ls1.append("\n Optimizer strategie: \n");
        ExplainDataIteratorPretty it = pOriginalStmt.getExplainObject().iteratorPretty();
        if (it != null) {
            while (it.hasNext()) {
                ls1.append(it.next());
            }
        }
        ls1.append("\n Alternative strategie: \n");
        it = null;
        it = pAlternativelStmt.getExplainObject().iteratorPretty();
        if (it != null) {
            while (it.hasNext()) {
                ls1.append(it.next());
            }
        }
        this.addMessage(this.getStep(), 'W', ls1.toString(), pOriginalStmt.getSqlString());
    }

    public void block_1() throws SQLException, TestCaseException, ExplainException, TestStatementMonitorException {
        String ID = "Block_001";
        String lSql = "select k0 from  " + sTableName;
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Table Scan");
        this.mMainExplainObject.add();
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mTableRows, ID);
        lSql = "select k1 from  " + sTableName;
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Table Scan");
        this.mMainExplainObject.add();
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mTableRows, ID);
        lSql = "select k2 from " + sTableName;
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Table Scan");
        this.mMainExplainObject.add();
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mTableRows, ID);
        lSql = "select k1 from  " + sTableName + " where k1 = " + (this.mDiffInteger - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Table Scan");
        this.mMainExplainObject.add();
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffString, ID);
        lSql = "select k1 from  " + sTableName + " where k0 = " + SingleTableV74.buildK0() + " and k1 = " + (this.mDiffInteger - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Range Condition For Key Column");
        this.mMainExplainObject.addStrategy("(USED KEY COLUMN)", "K0");
        this.mMainExplainObject.addStrategy("(USED KEY COLUMN)", "K1");
        this.mMainExplainObject.add();
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffString, ID);
        lSql = "select k1 from  " + sTableName + "  where k0 = " + SingleTableV74.buildK0() + " or k1 = " + (this.mDiffInteger - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Table Scan");
        this.mMainExplainObject.add();
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mTableRows, ID);
        lSql = "select k2 from  " + sTableName + " where k2 = " + SingleTableV74.buildK2(this.mDiffString - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Table Scan");
        this.mMainExplainObject.add();
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger, ID);
        lSql = "select k2 from  " + sTableName + " where k1 = " + (this.mDiffInteger - 1) + " and k2 = " + SingleTableV74.buildK2(this.mDiffString - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Table Scan");
        this.mMainExplainObject.add();
        this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
        lSql = "select k2 from  " + sTableName + " where k0 = " + SingleTableV74.buildK0() + " and k1 = " + (this.mDiffInteger - 1) + " and k2 = " + SingleTableV74.buildK2(this.mDiffString - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Equal Condition For Key Column");
        this.mMainExplainObject.addStrategy("(USED KEY COLUMN)", "K0");
        this.mMainExplainObject.addStrategy("(USED KEY COLUMN)", "K1");
        this.mMainExplainObject.addStrategy("(USED KEY COLUMN)", "K2");
        this.mMainExplainObject.add();
        this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
        lSql = "select k2 from  " + sTableName + " where k0 = " + SingleTableV74.buildK0() + " or k1 = " + (this.mDiffInteger - 1) + " or k2 = " + SingleTableV74.buildK2(this.mDiffString - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Table Scan");
        this.mMainExplainObject.add();
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mTableRows, ID);
        lSql = "select k2 from  " + sTableName + " where k0 = " + SingleTableV74.buildK0() + " and k1 = " + (this.mDiffInteger - 1) + " or k2 = " + SingleTableV74.buildK2(this.mDiffString - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Table Scan");
        this.mMainExplainObject.add();
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger + this.mDiffString - 1, ID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void block_10() throws SQLException, TestCaseException, ExplainException, TestStatementMonitorException {
        String ID = "Block_010";
        String IDD = "Block_010";
        String lSql = null;
        try {
            sTable.dropIndex("b20", false);
            sTable.createIndex("b20", new String[]{"k1, f2, f3"}, true, this.mHelpStatement);
            sTable.updateStatistics(this.mHelpStatement);
            ID = IDD + "-1";
            lSql = "select * from  " + sTableName + " where k1 = " + (this.mDiffInteger - 4) + " or " + " k1 = " + (this.mDiffInteger - 3);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("Different strategies for or-terms");
            this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEX", "B20");
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "K1");
            this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEX", "B20");
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "K1");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 2 * this.mDiffString, ID);
            lSql = "select * from  " + sTableName + " where k1 = 0" + " or " + " k1 = " + (this.mDiffInteger - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("Different strategies for or-terms");
            this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEX", "B20");
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "K1");
            this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEX", "B20");
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "K1");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 2 * this.mDiffString, ID);
            lSql = "select * from  " + sTableName + " where k1 = " + (this.mDiffInteger - 4) + " or " + " f2 = " + SingleTableV74.buildK2(this.mDiffString - 3);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("Table Scan");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger + this.mDiffString - 1, ID);
            lSql = "select * from  " + sTableName + " where k1 = " + (this.mDiffInteger - 4) + " and " + " f2 = " + SingleTableV74.buildK2(this.mDiffString - 3);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEX", "B20", false, false, false, false);
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "K1");
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "F2");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
            lSql = "select * from  " + sTableName + " where k1 = " + (this.mDiffInteger - 4) + " or k1 = " + (this.mDiffInteger - 1) + " or " + " f2 = " + SingleTableV74.buildK2(this.mDiffString - 3);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("Table Scan");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger + 2 * this.mDiffString - 2, ID);
            lSql = "select * from  " + sTableName + " where ( k1 = " + (this.mDiffInteger - 4) + " or k1 = " + (this.mDiffInteger - 1) + ") or " + " f2 = " + SingleTableV74.buildK2(this.mDiffString - 3);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("Table Scan");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger + 2 * this.mDiffString - 2, ID);
            lSql = "select * from  " + sTableName + " where k1 = " + (this.mDiffInteger - 4) + " or k1 = " + (this.mDiffInteger - 1) + " or " + " f2 = " + SingleTableV74.buildK2(this.mDiffString - 3) + " or " + " f2 = " + SingleTableV74.buildK2(this.mDiffString - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("Table Scan");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 2 * this.mDiffInteger + 2 * this.mDiffString - 4, ID);
            ID = IDD + "-2";
            lSql = "select * from  " + sTableName + " where k1 = " + (this.mDiffInteger - 4) + " or k1 = " + (this.mDiffInteger - 1) + " and " + " f2 = " + SingleTableV74.buildK2(this.mDiffString - 3) + " or " + " f2 = " + SingleTableV74.buildK2(this.mDiffString - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("Table Scan");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger + this.mDiffString, ID);
            lSql = "select * from  " + sTableName + " where (k1 = " + (this.mDiffInteger - 4) + " or k1 = " + (this.mDiffInteger - 1) + ") and (" + " f2 = " + SingleTableV74.buildK2(this.mDiffString - 3) + " or " + " f2 = " + SingleTableV74.buildK2(this.mDiffString - 1) + ")";
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("Different strategies for or-terms");
            this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEX", "B20");
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "K1");
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "F2");
            this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEX", "B20");
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "K1");
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "F2");
            this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEX", "B20");
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "K1");
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "F2");
            this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEX", "B20");
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "K1");
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "F2");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 4, ID);
            lSql = "select * from  " + sTableName + " where k1 = " + (this.mDiffInteger - 4) + " and " + " f2 = " + SingleTableV74.buildK2(this.mDiffString - 4) + " or " + " f2 = " + SingleTableV74.buildK2(this.mDiffString - 1) + " and k1 = " + (this.mDiffInteger - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("Different strategies for or-terms");
            this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEX", "B20");
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "K1");
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "F2");
            this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEX", "B20");
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "K1");
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "F2");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 2, ID);
            lSql = "select * from  " + sTableName + " where k1 = " + (this.mDiffInteger - 4) + " and (" + " f2 = " + SingleTableV74.buildK2(this.mDiffString - 4) + " or " + " f2 = " + SingleTableV74.buildK2(this.mDiffString - 1) + ") and k1 = " + (this.mDiffInteger - 4);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEX", "B20");
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "K1");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 2, ID);
            lSql = "select * from  " + sTableName + " where k1 = " + (this.mDiffInteger - 4) + " and (" + " f2 = " + SingleTableV74.buildK2(this.mDiffString - 4) + " or " + " f2 = " + SingleTableV74.buildK2(this.mDiffString - 1) + ") and k1 >= " + (this.mDiffInteger - 4);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEX", "B20");
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "K1");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 2, ID);
        }
        finally {
            if (this.mDropIndexesAfterBlockFinished) {
                sTable.dropIndex("b20", false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void block_2() throws SQLException, TestCaseException, ExplainException, TestStatementMonitorException {
        String IDD = "Block_002";
        String ID = "Block_002";
        String lSql = null;
        try {
            int x;
            for (x = 0; x < 3; ++x) {
                ID = IDD + "-1" + "-" + x;
                if (x == 0) {
                    sTable.dropIndex("b20", false);
                    sTable.createIndex("b20", new String[]{"k1"}, false, this.mHelpStatement);
                    this.addMessage(ID, 'I', "Single Index on K1");
                } else if (x == 1) {
                    sTable.dropIndex("b21", false);
                    sTable.createIndex("b21", new String[]{"k1", "k2", "f4"}, true, this.mHelpStatement);
                    this.addMessage(ID, 'I', "Single Index on K1; Multiple Index on K1, K2");
                } else {
                    sTable.dropIndex("b21");
                    this.addMessage(ID, 'I', "Single Index on K1");
                }
                sTable.updateStatistics(this.mHelpStatement);
                lSql = "select k1 from " + sTableName;
                this.mMainExplainObject.clear();
                this.mMainExplainObject.addTable(sTableName);
                this.mMainExplainObject.addStrategy("INDEX SCAN", "B20", true, false, false, false);
                this.mMainExplainObject.add();
                this.executePreparedStep(lSql, this.mMainExplainObject, this.mTableRows, ID);
                lSql = "select k1 from  " + sTableName + " where k1 = " + (this.mDiffInteger - 1);
                this.mMainExplainObject.clear();
                this.mMainExplainObject.addTable(sTableName);
                this.mMainExplainObject.addStrategy("EQUAL CONDITION FOR INDEX", "B20", true, false, false, false);
                this.mMainExplainObject.add();
                this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffString, ID);
                lSql = "select k1 from  " + sTableName + " where k1 >= " + (this.mDiffInteger - 2);
                this.mMainExplainObject.clear();
                this.mMainExplainObject.addTable(sTableName);
                this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEX", "B20", true, false, false, false);
                this.mMainExplainObject.add();
                this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffString * 2, ID);
                lSql = "select k1 from  " + sTableName + " where k1 >= " + (this.mDiffInteger - 2) + " and k1 <= " + (this.mDiffInteger - 1);
                this.mMainExplainObject.clear();
                this.mMainExplainObject.addTable(sTableName);
                this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEX", "B20", true, false, false, false);
                this.mMainExplainObject.add();
                this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffString * 2, ID);
                lSql = "select k1 from  " + sTableName + " where k1 between " + (this.mDiffInteger - 2) + " and " + (this.mDiffInteger - 1);
                this.mMainExplainObject.clear();
                this.mMainExplainObject.addTable(sTableName);
                this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEX", "B20", true, false, false, false);
                this.mMainExplainObject.add();
                this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffString * 2, ID);
            }
            sTable.dropIndex("B20", false);
            sTable.createIndex("B20", new String[]{"k2", "f0", "f1", "f2", "f3", "f4", "f5", "f6"}, false, this.mHelpStatement);
            for (x = 0; x < 3; ++x) {
                ID = IDD + "-2" + "-" + x;
                if (x == 0) {
                    sTable.dropIndex("c20", false);
                    sTable.createIndex("c20", new String[]{"k2"}, false, this.mHelpStatement);
                    this.addMessage(ID, 'I', "Single Index on K2");
                } else if (x == 1) {
                    sTable.dropIndex("c21", false);
                    sTable.createIndex("c21", new String[]{"k2", "k1", "f4"}, true, this.mHelpStatement);
                    this.addMessage(ID, 'I', "Single Index on K2; Multiple Index on K2, K1");
                } else {
                    sTable.dropIndex("c21");
                    this.addMessage(ID, 'I', "Single Index on K2");
                }
                sTable.updateStatistics(this.mHelpStatement);
                lSql = "select k2 from " + sTableName;
                this.mMainExplainObject.clear();
                this.mMainExplainObject.addTable(sTableName);
                this.mMainExplainObject.addStrategy("INDEX SCAN", "C20", true, false, false, false);
                this.mMainExplainObject.add();
                this.executePreparedStep(lSql, this.mMainExplainObject, this.mTableRows, ID);
                lSql = "select k2 from  " + sTableName + " where k2 = " + SingleTableV74.buildK2(this.mDiffString - 1);
                this.mMainExplainObject.clear();
                this.mMainExplainObject.addTable(sTableName);
                this.mMainExplainObject.addStrategy("EQUAL CONDITION FOR INDEX", "C20", true, false, false, false);
                this.mMainExplainObject.add();
                this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger, ID);
                lSql = "select k2 from  " + sTableName + " where k2 >= " + SingleTableV74.buildK2(this.mDiffString - 2);
                this.mMainExplainObject.clear();
                this.mMainExplainObject.addTable(sTableName);
                this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEX", "C20", true, false, false, false);
                this.mMainExplainObject.add();
                this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger * 2, ID);
                lSql = "select k2 from  " + sTableName + " where k2 >= " + SingleTableV74.buildK2(this.mDiffString - 2) + " and k2 <= " + SingleTableV74.buildK2(this.mDiffString - 1);
                this.mMainExplainObject.clear();
                this.mMainExplainObject.addTable(sTableName);
                this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEX", "C20", true, false, false, false);
                this.mMainExplainObject.add();
                this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger * 2, ID);
                lSql = "select k2 from  " + sTableName + " where k2 between " + SingleTableV74.buildK2(this.mDiffString - 2) + " and " + SingleTableV74.buildK2(this.mDiffString - 1);
                this.mMainExplainObject.clear();
                this.mMainExplainObject.addTable(sTableName);
                this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEX", "C20", true, false, false, false);
                this.mMainExplainObject.add();
                this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger * 2, ID);
            }
        }
        finally {
            if (this.mDropIndexesAfterBlockFinished) {
                sTable.dropIndex("b20", false);
                sTable.dropIndex("b21", false);
                sTable.dropIndex("c20", false);
                sTable.dropIndex("c21", false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void block_3() throws SQLException, TestCaseException, ExplainException, TestStatementMonitorException {
        String ID = "Block_003";
        String IDD = "Block_003";
        String lStrat1 = null;
        String lStrat2 = null;
        String lSql = null;
        try {
            int x;
            for (x = 0; x < 2; ++x) {
                ID = IDD + "-1" + "-" + x;
                if (x == 0) {
                    sTable.dropIndex("b20", false);
                    sTable.createIndex("b20", new String[]{"k1"}, false, this.mHelpStatement);
                    lStrat1 = "EQUAL CONDITION FOR INDEX";
                    lStrat2 = "RANGE CONDITION FOR INDEX";
                    this.addMessage(ID, 'I', "Single Index on K1");
                } else if (x == 1) {
                    sTable.dropIndex("b21", false);
                    sTable.createIndex("b21", new String[]{"k2", "k1", "f4"}, true, this.mHelpStatement);
                    lStrat1 = "EQUAL CONDITION FOR INDEX";
                    lStrat2 = "RANGE CONDITION FOR INDEX";
                    this.addMessage(ID, 'I', "Single Index on K1; Multiple Index on K2, K1");
                }
                sTable.updateStatistics(this.mHelpStatement);
                lSql = "select k2 from  " + sTableName + " where k1 = " + (this.mDiffInteger - 1);
                this.mMainExplainObject.clear();
                this.mMainExplainObject.addTable(sTableName);
                this.mMainExplainObject.addStrategy(lStrat1, "B20", true, false, false, false);
                this.mMainExplainObject.add();
                this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffString, ID);
                lSql = "select k2 from  " + sTableName + " where k1 >= " + (this.mDiffInteger - 2);
                this.mMainExplainObject.clear();
                this.mMainExplainObject.addTable(sTableName);
                this.mMainExplainObject.addStrategy(lStrat2, "B20", true, false, false, false);
                this.mMainExplainObject.add();
                this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffString * 2, ID);
                lSql = "select k2 from  " + sTableName + " where k1 >= " + (this.mDiffInteger - 2) + " and k1 <= " + (this.mDiffInteger - 1);
                this.mMainExplainObject.clear();
                this.mMainExplainObject.addTable(sTableName);
                this.mMainExplainObject.addStrategy(lStrat2, "B20", true, false, false, false);
                this.mMainExplainObject.add();
                this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffString * 2, ID);
                lSql = "select k2 from  " + sTableName + " where k1 between " + (this.mDiffInteger - 2) + " and " + (this.mDiffInteger - 1);
                this.mMainExplainObject.clear();
                this.mMainExplainObject.addTable(sTableName);
                this.mMainExplainObject.addStrategy(lStrat2, "B20", true, false, false, false);
                this.mMainExplainObject.add();
                this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffString * 2, ID);
            }
            sTable.dropIndex("b22", false);
            sTable.createIndex("b22", new String[]{"k1", "f2"}, true, this.mHelpStatement);
            this.addMessage(ID, 'I', "Single Index on K1; Multiple Index on K1, F2 and on K2, K1");
            sTable.updateStatistics(this.mHelpStatement);
            lSql = "select f2 from  " + sTableName + " where k1 = " + (this.mDiffInteger - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEX", "B22", true, false, false, false);
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "K1");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffString, ID);
            lSql = "select f2 from  " + sTableName + " where k1 >= " + (this.mDiffInteger - 2);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEX", "B22", true, false, false, false);
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "K1");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffString * 2, ID);
            lSql = "select f2 from  " + sTableName + " where k1 >= " + (this.mDiffInteger - 2) + " and k1 <= " + (this.mDiffInteger - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEX", "B22", true, false, false, false);
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "K1");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffString * 2, ID);
            lSql = "select f2 from  " + sTableName + " where k1 between " + (this.mDiffInteger - 2) + " and " + (this.mDiffInteger - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEX", "B22", true, false, false, false);
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "K1");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffString * 2, ID);
            sTable.dropIndex("b20", false);
            sTable.dropIndex("b21", false);
            sTable.dropIndex("b22", false);
            for (x = 0; x < 2; ++x) {
                ID = IDD + "-2" + "-" + x;
                if (x == 0) {
                    sTable.dropIndex("c20", false);
                    sTable.createIndex("c20", new String[]{"k2"}, false, this.mHelpStatement);
                    lStrat1 = "EQUAL CONDITION FOR INDEX";
                    lStrat2 = "RANGE CONDITION FOR INDEX";
                    this.addMessage(ID, 'I', "Single Index on K2");
                } else if (x == 1) {
                    sTable.dropIndex("c21", false);
                    sTable.createIndex("c21", new String[]{"k1", "k2", "f4"}, true, this.mHelpStatement);
                    lStrat1 = "EQUAL CONDITION FOR INDEX";
                    lStrat2 = "RANGE CONDITION FOR INDEX";
                    this.addMessage(ID, 'I', "Single Index on K2; Multiple Index on K2, K1");
                }
                sTable.updateStatistics(this.mHelpStatement);
                lSql = "select k1 from  " + sTableName + " where k2 = " + SingleTableV74.buildK2(this.mDiffString - 1);
                this.mMainExplainObject.clear();
                this.mMainExplainObject.addTable(sTableName);
                this.mMainExplainObject.addStrategy(lStrat1, "C20", true, false, false, false);
                this.mMainExplainObject.add();
                this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger, ID);
                lSql = "select k1 from  " + sTableName + " where k2 >= " + SingleTableV74.buildK2(this.mDiffString - 2);
                this.mMainExplainObject.clear();
                this.mMainExplainObject.addTable(sTableName);
                this.mMainExplainObject.addStrategy(lStrat2, "C20", true, false, false, false);
                this.mMainExplainObject.add();
                this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger * 2, ID);
                lSql = "select k1 from  " + sTableName + " where k2 >= " + SingleTableV74.buildK2(this.mDiffString - 2) + " and k2 <= " + SingleTableV74.buildK2(this.mDiffString - 1);
                this.mMainExplainObject.clear();
                this.mMainExplainObject.addTable(sTableName);
                this.mMainExplainObject.addStrategy(lStrat2, "C20", true, false, false, false);
                this.mMainExplainObject.add();
                this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger * 2, ID);
                lSql = "select k1 from  " + sTableName + " where k2 between " + SingleTableV74.buildK2(this.mDiffString - 2) + " and " + SingleTableV74.buildK2(this.mDiffString - 1);
                this.mMainExplainObject.clear();
                this.mMainExplainObject.addTable(sTableName);
                this.mMainExplainObject.addStrategy(lStrat2, "C20", true, false, false, false);
                this.mMainExplainObject.add();
                this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger * 2, ID);
            }
            sTable.dropIndex("c22", false);
            sTable.createIndex("c22", new String[]{"k2", "f1"}, true, this.mHelpStatement);
            this.addMessage(ID, 'I', "Single Index on K2; Multiple Index on K2, K1 and on K1, K2");
            sTable.updateStatistics(this.mHelpStatement);
            lSql = "select f1 from  " + sTableName + " where k2 = " + SingleTableV74.buildK2(this.mDiffString - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEX", "C22", true, false, false, false);
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "K2");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger, ID);
            lSql = "select f1 from  " + sTableName + " where k2 >= " + SingleTableV74.buildK2(this.mDiffString - 2);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEX", "C22", true, false, false, false);
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "K2");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger * 2, ID);
            lSql = "select f1 from  " + sTableName + " where k2 >= " + SingleTableV74.buildK2(this.mDiffString - 2) + " and k2 <= " + SingleTableV74.buildK2(this.mDiffString - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEX", "C22", true, false, false, false);
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "K2");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger * 2, ID);
            lSql = "select f1 from  " + sTableName + " where k2 between " + SingleTableV74.buildK2(this.mDiffString - 2) + " and " + SingleTableV74.buildK2(this.mDiffString - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEX", "C22", true, false, false, false);
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "K2");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger * 2, ID);
        }
        finally {
            if (this.mDropIndexesAfterBlockFinished) {
                sTable.dropIndex("b20", false);
                sTable.dropIndex("b21", false);
                sTable.dropIndex("b22", false);
                sTable.dropIndex("c20", false);
                sTable.dropIndex("c21", false);
                sTable.dropIndex("c22", false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void block_4() throws SQLException, TestCaseException, ExplainException, TestStatementMonitorException {
        String ID = "Block_004";
        String IDD = "Block_004";
        String lSql = null;
        try {
            sTable.dropIndex("b20", false);
            sTable.createIndex("b20", new String[]{"k1 desc"}, false, this.mHelpStatement);
            sTable.updateStatistics(this.mHelpStatement);
            ID = IDD + "-1";
            lSql = "select k1 from " + sTableName;
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("INDEX SCAN", "B20", true, false, false, false);
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mTableRows, ID);
            lSql = "select k1 from  " + sTableName + " where k1 = " + (this.mDiffInteger - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("EQUAL CONDITION FOR INDEX", "B20", true, false, false, false);
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffString, ID);
            lSql = "select k1 from  " + sTableName + " where k1 >= " + (this.mDiffInteger - 2);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEX", "B20", true, false, false, false);
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffString * 2, ID);
            lSql = "select k1 from  " + sTableName + " where k1 >= " + (this.mDiffInteger - 2) + " and k1 <= " + (this.mDiffInteger - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEX", "B20", true, false, false, false);
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffString * 2, ID);
            lSql = "select k1 from  " + sTableName + " where k1 between " + (this.mDiffInteger - 2) + " and " + (this.mDiffInteger - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEX", "B20", true, false, false, false);
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffString * 2, ID);
            ID = IDD + "-2";
            lSql = "select k1 from  " + sTableName + " order by k1 asc";
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("INDEX SCAN", "B20", true, false, false, false);
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mTableRows, ID);
            lSql = "select k1 from  " + sTableName + " where k1 = " + (this.mDiffInteger - 1) + " order by k1 asc";
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("EQUAL CONDITION FOR INDEX", "B20", true, false, false, false);
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffString, ID);
            lSql = "select k1 from  " + sTableName + " where k1 >= " + (this.mDiffInteger - 2) + " order by k1 asc";
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEX", "B20", true, false, false, false);
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffString * 2, ID);
            lSql = "select k1 from  " + sTableName + " where k1 >= " + (this.mDiffInteger - 2) + " and k1 <= " + (this.mDiffInteger - 1) + " order by k1 asc";
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEX", "B20", true, false, false, false);
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffString * 2, ID);
            lSql = "select k1 from  " + sTableName + " where k1 between " + (this.mDiffInteger - 2) + " and " + (this.mDiffInteger - 1) + " order by k1 asc";
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEX", "B20", true, false, false, false);
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffString * 2, ID);
            ID = IDD + "-3";
            lSql = "select k1 from  " + sTableName + " order by k1 desc";
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("INDEX SCAN", "B20", true, false, false, false);
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mTableRows, ID);
            lSql = "select k1 from  " + sTableName + " where k1 = " + (this.mDiffInteger - 1) + " order by k1 desc";
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("EQUAL CONDITION FOR INDEX", "B20", true, false, false, false);
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffString, ID);
            lSql = "select k1 from  " + sTableName + " where k1 >= " + (this.mDiffInteger - 2) + " order by k1 desc";
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEX", "B20", true, false, false, false);
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffString * 2, ID);
            lSql = "select k1 from  " + sTableName + " where k1 >= " + (this.mDiffInteger - 2) + " and k1 <= " + (this.mDiffInteger - 1) + " order by k1 desc";
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEX", "B20", true, false, false, false);
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffString * 2, ID);
            lSql = "select k1 from  " + sTableName + " where k1 between " + (this.mDiffInteger - 2) + " and " + (this.mDiffInteger - 1) + " order by k1 desc";
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEX", "B20", true, false, false, false);
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffString * 2, ID);
            sTable.dropIndex("b21", false);
            sTable.createIndex("b21", new String[]{"k1 asc, k2 desc"}, false, this.mHelpStatement);
            sTable.updateStatistics(this.mHelpStatement);
            ID = IDD + "-4";
            lSql = "select k1 from  " + sTableName + " order by k1 asc";
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("INDEX SCAN", "B21", true, false, false, false);
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mTableRows, ID);
            lSql = "select k1 from  " + sTableName + " where k1 = " + (this.mDiffInteger - 1) + " order by k1 asc";
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEX", "B21", true, false, false, false);
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "K1");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffString, ID);
            lSql = "select k1 from  " + sTableName + " where k1 = " + (this.mDiffInteger - 1) + " and k2 = " + SingleTableV74.buildK2(this.mDiffString - 1) + " order by k1 asc";
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("EQUAL CONDITION FOR INDEX", "B21", true, false, false, false);
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "K1");
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "K2");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
            lSql = "select k1 from  " + sTableName + " where k1 >= " + (this.mDiffInteger - 2) + " order by k1 asc";
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEX", "B21", true, false, false, false);
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "K1");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffString * 2, ID);
            lSql = "select k1 from  " + sTableName + " where k1 >= " + (this.mDiffInteger - 2) + " and k1 <= " + (this.mDiffInteger - 1) + " order by k1 asc";
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEX", "B21", true, false, false, false);
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "K1");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffString * 2, ID);
            lSql = "select k1 from  " + sTableName + " where k1 between " + (this.mDiffInteger - 2) + " and " + (this.mDiffInteger - 1) + " order by k1 asc";
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEX", "B21", true, false, false, false);
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "K1");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffString * 2, ID);
            sTable.dropIndex("b21", false);
            sTable.createIndex("b21", new String[]{"k1 desc, k2 desc"}, false, this.mHelpStatement);
            sTable.updateStatistics(this.mHelpStatement);
            ID = IDD + "-5";
            lSql = "select k1 from  " + sTableName + " order by k1 desc";
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("INDEX SCAN", "B20", true, false, false, false);
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mTableRows, ID);
            lSql = "select k1 from  " + sTableName + " where k1 = " + (this.mDiffInteger - 1) + " order by k1 desc";
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("EQUAL CONDITION FOR INDEX", "B20", true, false, false, false);
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffString, ID);
            lSql = "select k1 from  " + sTableName + " where k1 >= " + (this.mDiffInteger - 2) + " order by k1 desc";
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEX", "B20", true, false, false, false);
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffString * 2, ID);
            lSql = "select k1 from  " + sTableName + " where k1 >= " + (this.mDiffInteger - 2) + " and k1 <= " + (this.mDiffInteger - 1) + " order by k1 desc";
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEX", "B20", true, false, false, false);
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffString * 2, ID);
            lSql = "select k1 from  " + sTableName + " where k1 between " + (this.mDiffInteger - 2) + " and " + (this.mDiffInteger - 1) + " order by k1 desc";
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEX", "B20", true, false, false, false);
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffString * 2, ID);
            sTable.dropIndex("b21", false);
        }
        finally {
            if (this.mDropIndexesAfterBlockFinished) {
                sTable.dropIndex("b20", false);
                sTable.dropIndex("b21", false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void block_5() throws SQLException, TestCaseException, ExplainException, TestStatementMonitorException {
        String ID = "Block_005";
        String IDD = "Block_005";
        String lSql = null;
        try {
            sTable.dropIndex("b20", false);
            sTable.createIndex("b20", new String[]{"k1 desc, k2 desc"}, true, this.mHelpStatement);
            sTable.updateStatistics(this.mHelpStatement);
            ID = IDD + "-1";
            lSql = "select k1 from " + sTableName;
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("INDEX SCAN", "B20", true, false, false, false);
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mTableRows, ID);
            lSql = "select k1 from  " + sTableName + " order by k1 desc";
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("INDEX SCAN", "B20", true, false, false, false);
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mTableRows, ID);
            lSql = "select k1, k2 from " + sTableName;
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("INDEX SCAN", "B20", true, false, false, false);
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mTableRows, ID);
            lSql = "select k1, k2 from  " + sTableName + " order by k1 desc";
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("INDEX SCAN", "B20", true, false, false, false);
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mTableRows, ID);
            lSql = "select k1, k2 from  " + sTableName + " order by k1 desc, k2 desc";
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("INDEX SCAN", "B20", true, false, false, false);
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mTableRows, ID);
            lSql = "select k2, k1 from " + sTableName;
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("INDEX SCAN", "B20", true, false, false, false);
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mTableRows, ID);
            lSql = "select k2, k1 from  " + sTableName + " order by k1 desc";
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("INDEX SCAN", "B20", true, false, false, false);
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mTableRows, ID);
            lSql = "select k2, k1 from  " + sTableName + " order by k1 desc, k2 desc";
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("INDEX SCAN", "B20", true, false, false, false);
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mTableRows, ID);
            lSql = "select k1, k2 from  " + sTableName + " order by k2 desc, k1 desc";
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("INDEX SCAN", "B20", true, false, false, false);
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mTableRows, ID);
            lSql = "select k1, k2 from  " + sTableName + " order by k1 desc, k2 asc";
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("INDEX SCAN", "B20", true, false, false, false);
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mTableRows, ID);
            lSql = "select k1, k2, f1 from  " + sTableName + " order by k1 desc";
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("INDEX SCAN", "B20", false, false, false, false);
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mTableRows, ID);
            sTable.dropIndex("b21", false);
            sTable.createIndex("b21", new String[]{"k2 asc, k1 asc"}, true, this.mHelpStatement);
            sTable.updateStatistics(this.mHelpStatement);
            ID = IDD + "-2";
            lSql = "select k2 from  " + sTableName + " order by k2 asc";
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("INDEX SCAN", "B21", true, false, false, false);
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mTableRows, ID);
            lSql = "select k2, k1 from  " + sTableName + " order by k2 asc";
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("INDEX SCAN", "B21", true, false, false, false);
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mTableRows, ID);
            lSql = "select k2, k1 from  " + sTableName + " order by k2 asc, k1 asc";
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("INDEX SCAN", "B21", true, false, false, false);
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mTableRows, ID);
            lSql = "select k2, k1, f2, f1 from  " + sTableName + " order by k2 asc, k1 asc";
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("INDEX SCAN", "B21", false, false, false, false);
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mTableRows, ID);
        }
        finally {
            if (this.mDropIndexesAfterBlockFinished) {
                sTable.dropIndex("b20", false);
                sTable.dropIndex("b21", false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void block_6() throws SQLException, TestCaseException, ExplainException, TestStatementMonitorException {
        String ID = "Block_006";
        String IDD = "Block_006";
        String lSql = null;
        try {
            sTable.dropIndex("b20", false);
            sTable.dropIndex("b21", false);
            sTable.dropIndex("b22", false);
            sTable.createIndex("b20", new String[]{"k2 asc, k1 desc"}, true, this.mHelpStatement);
            sTable.createIndex("b21", new String[]{"k1 desc"}, false, this.mHelpStatement);
            sTable.createIndex("b22", new String[]{"k2 asc, k1 desc, f1, f2"}, true, this.mHelpStatement);
            sTable.updateStatistics(this.mHelpStatement);
            ID = IDD + "-1";
            lSql = "select k1, k2 from  " + sTableName + " where k1 = " + (this.mDiffInteger - 2) + " and k2 = " + SingleTableV74.buildK2(this.mDiffString - 2);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("EQUAL CONDITION FOR INDEX", "B20", true, false, false, false);
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "K2");
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "K1");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
            lSql = "select k1, k2 from  " + sTableName + " where k1 = " + (this.mDiffInteger - 2) + " and k2 = " + SingleTableV74.buildK2(this.mDiffString + 2);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("EQUAL CONDITION FOR INDEX", "B20", true, false, false, false);
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "K2");
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "K1");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 0, ID);
            lSql = "select k1, k2 from  " + sTableName + " where k1 >= " + (this.mDiffInteger - 5) + " and k1 < " + (this.mDiffInteger - 3) + " and k2 = " + SingleTableV74.buildK2(this.mDiffString - 2);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEX", "B20", true, false, false, false);
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "K2");
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "K1");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 2, ID);
            lSql = "select k1, k2 from  " + sTableName + " where k2 >= " + SingleTableV74.buildK2(this.mDiffString - 5) + " and k2 < " + SingleTableV74.buildK2(this.mDiffString - 3);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEX", "B20", true, false, false, false);
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "K2");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger * 2, ID);
            lSql = "select k1, k2, f1 from  " + sTableName + " where k1 = " + (this.mDiffInteger - 2) + " and k2 = " + SingleTableV74.buildK2(this.mDiffString - 2);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEX", "B22", true, false, false, false);
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "K2");
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "K1");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
            lSql = "select k1, k2, f1 from  " + sTableName + " where k1 = " + (this.mDiffInteger - 2) + " and k2 = " + SingleTableV74.buildK2(this.mDiffString + 2);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEX", "B22", true, false, false, false);
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "K2");
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "K1");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 0, ID);
            lSql = "select k1, k2, f1 from  " + sTableName + " where k1 >= " + (this.mDiffInteger - 5) + " and k1 < " + (this.mDiffInteger - 3) + " and k2 = " + SingleTableV74.buildK2(this.mDiffString - 2);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEX", "B22", true, false, false, false);
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "K2");
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "K1");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 2, ID);
            lSql = "select k1, k2, f1 from  " + sTableName + " where k2 >= " + SingleTableV74.buildK2(this.mDiffString - 5) + " and k2 < " + SingleTableV74.buildK2(this.mDiffString - 3);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEX", "B22", true, false, false, false);
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "K2");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger * 2, ID);
        }
        finally {
            if (this.mDropIndexesAfterBlockFinished) {
                sTable.dropIndex("b20", false);
                sTable.dropIndex("b21", false);
                sTable.dropIndex("b22", false);
                this.mFinallyStatement.executeUpdate("commit");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void block_7() throws SQLException, TestCaseException, ExplainException, TestStatementMonitorException {
        String ID = "Block_007";
        String IDD = "Block_007";
        String lSql = null;
        try {
            sTable.dropIndex("B20", false);
            sTable.dropIndex("B21", false);
            sTable.createIndex("B20", new String[]{"k1"}, false, this.mHelpStatement);
            sTable.createIndex("B21", new String[]{"k1, f1, f3"}, true, this.mHelpStatement);
            sTable.updateStatistics(this.mHelpStatement);
            ID = IDD + "-1";
            lSql = "select k1, f1 from  " + sTableName + " where k1 between " + (this.mDiffInteger - 4) + " and " + (this.mDiffInteger - 3) + " and f1 between " + (this.mDiffInteger - 4) + " and " + (this.mDiffInteger - 3);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEX", "B21", true, false, false, false);
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "K1");
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "F1");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 2 * this.mDiffString, ID);
            lSql = "select  k1, f1 from  " + sTableName + " where f1 between " + (this.mDiffInteger - 4) + " and " + (this.mDiffInteger - 3) + " and k1 between " + (this.mDiffInteger - 4) + " and " + (this.mDiffInteger - 3);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEX", "B21", true, false, false, false);
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "K1");
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "F1");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 2 * this.mDiffString, ID);
            lSql = "select k1, f1 from  " + sTableName + " where k1 between " + (this.mDiffInteger - 4) + " and " + (this.mDiffInteger - 3) + " and not (k1 is null) or not (f1 is null)";
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("INDEX SCAN", "B21", true, false, false, false);
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffString * this.mDiffInteger, ID);
            lSql = "select k1, f1 from  " + sTableName + " where ( k1 between " + (this.mDiffInteger - 4) + " and " + (this.mDiffInteger - 3) + " ) and (not (k1 is null) or not (f1 is null))";
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEX", "B21", true, false, false, false);
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "K1");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 2 * this.mDiffString, ID);
            ID = IDD + "-2";
            lSql = "select k1, f1 from  " + sTableName + " where f3 = " + (this.mTableRows - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("INDEX SCAN", "B21", true, false, false, false);
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
            lSql = "select k1, f1, f3 from  " + sTableName + " where f3 = " + (this.mTableRows - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("INDEX SCAN", "B21", true, false, false, false);
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
            lSql = "select k1, f1, f3 from  " + sTableName + " where f3 >= " + (this.mTableRows - 5);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("INDEX SCAN", "B21", true, false, false, false);
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 5, ID);
            lSql = "select k1, f1, f3 from  " + sTableName + " where f3 >= " + (this.mTableRows - 5) + " and f3 >= " + (this.mTableRows - 2);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("INDEX SCAN", "B21", true, false, false, false);
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 2, ID);
            lSql = "select k1, f1, f3 from  " + sTableName + " where f3 >= " + (this.mTableRows - 5) + " and f3 <= " + (this.mTableRows - 2);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("INDEX SCAN", "B21", true, false, false, false);
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 4, ID);
            lSql = "select k1, f1, f3 from  " + sTableName + " where f3 >= " + (this.mTableRows - 5) + " and f3 <= " + (this.mTableRows - 7);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("INDEX SCAN", "B21", true, false, false, false);
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 0, ID);
            lSql = "select k1, f1, f3 from  " + sTableName + " where f3 in ( 1,2,3,4,5)";
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("INDEX SCAN", "B21", true, false, false, false);
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 5, ID);
            ID = IDD + "-3";
            lSql = "select f2, f1 from  " + sTableName + " where f3 = " + (this.mTableRows - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("Table Scan");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
            lSql = "select f2, f1, f3 from  " + sTableName + " where f3 = " + (this.mTableRows - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("Table Scan");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
            lSql = "select f2, f1, f3 from  " + sTableName + " where f3 >= " + (this.mTableRows - 5);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("Table Scan");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 5, ID);
            lSql = "select f2, f1, f3 from  " + sTableName + " where f3 >= " + (this.mTableRows - 5) + " and f3 >= " + (this.mTableRows - 2);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("Table Scan");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 2, ID);
            lSql = "select f2, f1, f3 from  " + sTableName + " where f3 >= " + (this.mTableRows - 5) + " and f3 <= " + (this.mTableRows - 2);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("Table Scan");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 4, ID);
            lSql = "select f2, f1, f3 from  " + sTableName + " where f3 >= " + (this.mTableRows - 5) + " and f3 <= " + (this.mTableRows - 7);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("Table Scan");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 0, ID);
            lSql = "select f2, f1, f3 from  " + sTableName + " where f3 in ( 1,2,3,4,5)";
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("Table Scan");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 5, ID);
            ID = IDD + "-4";
            lSql = "select k2, f1 from  " + sTableName + " where f3 = " + (this.mTableRows - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("INDEX SCAN", "B21", true, false, false, false);
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
            lSql = "select k2, f1, f3 from  " + sTableName + " where f3 = " + (this.mTableRows - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("INDEX SCAN", "B21", true, false, false, false);
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
            lSql = "select k2, f1, f3 from  " + sTableName + " where f3 >= " + (this.mTableRows - 5);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("INDEX SCAN", "B21", true, false, false, false);
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 5, ID);
            lSql = "select k2, f1, f3 from  " + sTableName + " where f3 >= " + (this.mTableRows - 5) + " and f3 >= " + (this.mTableRows - 2);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("INDEX SCAN", "B21", true, false, false, false);
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 2, ID);
            lSql = "select k2, f1, f3 from  " + sTableName + " where f3 >= " + (this.mTableRows - 5) + " and f3 <= " + (this.mTableRows - 2);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("INDEX SCAN", "B21", true, false, false, false);
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 4, ID);
            lSql = "select k2, f1, f3 from  " + sTableName + " where f3 >= " + (this.mTableRows - 5) + " and f3 <= " + (this.mTableRows - 7);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("INDEX SCAN", "B21", true, false, false, false);
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 0, ID);
            lSql = "select k2, f1, f3 from  " + sTableName + " where f3 in ( 1,2,3,4,5)";
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("INDEX SCAN", "B21", true, false, false, false);
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 5, ID);
            ID = IDD + "-5";
            lSql = "select k2, f1 from  " + sTableName + " where k1 = " + (this.mDiffInteger - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEX", "B21", true, false, false, false);
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "K1");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffString, ID);
            lSql = "select k2, f1, f3 from  " + sTableName + " where k1 = " + (this.mDiffInteger - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEX", "B21", true, false, false, false);
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "K1");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffString, ID);
            lSql = "select k2, f1, f3 from  " + sTableName + " where k1 >= " + (this.mDiffInteger - 3);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEX", "B21", true, false, false, false);
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "K1");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffString * 3, ID);
            lSql = "select k2, f1, f3 from  " + sTableName + " where k1 >= " + (this.mDiffInteger - 3) + " and k1 >= " + (this.mDiffInteger - 2);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEX", "B21", true, false, false, false);
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "K1");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 2 * this.mDiffString, ID);
            lSql = "select k2, f1, f3 from  " + sTableName + " where k1 >= " + (this.mDiffInteger - 3) + " and k1 <= " + (this.mDiffInteger - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEX", "B21", true, false, false, false);
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "K1");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffString * 3, ID);
            lSql = "select k2, f1, f3 from  " + sTableName + " where k1 >= " + (this.mTableRows - 2) + " and k1 <= " + (this.mTableRows - 3);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEX", "B21", true, false, false, false);
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "K1");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 0, ID);
            int n = 0;
            switch (this.mDiffInteger) {
                case 0: {
                    lSql = null;
                    n = 0;
                    break;
                }
                case 1: {
                    lSql = "select k2, f1, f3 from  " + sTableName + " where k1 in ( 0 )";
                    n = 1;
                    break;
                }
                case 2: {
                    lSql = "select k2, f1, f3 from  " + sTableName + " where k1 in ( 0, 1 )";
                    n = 2;
                    break;
                }
                default: {
                    lSql = "select k2, f1, f3 from  " + sTableName + " where k1 in ( 0, 1, 2 )";
                    n = 3;
                }
            }
            if (n > 0) {
                this.mMainExplainObject.clear();
                this.mMainExplainObject.addTable(sTableName);
                this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEX", "B21", true, false, false, false);
                this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "K1");
                this.mMainExplainObject.add();
                this.executePreparedStep(lSql, this.mMainExplainObject, n * this.mDiffString, ID);
            }
            ID = IDD + "-6";
            lSql = "select f2, f1 from  " + sTableName + " where k1 = " + (this.mDiffInteger - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEX", "B21", false, false, false, false);
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "K1");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffString, ID, 'W');
            lSql = "select f2, f1, f3 from  " + sTableName + " where k1 = " + (this.mDiffInteger - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEX", "B21", false, false, false, false);
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "K1");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffString, ID, 'W');
            lSql = "select f2, f1, f3 from  " + sTableName + " where k1 >= " + (this.mDiffInteger - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEX", "B21", false, false, false, false);
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "K1");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffString, ID, 'W');
            lSql = "select f2, f1, f3 from  " + sTableName + " where k1 >= " + (this.mDiffInteger - 3) + " and k1 >= " + (this.mDiffInteger - 2);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEX", "B21", false, false, false, false);
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "K1");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffString * 2, ID, 'W');
            lSql = "select f2, f1, f3 from  " + sTableName + " where k1 >= " + (this.mDiffInteger - 3) + " and k1 <= " + (this.mDiffInteger - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEX", "B20", false, false, false, false);
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffString * 3, ID, 'W');
            lSql = "select f2, f1, f3 from  " + sTableName + " where k1 >= " + (this.mDiffInteger - 1) + " and k1 <= " + (this.mDiffInteger - 3);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEX", "B21", false, false, false, false);
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "K1");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 0, ID, 'W');
            n = 0;
            switch (this.mDiffInteger) {
                case 0: {
                    lSql = null;
                    n = 0;
                    break;
                }
                case 1: {
                    lSql = "select f2, f1, f3 from  " + sTableName + " where k1 in ( 0 )";
                    n = 1;
                    break;
                }
                case 2: {
                    lSql = "select f2, f1, f3 from  " + sTableName + " where k1 in ( 0, 1 )";
                    n = 2;
                    break;
                }
                default: {
                    lSql = "select f2, f1, f3 from  " + sTableName + " where k1 in ( 0, 1, 2 )";
                    n = 3;
                }
            }
            if (n > 0) {
                this.mMainExplainObject.clear();
                this.mMainExplainObject.addTable(sTableName);
                this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEX", "B20", false, false, false, false);
                this.mMainExplainObject.add();
                this.executePreparedStep(lSql, this.mMainExplainObject, n * this.mDiffString, ID, 'W');
            }
        }
        finally {
            if (this.mDropIndexesAfterBlockFinished) {
                sTable.dropIndex("B20", false);
                sTable.dropIndex("B21", false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void block_8() throws SQLException, TestCaseException, ExplainException, TestStatementMonitorException {
        String ID = "Block_008";
        String IDD = "Block_008";
        String lSql = null;
        try {
            ID = IDD + "-1";
            lSql = "select distinct k0 from " + sTableName;
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("Table Scan");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
            lSql = "select distinct k1 from " + sTableName;
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("Table Scan");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger, ID);
            lSql = "select distinct k2 from " + sTableName;
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("Table Scan");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffString, ID);
            lSql = "select distinct k0,k1 from " + sTableName;
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("Table Scan");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger, ID);
            lSql = "select distinct k0,k2 from " + sTableName;
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("Table Scan");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffString, ID);
            lSql = "select distinct k0,k2,k1 from " + sTableName;
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("Table Scan");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffString * this.mDiffInteger, ID);
            ID = IDD + "-2";
            lSql = "select distinct k0 from  " + sTableName + " where k0 = " + SingleTableV74.buildK0();
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("Range Condition For Key Column");
            this.mMainExplainObject.addStrategy("(USED KEY COLUMN)", "K0");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
            lSql = "select distinct k0 from  " + sTableName + " where k1 = " + (this.mDiffInteger - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("Table Scan");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
            lSql = "select distinct k0 from  " + sTableName + " where k2 = " + SingleTableV74.buildK2(this.mDiffString - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("Table Scan");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
            lSql = "select distinct k0 from  " + sTableName + " where k0 = " + SingleTableV74.buildK0() + " and k1 = " + (this.mDiffInteger - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("Range Condition For Key Column");
            this.mMainExplainObject.addStrategy("(USED KEY COLUMN)", "K0");
            this.mMainExplainObject.addStrategy("(USED KEY COLUMN)", "K1");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
            lSql = "select distinct k0 from  " + sTableName + " where k0 = " + SingleTableV74.buildK0() + " and k2 = " + SingleTableV74.buildK2(this.mDiffString - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("Range Condition For Key Column");
            this.mMainExplainObject.addStrategy("(USED KEY COLUMN)", "K0");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
            lSql = "select distinct k0 from  " + sTableName + " where k1 = " + (this.mDiffInteger - 1) + " and k2 = " + SingleTableV74.buildK2(this.mDiffString - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("Table Scan");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
            lSql = "select distinct k0 from  " + sTableName + " where k0 = " + SingleTableV74.buildK0() + " and k1 = " + (this.mDiffInteger - 1) + " and k2 = " + SingleTableV74.buildK2(this.mDiffString - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("Equal Condition For Key Column");
            this.mMainExplainObject.addStrategy("(USED KEY COLUMN)", "K0");
            this.mMainExplainObject.addStrategy("(USED KEY COLUMN)", "K1");
            this.mMainExplainObject.addStrategy("(USED KEY COLUMN)", "K2");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
            ID = IDD + "-3";
            lSql = "select distinct k1 from  " + sTableName + " where k0 = " + SingleTableV74.buildK0();
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("Range Condition For Key Column");
            this.mMainExplainObject.addStrategy("(USED KEY COLUMN)", "K0");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger, ID);
            lSql = "select distinct k1 from  " + sTableName + " where k1 = " + (this.mDiffInteger - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("Table Scan");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
            lSql = "select distinct k1 from  " + sTableName + " where k2 = " + SingleTableV74.buildK2(this.mDiffString - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("Table Scan");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger, ID);
            lSql = "select distinct k1 from  " + sTableName + " where k0 = " + SingleTableV74.buildK0() + " and k1 = " + (this.mDiffInteger - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("Range Condition For Key Column");
            this.mMainExplainObject.addStrategy("(USED KEY COLUMN)", "K0");
            this.mMainExplainObject.addStrategy("(USED KEY COLUMN)", "K1");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
            lSql = "select distinct k1 from  " + sTableName + " where k0 = " + SingleTableV74.buildK0() + " and k2 = " + SingleTableV74.buildK2(this.mDiffString - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("Range Condition For Key Column");
            this.mMainExplainObject.addStrategy("(USED KEY COLUMN)", "K0");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger, ID);
            lSql = "select distinct k1 from  " + sTableName + " where k1 = " + (this.mDiffInteger - 1) + " and k2 = " + SingleTableV74.buildK2(this.mDiffString - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("Table Scan");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
            lSql = "select distinct k1 from  " + sTableName + " where k0 = " + SingleTableV74.buildK0() + " and k1 = " + (this.mDiffInteger - 1) + " and k2 = " + SingleTableV74.buildK2(this.mDiffString - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("Equal Condition For Key Column");
            this.mMainExplainObject.addStrategy("(USED KEY COLUMN)", "K0");
            this.mMainExplainObject.addStrategy("(USED KEY COLUMN)", "K1");
            this.mMainExplainObject.addStrategy("(USED KEY COLUMN)", "K2");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
            ID = IDD + "-4";
            lSql = "select distinct k2 from  " + sTableName + " where k0 = " + SingleTableV74.buildK0();
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("Range Condition For Key Column");
            this.mMainExplainObject.addStrategy("(USED KEY COLUMN)", "K0");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffString, ID);
            lSql = "select distinct k2 from  " + sTableName + " where k1 = " + (this.mDiffInteger - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("Table Scan");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffString, ID);
            lSql = "select distinct k2 from  " + sTableName + " where k2 = " + SingleTableV74.buildK2(this.mDiffString - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("Table Scan");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
            lSql = "select distinct k2 from  " + sTableName + " where k0 = " + SingleTableV74.buildK0() + " and k1 = " + (this.mDiffInteger - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("Range Condition For Key Column");
            this.mMainExplainObject.addStrategy("(USED KEY COLUMN)", "K0");
            this.mMainExplainObject.addStrategy("(USED KEY COLUMN)", "K1");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffString, ID);
            lSql = "select distinct k2 from  " + sTableName + " where k0 = " + SingleTableV74.buildK0() + " and k2 = " + SingleTableV74.buildK2(this.mDiffString - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("Range Condition For Key Column");
            this.mMainExplainObject.addStrategy("(USED KEY COLUMN)", "K0");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
            lSql = "select distinct k2 from  " + sTableName + " where k1 = " + (this.mDiffInteger - 1) + " and k2 = " + SingleTableV74.buildK2(this.mDiffString - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("Table Scan");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
            lSql = "select distinct k2 from  " + sTableName + " where k0 = " + SingleTableV74.buildK0() + " and k1 = " + (this.mDiffInteger - 1) + " and k2 = " + SingleTableV74.buildK2(this.mDiffString - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("Equal Condition For Key Column");
            this.mMainExplainObject.addStrategy("(USED KEY COLUMN)", "K0");
            this.mMainExplainObject.addStrategy("(USED KEY COLUMN)", "K1");
            this.mMainExplainObject.addStrategy("(USED KEY COLUMN)", "K2");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
            sTable.dropIndex("b20", false);
            sTable.createIndex("b20", new String[]{"f0, f1, f2"}, true, this.mHelpStatement);
            sTable.updateStatistics(this.mHelpStatement);
            ID = IDD + "-5";
            lSql = "select distinct f0 from " + sTableName;
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("INDEX SCAN", "B20", true, false, false, false);
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
            lSql = "select distinct f1 from " + sTableName;
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("INDEX SCAN", "B20", true, false, false, false);
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger, ID);
            lSql = "select distinct f2 from " + sTableName;
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("INDEX SCAN", "B20", true, false, false, false);
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffString, ID);
            lSql = "select distinct f0,f1 from " + sTableName;
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("INDEX SCAN", "B20", true, false, false, false);
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger, ID);
            lSql = "select distinct f0,f2 from " + sTableName;
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("INDEX SCAN", "B20", true, false, false, false);
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffString, ID);
            lSql = "select distinct f0,f1,f2 from " + sTableName;
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("INDEX SCAN", "B20", true, false, false, false);
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mTableRows, ID);
            ID = IDD + "-6";
            lSql = "select distinct f0 from  " + sTableName + " where f0 = " + SingleTableV74.buildK0();
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEX", "B20", true, false, false, false);
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f0");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
            lSql = "select distinct f0 from  " + sTableName + " where f1 = " + (this.mDiffInteger - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("INDEX SCAN", "B20", true, false, false, false);
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
            lSql = "select distinct f0 from  " + sTableName + " where f2 = " + SingleTableV74.buildK2(this.mDiffString - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("INDEX SCAN", "B20", true, false, false, false);
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
            lSql = "select distinct f0 from  " + sTableName + " where f0 = " + SingleTableV74.buildK0() + " and f1 = " + (this.mDiffInteger - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEX", "B20", true, false, false, false);
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f0");
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f1");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
            lSql = "select distinct f0 from  " + sTableName + " where f0 = " + SingleTableV74.buildK0() + " and f2 = " + SingleTableV74.buildK2(this.mDiffString - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEX", "B20", true, false, false, false);
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f0");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
            lSql = "select distinct f0 from  " + sTableName + " where f1 = " + (this.mDiffInteger - 1) + " and f2 = " + SingleTableV74.buildK2(this.mDiffString - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("INDEX SCAN", "B20", true, false, false, false);
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
            lSql = "select distinct f0 from  " + sTableName + " where f0 = " + SingleTableV74.buildK0() + " and f1 = " + (this.mDiffInteger - 1) + " and f2 = " + SingleTableV74.buildK2(this.mDiffString - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("EQUAL CONDITION FOR INDEX", "B20", true, false, false, false);
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f0");
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f1");
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f2");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
            ID = IDD + "-7";
            lSql = "select distinct f1 from  " + sTableName + " where f0 = " + SingleTableV74.buildK0();
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEX", "B20", true, false, false, false);
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f0");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger, ID);
            lSql = "select distinct f1 from  " + sTableName + " where f1 = " + (this.mDiffInteger - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("INDEX SCAN", "B20", true, false, false, false);
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
            lSql = "select distinct f1 from  " + sTableName + " where f2 = " + SingleTableV74.buildK2(this.mDiffString - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("INDEX SCAN", "B20", true, false, false, false);
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger, ID);
            lSql = "select distinct f1 from  " + sTableName + " where f0 = " + SingleTableV74.buildK0() + " and f1 = " + (this.mDiffInteger - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEX", "B20", true, false, false, false);
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f0");
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f1");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
            lSql = "select distinct f1 from  " + sTableName + " where f0 = " + SingleTableV74.buildK0() + " and f2 = " + SingleTableV74.buildK2(this.mDiffString - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEX", "B20", true, false, false, false);
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f0");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger, ID);
            lSql = "select distinct f1 from  " + sTableName + " where f1 = " + (this.mDiffInteger - 1) + " and f2 = " + SingleTableV74.buildK2(this.mDiffString - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("INDEX SCAN", "B20", true, false, false, false);
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
            lSql = "select distinct f1 from  " + sTableName + " where f0 = " + SingleTableV74.buildK0() + " and f1 = " + (this.mDiffInteger - 1) + " and f2 = " + SingleTableV74.buildK2(this.mDiffString - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("EQUAL CONDITION FOR INDEX", "B20", true, false, false, false);
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f0");
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f1");
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f2");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
            ID = IDD + "-8";
            lSql = "select distinct f2 from  " + sTableName + " where f0 = " + SingleTableV74.buildK0();
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEX", "B20", true, false, false, false);
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f0");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffString, ID);
            lSql = "select distinct f2 from  " + sTableName + " where f1 = " + (this.mDiffInteger - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("INDEX SCAN", "B20", true, false, false, false);
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffString, ID);
            lSql = "select distinct f2 from  " + sTableName + " where f2 = " + SingleTableV74.buildK2(this.mDiffString - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("INDEX SCAN", "B20", true, false, false, false);
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
            lSql = "select distinct f2 from  " + sTableName + " where f0 = " + SingleTableV74.buildK0() + " and f1 = " + (this.mDiffInteger - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEX", "B20", true, false, false, false);
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f0");
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f1");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffString, ID);
            lSql = "select distinct f2 from  " + sTableName + " where f0 = " + SingleTableV74.buildK0() + " and f2 = " + SingleTableV74.buildK2(this.mDiffString - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEX", "B20", true, false, false, false);
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f0");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
            lSql = "select distinct f2 from  " + sTableName + " where f1 = " + (this.mDiffInteger - 1) + " and f2 = " + SingleTableV74.buildK2(this.mDiffString - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("INDEX SCAN", "B20", true, false, false, false);
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
            lSql = "select distinct f2 from  " + sTableName + " where f0 = " + SingleTableV74.buildK0() + " and f1 = " + (this.mDiffInteger - 1) + " and f2 = " + SingleTableV74.buildK2(this.mDiffString - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("EQUAL CONDITION FOR INDEX", "B20", true, false, false, false);
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f0");
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f1");
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f2");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
        }
        finally {
            if (this.mDropIndexesAfterBlockFinished) {
                sTable.dropIndex("b20", false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void block_9() throws SQLException, TestCaseException, ExplainException, TestStatementMonitorException {
        String ID = "Block_009";
        String IDD = "Block_009";
        String lSql = null;
        try {
            ID = IDD + "-1";
            lSql = "select distinct k0,k1 from  " + sTableName + " where k0 = " + SingleTableV74.buildK0();
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("Range Condition For Key Column");
            this.mMainExplainObject.addStrategy("(USED KEY COLUMN)", "K0");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger, ID);
            lSql = "select distinct k0,k1 from  " + sTableName + " where k1 = " + (this.mDiffInteger - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("Table Scan");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
            lSql = "select distinct k0,k1 from  " + sTableName + " where k2 = " + SingleTableV74.buildK2(this.mDiffString - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("Table Scan");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger, ID);
            lSql = "select distinct k0,k1 from  " + sTableName + " where k0 = " + SingleTableV74.buildK0() + " and k1 = " + (this.mDiffInteger - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("Range Condition For Key Column");
            this.mMainExplainObject.addStrategy("(USED KEY COLUMN)", "K0");
            this.mMainExplainObject.addStrategy("(USED KEY COLUMN)", "K1");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
            lSql = "select distinct k0,k1 from  " + sTableName + " where k0 = " + SingleTableV74.buildK0() + " and k2 = " + SingleTableV74.buildK2(this.mDiffString - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("Range Condition For Key Column");
            this.mMainExplainObject.addStrategy("(USED KEY COLUMN)", "K0");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger, ID);
            lSql = "select distinct k0,k1 from  " + sTableName + " where k1 = " + (this.mDiffInteger - 1) + " and k2 = " + SingleTableV74.buildK2(this.mDiffString - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("Table Scan");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
            lSql = "select distinct k0,k1 from  " + sTableName + " where k0 = " + SingleTableV74.buildK0() + " and k1 = " + (this.mDiffInteger - 1) + " and k2 = " + SingleTableV74.buildK2(this.mDiffString - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("Equal Condition For Key Column");
            this.mMainExplainObject.addStrategy("(USED KEY COLUMN)", "K0");
            this.mMainExplainObject.addStrategy("(USED KEY COLUMN)", "K1");
            this.mMainExplainObject.addStrategy("(USED KEY COLUMN)", "K2");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
            ID = IDD + "-2";
            lSql = "select distinct k0,k2 from  " + sTableName + " where k0 = " + SingleTableV74.buildK0();
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("Range Condition For Key Column");
            this.mMainExplainObject.addStrategy("(USED KEY COLUMN)", "K0");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffString, ID);
            lSql = "select distinct k0,k2 from  " + sTableName + " where k1 = " + (this.mDiffInteger - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("Table Scan");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffString, ID);
            lSql = "select distinct k0,k2 from  " + sTableName + " where k2 = " + SingleTableV74.buildK2(this.mDiffString - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("Table Scan");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
            lSql = "select distinct k0,k2 from  " + sTableName + " where k0 = " + SingleTableV74.buildK0() + " and k1 = " + (this.mDiffInteger - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("Range Condition For Key Column");
            this.mMainExplainObject.addStrategy("(USED KEY COLUMN)", "K0");
            this.mMainExplainObject.addStrategy("(USED KEY COLUMN)", "K1");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffString, ID);
            lSql = "select distinct k0,k2 from  " + sTableName + " where k0 = " + SingleTableV74.buildK0() + " and k2 = " + SingleTableV74.buildK2(this.mDiffString - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("Range Condition For Key Column");
            this.mMainExplainObject.addStrategy("(USED KEY COLUMN)", "K0");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
            lSql = "select distinct k0,k2 from  " + sTableName + " where k1 = " + (this.mDiffInteger - 1) + " and k2 = " + SingleTableV74.buildK2(this.mDiffString - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("Table Scan");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
            lSql = "select distinct k0,k2 from  " + sTableName + " where k0 = " + SingleTableV74.buildK0() + " and k1 = " + (this.mDiffInteger - 1) + " and k2 = " + SingleTableV74.buildK2(this.mDiffString - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("Equal Condition For Key Column");
            this.mMainExplainObject.addStrategy("(USED KEY COLUMN)", "K0");
            this.mMainExplainObject.addStrategy("(USED KEY COLUMN)", "K1");
            this.mMainExplainObject.addStrategy("(USED KEY COLUMN)", "K2");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
            ID = IDD + "-3";
            lSql = "select distinct k1,k2 from  " + sTableName + " where k0 = " + SingleTableV74.buildK0();
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("Range Condition For Key Column");
            this.mMainExplainObject.addStrategy("(USED KEY COLUMN)", "K0");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mTableRows, ID);
            lSql = "select distinct k1,k2 from  " + sTableName + " where k1 = " + (this.mDiffInteger - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("Table Scan");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffString, ID);
            lSql = "select distinct k1,k2 from  " + sTableName + " where k2 = " + SingleTableV74.buildK2(this.mDiffString - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("Table Scan");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger, ID);
            lSql = "select distinct k1,k2 from  " + sTableName + " where k0 = " + SingleTableV74.buildK0() + " and k1 = " + (this.mDiffInteger - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("Range Condition For Key Column");
            this.mMainExplainObject.addStrategy("(USED KEY COLUMN)", "K0");
            this.mMainExplainObject.addStrategy("(USED KEY COLUMN)", "K1");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffString, ID);
            lSql = "select distinct k1,k2 from  " + sTableName + " where k0 = " + SingleTableV74.buildK0() + " and k2 = " + SingleTableV74.buildK2(this.mDiffString - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("Range Condition For Key Column");
            this.mMainExplainObject.addStrategy("(USED KEY COLUMN)", "K0");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger, ID);
            lSql = "select distinct k1,k2 from  " + sTableName + " where k1 = " + (this.mDiffInteger - 1) + " and k2 = " + SingleTableV74.buildK2(this.mDiffString - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("Table Scan");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
            lSql = "select distinct k1,k2 from  " + sTableName + " where k0 = " + SingleTableV74.buildK0() + " and k1 = " + (this.mDiffInteger - 1) + " and k2 = " + SingleTableV74.buildK2(this.mDiffString - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("Equal Condition For Key Column");
            this.mMainExplainObject.addStrategy("(USED KEY COLUMN)", "K0");
            this.mMainExplainObject.addStrategy("(USED KEY COLUMN)", "K1");
            this.mMainExplainObject.addStrategy("(USED KEY COLUMN)", "K2");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
            ID = IDD + "-4";
            lSql = "select distinct k1,k2,k0 from  " + sTableName + " where k0 = " + SingleTableV74.buildK0();
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("Range Condition For Key Column");
            this.mMainExplainObject.addStrategy("(USED KEY COLUMN)", "K0");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mTableRows, ID);
            lSql = "select distinct k1,k2,k0 from  " + sTableName + " where k1 = " + (this.mDiffInteger - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("Table Scan");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffString, ID);
            lSql = "select distinct k1,k2,k0 from  " + sTableName + " where k2 = " + SingleTableV74.buildK2(this.mDiffString - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("Table Scan");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger, ID);
            lSql = "select distinct k1,k2,k0 from  " + sTableName + " where k0 = " + SingleTableV74.buildK0() + " and k1 = " + (this.mDiffInteger - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("Range Condition For Key Column");
            this.mMainExplainObject.addStrategy("(USED KEY COLUMN)", "K0");
            this.mMainExplainObject.addStrategy("(USED KEY COLUMN)", "K1");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffString, ID);
            lSql = "select distinct k1,k2,k0 from  " + sTableName + " where k0 = " + SingleTableV74.buildK0() + " and k2 = " + SingleTableV74.buildK2(this.mDiffString - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("Range Condition For Key Column");
            this.mMainExplainObject.addStrategy("(USED KEY COLUMN)", "K0");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger, ID);
            lSql = "select distinct k1,k2,k0 from  " + sTableName + " where k1 = " + (this.mDiffInteger - 1) + " and k2 = " + SingleTableV74.buildK2(this.mDiffString - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("Table Scan");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
            lSql = "select distinct k1,k2,k0 from  " + sTableName + " where k0 = " + SingleTableV74.buildK0() + " and k1 = " + (this.mDiffInteger - 1) + " and k2 = " + SingleTableV74.buildK2(this.mDiffString - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("Equal Condition For Key Column");
            this.mMainExplainObject.addStrategy("(USED KEY COLUMN)", "K0");
            this.mMainExplainObject.addStrategy("(USED KEY COLUMN)", "K1");
            this.mMainExplainObject.addStrategy("(USED KEY COLUMN)", "K2");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
            sTable.dropIndex("b20", false);
            sTable.createIndex("b20", new String[]{"f0, f1, f2"}, true, this.mHelpStatement);
            sTable.updateStatistics(this.mHelpStatement);
            ID = IDD + "-5";
            lSql = "select distinct f0,f1 from  " + sTableName + " where f0 = " + SingleTableV74.buildK0();
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEX", "B20", true, false, false, false);
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f0");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger, ID);
            lSql = "select distinct f0,f1 from  " + sTableName + " where f1 = " + (this.mDiffInteger - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("INDEX SCAN", "B20", true, false, false, false);
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
            lSql = "select distinct f0,f1 from  " + sTableName + " where f2 = " + SingleTableV74.buildK2(this.mDiffString - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("INDEX SCAN", "B20", true, false, false, false);
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger, ID);
            lSql = "select distinct f0,f1 from  " + sTableName + " where f0 = " + SingleTableV74.buildK0() + " and f1 = " + (this.mDiffInteger - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEX", "B20", true, false, false, false);
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f0");
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f1");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
            lSql = "select distinct f0,f1 from  " + sTableName + " where f0 = " + SingleTableV74.buildK0() + " and f2 = " + SingleTableV74.buildK2(this.mDiffString - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEX", "B20", true, false, false, false);
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f0");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger, ID);
            lSql = "select distinct f0,f1 from  " + sTableName + " where f1 = " + (this.mDiffInteger - 1) + " and f2 = " + SingleTableV74.buildK2(this.mDiffString - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("INDEX SCAN", "B20", true, false, false, false);
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
            lSql = "select distinct f0,f1 from  " + sTableName + " where f0 = " + SingleTableV74.buildK0() + " and f1 = " + (this.mDiffInteger - 1) + " and f2 = " + SingleTableV74.buildK2(this.mDiffString - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("EQUAL CONDITION FOR INDEX", "B20", true, false, false, false);
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f0");
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f1");
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f2");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
            ID = IDD + "-6";
            lSql = "select distinct f0,f2 from  " + sTableName + " where f0 = " + SingleTableV74.buildK0();
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEX", "B20", true, false, false, false);
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f0");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffString, ID);
            lSql = "select distinct f0,f2 from  " + sTableName + " where f1 = " + (this.mDiffInteger - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("INDEX SCAN", "B20", true, false, false, false);
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffString, ID);
            lSql = "select distinct f0,f2 from  " + sTableName + " where f2 = " + SingleTableV74.buildK2(this.mDiffString - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("INDEX SCAN", "B20", true, false, false, false);
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
            lSql = "select distinct f0,f2 from  " + sTableName + " where f0 = " + SingleTableV74.buildK0() + " and f1 = " + (this.mDiffInteger - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEX", "B20", true, false, false, false);
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f0");
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f1");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffString, ID);
            lSql = "select distinct f0,f2 from  " + sTableName + " where f0 = " + SingleTableV74.buildK0() + " and f2 = " + SingleTableV74.buildK2(this.mDiffString - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEX", "B20", true, false, false, false);
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f0");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
            lSql = "select distinct f0,f2 from  " + sTableName + " where f1 = " + (this.mDiffInteger - 1) + " and f2 = " + SingleTableV74.buildK2(this.mDiffString - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("INDEX SCAN", "B20", true, false, false, false);
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
            lSql = "select distinct f0,f2 from  " + sTableName + " where f0 = " + SingleTableV74.buildK0() + " and f1 = " + (this.mDiffInteger - 1) + " and f2 = " + SingleTableV74.buildK2(this.mDiffString - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("EQUAL CONDITION FOR INDEX", "B20", true, false, false, false);
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f0");
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f1");
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f2");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
            ID = IDD + "-7";
            lSql = "select distinct f1,f2 from  " + sTableName + " where f0 = " + SingleTableV74.buildK0();
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEX", "B20", true, false, false, false);
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f0");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mTableRows, ID);
            lSql = "select distinct f1,f2 from  " + sTableName + " where f1 = " + (this.mDiffInteger - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("INDEX SCAN", "B20", true, false, false, false);
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffString, ID);
            lSql = "select distinct f1,f2 from  " + sTableName + " where f2 = " + SingleTableV74.buildK2(this.mDiffString - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("INDEX SCAN", "B20", true, false, false, false);
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger, ID);
            lSql = "select distinct f1,f2 from  " + sTableName + " where f0 = " + SingleTableV74.buildK0() + " and f1 = " + (this.mDiffInteger - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEX", "B20", true, false, false, false);
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f0");
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f1");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffString, ID);
            lSql = "select distinct f1,f2 from  " + sTableName + " where f0 = " + SingleTableV74.buildK0() + " and f2 = " + SingleTableV74.buildK2(this.mDiffString - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEX", "B20", true, false, false, false);
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f0");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger, ID);
            lSql = "select distinct f1,f2 from  " + sTableName + " where f1 = " + (this.mDiffInteger - 1) + " and f2 = " + SingleTableV74.buildK2(this.mDiffString - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("INDEX SCAN", "B20", true, false, false, false);
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
            lSql = "select distinct f1,f2 from  " + sTableName + " where f0 = " + SingleTableV74.buildK0() + " and f1 = " + (this.mDiffInteger - 1) + " and f2 = " + SingleTableV74.buildK2(this.mDiffString - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("EQUAL CONDITION FOR INDEX", "B20", true, false, false, false);
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f0");
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f1");
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f2");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
            ID = IDD + "-8";
            lSql = "select distinct f1,f2,f0 from  " + sTableName + " where f0 = " + SingleTableV74.buildK0();
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEX", "B20", true, false, false, false);
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f0");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mTableRows, ID);
            lSql = "select distinct f1,f2,f0 from  " + sTableName + " where f1 = " + (this.mDiffInteger - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("INDEX SCAN", "B20", true, false, false, false);
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffString, ID);
            lSql = "select distinct f1,f2,f0 from  " + sTableName + " where f2 = " + SingleTableV74.buildK2(this.mDiffString - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("INDEX SCAN", "B20", true, false, false, false);
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger, ID);
            lSql = "select distinct f1,f2,f0 from  " + sTableName + " where f0 = " + SingleTableV74.buildK0() + " and f1 = " + (this.mDiffInteger - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEX", "B20", true, false, false, false);
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f0");
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f1");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffString, ID);
            lSql = "select distinct f1,f2,f0 from  " + sTableName + " where f0 = " + SingleTableV74.buildK0() + " and f2 = " + SingleTableV74.buildK2(this.mDiffString - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEX", "B20", true, false, false, false);
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f0");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger, ID);
            lSql = "select distinct f1,f2,f0 from  " + sTableName + " where f1 = " + (this.mDiffInteger - 1) + " and f2 = " + SingleTableV74.buildK2(this.mDiffString - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("INDEX SCAN", "B20", true, false, false, false);
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
            lSql = "select distinct f1,f2,f0 from  " + sTableName + " where f0 = " + SingleTableV74.buildK0() + " and f1 = " + (this.mDiffInteger - 1) + " and f2 = " + SingleTableV74.buildK2(this.mDiffString - 1);
            this.mMainExplainObject.clear();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("EQUAL CONDITION FOR INDEX", "B20", true, false, false, false);
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f0");
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f1");
            this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f2");
            this.mMainExplainObject.add();
            this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
        }
        finally {
            if (this.mDropIndexesAfterBlockFinished) {
                sTable.dropIndex("b20", false);
            }
        }
    }

    private static String buildK0() {
        return " '" + sValueK0 + "' ";
    }

    private static String buildK2(int pInt) {
        return " '" + sValueK2 + K2_FORMAT.format(pInt) + "' ";
    }

    protected boolean check(TestPreparedStatement ps, ExplainObject pEx, int pResultCounter, int pVr, long pMaxRuntime, String pStep) throws TestCaseException {
        return this.check(ps, pEx, pResultCounter, pVr, pMaxRuntime, pStep, 'E');
    }

    protected boolean check(TestPreparedStatement ps, ExplainObject pex, int pResultCounter, int pvr, long pMaxRuntime, String pStep, char pExplainErrorType) throws TestCaseException {
        boolean ret = this.check((TestStatement)ps, pex, pResultCounter, pMaxRuntime, pStep, pExplainErrorType);
        if (SingleTableV74.getParameterBoolean((String)"Check_Virtual_Reads", (boolean)true) && pvr > 0) {
            try {
                int ivr = ps.getMonitor().getNumberOfVirtualReads();
                int lvr = pvr == Integer.MAX_VALUE ? pvr : pvr + (int)((double)pvr * 0.1);
                if (ivr > lvr) {
                    this.addMessage(this.getStep(), 'W', "Too much virtual reads. Limit = " + lvr + " Actual = " + ivr, ps.getSqlString());
                    ret = false;
                }
            }
            catch (NullPointerException tnpe) {
                System.err.println("Couldn't monitor statement!!!");
                tnpe.printStackTrace(System.err);
                ret = false;
            }
        }
        return ret;
    }

    protected boolean check(TestStatement ps, ExplainObject pex, int pResultCounter, long pMaxRuntime, String pStep) throws TestCaseException {
        return this.check(ps, pex, pResultCounter, pMaxRuntime, pStep, 'E');
    }

    protected boolean check(TestStatement ps, ExplainObject pex, int pResultCounter, long pMaxRuntime, String pStep, char pExplainMessageType) throws TestCaseException {
        boolean ret = true;
        boolean b = true;
        pStep = this.nextStep(pStep);
        ret = this.checkResultCounter(ps, pResultCounter, pStep);
        if (SingleTableV74.getParameterBoolean((String)"Check_Strategy", (boolean)true) && !(b = this.checkStrategy(ps, pex, pStep, pExplainMessageType))) {
            ret = b;
        }
        if (SingleTableV74.getParameterBoolean((String)"Check_Statement_Runtime", (boolean)true) && pMaxRuntime != Long.MAX_VALUE && ps.getRuntime() > pMaxRuntime * 2L) {
            this.addMessage(this.getStep(), 'W', "Runtime of statement too long. Limit: " + pMaxRuntime * 10L + " Actual = " + ps.getRuntime(), ps.getSqlString());
            ret = false;
        }
        return ret;
    }

    protected boolean executePreparedStep(String pSql, ExplainObject pExplainObject, int pResultCounter, String pStep) throws SQLException, TestCaseException, TestStatementMonitorException {
        return this.executePreparedStep(pSql, pExplainObject, pResultCounter, pStep, 'E');
    }

    protected boolean executePreparedStep(String pSql, ExplainObject pExplainObject, int pResultCounter, String pStep, char pExplainErrorType) throws SQLException, TestCaseException, TestStatementMonitorException {
        this.mMainPreparedStatement = new TestPreparedStatement((TestCase)this, this.mMainConnection, pSql, this.mMainMonitor, 1005, 1007);
        this.mMainPreparedStatement.execute();
        boolean result = this.check(this.mMainPreparedStatement, pExplainObject, pResultCounter, this.mMaxNoOfVirtualReads, this.mMaxRuntime, pStep, pExplainErrorType);
        if (SingleTableV74.getParameterBoolean((String)"CHECK_ALTERNATIVE_STRATEGIES", (boolean)false) && pSql.toUpperCase().startsWith("SELECT")) {
            if (this.mAlternativeMonitor == null) {
                this.mAlternativeMonitor = new TestStatementMonitor(this.mMainConnection);
            }
            this.mAlternativeMonitor.activate();
            int lReadsOptimizer = this.mMainMonitor.getNumberOfVirtualReads();
            String ls = pSql.substring(7);
            TestPreparedStatement lps = null;
            String lsql = null;
            int lReadsAlternative = 0;
            Set lSet = sTable.getIndexNames();
            if (lSet != null && !lSet.isEmpty()) {
                Iterator lIt = lSet.iterator();
                while (lIt.hasNext()) {
                    String lIndexName = (String)lIt.next();
                    lsql = "Select /*+INDEXACCESS(" + lIndexName + ")*/ " + ls;
                    lps = new TestPreparedStatement((TestCase)this, this.mMainConnection, lsql, this.mAlternativeMonitor, 1005, 1007);
                    lps.execute();
                    lReadsAlternative = this.mAlternativeMonitor.getNumberOfVirtualReads();
                    if (lReadsOptimizer > lReadsAlternative) {
                        this.addAlternativeStrategieMessage(this.mMainPreparedStatement, lReadsOptimizer, lps, lReadsAlternative);
                    }
                    lsql = "Select /*+INDEXSCAN(" + lIndexName + ")*/ " + ls;
                    lps = new TestPreparedStatement((TestCase)this, this.mMainConnection, lsql, this.mAlternativeMonitor, 1005, 1007);
                    lps.execute();
                    lReadsAlternative = this.mAlternativeMonitor.getNumberOfVirtualReads();
                    if (lReadsOptimizer <= lReadsAlternative) continue;
                    this.addAlternativeStrategieMessage(this.mMainPreparedStatement, lReadsOptimizer, lps, lReadsAlternative);
                }
            }
            lsql = "Select /*+KEYACCESS*/ " + ls;
            lps = new TestPreparedStatement((TestCase)this, this.mMainConnection, lsql, this.mAlternativeMonitor, 1005, 1007);
            lps.execute();
            lReadsAlternative = this.mAlternativeMonitor.getNumberOfVirtualReads();
            if (lReadsOptimizer > lReadsAlternative) {
                this.addAlternativeStrategieMessage(this.mMainPreparedStatement, lReadsOptimizer, lps, lReadsAlternative);
            }
            lsql = "Select /*+KEYSCAN*/ " + ls;
            lps = new TestPreparedStatement((TestCase)this, this.mMainConnection, lsql, this.mAlternativeMonitor, 1005, 1007);
            lps.execute();
            lReadsAlternative = this.mAlternativeMonitor.getNumberOfVirtualReads();
            if (lReadsOptimizer > lReadsAlternative) {
                this.addAlternativeStrategieMessage(this.mMainPreparedStatement, lReadsOptimizer, lps, lReadsAlternative);
            }
            this.mAlternativeMonitor.deactivate();
        }
        return result;
    }

    public static String getTestClassId() {
        return "SingleTableV74";
    }

    public static long getTimeout() {
        return 0L;
    }

    public static boolean isReferenceEnabled() {
        return false;
    }

    public static boolean isSAPOnly() {
        return true;
    }

    public static void prepare() throws TestCaseException {
        Connection lDefConnection = null;
        TestStatement lDefTstmt = null;
        TestPreparedStatement lp = null;
        try {
            sTableName = SingleTableV74.getParameterString((String)"Table_Name", (String)"ST").toUpperCase();
            int lDiffInteger = SingleTableV74.getParameterInt((String)"Different_Integer_Values", (int)50);
            int lDiffString = SingleTableV74.getParameterInt((String)"Different_String_Values", (int)50);
            int lDummyKeyLength = SingleTableV74.getParameterInt((String)"Length_of_Static_Key_Field", (int)3);
            sUser = SingleTableV74.getParameterString((String)"User_Name", (String)"ST");
            sPassword = SingleTableV74.getParameterString((String)"User_Password", (String)"ST");
            if (lDiffInteger * lDiffString < 1000) {
                throw new TestCaseException("Too few different integer or string values defined. Please choose a higher value for Different_Integer_Values and/or Different_String_Values");
            }
            if (lDiffInteger < 10) {
                throw new TestCaseException("Too few different integer values (minimum 10) defined. Please choose a higher value for Different_Integer_Values");
            }
            if (lDiffString < 10) {
                throw new TestCaseException("Too few different string values (minimum 10) defined. Please choose a higher value for Different_String_Values");
            }
            if (lDummyKeyLength < 1) {
                throw new TestCaseException("Cannot create table with a key field of length " + lDummyKeyLength + " (minimum 1)");
            }
            lDefConnection = SingleTableV74.getDatabase().connect(SingleTableV74.getUser(), SingleTableV74.getPassword());
            lDefTstmt = new TestStatement(null, lDefConnection);
            lDefTstmt.enableExceptions(false);
            lDefTstmt.executeUpdate("Create user " + sUser + " password " + sPassword + " dba not exclusive");
            lDefTstmt.close();
            lDefConnection.close();
            lDefConnection = SingleTableV74.getDatabase().connect(sUser, sPassword);
            lDefTstmt = new TestStatement(null, lDefConnection, 1005, 1007);
            lDefTstmt.enableExceptions(false);
            sTable = new Table(sTableName);
            sTable.setConnection(lDefConnection);
            String u = "u";
            StringBuffer su = new StringBuffer(lDummyKeyLength);
            for (int i = 0; i < lDummyKeyLength; ++i) {
                su.append(u);
            }
            sValueK0 = su.toString();
            StringBuffer sv = new StringBuffer(300);
            for (int i = 0; i < 300; ++i) {
                sv.append("d");
            }
            sValueFx = "'" + sv.toString() + "'";
            sTable.addVarchar("k0", lDummyKeyLength, true, false, false, SingleTableV74.buildK0());
            sTable.addInteger("k1", true, false, false, 0, 0, 0);
            sTable.addVarchar("k2", 14, true, false, false, null);
            sTable.addVarchar("f0", lDummyKeyLength, false, false, false, SingleTableV74.buildK0());
            sTable.addInteger("f1", false, false, false, 0, 0, 0);
            sTable.addVarchar("f2", 14, false, false, false, null);
            sTable.addInteger("f3", false, false, false, 0, 0, 0);
            sTable.addCharacter("f4", 300, false, false, false, sValueFx);
            sTable.addCharacter("f5", 300, false, false, false, sValueFx);
            sTable.addCharacter("f6", 300, false, false, false, sValueFx);
            String lMode = SingleTableV74.getParameterString((String)"Test_Data", (String)"CHECK");
            boolean lCreateNewTable = false;
            if (lMode.equals("KEEP")) {
                lCreateNewTable = false;
            } else if (lMode.equals("REBUILD")) {
                lCreateNewTable = true;
            } else {
                lDefTstmt.executeQuery("select count(distinct k1) from  " + sTableName);
                if (lDefTstmt.getResultCounter() != lDiffInteger) {
                    lCreateNewTable = true;
                } else {
                    lDefTstmt.executeQuery("select count(distinct k2) from  " + sTableName);
                    if (lDefTstmt.getResultCounter() != lDiffString) {
                        lCreateNewTable = true;
                    } else {
                        int llen;
                        String lss = "select len from columns where owner = '" + sUser + "' and  tablename = '" + sTable.getName() + "' and columnname = 'K0'";
                        ResultSet rs = lDefTstmt.executeQuery(lss);
                        if (rs != null && rs.next() && (llen = rs.getInt(1)) != lDummyKeyLength) {
                            lCreateNewTable = true;
                        }
                    }
                }
            }
            if (lCreateNewTable) {
                System.out.println("Creating new table...");
                SingleTableV74.addGlobalMessage((String)"prepare", (char)'I', (String)("Creating new table with " + lDiffInteger + " integers and " + lDiffString + " character values"));
                sTable.drop(false);
                lDefTstmt.enableExceptions(true);
                sTable.create();
                String s = "insert into  " + sTableName + " (k1,k2,f1,f2,f3) values (?,?,?,?,?)";
                lp = new TestPreparedStatement(null, lDefConnection, s);
                int k = 0;
                for (int j = 0; j < lDiffInteger; ++j) {
                    lp.setInt(1, j);
                    lp.setInt(3, j);
                    for (int i = 0; i < lDiffString; ++i) {
                        lp.setString(2, sValueK2 + K2_FORMAT.format(i));
                        lp.setString(4, sValueK2 + K2_FORMAT.format(i));
                        lp.setInt(5, k++);
                        lp.addBatch();
                    }
                    lp.executeBatch();
                    lp.clearBatch();
                    lDefConnection.commit();
                }
                lp.executeBatch();
                lDefConnection.commit();
                sTable.updateStatistics(lDefTstmt);
            }
        }
        catch (Exception e) {
            SingleTableV74.handleGlobalExceptions((Exception)e);
            throw new TestCaseException(e.getMessage());
        }
        finally {
            try {
                if (lp != null) {
                    lp.close();
                }
                if (lDefTstmt != null) {
                    lDefTstmt.close();
                }
                if (lDefConnection != null) {
                    lDefConnection.close();
                }
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() {
        Connection lConnection = null;
        try {
            this.mDiffInteger = SingleTableV74.getParameterInt((String)"Different_Integer_Values", (int)50);
            this.mDiffString = SingleTableV74.getParameterInt((String)"Different_String_Values", (int)50);
            this.mDropIndexesAfterBlockFinished = SingleTableV74.getParameterBoolean((String)"Drop_Indexes_After_Block_Finished", (boolean)true);
            if (!this.mDropIndexesAfterBlockFinished) {
                this.addMessage("Index drop", 'E', "Warning: Indexes were not dropped after a test block finished.\nIf more than one block will be executed, unexpected errors might occur!!!!");
            }
            this.mTableRows = this.mDiffInteger * this.mDiffString;
            this.setAutoStep(false);
            SingleTableV74.setInfoMessageFilter((boolean)false);
            this.mMainConnection = SingleTableV74.getDatabase().connect(sUser, sPassword);
            this.mMainConnection.setTransactionIsolation(1);
            lConnection = SingleTableV74.getDatabase().connect(sUser, sPassword);
            this.mHelpStatement = new TestStatement((TestCase)this, lConnection, 1005, 1007);
            this.mFinallyStatement = new TestStatement(null, lConnection);
            this.mMainMonitor = new TestStatementMonitor(this.mMainConnection);
            this.mMainMonitor.clear();
            this.mMainMonitor.activate();
            this.mMainExplainObject.addTable(sTableName);
            this.mMainExplainObject.addStrategy("Table Scan");
            this.mMainExplainObject.add();
            this.executePreparedStep("select * from  " + sTableName + " for reuse", this.mMainExplainObject, this.mTableRows, "Max");
            this.mMaxNoOfVirtualReads = this.mMainMonitor.getNumberOfVirtualReads();
            this.mMaxRuntime = this.mMainPreparedStatement.getRuntime();
            this.addMessage("Initial select", 'I', "Strategie: TABLE SCAN # virtual reads: " + this.mMainMonitor.getNumberOfVirtualReads() + " #records read: " + this.mMainPreparedStatement.getResultCounter(), this.mMainPreparedStatement.getSqlString());
            if (SingleTableV74.getParameterBoolean((String)"Print_All_Virtual_Reads_To_Protocol", (boolean)false)) {
                this.mMaxNoOfVirtualReads = 0;
                this.addMessage("Virtual Reads", 'I', "All virtual reads will be reported to protocol as a WARNING, because the max. of virtual reads is set to 0");
            }
            String lSteps = SingleTableV74.getParameterString((String)"Block_Sequence", (String)DEFAULT_BLOCK_SEQUENCE);
            StringTokenizer lSt = new StringTokenizer(lSteps, ";");
            Class<?> lThisClass = ((Object)((Object)this)).getClass();
            Method lTheMethod = null;
            this.mMethodName = null;
            while (lSt.hasMoreTokens()) {
                this.mMethodName = "block_" + lSt.nextToken().trim();
                System.out.println("Running method " + this.mMethodName + " ... ");
                try {
                    lTheMethod = lThisClass.getMethod(this.mMethodName, new Class[0]);
                }
                catch (NoSuchMethodException nme) {
                    this.addMessage("running step sequence", 'E', "Unknown method " + this.mMethodName + ". Maybe method is not public?", nme);
                }
                try {
                    lTheMethod.invoke((Object)this, new Object[0]);
                }
                catch (IllegalAccessException e) {
                    this.addMessage("running step sequence", 'E', "Invalid Step_Sequence " + lSteps + " Method " + lTheMethod.getName() + " is unknown!!!", e);
                }
                catch (IllegalArgumentException e) {
                    this.addMessage("running step sequence", 'E', "Invalid Step_Sequence " + lSteps + " Method " + lTheMethod.getName() + " is unknown!!!", e);
                }
                catch (InvocationTargetException e) {
                    throw (Exception)e.getTargetException();
                    return;
                }
            }
        }
        catch (Exception e) {
            this.handleExceptions(e);
            return;
        }
        finally {
            try {
                SingleTableV74.printParametersToProtocol();
                this.mMainMonitor.deactivate();
                this.mHelpStatement.close();
                lConnection.close();
                this.mMainPreparedStatement.close();
                this.mMainConnection.close();
            }
            catch (Exception exception) {}
        }
    }

    static {
        sValueK0 = null;
        sValueFx = null;
        sValueK2 = "String-";
        K2_FORMAT = new DecimalFormat("#####");
        K2_FORMAT.setMinimumIntegerDigits(5);
    }
}

