/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.optimizer;

import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.testcase.TestPreparedStatement;
import com.sap.sapdb.testframe.testcase.TestStatement;
import com.sap.sapdb.testframe.utilities.Session;
import com.sap.sapdb.testframe.utilities.SessionEndless;
import com.sap.sapdb.testframe.utilities.SessionManager;
import com.sap.sapdb.testframe.utilities.User;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.BitSet;
import java.util.Random;

public class MultiTableRandom
extends TestCase {
    private static String TabPrefix = null;
    private static String sTestUser = null;
    private static String sTestUserPassword = null;
    private static Thread sViewThread = null;
    private static Thread sIndexThread = null;
    private static Thread sUpdateThread = null;

    public static void cleanUp() {
        sIndexThread.interrupt();
        sUpdateThread.interrupt();
        sViewThread.interrupt();
    }

    public static String getTestClassId() {
        return "MultiTableRandom";
    }

    public static boolean isReferenceEnabled() {
        return false;
    }

    public static boolean isSAPOnly() {
        return false;
    }

    public static void prepare() throws TestCaseException {
        Connection lConnection = null;
        TestStatement stmt = null;
        try {
            int i;
            sTestUser = MultiTableRandom.getParameterString((String)"User_Name", (String)"MTR").toUpperCase();
            sTestUserPassword = MultiTableRandom.getParameterString((String)"User_Password", (String)"MTR").toUpperCase();
            TabPrefix = MultiTableRandom.getParameterString((String)"Table_Name_Prefix", (String)"MTR_").toUpperCase();
            int lRandomInit = MultiTableRandom.getParameterInt((String)"Random_Init", (int)-1);
            int lNoOfTables = MultiTableRandom.getParameterInt((String)"No_Of_Tables", (int)10);
            int lNoOfTabRows = MultiTableRandom.getParameterInt((String)"No_Of_Table_Rows", (int)2500);
            boolean lAutoCommit = MultiTableRandom.getParameterBoolean((String)"Auto_Commit", (boolean)true);
            Session.setTraceSQLSequence((boolean)true);
            lConnection = MultiTableRandom.getDatabase().connect(MultiTableRandom.getUser(), MultiTableRandom.getPassword());
            Statement s1 = lConnection.createStatement();
            try {
                s1.execute("Create user " + sTestUser + " password " + sTestUserPassword + " resource not exclusive");
            }
            catch (SQLException e) {
                // empty catch block
            }
            lConnection.commit();
            s1.close();
            lConnection.close();
            lConnection = MultiTableRandom.getDatabase().connect(sTestUser, sTestUserPassword);
            lConnection.setAutoCommit(false);
            stmt = new TestStatement(null, lConnection, 1005, 1007);
            Random r = lRandomInit == -1 ? new Random() : new Random(lRandomInit);
            MultiTableRandom.addGlobalMessage((String)"prepare", (char)'I', (String)("Randomgenerator initialized with " + lRandomInit));
            if (lNoOfTables <= 2) {
                lNoOfTables = 3;
            }
            stmt.enableExceptions(false);
            boolean lNewTables = false;
            stmt.executeQuery("Select * from tables where owner = '" + sTestUser + "' and tablename like '" + TabPrefix + "%'");
            if (stmt.getResultCounter() < lNoOfTables) {
                lNewTables = true;
            } else {
                stmt.executeQuery("Select count(*) from " + TabPrefix + "0");
                if (stmt.getResultCounter() != lNoOfTabRows) {
                    lNewTables = true;
                }
            }
            if (lNewTables) {
                MultiTableRandom.addGlobalMessage((String)"prepare", (char)'I', (String)("Creating " + lNoOfTables + " tables"));
                TabFiller[] tf = new TabFiller[lNoOfTables];
                Connection[] ac = new Connection[tf.length];
                for (i = 0; i < lNoOfTables; ++i) {
                    ac[i] = MultiTableRandom.getDatabase().connect(sTestUser, sTestUserPassword);
                    ac[i].setAutoCommit(lAutoCommit);
                    tf[i] = new TabFiller(null, ac[i], i, lNoOfTabRows, lNoOfTables);
                    tf[i].start();
                }
                boolean oneIsAlive = true;
                boolean oneIsInterrupted = false;
                int mInterruptNo = 0;
                block26: while (oneIsAlive) {
                    Thread.sleep(2000L);
                    oneIsAlive = false;
                    for (int i2 = 0; i2 < lNoOfTables; ++i2) {
                        if (tf[i2].isAlive()) {
                            oneIsAlive = true;
                            continue block26;
                        }
                        try {
                            ac[i2].commit();
                        }
                        catch (SQLException e) {
                            // empty catch block
                        }
                        try {
                            ac[i2].close();
                        }
                        catch (SQLException e) {
                            // empty catch block
                        }
                        if (!tf[i2].isInterrupted()) continue;
                        oneIsInterrupted = true;
                        mInterruptNo = i2;
                        continue block26;
                    }
                }
                if (oneIsInterrupted) {
                    for (int k = 0; k < ac.length; ++k) {
                        try {
                            if (ac[k].isClosed()) continue;
                            ac[k].close();
                            continue;
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    throw new TestCaseException(tf[mInterruptNo].getException().getMessage());
                }
            } else {
                MultiTableRandom.addGlobalMessage((String)"prepare", (char)'I', (String)"Creation of tables not neccessary. Can use existing tables and contents");
            }
            int lBoarder = lNoOfTables / 2;
            if (MultiTableRandom.getParameterBoolean((String)"Parallel_Index_Thread", (boolean)true)) {
                MultiTableRandom.addGlobalMessage((String)"prepare", (char)'I', (String)"Start of dummy index thread on irrelevant field combination");
                String[] lIndexSql = new String[(lNoOfTables - lBoarder) * 2];
                for (i = 0; i < lNoOfTables - lBoarder; ++i) {
                    int lTabNo = i + lBoarder;
                    lIndexSql[2 * i + 0] = "drop index x" + lTabNo + " on " + TabPrefix + lTabNo;
                    lIndexSql[2 * i + 1] = "create index x" + lTabNo + " on " + TabPrefix + lTabNo + " (indexField1, indexField2, k0, k2, f0)";
                }
                SessionEndless lSession1 = new SessionEndless((TestCase)null, new User(MultiTableRandom.getDatabase(), sTestUser, sTestUserPassword), lIndexSql, -1);
                lSession1.setStopWhenSQLExceptionOccurs(false);
                lSession1.setIsolationLevel(1);
                sIndexThread = new Thread((Runnable)lSession1);
                sIndexThread.setDaemon(true);
                sIndexThread.setPriority(1);
                sIndexThread.start();
            }
            if (MultiTableRandom.getParameterBoolean((String)"Parallel_Update_Thread", (boolean)true)) {
                MultiTableRandom.addGlobalMessage((String)"prepare", (char)'I', (String)"Start of dummy update thread on irrelevant fields");
                String[] lUpdateSql = new String[lBoarder * 2];
                for (int i3 = 0; i3 < lBoarder; ++i3) {
                    lUpdateSql[2 * i3 + 0] = "update " + TabPrefix + i3 + " set indexField2 = 'update_" + r.nextInt() + "'";
                    lUpdateSql[2 * i3 + 1] = "update " + TabPrefix + i3 + " set indexField1 = " + r.nextInt() + " where k2 > " + r.nextInt(lNoOfTabRows - 2);
                }
                SessionEndless lSession2 = new SessionEndless((TestCase)null, new User(MultiTableRandom.getDatabase(), sTestUser, sTestUserPassword), lUpdateSql, -1);
                lSession2.setStopWhenSQLExceptionOccurs(false);
                lSession2.setIsolationLevel(1);
                sUpdateThread = new Thread((Runnable)lSession2);
                sUpdateThread.setDaemon(true);
                sUpdateThread.setPriority(1);
                sUpdateThread.start();
            }
            if (MultiTableRandom.getParameterBoolean((String)"Parallel_View_Thread", (boolean)true) && !MultiTableRandom.getParameterBoolean((String)"Index_Thread", (boolean)true)) {
                MultiTableRandom.addGlobalMessage((String)"prepare", (char)'I', (String)"Start of dummy view creator thread on irrelevant fields");
                String[] lViewSql = new String[lNoOfTables * 2];
                for (int i4 = 0; i4 < lNoOfTables; ++i4) {
                    lViewSql[2 * i4 + 0] = "create or replace view V_" + TabPrefix + i4 + " as select k1, k0, indexField2 from " + TabPrefix + i4 + " where k1 < " + r.nextInt() % 10;
                    lViewSql[2 * i4 + 1] = "select * from V_" + TabPrefix + i4;
                }
                SessionEndless lSession3 = new SessionEndless((TestCase)null, new User(MultiTableRandom.getDatabase(), sTestUser, sTestUserPassword), lViewSql, -1);
                lSession3.setStopWhenSQLExceptionOccurs(false);
                lSession3.setTraceSQLSession(false);
                lSession3.setIsolationLevel(1);
                sViewThread = new Thread((Runnable)lSession3);
                sViewThread.setDaemon(true);
                sViewThread.setPriority(1);
                sViewThread.start();
            }
        }
        catch (Exception e) {
            throw new TestCaseException("Preparation of " + MultiTableRandom.getTestClassId() + " failed. Exception: " + e.getClass() + " . Message: " + e.getMessage());
        }
        finally {
            try {
                lConnection.commit();
            }
            catch (Exception e) {}
            try {
                stmt.close();
            }
            catch (Exception e) {}
            try {
                lConnection.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Connection lConnection = null;
        TestStatement stmt = null;
        try {
            int lRandomInit = MultiTableRandom.getParameterInt((String)"Random_Init", (int)-1);
            int lNoOfTables = MultiTableRandom.getParameterInt((String)"No_Of_Tables", (int)10);
            int lNoOfTabRows = MultiTableRandom.getParameterInt((String)"No_Of_Table_Rows", (int)2500);
            int lNoOfJoins = MultiTableRandom.getParameterInt((String)"No_Of_Joins", (int)(lNoOfTables - 1));
            this.setAutoStep(false);
            lConnection = MultiTableRandom.getDatabase().connect(sTestUser, sTestUserPassword);
            stmt = new TestStatement((TestCase)this, lConnection, 1005, 1007);
            Random r = lRandomInit == -1 ? new Random() : new Random(lRandomInit);
            this.setAutoStep(true);
            for (int repeats = 0; repeats < MultiTableRandom.getParameterInt((String)"No_Of_Repeats", (int)1); ++repeats) {
                System.out.println("Running sequence no " + repeats);
                r = lRandomInit == -1 ? new Random() : new Random(lRandomInit);
                this.addMessage("Random init", 'I', "Randomgenerator initialized with: " + lRandomInit);
                for (int k = 1; k <= lNoOfJoins; ++k) {
                    int j;
                    System.out.println("Starting to join " + k + " tables...");
                    this.addMessage("Sequence start", 'I', "Starting to join " + k + " tables.");
                    int[] lTabSet = new int[lNoOfJoins];
                    BitSet lBitSet = new BitSet();
                    int i = 0;
                    while (i < k) {
                        j = r.nextInt(lNoOfTables);
                        if (lBitSet.get(j)) continue;
                        lBitSet.set(j);
                        lTabSet[i] = j;
                        ++i;
                    }
                    String lsql = "select ";
                    for (i = 0; i < k; ++i) {
                        lsql = lsql + TabPrefix + lTabSet[i] + ".k1 " + "K1_" + lTabSet[i] + ", " + TabPrefix + lTabSet[i] + ".k2 " + "K2_" + lTabSet[i] + ", " + TabPrefix + lTabSet[i] + ".f0 " + "F0_" + lTabSet[i] + ", " + TabPrefix + lTabSet[i] + ".f1 " + "F1_" + lTabSet[i] + ", " + TabPrefix + lTabSet[i] + ".f2 " + "F2_" + lTabSet[i];
                        if (i >= k - 1) continue;
                        lsql = lsql + ", ";
                    }
                    lsql = lsql + " from ";
                    for (i = 0; i < k; ++i) {
                        lsql = lsql + TabPrefix + lTabSet[i];
                        if (i >= k - 1) continue;
                        lsql = lsql + ", ";
                    }
                    String lsql1 = lsql;
                    if (k > 1) {
                        lsql1 = lsql1 + " where ";
                        for (i = 0; i < k - 1; ++i) {
                            lsql1 = lsql1 + TabPrefix + lTabSet[i] + ".k2 = " + TabPrefix + lTabSet[i + 1] + ".f2";
                            if (i >= k - 2) continue;
                            lsql1 = lsql1 + " and ";
                        }
                    }
                    lsql1 = lsql1.trim();
                    User lUser = new User(MultiTableRandom.getDatabase(), sTestUser, sTestUserPassword);
                    SessionManager lSManager = new SessionManager(true);
                    lSManager.setIsolationLevel(1);
                    lSManager.runSessionChecked((TestCase)this, lUser, lsql1, lNoOfTabRows);
                    String lsql2 = lsql;
                    if (k > 1) {
                        lsql2 = lsql2 + " where ";
                        for (i = 0; i < k - 1; ++i) {
                            lsql2 = lsql2 + TabPrefix + lTabSet[i] + ".f1 = " + TabPrefix + lTabSet[i + 1] + ".k1";
                            if (i >= k - 2) continue;
                            lsql2 = lsql2 + " and ";
                        }
                    }
                    lsql2 = lsql2.trim();
                    lSManager.runSessionChecked((TestCase)this, lUser, lsql1, lNoOfTabRows);
                    if (k <= 1) {
                        this.addMessage("Sequence end", 'I', k + " tables successfully joined.");
                        lSManager.joinAllSessions();
                        continue;
                    }
                    i = r.nextInt(k);
                    j = r.nextInt(lNoOfTabRows);
                    if (j == 0) {
                        ++j;
                    }
                    String lsql3 = lsql1 + " and " + TabPrefix + lTabSet[i] + ".k1 = " + j;
                    lSManager.runSessionChecked((TestCase)this, lUser, lsql3, 1);
                    lsql3 = lsql3 + " and " + TabPrefix + lTabSet[i] + ".k2 = " + (lNoOfTabRows - j);
                    lSManager.runSessionChecked((TestCase)this, lUser, lsql3, 1);
                    lsql3 = lsql3 + " and " + TabPrefix + lTabSet[i] + ".f2 = " + (lNoOfTabRows - j);
                    lSManager.runSessionChecked((TestCase)this, lUser, lsql3, 1);
                    i = r.nextInt(k);
                    j = r.nextInt(lNoOfTabRows);
                    if (j == 0) {
                        ++j;
                    }
                    lsql3 = lsql1 + " and " + TabPrefix + lTabSet[i] + ".k2 = " + j;
                    lSManager.runSessionChecked((TestCase)this, lUser, lsql3, 1);
                    lsql3 = lsql3 + " and " + TabPrefix + lTabSet[i] + ".k1 = " + (lNoOfTabRows - j);
                    lSManager.runSessionChecked((TestCase)this, lUser, lsql3, 1);
                    lsql3 = lsql3 + " and " + TabPrefix + lTabSet[i] + ".f1 = " + (lNoOfTabRows - j);
                    lSManager.runSessionChecked((TestCase)this, lUser, lsql3, 1);
                    i = r.nextInt(k);
                    j = r.nextInt(k);
                    while (j == i) {
                        j = r.nextInt(k);
                    }
                    int l = r.nextInt(lNoOfTabRows);
                    if (l == 0) {
                        ++l;
                    }
                    lsql3 = lsql1 + " and ( " + TabPrefix + lTabSet[i] + ".k1 = " + l + " or " + TabPrefix + lTabSet[j] + ".f1 = " + l + " ) ";
                    lSManager.runSessionChecked((TestCase)this, lUser, lsql3, 1);
                    lsql3 = lsql1 + " and ( " + TabPrefix + lTabSet[i] + ".k1 = " + l + " or " + TabPrefix + lTabSet[j] + ".f1 = " + l + " or " + TabPrefix + lTabSet[i] + ".k2 = " + (lNoOfTabRows - l) + " ) ";
                    lSManager.runSessionChecked((TestCase)this, lUser, lsql3, 1);
                    lsql3 = lsql1 + " and ( " + TabPrefix + lTabSet[i] + ".k1 = " + l + " or " + TabPrefix + lTabSet[j] + ".f1 = " + l + " or " + TabPrefix + lTabSet[i] + ".k2 = " + (lNoOfTabRows - l) + " or " + TabPrefix + lTabSet[j] + ".f2 = " + (lNoOfTabRows - l) + " ) ";
                    lSManager.runSessionChecked((TestCase)this, lUser, lsql3, 1);
                    i = r.nextInt(k);
                    j = r.nextInt(lNoOfTabRows);
                    if (j == 0) {
                        ++j;
                    }
                    String lsql4 = lsql2 + " and " + TabPrefix + lTabSet[i] + ".k1 = " + j;
                    lSManager.runSessionChecked((TestCase)this, lUser, lsql4, 1);
                    lsql4 = lsql2 + " and " + TabPrefix + lTabSet[i] + ".k2 = " + (lNoOfTabRows - j);
                    lSManager.runSessionChecked((TestCase)this, lUser, lsql4, 1);
                    lsql4 = lsql2 + " and " + TabPrefix + lTabSet[i] + ".f2 = " + (lNoOfTabRows - j);
                    lSManager.runSessionChecked((TestCase)this, lUser, lsql4, 1);
                    i = r.nextInt(k);
                    j = r.nextInt(lNoOfTabRows);
                    if (j == 0) {
                        ++j;
                    }
                    lsql4 = lsql2 + " and " + TabPrefix + lTabSet[i] + ".k2 = " + j;
                    lSManager.runSessionChecked((TestCase)this, lUser, lsql4, 1);
                    lsql4 = lsql4 + " and " + TabPrefix + lTabSet[i] + ".k1 = " + (lNoOfTabRows - j);
                    lSManager.runSessionChecked((TestCase)this, lUser, lsql4, 1);
                    lsql4 = lsql4 + " and " + TabPrefix + lTabSet[i] + ".f1 = " + (lNoOfTabRows - j);
                    lSManager.runSessionChecked((TestCase)this, lUser, lsql4, 1);
                    i = r.nextInt(k);
                    j = r.nextInt(k);
                    while (j == i) {
                        j = r.nextInt(k);
                    }
                    l = r.nextInt(lNoOfTabRows);
                    if (l == 0) {
                        ++l;
                    }
                    lsql4 = lsql2 + " and ( " + TabPrefix + lTabSet[i] + ".k2 = " + l + " or " + TabPrefix + lTabSet[j] + ".f2 = " + l + " ) ";
                    lSManager.runSessionChecked((TestCase)this, lUser, lsql4, 1);
                    lsql4 = lsql2 + " and ( " + TabPrefix + lTabSet[i] + ".k2 = " + l + " or " + TabPrefix + lTabSet[j] + ".f2 = " + l + " or " + TabPrefix + lTabSet[i] + ".k1 = " + (lNoOfTabRows - l) + " ) ";
                    lSManager.runSessionChecked((TestCase)this, lUser, lsql4, 1);
                    lsql4 = lsql2 + " and ( " + TabPrefix + lTabSet[i] + ".k2 = " + l + " or " + TabPrefix + lTabSet[j] + ".f2 = " + l + " or " + TabPrefix + lTabSet[i] + ".k2 = " + (lNoOfTabRows - l) + " or " + TabPrefix + lTabSet[j] + ".f2 = " + (lNoOfTabRows - l) + " ) ";
                    lSManager.runSessionChecked((TestCase)this, lUser, lsql4, 2);
                    i = r.nextInt(k);
                    j = r.nextInt(lNoOfTabRows - 15);
                    if (j == 0) {
                        ++j;
                    }
                    lsql3 = lsql1 + " and " + TabPrefix + lTabSet[i] + ".f2 >= " + j;
                    lsql3 = lsql3 + " and " + TabPrefix + lTabSet[i] + ".f2 <= " + (j + 10);
                    lSManager.runSessionChecked((TestCase)this, lUser, lsql3, 11);
                    i = r.nextInt(k);
                    j = r.nextInt(lNoOfTabRows - 25);
                    if (j == 0) {
                        ++j;
                    }
                    lsql3 = lsql1 + " and " + TabPrefix + lTabSet[i] + ".f1 >= " + j;
                    lsql3 = lsql3 + " and " + TabPrefix + lTabSet[i] + ".f1 <= " + (j + 20);
                    lSManager.runSessionChecked((TestCase)this, lUser, lsql3, 21);
                    i = r.nextInt(k);
                    j = r.nextInt(lNoOfTabRows - 15);
                    if (j == 0) {
                        ++j;
                    }
                    lsql4 = lsql2 + " and " + TabPrefix + lTabSet[i] + ".k2 >= " + j;
                    lsql4 = lsql4 + " and " + TabPrefix + lTabSet[i] + ".k2 <= " + (j + 10);
                    lSManager.runSessionChecked((TestCase)this, lUser, lsql4, 11);
                    i = r.nextInt(k);
                    j = r.nextInt(lNoOfTabRows - 25);
                    if (j == 0) {
                        ++j;
                    }
                    lsql4 = lsql2 + " and " + TabPrefix + lTabSet[i] + ".k1 >= " + j;
                    lsql4 = lsql4 + " and " + TabPrefix + lTabSet[i] + ".k1 <= " + (j + 20);
                    lSManager.runSessionChecked((TestCase)this, lUser, lsql4, 21);
                    int ladd = lNoOfTabRows % 2;
                    i = r.nextInt(k);
                    l = r.nextInt(k);
                    while (l == i) {
                        l = r.nextInt(k);
                    }
                    lsql3 = lsql1 + " and " + TabPrefix + lTabSet[i] + ".k1 = " + TabPrefix + lTabSet[l] + ".f2+" + ladd;
                    lSManager.runSessionChecked((TestCase)this, lUser, lsql3, 1);
                    i = r.nextInt(k);
                    while (l == i) {
                        l = r.nextInt(k);
                    }
                    lsql3 = lsql1 + " and " + TabPrefix + lTabSet[i] + ".f2 = " + TabPrefix + lTabSet[l] + ".k1+" + ladd;
                    lSManager.runSessionChecked((TestCase)this, lUser, lsql3, 1);
                    i = r.nextInt(k);
                    while (l == i) {
                        l = r.nextInt(k);
                    }
                    lsql4 = lsql2 + " and " + TabPrefix + lTabSet[i] + ".k2 = " + TabPrefix + lTabSet[l] + ".f1+" + ladd;
                    lSManager.runSessionChecked((TestCase)this, lUser, lsql4, 1);
                    i = r.nextInt(k);
                    while (l == i) {
                        l = r.nextInt(k);
                    }
                    lsql4 = lsql2 + " and " + TabPrefix + lTabSet[i] + ".f1 = " + TabPrefix + lTabSet[l] + ".k2+" + ladd;
                    lSManager.runSessionChecked((TestCase)this, lUser, lsql4, 1);
                    int li = 5;
                    lsql3 = lsql1 + " and " + TabPrefix + lTabSet[i] + ".k0 like '%" + li + "'";
                    int lCount = lNoOfTabRows / 10;
                    if (lNoOfTabRows % 10 > li) {
                        ++lCount;
                    }
                    lSManager.runSessionChecked((TestCase)this, lUser, lsql3, lCount);
                    li = 8;
                    lsql4 = lsql2 + " and " + TabPrefix + lTabSet[i] + ".f0 like '%" + li + "'";
                    lCount = lNoOfTabRows / 10;
                    if (lNoOfTabRows % 10 > li) {
                        ++lCount;
                    }
                    lSManager.runSessionChecked((TestCase)this, lUser, lsql4, lCount);
                    lSManager.joinAllSessions();
                    this.addMessage("Sequence end", 'I', k + " tables successfully joined.");
                }
            }
            this.storeResultObject();
            lConnection.commit();
        }
        catch (Exception e) {
            this.handleExceptions(e);
        }
        finally {
            MultiTableRandom.printParametersToProtocol();
            try {
                lConnection.commit();
            }
            catch (Exception e) {}
            try {
                stmt.close();
            }
            catch (Exception e) {}
            try {
                lConnection.close();
            }
            catch (Exception exception) {}
        }
    }

    private static class TabFiller
    extends Thread {
        private int mTabIndex;
        private int mTabRows;
        private int mRand;
        private TestCase mTestCase;
        private Connection mConnection;
        private boolean mInterrupt;
        private Exception mException = null;

        public TabFiller(TestCase pTestCase, Connection pConnection, int pTabIndex, int pTabRows, int pRand) {
            this.mTabIndex = pTabIndex;
            this.mTabRows = pTabRows;
            this.mRand = pRand;
            this.mTestCase = pTestCase;
            this.mConnection = pConnection;
            this.mInterrupt = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            TestPreparedStatement pstmt = null;
            TestStatement stmt = null;
            try {
                stmt = new TestStatement(this.mTestCase, this.mConnection, 1005, 1007);
                stmt.enableExceptions(false);
                stmt.execute("Drop table " + TabPrefix + this.mTabIndex);
                stmt.enableExceptions(true);
                String lsql = "create table " + TabPrefix + this.mTabIndex + " (k0 char(4), k1 int, k2 int, f0 char(5), f1 int, f2 int, indexField1 int, indexField2 char(20), primary key(k0,k1,k2))";
                stmt.execute(lsql);
                lsql = "create index i1 on " + TabPrefix + this.mTabIndex + " (k1)";
                stmt.execute(lsql);
                lsql = "create index i2 on " + TabPrefix + this.mTabIndex + " (k2)";
                stmt.execute(lsql);
                lsql = "create index i3 on " + TabPrefix + this.mTabIndex + " (f2,f1,k2)";
                stmt.execute(lsql);
                Random r = new Random(this.mRand);
                System.out.println("Filling table " + TabPrefix + this.mTabIndex + " with " + this.mTabRows + " entries");
                lsql = "insert " + TabPrefix + this.mTabIndex + " (k0, k1, k2, f0, f1, f2, indexField1, indexField2 ) values (?, ?, ?, ?, ?, ?, ?, ?)";
                pstmt = new TestPreparedStatement(this.mTestCase, this.mConnection, lsql);
                for (int j = 0; j < this.mTabRows; ++j) {
                    int x = r.nextInt(10000);
                    int k = this.mTabRows - j;
                    pstmt.setString(1, "Key" + j % 10);
                    pstmt.setInt(2, k);
                    pstmt.setInt(3, j);
                    pstmt.setString(4, "Data" + j % 10);
                    pstmt.setInt(5, k);
                    pstmt.setInt(6, j);
                    pstmt.setInt(7, x);
                    pstmt.setString(8, "Index_" + x % 100);
                    pstmt.addBatch();
                    if (j % 1000 == 0) {
                        pstmt.executeBatch();
                    }
                    pstmt.clearBatch();
                }
                pstmt.executeBatch();
                lsql = "update statistics " + TabPrefix + this.mTabIndex;
                stmt = new TestStatement(this.mTestCase, this.mConnection, 1005, 1007);
                stmt.execute(lsql);
                lsql = "update statistics column (*) for " + TabPrefix + this.mTabIndex;
                stmt.execute(lsql);
            }
            catch (Exception e) {
                this.mInterrupt = true;
                this.mException = e;
            }
            finally {
                try {
                    pstmt.close();
                }
                catch (Exception e) {}
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
            }
        }

        public boolean isInterrupted() {
            return this.mInterrupt;
        }

        public Exception getException() {
            return this.mException;
        }
    }
}

