/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.netweaver;

import com.sap.dbtech.powertoys.DBM;
import com.sap.dbtech.rte.comm.RTEException;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDatabaseSap;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.utilities.Execute;
import com.sap.sapdb.testframe.utilities.Zipper;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;

public class DTRTest
extends TestCase {
    private static DBM mDBMan = null;
    private static String sapcontrolPath = "";
    private static String opt_protocol = "";
    private static String opt_user;
    private static String opt_instance;
    private static String opt_host;
    private static int sapcontrolTimeout;
    private static int dtrTimeout;
    private static ArrayList logFileList;
    private static String dbHostName;
    private static String dtrtestsPath;
    private static String dtrtestsAntPath;
    private static String serverPath;
    private static String instanceNr;
    private static String instanceName;
    private static String nwHostName;
    private static String keyPhrase;
    private static String nwdbPassword;

    public static void prepare() throws TestCaseException {
        long sysTime;
        String methodName = "Method prepare()";
        serverPath = DTRTest.getParameterString((String)"nw.server_path", (String)"");
        instanceNr = DTRTest.getParameterString((String)"nw.instance_nr", (String)"");
        instanceName = DTRTest.getParameterString((String)"nw.instance_name", (String)"");
        nwHostName = DTRTest.getParameterString((String)"nw.hostname", (String)"");
        keyPhrase = DTRTest.getParameterString((String)"nw.secustore.keyphrase", (String)"");
        nwdbPassword = DTRTest.getParameterString((String)"nw.db.connection.password", (String)"");
        String string = opt_protocol = DTRTest.getParameterString((String)"nw.sapcontrol.protocol", (String)"").equals("") ? "" : " -prot " + DTRTest.getParameterString((String)"nw.sapcontrol.protocol", (String)"");
        if (!DTRTest.getParameterString((String)"nw.sapcontrol.password", (String)"").equals("") && !DTRTest.getParameterString((String)"nw.sapcontrol.user", (String)"").equals("")) {
            opt_user = " -user " + DTRTest.getParameterString((String)"nw.sapcontrol.user", (String)"") + " " + DTRTest.getParameterString((String)"nw.sapcontrol.password", (String)"");
        }
        opt_instance = " -nr " + instanceNr;
        opt_host = " -host " + nwHostName;
        TestDatabaseSap db = (TestDatabaseSap)DTRTest.getDatabase();
        dbHostName = db.getHostName();
        sapcontrolPath = serverPath + File.separator + instanceName + File.separator + "JC" + instanceNr + File.separator + "exe" + File.separator;
        sapcontrolTimeout = DTRTest.getParameterInt((String)"nw.sapcontrol.timeout", (int)600);
        dtrTimeout = DTRTest.getParameterInt((String)"dtr.tests.timeout", (int)6000);
        dtrtestsPath = DTRTest.getParameterString((String)"dtr.tests.path", (String)"");
        dtrtestsAntPath = dtrtestsPath + File.separator + "ant";
        String dtrtestsConfigPath = dtrtestsPath + File.separator + "config";
        File dtrDir = new File(dtrtestsPath);
        File dtrDirAnt = new File(dtrtestsAntPath);
        File dtrDirConfig = new File(dtrtestsConfigPath);
        if (!dtrDir.isDirectory()) {
            DTRTest.addGlobalMessage((String)methodName, (char)'E', (String)"wrong entry for dtr.test.path - directory does not exist.");
        }
        if (!dtrDirAnt.isDirectory()) {
            DTRTest.addGlobalMessage((String)methodName, (char)'E', (String)("directory " + dtrtestsAntPath + "does not exist."));
        }
        if (!dtrDirConfig.isDirectory()) {
            DTRTest.addGlobalMessage((String)methodName, (char)'E', (String)("directory " + dtrtestsConfigPath + "does not exist"));
        }
        int logFileNr = 1;
        logFileList = new ArrayList();
        while (!DTRTest.getParameterString((String)("dtr.tests.logfile" + logFileNr), (String)"").equals("")) {
            logFileList.add(new File(dtrtestsAntPath + File.separator + DTRTest.getParameterString((String)("dtr.tests.logfile" + logFileNr), (String)"")));
            ++logFileNr;
        }
        String cmd = "";
        if (DTRTest.getParameterString((String)"tf.nw.stopfirst", (String)"yes").equals("yes")) {
            DTRTest.addGlobalMessage((String)methodName, (char)'I', (String)"stop server");
            cmd = sapcontrolPath + "sapcontrol.exe" + opt_protocol + opt_user + opt_host + opt_instance + " -function StopWait " + sapcontrolTimeout + " 0";
            DTRTest.executeCmd(cmd, sapcontrolTimeout);
        }
        if (DTRTest.getParameterString((String)"tf.db.loadbackup", (String)"yes").equals("yes")) {
            DTRTest.addGlobalMessage((String)methodName, (char)'I', (String)"load backup data to db");
            System.out.println("Load backup...");
            try {
                cmd = "backup_media_put RECOVER " + DTRTest.getParameterString((String)"db.backup_medium", (String)"") + " FILE DATA";
                DTRTest.executeDBMCmd(cmd);
                cmd = "db_admin";
                DTRTest.executeDBMCmd(cmd);
                cmd = "util_connect";
                DTRTest.executeDBMCmd(cmd);
                cmd = "db_activate RECOVER RECOVER DATA";
                DTRTest.executeDBMCmd(cmd);
                cmd = "util_release";
                DTRTest.executeDBMCmd(cmd);
                cmd = "db_online";
                DTRTest.executeDBMCmd(cmd);
                cmd = "load_systab -u " + DTRTest.getDatabase().getDBAUser() + "," + DTRTest.getDatabase().getDBAPassword();
                DTRTest.executeDBMCmd(cmd);
            }
            catch (TestDatabaseException tde) {
                DTRTest.addGlobalMessage((String)methodName, (char)'E', (String)("Exception : " + tde.getMessage()), (Exception)((Object)tde), (String)"");
                tde.printStackTrace();
                return;
            }
        }
        if (DTRTest.getParameterString((String)"tf.nw.changedb", (String)"yes").equals("yes")) {
            DTRTest.addGlobalMessage((String)methodName, (char)'I', (String)"changing db for netweaver");
            DTRTest.addGlobalMessage((String)methodName, (char)'I', (String)"1. rename old SecStore.properties file");
            File secStore = new File(serverPath + File.separator + instanceName + File.separator + "SYS" + File.separator + "global" + File.separator + "security" + File.separator + "data" + File.separator + "SecStore.properties");
            sysTime = System.currentTimeMillis();
            File secStoreNew = new File(serverPath + File.separator + instanceName + File.separator + "SYS" + File.separator + "global" + File.separator + "security" + File.separator + "data" + File.separator + "SecStore_" + sysTime + ".properties");
            if (secStore.exists()) {
                if (secStore.renameTo(secStoreNew)) {
                    DTRTest.addGlobalMessage((String)methodName, (char)'I', (String)("SecStore.properties renamed to SecStore_" + sysTime + ".properties"));
                } else {
                    DTRTest.addGlobalMessage((String)methodName, (char)'E', (String)"SecStore.properties file couldn't be renamed.");
                }
            } else {
                DTRTest.addGlobalMessage((String)methodName, (char)'I', (String)"Couldn't find file SecStore.properties.");
            }
            DTRTest.addGlobalMessage((String)methodName, (char)'I', (String)"2. generate file SecStore.properties");
            String jars = serverPath + File.separator + instanceName + File.separator + "SYS" + File.separator + "global" + File.separator + "security" + File.separator + "lib" + File.separator + "engine" + File.separator + "iaik_jce.jar;" + serverPath + File.separator + instanceName + File.separator + "SYS" + File.separator + "global" + File.separator + "security" + File.separator + "lib" + File.separator + "tools" + File.separator + "iaik_jsse.jar;" + serverPath + File.separator + instanceName + File.separator + "SYS" + File.separator + "global" + File.separator + "security" + File.separator + "lib" + File.separator + "tools" + File.separator + "iaik_smime.jar;" + serverPath + File.separator + instanceName + File.separator + "SYS" + File.separator + "global" + File.separator + "security" + File.separator + "lib" + File.separator + "tools" + File.separator + "iaik_ssl.jar;" + serverPath + File.separator + instanceName + File.separator + "SYS" + File.separator + "global" + File.separator + "security" + File.separator + "lib" + File.separator + "tools" + File.separator + "w3c_http.jar;" + serverPath + File.separator + instanceName + File.separator + "JC" + instanceNr + File.separator + "j2ee" + File.separator + "configtool" + File.separator + "lib" + File.separator + "exception.jar;" + serverPath + File.separator + instanceName + File.separator + "JC" + instanceNr + File.separator + "j2ee" + File.separator + "configtool" + File.separator + "lib" + File.separator + "logging.jar;" + serverPath + File.separator + instanceName + File.separator + "JC" + instanceNr + File.separator + "j2ee" + File.separator + "configtool" + File.separator + "lib" + File.separator + "tc_sec_secstorefs.jar;" + serverPath + File.separator + instanceName + File.separator + "JC" + instanceNr + File.separator + "j2ee" + File.separator + "admin" + File.separator + "lib" + File.separator + "opensqlsta.jar;" + serverPath + File.separator + instanceName + File.separator + "JC" + instanceNr + File.separator + "j2ee" + File.separator + "configtool" + File.separator + "lib" + File.separator + "jdbc20.jar";
            cmd = "java -classpath " + serverPath + File.separator + instanceName + File.separator + "JC" + instanceNr + File.separator + "j2ee" + File.separator + "configtool" + File.separator + "lib" + File.separator + "launcher.jar -Xmx256m com.sap.engine.offline.OfflineToolStart com.sap.security.core.server.secstorefs.SecStoreFS " + jars + " create -s " + instanceName + " -f " + serverPath + File.separator + instanceName + File.separator + "SYS" + File.separator + "global" + File.separator + "security" + File.separator + "data" + File.separator + "SecStore.properties -k " + serverPath + File.separator + instanceName + File.separator + "SYS" + File.separator + "global" + File.separator + "security" + File.separator + "data" + File.separator + "SecStore.key -enc -p " + keyPhrase;
            DTRTest.executeCmd(cmd, sapcontrolTimeout);
            cmd = "java -classpath " + serverPath + File.separator + instanceName + File.separator + "JC" + instanceNr + File.separator + "j2ee" + File.separator + "configtool" + File.separator + "lib" + File.separator + "launcher.jar -Xmx256m com.sap.engine.offline.OfflineToolStart com.sap.sql.connect.OpenSQLConnectInfo " + jars + " create_dr jdbc/pool/" + instanceName + " com.sap.dbtech.jdbc.DriverSapDB \"jdbc:sapdb://" + dbHostName + ":" + DTRTest.getDatabase().getPort() + "/" + DTRTest.getDatabase().getName() + "?timeout=0&spaceoption=true&unicode=true\" SAP" + instanceName + "DB " + nwdbPassword + " " + instanceName + " " + serverPath + File.separator + instanceName + File.separator + "SYS" + File.separator + "global" + File.separator + "security" + File.separator + "data" + File.separator + "SecStore.properties " + serverPath + File.separator + instanceName + File.separator + "SYS" + File.separator + "global" + File.separator + "security" + File.separator + "data" + File.separator + "SecStore.key";
            DTRTest.executeCmd(cmd, sapcontrolTimeout);
        }
        if (DTRTest.getParameterString((String)"tf.files.rewrite", (String)"yes").equals("yes")) {
            String nwAdmin1 = DTRTest.getParameterString((String)"nw.user.admin1", (String)"");
            String nwAdmin1PW = DTRTest.getParameterString((String)"nw.user.admin1.password", (String)"");
            String nwAdmin2 = DTRTest.getParameterString((String)"nw.user.admin2", (String)"");
            String nwAdmin2PW = DTRTest.getParameterString((String)"nw.user.admin2.password", (String)"");
            String trackName = DTRTest.getParameterString((String)"dtr.tests.track.name", (String)"");
            String libRelease = DTRTest.getParameterString((String)"dtr.tests.lib.release", (String)"");
            String nwPort = DTRTest.getParameterString((String)"nw.server.port", (String)"");
            sysTime = System.currentTimeMillis();
            try {
                String line;
                String filename = dtrtestsConfigPath + File.separator + "dtrtest.properties";
                DTRTest.addGlobalMessage((String)methodName, (char)'I', (String)("Rewriting dtr-tests file: " + filename));
                File dtrtestsFile = new File(filename);
                File dtrtestsFileRenamed = new File(dtrtestsConfigPath + File.separator + "dtrtest_" + sysTime + ".properties");
                dtrtestsFile.renameTo(dtrtestsFileRenamed);
                dtrtestsFile.createNewFile();
                FileReader fin = new FileReader(dtrtestsFileRenamed);
                BufferedReader in = new BufferedReader(fin);
                FileWriter fout = new FileWriter(dtrtestsFile);
                BufferedWriter out = new BufferedWriter(fout);
                while ((line = in.readLine()) != null) {
                    if (line.startsWith("serverURL=")) {
                        out.write("serverURL=http://" + nwHostName + ":" + nwPort + "/dtr");
                        DTRTest.addGlobalMessage((String)methodName, (char)'I', (String)("serverURL=http://" + nwHostName + ":" + nwPort + "/dtr"));
                    } else if (line.startsWith("user=")) {
                        out.write("user=" + nwAdmin1);
                        DTRTest.addGlobalMessage((String)methodName, (char)'I', (String)("user=" + nwAdmin1));
                    } else if (line.startsWith("pass=")) {
                        out.write("pass=" + nwAdmin1PW);
                        DTRTest.addGlobalMessage((String)methodName, (char)'I', (String)("pass=" + nwAdmin1PW));
                    } else if (line.startsWith("namecollision.user2=")) {
                        out.write("namecollision.user2=" + nwAdmin2);
                        DTRTest.addGlobalMessage((String)methodName, (char)'I', (String)("namecollision.user2=" + nwAdmin2));
                    } else if (line.startsWith("namecollision.pass2=")) {
                        out.write("namecollision.pass2=" + nwAdmin2PW);
                        DTRTest.addGlobalMessage((String)methodName, (char)'I', (String)("namecollision.pass2=" + nwAdmin2PW));
                    } else {
                        out.write(line);
                    }
                    out.newLine();
                }
                out.close();
                filename = dtrtestsAntPath + File.separator + "remotePaths.properties";
                DTRTest.addGlobalMessage((String)methodName, (char)'I', (String)("Rewriting dtr-tests file: " + filename));
                dtrtestsFile = new File(filename);
                dtrtestsFileRenamed = new File(dtrtestsAntPath + File.separator + "remotePaths_" + sysTime + ".properties");
                dtrtestsFile.renameTo(dtrtestsFileRenamed);
                dtrtestsFile.createNewFile();
                fin = new FileReader(dtrtestsFileRenamed);
                in = new BufferedReader(fin);
                fout = new FileWriter(dtrtestsFile);
                out = new BufferedWriter(fout);
                while ((line = in.readLine()) != null) {
                    if (line.startsWith("track.name=")) {
                        out.write("track.name=" + trackName);
                        DTRTest.addGlobalMessage((String)methodName, (char)'I', (String)("track.name=" + trackName));
                    } else if (line.startsWith("lib.release=")) {
                        out.write("lib.release=" + libRelease);
                        DTRTest.addGlobalMessage((String)methodName, (char)'I', (String)("lib.release=" + libRelease));
                    } else {
                        out.write(line);
                    }
                    out.newLine();
                }
                out.close();
            }
            catch (IOException ioe) {
                DTRTest.addGlobalMessage((String)methodName, (char)'E', (String)("dtr-test files: IOError: " + ioe.getMessage()), (Exception)ioe, (String)"");
                ioe.printStackTrace();
            }
        }
        if (DTRTest.getParameterString((String)"tf.nw.start", (String)"yes").equals("yes")) {
            DTRTest.addGlobalMessage((String)methodName, (char)'I', (String)"start server");
            cmd = sapcontrolPath + "sapcontrol.exe" + opt_protocol + opt_user + opt_host + opt_instance + " -function StartWait " + sapcontrolTimeout + " 0";
            DTRTest.executeCmd(cmd, sapcontrolTimeout);
        }
    }

    public void run() {
        String methodName = "Method run()";
        try {
            if (DTRTest.getParameterString((String)"tf.tests.run", (String)"yes").equals("yes")) {
                this.addMessage(methodName, 'I', "start dtr-tests");
                for (int i = 0; i < logFileList.size(); ++i) {
                    File file = (File)logFileList.get(i);
                    if (!file.exists()) continue;
                    if (file.delete()) {
                        this.addMessage(methodName, 'I', "Delete file: " + file.getName());
                        continue;
                    }
                    this.addMessage(methodName, 'I', "Couldn't delete file: " + file.getName());
                }
                String sapantPath = DTRTest.getParameterString((String)"sapant.path", (String)"");
                File workingDir = new File(dtrtestsAntPath);
                this.addMessage(methodName, 'I', "Working DIR: " + workingDir);
                String cmd = "";
                if (DTRTest.getParameterString((String)"dtr.tests.small", (String)"").equals("one")) {
                    String oneTest = DTRTest.getParameterString((String)"dtr.tests.test", (String)"com.tssap.dtr.server.deltav.autotests.TestConcurrentCheckinCheckout");
                    cmd = sapantPath + File.separator + "bin" + File.separator + "ant.bat -Djver.tests=" + oneTest + " -Djvertask.timeout.seconds=" + dtrTimeout;
                } else {
                    cmd = sapantPath + File.separator + "bin" + File.separator + "ant.bat -Djvertask.timeout.seconds=" + dtrTimeout;
                }
                DTRTest.executeCmd(cmd, dtrTimeout, workingDir);
            }
        }
        catch (Exception e) {
            this.addMessage(methodName, 'E', "DTR Test failed: Runtime");
            this.addMessage(methodName, 'E', "Error: " + e.getMessage(), e, "");
            e.printStackTrace();
            this.handleExceptions(e);
        }
    }

    public static void cleanUp() {
        if (DTRTest.getParameterString((String)"tf.nw.stoplast", (String)"yes").equals("yes")) {
            DTRTest.addGlobalMessage((String)"Method run", (char)'I', (String)"stop server");
            String cmd = sapcontrolPath + "sapcontrol.exe" + opt_protocol + opt_user + opt_host + opt_instance + " -function StopWait " + sapcontrolTimeout + " 0";
            DTRTest.executeCmd(cmd, sapcontrolTimeout);
        }
    }

    private static void executeDBMCmd(String pCmd) throws TestDatabaseException {
        String methodName = "Method executeDBMCmd";
        DTRTest.addGlobalMessage((String)methodName, (char)'I', (String)("Running DBM Command: " + pCmd));
        String logon = "USER_LOGON " + DTRTest.getDatabase().getDBMUser() + "," + DTRTest.getDatabase().getDBMPassword();
        String mHost = "";
        String mName = "";
        try {
            String returnString;
            mHost = DTRTest.getDatabase().getHost();
            mName = DTRTest.getDatabase().getName();
            int mPort = DTRTest.getDatabase().getPort();
            if (mDBMan == null) {
                mDBMan = DBM.dbDBM((String)(mHost + ":" + mPort), (String)mName);
                mDBMan.cmd(logon);
            }
            if ((returnString = mDBMan.cmd(pCmd)).length() > 0) {
                System.out.println(returnString);
                DTRTest.addGlobalMessage((String)methodName, (char)'I', (String)returnString);
            }
        }
        catch (Exception e) {
            if (mDBMan != null) {
                try {
                    mDBMan.release();
                }
                catch (RTEException rte) {
                    DTRTest.addGlobalMessage((String)methodName, (char)'E', (String)("Exception : " + rte.getMessage()), (Exception)((Object)rte), (String)"");
                    rte.printStackTrace();
                }
                mDBMan = null;
            }
            throw new TestDatabaseException(e, " DBM command: " + pCmd + ", logon String: " + logon);
        }
    }

    private static void executeCmd(String cmd, int timeout) {
        DTRTest.executeCmd(cmd, timeout, null);
    }

    private static void executeCmd(String cmd, int timeout, File workDir) {
        String methodName = "Method executeCmd";
        DTRTest.addGlobalMessage((String)methodName, (char)'I', (String)("Running : " + cmd));
        StringBuffer sb = new StringBuffer();
        Execute exc = new Execute(cmd, null, sb);
        exc.enableWritingStdout(true);
        exc.setErrPrefix("STDERR ");
        exc.setOutPrefix("STDOUT ");
        exc.setTimeout(timeout);
        exc.exec(workDir);
        if (sb.length() > 0) {
            System.out.println(sb);
            DTRTest.addGlobalMessage((String)methodName, (char)'I', (String)sb.toString());
            if (sb.toString().indexOf("BUILD FAILED") != -1) {
                DTRTest.addGlobalMessage((String)methodName, (char)'E', (String)"DTR-TESTS FAILED - BUILD ERROR");
            }
        }
        if (exc.getExitValue() != 0) {
            if (exc.isDestroyed()) {
                DTRTest.addGlobalMessage((String)methodName, (char)'E', (String)("Subprocess: " + cmd + " has been destroyed after timeout: " + timeout + "s"));
                return;
            }
            DTRTest.addGlobalMessage((String)methodName, (char)'E', (String)(cmd + " -> error occured!"));
            return;
        }
        DTRTest.addGlobalMessage((String)"", (char)'I', (String)(cmd + " -> successful!"));
    }

    public static long getTimeout() {
        return 60000 * DTRTest.getParameterInt((String)"testframe.timeout", (int)120);
    }

    public String getLogFile() {
        File theZipFile = new File(this.getDataOutputPath() + File.separator + "dtr_logs.zip");
        Zipper myZipper = new Zipper(theZipFile);
        File[] filelist = new File[logFileList.size()];
        filelist = logFileList.toArray(filelist);
        myZipper.addFiles(filelist);
        try {
            myZipper.zip();
        }
        catch (IOException e) {
            this.addMessage("DTR-Tests", 'W', "Failed to create a zipfile with the protocol files\n" + e.getLocalizedMessage(), e, "");
            e.printStackTrace();
            return null;
        }
        return theZipFile.getAbsolutePath();
    }

    static {
        opt_instance = "";
        opt_host = "";
        sapcontrolTimeout = 0;
        dtrTimeout = 0;
        dbHostName = "";
        dtrtestsPath = "";
        dtrtestsAntPath = "";
        serverPath = "";
        instanceNr = "";
        instanceName = "";
        nwHostName = "";
        keyPhrase = "";
        nwdbPassword = "";
    }
}

