/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.multiversion;

import com.sap.sapdb.testframe.driver.TestDatabase;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDatabaseSap;
import com.sap.sapdb.testframe.driver.TestDriverConfiguration;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.testcase.TestPreparedStatement;
import com.sap.sapdb.testframe.testcase.TestStatement;
import com.sap.sapdb.testframe.testcase.VerificationDataComplete;
import com.sap.sapdb.testframe.utilities.Execute;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.Random;

public class MVMut
extends TestCase {
    private static final String mVersion = "MVMut 1.0.0.09";
    private static final String mExUser = "MVMut";
    private static final String mExPassword = "MVMut";
    private static final int TEST1 = 1;
    private static final int CONSISTENTVIEWHOLDER = 2;
    private static int m_maxTasks = 1;
    private static int m_checkSumRowCount = 1000;
    private static int m_maxRunTime = 30;
    private static int m_consistentViewLifeTime = 60;
    private static int m_traceLevel = 2;
    private static int m_keyLen = 1000;
    private static int m_crashDistance = 120;
    private static boolean m_consoleMsg = true;
    private static boolean m_jdbcTrace = false;
    private static boolean m_nolog = false;
    private static boolean m_useIndexes = false;
    private static int m_maxConnections = 2;
    private static boolean m_runTimeLimit = false;
    private static volatile boolean m_stop = false;
    private static int m_tasks = 0;
    private static int m_waitingTasks = 0;
    private static int m_checksum = 0;
    private static int m_sqlError = 0;
    private static boolean m_crashEvent = false;
    private static boolean m_cold = false;
    private static String m_sqlErrorMsg = null;
    private TestDatabaseSap m_shadowDB;
    private Crash_Timer m_crashTimer = null;

    public static long getTimeout() {
        return 60000 * (m_maxRunTime + 10);
    }

    public static Connection connect(TestDatabase db) throws TestDatabaseException {
        Properties conp = new Properties();
        conp.put("user", "MVMut");
        conp.put("password", "MVMut");
        conp.put("autocommit", "off");
        conp.put("reconnect", "false");
        conp.put("timeout", "0");
        if (m_jdbcTrace) {
            conp.put("trace", "jdbcTrace.prt");
        }
        Connection con = db.connect(conp);
        return con;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean dbCold() {
        MVMut mVMut = this;
        synchronized (mVMut) {
            return m_cold;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setCold(boolean isCold) {
        MVMut mVMut = this;
        synchronized (mVMut) {
            m_cold = isCold;
        }
    }

    private void Trace_1(String msg) {
        if (m_traceLevel >= 1) {
            if (m_consoleMsg) {
                System.out.println(msg);
            }
            this.addMessage("", 'I', msg);
        }
    }

    private void Sleep(Thread t, int sleepTime) throws InterruptedException {
        while (sleepTime > 0) {
            int s = sleepTime > 10000 ? 10000 : sleepTime;
            Thread.sleep(s);
            sleepTime -= s;
            if (!m_stop) continue;
            throw new InterruptedException();
        }
    }

    synchronized int getRunningTasks() {
        return m_tasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void incRunningTask() {
        MVMut mVMut = this;
        synchronized (mVMut) {
            ++m_tasks;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void decRunningTasks() {
        MVMut mVMut = this;
        synchronized (mVMut) {
            --m_tasks;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void incWaitingTasks() {
        MVMut mVMut = this;
        synchronized (mVMut) {
            ++m_waitingTasks;
        }
    }

    synchronized void setGlobalSqlError(SQLException e) {
        if (0 == m_sqlError) {
            m_sqlError = e.getErrorCode();
            m_sqlErrorMsg = e.getMessage();
        }
    }

    synchronized int sqlError() {
        return m_sqlError;
    }

    private static void Trace(String msg) {
        System.out.println(msg);
        MVMut.addGlobalMessage((String)"", (char)'I', (String)msg);
    }

    private void Trace(int level, String msg) {
        if (m_traceLevel > level) {
            System.out.println(msg);
            MVMut.addGlobalMessage((String)"", (char)'I', (String)msg);
        }
    }

    private void TraceError(String msg) {
        System.out.println(msg);
        this.addMessage("Error", 'E', msg);
        m_stop = true;
    }

    private void startTask(int processId, int test, int sleepDuration) throws SQLException, TestDatabaseException {
        this.incRunningTask();
        Task task = new Task(processId, test, sleepDuration);
    }

    public static void cleanUp() throws TestCaseException {
        System.out.println("End of " + MVMut.getTestClassId());
    }

    public static String getTestClassId() {
        return mVersion;
    }

    void FillCheckSumTable() throws SQLException, TestDatabaseException {
        MVMut.Trace("Filling CheckSumTable ...");
        Connection conn = MVMut.getDatabase().connect("MVMut", "MVMut");
        Connection shadowConnection = null;
        if (m_maxConnections > 1) {
            shadowConnection = this.m_shadowDB.connect("MVMut", "MVMut");
            shadowConnection.setAutoCommit(false);
        }
        TestPreparedStatement insertStmt = new TestPreparedStatement(null, conn, "Insert CHECKSUMTAB values (?, ?, ?, ?, ?, ?)");
        TestPreparedStatement shadowInsertStmt = null;
        if (null != shadowConnection) {
            shadowInsertStmt = new TestPreparedStatement(null, shadowConnection, "Insert CHECKSUMTAB values (?, ?, ?, ?, ?, ?)");
        }
        Random r = new Random(13L);
        conn.setAutoCommit(false);
        long rowIndex = 0L;
        for (int row = 0; row < m_checkSumRowCount; ++row) {
            String key1 = "X" + row;
            int key2 = row;
            int indexVal = row % 1000;
            int checkSumValue = r.nextInt() % 1000;
            for (int taskId = 0; taskId < m_maxTasks; ++taskId) {
                int idx = 0;
                insertStmt.setInt(++idx, taskId);
                insertStmt.setString(++idx, key1);
                insertStmt.setInt(++idx, key2);
                insertStmt.setInt(++idx, indexVal);
                insertStmt.setInt(++idx, checkSumValue);
                insertStmt.setLong(++idx, rowIndex);
                insertStmt.executeUpdate();
                if (null != shadowConnection) {
                    idx = 0;
                    shadowInsertStmt.setInt(++idx, taskId);
                    shadowInsertStmt.setString(++idx, key1);
                    shadowInsertStmt.setInt(++idx, key2);
                    shadowInsertStmt.setInt(++idx, indexVal);
                    shadowInsertStmt.setInt(++idx, checkSumValue);
                    shadowInsertStmt.setLong(++idx, rowIndex);
                    shadowInsertStmt.executeUpdate();
                }
                if (0 == indexVal) {
                    conn.commit();
                    if (null != shadowConnection) {
                        shadowConnection.commit();
                    }
                }
                ++rowIndex;
            }
            m_checksum += checkSumValue;
        }
        conn.commit();
        conn.close();
        if (null != shadowConnection) {
            shadowConnection.commit();
            shadowConnection.close();
        }
        this.verifyTableContent();
        MVMut.Trace("CheckSumTable filled, check sum is " + m_checksum);
    }

    void verifyTableContent() throws TestDatabaseException, SQLException {
        if (m_maxConnections > 1) {
            TestStatement stmt1;
            ResultSet rs1;
            Connection conn = MVMut.getDatabase().connect("MVMut", "MVMut");
            Connection shadowConnection = this.m_shadowDB.connect("MVMut", "MVMut");
            TestStatement stmt = new TestStatement(null, conn);
            ResultSet rs0 = stmt.executeQuery("Select * from CHECKSUMTAB");
            VerificationDataComplete verificationData = new VerificationDataComplete(rs0);
            if (!verificationData.equals(rs1 = (stmt1 = new TestStatement(null, shadowConnection)).executeQuery("Select * from CHECKSUMTAB"))) {
                System.out.println(verificationData.getErrorMessage());
                TestDatabaseException e = new TestDatabaseException(verificationData.getErrorMessage());
                throw e;
            }
            MVMut.Trace("Table content verified");
            conn.close();
            shadowConnection.close();
        }
    }

    public static void writeProt(Connection con, String msg) {
        try {
            TestStatement stmt = new TestStatement(null, con);
            stmt.executeUpdate("### Error : " + msg);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void createPackage(Connection con, String PackageName, String ProgId) throws SQLException {
        Statement stmt = con.createStatement();
        try {
            stmt.execute("DROP PACKAGE " + PackageName);
        }
        catch (SQLException e) {
            // empty catch block
        }
        stmt.execute("CREATE PACKAGE " + PackageName + " FILE '" + ProgId + "'");
    }

    private static void createDBProcedure(Connection con, String DBProcName, String PackageName) throws SQLException {
        Statement stmt = con.createStatement();
        try {
            stmt.execute("DROP DBPROC " + DBProcName);
        }
        catch (SQLException e) {
            // empty catch block
        }
        String CallString = "CREATE DBPROC " + DBProcName + " IN " + PackageName + " EXECUTE INPROC";
        stmt.execute(CallString);
    }

    void createSchema(TestDatabase database) throws TestCaseException {
        TestStatement stmt = null;
        Object prepstmt = null;
        try {
            Connection conn = database.connect(MVMut.getUser(), MVMut.getPassword());
            stmt = new TestStatement(null, conn);
            stmt.enableExceptions(false);
            stmt.executeUpdate("Drop user MVMut");
            stmt.enableExceptions(true);
            stmt.executeUpdate("Create user MVMut password MVMut dba not exclusive");
            stmt.close();
            conn.commit();
            conn.close();
            conn = database.connect("MVMut", "MVMut");
            stmt = new TestStatement(null, conn);
            String createTable = "CREATE TABLE CHECKSUMTAB (TASKID INT, KEY1 CHAR(" + m_keyLen + "), KEY2 FIXED(10), INDEXFIELD FIXED(10), CHECKSUMVAL FIXED(10), ROWINDEX FIXED(20), PRIMARY KEY(KEY1,KEY2,TASKID))";
            stmt.executeUpdate(createTable);
            if (m_useIndexes) {
                stmt.execute("CREATE INDEX TASKIDIDX on CHECKSUMTAB (TASKID)");
                stmt.execute("CREATE INDEX IDX1 on CHECKSUMTAB (INDEXFIELD)");
                stmt.execute("CREATE INDEX IDX2 on CHECKSUMTAB (ROWINDEX)");
            }
            stmt.execute("CREATE TABLE PROT (MSG CHAR(2000))");
            String Package2 = "LCTEST";
            stmt.executeUpdate("CREATE DBPROC ABORT AS LANGUAGE SYSTEM NAME 'SYS_CRASH'");
            conn.commit();
            conn.close();
            MVMut.addGlobalMessage((String)"Method prepare", (char)'I', (String)"just created MVMulti1");
        }
        catch (SQLException e) {
            MVMut.Trace("*** stop because of error during prepare():" + e.getErrorCode() + " " + e.getMessage());
            throw new TestCaseException("Error during preparation: " + e.getClass() + e.getErrorCode() + " " + e.getMessage());
        }
        catch (Exception e) {
            MVMut.addGlobalMessage((String)"Method prepare", (char)'E', (String)"preparation failed");
            throw new TestCaseException("Error during preparation: " + e.getClass() + " " + e.getMessage());
        }
    }

    public static void prepare() throws TestCaseException {
        System.out.println("Start of " + MVMut.getTestClassId());
        MVMut.readParameters();
    }

    private void createShadowDb() throws Exception {
        TestDriverConfiguration configOfFirstDB = new TestDriverConfiguration();
        configOfFirstDB.setConfiguration(mTestDriverOptions);
        configOfFirstDB.setDBDeviceList(mTestDriverConfiguration.getDBDeviceList());
        configOfFirstDB.setDBParameterMap(mTestDriverConfiguration.getDBParameterMap());
        configOfFirstDB.setConfigValue("DBName", (Object)(MVMut.getDatabase().getName() + "_T"));
        configOfFirstDB.setConfigValue("DBKind", (Object)"OLTP");
        if (m_maxConnections > 1) {
            this.m_shadowDB = this.additionalDatabase(configOfFirstDB, 1);
        }
    }

    private static void readParameters() {
        m_maxTasks = MVMut.getParameterInt((String)"MAX_TASKS", (int)20);
        m_checkSumRowCount = MVMut.getParameterInt((String)"CHECKSUM_ROWCOUNT", (int)1000);
        m_maxRunTime = MVMut.getParameterInt((String)"MAX_RUNTIME", (int)30);
        m_consistentViewLifeTime = MVMut.getParameterInt((String)"CNSVIEW_LIFETIME", (int)60);
        m_traceLevel = MVMut.getParameterInt((String)"TRACE_LEVEL", (int)1);
        m_keyLen = MVMut.getParameterInt((String)"KEYLEN", (int)1000);
        m_crashDistance = MVMut.getParameterInt((String)"CRASH_DISTANCE", (int)120);
        m_maxConnections = 0 == m_crashDistance ? 1 : 2;
        m_consoleMsg = MVMut.getParameterBoolean((String)"CONSOLE_MSG", (boolean)true);
        m_jdbcTrace = MVMut.getParameterBoolean((String)"JDBC_TRACE", (boolean)false);
        m_nolog = MVMut.getParameterBoolean((String)"NOLOG", (boolean)false);
        m_useIndexes = MVMut.getParameterBoolean((String)"USE_INDEX", (boolean)true);
        if (m_traceLevel > 0) {
            MVMut.Trace("TRACE_LEVEL       : " + m_traceLevel);
            MVMut.Trace("MAX_TASKS         : " + m_maxTasks);
            MVMut.Trace("CHECKSUM_ROWCOUNT : " + m_checkSumRowCount);
            MVMut.Trace("MAX_RUNTIME       : " + m_maxRunTime);
            MVMut.Trace("CNSVIEW_LIFETIME  : " + m_consistentViewLifeTime);
            MVMut.Trace("KEYLEN            : " + m_keyLen);
            MVMut.Trace("CRASH_DISTANCE    : " + m_crashDistance);
            MVMut.Trace("CONSOLE_MSG       : " + m_consoleMsg);
            MVMut.Trace("JDBC_TRACE        : " + m_jdbcTrace);
            MVMut.Trace("NOLOG             : " + m_nolog);
            MVMut.Trace("USE_INDEX         : " + m_useIndexes);
        }
    }

    public void TraceTestStatistics(Connection connection) {
        try {
            CallableStatement selectInto = connection.prepareCall("select HISTORYANCHORFROMFILECOUNT, HISTORYANCHORFROMPAGECOUNT into ?,?  from MULTIVERSIONREADSTATISTICS");
            selectInto.registerOutParameter(1, 4);
            selectInto.registerOutParameter(2, 4);
            selectInto.execute();
            MVMut.Trace("HistoryFrom File : " + selectInto.getLong(1) + ", HistoryFromPage : " + selectInto.getLong(2));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean verifyCheckSumAfterRestart(Connection connection) throws SQLException, TestCaseException, TestDatabaseException {
        PreparedStatement verifyCheckSumStmt = connection.prepareStatement("SELECT CHECKSUMVAL,ROWINDEX FROM CHECKSUMTAB WHERE TASKID = ?", 1005, 1007);
        for (int taskId = 0; taskId < m_maxTasks; ++taskId) {
            boolean ok;
            verifyCheckSumStmt.setInt(1, taskId);
            ResultSet rs = verifyCheckSumStmt.executeQuery();
            int checkSum = 0;
            while (rs.next()) {
                int val = rs.getInt(1);
                long rowIndex = rs.getLong(2);
                this.Trace(10, "RowIndex : " + rowIndex + ", Value : " + val);
                checkSum += val;
            }
            boolean bl = ok = checkSum == m_checksum;
            if (!ok) {
                MVMut.writeProt(connection, "wrong checksum");
                this.TraceError("unexpected checksum for T" + taskId + " : found " + checkSum + ", expected " + m_checksum);
                PreparedStatement verifyCheckSumStmtScan = connection.prepareStatement("SELECT /*+KEYACCESS*/ CHECKSUMVAL,ROWINDEX FROM CHECKSUMTAB WHERE TASKID = ?", 1005, 1007);
                verifyCheckSumStmtScan.setInt(1, taskId);
                ResultSet rsScan = verifyCheckSumStmtScan.executeQuery();
                checkSum = 0;
                while (rsScan.next()) {
                    int val = rsScan.getInt(1);
                    long rowIndex = rsScan.getLong(2);
                    this.Trace(10, "RowIndex : " + rowIndex + ", Value : " + val);
                    checkSum += val;
                }
                rsScan.close();
                this.TraceError("checksum via scan   for T" + taskId + " : " + checkSum);
                this.verifyTableContent();
            } else {
                MVMut.Trace("Checksum for T" + taskId + " ok");
            }
            rs.close();
            if (ok) continue;
            return false;
        }
        this.verifyTableContent();
        return true;
    }

    boolean copyFile(String fileName) {
        String copyCmd = "C:\\SAPDevelop\\Devtool\\Posix\\cp.exe " + fileName + " " + fileName + ".sav";
        StringBuffer pBuffer = new StringBuffer(1000);
        Execute ex = new Execute(copyCmd, null, pBuffer);
        ex.exec();
        int ret = ex.getExitValue();
        if (0 != ret) {
            String s = pBuffer.toString();
            MVMut.Trace(s);
        }
        return ret == 0;
    }

    void copyDataAndLog() throws TestDatabaseException {
        String runDir = MVMut.getDatabase().executeDBMcmd("param_directget rundirectory");
        int idx = runDir.indexOf(9);
        if ((idx = (runDir = runDir.substring(idx + 1)).indexOf(10)) > 0) {
            runDir = runDir.substring(0, idx);
        }
        if (!this.copyFile(runDir + "\\DAT01.dat")) {
            return;
        }
        if (!this.copyFile(runDir + "\\DAT02.dat")) {
            return;
        }
        if (!this.copyFile(runDir + "\\LOG01.dat")) {
            return;
        }
        MVMut.Trace("Data and Log copied successfully");
    }

    void setLogWriter() {
        if (m_nolog) {
            try {
                MVMut.getDatabase().executeDBMcmd("db_offline");
                MVMut.getDatabase().executeDBMcmd("db_admin");
                MVMut.getDatabase().executeDBMcmd("db_execute set log writer off");
                MVMut.getDatabase().executeDBMcmd("db_online");
            }
            catch (Exception e) {
                MVMut.Trace("Could not disable log writer");
            }
            MVMut.Trace("log writer is off !");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block24: {
            Connection connection = null;
            this.setLogWriter();
            this.createShadowDb();
            this.createSchema(MVMut.getDatabase());
            if (m_maxConnections > 1) {
                this.createSchema((TestDatabase)this.m_shadowDB);
            }
            this.FillCheckSumTable();
            connection = MVMut.connect(MVMut.getDatabase());
            MaxRunTimeTimer timer = new MaxRunTimeTimer(m_maxRunTime);
            this.m_crashTimer = new Crash_Timer(m_crashDistance);
            this.startTask(m_maxTasks, 2, m_consistentViewLifeTime);
            for (int task = 0; task < m_maxTasks; ++task) {
                this.startTask(task, 1, 0);
            }
            while (this.getRunningTasks() > 0) {
                try {
                    Thread.sleep(1000L);
                    connection.rollback();
                }
                catch (Exception e) {
                    if (!m_crashEvent) continue;
                    int loopCnt = 0;
                    while (m_waitingTasks != m_maxTasks + 1) {
                        Thread.sleep(1000L);
                        if (++loopCnt < 120) continue;
                    }
                    if (m_waitingTasks != m_maxTasks + 1) {
                        MVMut.Trace("not all tasks recognized database crash yet !");
                    }
                    for (int jx = 0; jx < 100; ++jx) {
                        try {
                            MVMut.getDatabase().executeDBMcmd("db_offline");
                            break;
                        }
                        catch (Exception offlineE) {
                            MVMut.Trace("db_offline failed");
                            Thread.sleep(5000L);
                            continue;
                        }
                    }
                    this.copyDataAndLog();
                    boolean inAdminMode = false;
                    for (int ix = 0; ix < 180; ++ix) {
                        try {
                            MVMut.getDatabase().executeDBMcmd("db_admin");
                            inAdminMode = true;
                            break;
                        }
                        catch (Exception adminE) {
                            Thread.sleep(1000L);
                            continue;
                        }
                    }
                    if (!inAdminMode) {
                        this.TraceError("could not enter admin mode");
                        break;
                    }
                    MVMut.getDatabase().executeDBMcmd("db_online");
                    MVMut.Trace("database is online again");
                    connection = MVMut.connect(MVMut.getDatabase());
                    if (!this.verifyCheckSumAfterRestart(connection)) continue;
                    this.setCold(false);
                    this.m_crashTimer.restart();
                    connection.commit();
                    m_waitingTasks = 0;
                }
            }
            try {
                this.TraceTestStatistics(connection);
                connection.close();
            }
            catch (SQLException sql_e) {}
            break block24;
            catch (Exception e) {
                try {
                    this.TraceError(e.getMessage());
                    e.printStackTrace();
                    this.handleExceptions(e);
                }
                catch (Throwable throwable) {
                    try {
                        this.TraceTestStatistics(connection);
                        connection.close();
                    }
                    catch (SQLException sql_e) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    this.TraceTestStatistics(connection);
                    connection.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    class Task
    extends MVMulti1Test
    implements Runnable {
        Task(int processId, int test, int sleepDurationSeconds) throws SQLException, TestDatabaseException {
            super(processId);
            Thread t = new Thread(this);
            this.m_test = test;
            if (sleepDurationSeconds <= 0) {
                sleepDurationSeconds = 1;
            }
            this.m_sleep = sleepDurationSeconds * 1000;
            t.setDaemon(true);
            t.start();
        }

        void abort() throws SQLException {
            CallableStatement call = this.m_connection[0].prepareCall("CALL ABORT");
            call.execute();
        }

        int chooseRow() {
            int rowIndex = this.m_processId + m_maxTasks * this.nextRand(m_checkSumRowCount);
            this.TaskTrace(10, "chooseRow : " + rowIndex + "(" + this.m_processId + ")");
            return rowIndex;
        }

        void TransEnd() throws SQLException, TestCaseException {
            if (this.nextRand(100) > 40) {
                this.TaskTrace(9, "commit");
                if (MVMut.this.m_crashTimer.incCommitCounter()) {
                    for (int ix = 0; ix < m_maxConnections; ++ix) {
                        this.m_connection[ix].commit();
                    }
                    MVMut.this.m_crashTimer.decCommitCounter();
                    return;
                }
                this.TaskTrace(1, "could not commit because crash is pending");
            }
            this.TaskTrace(9, "rollback");
            for (int ix = 0; ix < m_maxConnections; ++ix) {
                try {
                    this.m_connection[ix].rollback();
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        private void randomSelectRow() throws SQLException, TestCaseException {
            int rowIndex = this.chooseRow();
            this.TaskTrace(8, "select rowIndex " + rowIndex);
            CallableStatement selectInto = this.m_connection[0].prepareCall("select * into ?,?,?,?,?,?  from CHECKSUMTAB where ROWINDEX = ?");
            selectInto.registerOutParameter(1, 4);
            selectInto.registerOutParameter(2, 1);
            selectInto.registerOutParameter(3, 4);
            selectInto.registerOutParameter(4, 4);
            selectInto.registerOutParameter(5, 4);
            selectInto.registerOutParameter(6, 4);
            selectInto.setInt(7, rowIndex);
            selectInto.execute();
            try {
                this.m_rowTaskId = selectInto.getInt(1);
            }
            catch (Exception e) {
                MVMut.this.TraceError("NO RESULT found by: select * into ?,?,?,?,?,?  from CHECKSUMTAB where ROWINDEX = ?");
                this.abort();
            }
            if (this.m_rowTaskId != this.m_processId) {
                MVMut.this.TraceError("unexpeected taskId " + this.m_rowTaskId);
            }
            this.m_rowKey1 = selectInto.getString(2);
            this.m_rowKey2 = selectInto.getInt(3);
            this.m_rowIndexVal = selectInto.getInt(4);
            this.m_rowCheckSumVal = selectInto.getInt(5);
            this.m_rowIndex = selectInto.getInt(6);
            this.TaskTrace(9, "read row (" + this.m_rowTaskId + "," + this.m_rowKey1 + "," + this.m_rowKey2 + "," + this.m_rowIndexVal + "," + this.m_rowCheckSumVal + "," + this.m_rowIndex);
        }

        private void insertRow() throws SQLException, TestCaseException {
            ++this.m_key2Counter;
            this.TaskTrace(9, "InsertRow (" + this.m_rowTaskId + "," + this.m_rowKey1 + "," + this.m_key2Counter + "," + this.m_rowIndexVal + "," + this.m_rowCheckSumVal + "," + this.m_rowIndex + ")");
            for (int db = 0; db < m_maxConnections; ++db) {
                int idx = 0;
                this.m_insertStatement[db].setInt(++idx, this.m_rowTaskId);
                this.m_insertStatement[db].setString(++idx, this.m_rowKey1);
                this.m_insertStatement[db].setInt(++idx, this.m_key2Counter);
                this.m_insertStatement[db].setInt(++idx, this.m_rowIndexVal);
                this.m_insertStatement[db].setInt(++idx, this.m_rowCheckSumVal);
                this.m_insertStatement[db].setLong(++idx, this.m_rowIndex);
                this.m_insertStatement[db].execute();
            }
        }

        private void deleteRow(long rowIndex) throws SQLException, TestCaseException {
            this.TaskTrace(9, "DeleteRow : " + rowIndex);
            for (int ix = 0; ix < m_maxConnections; ++ix) {
                this.m_deleteStatement[ix].setLong(1, rowIndex);
                this.m_deleteStatement[ix].execute();
                if (this.m_deleteStatement[ix].getUpdateCount() == 1) continue;
                MVMut.this.TraceError("unexpected delete count " + this.m_deleteStatement[ix].getUpdateCount() + " in database " + ix);
                this.abort();
            }
        }

        private void massUpdate() throws SQLException, TestCaseException {
            this.TaskTrace(5, "Mass Update");
            for (int db = 0; db < m_maxConnections; ++db) {
                this.m_massUpdateStatement[db].setInt(1, this.m_processId);
                this.m_massUpdateStatement[db].execute();
                if (this.m_massUpdateStatement[db].getUpdateCount() == m_checkSumRowCount - 1) continue;
                MVMut.this.TraceError("unexpected mass update count : " + this.m_massUpdateStatement[db].getUpdateCount());
                this.abort();
            }
        }

        private int updateRow(long rowIndex, int delta) throws SQLException, TestCaseException {
            this.TaskTrace(9, "UpdateRow : " + rowIndex + ", delta : " + delta);
            for (int db = 0; db < m_maxConnections; ++db) {
                this.m_updateStatement[db].setLong(1, delta);
                this.m_updateStatement[db].setLong(2, rowIndex);
                this.m_updateStatement[db].execute();
                if (this.m_updateStatement[db].getUpdateCount() == 1) continue;
                if (0 == db && 0 == this.m_updateStatement[db].getUpdateCount()) {
                    return 0;
                }
                MVMut.this.TraceError("unexpected update count " + this.m_updateStatement[db].getUpdateCount() + " in database " + db);
                this.abort();
            }
            return delta;
        }

        private void executeUpdateTrans() throws SQLException, TestCaseException {
            boolean massUpd = false;
            for (int ix = 0; ix < 10 && !massUpd; ++ix) {
                this.randomSelectRow();
                this.deleteRow(this.m_rowIndex);
                int delta = 0;
                if (this.nextRand(100) < 0) {
                    this.massUpdate();
                    massUpd = true;
                    delta = m_checkSumRowCount - 1;
                } else {
                    long updateRowIndex;
                    delta = this.m_rowCheckSumVal / 2;
                    while ((updateRowIndex = (long)this.chooseRow()) == (long)this.m_rowIndex) {
                    }
                    delta = this.updateRow(updateRowIndex, delta);
                }
                this.m_rowCheckSumVal -= delta;
                this.insertRow();
            }
        }

        private void prepareVerifyStatements() throws SQLException, TestCaseException {
            this.m_verifyCheckSumStmt = this.m_connection[0].prepareStatement("SELECT CHECKSUMVAL,ROWINDEX FROM CHECKSUMTAB WHERE TASKID = ?", 1005, 1007);
            this.m_verifyCheckSumViaSumStmt = this.m_connection[0].prepareCall("SELECT SUM(CHECKSUMVAL) INTO ? FROM CHECKSUMTAB WHERE TASKID = ?");
        }

        private void verifyCheckSum() throws SQLException, TestCaseException {
            int taskId = this.nextRand(m_maxTasks);
            this.m_verifyCheckSumStmt.setInt(1, taskId);
            ResultSet rs = this.m_verifyCheckSumStmt.executeQuery();
            int checkSum = 0;
            while (rs.next()) {
                int val = rs.getInt(1);
                long rowIndex = rs.getLong(2);
                MVMut.this.Trace(10, "RowIndex : " + rowIndex + ", Value : " + val);
                checkSum += val;
            }
            MVMut.this.Trace(9, "TASK" + this.m_processId + " : selected checkSum(TaskId = " + taskId + ") : " + checkSum);
            if (checkSum != m_checksum) {
                MVMut.writeProt(this.m_connection[0], "wrong checksum");
                MVMut.this.TraceError("unexpected checksum found by TASK" + this.m_processId + " : " + checkSum + ", expected " + m_checksum);
                this.abort();
            }
            rs.close();
        }

        private void verifyCheckSumViaSumFunction() throws SQLException, TestCaseException {
            int taskId = this.nextRand(m_maxTasks);
            this.m_verifyCheckSumViaSumStmt.setInt(2, taskId);
            this.m_verifyCheckSumViaSumStmt.registerOutParameter(1, 4);
            this.m_verifyCheckSumViaSumStmt.execute();
            long checkSum = this.m_verifyCheckSumViaSumStmt.getLong(1);
            MVMut.this.Trace(9, "TASK" + this.m_processId + " : selected checkSum via SUM (TaskId = " + taskId + ") : " + checkSum);
            if (checkSum != (long)m_checksum) {
                MVMut.writeProt(this.m_connection[0], "wrong checksum");
                MVMut.this.TraceError("unexpected checksum via function found by TASK" + this.m_processId + " : " + checkSum + ", expected " + m_checksum);
                this.abort();
            }
        }

        private void verifySum() throws SQLException, TestCaseException {
            int rand = this.nextRand(200);
            if (this.nextRand(100) > 100) {
                this.verifyCheckSumViaSumFunction();
            } else {
                this.verifyCheckSum();
            }
        }

        private void updaterTask() throws SQLException, TestCaseException {
            this.TaskTrace(1, "updaterTask started");
            this.prepareVerifyStatements();
            this.m_deleteStatement = new PreparedStatement[m_maxConnections];
            this.m_massUpdateStatement = new PreparedStatement[m_maxConnections];
            this.m_updateStatement = new PreparedStatement[m_maxConnections];
            this.m_insertStatement = new PreparedStatement[m_maxConnections];
            for (int ix = 0; ix < m_maxConnections; ++ix) {
                this.m_deleteStatement[ix] = this.m_connection[ix].prepareStatement("DELETE FROM CHECKSUMTAB WHERE ROWINDEX = ?");
                this.m_massUpdateStatement[ix] = this.m_connection[ix].prepareStatement("UPDATE CHECKSUMTAB SET CHECKSUMVAL = CHECKSUMVAL + 1 WHERE TASKID = ?");
                this.m_updateStatement[ix] = this.m_connection[ix].prepareStatement("UPDATE CHECKSUMTAB SET CHECKSUMVAL = CHECKSUMVAL + ? WHERE ROWINDEX = ?");
                this.m_insertStatement[ix] = this.m_connection[ix].prepareStatement("INSERT INTO CHECKSUMTAB VALUES (?,?,?,?,?,?)");
            }
            while (!m_stop) {
                this.executeUpdateTrans();
                this.verifySum();
                this.TransEnd();
            }
        }

        private void runConsistentViewHolder() throws SQLException, TestCaseException {
            this.TaskTrace(1, "runConsistentViewHolder started");
            TestStatement stmt = new TestStatement(null, this.m_connection[0]);
            stmt.executeUpdate("SET ISOLATION LEVEL 60");
            this.prepareVerifyStatements();
            while (!m_stop) {
                try {
                    Thread.sleep(this.m_sleep);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.verifySum();
                this.TaskTrace(9, "runConsistentViewHolder commit");
                this.m_connection[0].commit();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void run() {
            try {
                this.m_connection = new Connection[2];
                this.m_connection[0] = MVMut.connect(TestCase.getDatabase());
                while (!m_stop) {
                    try {
                        switch (this.m_test) {
                            case 1: {
                                if (null != MVMut.this.m_shadowDB) {
                                    this.m_connection[1] = MVMut.connect((TestDatabase)MVMut.this.m_shadowDB);
                                }
                                this.updaterTask();
                                break;
                            }
                            case 2: {
                                this.runConsistentViewHolder();
                            }
                        }
                    }
                    catch (SQLException sql_e) {
                        if (MVMut.this.dbCold()) {
                            MVMut.this.incWaitingTasks();
                            if (null != this.m_connection[1]) {
                                this.m_connection[1].rollback();
                            }
                            this.reconnect();
                            continue;
                        }
                        MVMut.this.Trace_1("Sql exception " + sql_e.getErrorCode() + " catched in Task " + this.m_processId);
                        throw sql_e;
                        return;
                    }
                }
            }
            catch (SQLException sql_e) {
                this.setSqlError(sql_e);
                MVMut.this.TraceError(sql_e.getMessage());
                sql_e.printStackTrace();
                return;
            }
            catch (Exception e) {
                MVMut.this.TraceError(e.getMessage());
                e.printStackTrace();
                this.exceptionHandler(e);
                return;
            }
            finally {
                try {
                    for (int ix = 0; ix < m_maxConnections; ++ix) {
                        if (null == this.m_connection[ix]) continue;
                        this.m_connection[ix].close();
                    }
                }
                catch (SQLException sql_e) {}
                MVMut.this.decRunningTasks();
            }
        }
    }

    abstract class MVMulti1Test {
        Connection[] m_connection = null;
        int m_processId = -1;
        int m_sleep = 0;
        int m_test = 0;
        Random m_random = null;
        int m_key2Counter;
        int m_rowTaskId;
        String m_rowKey1;
        int m_rowKey2;
        int m_rowIndexVal;
        int m_rowCheckSumVal;
        int m_rowIndex;
        PreparedStatement m_verifyCheckSumStmt = null;
        PreparedStatement[] m_deleteStatement = null;
        PreparedStatement[] m_massUpdateStatement = null;
        PreparedStatement[] m_updateStatement = null;
        PreparedStatement[] m_insertStatement = null;
        CallableStatement m_verifyCheckSumViaSumStmt = null;

        MVMulti1Test(int processId) {
            this.m_processId = processId;
            this.m_random = new Random(17 * processId);
            this.m_key2Counter = m_checkSumRowCount;
        }

        void TaskTrace(int level, String msg) {
            MVMut.this.Trace(level, "TASK" + this.m_processId + " : " + msg);
        }

        int nextRand(int max) {
            int r = Math.abs(this.m_random.nextInt()) % max;
            this.TaskTrace(9, "nextRand(" + max + ") : " + r);
            return r;
        }

        protected void exceptionHandler(Exception e) {
            MVMut.this.TraceError("Unknown exception in task " + this.m_processId + " " + e.getClass() + " " + e.getMessage());
            e.printStackTrace();
        }

        protected void reconnect() throws SQLException {
            this.m_connection[0] = null;
            Thread t = Thread.currentThread();
            while (MVMut.this.dbCold()) {
                if (m_stop) {
                    return;
                }
                try {
                    Thread.sleep(500L);
                }
                catch (Exception dummy) {}
            }
            try {
                this.m_connection[0] = MVMut.connect(TestCase.getDatabase());
                MVMut.this.Trace_1("Reconnect(" + this.m_processId + ") (T" + this.m_processId + ") ok");
            }
            catch (TestDatabaseException e) {
                throw new SQLException("cannot reconnect", "", -101);
            }
        }

        protected void setSqlError(SQLException e) {
            MVMut.this.TraceError("SQL Error in Task " + this.m_processId + " : " + e.getErrorCode() + " " + e.getMessage() + " " + e.getSQLState());
            MVMut.this.setGlobalSqlError(e);
        }
    }

    class MaxRunTimeTimer
    implements Runnable {
        private int m_intervall = 0;
        private Thread m_thread = null;

        MaxRunTimeTimer(int minutes) {
            this.m_intervall = minutes * 60000;
            this.start();
        }

        public void run() {
            try {
                Thread.sleep(this.m_intervall);
            }
            catch (Exception exception) {
                // empty catch block
            }
            m_stop = true;
            m_runTimeLimit = true;
        }

        public void start() {
            this.m_thread = new Thread(this);
            this.m_thread.setDaemon(true);
            this.m_thread.start();
        }
    }

    class Crash_Timer
    implements Runnable {
        private int m_intervall = 0;
        private int m_crashCnt = 0;
        private int m_commitsRunning = 0;
        private Thread m_thread = null;

        Crash_Timer(int intervall) {
            this.m_intervall = intervall * 1000;
            m_crashEvent = false;
            this.start();
        }

        public void restart() {
            m_crashEvent = false;
            this.m_commitsRunning = 0;
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean incCommitCounter() {
            Crash_Timer crash_Timer = this;
            synchronized (crash_Timer) {
                if (m_crashEvent) {
                    return false;
                }
                ++this.m_commitsRunning;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void decCommitCounter() {
            Crash_Timer crash_Timer = this;
            synchronized (crash_Timer) {
                --this.m_commitsRunning;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (0 == this.m_intervall) {
                return;
            }
            MVMut.this.Trace_1("CrashTimer : Sleep(" + this.m_intervall / 1000 + " seconds)");
            try {
                MVMut.this.Sleep(this.m_thread, this.m_intervall);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (m_stop) {
                return;
            }
            Connection con = null;
            try {
                con = MVMut.connect(TestCase.getDatabase());
            }
            catch (Exception e) {
                MVMut.this.Trace_1("crash : could not connect ");
                return;
            }
            ++this.m_crashCnt;
            MVMut.this.Trace_1("crash database(" + this.m_crashCnt + ")");
            try {
                CallableStatement call = con.prepareCall("CALL ABORT");
                MVMut.this.setCold(true);
                while (true) {
                    Crash_Timer crash_Timer = this;
                    synchronized (crash_Timer) {
                        m_crashEvent = true;
                        if (0 == this.m_commitsRunning) {
                            break;
                        }
                    }
                    try {
                        MVMut.this.Trace_1("waiting for commit completion ...");
                        MVMut.this.Sleep(this.m_thread, 10);
                    }
                    catch (Exception exception) {}
                }
                call.execute();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void start() {
            this.m_thread = new Thread(this);
            this.m_thread.setDaemon(true);
            this.m_thread.start();
        }
    }
}

