/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.multiversion;

import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.testcase.TestPreparedStatement;
import com.sap.sapdb.testframe.testcase.TestStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;

public class MVMulti1
extends TestCase {
    private static final String mExUser = "MVMULTI1";
    private static final String mExPassword = "MVMULTI1";
    private static final int TEST1 = 1;
    private static final int TEST2 = 2;
    private static int m_maxRunTime = 30;
    private static int m_traceLevel = 2;
    private static int m_StopTraceOnError = 0;
    private static int m_vtraceLevel = 0;
    private static int m_checkLevel = 0;
    private static boolean m_runTimeLimit = false;
    private static volatile boolean m_stop = false;
    private static volatile boolean m_crash = false;
    private static int m_tasks = 0;
    private static int m_sqlError = 0;
    private static String m_sqlErrorMsg;

    synchronized int getRunningTasks() {
        return m_tasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void incRunningTask() {
        MVMulti1 mVMulti1 = this;
        synchronized (mVMulti1) {
            ++m_tasks;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void decRunningTasks() {
        MVMulti1 mVMulti1 = this;
        synchronized (mVMulti1) {
            --m_tasks;
        }
    }

    synchronized void setGlobalSqlError(SQLException e) {
        if (0 == m_sqlError) {
            m_sqlError = e.getErrorCode();
            m_sqlErrorMsg = e.getMessage();
        }
    }

    synchronized int sqlError() {
        return m_sqlError;
    }

    public static long getTimeout() {
        return 60000 * m_maxRunTime;
    }

    private static void Trace(String msg) {
        System.out.println(msg);
        MVMulti1.addGlobalMessage((String)"", (char)'I', (String)msg);
    }

    private void TraceError(String msg) {
        System.out.println(msg);
        this.addMessage("Error", 'E', msg);
    }

    private void startTask(int processId, int test, int sleepDuration) throws SQLException, TestDatabaseException {
        this.incRunningTask();
        Task task = new Task(processId, test, sleepDuration);
    }

    public static void cleanUp() throws TestCaseException {
        System.out.println("End of " + MVMulti1.getTestClassId());
    }

    public static String getTestClassId() {
        return "MVMulti1";
    }

    private static void readParameters() {
        m_maxRunTime = MVMulti1.getParameterInt((String)"MAX_RUNTIME", (int)30);
        m_traceLevel = MVMulti1.getParameterInt((String)"TRACE_LEVEL", (int)1);
        m_StopTraceOnError = MVMulti1.getParameterInt((String)"STOP_TRACE_ON_ERROR", (int)0);
        m_vtraceLevel = MVMulti1.getParameterInt((String)"VTRACE_LEVEL", (int)0);
        m_checkLevel = MVMulti1.getParameterInt((String)"CHECK_LEVEL", (int)0);
        if (m_traceLevel > 0) {
            MVMulti1.Trace("TRACE_LEVEL         : " + m_traceLevel);
            MVMulti1.Trace("VTRACE_LEVEL        : " + m_vtraceLevel);
            MVMulti1.Trace("CHECK_LEVEL         : " + m_checkLevel);
            MVMulti1.Trace("STOP_TRACE_ON_ERROR : " + m_StopTraceOnError);
            MVMulti1.Trace("MAX_RUNTIME         : " + m_maxRunTime);
        }
        try {
            if (0 < m_vtraceLevel) {
                MVMulti1.getDatabase().executeDBMcmd("trace_on PRIMARY_TREE");
                MVMulti1.getDatabase().executeDBMcmd("trace_on DATATREE " + m_vtraceLevel);
                MVMulti1.getDatabase().executeDBMcmd("trace_on DATAINDEX " + m_vtraceLevel);
            }
            if (0 < m_vtraceLevel) {
                MVMulti1.getDatabase().executeDBMcmd("db_execute set parameter check_tree = 'YES'");
                MVMulti1.getDatabase().executeDBMcmd("db_execute set parameter check_dataindex = " + m_vtraceLevel);
            }
            if (m_StopTraceOnError != 0) {
                MVMulti1.getDatabase().executeDBMcmd("db_execute vtrace stop on error " + m_StopTraceOnError);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void prepare() throws TestCaseException {
        Connection conn = null;
        TestStatement stmt = null;
        Object prepstmt = null;
        MVMulti1.readParameters();
        System.out.println("Start of " + MVMulti1.getTestClassId());
        int lNoOfTableRows = MVMulti1.getParameterInt((String)"NoOfTableRows", (int)2000);
        try {
            conn = MVMulti1.getDatabase().connect(MVMulti1.getUser(), MVMulti1.getPassword());
            stmt = new TestStatement(null, conn);
            stmt.enableExceptions(false);
            stmt.executeUpdate("Drop user MVMULTI1");
            stmt.enableExceptions(true);
            stmt.executeUpdate("Create user MVMULTI1 password MVMULTI1 dba not exclusive");
            stmt.close();
            conn.commit();
            conn.close();
            conn = MVMulti1.getDatabase().connect("MVMULTI1", "MVMULTI1");
            stmt = new TestStatement(null, conn);
            try {
                stmt.executeUpdate("drop package mvr");
            }
            catch (SQLException e) {
                // empty catch block
            }
            stmt.executeUpdate("Create package mvr file'lctest'");
            stmt.executeUpdate("Create dbproc abort in mvr");
            conn.commit();
            stmt.executeUpdate("Create table MVMULTI1_1 (transid fixed(18,0), sessionid fixed(18,0), cnt fixed(18,0), c char(20), cl clob)");
            stmt.execute("GRANT ALL ON MVMULTI1_1 TO PUBLIC");
            stmt.executeUpdate("Create table MVMULTI1_2 (transid fixed(18,0) key, sessionid fixed(18,0) key, cnt fixed(18,0) key, c char(20), cl clob)");
            stmt.execute("GRANT ALL ON MVMULTI1_2 TO PUBLIC");
            stmt.executeUpdate("Create table MVMULTI1_3 (transid fixed(18,0) , sessionid fixed(18,0), cnt fixed(18,0), c char(20), cl clob)");
            stmt.execute("GRANT ALL ON MVMULTI1_3 TO PUBLIC");
            stmt.execute("CREATE INDEX MVMULTI1_3_IDX1 on MVMULTI1_3 (transid desc)");
            stmt.execute("CREATE INDEX MVMULTI1_3_IDX2 on MVMULTI1_3 (sessionid)");
            stmt.execute("CREATE INDEX MVMULTI1_2_IDX2 on MVMULTI1_2 (sessionid)");
            stmt.execute("CREATE UNIQUE INDEX MVMULTI1_1_IDX3 on MVMULTI1_1 (sessionid desc, transid, cnt)");
            conn.commit();
            stmt.execute("force savepoint");
            MVMulti1.addGlobalMessage((String)"Method prepare", (char)'I', (String)"just created MVMulti1");
            conn.close();
        }
        catch (SQLException e) {
            MVMulti1.Trace("*** stop because of error during prepare():" + e.getErrorCode() + " " + e.getMessage());
            throw new TestCaseException("Error during preparation: " + e.getClass() + e.getErrorCode() + " " + e.getMessage());
        }
        catch (Exception e) {
            MVMulti1.addGlobalMessage((String)"Method prepare", (char)'E', (String)"preparation failed");
            throw new TestCaseException("Error during preparation: " + e.getClass() + " " + e.getMessage());
        }
        finally {
            try {
                stmt.close();
            }
            catch (Exception e) {}
            try {
                prepstmt.close();
            }
            catch (Exception e) {}
            try {
                conn.commit();
                conn.close();
            }
            catch (Exception e) {}
        }
    }

    public void run() {
        try {
            MaxRunTimeTimer RunTimeTimer = new MaxRunTimeTimer(m_maxRunTime);
            int ix = 0;
            while (ix < 7 && 0 == this.sqlError() && !m_stop) {
                int i;
                MVMulti1.Trace(">>>--------------------   TEST 1 - " + ++ix + " --------------------<<<");
                for (i = 0; i < 2 + ix && !m_runTimeLimit; ++i) {
                    MVMulti1.Trace("      Start TEST1 task: " + i);
                    this.startTask(i, 1, m_maxRunTime);
                }
                MVMulti1.Trace("      Start TEST2 task: " + i);
                this.startTask(i, 2, m_maxRunTime);
                while (this.getRunningTasks() > 0 && 0 == this.sqlError()) {
                    Thread.sleep(100L);
                    if (!m_runTimeLimit) continue;
                    m_stop = true;
                }
                if (0 != this.sqlError() || m_stop) {
                    if (m_runTimeLimit) {
                        MVMulti1.Trace("*** stop runtime limit:" + this.sqlError());
                        while (this.getRunningTasks() > 0) {
                            Thread.sleep(100L);
                        }
                    } else {
                        MVMulti1.Trace("*** stop because of error:" + this.sqlError());
                        throw new TestCaseException("Error: " + this.sqlError());
                    }
                    m_stop = true;
                    continue;
                }
                m_crash = false;
                MVMulti1.getDatabase().executeDBMcmd("db_clear");
                boolean retry = true;
                while (retry) {
                    retry = false;
                    try {
                        MVMulti1.getDatabase().executeDBMcmd("db_admin");
                    }
                    catch (Exception e) {
                        Thread.sleep(100L);
                        retry = true;
                    }
                }
                MVMulti1.getDatabase().executeDBMcmd("db_online");
                MVMulti1.getDatabase().executeDBMcmd("sql_execute diagnose index mvmulti1_3_idx1 on mvmulti1.mvmulti1_3");
                MVMulti1.getDatabase().executeDBMcmd("sql_execute diagnose index mvmulti1_3_idx2 on mvmulti1.mvmulti1_3");
                MVMulti1.getDatabase().executeDBMcmd("sql_execute diagnose index mvmulti1_2_idx2 on mvmulti1.mvmulti1_2");
                MVMulti1.getDatabase().executeDBMcmd("sql_execute diagnose index mvmulti1_1_idx3 on mvmulti1.mvmulti1_1");
                m_stop = false;
            }
        }
        catch (Exception e) {
            this.handleExceptions(e);
        }
    }

    class Task
    extends MVMulti1Test
    implements Runnable {
        Task(int processId, int test, int sleepDuration) throws SQLException, TestDatabaseException {
            Thread t = new Thread(this);
            this.m_processId = processId;
            this.m_test = test;
            if (sleepDuration <= 0) {
                sleepDuration = 1;
            }
            this.m_sleep = sleepDuration;
            t.setDaemon(true);
            t.start();
        }

        private void execDelStmt1(TestPreparedStatement stmt, int transcount, int sessionid, String traceinfo) throws SQLException, TestCaseException {
            stmt.setInt(1, transcount);
            try {
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                m_stop = true;
                MVMulti1.Trace("*** error with " + traceinfo + ": " + e.getErrorCode() + " " + e.getMessage());
                MVMulti1.Trace("Call Abort() to terminate! session:" + sessionid);
                stmt.executeUpdate("call abort");
                throw new TestCaseException("Error with " + traceinfo + ": " + e.getClass() + e.getErrorCode() + " " + e.getMessage());
            }
            try {
                Thread.sleep(1L);
            }
            catch (Exception e) {
                // empty catch block
            }
        }

        private int execDelStmt2(TestPreparedStatement stmt, int transcount, int sessionid, String traceinfo) throws SQLException, TestCaseException {
            int resCount = 0;
            stmt.setInt(1, transcount);
            try {
                stmt.executeUpdate();
                resCount = stmt.getResultCounter();
            }
            catch (SQLException e) {
                m_stop = true;
                MVMulti1.Trace("*** error with " + traceinfo + ": " + e.getErrorCode() + " " + e.getMessage());
                MVMulti1.Trace("Call Abort() to terminate! session:" + sessionid);
                stmt.executeUpdate("call abort");
                throw new TestCaseException("Error with " + traceinfo + " " + e.getClass() + e.getErrorCode() + " " + e.getMessage());
            }
            try {
                Thread.sleep(1L);
            }
            catch (Exception e) {
                // empty catch block
            }
            return resCount;
        }

        private void execInsStmt1(TestPreparedStatement stmt, int transcount, int sessionid, int idx, String comment, String traceinfo, String clstring) throws SQLException, TestCaseException {
            stmt.setInt(1, transcount);
            stmt.setInt(2, sessionid);
            stmt.setString(4, comment);
            stmt.setInt(3, idx);
            stmt.setString(5, clstring);
            try {
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                m_stop = true;
                MVMulti1.Trace("*** error with " + traceinfo + ": " + e.getErrorCode() + " " + e.getMessage());
                MVMulti1.Trace("Call Abort() to terminate! session:" + sessionid);
                stmt.executeUpdate("call abort");
                throw new TestCaseException("Error with " + traceinfo + ": " + e.getClass() + e.getErrorCode() + " " + e.getMessage());
            }
            try {
                Thread.sleep(1L);
            }
            catch (Exception e) {
                // empty catch block
            }
        }

        private void execQueryStmt1(String query, int transcount, int transcount_old, int sessionid, int loopcount, int loopcount_old, boolean bCommit) throws SQLException, TestCaseException {
            TestStatement stmt;
            block4: {
                stmt = new TestStatement(null, this.m_connection, 1005, 1007);
                try {
                    ResultSet rs = stmt.executeQuery(query);
                    rs.next();
                    if (rs.getInt("cnt") == loopcount_old) break block4;
                    m_stop = true;
                    MVMulti1.Trace("Error in Query:" + query);
                    MVMulti1.Trace("Transcount:" + transcount + " Transcount_old:" + transcount_old + " bCommit:" + bCommit + " number of results in T1 incorrect: " + rs.getInt("cnt") + " loopcount_old: " + loopcount_old + " session: " + sessionid);
                    String msg = "Call Abort() to terminate! session:" + sessionid;
                    MVMulti1.addGlobalMessage((String)"checkLiveCache", (char)'E', (String)msg);
                    MVMulti1.Trace(msg);
                    try {
                        stmt.executeUpdate("call abort");
                    }
                    catch (SQLException e) {
                        // empty catch block
                    }
                    throw new TestCaseException(msg);
                }
                catch (SQLException e) {
                    m_stop = true;
                    MVMulti1.Trace("*** error with ***" + query + "***: " + e.getErrorCode() + " " + e.getMessage());
                    MVMulti1.Trace("Call Abort() to terminate! session:" + sessionid);
                    stmt.executeUpdate("call abort");
                    throw new TestCaseException("Error with ***" + query + "***:: " + e.getClass() + e.getErrorCode() + " " + e.getMessage());
                }
            }
            stmt.close();
        }

        private void runtest1() throws SQLException, TestCaseException {
            TestStatement stmt = null;
            TestPreparedStatement prepstmt1 = null;
            TestPreparedStatement prepstmt2 = null;
            TestPreparedStatement prepstmt3 = null;
            TestPreparedStatement upd_prepstmt1 = null;
            TestPreparedStatement upd_prepstmt2 = null;
            TestPreparedStatement upd_prepstmt3 = null;
            TestPreparedStatement del_prepstmt1 = null;
            TestPreparedStatement del_prepstmt2 = null;
            TestPreparedStatement del_prepstmt3 = null;
            int sessionid = 0;
            int transcount = 0;
            int sessionid_old = 0;
            int transcount_old = 0;
            int loopcount_old = 0;
            prepstmt1 = new TestPreparedStatement(null, this.m_connection, "Insert MVMULTI1_1 values (?, ?, ?, ?, ?)");
            prepstmt2 = new TestPreparedStatement(null, this.m_connection, "Insert MVMULTI1_2 values (?, ?, ?, ?, ?)");
            prepstmt3 = new TestPreparedStatement(null, this.m_connection, "Insert MVMULTI1_3 values (?, ?, ?, ?, ?)");
            upd_prepstmt1 = new TestPreparedStatement(null, this.m_connection, "update MVMULTI1_1 set cnt = cnt + 10000, cl = ? where transid = ?");
            upd_prepstmt2 = new TestPreparedStatement(null, this.m_connection, "update MVMULTI1_2 set cnt = cnt + 10000, cl = ? where transid = ?");
            upd_prepstmt3 = new TestPreparedStatement(null, this.m_connection, "update MVMULTI1_3 set cnt = cnt + 10000, cl = ? where transid = ?");
            del_prepstmt1 = new TestPreparedStatement(null, this.m_connection, "delete from MVMULTI1_1 where transid = ?");
            del_prepstmt2 = new TestPreparedStatement(null, this.m_connection, "delete from MVMULTI1_2 where transid = ?");
            del_prepstmt3 = new TestPreparedStatement(null, this.m_connection, "delete from MVMULTI1_3 where transid = ?");
            stmt = new TestStatement(null, this.m_connection, 1005, 1007);
            boolean bCommit = true;
            for (int ix = 1; !(ix >= 20 && m_crash || m_stop); ix += 7) {
                if (ix >= 20) {
                    m_crash = true;
                }
                bCommit = true;
                for (int iy = 0; iy < 121 && !m_stop; iy += 13) {
                    String msg;
                    boolean bEntryFound = false;
                    int loopcount = ix + 1 + (iy + 1) + 100;
                    ResultSet rs = stmt.executeQuery("select s.sessionid, num(t.transcount) transcount from sessions s, transactions t where s.own='YES' and s.sessionid = t.session");
                    while (rs.next() && !m_stop) {
                        String cl;
                        int iz;
                        if (bEntryFound) {
                            m_stop = true;
                            MVMulti1.Trace("second OWN transaction found !");
                            throw new TestCaseException("second OWN transaction found !");
                        }
                        bEntryFound = true;
                        sessionid = rs.getInt("sessionid");
                        transcount = rs.getInt("transcount");
                        String comment = "S" + sessionid;
                        this.execDelStmt1(del_prepstmt1, transcount, sessionid, "Delete1");
                        this.execDelStmt1(del_prepstmt2, transcount, sessionid, "Delete2");
                        this.execDelStmt1(del_prepstmt3, transcount, sessionid, "Delete3");
                        this.m_connection.commit();
                        if (m_stop) continue;
                        for (iz = 0; iz < loopcount; ++iz) {
                            cl = "X " + transcount + " " + sessionid + " " + iz + comment + " xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxXXXXXXXXXXXX" + " yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy" + " zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz";
                            this.execInsStmt1(prepstmt1, transcount, sessionid, iz, comment, "Update1", cl);
                            this.execInsStmt1(prepstmt2, transcount, sessionid, loopcount - 1 - iz, comment, "Update2", cl);
                        }
                        for (iz = 0; iz < loopcount; ++iz) {
                            cl = "X " + transcount + " " + sessionid + " " + iz + comment + " xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxXXXXXXXXXXXX" + " yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy" + " zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz";
                            this.execInsStmt1(prepstmt3, transcount, sessionid, iz, comment, "Update3", cl);
                        }
                    }
                    rs.close();
                    int resCount1 = 0;
                    int resCount2 = 0;
                    int resCount3 = 0;
                    if (transcount_old != 0 && !m_stop) {
                        resCount1 = this.execDelStmt2(del_prepstmt1, transcount_old, sessionid, "Delete_1");
                        resCount2 = this.execDelStmt2(del_prepstmt2, transcount_old, sessionid, "Delete_2");
                        resCount3 = this.execDelStmt2(del_prepstmt3, transcount_old, sessionid, "Delete_3");
                        if (resCount1 != resCount2 || resCount1 != resCount3 || resCount1 != loopcount_old && bCommit) {
                            m_stop = true;
                            msg = "Transcount:" + transcount + " Transcount_old:" + transcount_old + " bCommit:" + bCommit + " DeleteCounts are different: " + resCount1 + ", " + resCount2 + ", " + resCount3 + ", " + loopcount_old + " session: " + sessionid;
                            MVMulti1.Trace(msg);
                            msg = "Call Abort() to terminate! session:" + sessionid;
                            MVMulti1.Trace(msg);
                            try {
                                stmt.executeUpdate("call abort");
                            }
                            catch (SQLException e) {
                                // empty catch block
                            }
                            throw new TestCaseException(msg);
                        }
                    }
                    if (m_crash) {
                        if (m_stop) break;
                        MVMulti1.Trace("CRASH wanted ! Waiting for other threads to terminate");
                        m_stop = true;
                        while (MVMulti1.this.getRunningTasks() > 1 && 0 == MVMulti1.this.sqlError()) {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (Exception e) {}
                        }
                        if (0 != MVMulti1.this.sqlError()) break;
                        msg = "Call Abort() to Crash! session:" + sessionid;
                        MVMulti1.Trace(msg);
                        try {
                            stmt.executeUpdate("call abort");
                        }
                        catch (SQLException e) {
                            // empty catch block
                        }
                        m_stop = false;
                        break;
                    }
                    if (bCommit) {
                        sessionid_old = sessionid;
                        transcount_old = transcount;
                        loopcount_old = loopcount;
                        bCommit = false;
                        this.m_connection.commit();
                    } else {
                        bCommit = true;
                        this.m_connection.rollback();
                    }
                    if (!m_stop) {
                        this.execQueryStmt1("select count(*) cnt from MVMULTI1_1 where transid = " + transcount_old + " ", transcount, transcount_old, sessionid, loopcount, loopcount_old, bCommit);
                        this.execQueryStmt1("select count(*) cnt from MVMULTI1_2 where transid = " + transcount_old + " ", transcount, transcount_old, sessionid, loopcount, loopcount_old, bCommit);
                        this.execQueryStmt1("select count(*) cnt from MVMULTI1_3 where transid = " + transcount_old + " ", transcount, transcount_old, sessionid, loopcount, loopcount_old, bCommit);
                    }
                    try {
                        if (loopcount == 10 || loopcount == 30 || loopcount == 70) {
                            Thread.sleep(50000L);
                        } else {
                            Thread.sleep(1L);
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (transcount_old != 0 && !m_stop) {
                        upd_prepstmt1.setString(1, "Hugo was here" + transcount + " " + transcount_old);
                        upd_prepstmt1.setInt(2, transcount);
                        upd_prepstmt1.executeUpdate();
                        if (upd_prepstmt1.getResultCounter() != loopcount && !bCommit || upd_prepstmt1.getResultCounter() != 0 && upd_prepstmt1.getResultCounter() != loopcount && bCommit) {
                            m_stop = true;
                            msg = "Transcount:" + transcount + " Transcount_old:" + transcount_old + " bCommit:" + bCommit + " number updates in T1 incorrect: " + upd_prepstmt1.getResultCounter() + " loopcount: " + loopcount;
                            MVMulti1.Trace(msg);
                            MVMulti1.addGlobalMessage((String)"checkLiveCache", (char)'E', (String)msg);
                            throw new TestCaseException(msg);
                        }
                        try {
                            Thread.sleep(1L);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        upd_prepstmt2.setString(1, "Hugo was here" + transcount + " " + transcount_old);
                        upd_prepstmt2.setInt(2, transcount);
                        upd_prepstmt2.executeUpdate();
                        if (upd_prepstmt2.getResultCounter() != loopcount && !bCommit || upd_prepstmt2.getResultCounter() != 0 && upd_prepstmt2.getResultCounter() != loopcount && bCommit) {
                            m_stop = true;
                            msg = "Transcount:" + transcount + " Transcount_old:" + transcount_old + " bCommit:" + bCommit + " number updates in T2 incorrect: " + upd_prepstmt2.getResultCounter() + " loopcount: " + loopcount;
                            MVMulti1.Trace(msg);
                            MVMulti1.addGlobalMessage((String)"checkLiveCache", (char)'E', (String)msg);
                            throw new TestCaseException(msg);
                        }
                        try {
                            Thread.sleep(1L);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        upd_prepstmt3.setString(1, "Hugo was here" + transcount + " " + transcount_old);
                        upd_prepstmt3.setInt(2, transcount);
                        upd_prepstmt3.executeUpdate();
                        if (upd_prepstmt3.getResultCounter() != loopcount && !bCommit || upd_prepstmt3.getResultCounter() != 0 && upd_prepstmt3.getResultCounter() != loopcount && bCommit) {
                            m_stop = true;
                            msg = "Transcount:" + transcount + " Transcount_old:" + transcount_old + " bCommit:" + bCommit + " number updates in T3 incorrect: " + upd_prepstmt3.getResultCounter() + " loopcount: " + loopcount;
                            MVMulti1.Trace(msg);
                            MVMulti1.addGlobalMessage((String)"checkLiveCache", (char)'E', (String)msg);
                            throw new TestCaseException(msg);
                        }
                        try {
                            Thread.sleep(1L);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        this.m_connection.commit();
                    }
                    if (transcount_old == 0 || m_stop || !bCommit) continue;
                    upd_prepstmt1.setString(1, "Otto came and stayed too long" + transcount_old);
                    upd_prepstmt1.setInt(2, transcount_old);
                    upd_prepstmt1.executeUpdate();
                    if (upd_prepstmt1.getResultCounter() != 0 && upd_prepstmt1.getResultCounter() != loopcount_old) {
                        m_stop = true;
                        msg = "Transcount:" + transcount + " Transcount_old:" + transcount_old + " bCommit:" + bCommit + " number updates in T1 incorrect: " + upd_prepstmt1.getResultCounter() + " loopcount_old: " + loopcount_old;
                        MVMulti1.Trace(msg);
                        MVMulti1.addGlobalMessage((String)"checkLiveCache", (char)'E', (String)msg);
                        throw new TestCaseException(msg);
                    }
                    try {
                        Thread.sleep(1L);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    upd_prepstmt2.setString(1, "Otto came and stayed too long" + transcount_old);
                    upd_prepstmt2.setInt(2, transcount_old);
                    upd_prepstmt2.executeUpdate();
                    if (upd_prepstmt2.getResultCounter() != 0 && upd_prepstmt2.getResultCounter() != loopcount_old) {
                        m_stop = true;
                        msg = "Transcount:" + transcount + " Transcount_old:" + transcount_old + " bCommit:" + bCommit + " number updates in T2 incorrect: " + upd_prepstmt2.getResultCounter() + " loopcount_old: " + loopcount_old;
                        MVMulti1.Trace(msg);
                        MVMulti1.addGlobalMessage((String)"checkLiveCache", (char)'E', (String)msg);
                        throw new TestCaseException(msg);
                    }
                    try {
                        Thread.sleep(1L);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    upd_prepstmt3.setString(1, "Otto came and stayed too long" + transcount_old);
                    upd_prepstmt3.setInt(2, transcount_old);
                    upd_prepstmt3.executeUpdate();
                    if (upd_prepstmt3.getResultCounter() != 0 && upd_prepstmt3.getResultCounter() != loopcount_old) {
                        m_stop = true;
                        msg = "Transcount:" + transcount + " Transcount_old:" + transcount_old + " bCommit:" + bCommit + " number updates in T3 incorrect: " + upd_prepstmt3.getResultCounter() + " loopcount_old: " + loopcount_old;
                        MVMulti1.Trace(msg);
                        MVMulti1.addGlobalMessage((String)"checkLiveCache", (char)'E', (String)msg);
                        throw new TestCaseException(msg);
                    }
                    try {
                        Thread.sleep(1L);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    this.m_connection.commit();
                }
                if (m_stop) continue;
                MVMulti1.Trace(" iteration: " + ix + " done for session: " + sessionid);
            }
        }

        private void runtest2() throws SQLException, TestCaseException {
            this.m_connection.commit();
            TestStatement stmt = new TestStatement(null, this.m_connection, 1005, 1007);
            stmt.execute("set isolation level 60");
            this.m_connection.commit();
            int count = 0;
            while (MVMulti1.this.getRunningTasks() > 1 && 0 == MVMulti1.this.sqlError() && !m_stop && !m_crash) {
                ++count;
                try {
                    Thread.sleep(10000L);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (m_stop || MVMulti1.this.getRunningTasks() <= 1) break;
                String cStmt = "select sessionid from mvmulti1_3 order by sessionid desc";
                ResultSet rs = stmt.executeQuery(cStmt);
                int l_sessionid = 0;
                if (rs.next() && !m_stop) {
                    l_sessionid = rs.getInt(1);
                }
                while (rs.next() && !m_stop && !m_crash) {
                    int val = rs.getInt(1);
                    if (l_sessionid < val) {
                        MVMulti1.Trace("reverse-iterator delivered wong result");
                        throw new TestCaseException("reverse-iterator delivered wong result");
                    }
                    l_sessionid = val;
                }
                if (m_crash || m_stop || MVMulti1.this.getRunningTasks() <= 1) {
                    rs.close();
                    break;
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (!m_crash && !m_stop && MVMulti1.this.getRunningTasks() > 1) continue;
                rs.close();
                break;
            }
            this.m_connection.commit();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Thread t = Thread.currentThread();
                this.m_connection = TestCase.getDatabase().connect("MVMULTI1", "MVMULTI1");
                this.m_connection.setAutoCommit(false);
                Object call = null;
                switch (this.m_test) {
                    case 1: {
                        this.runtest1();
                        break;
                    }
                    case 2: {
                        this.runtest2();
                    }
                }
            }
            catch (SQLException sql_e) {
                this.setSqlError(sql_e);
            }
            catch (Exception e) {
                this.exceptionHandler(e);
            }
            finally {
                try {
                    this.m_connection.close();
                }
                catch (SQLException sql_e) {}
                MVMulti1.this.decRunningTasks();
            }
        }
    }

    abstract class MVMulti1Test {
        Connection m_connection = null;
        int m_processId = -1;
        int m_sleep = 0;
        int m_test = 0;

        MVMulti1Test() {
        }

        protected void exceptionHandler(Exception e) {
            MVMulti1.this.TraceError("Unknown exception in task " + this.m_processId + " " + e.getClass() + " " + e.getMessage());
            e.printStackTrace();
        }

        protected void setSqlError(SQLException e) {
            MVMulti1.this.TraceError("SQL Error in Task " + this.m_processId + " : " + e.getErrorCode() + " " + e.getMessage() + " " + e.getSQLState());
            MVMulti1.this.setGlobalSqlError(e);
        }
    }

    class MaxRunTimeTimer
    implements Runnable {
        private int m_intervall = 0;
        private Thread m_thread = null;

        MaxRunTimeTimer(int intervall) {
            this.m_intervall = intervall * 60000;
            this.start();
        }

        public void run() {
            try {
                Thread.sleep(this.m_intervall);
            }
            catch (Exception exception) {
                // empty catch block
            }
            m_runTimeLimit = true;
        }

        public void start() {
            this.m_thread = new Thread(this);
            this.m_thread.setDaemon(true);
            this.m_thread.start();
        }
    }
}

