/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.migration;

import com.sap.dbtech.powertoys.DBM;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDatabaseSap;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.testcase.TestStatement;
import com.sap.sapdb.testframe.testcase.VerificationDataComplete;
import com.sap.sapdb.testframe.utilities.Zipper;
import com.sap.sapdb.testframe.utilities.webdav.WebDAVClient;
import com.sap.sapdb.testframe.utilities.webdav.protocol.WebDAVException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class RecoverFromPreviousBuild
extends TestCase {
    private DBM mDBMan = null;
    protected Connection myConnection = null;
    protected TestStatement myStatement = null;
    protected WebDAVClient client = null;
    private String pltf;
    private String createBackup;
    private String webDavDir;
    private String ownRelease = null;
    private String ownReleaseShort = null;
    private int ownBuild = 0;
    private String addFilename = null;
    private String fileSep = null;
    private Properties conProps = null;
    private Properties conProps2 = null;
    private Properties conPropsDba = null;
    private String rundir = null;
    private String testUser = null;
    private String testPassword = null;
    protected static final String mVersion = "3.3";

    public static String getTestClassId() {
        return "RecoverFromPreviousBuild";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int buildCtr;
        block120: {
            String token;
            this.testUser = "migrtst";
            this.testPassword = "migrtst";
            boolean autoCommit = true;
            this.fileSep = System.getProperty("file.separator");
            buildCtr = 0;
            String veriFilename = null;
            String url = null;
            boolean exists = false;
            Vector releases = null;
            Vector builds = null;
            String releaseName = null;
            String buildName = null;
            System.out.println(RecoverFromPreviousBuild.getTestClassId() + " in version " + mVersion + " started");
            this.addMessage(RecoverFromPreviousBuild.getTestClassId(), 'I', "Test in version 3.3 started.");
            try {
                this.rundir = ((TestDatabaseSap)RecoverFromPreviousBuild.getDatabase()).getRunDir();
            }
            catch (TestDatabaseException e) {
                this.addMessage("run()", 'E', "Cannot determine RUNDIRECTORY.");
                this.addMessage("run()", 'E', "Exception: " + e.getMessage());
            }
            this.webDavDir = RecoverFromPreviousBuild.getParameterString((String)"webDavDir", (String)"");
            if (this.webDavDir == null || this.webDavDir.equals("")) {
                this.addMessage("run()", 'E', "Cannot determine WebDAV directory.");
            }
            this.pltf = RecoverFromPreviousBuild.getParameterString((String)"pltf", (String)"");
            this.createBackup = RecoverFromPreviousBuild.getParameterString((String)"createBackup", (String)"false");
            String backupsToTest = RecoverFromPreviousBuild.getParameterString((String)"backups", (String)"");
            String kernelSpeed = RecoverFromPreviousBuild.getParameterString((String)"kernelSpeed", (String)"slow");
            StringTokenizer st = new StringTokenizer(this.executeDBMCmd("param_getvalue kernelversion"));
            String releaseDir = null;
            if (st.hasMoreTokens()) {
                token = st.nextToken();
                if (token.equals("error")) {
                    this.addMessage("run()", 'E', "Cannot determine release using 'param_getvalue kernelversion'.");
                } else if (!st.hasMoreTokens()) {
                    this.addMessage("run()", 'E', "Cannot determine release using 'param_getvalue kernelversion'.");
                } else {
                    this.ownRelease = token = st.nextToken();
                    if (!st.hasMoreTokens()) {
                        this.addMessage("run()", 'E', "Cannot determine release using 'param_getvalue kernelversion'.");
                        this.ownRelease = null;
                    } else {
                        token = st.nextToken();
                        if (st.hasMoreTokens()) {
                            token = st.nextToken();
                            this.ownBuild = new Integer(token.substring(0, 3));
                        } else {
                            this.addMessage("run()", 'E', "Cannot determine build using 'param_getvalue kernelversion'.");
                            this.ownRelease = null;
                            this.ownBuild = 0;
                        }
                    }
                }
            }
            try {
                this.client = new WebDAVClient(new URL("http://" + this.webDavDir));
                releases = this.client.list("", 1);
                if (releases == null) {
                    this.addMessage("run()", 'E', "Cannot read releases from WebDAV host.");
                    break block120;
                }
                for (int i = 1; i < releases.size() && !this.isInterrupted(); ++i) {
                    releaseName = (String)releases.get(i);
                    this.ownReleaseShort = "";
                    if (this.ownRelease != null) {
                        this.ownReleaseShort = this.ownRelease.substring(this.ownRelease.length() - 2, this.ownRelease.length() - 1).equals("0") ? this.ownRelease.substring(0, this.ownRelease.length() - 2) + this.ownRelease.substring(this.ownRelease.length() - 1, this.ownRelease.length()) : this.ownRelease;
                    }
                    if (releaseName.equals("") || releaseName.compareTo(this.ownReleaseShort) > 0) continue;
                    releaseDir = "http://" + this.webDavDir + "/" + releaseName;
                    builds = this.client.list(releaseDir, 1);
                    if (builds == null) {
                        this.addMessage("run()", 'E', "Cannot read builds from WebDAV host.");
                        continue;
                    }
                    for (int j = 1; j < builds.size() && !this.isInterrupted(); ++j) {
                        buildName = (String)builds.get(j);
                        if (buildName.equals("")) continue;
                        if (buildName.endsWith("/")) {
                            buildName = buildName.substring(0, buildName.length() - 1);
                        }
                        int buildNo = new Integer(buildName.substring(2));
                        String releaseNameWithBuild = releaseName + "." + buildNo;
                        if (releaseName.compareTo(this.ownReleaseShort) >= 0 && buildNo >= this.ownBuild || backupsToTest != null && !backupsToTest.equals("") && backupsToTest.indexOf(releaseNameWithBuild) == -1) continue;
                        String os = this.getOsDir();
                        if (os == null) {
                            this.addMessage("run()", 'E', "Cannot determine OS directory on WebDAV server.");
                            continue;
                        }
                        int unicodeOnly = 0;
                        if (this.ownRelease.startsWith("7.7")) {
                            unicodeOnly = 1;
                        }
                        for (int u = unicodeOnly; u < 2; ++u) {
                            String backupName = u == 0 ? "migrtst" : "migrtstu";
                            try {
                                url = releaseDir + "/" + buildName + "/" + os + "/" + backupName + ".zip";
                                System.out.println("Trying to recover " + releaseName + "." + buildNo + " backup...");
                                this.addMessage("run()", 'I', "Trying to recover " + releaseName + "." + buildNo + " backup.");
                                exists = this.downloadFromWebdav(url, this.getDataInputPath() + this.fileSep + backupName + ".zip");
                                if (exists) {
                                    ++buildCtr;
                                } else {
                                    this.addMessage("run()", 'I', "Backup file " + url + " does not exist on WebDAV server.");
                                }
                            }
                            catch (Exception e) {
                                this.addMessage("run()", 'E', "Error during download of backup file, download location: " + url);
                                this.addMessage("run()", 'E', "Exception: " + e.getMessage() + " " + e.getClass());
                                StringWriter sw = new StringWriter();
                                e.printStackTrace(new PrintWriter(sw));
                                this.addMessage("run()", 'T', "Exception stackbacktrace: " + sw.toString());
                            }
                            if (!exists) continue;
                            this.addMessage("run()", 'I', "Backup " + url + " exists - trying recovery and verification.");
                            try {
                                System.out.println("Extracting backup file...");
                                this.extractFile(this.getDataInputPath() + this.fileSep + backupName + ".zip", this.rundir);
                            }
                            catch (Exception e) {
                                this.addMessage("run()", 'E', "Extracting backup file from " + this.getDataInputPath() + this.fileSep + backupName + ".zip to " + this.rundir + this.fileSep + backupName + " failed.");
                                this.addMessage("run()", 'E', "Exception: " + e.getMessage());
                                e.printStackTrace();
                            }
                            veriFilename = "verification.txt";
                            this.addFilename = "addstmt.sql";
                            if (!new File(this.rundir + this.fileSep + backupName).canRead()) {
                                this.addMessage("run()", 'E', "Backup medium " + this.getDataInputPath() + this.fileSep + backupName + " not accessible.");
                                continue;
                            }
                            if (!new File(this.getDataInputPath() + this.fileSep + veriFilename).canRead()) {
                                this.addMessage("run()", 'E', "Verification data file " + this.getDataInputPath() + this.fileSep + veriFilename + " not accessible.");
                                continue;
                            }
                            try {
                                ResultSet result;
                                block125: {
                                    this.conPropsDba = new Properties();
                                    this.conPropsDba.put("user", RecoverFromPreviousBuild.getDatabase().getUser());
                                    this.conPropsDba.put("password", RecoverFromPreviousBuild.getDatabase().getPassword());
                                    this.conPropsDba.put("autocommit", "on");
                                    this.conProps = new Properties();
                                    this.conProps.put("user", this.testUser);
                                    this.conProps.put("password", this.testPassword);
                                    if (autoCommit) {
                                        this.conProps.put("autocommit", "on");
                                    } else {
                                        this.conProps.put("autocommit", "off");
                                    }
                                    this.conProps2 = new Properties();
                                    this.conProps2.put("user", this.testUser + "2");
                                    this.conProps2.put("password", this.testPassword + "2");
                                    if (autoCommit) {
                                        this.conProps2.put("autocommit", "on");
                                    } else {
                                        this.conProps2.put("autocommit", "off");
                                    }
                                    System.out.println("Switching DB to offline state...");
                                    this.executeDBMCmd("db_offline");
                                    if (!this.ownRelease.startsWith("7.7")) {
                                        if (u == 1) {
                                            System.out.println("Setting _UNICODE to YES...");
                                            this.executeDBMCmd("param_directput _UNICODE YES");
                                            this.executeDBMCmd("param_checkall");
                                        } else {
                                            System.out.println("Setting _UNICODE to NO...");
                                            this.executeDBMCmd("param_directput _UNICODE NO");
                                            this.executeDBMCmd("param_checkall");
                                        }
                                    }
                                    System.out.println("Switching DB to admin state (" + kernelSpeed + " kernel)...");
                                    this.executeDBMCmd("db_admin -" + kernelSpeed);
                                    System.out.println("Clearing log...");
                                    this.executeDBMCmd("util_execute clear log");
                                    System.out.println("Recovering...");
                                    this.executeDBMCmd("util_connect");
                                    this.executeDBMCmd("backup_media_put " + backupName + " " + backupName + " file data 0 8 yes no");
                                    this.executeDBMCmd("recover_start " + backupName + " data");
                                    this.executeDBMCmd("util_release");
                                    System.out.println("Switching DB to online state (" + kernelSpeed + " kernel)...");
                                    this.executeDBMCmd("db_online -" + kernelSpeed);
                                    System.out.println("Loading system tables...");
                                    this.executeDBMCmd("load_systab -ud domain");
                                    if (releaseName.startsWith("7.3")) {
                                        System.out.println("Re-creating bad index...");
                                        this.executeDBMCmd("sql_recreateindex \"MIGRTST\".\"TAB1\".\"CONSTR3\"");
                                    }
                                    System.out.println("Executing CHECK DATA...");
                                    this.executeDBMCmd("db_execute check data");
                                    this.myConnection = RecoverFromPreviousBuild.getDatabase().connect(this.conPropsDba);
                                    this.myStatement = new TestStatement((TestCase)this, this.myConnection, 1005, 1007);
                                    try {
                                        this.myStatement.executeQuery("SELECT * FROM POSTUPGRADECHECKLIST");
                                        result = this.myStatement.getResultSet();
                                        if (result != null && result.first()) {
                                            this.addMessage("run()", 'I', "\"SELECT * FROM POSTUPGRADECHECKLIST\" after load_systab -> POSTUPGRADECHECKLIST contains rows.");
                                        } else {
                                            this.addMessage("run()", 'I', "\"SELECT * FROM POSTUPGRADECHECKLIST\" after load_systab -> POSTUPGRADECHECKLIST is empty.");
                                        }
                                    }
                                    catch (SQLException e) {
                                        this.addMessage("run()", 'E', "Trying \"SELECT * FROM POSTUPGRADECHECKLIST\" after load_systab -> getting SQLException: " + e.getMessage());
                                    }
                                    finally {
                                        this.myConnection.close();
                                    }
                                    if (this.ownRelease.startsWith("7.7.02")) {
                                        System.out.println("Checking date and time in view V1...");
                                        this.myConnection = RecoverFromPreviousBuild.getDatabase().connect(this.conProps);
                                        this.myStatement = new TestStatement((TestCase)this, this.myConnection, 1005, 1007);
                                        try {
                                            this.myStatement.executeQuery("SELECT DISTINCT COL10, COL11, TIMESTAMP(COL10, COL11) FROM V1");
                                            result = this.myStatement.getResultSet();
                                            if (result != null && result.next()) {
                                                String dateString = result.getString(1);
                                                String timeString = result.getString(2);
                                                String timestampString = result.getString(3);
                                                System.out.println("DATE: '" + dateString + "', TIME: '" + timeString + "' , TIMESTAMP: '" + timestampString + "'");
                                                if (this.checkDbDate(dateString, timeString, timestampString)) {
                                                    this.addMessage("run()", 'I', "Check of DATE, TIME and TIMESTAMP from view V1 successful.");
                                                }
                                            }
                                        }
                                        catch (SQLException e) {
                                            this.addMessage("run()", 'E', "Trying \"SELECT DISTINCT COL10, COL11, TIMESTAMP(COL10, COL11) FROM V1\" -> getting SQLException: " + e.getMessage());
                                        }
                                        finally {
                                            this.myConnection.close();
                                        }
                                    }
                                    if (releaseName.startsWith("7.3") && u == 0) {
                                        System.out.println("Migrating catalog to UNICODE...");
                                        this.myConnection = RecoverFromPreviousBuild.getDatabase().connect(this.conProps);
                                        this.myStatement = new TestStatement((TestCase)this, this.myConnection, 1005, 1007);
                                        try {
                                            this.myStatement.executeUpdate("DROP DBPROC DO_INSERTS_2");
                                            this.myStatement.executeUpdate("CREATE DBPROC DO_INSERTS_2 AS VAR I INTEGER; SET I = 1; WHILE I <= 20 DO BEGIN INSERT INTO MIGRTST.TAB2 VALUES (RFILL(ASCII(''), '1234567890' ,8000), CHR(:I)); IF $RC <> 0 THEN STOP ($RC, $ERRMSG); SET I = I + 1; END;");
                                        }
                                        catch (SQLException e) {
                                            this.addMessage("run()", 'E', "Trying to re-create dbproc DO_INSERTS_2 -> getting SQLException: " + e.getMessage());
                                        }
                                        finally {
                                            this.myConnection.close();
                                        }
                                        this.executeDBMCmd("db_offline");
                                        this.executeDBMCmd("db_migratecatalog");
                                        this.myConnection = RecoverFromPreviousBuild.getDatabase().connect(this.conProps);
                                        this.reCreateDbprocs(this.myConnection);
                                        this.myConnection.close();
                                        this.myConnection = RecoverFromPreviousBuild.getDatabase().connect(this.conPropsDba);
                                        this.myStatement = new TestStatement((TestCase)this, this.myConnection, 1005, 1007);
                                        try {
                                            this.myStatement.executeQuery("SELECT * FROM POSTUPGRADECHECKLISTUNICODE");
                                            result = this.myStatement.getResultSet();
                                            boolean resultOk = true;
                                            if (result != null && result.next()) {
                                                do {
                                                    if (result.getString("STATEMENT").indexOf("DO_INSERTS") > -1 || result.getString("STATEMENT").indexOf("SYSUPDSTATWANTED_DELETE") > -1 || result.getString("STATEMENT").indexOf("TQUERYREWRITERULES") > -1) continue;
                                                    resultOk = false;
                                                } while (result.next());
                                            } else {
                                                this.addMessage("run()", 'I', "\"SELECT * FROM POSTUPGRADECHECKLISTUNICODE\" after db_migratecatalog -> POSTUPGRADECHECKLISTUNICODE is empty.");
                                            }
                                            if (!resultOk) {
                                                this.addMessage("run()", 'I', "\"SELECT * FROM POSTUPGRADECHECKLISTUNICODE\" after db_migratecatalog -> Result:\n" + new VerificationDataComplete(result).toString());
                                                this.addMessage("run()", 'E', "POSTUPGRADECHECKLISTUNICODE not empty after UNICODE migration.");
                                            }
                                        }
                                        catch (SQLException e) {
                                            this.addMessage("run()", 'E', "Trying \"SELECT * FROM POSTUPGRADECHECKLISTUNICODE\" after db_migratecatalog -> getting SQLException: " + e.getMessage());
                                        }
                                        finally {
                                            this.myConnection.close();
                                        }
                                    }
                                    if (this.createBackup.equals("true") && !releaseName.startsWith("7.3")) {
                                        this.createBackupIfRequired(u);
                                    }
                                    System.out.println("Checking if default serial still works...");
                                    try {
                                        this.myConnection = RecoverFromPreviousBuild.getDatabase().connect(this.conProps2);
                                        this.myStatement = new TestStatement((TestCase)this, this.myConnection, 1005, 1007);
                                        try {
                                            this.myStatement.executeUpdate("insert into defcheck (datacol) values ('This is another row.')");
                                            this.addMessage("run()", 'I', "Check for default serial successful.");
                                        }
                                        catch (SQLException e) {
                                            if (e.getErrorCode() != -4004) {
                                                this.addMessage("run()", 'E', "Trying: insert into defcheck (datacol) values ('This is another row.')\n -> getting SQLException: " + e.getMessage());
                                                break block125;
                                            }
                                            this.addMessage("run()", 'I', "Table for default serial check does not exist in this backup, skipping check.");
                                        }
                                    }
                                    catch (TestDatabaseException te) {
                                        if (te.getMessage().indexOf("-4008") >= 0) {
                                            this.addMessage("run()", 'I', "User that owns table for default serial check does not exist in this backup, skipping check.");
                                        } else {
                                            this.addMessage("run()", 'W', "Trying to connect as user that owns table for default serial check -> getting SQLException: " + te.getMessage());
                                        }
                                    }
                                    finally {
                                        this.myConnection.close();
                                    }
                                }
                                if ((releaseName.startsWith("7.3") || u == 1) && !this.ownRelease.startsWith("7.7")) {
                                    System.out.println("Resetting _UNICODE for next test...");
                                    this.executeDBMCmd("param_directput _UNICODE NO");
                                    this.executeDBMCmd("param_checkall");
                                }
                                BufferedReader reader = new BufferedReader(new FileReader(new File(this.getDataInputPath() + this.fileSep + veriFilename)));
                                this.myConnection = RecoverFromPreviousBuild.getDatabase().connect(this.conProps);
                                String line = null;
                                line = reader.readLine();
                                while (line != null) {
                                    this.myStatement = new TestStatement((TestCase)this, this.myConnection, 1005, 1007);
                                    System.out.println(line);
                                    String stmt = line;
                                    this.myStatement.executeQuery(line);
                                    result = this.myStatement.getResultSet();
                                    ResultSetMetaData meta = result.getMetaData();
                                    result.first();
                                    line = reader.readLine();
                                    StringTokenizer tknz = new StringTokenizer(line, "\t");
                                    Vector<String> colVec = new Vector<String>();
                                    Vector<Integer> typeVec = new Vector<Integer>();
                                    int index = 0;
                                    while (tknz.hasMoreTokens()) {
                                        token = tknz.nextToken();
                                        colVec.add(index, token);
                                        typeVec.add(index, new Integer(meta.getColumnType(index + 1)));
                                        ++index;
                                    }
                                    line = reader.readLine();
                                    while (line != null && !line.equals("//")) {
                                        if (result.isAfterLast()) {
                                            if (!releaseName.startsWith("7.3") || !stmt.startsWith("SELECT DBPROCNAME, PARAMETER FROM DBPROCEDURES")) {
                                                this.addMessage("run()", 'E', "Unexpected end of result set, expected:\n   " + line + "\n   Statement: " + this.myStatement.getSqlString());
                                            }
                                            line = reader.readLine();
                                            continue;
                                        }
                                        while (line.indexOf("\t\t") != -1) {
                                            line = line.substring(0, line.indexOf("\t\t") + 1) + "_EMPTY_" + line.substring(line.indexOf("\t\t") + 1);
                                        }
                                        tknz = new StringTokenizer(line, "\t");
                                        index = 0;
                                        while (tknz.hasMoreTokens()) {
                                            String resultField;
                                            token = new String(tknz.nextToken());
                                            if ((Integer)typeVec.get(index) == 6 && token.indexOf(".") == -1 && (token = token.indexOf("E") != -1 ? token.substring(0, token.indexOf("E")) + ".0" + token.substring(token.indexOf("E")) : token + ".0").indexOf("+") != -1) {
                                                token = token.substring(0, token.indexOf("+")) + token.substring(token.indexOf("+") + 1);
                                            }
                                            if ((Integer)typeVec.get(index) == 93 && token.indexOf(".") == -1) {
                                                token = token + ".0";
                                            }
                                            if (token.equals("_EMPTY_")) {
                                                token = "";
                                            }
                                            if (!((resultField = this.getResultField(result, index + 1, (Integer)typeVec.get(index))).equals(token) || releaseName.startsWith("7.3") && stmt.startsWith("SELECT DBPROCNAME, PARAMETER FROM DBPROCEDURES"))) {
                                                this.addMessage("run()", 'E', "Value of field " + colVec.get(index) + " is: " + resultField + "\n   expected: " + token + "\n   Statement: " + this.myStatement.getSqlString());
                                            }
                                            ++index;
                                        }
                                        result.next();
                                        line = reader.readLine();
                                    }
                                    if (!result.isAfterLast()) {
                                        this.addMessage("run()", 'E', "Unexpected end of verification data, result set contains more rows.\n   Statement: " + this.myStatement.getSqlString());
                                    }
                                    line = reader.readLine();
                                }
                                System.out.println("Saving catalog to table...");
                                try {
                                    this.myConnection = RecoverFromPreviousBuild.getDatabase().connect(this.conPropsDba);
                                    this.myStatement = new TestStatement((TestCase)this, this.myConnection);
                                    this.myStatement.executeUpdate("SAVE CATALOG ALL INTO CATALOG");
                                }
                                catch (Exception e) {
                                    this.addMessage("run()", 'E', "Trying \"SAVE CATALOG ALL INTO CATALOG\" -> getting SQLException: " + e.getMessage());
                                }
                                finally {
                                    this.myConnection.close();
                                }
                                try {
                                    this.myConnection = RecoverFromPreviousBuild.getDatabase().connect(this.conPropsDba);
                                    this.myStatement = new TestStatement((TestCase)this, this.myConnection);
                                    ResultSet resultCatalog = null;
                                    this.myStatement.executeQuery("SELECT COUNT (*) FROM CATALOG");
                                    resultCatalog = this.myStatement.getResultSet();
                                    if (resultCatalog == null || !resultCatalog.next() || resultCatalog.getInt(1) <= 0) {
                                        this.addMessage("run()", 'E', "Table CATALOG is empty after SAVE CATALOG ALL INTO CATALOG");
                                    }
                                }
                                catch (Exception e) {
                                    this.addMessage("run()", 'E', "Trying \"SELECT COUNT (*) FROM CATALOG\" -> getting SQLException: " + e.getMessage());
                                }
                                finally {
                                    this.myConnection.close();
                                }
                                System.out.println("Switching DB to offline state before restoring parameters...");
                                this.executeDBMCmd("db_offline");
                                System.out.println("Restoring parameter file from backup...");
                                this.executeDBMCmd("service_connect");
                                System.out.println("recover_config " + backupName);
                                this.executeDBMCmd("recover_config " + backupName);
                                this.executeDBMCmd("service_release");
                                System.out.println("Checking restored parameters...");
                                this.executeDBMCmd("param_checkall");
                                System.out.println("Adapting RUNDIRECTORY...");
                                this.executeDBMCmd("param_directput RUNDIRECTORY " + ((TestDatabaseSap)RecoverFromPreviousBuild.getDatabase()).getRunDir());
                                System.out.println("Adapting DIAG_HISTORY_PATH...");
                                this.executeDBMCmd("param_directput DIAG_HISTORY_PATH " + ((TestDatabaseSap)RecoverFromPreviousBuild.getDatabase()).getRunDir() + this.fileSep + "DIAGHISTORY");
                                this.executeDBMCmd("param_checkall");
                                System.out.println("Switching DB to admin state (" + kernelSpeed + " kernel)...");
                                this.executeDBMCmd("db_admin -" + kernelSpeed);
                                System.out.println("Switching DB to offline state...");
                                this.executeDBMCmd("db_offline");
                                System.out.println("Reverting to previous parameter file...");
                                this.executeDBMCmd("param_restore 1");
                                if (!releaseName.startsWith("7.3") && u != 1 || this.ownRelease.startsWith("7.7")) continue;
                                System.out.println("Set _UNICODE to NO");
                                this.executeDBMCmd("param_directput _UNICODE NO");
                                this.executeDBMCmd("param_checkall");
                                continue;
                            }
                            catch (Exception e) {
                                this.addMessage("run()", 'E', "Exception: " + e.getMessage());
                                e.printStackTrace();
                                continue;
                            }
                            finally {
                                try {
                                    this.myConnection.commit();
                                    this.myConnection.close();
                                }
                                catch (Exception e) {}
                                this.addMessage("run()", 'I', "Verification of backup completed.");
                            }
                        }
                    }
                }
            }
            catch (MalformedURLException mue) {
                this.addMessage("run()", 'E', "MalformedURLException http://" + this.webDavDir + "\n" + mue.getMessage());
            }
            catch (WebDAVException e) {
                this.addMessage("run()", 'E', "Exception while accessing http://" + this.webDavDir + "\n" + e.getMessage());
            }
        }
        if (buildCtr == 0) {
            this.addMessage("run()", 'W', "No backups found on WebDAV server.");
        }
        if (this.mDBMan != null) {
            try {
                this.mDBMan.release();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private boolean checkDbDate(String sDate, String sTime, String sTimestamp) {
        Date date2;
        int iYear = new Integer(sDate.substring(0, 4));
        int iMonth = new Integer(sDate.substring(5, 7));
        int iDay = new Integer(sDate.substring(8, 10));
        int iHour = new Integer(sTime.substring(0, 2));
        int iMinute = new Integer(sTime.substring(3, 5));
        int iSecond = new Integer(sTime.substring(6, 8));
        Date date1 = new GregorianCalendar(iYear, iMonth - 1, iDay, iHour, iMinute, iSecond).getTime();
        if (!date1.equals(date2 = new GregorianCalendar(iYear = new Integer(sTimestamp.substring(0, 4)).intValue(), (iMonth = new Integer(sTimestamp.substring(5, 7)).intValue()) - 1, iDay = new Integer(sTimestamp.substring(8, 10)).intValue(), iHour = new Integer(sTimestamp.substring(11, 13)).intValue(), iMinute = new Integer(sTimestamp.substring(14, 16)).intValue(), iSecond = new Integer(sTimestamp.substring(17, 19)).intValue()).getTime())) {
            this.addMessage("checkDbDate()", 'E', "DATE and TIME do not match TIMESTAMP(DATE,TIME) in system view:\nDATE+TIME='" + date1.toString() + "', TIMESTAMP='" + date2.toString() + "'");
            return false;
        }
        Date referenceDate = new GregorianCalendar(1992, 6, 7, 17, 10, 46).getTime();
        if (!date1.equals(referenceDate)) {
            this.addMessage("checkDbDate()", 'E', "DATE/TIME from system view (" + date1.toString() + ")is equal to " + referenceDate.toString() + ".");
            return false;
        }
        return true;
    }

    private void createBackupIfRequired(int unicode) {
        block14: {
            String os = this.getOsDir();
            if (os == null) {
                this.addMessage("run()", 'W', "Cannot determine OS directory on WebDAV server.");
            } else {
                String fileName = unicode == 1 ? "migrtstu" : "migrtst";
                String zipFileName = fileName + ".zip";
                String ownReleaseShort = "";
                if (this.ownRelease != null) {
                    ownReleaseShort = this.ownRelease.substring(this.ownRelease.length() - 2, this.ownRelease.length() - 1).equals("0") ? this.ownRelease.substring(0, this.ownRelease.length() - 2) + this.ownRelease.substring(this.ownRelease.length() - 1, this.ownRelease.length()) : this.ownRelease;
                }
                String ownBuildName = this.ownBuild < 10 ? "b_0" + this.ownBuild : "b_" + this.ownBuild;
                String url = "http://" + this.webDavDir + "/" + ownReleaseShort + "/" + ownBuildName + "/" + os + "/" + zipFileName;
                String resource = ownReleaseShort + "/" + ownBuildName + "/" + os + "/" + zipFileName;
                try {
                    if (this.client.exists(url)) break block14;
                    System.out.println("Backup of this build does not yet exist on server, creating it now...");
                    this.addMessage("run()", 'I', "Backup of this build does not yet exist on server, creating it now...");
                    File addFile = new File(this.getDataInputPath() + this.fileSep + this.addFilename);
                    if (addFile.exists()) {
                        BufferedReader reader = new BufferedReader(new FileReader(addFile));
                        Connection myDbaConnection = RecoverFromPreviousBuild.getDatabase().connect(this.conPropsDba);
                        TestStatement myDbaStatement = new TestStatement((TestCase)this, myDbaConnection);
                        try {
                            myDbaStatement.executeUpdate("create user " + this.testUser + "2 password " + this.testPassword + "2 resource not exclusive");
                        }
                        catch (SQLException se) {
                            // empty catch block
                        }
                        this.myConnection = RecoverFromPreviousBuild.getDatabase().connect(this.conProps2);
                        this.myStatement = new TestStatement((TestCase)this, this.myConnection);
                        String line = null;
                        System.out.println("  Executing additional statements from " + this.getDataInputPath() + this.fileSep + this.addFilename + " ...");
                        while ((line = reader.readLine()) != null) {
                            if (line.trim().length() == 0 || line.startsWith("//")) continue;
                            try {
                                System.out.println("  " + line);
                                this.myStatement.execute(line);
                            }
                            catch (SQLException se) {}
                        }
                        reader.close();
                        this.myConnection.close();
                    }
                    System.out.println("  Saving backup...");
                    this.executeDBMCmd("db_offline");
                    this.executeDBMCmd("db_admin");
                    this.executeDBMCmd("util_connect");
                    this.executeDBMCmd("backup_media_put " + fileName + " " + this.getDataOutputPath() + this.fileSep + fileName + " file data 0 8 yes no");
                    this.executeDBMCmd("backup_save " + fileName + " data");
                    this.executeDBMCmd("util_release");
                    this.executeDBMCmd("db_online");
                    System.out.println("  Compressing backup...");
                    File zipFile = new File(this.getDataOutputPath() + this.fileSep + zipFileName);
                    Zipper myZipper = new Zipper(zipFile);
                    myZipper.setRootDirectory(new File(this.getDataOutputPath()));
                    myZipper.addFile(new File(this.getDataOutputPath() + this.fileSep + fileName));
                    try {
                        myZipper.zip();
                        System.out.println("  Uploading backup...");
                        WebDAVClient clientForUpload = new WebDAVClient(new URL("http://" + this.webDavDir + "/"));
                        boolean uploadSuccessful = clientForUpload.upload(zipFile, resource, 300);
                        if (uploadSuccessful) {
                            System.out.println("  Backup uploaded successfully to " + url);
                            this.addMessage("run()", 'I', "Backup uploaded successfully to " + url);
                            break block14;
                        }
                        this.addMessage("run()", 'W', "Failed to create a zipfile that contains a new backup.");
                        System.out.println("  WARNING: failed to create a zip file that contains a new backup.");
                    }
                    catch (Exception e) {
                        this.addMessage("run()", 'W', "Failed to create a zipfile that contains a new backup.\n" + e.getLocalizedMessage());
                        System.out.println("  WARNING: failed to create a zip file that contains a new backup.");
                    }
                }
                catch (Exception e) {
                    System.out.println("Exception: " + e.getMessage() + "\n" + e.getClass());
                    this.addMessage("createBackupIfRequired()", 'E', "Exception: " + e.getMessage() + "\n" + e.getClass());
                }
            }
        }
    }

    private void reCreateDbprocs(Connection myConnection) {
        try {
            int ctr1;
            this.myStatement = new TestStatement((TestCase)this, myConnection, 1005, 1007);
            this.myStatement.executeUpdateIgnoreErrors("DROP DBPROC DO_INSERTS_2");
            this.myStatement.executeUpdate("CREATE DBPROC DO_INSERTS_2 AS VAR I INTEGER; SET I = 1; WHILE I <= 20 DO BEGIN INSERT INTO MIGRTST.TAB2 VALUES (RFILL(ASCII(''), '1234567890' ,4000), CHR(:I)); IF $RC <> 0 THEN STOP ($RC, $ERRMSG); SET I = I + 1; END;");
            this.myStatement.executeUpdateIgnoreErrors("DROP DBPROC DO_INSERTS_4_0");
            String stmtxt = "CREATE DBPROC DO_INSERTS_4_0 AS VAR I INTEGER; ";
            for (ctr1 = 1; ctr1 < 4; ++ctr1) {
                stmtxt = stmtxt + "SET I = " + ctr1 + "; INSERT INTO MIGRTST.TAB4 VALUES (";
                for (int ctr2 = 1; ctr2 < 21; ++ctr2) {
                    stmtxt = stmtxt + "CHR(:I), CHR(:I * 2), CHR(:I * 3), CHR(:I * 4), CHR(:I * 5), CHR(:I * 6), CHR(:I * 7), CHR(:I * 8), CHR(:I * 9),  CHR(:I * 10), ";
                }
                stmtxt = stmtxt + "CHR(:I), CHR(:I * 2), CHR(:I * 3), CHR(:I * 4), CHR(:I * 5), CHR(:I * 6), CHR(:I * 7), CHR(:I * 8), CHR(:I * 9),  CHR(:I * 10)); ";
                stmtxt = stmtxt + "IF $RC <> 0 THEN STOP ($RC, $ERRMSG); ";
            }
            stmtxt = stmtxt + "DELETE FROM MIGRTST.TAB4; IF $RC <> 0 THEN STOP ($RC, $ERRMSG);";
            this.myStatement.executeUpdate(stmtxt);
            this.myStatement.executeUpdateIgnoreErrors("DROP DBPROC DO_INSERTS_4");
            stmtxt = "CREATE DBPROC DO_INSERTS_4 AS VAR I INTEGER; ";
            stmtxt = stmtxt + "SET I = 1; WHILE I <= 20 DO BEGIN INSERT INTO MIGRTST.TAB4 VALUES (";
            for (ctr1 = 1; ctr1 < 21; ++ctr1) {
                stmtxt = stmtxt + "CHR(:I), CHR(:I * 2), CHR(:I * 3), CHR(:I * 4), CHR(:I * 5), CHR(:I * 6), CHR(:I * 7), CHR(:I * 8), CHR(:I * 9),  CHR(:I * 10), ";
            }
            stmtxt = stmtxt + "CHR(:I), CHR(:I * 2), CHR(:I * 3), CHR(:I * 4), CHR(:I * 5), CHR(:I * 6), CHR(:I * 7), CHR(:I * 8), CHR(:I * 9),  CHR(:I * 10)); ";
            stmtxt = stmtxt + "IF $RC <> 0 THEN STOP ($RC, $ERRMSG); SET I = I + 1; END;";
            this.myStatement.executeUpdate(stmtxt);
            this.myStatement.executeUpdateIgnoreErrors("DROP DBPROC DO_INSERTS_6");
            stmtxt = "CREATE DBPROC DO_INSERTS_6 AS VAR I INTEGER; SET I = 1; WHILE I <= 20 DO BEGIN INSERT INTO MIGRTST.TAB6 VALUES (";
            stmtxt = stmtxt + "CHR(:I), CHR(:I * 2), :I + .01, RFILL('', '1234567890', 1000)); IF $RC <> 0 THEN STOP ($RC, $ERRMSG); SET I = I + 1; END;";
            this.myStatement.executeUpdate(stmtxt);
            this.myStatement.executeUpdateIgnoreErrors("DROP DBPROC DO_INSERTS_7");
            stmtxt = "CREATE DBPROC DO_INSERTS_7 AS VAR I INTEGER; SET I = 1; WHILE I <= 20 DO BEGIN ";
            stmtxt = stmtxt + "INSERT INTO MIGRTST.TAB7 VALUES (:I - 1, CHR(:I), CHR(:I * 2), RFILL('', '1234567890', 100)); IF $RC <> 0 THEN STOP ($RC, $ERRMSG); SET I = I + 1; END;";
            this.myStatement.executeUpdate(stmtxt);
            this.myStatement.executeUpdateIgnoreErrors("DROP DBPROC DO_INSERTS_8A9A");
            stmtxt = "CREATE DBPROC DO_INSERTS_8A9A AS VAR I INTEGER; SET I = 1; WHILE I <= 20 DO BEGIN ";
            stmtxt = stmtxt + "INSERT INTO MIGRTST.TAB8A VALUES (CHR(:I), MIGRTST.SEQ1.NEXTVAL, TRUE, RFILL('', '1234567890', 1000)); IF $RC <> 0 THEN STOP ($RC, $ERRMSG); ";
            stmtxt = stmtxt + "INSERT INTO MIGRTST.TAB9A VALUES (:I, TRUE, 'Hello World!', 'lalala', MIGRTST.SEQ1.CURRVAL, 'ifsodpfiosodpfosdfksoifjdsioofjsoifujdsiofh', MIGRTST.SEQ2.NEXTVAL); ";
            stmtxt = stmtxt + "IF $RC <> 0 THEN STOP ($RC, $ERRMSG); SET I = I + 1; END;";
            this.myStatement.executeUpdate(stmtxt);
        }
        catch (SQLException e) {
            this.addMessage("run()", 'E', "Trying to re-create dbprocs -> getting SQLException: " + e.getMessage());
        }
    }

    public String executeDBMCmd(String pCmd) {
        String logon = "";
        String mHost = "";
        String mName = "";
        try {
            mHost = RecoverFromPreviousBuild.getDatabase().getHost();
            mName = RecoverFromPreviousBuild.getDatabase().getName();
            int mPort = RecoverFromPreviousBuild.getDatabase().getPort();
            if (this.mDBMan == null) {
                this.mDBMan = DBM.dbDBM((String)(mHost + ":" + mPort), (String)mName);
                logon = "USER_LOGON DBM,DBM";
                this.mDBMan.cmd(logon);
            }
            return this.mDBMan.cmd(pCmd);
        }
        catch (Exception e) {
            System.out.println("Could not execute: " + pCmd);
            System.out.println("Exception: " + e.getMessage() + "\n" + e.getClass());
            this.addMessage("executeDBMCmd()", 'E', "Could not execute: " + pCmd + "\nException: " + e.getMessage());
            return "error";
        }
    }

    private String getResultField(ResultSet result, int index, int type) {
        String resultField = "";
        try {
            resultField = type == 4 ? "" + result.getInt(index) : (type == 5 ? "" + result.getShort(index) : (type == 3 ? "" + result.getBigDecimal(index) : (type == 6 ? "" + result.getDouble(index) : (type == 1 || type == 12 || type == -1 ? "" + result.getString(index) : (type == 91 ? "" + result.getDate(index) : (type == 92 ? "" + result.getTime(index) : (type == 93 ? "" + result.getTimestamp(index) : "" + result.getObject(index))))))));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resultField;
    }

    private void extractFile(String zipFileName, String targetDir) throws Exception {
        String fileSep = System.getProperty("file.separator");
        ZipInputStream zis = new ZipInputStream(new FileInputStream(new File(zipFileName)));
        ZipEntry zipEntry = zis.getNextEntry();
        while (zipEntry != null) {
            File outFile = new File(targetDir + fileSep + zipEntry.getName());
            if (zipEntry.isDirectory()) {
                if (outFile.exists()) {
                    if (!outFile.isDirectory()) {
                        throw new TestCaseException(targetDir + fileSep + zipEntry.getName() + " exists but is not a directory - cannot continue extraction.");
                    }
                } else if (!outFile.mkdir()) {
                    throw new TestCaseException("Cannot create directory " + targetDir + fileSep + zipEntry.getName());
                }
            } else {
                if (outFile.exists() && outFile.isFile() && !outFile.delete()) {
                    throw new TestCaseException("Cannot delete file " + targetDir + fileSep + zipEntry.getName());
                }
                if (outFile.isFile() && !outFile.createNewFile()) {
                    throw new TestCaseException("Cannot create file " + targetDir + fileSep + zipEntry.getName());
                }
                FileOutputStream fos = new FileOutputStream(outFile);
                byte[] buf = new byte[1024];
                int i = 0;
                while ((i = zis.read(buf, 0, 1024)) != -1) {
                    fos.write(buf, 0, i);
                }
                fos.close();
            }
            zipEntry = zis.getNextEntry();
        }
        zis.close();
    }

    private boolean downloadFromWebdav(String webdavUrl, String targetPath) throws Exception {
        File outFile;
        String resource = webdavUrl;
        if (resource != null && this.client.exists(resource)) {
            outFile = new File(targetPath);
            if (outFile.exists()) {
                if (outFile.isDirectory()) {
                    throw new TestCaseException(targetPath + " exists but is a directory - cannot continue download.");
                }
                if (!outFile.delete()) {
                    System.out.println("Cannot delete old backup file, trying again after 5 sec.");
                    System.gc();
                    this.addMessage("downloadFromWebdav()", 'I', "Cannot delete old backup file, trying again after 5 sec.");
                    Thread.sleep(5000L);
                    if (!outFile.delete()) {
                        throw new TestCaseException("Cannot delete file " + targetPath);
                    }
                }
            }
            if (!outFile.createNewFile()) {
                throw new TestCaseException("Cannot create file " + targetPath);
            }
        } else {
            return false;
        }
        boolean result = this.client.download(webdavUrl, outFile);
        outFile = null;
        System.gc();
        return result;
    }

    private String getOsDir() {
        String name = System.getProperty("os.name");
        String osName = null;
        Integer bits = (Integer)mTestDriverOptions.get("DBBits");
        if (bits == null) {
            return null;
        }
        String sbits = "" + bits;
        if (name == null || name.equals("")) {
            return null;
        }
        if (name.indexOf("Windows") != -1) {
            osName = "win";
        }
        if (name.indexOf("Windows") != -1 && this.pltf.equals("Winx86_64")) {
            osName = "winx86_";
        }
        if (name.equals("SunOS")) {
            osName = "sun";
        }
        if (name.equals("SunOS") && this.pltf.equals("Sunx86_64")) {
            osName = "sunx86_";
        }
        if (name.equals("AIX")) {
            osName = "aix";
        }
        if (name.equals("HP-UX")) {
            osName = "hp";
        }
        if (name.equals("HP-UX") && this.pltf.equals("Hpia64")) {
            osName = "hpia";
        }
        if (name.equals("OSF1")) {
            osName = "dec";
        }
        if (name.equals("ReliantUNIX-N")) {
            osName = "sni";
        }
        if (name.equals("Linux")) {
            osName = "linux";
        }
        if (name.equals("Linux") && this.pltf.equals("Linuxx86_64")) {
            osName = "linuxx86_";
        }
        if (name.equals("Linux") && this.pltf.equals("pLinux")) {
            osName = "plinux";
        }
        if (name.equals("Linux") && this.pltf.equals("zLinux")) {
            osName = "zlinux";
        }
        if (osName == null) {
            return null;
        }
        return osName + sbits;
    }

    public static long getTimeout() {
        return 10800000L;
    }
}

