/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.lock;

import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDatabaseSap;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.testcase.TestStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Properties;
import java.util.Random;
import java.util.Set;

public class LockList4
extends TestCase {
    static final boolean devTrace = false;
    static final String TIME_OUT = "TimeOut";
    static final int MIN_NUMBER_OF_TRANSACTIONS = 2;
    static final String sUser = "BERLIN";
    static final String sPassword = "BERLIN";
    static String MAX_NUMBER_OF_TRANSACTIONS = "MaxNumberOfTransactions";
    private static Properties sTestParameter = new Properties();
    private static Properties sDbParameter = new Properties();

    private void addMessage(String pMessage) {
    }

    public static void cleanUp() throws TestCaseException {
        Connection con = null;
        TestStatement stmt = null;
        try {
            con = LockList4.getDatabase().connect("BERLIN", "BERLIN");
            stmt = new TestStatement(null, con);
            stmt.enableExceptions(false);
            stmt.executeUpdate("Drop user BERLIN");
            stmt.enableExceptions(true);
        }
        catch (Exception e) {
            LockList4.addGlobalMessage((String)"Clean up", (char)'E', (String)"failed");
            throw new TestCaseException("Error during clean up: " + e.getMessage());
        }
        finally {
            try {
                stmt.close();
                con.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void createLock(Connection pConnection, boolean pExclusiveMode) {
        TestStatement stmt = null;
        try {
            stmt = new TestStatement(null, pConnection);
            if (pExclusiveMode) {
                stmt.executeUpdate("LOCK ROW LOCKTEST KEY S0 = 'ABC' IN EXCLUSIVE MODE");
            } else {
                stmt.executeUpdate("LOCK ROW LOCKTEST KEY S0 = 'ABC' IN SHARE MODE");
            }
        }
        catch (Exception e) {
        }
        finally {
            try {
                stmt.close();
            }
            catch (Exception e) {}
        }
    }

    public static String getTestClassId() {
        return "LockList4";
    }

    private void handleException(Exception e) {
        this.handleExceptions(e);
    }

    public static void prepare() throws TestCaseException {
        Connection con = null;
        TestStatement stmt = null;
        try {
            String timeout;
            String maxNumberOfTransactions;
            String maxuser;
            String maxlocks;
            con = LockList4.getDatabase().connect("BERLIN", "BERLIN");
            stmt = new TestStatement(null, con);
            stmt.enableExceptions(false);
            stmt.executeUpdate("DROP TABLE LOCKTEST");
            stmt.enableExceptions(true);
            stmt.close();
            con.close();
            con = LockList4.getDatabase().connect(LockList4.getUser(), LockList4.getPassword());
            stmt = new TestStatement(null, con);
            stmt.enableExceptions(false);
            stmt.executeUpdate("Drop user BERLIN");
            stmt.enableExceptions(true);
            stmt.executeUpdate("Create user BERLIN password BERLIN resource not exclusive");
            stmt.close();
            con.close();
            con = LockList4.getDatabase().connect("BERLIN", "BERLIN");
            stmt = new TestStatement(null, con);
            stmt.executeUpdate("CREATE TABLE LOCKTEST (S0 VARCHAR(3) KEY)");
            LockList4.setTestParameter(TIME_OUT, LockList4.getParameterString((String)TIME_OUT, (String)"60"));
            LockList4.setTestParameter(MAX_NUMBER_OF_TRANSACTIONS, LockList4.getParameterString((String)MAX_NUMBER_OF_TRANSACTIONS, (String)"5"));
            String maxcpu = LockList4.getParameterString((String)"MAXCPU", null);
            if (maxcpu != null) {
                LockList4.setDbParameter("MAXCPU", maxcpu);
            }
            if ((maxlocks = LockList4.getParameterString((String)"MAXLOCKS", null)) != null) {
                LockList4.setDbParameter("MAXLOCKS", maxlocks);
            }
            if ((maxuser = LockList4.getParameterString((String)"MAXUSERTASKS", (String)(maxNumberOfTransactions = LockList4.getParameterString((String)MAX_NUMBER_OF_TRANSACTIONS, (String)"5")))) != null) {
                LockList4.setDbParameter("MAXUSERTASKS", maxuser);
            }
            if ((timeout = LockList4.getParameterString((String)"REQUEST_TIMEOUT", (String)"30")) != null) {
                LockList4.setDbParameter("REQUEST_TIMEOUT", timeout);
            }
        }
        catch (Exception e) {
            LockList4.addGlobalMessage((String)"Preparation", (char)'E', (String)"failed");
            throw new TestCaseException("Error during preparation: " + e.getMessage());
        }
        finally {
            try {
                stmt.close();
                con.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block27: {
            Properties orgDbParameter = new Properties();
            if (!sDbParameter.isEmpty()) {
                Set<Object> set = sDbParameter.keySet();
                Iterator<Object> it1 = set.iterator();
                while (it1.hasNext()) {
                    String key = (String)it1.next();
                    String value = ((TestDatabaseSap)LockList4.getDatabase()).getParameter(key);
                    orgDbParameter.setProperty(key, value);
                }
                ((TestDatabaseSap)LockList4.getDatabase()).stop();
                Iterator<Object> it2 = set.iterator();
                while (it2.hasNext()) {
                    String key = (String)it2.next();
                    String value = sDbParameter.getProperty(key);
                    ((TestDatabaseSap)LockList4.getDatabase()).setParameter(key, value);
                }
                ((TestDatabaseSap)LockList4.getDatabase()).start();
            }
            if (LockList4.getDatabase().isSap()) {
                ((TestDatabaseSap)LockList4.getDatabase()).enableOLTPTrace();
            }
            int MaxNumberOfTransactions = Integer.parseInt(sTestParameter.getProperty(MAX_NUMBER_OF_TRANSACTIONS));
            String timeout = sTestParameter.getProperty(TIME_OUT);
            long Timeout = 1000L * Long.parseLong(timeout);
            for (int i = 2; i <= MaxNumberOfTransactions; ++i) {
                this.addMessage("", 'I', "Number of transactions = " + Integer.toString(i));
                LockRequestor[] RequestorSet = new LockRequestor[i];
                long start = System.currentTimeMillis();
                boolean isStarted = false;
                for (int j = 0; j < i; ++j) {
                    RequestorSet[j] = new LockRequestor();
                    isStarted = true;
                }
                if (!isStarted) continue;
                long elapsedTime = 0L;
                while (elapsedTime < Timeout) {
                    Thread.sleep(Timeout / 100L);
                    elapsedTime = System.currentTimeMillis() - start;
                }
                for (int j = 0; j < i; ++j) {
                    RequestorSet[j].pleaseStop();
                }
                boolean areAlive = true;
                while (areAlive) {
                    for (int j = 0; j < i; ++j) {
                        areAlive = RequestorSet[j].isAlive();
                    }
                }
            }
            Object var16_18 = null;
            try {
                if (LockList4.getDatabase().isSap()) {
                    TestDatabaseSap sapdb = (TestDatabaseSap)LockList4.getDatabase();
                    sapdb.disableOLTPTrace();
                }
                if (!sDbParameter.isEmpty()) {
                    ((TestDatabaseSap)LockList4.getDatabase()).stop();
                    Set<Object> set = orgDbParameter.keySet();
                    Iterator<Object> it = set.iterator();
                    while (it.hasNext()) {
                        String key = (String)it.next();
                        String value = orgDbParameter.getProperty(key);
                        ((TestDatabaseSap)LockList4.getDatabase()).setParameter(key, value);
                    }
                    ((TestDatabaseSap)LockList4.getDatabase()).start();
                }
                break block27;
            }
            catch (Exception e2) {}
            break block27;
            {
                catch (Exception e) {
                    this.handleExceptions(e);
                    Object var16_19 = null;
                    try {
                        if (LockList4.getDatabase().isSap()) {
                            TestDatabaseSap sapdb = (TestDatabaseSap)LockList4.getDatabase();
                            sapdb.disableOLTPTrace();
                        }
                        if (!sDbParameter.isEmpty()) {
                            ((TestDatabaseSap)LockList4.getDatabase()).stop();
                            Set<Object> set = orgDbParameter.keySet();
                            Iterator<Object> it = set.iterator();
                            while (it.hasNext()) {
                                String key = (String)it.next();
                                String value = orgDbParameter.getProperty(key);
                                ((TestDatabaseSap)LockList4.getDatabase()).setParameter(key, value);
                            }
                            ((TestDatabaseSap)LockList4.getDatabase()).start();
                        }
                        break block27;
                    }
                    catch (Exception e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var16_20 = null;
                try {
                    if (LockList4.getDatabase().isSap()) {
                        TestDatabaseSap sapdb = (TestDatabaseSap)LockList4.getDatabase();
                        sapdb.disableOLTPTrace();
                    }
                    if (!sDbParameter.isEmpty()) {
                        ((TestDatabaseSap)LockList4.getDatabase()).stop();
                        Set<Object> set = orgDbParameter.keySet();
                        Iterator<Object> it = set.iterator();
                        while (it.hasNext()) {
                            String key = (String)it.next();
                            String value = orgDbParameter.getProperty(key);
                            ((TestDatabaseSap)LockList4.getDatabase()).setParameter(key, value);
                        }
                        ((TestDatabaseSap)LockList4.getDatabase()).start();
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    private static void setDbParameter(String pKey, String pValue) {
        sDbParameter.setProperty(pKey, pValue);
        LockList4.addGlobalMessage((String)"", (char)'I', (String)("Db parameter " + pKey + " = " + pValue));
    }

    private static void setTestParameter(String pKey, String pValue) {
        sTestParameter.setProperty(pKey, pValue);
        LockList4.addGlobalMessage((String)"", (char)'I', (String)("Testparameter " + pKey + " = " + pValue));
    }

    class LockRequestor
    extends Thread {
        boolean keepRuning = true;

        LockRequestor() {
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Connection con = null;
            try {
                con = TestCase.getDatabase().connect("BERLIN", "BERLIN");
                con.setAutoCommit(false);
                Random randomGenerator = new Random(System.currentTimeMillis());
                String ReqTimeout = sDbParameter.getProperty("REQUEST_TIMEOUT");
                long RequestTimeout = 1000L * Long.parseLong(ReqTimeout);
                while (this.keepRuning) {
                    int random = randomGenerator.nextInt(5);
                    switch (random) {
                        case 0: {
                            LockList4.this.addMessage("Lock in share mode");
                            LockList4.this.createLock(con, false);
                            break;
                        }
                        case 1: {
                            LockList4.this.addMessage("Lock in exclusive mode");
                            LockList4.this.createLock(con, true);
                            break;
                        }
                        case 2: {
                            LockList4.this.addMessage("Sleeping");
                            try {
                                Thread.sleep(1000L * RequestTimeout + 1L);
                            }
                            catch (InterruptedException e) {}
                            break;
                        }
                        case 4: {
                            LockList4.this.addMessage("Commit");
                            con.commit();
                        }
                    }
                    Thread.yield();
                }
            }
            catch (Exception e) {
                LockList4.this.handleException(e);
            }
            finally {
                try {
                    con.close();
                }
                catch (Exception exception) {}
            }
        }

        public void pleaseStop() {
            this.keepRuning = false;
        }
    }
}

