/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.lock;

import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDatabaseSap;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.testcase.TestStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;

public class LockList3
extends TestCase {
    private static String sUser = "BERLIN";
    private static String sPassword = "BERLIN";
    private static int sRequestTimeout = 30;

    public static void cleanUp() throws TestCaseException {
        Connection con = null;
        TestStatement stmt = null;
        try {
            con = LockList3.getDatabase().connect(sUser, sPassword);
            stmt = new TestStatement(null, con);
            stmt.enableExceptions(false);
            stmt.executeUpdate("Drop user " + sUser);
            stmt.enableExceptions(true);
        }
        catch (Exception e) {
            LockList3.addGlobalMessage((String)"Clean up", (char)'E', (String)"failed");
            throw new TestCaseException("Error during clean up: " + e.getMessage());
        }
        finally {
            try {
                stmt.close();
                con.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void createLock(Connection pConnection, boolean pExclusiveMode) {
        TestStatement stmt = null;
        try {
            stmt = new TestStatement(null, pConnection);
            if (pExclusiveMode) {
                stmt.executeUpdate("LOCK ROW LOCKTEST KEY S0 = 'ABC' IN EXCLUSIVE MODE");
            } else {
                stmt.executeUpdate("LOCK ROW LOCKTEST KEY S0 = 'ABC' IN SHARE MODE");
            }
        }
        catch (Exception e) {
        }
        finally {
            try {
                stmt.close();
            }
            catch (Exception e) {}
        }
    }

    public static String getTestClassId() {
        return "LockList3";
    }

    public static void prepare() throws TestCaseException {
        Connection con = null;
        TestStatement stmt = null;
        try {
            con = LockList3.getDatabase().connect(LockList3.getUser(), LockList3.getPassword());
            stmt = new TestStatement(null, con);
            stmt.enableExceptions(false);
            stmt.executeUpdate("Drop user " + sUser);
            stmt.enableExceptions(true);
            stmt.executeUpdate("Create user " + sUser + " password " + sPassword + " resource not exclusive");
            stmt.close();
            con.close();
            con = LockList3.getDatabase().connect(sUser, sPassword);
            stmt = new TestStatement(null, con);
            stmt.enableExceptions(false);
            stmt.executeUpdate("DROP TABLE LOCKTEST");
            stmt.enableExceptions(true);
            stmt.executeUpdate("CREATE TABLE LOCKTEST (S0 VARCHAR(3) KEY)");
            sRequestTimeout = LockList3.getParameterInt((String)"RequestTimeout", (int)30);
            LockList3.addGlobalMessage((String)"", (char)'I', (String)("RequestTimeout = " + sRequestTimeout));
        }
        catch (Exception e) {
            LockList3.addGlobalMessage((String)"Preparation", (char)'E', (String)("failed: " + e.getMessage()));
            throw new TestCaseException("Error during preparation: " + e.getMessage());
        }
        finally {
            try {
                stmt.close();
                con.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Connection con1 = null;
        Connection con2 = null;
        int orgRequestTimeout = 0;
        try {
            orgRequestTimeout = Integer.parseInt(((TestDatabaseSap)LockList3.getDatabase()).getParameter("REQUEST_TIMEOUT"));
            this.setRequestTimeout(sRequestTimeout);
            if (LockList3.getDatabase().isSap()) {
                ((TestDatabaseSap)LockList3.getDatabase()).enableOLTPTrace();
            }
            Properties conProps = new Properties();
            conProps.put("user", sUser);
            conProps.put("password", sPassword);
            conProps.put("timeout", new Integer(sRequestTimeout));
            con1 = LockList3.getDatabase().connect(conProps);
            con2 = LockList3.getDatabase().connect(conProps);
            con1.setAutoCommit(false);
            con2.setAutoCommit(false);
            this.createLock(con1, false);
            this.createLock(con2, false);
            this.createLock(con2, true);
            long startTime = System.currentTimeMillis();
            long deltaTime = 0L;
            long threshold = (long)(sRequestTimeout + 5) * 1000L;
            while (deltaTime < threshold) {
                deltaTime = System.currentTimeMillis() - startTime;
            }
            con1.commit();
            con2.commit();
        }
        catch (Exception e) {
            this.handleExceptions(e);
        }
        finally {
            try {
                this.setRequestTimeout(orgRequestTimeout);
                if (LockList3.getDatabase().isSap()) {
                    TestDatabaseSap sapdb = (TestDatabaseSap)LockList3.getDatabase();
                    sapdb.disableOLTPTrace();
                }
                con1.close();
                con2.close();
            }
            catch (Exception e) {}
        }
    }

    private void setRequestTimeout(int pRequestTimeout) throws TestDatabaseException {
        ((TestDatabaseSap)LockList3.getDatabase()).setParameter("REQUEST_TIMEOUT", Integer.toString(pRequestTimeout));
    }
}

