/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.loader;

import com.sap.dbtech.jdbc.DriverSapDB;
import com.sap.dbtech.powertoys.Loader;
import com.sap.dbtech.powertoys.LoaderException;
import com.sap.dbtech.rte.comm.RTEException;
import com.sap.sapdb.sqltest.interpreter.Cache;
import com.sap.sapdb.sqltest.interpreter.Catalog;
import com.sap.sapdb.sqltest.interpreter.Reference;
import com.sap.sapdb.sqltest.interpreter.TestCasesInterpreter;
import com.sap.sapdb.sqltest.parser.StatementBean;
import com.sap.sapdb.sqltest.parser.TestCaseBean;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDatabaseSap;
import com.sap.sapdb.testframe.driver.TestDriver;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.testcase.TestStatement;
import com.sap.sapdb.testframe.testcase.VerificationData;
import com.sap.sapdb.testframe.testcase.VerificationDataComplete;
import com.sap.sapdb.testframe.utilities.TestCaseDBVersionScope;
import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;

public class LoaderTestInterpreter
extends TestCase {
    private static final String mTestUser = "LOADER";
    private static final String mTestUserPw = "LOADER";
    private static String mTestRoot = null;
    private String mDataInputPath = null;
    private static String mTestCatalogFile = null;
    private Catalog mTestCaseCatalog = null;
    private Reference m_CurrentRef = null;
    private Cache mTestCaseCache = null;
    private static Connection mSQLConnection = null;
    private static final String mDBName = LoaderTestInterpreter.getDatabase().getName();
    private Loader mLoader = null;
    private static String logPath = null;
    private static String communicationType = "Communication type: ";
    public static final int MAXERROR_PROT = 9;
    private boolean stopOnFirstError = false;
    private boolean errorsOccured = false;
    private int errorCount = 0;
    private Hashtable userConnections = new Hashtable();

    public void setStopOnError(boolean stopOnError) {
        this.stopOnFirstError = stopOnError;
    }

    public static void cleanUp() throws TestCaseException {
        System.out.println("-------------------------------------------------------------------------------\n");
        System.out.println(communicationType);
        System.out.println(logPath);
        System.out.println("-------------------------------------------------------------------------------");
        System.out.println("End of " + LoaderTestInterpreter.getTestClassId() + "\n");
    }

    public static String getTestClassId() {
        return "LoaderTest";
    }

    public static void prepare() throws TestCaseException {
        TestStatement myStatement = null;
        mTestRoot = TestDriver.getJTestRoot();
        System.out.println("Start of " + LoaderTestInterpreter.getTestClassId());
        try {
            mSQLConnection = LoaderTestInterpreter.getDatabase().connect(LoaderTestInterpreter.getUser(), LoaderTestInterpreter.getPassword());
            System.out.println("Driver given user " + LoaderTestInterpreter.getUser());
            myStatement = new TestStatement(null, mSQLConnection);
            myStatement.executeUpdateIgnoreErrors("Drop user LOADER");
            myStatement.executeUpdate("Create user LOADER password LOADER dba not exclusive");
            myStatement.close();
            mSQLConnection.close();
            mSQLConnection = LoaderTestInterpreter.getDatabase().connect("LOADER", "LOADER");
        }
        catch (Exception e) {
            LoaderTestInterpreter.addGlobalMessage((String)"Method prepare", (char)'E', (String)"preparation failed");
            throw new TestCaseException("Error during preparation: " + e.getClass() + e.getMessage());
        }
        finally {
            try {
                myStatement.close();
                mSQLConnection.commit();
            }
            catch (Exception e) {
                LoaderTestInterpreter.addGlobalMessage((String)"EXCEPTION!", (char)'E', (String)"preparation failed");
                throw new TestCaseException("Method prepare \nReleasing the object's database and JDBC resources failed with error message: " + e.getClass() + e.getMessage());
            }
        }
    }

    public void run() {
        this.mDataInputPath = this.getDataInputPath() + File.separator;
        mTestCatalogFile = this.mDataInputPath + "LOADERTESTS.xml";
        String URIPrefix = "file:///" + this.mDataInputPath;
        Properties loaderProperties = null;
        loaderProperties = new Properties();
        loaderProperties.setProperty("dbname", mDBName);
        if (3 == DriverSapDB.loadNativeCommunication()) {
            loaderProperties.setProperty("host", "localhost:" + LoaderTestInterpreter.getDatabase().getPort());
            communicationType = communicationType + "non local (localhost:" + LoaderTestInterpreter.getDatabase().getPort() + ")";
        } else {
            communicationType = communicationType + "local";
        }
        this.stopOnFirstError = LoaderTestInterpreter.getParameterBoolean((String)"StopOnFirstError", (boolean)false);
        try {
            this.mLoader = new Loader(loaderProperties);
            logPath = this.mLoader.cmd("SET");
        }
        catch (Exception e) {
            LoaderTestInterpreter.addGlobalMessage((String)"EXCEPTION!", (char)'E', (String)("Method run \nCreation of Loader object failed with error message:\n" + e.getMessage()));
        }
        TestCaseBean LoaderTestCase = null;
        int numberOfSelectedTestCases = 0;
        String Scope_charEncType = null;
        String Scope_sqlmode = LoaderTestInterpreter.getParameterString((String)"SQLMODE", (String)"INTERNAL");
        String Scope_version = null;
        try {
            this.mTestCaseCatalog = new Catalog(mTestCatalogFile);
            this.mTestCaseCache = new Cache(URIPrefix);
            Iterator itReference = this.mTestCaseCatalog.iterator();
            TestDatabaseSap myDb = (TestDatabaseSap)LoaderTestInterpreter.getDatabase();
            Scope_sqlmode = myDb.getSqlMode();
            Scope_charEncType = myDb.getParameter("_UNICODE").equalsIgnoreCase("YES") ? (myDb.getParameter("DEFAULT_CODE").equalsIgnoreCase("UNICODE") ? "unicode" : "mixed") : "ascii";
            Scope_version = myDb.getVersion();
            this.addMessage("Testcontext", 'T', "The context for these tests is: \nRelease     : " + Scope_version + "\nCharEncType : " + Scope_charEncType + "\nSQLMode     : " + Scope_sqlmode + "\n\ndb parameter:" + "\n _UNICODE      = " + myDb.getParameter("_UNICODE") + "\n DEFAULT_CODE  = " + myDb.getParameter("DEFAULT_CODE") + "\n _PACKET_SIZE  = " + myDb.getParameter("_PACKET_SIZE") + "\n StopOnFirstError = " + this.stopOnFirstError + "\n\ncommunication parameter:" + "\n " + communicationType + "\n\n" + logPath);
            while (itReference.hasNext() && !this.errorsOccured) {
                TestCaseDBVersionScope t;
                this.m_CurrentRef = (Reference)itReference.next();
                if (!this.m_CurrentRef.getSelected()) continue;
                ++numberOfSelectedTestCases;
                LoaderTestCase = this.mTestCaseCache.getCaseForReference(this.m_CurrentRef);
                if (LoaderTestCase == null) {
                    this.addMessage("File = " + this.m_CurrentRef.getFileName(), 'W', "the test case for this " + this.m_CurrentRef.toString() + " does not exist.");
                    continue;
                }
                if (null != LoaderTestCase.getExcludeProperty() && 0 != LoaderTestCase.getExcludeProperty().length() && !(t = new TestCaseDBVersionScope(LoaderTestCase.getExcludeProperty())).isInScope(Scope_charEncType, Scope_sqlmode, Scope_version)) {
                    this.addMessage("Exclude rule", 'T', "Test " + this.m_CurrentRef.toString() + " \nwas not executed because exclude rule \"" + LoaderTestCase.getExcludeProperty() + "\" matched.");
                    continue;
                }
                this.ProcessLoaderTestCase(LoaderTestCase);
            }
            if (this.errorsOccured) {
                this.addMessage(LoaderTestInterpreter.getTestClassId(), 'E', "Because 9 error(s) have already occurred, the test ceases to protocolate. Be aware that further errors might exist!");
            }
        }
        catch (Exception e) {
            LoaderTestInterpreter.addGlobalMessage((String)"EXCEPTION!", (char)'E', (String)("Method run \nIterating over the Test case catalog failedwith error message:\n" + e.getMessage()));
        }
        try {
            this.mLoader.release();
        }
        catch (Exception e) {
            LoaderTestInterpreter.addGlobalMessage((String)"EXCEPTION!", (char)'E', (String)("Method run \nReleasing the Loader object failedwith error message:\n" + e.getMessage()));
        }
        try {
            mSQLConnection.close();
        }
        catch (SQLException se) {
            LoaderTestInterpreter.addGlobalMessage((String)"EXCEPTION!", (char)'E', (String)("Method run \nReleasing the SQL connection failedwith error message:\n" + se.getMessage()));
        }
    }

    public int ProcessLoaderTestCase(TestCaseBean LoaderTestCase) {
        int rc = 0;
        try {
            this.mLoader.cmd("use user LOADER LOADER serverdb " + mDBName);
        }
        catch (Exception e) {
            this.addMessage("EXCEPTION!", 'E', "Test no = " + LoaderTestCase.getTestCaseNumber() + "; file = " + this.m_CurrentRef.getFileName() + "\nResetting the user name at the beginning of this test case failed with error message:\n" + e.getLocalizedMessage());
        }
        if (LoaderTestCase.getPrepareStatemets().size() > 0) {
            try {
                this.LoaderTest_Prepare(LoaderTestCase.getPrepareStatemets(), LoaderTestCase.getTestCaseNumber());
            }
            catch (Exception e) {
                this.addMessage("EXCEPTION!", 'E', "Test no = " + LoaderTestCase.getTestCaseNumber() + "; file = " + this.m_CurrentRef.getFileName() + "\nProcessing the prepare statements of this test case failed with error message:\n" + e.getLocalizedMessage());
            }
        }
        if (LoaderTestCase.getRunStatements().size() > 0) {
            try {
                rc = this.LoaderTest_Run(LoaderTestCase);
            }
            catch (Exception e) {
                this.addMessage("EXCEPTION!", 'E', "Test no = " + LoaderTestCase.getTestCaseNumber() + "; file = " + this.m_CurrentRef.getFileName() + "\nProcessing the run statements of this test case failed with error message:\n" + e.getMessage());
            }
        }
        if (LoaderTestCase.getCleanUpStatements().size() > 0) {
            try {
                this.LoaderTest_Cleanup(LoaderTestCase.getCleanUpStatements(), LoaderTestCase.getTestCaseNumber());
            }
            catch (Exception e) {
                this.addMessage("EXCEPTION!", 'E', "Test no = " + LoaderTestCase.getTestCaseNumber() + "; file = " + this.m_CurrentRef.getFileName() + "\nProcessing the cleanup statements of this test case failed with error message:\n" + e.getLocalizedMessage());
            }
        }
        return rc;
    }

    private int LoaderTest_Prepare(ArrayList PrepareStmtArray, int TestCaseNo) {
        int rc = 0;
        int NoOfStmts = PrepareStmtArray.size();
        StatementBean LoaderStmt = null;
        String _callString = null;
        for (int i = 0; i < NoOfStmts; ++i) {
            try {
                LoaderStmt = (StatementBean)PrepareStmtArray.get(i);
                _callString = LoaderStmt.getCallString();
                this.mLoader.cmd(_callString);
                continue;
            }
            catch (Exception e) {
                if (!LoaderStmt.isIgnoreErrors() && !this.stopOnFirstError) {
                    this.addMessage(LoaderTestInterpreter.getTestClassId(), 'E', "Test no = " + TestCaseNo + "; file = " + this.m_CurrentRef.getFileName() + "; phase = prepare\n" + "Statement:\n" + _callString + "\nfailed with error message:\n" + e.getLocalizedMessage());
                }
                if (!LoaderStmt.isIgnoreErrors() && this.stopOnFirstError && this.errorCount >= 9) {
                    this.errorsOccured = true;
                }
                if (LoaderStmt.isIgnoreErrors() || !this.stopOnFirstError || this.errorCount >= 9) continue;
                this.addMessage(LoaderTestInterpreter.getTestClassId(), 'E', "Test no = " + TestCaseNo + "; file = " + this.m_CurrentRef.getFileName() + "; phase = prepare\n" + "Statement:\n" + _callString + "\nfailed with error message:\n" + e.getLocalizedMessage());
                ++this.errorCount;
            }
        }
        return rc;
    }

    private int LoaderTest_Run(TestCaseBean LoaderTestCase) throws RTEException, TestCaseException {
        int rc = 0;
        ArrayList RunStmtArray = LoaderTestCase.getRunStatements();
        int NoOfStmts = RunStmtArray.size();
        StatementBean LoaderStmt = null;
        String _callString = null;
        String _tmpString = null;
        int _pos = 0;
        VerificationData _ReferenceData = null;
        boolean _bError = false;
        boolean _bReminder = false;
        boolean _bTestFailed = false;
        boolean _bTestToKeepInMind = false;
        TestStatement _SQLStmt = null;
        StringBuffer _sb_stmt = new StringBuffer();
        StringBuffer _sb_test = new StringBuffer();
        for (int i = 0; i < NoOfStmts; ++i) {
            block48: {
                try {
                    LoaderStmt = (StatementBean)RunStmtArray.get(i);
                    _callString = LoaderStmt.getCallString();
                    String user = LoaderStmt.getUser();
                    String trimmedCallString = _callString.replaceAll("/\\*[^(\\*)]*\\*/", "");
                    trimmedCallString = trimmedCallString.trim().replaceAll("\\s+", " ");
                    String trimmedLowerCallString = trimmedCallString.toLowerCase();
                    boolean isReleaseFound = false;
                    if (trimmedLowerCallString.matches("connect .+ identified by .+")) {
                        try {
                            Properties props = new Properties();
                            String[] tokens = trimmedCallString.split(" ");
                            props.setProperty("user", tokens[1]);
                            props.setProperty("password", tokens[4]);
                            boolean[] propertyWasAlraedyFound = new boolean[TestCasesInterpreter.knownConnectionProperties.length];
                            for (int k = 5; k < tokens.length; k += 2) {
                                String token2;
                                String token1 = tokens[k].toLowerCase();
                                boolean isProperty = false;
                                for (int j = 0; j < TestCasesInterpreter.knownConnectionProperties.length; ++j) {
                                    if (!token1.equalsIgnoreCase(TestCasesInterpreter.knownConnectionProperties[j])) continue;
                                    isProperty = true;
                                    if (propertyWasAlraedyFound[j]) {
                                        throw new SQLException("[-828] Duplicate variable name: " + token1, "", -828);
                                    }
                                    propertyWasAlraedyFound[j] = true;
                                    break;
                                }
                                if (isProperty) {
                                    if (tokens.length <= k + 1) {
                                        throw new SQLException("Invalids end of SQL statement", "", -3014);
                                    }
                                    token2 = tokens[k + 1];
                                } else {
                                    String possibleProperties = "";
                                    for (int j = 0; j < TestCasesInterpreter.knownConnectionProperties.length; ++j) {
                                        possibleProperties = possibleProperties + TestCasesInterpreter.knownConnectionProperties[j].toUpperCase() + ", ";
                                    }
                                    possibleProperties = possibleProperties.substring(0, possibleProperties.length() - 2);
                                    throw new SQLException("[-843] Invalid parameter name. Expect: " + possibleProperties, "", -843);
                                }
                                props.setProperty(token1, token2);
                            }
                            Connection con = null;
                            con = LoaderTestInterpreter.getDatabase().connect(props);
                            String newUser = props.getProperty("user");
                            if (this.userConnections.containsKey(newUser)) {
                                int k = 2;
                                while (this.userConnections.containsKey(newUser + "#" + k)) {
                                    ++k;
                                }
                                newUser = newUser + "#" + k;
                            }
                            if (con == null) continue;
                            this.userConnections.put(newUser, con);
                            continue;
                        }
                        catch (TestDatabaseException tde) {
                            int erroCode = 0;
                            String message = tde.getMessage();
                            try {
                                erroCode = Integer.parseInt(message.substring(message.indexOf("[") + 1, message.indexOf("]")));
                            }
                            catch (NumberFormatException nfe) {
                                // empty catch block
                            }
                            throw new SQLException(message, "", erroCode);
                        }
                    }
                    if (trimmedLowerCallString.matches("((commit)|(rollback)) (work )?release")) {
                        _callString = trimmedLowerCallString.substring(0, trimmedLowerCallString.indexOf("release"));
                        isReleaseFound = true;
                    }
                    if (!trimmedLowerCallString.startsWith("select") && (user == null || user.matches("\\s*"))) {
                        _pos = _callString.indexOf("<infile_path>");
                        while (-1 != _pos) {
                            _tmpString = _callString.substring(0, _pos);
                            _tmpString = _tmpString + this.mDataInputPath;
                            _callString = _tmpString = _tmpString + _callString.substring(_pos + 13);
                            _pos = _callString.indexOf("<infile_path>");
                        }
                        _tmpString = _callString;
                        this.mLoader.cmd(_tmpString);
                        String _szExpectedErrorCodes = LoaderStmt.getListOfExpectedErrorCodes();
                        if (3 < _szExpectedErrorCodes.length()) {
                            _sb_stmt.append("Expected error " + _szExpectedErrorCodes + " but return code was ( 0 )\n");
                            _bError = true;
                        }
                    } else {
                        Connection myConnection;
                        if (user == null || user.length() == 0) {
                            myConnection = mSQLConnection;
                        } else {
                            if (user.endsWith("#1")) {
                                user = user.substring(0, user.length() - 2);
                            }
                            if (this.userConnections.containsKey(user)) {
                                myConnection = (Connection)this.userConnections.get(user);
                            } else {
                                throw new SQLException("Session not connected", "", -821);
                            }
                        }
                        _ReferenceData = LoaderStmt.getVerificationData();
                        ResultSet rs = null;
                        _SQLStmt = new TestStatement((TestCase)this, myConnection, 1005, 1007);
                        if (isReleaseFound) {
                            _SQLStmt.execute(_callString);
                        } else {
                            rs = _SQLStmt.executeQuery(_callString);
                            if (!_ReferenceData.equals(rs)) {
                                VerificationDataComplete vercom = new VerificationDataComplete(rs);
                                if (!LoaderStmt.isIgnoreErrors()) {
                                    _sb_stmt.append("Expected resultset:\n" + _ReferenceData.toString() + "\nReal resultset:\n" + vercom.toString() + "\n");
                                    _bError = true;
                                } else {
                                    _sb_stmt.append("Expected resultset:\n" + _ReferenceData.toString() + "\nReal resultset:\n" + vercom.toString() + "\n");
                                    _bReminder = true;
                                }
                            }
                        }
                        if (isReleaseFound && user != null) {
                            myConnection.close();
                            this.userConnections.remove(user);
                        }
                    }
                }
                catch (LoaderException le) {
                    String _szExpectedErrorCodes = LoaderStmt.getListOfExpectedErrorCodes();
                    if (!LoaderStmt.checkErrorCodes(le.getErrorCode())) {
                        if (!LoaderStmt.isIgnoreErrors()) {
                            if (_szExpectedErrorCodes.length() > 3) {
                                _sb_stmt.append(le.toString() + "\nexecuting Loader statement\n\"" + _callString + "\"\n" + "!Encountered a different error then the one expected!\n\n");
                            } else {
                                _sb_stmt.append(le.toString() + "\nexecuting Loader statement\n\"" + _callString + "\"\n");
                            }
                            _bError = true;
                        } else {
                            if (_szExpectedErrorCodes.length() > 3) {
                                _sb_stmt.append(le.toString() + "\nexecuting Loader statement\n\"" + _callString + "\"\n" + "!Encountered a different error then the one expected!\n\n");
                            } else {
                                _sb_stmt.append(le.toString() + "\nexecuting Loader statement\n\"" + _callString + "\"\n");
                            }
                            _bReminder = true;
                        }
                    }
                }
                catch (SQLException se) {
                    boolean bDoWeNeedToHandleException = true;
                    if (LoaderStmt.isVerify() && 100 == se.getErrorCode()) {
                        bDoWeNeedToHandleException = false;
                    }
                    if (!bDoWeNeedToHandleException) break block48;
                    this.addMessage("EXCEPTION!", 'E', "Test no = " + LoaderTestCase.getTestCaseNumber() + "; file = " + this.m_CurrentRef.getFileName() + "; phase = run\n" + "SQL statement failed with error message:\n" + se.getLocalizedMessage());
                    _bError = true;
                }
            }
            if (_bError) {
                _sb_test.append("Statement (run) " + i + " failed with error message:\n" + _sb_stmt.toString());
                _sb_stmt.delete(0, _sb_stmt.length() - 1);
                _bError = false;
                if (!_bTestFailed) {
                    _bTestFailed = true;
                }
            }
            if (!_bReminder) continue;
            _sb_test.append("Statement (run) " + i + " failed with error message:\n" + _sb_stmt.toString());
            _sb_stmt.delete(0, _sb_stmt.length() - 1);
            _bReminder = false;
            if (_bTestToKeepInMind) continue;
            _bTestToKeepInMind = true;
        }
        if (_bTestFailed && !this.stopOnFirstError) {
            this.addMessage(LoaderTestInterpreter.getTestClassId(), 'E', "Test no = " + LoaderTestCase.getTestCaseNumber() + "; file = " + this.m_CurrentRef.getFileName() + "; phase = run\n" + _sb_test.toString());
            rc = -1;
        }
        if (_bTestFailed && this.stopOnFirstError && this.errorCount >= 9) {
            this.errorsOccured = true;
        }
        if (_bTestFailed && this.stopOnFirstError && this.errorCount < 9) {
            this.addMessage(LoaderTestInterpreter.getTestClassId(), 'E', "Test no = " + LoaderTestCase.getTestCaseNumber() + "; file = " + this.m_CurrentRef.getFileName() + "; phase = run\n" + _sb_test.toString());
            rc = -1;
            ++this.errorCount;
        }
        if (_bTestToKeepInMind) {
            this.addMessage(LoaderTestInterpreter.getTestClassId(), 'R', "Test no = " + LoaderTestCase.getTestCaseNumber() + "; file = " + this.m_CurrentRef.getFileName() + "; phase = run\n" + _sb_test.toString());
        }
        return rc;
    }

    private int LoaderTest_Cleanup(ArrayList CleanupStmtArray, int TestCaseNo) {
        int rc = 0;
        int NoOfStmts = CleanupStmtArray.size();
        StatementBean LoaderStmt = null;
        for (int i = 0; i < NoOfStmts; ++i) {
            try {
                LoaderStmt = (StatementBean)CleanupStmtArray.get(i);
                this.mLoader.cmd(LoaderStmt.getCallString());
                continue;
            }
            catch (Exception e) {
                this.addMessage("EXCEPTION!", 'E', "Test no = " + TestCaseNo + "; file = " + this.m_CurrentRef.getFileName() + "; phase = cleanup\n" + "Transmission of Loader statement:\n" + LoaderStmt.getCallString() + "\nfailed with error message:\n" + e.getLocalizedMessage());
            }
        }
        return rc;
    }
}

