/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.jver;

import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDatabaseSap;
import com.sap.sapdb.testframe.driver.TestDriver;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.testcase.TestStatement;
import com.sap.sapdb.testframe.utilities.Execute;
import com.sap.sapdb.testframe.utilities.Zipper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class JverStarter
extends TestCase {
    private String fileSep = System.getProperty("file.separator");
    private File zippedResults = null;

    public static long getTimeout() {
        return 3600000L;
    }

    public static void prepare() throws TestCaseException {
    }

    public void run() {
        try {
            String indepProgPath = ((TestDatabaseSap)JverStarter.getDatabase()).getIndepProgPath();
            String jtestRoot = TestDriver.getJTestRoot();
            File workDir = new File(jtestRoot + this.fileSep + "jver");
            File jdbcInstalled = new File(indepProgPath + this.fileSep + "runtime" + this.fileSep + "sapdbc.jar");
            File jdbcTestframe = new File(jtestRoot + this.fileSep + "frame" + this.fileSep + "sapdbc.jar");
            File jdbcJver = new File(jtestRoot + this.fileSep + "jver" + this.fileSep + "sapdbc.jar");
            String archiveSourceDir = JverStarter.getParameterString((String)"archiveSourceDir", (String)"\\\\production\\swl\\projects\\hm.opensql\\dev\\gen\\dbg\\java\\packaged\\full\\_opensql_testsuite");
            String archiveFilename = JverStarter.getParameterString((String)"archiveSourceFile", (String)"opensql_testsuite.sda");
            File archiveSource = new File(archiveSourceDir + this.fileSep + archiveFilename);
            File archiveTarget = new File(jtestRoot + this.fileSep + "jver" + this.fileSep + archiveFilename);
            String appArchiveFilename = JverStarter.getParameterString((String)"appArchiveFile", (String)"opensql_testsuite_app.app");
            File appArchive = new File(jtestRoot + this.fileSep + "jver" + this.fileSep + "app" + this.fileSep + appArchiveFilename);
            File jverDir = new File(jtestRoot + this.fileSep + "jver");
            if (!jverDir.exists() && !jverDir.mkdir()) {
                throw new TestCaseException("Cannot create directory " + jtestRoot + this.fileSep + "jver");
            }
            boolean skipCopying = JverStarter.getParameterBoolean((String)"skipCopying", (boolean)false);
            if (!skipCopying) {
                if (jdbcInstalled.exists()) {
                    JverStarter.copyFile(jdbcInstalled, jdbcJver);
                } else if (jdbcTestframe.exists()) {
                    JverStarter.copyFile(jdbcTestframe, jdbcJver);
                } else {
                    throw new TestCaseException("sapdbc.jar not found.");
                }
                if (archiveSource.exists()) {
                    JverStarter.copyFile(archiveSource, archiveTarget);
                } else {
                    throw new TestCaseException(archiveFilename + " not found.");
                }
            }
            this.extractFile(jtestRoot + this.fileSep + "jver" + this.fileSep + archiveFilename, jtestRoot + this.fileSep + "jver");
            File tmpDir = new File(jtestRoot + this.fileSep + "jver" + this.fileSep + "app" + this.fileSep + "tmp");
            if (!tmpDir.exists() && !tmpDir.mkdir()) {
                throw new TestCaseException("Cannot create tmp directory for application archive extraction.");
            }
            this.extractFile(jtestRoot + this.fileSep + "jver" + this.fileSep + "app" + this.fileSep + appArchiveFilename, jtestRoot + this.fileSep + "jver" + this.fileSep + "app" + this.fileSep + "tmp");
            if (!jdbcJver.exists()) {
                throw new TestCaseException("Cannot sapdbc.jar to tmp directory.");
            }
            JverStarter.copyFile(jdbcJver, new File(jtestRoot + this.fileSep + "jver" + this.fileSep + "app" + this.fileSep + "tmp" + this.fileSep + "sapdbc.jar"));
            Zipper zipfile = new Zipper(appArchive, tmpDir);
            zipfile.addFiles(tmpDir.listFiles());
            zipfile.setDeleteSourceFiles(true);
            zipfile.zip();
            FileWriter writer = new FileWriter(new File(jtestRoot + this.fileSep + "jver" + this.fileSep + "database.properties"));
            String hostname = ((TestDatabaseSap)JverStarter.getDatabase()).getHostName();
            String dbname = JverStarter.getDatabase().getName();
            String connectOptions = JverStarter.getParameterString((String)"connectOptions", (String)"?spaceoption\\\\=true\\\\&unicode\\\\=yes");
            String jverUser = JverStarter.getParameterString((String)"jverUser", (String)"JVER_RIO");
            String jverPassword = JverStarter.getParameterString((String)"jverPassword", (String)"sap");
            writer.write("# JDBC connection\n");
            writer.write("database.datasource=vendorsql://Driver?ClassName=com.sap.dbtech.jdbc.DriverSapDB&Url=jdbc:sapdb://" + hostname + "/" + dbname + "\\\\" + connectOptions + "&User=" + jverUser + "&Password=" + jverPassword + "&\n\n");
            ArrayList skipTests = JverStarter.getUnnamedParameterList();
            if (skipTests != null && !skipTests.isEmpty()) {
                ListIterator it = skipTests.listIterator();
                writer.write("#skip test with known failures\n");
                while (it.hasNext()) {
                    writer.write(((String)it.next()).trim() + "=true\n");
                }
            }
            writer.close();
            Properties conPropsDba = new Properties();
            conPropsDba.put("user", JverStarter.getDatabase().getUser());
            conPropsDba.put("password", JverStarter.getDatabase().getPassword());
            conPropsDba.put("autocommit", "on");
            Properties conPropsTest = new Properties();
            conPropsTest.put("user", jverUser);
            conPropsTest.put("password", jverPassword);
            conPropsTest.put("autocommit", "on");
            Connection myConnection = JverStarter.getDatabase().connect(conPropsDba);
            TestStatement myStatement = new TestStatement((TestCase)this, myConnection, 1005, 1007);
            try {
                myStatement.executeUpdateIgnoreErrors("DROP USER " + jverUser);
                myStatement.executeUpdate("CREATE USER " + jverUser + " PASSWORD " + jverPassword + " RESOURCE NOT EXCLUSIVE");
            }
            catch (SQLException e) {
                throw new TestCaseException("Cannot create user " + jverUser + ": " + e.getMessage());
            }
            finally {
                myConnection.close();
            }
            myConnection = JverStarter.getDatabase().connect(conPropsTest);
            myStatement = new TestStatement((TestCase)this, myConnection, 1005, 1007);
            String stmt = "";
            try {
                int stmtCounter = 1;
                stmt = JverStarter.getParameterString((String)("stmt" + stmtCounter), (String)"");
                while (!stmt.equals("")) {
                    myStatement.executeUpdate(stmt);
                    stmt = JverStarter.getParameterString((String)("stmt" + ++stmtCounter), (String)"");
                }
            }
            catch (SQLException e) {
                throw new TestCaseException("Cannot create table: " + stmt + "\n" + e.getMessage());
            }
            finally {
                myConnection.close();
            }
            String cmd = JverStarter.getParameterString((String)"command", (String)"perl start.pl");
            StringBuffer sb = new StringBuffer();
            Execute exc = new Execute(cmd, null, sb);
            exc.enableWritingStdout(true);
            exc.setErrPrefix("STDERR ");
            exc.ignoreBufferLimitForStdOut(true);
            exc.setTimeout(JverStarter.getParameterInt((String)"timeout", (int)2700));
            exc.exec(workDir);
            String stdout = sb.length() > 4096 ? sb.substring(sb.length() - 4096) : sb.toString();
            this.addMessage("run()", 'I', "Output of JVer test (last 4K characters):\n\n" + stdout);
            int beginIndex = stdout.indexOf("verifications in");
            int endIndex = stdout.indexOf("warnings.");
            String result = "";
            boolean foundErrCount = false;
            if (beginIndex > -1 && endIndex > -1 && beginIndex < endIndex) {
                result = stdout.substring(beginIndex, endIndex + 8);
                String[] resultParts = result.split("\\s");
                for (int x = 0; x < resultParts.length; ++x) {
                    if (!resultParts[x].equals("failed,") || x <= 0) continue;
                    foundErrCount = true;
                    if (new Integer(resultParts[x - 1]) == 0) {
                        this.addMessage("run()", 'I', "JVer tests successful.");
                        continue;
                    }
                    this.addMessage("run()", 'E', "JVer tests failed.");
                }
                if (!foundErrCount) {
                    this.addMessage("run()", 'W', "Cannot determine result of JVer tests: String 'failed.' not found");
                }
            } else {
                this.addMessage("run()", 'W', "Cannot determine result of JVer tests: String 'verifications in ... warnings.' not found.");
            }
            File resultDir = new File(jtestRoot + this.fileSep + "jver" + this.fileSep + "result");
            this.zippedResults = new File(jtestRoot + this.fileSep + "jver" + this.fileSep + "jver_results.zip");
            zipfile = new Zipper(this.zippedResults, resultDir);
            zipfile.addFiles(resultDir.listFiles());
            zipfile.setDeleteSourceFiles(false);
            zipfile.zip();
        }
        catch (Exception e) {
            this.addMessage("run()", 'E', "Exception: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public String getLogFile() {
        if (this.zippedResults != null) {
            return this.zippedResults.getAbsolutePath();
        }
        return null;
    }

    private static void copyFile(File in, File out) throws Exception {
        FileInputStream fis = new FileInputStream(in);
        FileOutputStream fos = new FileOutputStream(out);
        byte[] buf = new byte[0x100000];
        int i = 0;
        while ((i = fis.read(buf)) != -1) {
            fos.write(buf, 0, i);
        }
        fis.close();
        fos.close();
    }

    private void extractFile(String zipFileName, String targetDir) throws Exception {
        File outFile;
        ZipInputStream zis = new ZipInputStream(new FileInputStream(new File(zipFileName)));
        ZipEntry zipEntry = zis.getNextEntry();
        while (zipEntry != null) {
            outFile = new File(targetDir + this.fileSep + zipEntry.getName());
            if (zipEntry.isDirectory()) {
                if (outFile.exists()) {
                    if (!outFile.isDirectory()) {
                        throw new TestCaseException(targetDir + this.fileSep + zipEntry.getName() + " exists but is not a directory - cannot continue extraction.");
                    }
                } else if (!outFile.mkdir()) {
                    throw new TestCaseException("Cannot create directory " + targetDir + this.fileSep + zipEntry.getName());
                }
            }
            zipEntry = zis.getNextEntry();
        }
        zis.close();
        zis = new ZipInputStream(new FileInputStream(new File(zipFileName)));
        zipEntry = zis.getNextEntry();
        while (zipEntry != null) {
            outFile = new File(targetDir + this.fileSep + zipEntry.getName());
            if (!zipEntry.isDirectory()) {
                if (outFile.exists() && outFile.isFile() && !outFile.delete()) {
                    throw new TestCaseException("Cannot delete file " + targetDir + this.fileSep + zipEntry.getName());
                }
                if (outFile.isFile() && !outFile.createNewFile()) {
                    throw new TestCaseException("Cannot create file " + targetDir + this.fileSep + zipEntry.getName());
                }
                FileOutputStream fos = new FileOutputStream(outFile);
                byte[] buf = new byte[1024];
                int i = 0;
                while ((i = zis.read(buf, 0, 1024)) != -1) {
                    fos.write(buf, 0, i);
                }
                fos.close();
            }
            zipEntry = zis.getNextEntry();
        }
        zis.close();
    }
}

