/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.join.simulation.unittests;

import com.sap.sapdb.oltptest.join.simulation.DatabaseTable;
import com.sap.sapdb.oltptest.join.simulation.IntegerCell;
import com.sap.sapdb.oltptest.join.simulation.IntegerColumn;
import com.sap.sapdb.oltptest.join.simulation.ResultTable;
import com.sap.sapdb.oltptest.join.simulation.Table;
import com.sap.sapdb.oltptest.join.simulation.TableRow;
import java.util.Iterator;
import java.util.List;
import junit.framework.Assert;

public class TestHelpers {
    public static DatabaseTable createTable(int columnCount, int rowCount) {
        int i;
        DatabaseTable table = new DatabaseTable();
        for (i = 1; i <= columnCount; ++i) {
            IntegerColumn c = new IntegerColumn();
            table.addColumn(c);
        }
        for (i = 1; i <= rowCount; ++i) {
            TableRow row = new TableRow(table);
            for (int j = 1; j <= columnCount; ++j) {
                row.setValue(j, new IntegerCell(i + j));
            }
            table.insert(row);
        }
        return table;
    }

    public static void verifyTableDefinition(ResultTable op, List containedTablesList) {
        Iterator tabIt = op.containedTablesIterator();
        while (tabIt.hasNext()) {
            Table tab = (Table)tabIt.next();
            boolean found = false;
            Iterator verIt = containedTablesList.iterator();
            while (verIt.hasNext()) {
                Table ver = (Table)verIt.next();
                if (!tab.getTableName().equals(ver.getTableName())) continue;
                verIt.remove();
                found = true;
                break;
            }
            if (!found) {
                System.err.println("Table too many: " + tab.getTableName());
            }
            Assert.assertTrue((boolean)found);
        }
        if (containedTablesList.size() > 0) {
            System.err.println("Table(s) missing:");
            Iterator verIt = containedTablesList.iterator();
            while (verIt.hasNext()) {
                Table ver = (Table)verIt.next();
                System.err.println("  " + ver.getTableName());
            }
        }
        Assert.assertEquals((int)0, (int)containedTablesList.size());
    }
}

