/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.join.simulation.unittests;

import com.sap.sapdb.oltptest.join.simulation.DatabaseTable;
import com.sap.sapdb.oltptest.join.simulation.DbResultTable;
import com.sap.sapdb.oltptest.join.simulation.IntegerCell;
import com.sap.sapdb.oltptest.join.simulation.SortInfo;
import com.sap.sapdb.oltptest.join.simulation.SortOperator;
import com.sap.sapdb.oltptest.join.simulation.TableRow;
import com.sap.sapdb.oltptest.join.simulation.unittests.TestHelpers;
import junit.framework.Assert;
import junit.framework.TestCase;

public class SortOperatorTest
extends TestCase {
    private DatabaseTable table;

    protected void setUp() throws Exception {
        super.setUp();
        this.table = TestHelpers.createTable(2, 7);
    }

    public void testSimpleSort() {
        System.out.println("SortOperatorTest: simple sort.");
        SortOperator s = new SortOperator(new DbResultTable(this.table));
        TableRow lastRow = new TableRow(s);
        lastRow = s.next();
        while (s.hasNext()) {
            TableRow currentRow = s.next();
            for (int i = 1; i <= s.getColumnCount() && !lastRow.getValue(i).isLess(currentRow.getValue(i)); ++i) {
                if (!lastRow.getValue(i).isGreater(currentRow.getValue(i))) continue;
                System.out.println(currentRow + ",\t" + lastRow);
                Assert.assertTrue((boolean)false);
            }
            lastRow = (TableRow)currentRow.clone();
        }
    }

    public void testNotSoSimpleSort() {
        System.out.println("SortOperatorTest: not so simple sort.");
        DatabaseTable t = TestHelpers.createTable(2, 5);
        TableRow r = new TableRow(t);
        r.setValue(1, new IntegerCell(5));
        r.setValue(2, new IntegerCell(3));
        t.insert(r);
        r.setValue(1, new IntegerCell(5));
        r.setValue(2, new IntegerCell(2));
        t.insert(r);
        r.setValue(1, new IntegerCell(5));
        r.setValue(2, new IntegerCell(6));
        t.insert(r);
        r.setValue(1, new IntegerCell(5));
        r.setValue(2, new IntegerCell(2));
        t.insert(r);
        r.setValue(1, new IntegerCell(1));
        r.setValue(2, new IntegerCell(3));
        t.insert(r);
        SortInfo si = new SortInfo();
        si.addColumn(2, 2);
        si.addColumn(1, 1);
        SortOperator s = new SortOperator(new DbResultTable(t), si);
        TableRow[] verify = new TableRow[11];
        verify[0] = new TableRow(t);
        verify[0].setValue(1, new IntegerCell(6));
        verify[0].setValue(2, new IntegerCell(7));
        verify[1] = new TableRow(t);
        verify[1].setValue(1, new IntegerCell(5));
        verify[1].setValue(2, new IntegerCell(6));
        verify[2] = new TableRow(t);
        verify[2].setValue(1, new IntegerCell(5));
        verify[2].setValue(2, new IntegerCell(6));
        verify[3] = new TableRow(t);
        verify[3].setValue(1, new IntegerCell(4));
        verify[3].setValue(2, new IntegerCell(5));
        verify[4] = new TableRow(t);
        verify[4].setValue(1, new IntegerCell(3));
        verify[4].setValue(2, new IntegerCell(4));
        verify[5] = new TableRow(t);
        verify[5].setValue(1, new IntegerCell(1));
        verify[5].setValue(2, new IntegerCell(3));
        verify[6] = new TableRow(t);
        verify[6].setValue(1, new IntegerCell(2));
        verify[6].setValue(2, new IntegerCell(3));
        verify[7] = new TableRow(t);
        verify[7].setValue(1, new IntegerCell(5));
        verify[7].setValue(2, new IntegerCell(3));
        verify[8] = new TableRow(t);
        verify[8].setValue(1, new IntegerCell(5));
        verify[8].setValue(2, new IntegerCell(2));
        verify[9] = new TableRow(t);
        verify[9].setValue(1, new IntegerCell(5));
        verify[9].setValue(2, new IntegerCell(2));
        int i = 0;
        while (s.hasNext()) {
            TableRow cr = s.next();
            Assert.assertTrue((boolean)cr.getValue(1).isEqual(verify[i].getValue(1)));
            Assert.assertTrue((boolean)cr.getValue(2).isEqual(verify[i].getValue(2)));
            ++i;
        }
    }
}

