/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.join.simulation.unittests;

import com.sap.sapdb.oltptest.join.simulation.Column;
import com.sap.sapdb.oltptest.join.simulation.DatabaseTable;
import com.sap.sapdb.oltptest.join.simulation.DbResultTable;
import com.sap.sapdb.oltptest.join.simulation.IntegerCell;
import com.sap.sapdb.oltptest.join.simulation.IntegerColumn;
import com.sap.sapdb.oltptest.join.simulation.ProjectionOperator;
import com.sap.sapdb.oltptest.join.simulation.TableRow;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import junit.framework.Assert;
import junit.framework.TestCase;

public class ProjectionOperatorTest
extends TestCase {
    final int c_maxColumns = 1;
    final int c_rowCount = 3;
    private AbstractList tableList;
    private DatabaseTable table2;

    protected void setUp() throws Exception {
        super.setUp();
        this.tableList = new ArrayList(3);
        this.tableList.add(this.createTable(2, 7));
        this.tableList.add(this.createTable(3, 5));
        this.tableList.add(this.createTable(1, 10));
        Iterator it = this.tableList.iterator();
        while (it.hasNext()) {
            DatabaseTable databaseTable = (DatabaseTable)it.next();
        }
    }

    protected DatabaseTable createTable(int columnCount, int rowCount) {
        int i;
        DatabaseTable table = new DatabaseTable();
        for (i = 1; i <= columnCount; ++i) {
            IntegerColumn c = new IntegerColumn();
            table.addColumn(c);
        }
        for (i = 1; i <= rowCount; ++i) {
            TableRow row = new TableRow(table);
            for (int j = 1; j <= columnCount; ++j) {
                row.setValue(j, new IntegerCell(i + j));
            }
            table.insert(row);
        }
        return table;
    }

    private DatabaseTable getTable(int index) {
        return (DatabaseTable)this.tableList.get(index);
    }

    public void testProjectionOperatorSingle() {
        System.out.println("Projection operator: single");
        DbResultTable input = new DbResultTable(this.getTable(1));
        ArrayList<Column> colList = new ArrayList<Column>(3);
        ((AbstractList)colList).add(this.getTable(1).getColumnInfo(2));
        ProjectionOperator p = new ProjectionOperator(input, colList);
        DatabaseTable resultTable = new DatabaseTable(p.getResultTableDefinition());
        while (p.hasNext()) {
            TableRow row = p.next();
            resultTable.insert(row);
        }
        Assert.assertEquals((String)"COL2", (String)resultTable.getColumnInfo(1).getColumnName());
        Assert.assertEquals((int)5, (int)resultTable.getRowCount());
    }

    public void testProjectionOperatorMulti() {
        System.out.println("Projection operator: multi");
        DbResultTable input = new DbResultTable(this.getTable(1));
        ArrayList<Column> colList = new ArrayList<Column>(3);
        ((AbstractList)colList).add(this.getTable(1).getColumnInfo(3));
        ((AbstractList)colList).add(this.getTable(1).getColumnInfo(1));
        ProjectionOperator p = new ProjectionOperator(input, colList);
        DatabaseTable resultTable = new DatabaseTable(p.getResultTableDefinition());
        while (p.hasNext()) {
            TableRow row = p.next();
            resultTable.insert(row);
        }
        Assert.assertEquals((String)"COL3", (String)resultTable.getColumnInfo(1).getColumnName());
        Assert.assertEquals((String)"COL1", (String)resultTable.getColumnInfo(2).getColumnName());
        Assert.assertEquals((int)5, (int)resultTable.getRowCount());
    }

    public void testProjectionOperatorSingleRename() {
        System.out.println("Projection operator: rename single");
        DbResultTable input = new DbResultTable(this.getTable(1));
        ProjectionOperator p = new ProjectionOperator(input);
        p.addColumn(this.getTable(1), 2, "new column");
        DatabaseTable resultTable = new DatabaseTable(p.getResultTableDefinition());
        while (p.hasNext()) {
            TableRow row = p.next();
            resultTable.insert(row);
        }
        Assert.assertEquals((String)"new column", (String)resultTable.getColumnInfo(1).getColumnName());
        Assert.assertEquals((int)5, (int)resultTable.getRowCount());
    }

    public void testProjectionOperatorMultiRename() {
        System.out.println("Projection operator: rename multi");
        DbResultTable input = new DbResultTable(this.getTable(1));
        ProjectionOperator p = new ProjectionOperator(input);
        p.addColumn(this.getTable(1), 2, "new column");
        p.addColumn(this.getTable(1), 1, "second column");
        DatabaseTable resultTable = new DatabaseTable(p.getResultTableDefinition());
        while (p.hasNext()) {
            TableRow row = p.next();
            resultTable.insert(row);
        }
        Assert.assertEquals((String)"new column", (String)resultTable.getColumnInfo(1).getColumnName());
        Assert.assertEquals((String)"second column", (String)resultTable.getColumnInfo(2).getColumnName());
        Assert.assertEquals((int)5, (int)resultTable.getRowCount());
    }
}

