/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.join.simulation.unittests;

import com.sap.sapdb.oltptest.join.simulation.DatabaseTable;
import com.sap.sapdb.oltptest.join.simulation.DbResultTable;
import com.sap.sapdb.oltptest.join.simulation.EqualCondition;
import com.sap.sapdb.oltptest.join.simulation.IntegerCell;
import com.sap.sapdb.oltptest.join.simulation.IntegerColumn;
import com.sap.sapdb.oltptest.join.simulation.LeftOuterJoin;
import com.sap.sapdb.oltptest.join.simulation.MaterializeResultOperator;
import com.sap.sapdb.oltptest.join.simulation.TableRow;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import junit.framework.TestCase;

public class MaterializeResultOperatorTest
extends TestCase {
    final int c_maxColumns = 1;
    final int c_rowCount = 3;
    private AbstractList tableList;
    private DatabaseTable table2;

    protected void setUp() throws Exception {
        super.setUp();
        this.tableList = new ArrayList(3);
        this.tableList.add(this.createTable(2, 7));
        this.tableList.add(this.createTable(3, 5));
        this.tableList.add(this.createTable(1, 10));
        Iterator it = this.tableList.iterator();
        while (it.hasNext()) {
            DatabaseTable databaseTable = (DatabaseTable)it.next();
        }
    }

    protected DatabaseTable createTable(int columnCount, int rowCount) {
        int i;
        DatabaseTable table = new DatabaseTable();
        for (i = 1; i <= columnCount; ++i) {
            IntegerColumn c = new IntegerColumn();
            table.addColumn(c);
        }
        for (i = 1; i <= rowCount; ++i) {
            TableRow row = new TableRow(table);
            for (int j = 1; j <= columnCount; ++j) {
                row.setValue(j, new IntegerCell(i + j));
            }
            table.insert(row);
        }
        return table;
    }

    private DatabaseTable getTable(int index) {
        return (DatabaseTable)this.tableList.get(index);
    }

    public void testTwoLevelJoin() {
        System.out.println("MaterializeResultOperator: two level join");
        EqualCondition eq = new EqualCondition(new DbResultTable(this.getTable(0)), 1, new DbResultTable(this.getTable(1)), 2);
        LeftOuterJoin lo1 = new LeftOuterJoin(new DbResultTable(this.getTable(0)), new DbResultTable(this.getTable(1)), eq);
        MaterializeResultOperator r = new MaterializeResultOperator(lo1);
        eq = new EqualCondition(new DbResultTable(this.getTable(0)), 2, new DbResultTable(this.getTable(2)), 1);
        LeftOuterJoin lo2 = new LeftOuterJoin(r, new DbResultTable(this.getTable(2)), eq);
        DatabaseTable r1 = new MaterializeResultOperator(lo2).getResultTable();
        r1.dump();
    }
}

